/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.spi.tomcat;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.glassfish.exousia.AuthorizationService;
import org.glassfish.exousia.constraints.SecurityConstraint;
import org.glassfish.exousia.constraints.WebResourceCollection;

public class TomcatAuthorizationFilter
extends HttpFilter
implements ServletRequestListener {
    private static final long serialVersionUID = 1L;
    public static ThreadLocal<HttpServletRequest> localServletRequest = new ThreadLocal();

    public void init() throws ServletException {
        ServletContext servletContext = this.getFilterConfig().getServletContext();
        StandardRoot root = (StandardRoot)servletContext.getAttribute("org.apache.catalina.resources");
        Context context = root.getContext();
        org.apache.tomcat.util.descriptor.web.SecurityConstraint[] constraints = context.findConstraints();
        List<String> declaredRoles = Arrays.asList(context.findSecurityRoles());
        boolean isDenyUncoveredHttpMethods = root.getContext().getDenyUncoveredHttpMethods();
        AuthorizationService.setThreadContextId((ServletContext)servletContext);
        AuthorizationService authorizationService = new AuthorizationService(servletContext, () -> TomcatAuthorizationFilter.getSubject(localServletRequest.get()));
        authorizationService.setRequestSupplier(() -> localServletRequest.get());
        authorizationService.addConstraintsToPolicy(this.convertTomcatConstraintsToExousia(constraints), new HashSet<String>(declaredRoles), isDenyUncoveredHttpMethods, Collections.emptyMap());
    }

    public void requestInitialized(ServletRequestEvent sre) {
        localServletRequest.set((HttpServletRequest)sre.getServletRequest());
        AuthorizationService.setThreadContextId((ServletContext)sre.getServletContext());
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        localServletRequest.remove();
    }

    private List<SecurityConstraint> convertTomcatConstraintsToExousia(org.apache.tomcat.util.descriptor.web.SecurityConstraint[] tomcatConstraints) {
        if (tomcatConstraints == null || tomcatConstraints.length == 0) {
            return null;
        }
        ArrayList<SecurityConstraint> exousiaConstraints = new ArrayList<SecurityConstraint>();
        for (org.apache.tomcat.util.descriptor.web.SecurityConstraint tomcatConstraint : tomcatConstraints) {
            ArrayList<WebResourceCollection> exousiaWebResourceCollections = new ArrayList<WebResourceCollection>();
            for (SecurityCollection tomcatSecurityCollection : tomcatConstraint.findCollections()) {
                exousiaWebResourceCollections.add(new WebResourceCollection(tomcatSecurityCollection.findPatterns(), tomcatSecurityCollection.findMethods(), tomcatSecurityCollection.findOmittedMethods()));
            }
            exousiaConstraints.add(new SecurityConstraint(exousiaWebResourceCollections, new HashSet<String>(Arrays.asList(tomcatConstraint.findAuthRoles())), "confidential".equalsIgnoreCase(tomcatConstraint.getUserConstraint()) ? ServletSecurity.TransportGuarantee.CONFIDENTIAL : ServletSecurity.TransportGuarantee.NONE));
        }
        return exousiaConstraints;
    }

    private static Subject getSubject(HttpServletRequest httpServletRequest) {
        return (Subject)TomcatAuthorizationFilter.getRequest((RequestFacade)TomcatAuthorizationFilter.unwrapFully((ServletRequest)httpServletRequest)).getNote("org.apache.catalina.authenticator.jaspic.SUBJECT");
    }

    private static <T extends ServletRequest> T unwrapFully(ServletRequest request) {
        ServletRequest currentRequest = request;
        while (currentRequest instanceof ServletRequestWrapper) {
            ServletRequestWrapper wrapper = (ServletRequestWrapper)currentRequest;
            currentRequest = wrapper.getRequest();
        }
        return (T)currentRequest;
    }

    private static Request getRequest(RequestFacade facade) {
        try {
            Field requestField = RequestFacade.class.getDeclaredField("request");
            requestField.setAccessible(true);
            return (Request)requestField.get(facade);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

