/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.IsoLevel;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CacheSessionDataTest
extends BaseJDBCTestCase {
    private static IsoLevel[] isoLevels;
    private static int isolationIndex;

    public CacheSessionDataTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("CacheSessionDataTest");
        if (JDBC.vmSupportsJDBC3()) {
            suite.addTest(CacheSessionDataTest.baseSuite("CacheSessionDataTest:embedded"));
            suite.addTest(TestConfiguration.clientServerDecorator(CacheSessionDataTest.baseSuite("CacheSessionDataTest:client")));
        }
        return suite;
    }

    private static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(CacheSessionDataTest.class);
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("CREATE TABLE ISOLATION_NAMES(ISOLEVEL INT, JDBCNAME VARCHAR(30), SQLNAME VARCHAR(2))");
                PreparedStatement insert = s.getConnection().prepareStatement("INSERT INTO ISOLATION_NAMES VALUES (?, ?, ?)");
                insert.setInt(1, 0);
                insert.setString(2, "TRANSACTION_NONE");
                insert.setNull(3, 12);
                insert.execute();
                insert.setInt(1, 1);
                insert.setString(2, "TRANSACTION_READ_UNCOMMITTED");
                insert.setString(3, "UR");
                insert.execute();
                insert.setInt(1, 2);
                insert.setString(2, "TRANSACTION_READ_COMMITTED");
                insert.setString(3, "CS");
                insert.execute();
                insert.setInt(1, 4);
                insert.setString(2, "TRANSACTION_REPEATABLE_READ");
                insert.setString(3, "RS");
                insert.execute();
                insert.setInt(1, 8);
                insert.setString(2, "TRANSACTION_SERIALIZABLE");
                insert.setString(3, "RR");
                insert.execute();
                insert.close();
                s.execute("CREATE TABLE BIG(C1 VARCHAR(32672), C2 VARCHAR(32672), C3 VARCHAR(32672), C4 VARCHAR(32672))");
                s.execute("CREATE PROCEDURE INSERTDATA1(IN A INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.ProcedureTest.bigTestData'");
                CallableStatement cs = s.getConnection().prepareCall("CALL INSERTDATA1(?)");
                cs.setInt(1, 9);
                for (int i = 0; i < 10; ++i) {
                    cs.execute();
                }
                ResultSet x = s.executeQuery("SELECT COUNT(*) FROM BIG");
                x.next();
                this.println("BIG has " + x.getInt(1) + " rows");
                s.execute("CREATE PROCEDURE SET_ISOLATION_JDBC (ISO INT) NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".setIsolationJDBC'");
                s.execute("CREATE PROCEDURE SET_ISOLATION_SQL (SQLNAME VARCHAR(2)) MODIFIES SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".setIsolationSQL'");
                s.execute("CREATE FUNCTION GET_TRANSACTION_ISOLATION_JDBC () RETURNS INT NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".getTransactionIsolationJDBC'");
                s.execute("CREATE FUNCTION GET_CYCLE_ISOLATION_JDBC () RETURNS INT NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".getCycleIsolationJDBC'");
                s.execute("CREATE FUNCTION GET_CYCLE_ISOLATION_SQL () RETURNS VARCHAR(2) READS SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".getCycleIsolationSQL'");
                s.execute("CREATE SCHEMA FOO");
                String unicodeschema = "\u00bbMY\u20ac\u00ab";
                s.execute("CREATE SCHEMA \"" + unicodeschema + "\"");
                s.execute("CREATE PROCEDURE APP.SET_SCHEMA (SCHEMANAME VARCHAR(128)) MODIFIES SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".setSchema'");
                s.execute("CREATE FUNCTION APP.GET_SCHEMA_TRANSITION (SCHEMANAME VARCHAR(128)) RETURNS VARCHAR(128) READS SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".getSchemaTransition'");
                s.execute("CREATE TABLE APP.LARGE(X VARCHAR(32000), SCHEMANAME VARCHAR(128), Y VARCHAR(32000))");
                char[] carray = new char[32000];
                Arrays.fill(carray, 'x');
                String xs = new String(carray);
                Arrays.fill(carray, 'y');
                String ys = new String(carray);
                s.execute("INSERT INTO APP.LARGE (SELECT '" + xs + "', " + "SCHEMANAME, " + " '" + ys + "' FROM SYS.SYSSCHEMAS)");
            }
        };
    }

    public void setUp() throws SQLException {
        Connection c = this.getConnection();
        c.setAutoCommit(false);
        CacheSessionDataTest.assertEquals((int)2, (int)c.getTransactionIsolation());
        if (isoLevels == null) {
            Statement s = this.createStatement();
            ResultSet rs = s.executeQuery("SELECT * FROM ISOLATION_NAMES WHERE ISOLEVEL > 0 ORDER BY ISOLEVEL");
            isoLevels = new IsoLevel[4];
            for (int i = 0; i < 4; ++i) {
                CacheSessionDataTest.isoLevels[i] = new IsoLevel(rs);
                CacheSessionDataTest.println(isoLevels[i].toString());
            }
            CacheSessionDataTest.assertFalse((boolean)rs.next());
            rs.close();
            s.close();
        }
        CacheSessionDataTest.assertNotNull((Object)isoLevels[0]);
        CacheSessionDataTest.assertNotNull((Object)isoLevels[1]);
        CacheSessionDataTest.assertNotNull((Object)isoLevels[2]);
        CacheSessionDataTest.assertNotNull((Object)isoLevels[3]);
    }

    @Override
    public void tearDown() throws Exception {
        DatabaseMetaData meta = this.getConnection().getMetaData();
        ResultSet tables = meta.getTables(null, "APP", "T%", null);
        Statement s = this.createStatement();
        while (tables.next()) {
            s.execute("DROP TABLE " + tables.getString("TABLE_NAME"));
        }
        tables.close();
        s.close();
        this.commit();
        super.tearDown();
    }

    public static void setIsolationJDBC(int isolation) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        c.setTransactionIsolation(isolation);
    }

    public static void setIsolationSQL(String sqlName) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement s = c.createStatement();
        s.execute("SET ISOLATION " + sqlName);
        s.close();
    }

    public static int getTransactionIsolationJDBC() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection").getTransactionIsolation();
    }

    public static int getCycleIsolationJDBC() throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        c.setTransactionIsolation(CacheSessionDataTest.cycleIsolation().getIsoLevel());
        CacheSessionDataTest.println("getCycleIsolationJDBC() -> " + c.getTransactionIsolation());
        return c.getTransactionIsolation();
    }

    public static String getCycleIsolationSQL() throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement s = c.createStatement();
        s.execute("SET ISOLATION " + CacheSessionDataTest.cycleIsolation().getSqlName());
        ResultSet rs = s.executeQuery("VALUES CURRENT ISOLATION");
        rs.next();
        String sqlName = rs.getString(1);
        rs.close();
        s.close();
        CacheSessionDataTest.println("getCycleIsolationSQL() -> " + sqlName);
        return sqlName;
    }

    public static void setSchema(String schemaName) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement s = c.createStatement();
        s.execute("SET SCHEMA " + schemaName);
        s.close();
    }

    public static String getSchemaTransition(String nextSchema) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("VALUES CURRENT SCHEMA");
        rs.next();
        String prevSchema = rs.getString(1);
        rs.close();
        s.execute("SET SCHEMA \"" + nextSchema + "\"");
        s.close();
        return prevSchema + "->" + nextSchema;
    }

    private static IsoLevel cycleIsolation() {
        ++isolationIndex;
        return isoLevels[isolationIndex %= 4];
    }

    private void verifyCachedIsolation(Connection c) throws SQLException {
        int clientInt = c.getTransactionIsolation();
        Statement s = this.createStatement();
        IsoLevel serverSql = new IsoLevel(s.executeQuery("SELECT * FROM ISOLATION_NAMES WHERE SQLNAME = (VALUES CURRENT ISOLATION)"));
        IsoLevel serverJdbc = new IsoLevel(s.executeQuery("SELECT * FROM ISOLATION_NAMES WHERE ISOLEVEL = GET_TRANSACTION_ISOLATION_JDBC()"));
        IsoLevel client = new IsoLevel(s.executeQuery("SELECT * FROM ISOLATION_NAMES WHERE ISOLEVEL = " + clientInt));
        s.getResultSet().close();
        s.close();
        CacheSessionDataTest.assertEquals((Object)serverSql, (Object)client);
        CacheSessionDataTest.assertEquals((Object)serverJdbc, (Object)client);
    }

    private void verifyCachedSchema(Connection c) throws SQLException {
        if (CacheSessionDataTest.usingDerbyNetClient()) {
            String cached = ((ClientConnection)c).getCurrentSchemaName();
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery("VALUES CURRENT SCHEMA");
            rs.next();
            String reported = rs.getString(1);
            CacheSessionDataTest.assertEquals((String)reported, (String)cached);
        } else {
            CacheSessionDataTest.println("Cannot verify cached schema for " + c.getClass());
        }
    }

    public void testChangeIsoLevelStatementSQL() throws SQLException {
        Connection c = this.getConnection();
        Statement s = this.createStatement();
        for (int i = 0; i < 4; ++i) {
            s.execute("SET ISOLATION " + isoLevels[i].getSqlName());
            this.verifyCachedIsolation(c);
        }
        s.close();
    }

    public void testChangeIsoLevelPreparedStatementSQL() throws SQLException {
        Connection c = this.getConnection();
        for (int i = 0; i < 4; ++i) {
            PreparedStatement ps = this.prepareStatement("SET ISOLATION " + isoLevels[i].getSqlName());
            ps.execute();
            this.verifyCachedIsolation(c);
            ps.close();
        }
    }

    public void testChangeIsoLevelFunctionJDBC() throws SQLException {
        Connection c = this.getConnection();
        c.setAutoCommit(true);
        Statement s = this.createStatement();
        s.execute("CREATE TABLE T1(ISOLEVEL INT)");
        for (int i = 0; i < 4; ++i) {
            s.execute("INSERT INTO T1 VALUES GET_CYCLE_ISOLATION_JDBC()");
            this.verifyCachedIsolation(c);
        }
        s.close();
    }

    public void testChangeIsoLevelFunctionSQL() throws SQLException {
        Connection c = this.getConnection();
        c.setAutoCommit(true);
        Statement s = this.createStatement();
        s.execute("CREATE TABLE T1(SQLNAME VARCHAR(2))");
        for (int i = 0; i < 4; ++i) {
            s.executeUpdate("INSERT INTO T1 VALUES GET_CYCLE_ISOLATION_SQL()");
            this.verifyCachedIsolation(c);
        }
        s.close();
    }

    public void testChangeIsoLevelPreparedFunctionJDBC() throws SQLException {
        Connection c = this.getConnection();
        c.setAutoCommit(true);
        Statement s = this.createStatement();
        s.execute("CREATE TABLE T1(ISOLEVEL INT)");
        PreparedStatement ps = this.prepareStatement("INSERT INTO T1 VALUES GET_CYCLE_ISOLATION_JDBC()");
        for (int i = 0; i < 4; ++i) {
            ps.executeUpdate();
            this.verifyCachedIsolation(c);
        }
        ps.close();
    }

    public void testChangeIsoLevelPreparedFunctionSQL() throws SQLException {
        Connection c = this.getConnection();
        c.setAutoCommit(true);
        Statement s = this.createStatement();
        s.execute("CREATE TABLE T1(SQLNAME VARCHAR(2))");
        PreparedStatement ps = this.prepareStatement("INSERT INTO T1 VALUES GET_CYCLE_ISOLATION_SQL()");
        for (int i = 0; i < 4; ++i) {
            ps.executeUpdate();
            this.verifyCachedIsolation(c);
        }
        ps.close();
    }

    public void testChangeIsoLevelProcedureJDBC() throws SQLException {
        Connection c = this.getConnection();
        Statement s = this.createStatement();
        for (int i = 0; i < 4; ++i) {
            s.execute("CALL SET_ISOLATION_JDBC(" + isoLevels[i].getIsoLevel() + ")");
            this.verifyCachedIsolation(c);
        }
        s.close();
    }

    public void testChangeIsoLevelProcedureSQL() throws SQLException {
        Connection c = this.getConnection();
        Statement s = this.createStatement();
        for (int i = 0; i < 4; ++i) {
            s.execute("CALL SET_ISOLATION_SQL('" + isoLevels[i].getSqlName() + "')");
            this.verifyCachedIsolation(c);
        }
        s.close();
    }

    public void testChangeIsoLevelCallableStatementJDBC() throws SQLException {
        Connection c = this.getConnection();
        CallableStatement cs = this.prepareCall("CALL SET_ISOLATION_JDBC(?)");
        for (int i = 0; i < 4; ++i) {
            cs.setInt(1, isoLevels[i].getIsoLevel());
            cs.execute();
            this.verifyCachedIsolation(c);
        }
        cs.close();
    }

    public void testChangeIsoLevelCallableStatementSQL() throws SQLException {
        Connection c = this.getConnection();
        CallableStatement cs = this.prepareCall("CALL SET_ISOLATION_SQL(?)");
        for (int i = 0; i < 4; ++i) {
            cs.setString(1, isoLevels[i].getSqlName());
            cs.execute();
            this.verifyCachedIsolation(c);
        }
        cs.close();
    }

    public void testChangeIsoLevelSQLInBatch() throws SQLException {
        Statement s = this.createStatement();
        for (int i = 0; i < isoLevels.length; ++i) {
            s.addBatch("SET ISOLATION " + isoLevels[i].getSqlName());
        }
        try {
            s.executeBatch();
        }
        catch (SQLException e) {
            SQLException prev = e;
            while (e != null) {
                prev = e;
                e = e.getNextException();
            }
            throw prev;
        }
        this.verifyCachedIsolation(s.getConnection());
        s.close();
    }

    public void testChangeIsoLevelProcedureJdbcBatch() throws SQLException {
        Statement s = this.createStatement();
        for (int i = 0; i < isoLevels.length; ++i) {
            s.addBatch("CALL SET_ISOLATION_JDBC(" + isoLevels[i].getIsoLevel() + ")");
        }
        try {
            s.executeBatch();
        }
        catch (SQLException e) {
            SQLException prev = e;
            while (e != null) {
                prev = e;
                e = e.getNextException();
            }
            throw prev;
        }
        this.verifyCachedIsolation(s.getConnection());
        s.close();
    }

    public void testChangeIsoLevelProcedureSqlBatch() throws SQLException {
        Statement s = this.createStatement();
        for (int i = 0; i < isoLevels.length; ++i) {
            s.addBatch("CALL SET_ISOLATION_SQL('" + isoLevels[i].getSqlName() + "')");
        }
        try {
            s.executeBatch();
        }
        catch (SQLException e) {
            SQLException prev = e;
            while (e != null) {
                prev = e;
                e = e.getNextException();
            }
            throw prev;
        }
        this.verifyCachedIsolation(s.getConnection());
        s.close();
    }

    public void testChangeIsoLevelProcedureJdbcCallableBatch() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SET_ISOLATION_JDBC(?)");
        for (int i = 0; i < isoLevels.length; ++i) {
            cs.setInt(1, isoLevels[i].getIsoLevel());
            cs.addBatch();
        }
        try {
            cs.executeBatch();
        }
        catch (SQLException e) {
            SQLException prev = e;
            while (e != null) {
                prev = e;
                e = e.getNextException();
            }
            throw prev;
        }
        this.verifyCachedIsolation(cs.getConnection());
        cs.close();
    }

    public void testChangeIsoLevelProcedureSqlCallableBatch() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SET_ISOLATION_SQL(?)");
        for (int i = 0; i < isoLevels.length; ++i) {
            cs.setString(1, isoLevels[i].getSqlName());
            cs.addBatch();
        }
        try {
            cs.executeBatch();
        }
        catch (SQLException e) {
            SQLException prev = e;
            while (e != null) {
                prev = e;
                e = e.getNextException();
            }
            throw prev;
        }
        this.verifyCachedIsolation(cs.getConnection());
        cs.close();
    }

    private void cursorTest(String table, int type, int concur) throws SQLException {
        Connection c = this.getConnection();
        Statement s = this.createStatement(type, concur);
        ResultSet rs = s.executeQuery("SELECT * FROM " + table);
        this.verifyCachedIsolation(c);
        while (rs.next()) {
            this.verifyCachedIsolation(c);
        }
        rs.close();
        s.close();
    }

    private void preparedCursorTest(String table, int type, int concur) throws SQLException {
        Connection c = this.getConnection();
        PreparedStatement ps = c.prepareStatement("SELECT * FROM " + table, type, concur);
        ResultSet rs = ps.executeQuery();
        this.verifyCachedIsolation(c);
        while (rs.next()) {
            this.verifyCachedIsolation(c);
        }
        rs.close();
        ps.close();
    }

    public void testSmallForwardOnlyReadOnly() throws SQLException {
        this.cursorTest("ISOLATION_NAMES", 1003, 1007);
    }

    public void testSmallScrollInsensitiveReadOnly() throws SQLException {
        this.cursorTest("ISOLATION_NAMES", 1004, 1007);
    }

    public void testSmallScrollSensitiveReadOnly() throws SQLException {
        this.cursorTest("ISOLATION_NAMES", 1005, 1007);
    }

    public void testSmallForwardOnlyUpdatable() throws SQLException {
        this.cursorTest("ISOLATION_NAMES", 1003, 1008);
    }

    public void testSmallScrollInsensitiveUpdatable() throws SQLException {
        this.cursorTest("ISOLATION_NAMES", 1004, 1008);
    }

    public void testSmallScrollSensitiveUpdatable() throws SQLException {
        this.cursorTest("ISOLATION_NAMES", 1005, 1008);
    }

    public void testSmallPreparedForwardOnlyReadOnly() throws SQLException {
        this.preparedCursorTest("ISOLATION_NAMES", 1003, 1007);
    }

    public void testSmallPreparedScrollSensitiveReadOnly() throws SQLException {
        this.preparedCursorTest("ISOLATION_NAMES", 1005, 1007);
    }

    public void testSmallPreparedScrollInsensitiveReadOnly() throws SQLException {
        this.preparedCursorTest("ISOLATION_NAMES", 1004, 1007);
    }

    public void testSmallPreparedForwardOnlyUpdatable() throws SQLException {
        this.preparedCursorTest("ISOLATION_NAMES", 1003, 1008);
    }

    public void testSmallPreparedScrollSensitiveUpdatable() throws SQLException {
        this.preparedCursorTest("ISOLATION_NAMES", 1005, 1008);
    }

    public void testSmallPreparedScrollInsensitiveUpdatable() throws SQLException {
        this.preparedCursorTest("ISOLATION_NAMES", 1004, 1008);
    }

    public void testLargeForwardOnlyReadOnly() throws SQLException {
        this.cursorTest("BIG", 1003, 1007);
    }

    public void testLargeScrollSensitiveReadOnly() throws SQLException {
        this.cursorTest("BIG", 1005, 1007);
    }

    public void testLargeScrollInsensitiveReadOnly() throws SQLException {
        this.cursorTest("BIG", 1004, 1007);
    }

    public void testLargeForwardOnlyUpdatable() throws SQLException {
        this.cursorTest("BIG", 1003, 1008);
    }

    public void testLargeScrollSensitiveUpdatable() throws SQLException {
        this.cursorTest("BIG", 1005, 1008);
    }

    public void testLargeScrollInsensitiveUpdatable() throws SQLException {
        this.cursorTest("BIG", 1004, 1008);
    }

    public void testLargePreparedForwardOnlyReadOnly() throws SQLException {
        this.preparedCursorTest("BIG", 1003, 1007);
    }

    public void testLargePreparedScrollSensitiveReadOnly() throws SQLException {
        this.preparedCursorTest("BIG", 1005, 1007);
    }

    public void testLargePreparedScrollInsensitiveReadOnly() throws SQLException {
        this.preparedCursorTest("BIG", 1004, 1007);
    }

    public void testLargePreparedForwardOnlyUpdatable() throws SQLException {
        this.preparedCursorTest("BIG", 1003, 1008);
    }

    public void testLargePreparedScrollSensitiveUpdatable() throws SQLException {
        this.preparedCursorTest("BIG", 1005, 1008);
    }

    public void testLargePreparedScrollInsensitiveUpdatable() throws SQLException {
        this.preparedCursorTest("BIG", 1004, 1008);
    }

    public void testSetSchema() throws SQLException {
        Statement s = this.createStatement();
        s.execute("SET SCHEMA FOO");
        this.verifyCachedSchema(this.getConnection());
        s.execute("SET SCHEMA \"\u00bbMY\u20ac\u00ab\"");
        this.verifyCachedSchema(this.getConnection());
    }

    public void testPreparedSetSchema() throws SQLException {
        PreparedStatement ps = this.prepareStatement("SET SCHEMA ?");
        ps.setString(1, "FOO");
        ps.execute();
        this.verifyCachedSchema(this.getConnection());
        ps.setString(1, "\u00bbMY\u20ac\u00ab");
        ps.execute();
        this.verifyCachedSchema(this.getConnection());
    }

    public void testSetSchemaProcedure() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CALL APP.SET_SCHEMA('FOO')");
        this.verifyCachedSchema(this.getConnection());
        s.execute("CALL APP.SET_SCHEMA('\"\u00bbMY\u20ac\u00ab\"')");
        this.verifyCachedSchema(this.getConnection());
    }

    public void testPreparedSetSchemaProcedure() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL APP.SET_SCHEMA(?)");
        cs.setString(1, "FOO");
        cs.execute();
        this.verifyCachedSchema(this.getConnection());
        cs.setString(1, "\"\u00bbMY\u20ac\u00ab\"");
        cs.execute();
        this.verifyCachedSchema(this.getConnection());
    }

    public void testSetSchemaFunction() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("SELECT APP.GET_SCHEMA_TRANSITION(SCHEMANAME) FROM SYS.SYSSCHEMAS");
        while (rs.next()) {
            CacheSessionDataTest.assertTrue((rs.getString(1).length() > 2 ? 1 : 0) != 0);
            this.verifyCachedSchema(this.getConnection());
        }
    }

    public void testPreparedSetSchemaFunction() throws SQLException {
        PreparedStatement ps = this.prepareStatement("SELECT APP.GET_SCHEMA_TRANSITION(SCHEMANAME) FROM SYS.SYSSCHEMAS");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            CacheSessionDataTest.assertTrue((rs.getString(1).length() > 2 ? 1 : 0) != 0);
            this.verifyCachedSchema(this.getConnection());
        }
    }

    public void testSetSchemaFunctionLarge() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("SELECT X, APP.GET_SCHEMA_TRANSITION(SCHEMANAME), Y FROM APP.LARGE");
        while (rs.next()) {
            CacheSessionDataTest.assertTrue((rs.getString(2).length() > 2 ? 1 : 0) != 0);
            this.verifyCachedSchema(this.getConnection());
        }
    }

    public void testPreparedSetSchemaFunctionLarge() throws SQLException {
        PreparedStatement ps = this.prepareStatement("SELECT X, APP.GET_SCHEMA_TRANSITION(SCHEMANAME), Y FROM APP.LARGE");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            CacheSessionDataTest.assertTrue((rs.getString(2).length() > 2 ? 1 : 0) != 0);
            this.verifyCachedSchema(this.getConnection());
        }
    }

    static {
        isolationIndex = -1;
    }
}

