/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derby.jdbc.BasicEmbeddedDataSource40;
import org.apache.derby.jdbc.ClientDataSourceInterface;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.SecurityCheck;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DataSourceTest
extends BaseJDBCTestCase {
    private static final String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
    protected static Hashtable<String, Connection> conns = new Hashtable();
    private static final String CONNSTRING_FORMAT = "\\S+@\\-?[0-9]+.* \\(XID = .*\\), \\(SESSIONID = [0-9]+\\), \\(DATABASE = [A-Za-z]+\\), \\(DRDAID = .*\\) ";
    private final Object nogc = SecurityCheck.class;

    public DataSourceTest(String name) {
        super(name);
    }

    private static Test baseSuite(String postfix) {
        BaseTestSuite suite = new BaseTestSuite("ClientAndEmbedded" + postfix);
        suite.addTest((Test)new DataSourceTest("testBadConnectionAttributeSyntax"));
        suite.addTest((Test)new DataSourceTest("testDescriptionProperty"));
        suite.addTest((Test)new DataSourceTest("testAllDataSources"));
        suite.addTest((Test)new DataSourceTest("testJira95ds"));
        return suite;
    }

    private static Test getClientSuite() {
        BaseTestSuite suite = new BaseTestSuite("Client/Server");
        suite.addTest((Test)new DataSourceTest("testClientDSConnectionAttributes"));
        suite.addTest((Test)new DataSourceTest("testClientTraceFileDSConnectionAttribute"));
        suite.addTest((Test)new DataSourceTest("testClientMessageTextConnectionAttribute"));
        return suite;
    }

    private static Test getEmbeddedSuite(String postfix) {
        BaseTestSuite suite = new BaseTestSuite("Embedded" + postfix);
        suite.addTest((Test)new DataSourceTest("testDSRequestAuthentication"));
        return suite;
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("DataSourceTest suite");
        suite.addTest(DataSourceTest.getEmbeddedSuite("embedded"));
        suite.addTest(DataSourceTest.baseSuite(":embedded"));
        if (!JDBC.vmSupportsJSR169()) {
            suite.addTest(TestConfiguration.clientServerDecorator(DataSourceTest.baseSuite(":client")));
            suite.addTest(TestConfiguration.clientServerDecorator(DataSourceTest.getClientSuite()));
        }
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("create table intTable(i int)");
            }
        };
    }

    @Override
    public void tearDown() throws Exception {
        for (int i = 0; i < 6; ++i) {
            String traceFileName = "trace" + (i + 1) + ".out";
            File traceFile = new File(traceFileName);
            if (!PrivilegedFileOpsForTests.exists(traceFile)) continue;
            PrivilegedFileOpsForTests.delete(traceFile);
        }
        super.tearDown();
    }

    public void testAllDataSources() throws SQLException, Exception {
        Object[] expectedValues = new Object[]{1, "XJ010", 2, true, false};
        if (DataSourceTest.usingEmbedded()) {
            this.assertTenConnectionsUnique();
        }
        DataSource dscs = JDBCDataSource.getDataSource();
        if (DataSourceTest.usingEmbedded()) {
            DataSourceTest.assertToString(dscs);
        }
        DataSource ds = dscs;
        this.assertConnectionOK(expectedValues, "DataSource", ds.getConnection());
        if (JDBC.vmSupportsJDBC4()) {
            BasicEmbeddedDataSource40 nds = new BasicEmbeddedDataSource40();
            nds.setDatabaseName(dbName);
            this.assertConnectionOK(expectedValues, "BasicDataSource", nds.getConnection());
        }
    }

    public void testJira95ds() throws SQLException {
        try {
            DataSource ds = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(ds, "databaseName", "jdbc:derby:wombat");
            ds.getConnection();
            DataSourceTest.fail((String)"expected an SQLException!");
        }
        catch (SQLException sqle) {
            DataSourceTest.assertSQLState("XCY00", sqle);
        }
        catch (Exception e) {
            DataSourceTest.fail((String)("unexpected exception: " + e.toString()));
        }
    }

    public void testBadConnectionAttributeSyntax() throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", "bad");
        try {
            ds.getConnection();
            DataSourceTest.fail((String)"should have seen an error");
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("XJ028", e);
        }
    }

    public void testClientDSConnectionAttributes() throws Exception {
        if (DataSourceTest.usingEmbedded()) {
            return;
        }
        ClientDataSourceInterface ds = null;
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            ds = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientDataSource40");
            ds = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        ds.setPortNumber(TestConfiguration.getCurrent().getPort());
        DataSourceTest.dsConnectionRequests(new String[]{"08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001"}, (DataSource)ds);
        ds.setConnectionAttributes("databaseName=" + dbName);
        DataSourceTest.dsConnectionRequests(new String[]{"08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001"}, (DataSource)ds);
        ds.setConnectionAttributes(null);
        ds.setConnectionAttributes("databaseName=kangaroo");
        ds.setDatabaseName(dbName);
        DataSourceTest.dsConnectionRequests(new String[]{"OK", "08001", "OK", "OK", "08001", "08001", "OK", "OK", "OK"}, (DataSource)ds);
        ds.setConnectionAttributes(null);
        ds.setDatabaseName(null);
    }

    public void testDSRequestAuthentication() throws SQLException {
        JDBCClient dsclient = this.getTestConfiguration().getJDBCClient();
        String dsName = dsclient.getDataSourceClassName();
        DataSource ds = null;
        try {
            Class<?> clazz = Class.forName(dsName);
            ds = (DataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            DataSourceTest.fail((String)"unable to complete test because unable to create new instance of datasource");
        }
        DataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004"}, ds);
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "databaseName=" + dbName);
        DataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004"}, ds);
        JDBCDataSource.clearStringBeanProperty(ds, "connectionAttributes");
        ds = null;
        TestConfiguration.getCurrent().shutdownDatabase();
    }

    public void testClientTraceFileDSConnectionAttribute() throws SQLException {
        if (DataSourceTest.usingEmbedded()) {
            return;
        }
        DataSource ds = JDBCDataSource.getDataSource();
        String traceFile = "trace1.out";
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "traceFile=" + traceFile);
        DataSourceTest.dsGetBadConnection(ds);
        JDBCDataSource.clearStringBeanProperty(ds, "connectionAttributes");
        traceFile = "trace2.out";
        JDBCDataSource.setBeanProperty(ds, "traceFile", traceFile);
        ds.getConnection();
        ds = null;
        DataSourceTest.assertTraceFilesExist();
    }

    private static void dsGetBadConnection(DataSource ds) {
        try {
            ds.getConnection();
            ds.getConnection(null, null);
            DataSourceTest.fail((String)"expected an sqlException");
        }
        catch (SQLException sqle) {
            DataSourceTest.assertSQLState("08001", sqle);
        }
    }

    private static void assertTraceFilesExist() {
        for (int i = 0; i < 2; ++i) {
            String traceFileName = "trace" + (i + 1) + ".out";
            File traceFile = new File(traceFileName);
            DataSourceTest.assertTrue((boolean)PrivilegedFileOpsForTests.exists(traceFile));
        }
    }

    public void testClientMessageTextConnectionAttribute() throws Exception {
        if (DataSourceTest.usingEmbedded()) {
            return;
        }
        String retrieveMessageTextProperty = "retrieveMessageText";
        ClientDataSourceInterface ds = null;
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            ds = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientDataSource40");
            ds = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        ds.setPortNumber(TestConfiguration.getCurrent().getPort());
        ds.setDatabaseName(dbName);
        ds.setConnectionAttributes(retrieveMessageTextProperty + "=false");
        Connection conn = ds.getConnection();
        DataSourceTest.assertMessageText(conn, "false");
        conn.close();
        ds.setConnectionAttributes(retrieveMessageTextProperty + "=true");
        conn = ds.getConnection();
        DataSourceTest.assertMessageText(conn, "true");
        ds.setConnectionAttributes(null);
        conn.close();
    }

    private static void assertMessageText(Connection conn, String retrieveMessageTextValue) throws SQLException {
        try {
            conn.createStatement().executeQuery("SELECT * FROM APP.NOTTHERE");
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("42X05", e);
            if (retrieveMessageTextValue.equals("true")) {
                DataSourceTest.assertTrue((e.getMessage().indexOf("does not exist") >= 0 ? 1 : 0) != 0);
            }
            DataSourceTest.assertTrue((e.getMessage().indexOf("does not exist") == -1 ? 1 : 0) != 0);
        }
    }

    public void testDescriptionProperty() throws SQLException, Exception {
        this.subTestDataSourceDescription(JDBCDataSource.getDataSource());
    }

    private void subTestDataSourceDescription(DataSource ds) throws Exception {
        String setDescription = "Everything you ever wanted to know about this datasource";
        JDBCDataSource.setBeanProperty(ds, "description", setDescription);
        ds.getConnection();
        DataSourceTest.assertEquals((Object)setDescription, (Object)JDBCDataSource.getBeanProperty(ds, "description"));
        JDBCDataSource.clearStringBeanProperty(ds, "description");
        DataSourceTest.assertNull((Object)JDBCDataSource.getBeanProperty(ds, "description"));
    }

    private static void setDatabaseProperty(String property, String value) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource();
        Connection cadmin = ds.getConnection();
        CallableStatement cs = cadmin.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        cs.setString(1, property);
        cs.setString(2, value);
        cs.execute();
        cs.close();
        cadmin.close();
    }

    private static void dsConnectionRequests(String[] expectedValues, DataSource ds) {
        if (DataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(ds, "javax.sql.DataSource");
        }
        try {
            ds.getConnection();
            if (!expectedValues[0].equals("OK")) {
                DataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sqle) {
            DataSourceTest.assertSQLState(expectedValues[0], sqle);
        }
        DataSourceTest.dsConnectionRequest(expectedValues[1], ds, null, null);
        DataSourceTest.dsConnectionRequest(expectedValues[2], ds, "fred", null);
        DataSourceTest.dsConnectionRequest(expectedValues[3], ds, "fred", "wilma");
        DataSourceTest.dsConnectionRequest(expectedValues[4], ds, null, "wilma");
        DataSourceTest.dsConnectionRequest(expectedValues[5], ds, null, "databaseName=wombat");
        DataSourceTest.dsConnectionRequest(expectedValues[6], ds, "fred", "databaseName=wombat");
        DataSourceTest.dsConnectionRequest(expectedValues[7], ds, "fred", "databaseName=wombat;password=wilma");
        DataSourceTest.dsConnectionRequest(expectedValues[8], ds, "fred", "databaseName=wombat;password=betty");
    }

    private static void dsConnectionRequest(String expectedValue, DataSource ds, String user, String ConnAttr) {
        try {
            ds.getConnection(user, ConnAttr);
            if (!expectedValue.equals("OK")) {
                DataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sqle) {
            DataSourceTest.assertSQLState(expectedValue, sqle);
        }
    }

    private void assertConnectionOK(Object[] expectedValues, String dsName, Connection conn) throws SQLException {
        DataSourceTest.assertEquals((int)((Integer)expectedValues[0]), (int)conn.getHoldability());
        try {
            conn.releaseSavepoint(conn.setSavepoint());
            if (conn.getAutoCommit()) {
                DataSourceTest.fail((String)"expected a SQLExpection (savepoint with autocommit on");
            }
            if (!((String)expectedValues[1]).equals("OK")) {
                DataSourceTest.fail((String)"expected a SQLExpection (savepoint with autocommit on");
            }
        }
        catch (SQLException sqle) {
            if (conn.getAutoCommit()) {
                DataSourceTest.assertSQLState("XJ010", sqle);
            }
            if (((String)expectedValues[1]).equals("OK")) {
                DataSourceTest.fail((String)"unexpected JDBC 3.0 savepoint SQL Exception");
            }
            DataSourceTest.assertSQLState((String)expectedValues[1], sqle);
        }
        if (DataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(conn, "java.sql.Connection");
            SecurityCheck.assertSourceSecurity(conn.getMetaData(), "java.sql.DatabaseMetaData");
        }
        DataSourceTest.assertEquals((int)((Integer)expectedValues[2]), (int)conn.getTransactionIsolation());
        DataSourceTest.assertEquals((boolean)((Boolean)expectedValues[3]), (boolean)conn.getAutoCommit());
        DataSourceTest.assertEquals((boolean)((Boolean)expectedValues[4]), (boolean)conn.isReadOnly());
        if (conn.getWarnings() != null) {
            DataSourceTest.assertSQLState("01J01", conn.getWarnings());
        }
        Statement s1 = conn.createStatement();
        this.assertStatementOK(dsName, conn, s1);
        this.assertStatementOK(dsName, conn, conn.createStatement(1004, 1007));
        Connection c1 = conn.getMetaData().getConnection();
        if (!DataSourceTest.usingDerbyNetClient() && dsName.indexOf("DataSource") >= 0) {
            DataSourceTest.assertEquals((Object)c1, (Object)conn);
        }
        this.assertConnectionPreClose(dsName, conn);
        conn.close();
        try {
            conn.close();
        }
        catch (SQLException sqle) {
            DataSourceTest.fail((String)" unexpected exception on <closedconn>.close() ");
        }
        try {
            conn.createStatement();
            DataSourceTest.fail((String)(dsName + " <closedconn>.createStatement(), " + "expected 08003 - No current connection"));
        }
        catch (SQLException sqle) {
            DataSourceTest.assertSQLState("08003", sqle);
        }
        try {
            s1.execute("values 1");
            DataSourceTest.fail((String)(dsName + " <closedstmt>.execute(), " + "expected 08003 - No current connection"));
        }
        catch (SQLException sqle) {
            DataSourceTest.assertSQLState("08003", sqle);
        }
    }

    private void assertConnectionPreClose(String dsName, Connection conn) throws SQLException {
        conn.setHoldability(2);
        if (!dsName.equals("Nested2")) {
            try {
                conn.setReadOnly(true);
            }
            catch (SQLException sqle) {
                DataSourceTest.assertSQLState("25501", sqle);
            }
        }
    }

    private void assertStatementOK(String dsName, Connection conn, Statement s) throws SQLException {
        ResultSet rs;
        Connection c1;
        if (DataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(s, "java.sql.Statement");
        }
        if ((c1 = s.getConnection()) != conn && !DataSourceTest.usingDerbyNetClient() && dsName.indexOf("DataSource") >= 0) {
            DataSourceTest.fail((String)"incorrect connection object returned for Statement.getConnection()");
        }
        s.addBatch("insert into intTable values 1");
        s.addBatch("insert into intTable values 2,3");
        int[] states = s.executeBatch();
        if (states[0] != 1) {
            DataSourceTest.fail((String)"invalid update count for first batch statement");
        }
        if (states[1] != 2) {
            DataSourceTest.fail((String)"invalid update count for second batch statement");
        }
        if ((rs = s.executeQuery("VALUES 1")).getStatement() != s) {
            DataSourceTest.fail((String)("incorrect Statement object returned for ResultSet.getStatement for " + dsName));
        }
        rs.close();
        s.close();
    }

    private static void assertToString(Connection conn) throws Exception {
        DataSourceTest.assertStringFormat(conn);
        String str = conn.toString();
        if (conns.containsKey(str)) {
            throw new Exception("ERROR: Connection toString() is not unique: " + str);
        }
        conns.put(str, conn);
    }

    private static void assertStringFormat(Connection conn) {
        DataSourceTest.assertStringPrefix(conn);
        String str = conn.toString();
        if (!JDBC.vmSupportsJSR169()) {
            DataSourceTest.assertTrue((String)("\nexpected format:\n \\S+@\\-?[0-9]+.* \\(XID = .*\\), \\(SESSIONID = [0-9]+\\), \\(DATABASE = [A-Za-z]+\\), \\(DRDAID = .*\\) \nactual value:\n " + str), (boolean)str.matches(CONNSTRING_FORMAT));
        }
    }

    private static String assertStringPrefix(Object conn) {
        String connstr = conn.toString();
        String prefix = conn.getClass().getName() + "@" + conn.hashCode();
        DataSourceTest.assertTrue((boolean)connstr.startsWith(prefix));
        return prefix;
    }

    private static void assertToString(DataSource ds) throws Exception {
        DataSourceTest.clearConnections();
        int numConnections = 10;
        for (int i = 0; i < numConnections; ++i) {
            Connection conn = ds.getConnection();
            DataSourceTest.assertToString(conn);
        }
        DataSourceTest.clearConnections();
    }

    private static void clearConnections() throws SQLException {
        for (Connection conn : conns.values()) {
            conn.close();
        }
        conns.clear();
    }

    private void assertTenConnectionsUnique() throws Exception {
        DataSourceTest.clearConnections();
        int numConnections = 10;
        for (int i = 0; i < numConnections; ++i) {
            Connection conn = this.openDefaultConnection();
            DataSourceTest.assertToString(conn);
        }
        DataSourceTest.clearConnections();
    }
}

