/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.Wrapper41DBMD;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.Wrapper42DBMD;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Version;
import org.apache.derbyTesting.functionTests.util.Barrier;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DatabaseMetaDataTest
extends BaseJDBCTestCase {
    private static final String[][] NUMERIC_FUNCTIONS = new String[][]{{"ABS", "-25.67"}, {"ACOS", "0.0707"}, {"ASIN", "0.997"}, {"ATAN", "14.10"}, {"ATAN2", "0.56", "1.2"}, {"CEILING", "3.45"}, {"COS", "1.2"}, {"COT", "3.4"}, {"DEGREES", "2.1"}, {"EXP", "2.3"}, {"FLOOR", "3.22"}, {"LOG", "34.1"}, {"LOG10", "18.7"}, {"MOD", "124", "7"}, {"PI"}, {"POWER", "2", "3"}, {"RADIANS", "54"}, {"RAND", "17"}, {"ROUND", "345.345", "1"}, {"SIGN", "-34"}, {"SIN", "0.32"}, {"SQRT", "6.22"}, {"TAN", "0.57"}, {"TRUNCATE", "345.395", "1"}};
    private static final String[][] TIMEDATE_FUNCTIONS = new String[][]{{"CURDATE"}, {"CURTIME"}, {"DAYNAME", "{d '1995-12-19'h}"}, {"DAYOFMONTH", "{d '1995-12-19'}"}, {"DAYOFWEEK", "{d '1995-12-19'}"}, {"DAYOFYEAR", "{d '1995-12-19'}"}, {"HOUR", "{t '16:13:03'}"}, {"MINUTE", "{t '16:13:03'}"}, {"MONTH", "{d '1995-12-19'}"}, {"MONTHNAME", "{d '1995-12-19'}"}, {"NOW"}, {"QUARTER", "{d '1995-12-19'}"}, {"SECOND", "{t '16:13:03'}"}, {"TIMESTAMPADD", "SQL_TSI_DAY", "7", "{ts '1995-12-19 12:15:54'}"}, {"TIMESTAMPDIFF", "SQL_TSI_DAY", "{ts '1995-12-19 12:15:54'}", "{ts '1997-11-02 00:15:23'}"}, {"WEEK", "{d '1995-12-19'}"}, {"YEAR", "{d '1995-12-19'}"}};
    private static final String[][] SYSTEM_FUNCTIONS = new String[][]{{"DATABASE"}, {"IFNULL", "'this'", "'that'"}, {"USER"}};
    private static final String[][] STRING_FUNCTIONS = new String[][]{{"ASCII", "'Yellow'"}, {"CHAR", "65"}, {"CONCAT", "'hello'", "'there'"}, {"DIFFERENCE", "'Pires'", "'Piers'"}, {"INSERT", "'Bill Clinton'", "4", "'William'"}, {"LCASE", "'Fernando Alonso'"}, {"LEFT", "'Bonjour'", "3"}, {"LENGTH", "'four    '"}, {"LOCATE", "'jour'", "'Bonjour'"}, {"LTRIM", "'   left trim   '"}, {"REPEAT", "'echo'", "3"}, {"REPLACE", "'to be or not to be'", "'be'", "'England'"}, {"RTRIM", "'  right trim   '"}, {"SOUNDEX", "'Derby'"}, {"SPACE", "12"}, {"SUBSTRING", "'Ruby the Rubicon Jeep'", "10", "7"}, {"UCASE", "'Fernando Alonso'"}};
    private boolean modifiedDatabase;
    private String schema;
    private static final String[] IDS = new String[]{"one_dmd_test", "TWO_dmd_test", "ThReE_dmd_test", "\"four_dmd_test\"", "\"FIVE_dmd_test\"", "\"sIx_dmd_test\""};
    private static final String[] BUILTIN_SCHEMAS = new String[]{"APP", "NULLID", "SQLJ", "SYS", "SYSCAT", "SYSCS_DIAG", "SYSCS_UTIL", "SYSFUN", "SYSIBM", "SYSPROC", "SYSSTAT"};

    public DatabaseMetaDataTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.schema = TestConfiguration.getCurrent().getUserName();
        DatabaseMetaDataTest.assertTrue((String)"schema name must be at least three characters long", (this.schema.length() > 2 ? 1 : 0) != 0);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.modifiedDatabase) {
            Connection conn = this.getConnection();
            conn.setAutoCommit(false);
            DatabaseMetaData dmd = this.getDMD();
            for (String IDS1 : IDS) {
                JDBC.dropSchema(dmd, DatabaseMetaDataTest.getStoredIdentifier(IDS1));
            }
            this.commit();
        }
        super.tearDown();
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("DatabaseMetaDataTest");
        suite.addTest(TestConfiguration.defaultSuite(DatabaseMetaDataTest.class));
        suite.addTest(DatabaseMetaDataTest.connectionPoolingSuite("embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(DatabaseMetaDataTest.connectionPoolingSuite("client")));
        suite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)new DatabaseMetaDataTest("initialCompilationTest")));
        suite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)new DatabaseMetaDataTest("concurrentCompilationTest")));
        Properties props = new Properties();
        props.setProperty("derby.locks.waitTimeout", "90");
        props.setProperty("derby.language.stalePlanCheckInterval", "5");
        suite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)new DatabasePropertyTestSetup((Test)new DatabaseMetaDataTest("recompileTimeoutTest"), props, true)));
        return suite;
    }

    private static Test connectionPoolingSuite(String jdbcClient) {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("Base connection pooling suite:DISABLED");
        }
        BaseTestSuite baseCpSuite = new BaseTestSuite("Base connection pooling suite");
        baseCpSuite.addTest((Test)new DatabaseMetaDataTest("testConnectionSpecific"));
        BaseTestSuite fullCpSuite = new BaseTestSuite("DatabaseMetaData with connection pooling:" + jdbcClient);
        BaseTestSuite cpSuite = new BaseTestSuite("ConnectionPoolDataSource");
        BaseTestSuite xaSuite = new BaseTestSuite("XADataSource");
        cpSuite.addTest(TestConfiguration.connectionCPDecorator((Test)baseCpSuite));
        xaSuite.addTest(TestConfiguration.connectionXADecorator((Test)baseCpSuite));
        fullCpSuite.addTest((Test)cpSuite);
        fullCpSuite.addTest((Test)xaSuite);
        return fullCpSuite;
    }

    private String[] getSortedIdentifiers() {
        Object[] dbIDS = new String[IDS.length];
        for (int i = 0; i < IDS.length; ++i) {
            dbIDS[i] = DatabaseMetaDataTest.getStoredIdentifier(IDS[i]);
        }
        Arrays.sort(dbIDS);
        return dbIDS;
    }

    private DatabaseMetaData getDMD() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public void initialCompilationTest() throws SQLException {
        Connection c = this.getConnection();
        c.setAutoCommit(false);
        c.setTransactionIsolation(4);
        Statement s = this.createStatement();
        JDBC.assertDrainResults(s.executeQuery("SELECT * FROM SYS.SYSSTATEMENTS"));
        s.close();
        this.getDMD().getIndexInfo(null, null, "T", false, false).close();
        this.getDMD().getIndexInfo(null, null, "T", false, false).close();
    }

    public void concurrentCompilationTest() throws Exception {
        final Barrier barrier = new Barrier(2);
        final DatabaseMetaData dmd = this.getDMD();
        final Exception[] exception = new Exception[1];
        Thread th = new Thread(){

            @Override
            public void run() {
                try {
                    DatabaseMetaDataTest.this.concurrentCompilationTestHelper(barrier, dmd);
                }
                catch (Exception e) {
                    exception[0] = e;
                }
            }
        };
        th.start();
        Connection c2 = this.openDefaultConnection();
        this.concurrentCompilationTestHelper(barrier, c2.getMetaData());
        c2.close();
        th.join();
        if (exception[0] != null) {
            DatabaseMetaDataTest.fail("Exception in other thread", exception[0]);
        }
        this.testGetBestRowIdentifier();
        this.testGetIndexInfo();
    }

    private void concurrentCompilationTestHelper(Barrier barrier, DatabaseMetaData dmd) throws Exception {
        barrier.await();
        ResultSet rs1 = dmd.getBestRowIdentifier(null, null, "", 0, true);
        ResultSet rs2 = dmd.getIndexInfo(null, null, "", true, true);
        JDBC.assertDrainResults(rs1);
        JDBC.assertDrainResults(rs2);
    }

    public void recompileTimeoutTest() throws SQLException {
        int i;
        DatabaseMetaData dmd = this.getDMD();
        JDBC.assertDrainResults(dmd.getTables(null, "%", "%", null));
        Statement s = this.createStatement();
        for (i = 0; i < 20; ++i) {
            s.executeUpdate("create table t" + i + "(x int)");
        }
        for (i = 0; i < 5; ++i) {
            long time = System.currentTimeMillis();
            JDBC.assertDrainResults(dmd.getTables(null, "%", "T0", null));
            time = System.currentTimeMillis() - time;
            if (time <= 60000L) continue;
            DatabaseMetaDataTest.fail((String)("getTables() took a very long time, possibly because of an internal timeout. i=" + i + ", time=" + time));
        }
    }

    public void testDetermineFeatureSupport() throws SQLException {
        DatabaseMetaData dmd = this.getDMD();
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsAlterTableWithAddColumn());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsAlterTableWithDropColumn());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsANSI92EntryLevelSQL());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsANSI92FullSQL());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsANSI92IntermediateSQL());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsBatchUpdates());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsCatalogsInDataManipulation());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsCatalogsInIndexDefinitions());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsCatalogsInPrivilegeDefinitions());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsCatalogsInProcedureCalls());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsCatalogsInTableDefinitions());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsColumnAliasing());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsConvert());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsConvert(4, 5));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsCoreSQLGrammar());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsCorrelatedSubqueries());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsDataDefinitionAndDataManipulationTransactions());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsDataManipulationTransactionsOnly());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsDifferentTableCorrelationNames());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsExpressionsInOrderBy());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsExtendedSQLGrammar());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsFullOuterJoins());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsGetGeneratedKeys());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsGroupBy());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsGroupByBeyondSelect());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsGroupByUnrelated());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsIntegrityEnhancementFacility());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsLikeEscapeClause());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsLimitedOuterJoins());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsMinimumSQLGrammar());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsMixedCaseIdentifiers());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsMixedCaseQuotedIdentifiers());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsMultipleOpenResults());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsMultipleResultSets());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsMultipleTransactions());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsNamedParameters());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsNonNullableColumns());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsOpenCursorsAcrossCommit());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsOpenCursorsAcrossRollback());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsOpenStatementsAcrossCommit());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsOpenStatementsAcrossRollback());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsOrderByUnrelated());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsOuterJoins());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsPositionedDelete());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsPositionedUpdate());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsResultSetConcurrency(1003, 1007));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsResultSetConcurrency(1003, 1008));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsResultSetConcurrency(1004, 1007));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsResultSetConcurrency(1004, 1008));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsResultSetConcurrency(1005, 1007));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsResultSetConcurrency(1005, 1008));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsResultSetHoldability(2));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsResultSetHoldability(1));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsResultSetType(1003));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsResultSetType(1004));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsResultSetType(1005));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsSavepoints());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsSchemasInDataManipulation());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsSchemasInIndexDefinitions());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsSchemasInPrivilegeDefinitions());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsSchemasInProcedureCalls());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsSchemasInTableDefinitions());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsSelectForUpdate());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.supportsStatementPooling());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsStoredProcedures());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsSubqueriesInComparisons());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsSubqueriesInExists());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsSubqueriesInIns());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsSubqueriesInQuantifieds());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsTableCorrelationNames());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsTransactionIsolationLevel(2));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsTransactionIsolationLevel(1));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsTransactionIsolationLevel(4));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsTransactionIsolationLevel(8));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsTransactions());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsUnion());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.supportsUnionAll());
    }

    public void testDataSourceLimits() throws SQLException {
        DatabaseMetaData dmd = this.getDMD();
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxBinaryLiteralLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxCatalogNameLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxCharLiteralLength());
        DatabaseMetaDataTest.assertEquals((int)128, (int)dmd.getMaxColumnNameLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxColumnsInGroupBy());
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxColumnsInIndex());
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxColumnsInOrderBy());
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxColumnsInSelect());
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxColumnsInTable());
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxConnections());
        DatabaseMetaDataTest.assertEquals((int)128, (int)dmd.getMaxCursorNameLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxIndexLength());
        DatabaseMetaDataTest.assertEquals((int)128, (int)dmd.getMaxProcedureNameLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxRowSize());
        DatabaseMetaDataTest.assertEquals((int)128, (int)dmd.getMaxSchemaNameLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxStatementLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxStatements());
        DatabaseMetaDataTest.assertEquals((int)128, (int)dmd.getMaxTableNameLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)dmd.getMaxTablesInSelect());
        DatabaseMetaDataTest.assertEquals((int)128, (int)dmd.getMaxUserNameLength());
    }

    public void testMiscellaneous() throws SQLException {
        DatabaseMetaData dmd = this.getDMD();
        DatabaseMetaDataTest.assertTrue((boolean)dmd.allProceduresAreCallable());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.allTablesAreSelectable());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.dataDefinitionCausesTransactionCommit());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.dataDefinitionIgnoredInTransactions());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.deletesAreDetected(1003));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.deletesAreDetected(1004));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.deletesAreDetected(1005));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.insertsAreDetected(1003));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.insertsAreDetected(1004));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.insertsAreDetected(1005));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.updatesAreDetected(1003));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.updatesAreDetected(1004));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.updatesAreDetected(1005));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.othersDeletesAreVisible(1003));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.othersDeletesAreVisible(1004));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.othersDeletesAreVisible(1005));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.othersInsertsAreVisible(1003));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.othersInsertsAreVisible(1004));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.othersInsertsAreVisible(1005));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.othersUpdatesAreVisible(1003));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.othersUpdatesAreVisible(1004));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.othersUpdatesAreVisible(1005));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.ownDeletesAreVisible(1003));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.ownDeletesAreVisible(1004));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.ownDeletesAreVisible(1005));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.ownInsertsAreVisible(1003));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.ownInsertsAreVisible(1004));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.ownInsertsAreVisible(1005));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.ownUpdatesAreVisible(1003));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.ownUpdatesAreVisible(1004));
        DatabaseMetaDataTest.assertFalse((boolean)dmd.ownUpdatesAreVisible(1005));
        DatabaseMetaDataTest.assertTrue((boolean)dmd.doesMaxRowSizeIncludeBlobs());
        DatabaseMetaDataTest.assertEquals((String)"", (String)dmd.getCatalogSeparator());
        DatabaseMetaDataTest.assertEquals((String)"CATALOG", (String)dmd.getCatalogTerm());
        DatabaseMetaDataTest.assertEquals((int)2, (int)dmd.getDefaultTransactionIsolation());
        DatabaseMetaDataTest.assertEquals((String)"", (String)dmd.getExtraNameCharacters());
        DatabaseMetaDataTest.assertEquals((String)"\"", (String)dmd.getIdentifierQuoteString());
        DatabaseMetaDataTest.assertEquals((String)"PROCEDURE", (String)dmd.getProcedureTerm());
        DatabaseMetaDataTest.assertEquals((int)1, (int)dmd.getResultSetHoldability());
        DatabaseMetaDataTest.assertEquals((String)"SCHEMA", (String)dmd.getSchemaTerm());
        DatabaseMetaDataTest.assertEquals((String)"", (String)dmd.getSearchStringEscape());
        DatabaseMetaDataTest.assertEquals((int)2, (int)dmd.getSQLStateType());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.isCatalogAtStart());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.locatorsUpdateCopy());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.usesLocalFilePerTable());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.usesLocalFiles());
    }

    public void testVersionInfo() throws SQLException {
        DatabaseMetaData dmd = this.getDMD();
        int databaseMajor = dmd.getDatabaseMajorVersion();
        int databaseMinor = dmd.getDatabaseMinorVersion();
        int driverMajor = dmd.getDriverMajorVersion();
        int driverMinor = dmd.getDriverMinorVersion();
        String databaseVersion = dmd.getDatabaseProductVersion();
        String driverVersion = dmd.getDriverVersion();
        if (DatabaseMetaDataTest.usingEmbedded()) {
            DatabaseMetaDataTest.assertEquals((String)"Embedded Major version ", (int)databaseMajor, (int)driverMajor);
            DatabaseMetaDataTest.assertEquals((String)"Embedded Minor version ", (int)databaseMinor, (int)driverMinor);
            DatabaseMetaDataTest.assertEquals((String)"Embedded version", (String)databaseVersion, (String)driverVersion);
        }
        DatabaseMetaDataTest.assertEquals((String)"Apache Derby", (String)dmd.getDatabaseProductName());
        String driverName = dmd.getDriverName();
        if (DatabaseMetaDataTest.usingEmbedded()) {
            DatabaseMetaDataTest.assertEquals((String)"Apache Derby Embedded JDBC Driver", (String)driverName);
        } else if (DatabaseMetaDataTest.usingDerbyNetClient()) {
            DatabaseMetaDataTest.assertEquals((String)"Apache Derby Network Client JDBC Driver", (String)driverName);
        }
        int jdbcMajor = dmd.getJDBCMajorVersion();
        int jdbcMinor = dmd.getJDBCMinorVersion();
        int expectedJDBCMajor = -1;
        int expectedJDBCMinor = -1;
        if (JDBC.vmSupportsJDBC42()) {
            expectedJDBCMajor = 4;
            expectedJDBCMinor = 2;
        } else if (JDBC.vmSupportsJDBC41()) {
            expectedJDBCMajor = 4;
            expectedJDBCMinor = 1;
        } else if (JDBC.vmSupportsJDBC4()) {
            expectedJDBCMajor = 4;
            expectedJDBCMinor = 0;
        }
        if (expectedJDBCMajor != -1) {
            DatabaseMetaDataTest.assertEquals((String)"JDBC Major version", (int)expectedJDBCMajor, (int)jdbcMajor);
            DatabaseMetaDataTest.assertEquals((String)"JDBC Minor version", (int)expectedJDBCMinor, (int)jdbcMinor);
        }
    }

    public void testGetURL() throws SQLException {
        String url;
        DatabaseMetaData dmd = this.getDMD();
        try {
            url = dmd.getURL();
        }
        catch (NoSuchMethodError e) {
            DatabaseMetaDataTest.assertTrue((String)"getURL not supported", (boolean)JDBC.vmSupportsJSR169());
            DatabaseMetaDataTest.assertFalse((String)"getURL not supported", (boolean)JDBC.vmSupportsJDBC3());
            return;
        }
        DatabaseMetaDataTest.assertFalse((String)"getURL is supported!", (boolean)JDBC.vmSupportsJSR169());
        DatabaseMetaDataTest.assertTrue((String)"getURL is supported!", (boolean)JDBC.vmSupportsJDBC3());
        TestConfiguration config = this.getTestConfiguration();
        String expectedURL = config.getJDBCUrl();
        if (DatabaseMetaDataTest.usingDerbyNetClient()) {
            List<String> urlComponents = Arrays.asList(url.split(";"));
            url = urlComponents.get(0);
            HashSet<String> attrs = new HashSet<String>(urlComponents.subList(1, urlComponents.size()));
            HashSet<String> expectedAttrs = new HashSet<String>();
            Properties ca = config.getConnectionAttributes();
            for (String key : ca.stringPropertyNames()) {
                expectedAttrs.add(key + '=' + ca.getProperty(key));
            }
            DatabaseMetaDataTest.assertEquals((String)"Connection attributes don't match", expectedAttrs, attrs);
        }
        DatabaseMetaDataTest.assertEquals((String)"getURL match", (String)expectedURL, (String)url);
    }

    public void testIdentifierStorage() throws SQLException {
        DatabaseMetaData dmd = this.getDMD();
        DatabaseMetaDataTest.assertFalse((boolean)dmd.storesLowerCaseIdentifiers());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.storesLowerCaseQuotedIdentifiers());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.storesMixedCaseIdentifiers());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.storesMixedCaseQuotedIdentifiers());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.storesUpperCaseIdentifiers());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.storesUpperCaseQuotedIdentifiers());
    }

    public void testNullInfo() throws SQLException {
        DatabaseMetaData dmd = this.getDMD();
        DatabaseMetaDataTest.assertTrue((boolean)dmd.nullPlusNonNullIsNull());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.nullsAreSortedAtEnd());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.nullsAreSortedAtStart());
        DatabaseMetaDataTest.assertTrue((boolean)dmd.nullsAreSortedHigh());
        DatabaseMetaDataTest.assertFalse((boolean)dmd.nullsAreSortedLow());
    }

    public void testSQLKeywords() throws SQLException {
        String keywords = this.getDMD().getSQLKeywords();
        DatabaseMetaDataTest.assertNotNull((Object)keywords);
    }

    public void testConnectionSpecific() throws SQLException {
        DatabaseMetaData dmd = this.getDMD();
        DatabaseMetaDataTest.assertSame((Object)this.getConnection(), (Object)dmd.getConnection());
        DatabaseMetaDataTest.assertEquals((String)this.getTestConfiguration().getUserName(), (String)dmd.getUserName());
        DatabaseMetaDataTest.assertEquals((boolean)this.getConnection().isReadOnly(), (boolean)dmd.isReadOnly());
    }

    public void testConstants() {
        DatabaseMetaDataTest.assertEquals((int)0, (int)0);
        DatabaseMetaDataTest.assertEquals((int)1, (int)1);
        DatabaseMetaDataTest.assertEquals((int)2, (int)2);
    }

    public void testUDTs() throws Exception {
        Version dataVersion = this.getDataVersion(this.getConnection());
        if (dataVersion.compareTo(new Version(10, 6, 0, 0)) < 0) {
            return;
        }
        DatabaseMetaData dmd = this.getDMD();
        this.createObjectsForUDTTests();
        ResultSet rs = dmd.getUDTs(null, null, null, null);
        String[] columnNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"};
        int[] columnTypes = new int[]{12, 12, 12, -1, 4, 12, 5};
        boolean[] nullability = new boolean[]{true, true, false, false, false, true, true};
        DatabaseMetaDataTest.assertMetaDataResultSet(rs, columnNames, columnTypes, nullability);
        String[][] expectedRows = new String[][]{{null, this.schema, "PRICE", "org.apache.derbyTesting.functionTests.tests.lang.Price", "2000", null, null}};
        JDBC.assertFullResultSet(rs, expectedRows);
        rs = dmd.getUDTs(null, null, null, new int[]{2000});
        JDBC.assertFullResultSet(rs, expectedRows);
        rs = dmd.getUDTs(null, null, null, new int[]{2001, 2000});
        JDBC.assertFullResultSet(rs, expectedRows);
        rs = dmd.getUDTs(null, null, null, new int[]{2001, 2002});
        JDBC.assertEmpty(rs);
        rs = dmd.getUDTs(null, this.schema, "PRICE", new int[]{2001, 2000});
        JDBC.assertFullResultSet(rs, expectedRows);
        rs = dmd.getUDTs(null, this.schema.substring(0, 2) + "%", "PRI%", new int[]{2001, 2000});
        JDBC.assertFullResultSet(rs, expectedRows);
        rs = dmd.getUDTs(null, "FOO", "PRICE", new int[]{2001, 2000});
        JDBC.assertEmpty(rs);
        rs = dmd.getColumns(null, this.schema, "ORDERS", null);
        expectedRows = new String[][]{{"", this.schema, "ORDERS", "TOTALPRICE", "2000", "\"" + this.schema + "\".\"PRICE\"", "-1", null, null, null, "1", "", null, null, null, null, "1", "YES", null, null, null, null, "NO", "NO", null}};
        JDBC.assertFullResultSet(rs, expectedRows);
        rs = dmd.getColumns(null, this.schema, "ORDERS", null);
        this.crossCheckGetColumnsAndResultSetMetaData(rs, false, 0);
        this.dropObjectsForUDTTests();
    }

    private void createObjectsForUDTTests() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create type price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        s.execute("create table orders( totalPrice price )");
        this.commit();
        this.getConnection().setAutoCommit(true);
    }

    private void dropObjectsForUDTTests() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("drop table orders");
        s.execute("drop type price restrict");
        this.commit();
        this.getConnection().setAutoCommit(true);
    }

    public void testUnimplementedSQLObjectAttributes() throws SQLException {
        DatabaseMetaData dmd = this.getDMD();
        ResultSet rs = dmd.getAttributes(null, null, null, null);
        String[] columnNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "ATTR_NAME", "DATA_TYPE", "ATTR_TYPE_NAME", "ATTR_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "ATTR_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"};
        int[] columnTypes = new int[]{12, 12, 12, 12, 4, 12, 4, 4, 4, 4, 12, 12, 4, 4, 4, 4, 12, 12, 12, 12, 5};
        boolean nullval = true;
        if (DatabaseMetaDataTest.usingDerbyNetClient()) {
            nullval = false;
        }
        boolean[] nullability = new boolean[]{true, true, false, nullval, nullval, nullval, nullval, nullval, nullval, nullval, true, true, nullval, nullval, nullval, nullval, nullval, true, true, true, true};
        DatabaseMetaDataTest.assertMetaDataResultSet(rs, columnNames, columnTypes, nullability);
        JDBC.assertEmpty(rs);
        rs = dmd.getCatalogs();
        this.checkCatalogsShape(rs);
        JDBC.assertEmpty(rs);
        rs = dmd.getSuperTables(null, null, null);
        columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "SUPERTABLE_NAME"};
        columnTypes = new int[]{12, 12, 12, 12};
        nullability = new boolean[]{true, true, false, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(rs, columnNames, columnTypes, nullability);
        JDBC.assertEmpty(rs);
        rs = dmd.getSuperTypes(null, null, null);
        columnNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SUPERTYPE_CAT", "SUPERTYPE_SCHEM", "SUPERTYPE_NAME"};
        columnTypes = new int[]{12, 12, 12, 12, 12, 12};
        nullability = new boolean[]{true, true, false, true, true, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(rs, columnNames, columnTypes, nullability);
        JDBC.assertEmpty(rs);
        ResultSet[] rss = this.getVersionColumns(null, null, "No_such_table");
        DatabaseMetaDataTest.checkVersionColumnsShape(rss);
        JDBC.assertEmpty(rss[0]);
        JDBC.assertEmpty(rss[1]);
        rs.close();
        rss[0].close();
        rss[1].close();
    }

    public ResultSet getVersionColumnsODBC(String catalog, String schema, String table) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLSPECIALCOLUMNS (2, ?, ?, ?, 1, 1, 'DATATYPE=''ODBC''')");
        cs.setString(1, catalog);
        cs.setString(2, schema);
        cs.setString(3, table);
        cs.execute();
        return cs.getResultSet();
    }

    private ResultSet[] getVersionColumns(String catalog, String schema, String table) throws SQLException {
        ResultSet[] rss = new ResultSet[2];
        DatabaseMetaData dmd = this.getDMD();
        rss[0] = dmd.getVersionColumns(catalog, schema, table);
        rss[1] = this.getVersionColumnsODBC(catalog, schema, table);
        return rss;
    }

    public static String getStoredIdentifier(String sqlIdentifier) {
        if (sqlIdentifier.charAt(0) == '\"') {
            return sqlIdentifier.substring(1, sqlIdentifier.length() - 1);
        }
        return sqlIdentifier.toUpperCase(Locale.ENGLISH);
    }

    public void testGetSchemasReadOnly() throws SQLException {
        DatabaseMetaData dmd = this.getDMD();
        ResultSet rs = dmd.getSchemas();
        DatabaseMetaDataTest.checkSchemas(rs, new String[0]);
    }

    public void testGetSchemasModify() throws SQLException {
        this.createSchemasForTests();
        DatabaseMetaData dmd = this.getDMD();
        ResultSet rs = dmd.getSchemas();
        DatabaseMetaDataTest.checkSchemas(rs, IDS);
    }

    private void createSchemasForTests() throws SQLException {
        this.modifiedDatabase = true;
        Statement s = this.createStatement();
        for (String IDS1 : IDS) {
            s.executeUpdate("CREATE SCHEMA " + IDS1);
        }
        s.close();
        this.commit();
    }

    public static void checkSchemas(ResultSet rs, String[] userExpected) throws SQLException {
        DatabaseMetaDataTest.checkSchemasShape(rs);
        Object[] expected = new String[BUILTIN_SCHEMAS.length + userExpected.length];
        System.arraycopy(BUILTIN_SCHEMAS, 0, expected, 0, BUILTIN_SCHEMAS.length);
        System.arraycopy(userExpected, 0, expected, BUILTIN_SCHEMAS.length, userExpected.length);
        for (int i = BUILTIN_SCHEMAS.length; i < expected.length; ++i) {
            expected[i] = DatabaseMetaDataTest.getStoredIdentifier((String)expected[i]);
        }
        Arrays.sort(expected);
        int nextMatch = 0;
        while (rs.next()) {
            String schema = rs.getString("TABLE_SCHEM");
            DatabaseMetaDataTest.assertNotNull((Object)schema);
            DatabaseMetaDataTest.assertNull((Object)rs.getString("TABLE_CATALOG"));
            if (nextMatch >= expected.length || !((String)expected[nextMatch]).equals(schema)) continue;
            ++nextMatch;
        }
        rs.close();
        DatabaseMetaDataTest.assertEquals((String)"Schemas missing ", (int)expected.length, (int)nextMatch);
    }

    private static void checkSchemasShape(ResultSet rs) throws SQLException {
        DatabaseMetaDataTest.assertMetaDataResultSet(rs, new String[]{"TABLE_SCHEM", "TABLE_CATALOG"}, new int[]{12, 12}, new boolean[]{false, true});
    }

    private ResultSet getDMDTables(DatabaseMetaData dmd, String catalog, String schema, String table, String[] tableTypes) throws SQLException, IOException {
        this.checkGetTablesODBC(catalog, schema, table, tableTypes);
        return dmd.getTables(catalog, schema, table, tableTypes);
    }

    public void testGetTablesReadOnly() throws SQLException, IOException {
        DatabaseMetaData dmd = this.getDMD();
        ResultSet rs = this.getDMDTables(dmd, null, null, null, null);
        this.checkTablesShape(rs);
        int allTableCount = JDBC.assertDrainResults(rs);
        DatabaseMetaDataTest.assertTrue((String)"getTables() on all was empty!", (allTableCount > 0 ? 1 : 0) != 0);
        rs = this.getDMDTables(dmd, "%", "%", "%", null);
        this.checkTablesShape(rs);
        DatabaseMetaDataTest.assertEquals((String)"Different counts from getTables", (int)allTableCount, (int)JDBC.assertDrainResults(rs));
        rs = this.getDMDTables(dmd, null, "NO_such_schema", null, null);
        this.checkTablesShape(rs);
        JDBC.assertEmpty(rs);
        rs = this.getDMDTables(dmd, null, "SQLJ", null, null);
        this.checkTablesShape(rs);
        JDBC.assertEmpty(rs);
        rs = this.getDMDTables(dmd, null, "SQLJ", "%", null);
        this.checkTablesShape(rs);
        JDBC.assertEmpty(rs);
        rs = this.getDMDTables(dmd, null, "SYS", "No_such_table", null);
        this.checkTablesShape(rs);
        JDBC.assertEmpty(rs);
        String[] userTableOnly = new String[]{"TABLE"};
        rs = this.getDMDTables(dmd, null, "SYS", null, userTableOnly);
        this.checkTablesShape(rs);
        JDBC.assertEmpty(rs);
        rs = this.getDMDTables(dmd, null, "SYS", "%", userTableOnly);
        this.checkTablesShape(rs);
        JDBC.assertEmpty(rs);
        String[] systemTableOnly = new String[]{"SYSTEM_TABLE"};
        rs = this.getDMDTables(dmd, null, "SYS", null, systemTableOnly);
        this.checkTablesShape(rs);
        int systemTableCount = JDBC.assertDrainResults(rs);
        DatabaseMetaDataTest.assertTrue((String)"getTables() on system tables was empty!", (systemTableCount > 0 ? 1 : 0) != 0);
        rs = this.getDMDTables(dmd, null, "SYS", "%", systemTableOnly);
        this.checkTablesShape(rs);
        DatabaseMetaDataTest.assertEquals((int)systemTableCount, (int)JDBC.assertDrainResults(rs));
        String[] viewOnly = new String[]{"VIEW"};
        rs = this.getDMDTables(dmd, null, "SYS", null, viewOnly);
        JDBC.assertEmpty(rs);
        rs = this.getDMDTables(dmd, null, "SYS", "%", viewOnly);
        JDBC.assertEmpty(rs);
        String[] allTables = new String[]{"SYNONYM", "SYSTEM TABLE", "TABLE", "VIEW"};
        rs = this.getDMDTables(dmd, null, null, null, allTables);
        this.checkTablesShape(rs);
        DatabaseMetaDataTest.assertEquals((String)"Different counts from getTables", (int)allTableCount, (int)JDBC.assertDrainResults(rs));
        rs = this.getDMDTables(dmd, "%", "%", "%", allTables);
        this.checkTablesShape(rs);
        DatabaseMetaDataTest.assertEquals((String)"Different counts from getTables", (int)allTableCount, (int)JDBC.assertDrainResults(rs));
    }

    public void testGetTablesModify() throws Exception {
        int pc;
        int totalTables = this.createTablesForTest(false);
        DatabaseMetaData dmd = this.getDMD();
        String[] userTableOnly = new String[]{"TABLE"};
        Object[] dbIDS = this.getSortedIdentifiers();
        ResultSet rs = this.getDMDTables(dmd, null, null, null, userTableOnly);
        this.checkTablesShape(rs);
        int rowPosition = 0;
        while (rs.next()) {
            boolean ourSchema;
            DatabaseMetaDataTest.assertEquals((String)"TABLE_CAT", (String)"", (String)rs.getString("TABLE_CAT"));
            String schema_ = rs.getString("TABLE_SCHEM");
            boolean bl = ourSchema = Arrays.binarySearch(dbIDS, schema_) >= 0;
            if (ourSchema) {
                DatabaseMetaDataTest.assertEquals((String)"TABLE_SCHEM", (String)dbIDS[rowPosition / dbIDS.length], (String)schema_);
                DatabaseMetaDataTest.assertEquals((String)"TABLE_NAME", (String)dbIDS[rowPosition % dbIDS.length], (String)rs.getString("TABLE_NAME"));
            }
            DatabaseMetaDataTest.assertEquals((String)"TABLE_TYPE", (String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            DatabaseMetaDataTest.assertEquals((String)"REMARKS", (String)"", (String)rs.getString("REMARKS"));
            DatabaseMetaDataTest.assertNull((String)"TYPE_CAT", (Object)rs.getString("TYPE_CAT"));
            DatabaseMetaDataTest.assertNull((String)"TYPE_SCHEM", (Object)rs.getString("TYPE_SCHEM"));
            DatabaseMetaDataTest.assertNull((String)"TYPE_NAME", (Object)rs.getString("TYPE_NAME"));
            DatabaseMetaDataTest.assertNull((String)"SELF_REFERENCING_COL_NAME", (Object)rs.getString("SELF_REFERENCING_COL_NAME"));
            DatabaseMetaDataTest.assertNull((String)"REF_GENERATION", (Object)rs.getString("REF_GENERATION"));
            if (!ourSchema) continue;
            ++rowPosition;
        }
        rs.close();
        DatabaseMetaDataTest.assertEquals((String)"getTables count for all user tables", (int)totalTables, (int)rowPosition);
        Random rand = new Random();
        for (Object schema_ : dbIDS) {
            pc = rand.nextInt(6);
            String schemaPattern = ((String)schema_).substring(0, pc + 2) + "%";
            rs = this.getDMDTables(dmd, null, schemaPattern, null, userTableOnly);
            this.checkTablesShape(rs);
            rowPosition = 0;
            while (rs.next()) {
                DatabaseMetaDataTest.assertEquals((String)"TABLE_SCHEM", (String)schema_, (String)rs.getString("TABLE_SCHEM"));
                DatabaseMetaDataTest.assertEquals((String)"TABLE_NAME", (String)dbIDS[rowPosition % dbIDS.length], (String)rs.getString("TABLE_NAME"));
                DatabaseMetaDataTest.assertEquals((String)"TABLE_TYPE", (String)"TABLE", (String)rs.getString("TABLE_TYPE"));
                ++rowPosition;
            }
            rs.close();
            DatabaseMetaDataTest.assertEquals((String)"getTables count schema pattern", (int)dbIDS.length, (int)rowPosition);
        }
        for (Object table : dbIDS) {
            pc = rand.nextInt(6);
            String tablePattern = ((String)table).substring(0, pc + 2) + "%";
            rs = this.getDMDTables(dmd, null, null, tablePattern, userTableOnly);
            this.checkTablesShape(rs);
            rowPosition = 0;
            while (rs.next()) {
                DatabaseMetaDataTest.assertEquals((String)"TABLE_SCHEM", (String)dbIDS[rowPosition % dbIDS.length], (String)rs.getString("TABLE_SCHEM"));
                DatabaseMetaDataTest.assertEquals((String)"TABLE_TYPE", (String)"TABLE", (String)rs.getString("TABLE_TYPE"));
                DatabaseMetaDataTest.assertEquals((String)"TABLE_NAME", (String)table, (String)rs.getString("TABLE_NAME"));
                ++rowPosition;
            }
            rs.close();
            DatabaseMetaDataTest.assertEquals((String)"getTables count schema pattern", (int)dbIDS.length, (int)rowPosition);
        }
    }

    private void checkGetTablesODBC(String catalog, String schema, String table, String[] tableTypes) throws SQLException, IOException {
        String tableTypesAsString = null;
        if (tableTypes != null) {
            int count = tableTypes.length;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(tableTypes[i]);
            }
            tableTypesAsString = sb.toString();
        }
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLTABLES(?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        cs.setString(1, catalog);
        cs.setString(2, schema);
        cs.setString(3, table);
        cs.setString(4, tableTypesAsString);
        cs.execute();
        ResultSet odbcrs = cs.getResultSet();
        DatabaseMetaDataTest.assertNotNull((Object)odbcrs);
        this.checkTablesShape(odbcrs);
        ResultSet dmdrs = this.getDMD().getTables(catalog, schema, table, tableTypes);
        JDBC.assertSameContents(odbcrs, dmdrs);
        cs.close();
    }

    private int createTablesForTest(boolean skipXML) throws Exception {
        Version dataVersion;
        this.getConnection().setAutoCommit(false);
        List<String> types = DatabaseMetaDataTest.getSQLTypes(this.getConnection());
        if (skipXML) {
            types.remove("XML");
        }
        if ((dataVersion = this.getDataVersion(this.getConnection())).compareTo(new Version(10, 7, 0, 0)) < 0) {
            types.remove("BOOLEAN");
        }
        int typeCount = types.size();
        this.createSchemasForTests();
        Statement s = this.createStatement();
        int columnCounter = 0;
        for (String IDS1 : IDS) {
            for (String IDS2 : IDS) {
                StringBuilder sb = new StringBuilder();
                sb.append("CREATE TABLE ");
                sb.append(IDS1);
                sb.append('.');
                sb.append(IDS2);
                sb.append(" (");
                for (int c = 1; c <= 5; ++c) {
                    boolean delimited;
                    String colName = IDS[columnCounter % IDS.length];
                    boolean bl = delimited = colName.charAt(colName.length() - 1) == '\"';
                    if (delimited) {
                        colName = colName.substring(0, colName.length() - 1);
                    }
                    sb.append(colName);
                    sb.append('_');
                    sb.append(c);
                    if (delimited) {
                        sb.append('\"');
                    }
                    sb.append(' ');
                    sb.append(types.get(columnCounter++ % typeCount));
                    if (c >= 5) continue;
                    sb.append(", ");
                }
                sb.append(")");
                s.execute(sb.toString());
            }
        }
        s.close();
        this.commit();
        return IDS.length * IDS.length;
    }

    public void testGetColumnsReadOnly() throws Exception {
        ResultSet[] rs = this.getColumns(null, null, null, null);
        for (int j = 0; j < 2; ++j) {
            this.checkColumnsShape(rs[j], j);
            this.crossCheckGetColumnsAndResultSetMetaData(rs[j], false, j);
        }
    }

    public void testGetColumnsModify() throws Exception {
        int totalTables = this.createTablesForTest(true);
        this.testGetColumnsReadOnly();
        Random rand = new Random();
        String[] dbIDS = this.getSortedIdentifiers();
        for (int i = 1; i < 20; ++i) {
            int j;
            int seenColumnCount = 0;
            String schemaPattern = this.getPattern(rand, dbIDS);
            String tableNamePattern = this.getPattern(rand, dbIDS);
            String columnNamePattern = this.getPattern(rand, dbIDS);
            ResultSet[] rs = this.getColumns(null, schemaPattern, tableNamePattern, columnNamePattern);
            for (j = 0; j < 2; ++j) {
                this.checkColumnsShape(rs[j], j);
                while (rs[j].next()) {
                    String schema_ = rs[j].getString("TABLE_SCHEM");
                    String table = rs[j].getString("TABLE_NAME");
                    String column = rs[j].getString("COLUMN_NAME");
                    this.assertMatchesPattern(schemaPattern, schema_);
                    this.assertMatchesPattern(tableNamePattern, table);
                    this.assertMatchesPattern(columnNamePattern, column);
                    ++seenColumnCount;
                }
                rs[j].close();
            }
            rs = this.getColumns(null, schemaPattern, tableNamePattern, columnNamePattern);
            for (j = 0; j < 2; ++j) {
                this.crossCheckGetColumnsAndResultSetMetaData(rs[j], true, j);
            }
            rs = this.getColumns(null, null, null, null);
            int appColumnCount = 0;
            for (int j2 = 0; j2 < 2; ++j2) {
                while (rs[j2].next()) {
                    String schema_ = rs[j2].getString("TABLE_SCHEM");
                    String table = rs[j2].getString("TABLE_NAME");
                    String column = rs[j2].getString("COLUMN_NAME");
                    if (!this.doesMatch(schemaPattern, 0, schema_, 0) || !this.doesMatch(tableNamePattern, 0, table, 0) || !this.doesMatch(columnNamePattern, 0, column, 0)) continue;
                    ++appColumnCount;
                }
                rs[j2].close();
            }
            DatabaseMetaDataTest.assertEquals((String)"Mismatched column count on getColumns() filtering", (int)seenColumnCount, (int)appColumnCount);
        }
    }

    private void assertMatchesPattern(String pattern, String result) {
        if (!this.doesMatch(pattern, 0, result, 0)) {
            DatabaseMetaDataTest.fail((String)("Bad pattern matching:" + pattern + " result:" + result));
        }
    }

    private boolean doesMatch(String pattern, int pp, String result, int rp) {
        while (pp != pattern.length() || rp != result.length()) {
            if (pp == pattern.length()) {
                return false;
            }
            char pc = pattern.charAt(pp);
            if (pc == '_') {
                if (rp == result.length()) {
                    return false;
                }
                ++pp;
                ++rp;
                continue;
            }
            if (pc == '%') {
                if (pp == pattern.length() - 1) {
                    return true;
                }
                for (int sp = rp; sp < result.length(); ++sp) {
                    if (!this.doesMatch(pattern, pp + 1, result, sp)) continue;
                    return true;
                }
                return false;
            }
            if (rp == result.length()) {
                return false;
            }
            if (pc != result.charAt(rp)) {
                return false;
            }
            ++pp;
            ++rp;
        }
        return true;
    }

    private String getPattern(Random rand, String[] dbIDS) {
        int y = rand.nextInt(100);
        if (y < 10) {
            return "%";
        }
        if (y < 30) {
            return dbIDS[rand.nextInt(dbIDS.length)];
        }
        String base = y < 40 ? "XxZZzXXZZZxxXxZz" : dbIDS[rand.nextInt(dbIDS.length)];
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < base.length()) {
            boolean inWild;
            int x = rand.nextInt(10);
            if (x < 5) {
                x = 0;
            }
            if (sb.length() == 0) {
                inWild = false;
            } else {
                char last = sb.charAt(sb.length() - 1);
                boolean bl = inWild = last == '_' || last == '%';
            }
            if (x == 0) {
                sb.append(base.charAt(i++));
                continue;
            }
            if (x == 5) {
                ++i;
                if (inWild) continue;
                sb.append('_');
                continue;
            }
            i += x - 5;
            if (inWild) continue;
            sb.append('%');
        }
        return sb.toString();
    }

    private void crossCheckGetColumnsAndResultSetMetaData(ResultSet rs, boolean partial, int odbc) throws Exception {
        Statement s = this.createStatement();
        while (rs.next()) {
            String schema_ = rs.getString("TABLE_SCHEM");
            String table = rs.getString("TABLE_NAME");
            ResultSet rst = s.executeQuery("SELECT * FROM " + JDBC.escape(schema_, table));
            ResultSetMetaData rsmdt = rst.getMetaData();
            for (int col = 1; col <= rsmdt.getColumnCount(); ++col) {
                if (!partial) {
                    if (col != 1) {
                        DatabaseMetaDataTest.assertTrue((boolean)rs.next());
                    }
                    DatabaseMetaDataTest.assertEquals((String)"ORDINAL_POSITION", (int)col, (int)rs.getInt("ORDINAL_POSITION"));
                }
                DatabaseMetaDataTest.assertEquals((String)"TABLE_CAT", (String)"", (String)rs.getString("TABLE_CAT"));
                DatabaseMetaDataTest.assertEquals((String)"TABLE_SCHEM", (String)schema_, (String)rs.getString("TABLE_SCHEM"));
                DatabaseMetaDataTest.assertEquals((String)"TABLE_NAME", (String)table, (String)rs.getString("TABLE_NAME"));
                this.crossCheckGetColumnRowAndResultSetMetaData(rs, rsmdt, odbc);
                if (partial) break;
            }
            rst.close();
        }
        rs.close();
        s.close();
    }

    public void crossCheckGetColumnRowAndResultSetMetaData(ResultSet rs, ResultSetMetaData rsmdt, int odbc) throws Exception {
        boolean isView;
        int col = rs.getInt("ORDINAL_POSITION");
        Version dataVersion = this.getDataVersion(this.getConnection());
        String catalogName = rs.getString("TABLE_CAT");
        String schemaName = rs.getString("TABLE_SCHEM");
        String tableName = rs.getString("TABLE_NAME");
        ResultSet views = rs.getStatement().getConnection().getMetaData().getTables(catalogName, schemaName, tableName, JDBC.GET_TABLES_VIEW);
        boolean bl = isView = JDBC.assertDrainResults(views) > 0;
        if (!isView) {
            DatabaseMetaDataTest.assertEquals((String)"RSMD.getCatalogName", (String)catalogName, (String)rsmdt.getCatalogName(col));
            DatabaseMetaDataTest.assertEquals((String)"RSMD.getSchemaName", (String)schemaName, (String)rsmdt.getSchemaName(col));
            DatabaseMetaDataTest.assertEquals((String)"RSMD.getTableName", (String)tableName, (String)rsmdt.getTableName(col));
        }
        DatabaseMetaDataTest.assertEquals((String)"COLUMN_NAME", (String)rsmdt.getColumnName(col), (String)rs.getString("COLUMN_NAME"));
        int dmdColumnType = rs.getInt("DATA_TYPE");
        if (dmdColumnType == 2000 && DatabaseMetaDataTest.usingDerbyNetClient() && dataVersion.compareTo(new Version(10, 6, 0, 0)) < 0) {
            DatabaseMetaDataTest.assertEquals((String)"DATA_TYPE", (int)-4, (int)rsmdt.getColumnType(col));
        } else if (dmdColumnType == -3 && DatabaseMetaDataTest.usingDerbyNetClient()) {
            DatabaseMetaDataTest.assertEquals((String)"DATA_TYPE", (int)-3, (int)rsmdt.getColumnType(col));
        } else if (dmdColumnType == -2 && DatabaseMetaDataTest.usingDerbyNetClient()) {
            DatabaseMetaDataTest.assertEquals((String)"DATA_TYPE", (int)-2, (int)rsmdt.getColumnType(col));
        } else if (dmdColumnType == 2 && DatabaseMetaDataTest.usingDerbyNetClient()) {
            DatabaseMetaDataTest.assertEquals((String)"DATA_TYPE", (int)3, (int)rsmdt.getColumnType(col));
            DatabaseMetaDataTest.assertEquals((String)"TYPE_NAME", (String)"DECIMAL", (String)rsmdt.getColumnTypeName(col));
            DatabaseMetaDataTest.assertEquals((String)"TYPE_NAME", (String)"NUMERIC", (String)rs.getString("TYPE_NAME"));
        } else {
            DatabaseMetaDataTest.assertEquals((String)"DATA_TYPE", (int)rsmdt.getColumnType(col), (int)rs.getInt("DATA_TYPE"));
            DatabaseMetaDataTest.assertEquals((String)"TYPE_NAME", (String)rsmdt.getColumnTypeName(col), (String)rs.getString("TYPE_NAME"));
        }
        if (odbc == 0) {
            DatabaseMetaDataTest.assertEquals((String)"BUFFER_LENGTH", (int)0, (int)rs.getInt("BUFFER_LENGTH"));
            DatabaseMetaDataTest.assertTrue((String)"BUFFER_LENGTH", (boolean)rs.wasNull());
        } else if (col == 0) {
            DatabaseMetaDataTest.assertEquals((String)"BUFFER_LENGTH", (int)0, (int)rs.getInt("BUFFER_LENGTH"));
        } else {
            DatabaseMetaDataTest.assertTrue((rs.getInt("BUFFER_LENGTH") != 0 ? 1 : 0) != 0);
        }
        DatabaseMetaDataTest.assertEquals((String)"NULLABLE", (int)rsmdt.isNullable(col), (int)rs.getInt("NULLABLE"));
        DatabaseMetaDataTest.assertEquals((String)"REMARKS", (String)"", (String)rs.getString("REMARKS"));
        if (odbc == 0) {
            DatabaseMetaDataTest.assertEquals((String)"SQL_DATA_TYPE", (int)0, (int)rs.getInt("SQL_DATA_TYPE"));
            DatabaseMetaDataTest.assertTrue((boolean)rs.wasNull());
            DatabaseMetaDataTest.assertEquals((String)"SQL_DATETIME_SUB", (int)0, (int)rs.getInt("SQL_DATETIME_SUB"));
            DatabaseMetaDataTest.assertTrue((boolean)rs.wasNull());
        } else if (dmdColumnType == 91) {
            DatabaseMetaDataTest.assertTrue((rs.getInt("SQL_DATA_TYPE") == 9 ? 1 : 0) != 0);
            DatabaseMetaDataTest.assertTrue((rs.getInt("SQL_DATETIME_SUB") == 1 ? 1 : 0) != 0);
        } else if (dmdColumnType == 92) {
            DatabaseMetaDataTest.assertTrue((rs.getInt("SQL_DATA_TYPE") == 9 ? 1 : 0) != 0);
            DatabaseMetaDataTest.assertTrue((rs.getInt("SQL_DATETIME_SUB") == 2 ? 1 : 0) != 0);
        } else if (dmdColumnType == 93) {
            DatabaseMetaDataTest.assertTrue((rs.getInt("SQL_DATA_TYPE") == 9 ? 1 : 0) != 0);
            DatabaseMetaDataTest.assertTrue((rs.getInt("SQL_DATETIME_SUB") == 3 ? 1 : 0) != 0);
        } else {
            DatabaseMetaDataTest.assertTrue((rs.getInt("SQL_DATA_TYPE") == dmdColumnType ? 1 : 0) != 0);
        }
        switch (rsmdt.isNullable(col)) {
            case 0: {
                DatabaseMetaDataTest.assertEquals((String)"IS_NULLABLE", (String)"NO", (String)rs.getString("IS_NULLABLE"));
                break;
            }
            case 1: {
                DatabaseMetaDataTest.assertEquals((String)"IS_NULLABLE", (String)"YES", (String)rs.getString("IS_NULLABLE"));
                break;
            }
            case 2: {
                DatabaseMetaDataTest.assertEquals((String)"IS_NULLABLE", (String)"", (String)rs.getString("IS_NULLABLE"));
                break;
            }
            default: {
                DatabaseMetaDataTest.fail((String)"invalid return from rsmdt.isNullable(col)");
            }
        }
        DatabaseMetaDataTest.assertNull((String)"SCOPE_CATALOG", (Object)rs.getString("SCOPE_CATALOG"));
        DatabaseMetaDataTest.assertNull((String)"SCOPE_CATLOG", (Object)rs.getString("SCOPE_CATLOG"));
        DatabaseMetaDataTest.assertNull((String)"SCOPE_SCHEMA", (Object)rs.getString("SCOPE_SCHEMA"));
        DatabaseMetaDataTest.assertNull((String)"SCOPE_TABLE", (Object)rs.getString("SCOPE_TABLE"));
        DatabaseMetaDataTest.assertEquals((String)"SOURCE_DATA_TYPE", (int)0, (int)rs.getShort("SOURCE_DATA_TYPE"));
        DatabaseMetaDataTest.assertTrue((boolean)rs.wasNull());
        DatabaseMetaDataTest.assertEquals((String)"IS_AUTOINCREMENT", (String)(rsmdt.isAutoIncrement(col) ? "YES" : "NO"), (String)rs.getString("IS_AUTOINCREMENT"));
        DatabaseMetaDataTest.assertFalse((boolean)rs.wasNull());
    }

    private ResultSet getColumnsODBC(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLCOLUMNS(?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        cs.setString(1, catalog);
        cs.setString(2, schemaPattern);
        cs.setString(3, tableNamePattern);
        cs.setString(4, columnNamePattern);
        cs.execute();
        return cs.getResultSet();
    }

    private ResultSet[] getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ResultSet[] rss = new ResultSet[2];
        DatabaseMetaData dmd = this.getDMD();
        rss[0] = dmd.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        rss[1] = this.getColumnsODBC(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        return rss;
    }

    public void testTableTypes() throws SQLException {
        DatabaseMetaData dmd = this.getDMD();
        ResultSet rs = dmd.getTableTypes();
        DatabaseMetaDataTest.assertMetaDataResultSet(rs, new String[]{"TABLE_TYPE"}, new int[]{12}, null);
        JDBC.assertFullResultSet(rs, (Object[][])new String[][]{{"SYNONYM"}, {"SYSTEM TABLE"}, {"TABLE"}, {"VIEW"}}, true);
        rs.close();
    }

    public void testGetTypeInfo() throws Exception {
        boolean booleanSupported;
        int BOOLEAN = 16;
        String[] JDBC_COLUMN_NAMES = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        int[] JDBC_COLUMN_TYPES = new int[]{12, 4, 4, 12, 12, 12, 5, BOOLEAN, 5, BOOLEAN, BOOLEAN, BOOLEAN, 12, 5, 5, 4, 4, 4};
        boolean[] JDBC_COLUMN_NULLABILITY = new boolean[]{false, false, true, true, true, true, false, false, false, true, false, true, true, true, true, true, true, true};
        JDBC_COLUMN_NULLABILITY[0] = true;
        ResultSet rs = this.getDMD().getTypeInfo();
        DatabaseMetaDataTest.assertMetaDataResultSet(rs, JDBC_COLUMN_NAMES, JDBC_COLUMN_TYPES, JDBC_COLUMN_NULLABILITY);
        ArrayList<Integer> supportedTypes = new ArrayList<Integer>(Arrays.asList(-5, -2, 2004, 16, 1, 2005, 91, 3, 8, 6, 4, -4, -1, 2, 7, 5, 92, 93, -3, 12, 2009, 2000));
        Version dataVersion = this.getDataVersion(this.getConnection());
        boolean bl = booleanSupported = dataVersion.compareTo(new Version(10, 7, 0, 0)) >= 0;
        if (!booleanSupported) {
            supportedTypes.remove((Object)16);
        }
        Collections.sort(supportedTypes);
        int offset = 0;
        while (rs.next()) {
            int maxScale;
            boolean autoIncrement;
            int searchable;
            String createParams;
            String typeName = rs.getString("TYPE_NAME");
            DatabaseMetaDataTest.assertNotNull((Object)typeName);
            int type = rs.getInt("DATA_TYPE");
            DatabaseMetaDataTest.assertFalse((boolean)rs.wasNull());
            if (!((Integer)supportedTypes.get(offset)).equals(type)) {
                DatabaseMetaDataTest.fail((String)("Unexpected type " + typeName));
            } else {
                ++offset;
            }
            int precision = -1;
            switch (type) {
                case 16: {
                    precision = 1;
                    break;
                }
                case -2: 
                case 1: {
                    precision = 254;
                    break;
                }
                case 2004: 
                case 2005: {
                    precision = Integer.MAX_VALUE;
                    break;
                }
                case 91: {
                    precision = 10;
                    break;
                }
                case 92: {
                    precision = 8;
                    break;
                }
                case 93: {
                    precision = 29;
                    break;
                }
                case 2: 
                case 3: {
                    precision = 31;
                    break;
                }
                case 6: 
                case 8: {
                    precision = 52;
                    break;
                }
                case 7: {
                    precision = 23;
                    break;
                }
                case -5: {
                    precision = 19;
                    break;
                }
                case 4: {
                    precision = 10;
                    break;
                }
                case 5: {
                    precision = 5;
                    break;
                }
                case -4: 
                case -1: {
                    precision = 32700;
                    break;
                }
                case -3: {
                    precision = 32672;
                    break;
                }
                case 12: {
                    precision = 32672;
                    break;
                }
                case 2000: 
                case 2009: {
                    precision = 0;
                }
            }
            DatabaseMetaDataTest.assertEquals((String)("PRECISION " + typeName), (int)precision, (int)rs.getInt("PRECISION"));
            if (typeName.equals("XML") || typeName.equals("OBJECT")) {
                DatabaseMetaDataTest.assertTrue((boolean)rs.wasNull());
            } else {
                DatabaseMetaDataTest.assertFalse((boolean)rs.wasNull());
            }
            switch (type) {
                case -3: 
                case -2: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    createParams = "length";
                    break;
                }
                case 2: 
                case 3: {
                    createParams = "precision,scale";
                    break;
                }
                case 6: {
                    createParams = "precision";
                    break;
                }
                default: {
                    createParams = null;
                }
            }
            DatabaseMetaDataTest.assertEquals((String)("CREATE_PARAMS " + typeName), (String)createParams, (String)rs.getString("CREATE_PARAMS"));
            DatabaseMetaDataTest.assertEquals((String)("NULLABLE " + typeName), (int)1, (int)rs.getInt("NULLABLE"));
            DatabaseMetaDataTest.assertFalse((boolean)rs.wasNull());
            switch (type) {
                case -4: {
                    searchable = 0;
                    break;
                }
                case -1: {
                    searchable = 1;
                    break;
                }
                case 2004: {
                    searchable = 0;
                    break;
                }
                case 2005: {
                    searchable = 1;
                    break;
                }
                case 1: 
                case 12: {
                    searchable = 3;
                    break;
                }
                case 2009: {
                    searchable = 0;
                    break;
                }
                default: {
                    searchable = 2;
                }
            }
            DatabaseMetaDataTest.assertEquals((String)("SEARCHABLE " + typeName), (int)searchable, (int)rs.getInt("SEARCHABLE"));
            boolean fixedScale = type == 3 || type == 2;
            DatabaseMetaDataTest.assertEquals((String)("FIXED_PREC_SCALE " + typeName), (boolean)fixedScale, (boolean)rs.getBoolean("FIXED_PREC_SCALE"));
            DatabaseMetaDataTest.assertFalse((boolean)rs.wasNull());
            switch (type) {
                case -5: 
                case 4: 
                case 5: {
                    autoIncrement = true;
                    break;
                }
                default: {
                    autoIncrement = false;
                }
            }
            DatabaseMetaDataTest.assertEquals((String)("AUTO_INCREMENT " + typeName), (boolean)autoIncrement, (boolean)rs.getBoolean("AUTO_INCREMENT"));
            DatabaseMetaDataTest.assertEquals((String)("LOCAL_TYPE_NAME " + typeName), (String)typeName, (String)rs.getString("LOCAL_TYPE_NAME"));
            boolean hasScale = true;
            switch (type) {
                case 2: 
                case 3: {
                    maxScale = 31;
                    break;
                }
                case 93: {
                    maxScale = 9;
                    break;
                }
                case -5: 
                case 4: 
                case 5: 
                case 91: 
                case 92: {
                    maxScale = 0;
                    break;
                }
                default: {
                    maxScale = 0;
                    hasScale = false;
                }
            }
            DatabaseMetaDataTest.assertEquals((String)("MINIMUM_SCALE " + typeName), (int)0, (int)rs.getInt("MINIMUM_SCALE"));
            DatabaseMetaDataTest.assertEquals((String)("MINIMUM_SCALE (wasNull) " + typeName), (!hasScale ? 1 : 0) != 0, (boolean)rs.wasNull());
            DatabaseMetaDataTest.assertEquals((String)("MAXIMUM_SCALE " + typeName), (int)maxScale, (int)rs.getInt("MAXIMUM_SCALE"));
            DatabaseMetaDataTest.assertEquals((String)("MAXIMUM_SCALE (wasNull)" + typeName), (!hasScale ? 1 : 0) != 0, (boolean)rs.wasNull());
            DatabaseMetaDataTest.assertEquals((String)("SQL_DATA_TYPE " + typeName), (int)0, (int)rs.getInt("SQL_DATA_TYPE"));
            DatabaseMetaDataTest.assertTrue((boolean)rs.wasNull());
            DatabaseMetaDataTest.assertEquals((String)("SQL_DATETIME_SUB " + typeName), (int)0, (int)rs.getInt("SQL_DATETIME_SUB"));
            DatabaseMetaDataTest.assertTrue((boolean)rs.wasNull());
        }
        rs.close();
        String[] ODBC_COLUMN_NAMES = new String[19];
        System.arraycopy(JDBC_COLUMN_NAMES, 0, ODBC_COLUMN_NAMES, 0, JDBC_COLUMN_NAMES.length);
        ODBC_COLUMN_NAMES[2] = "COLUMN_SIZE";
        ODBC_COLUMN_NAMES[11] = "AUTO_UNIQUE_VAL";
        ODBC_COLUMN_NAMES[18] = "INTERVAL_PRECISION";
        int[] ODBC_COLUMN_TYPES = new int[ODBC_COLUMN_NAMES.length];
        System.arraycopy(JDBC_COLUMN_TYPES, 0, ODBC_COLUMN_TYPES, 0, JDBC_COLUMN_TYPES.length);
        ODBC_COLUMN_TYPES[1] = 5;
        ODBC_COLUMN_TYPES[7] = 5;
        ODBC_COLUMN_TYPES[9] = 5;
        ODBC_COLUMN_TYPES[10] = 5;
        ODBC_COLUMN_TYPES[11] = 5;
        ODBC_COLUMN_TYPES[15] = 5;
        ODBC_COLUMN_TYPES[16] = 5;
        ODBC_COLUMN_TYPES[18] = 5;
        boolean[] ODBC_COLUMN_NULLABILITY = new boolean[]{true, false, true, true, true, true, false, false, false, true, false, true, true, true, true, false, true, true, true};
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLGETTYPEINFO (0, 'DATATYPE=''ODBC''')");
        cs.execute();
        ResultSet odbcrs = cs.getResultSet();
        DatabaseMetaDataTest.assertNotNull((Object)odbcrs);
        DatabaseMetaDataTest.assertMetaDataResultSet(odbcrs, ODBC_COLUMN_NAMES, ODBC_COLUMN_TYPES, ODBC_COLUMN_NULLABILITY);
        odbcrs.close();
        cs.close();
    }

    private void checkColumnsShape(ResultSet rs, int odbc) throws SQLException {
        int[] columnTypes = new int[]{12, 12, 12, 12, 4, 12, 4, 4, 4, 4, 4, 12, 12, 4, 4, 4, 4, 12, 12, 12, 12, 5, 12, 12, 12};
        boolean[] nullability = new boolean[]{false, false, false, false, true, true, true, true, true, true, true, false, true, true, true, true, false, false, true, true, true, true, false, false, true};
        if (odbc == 1) {
            columnTypes[4] = 5;
            columnTypes[8] = 5;
            columnTypes[9] = 5;
            columnTypes[10] = 5;
            columnTypes[13] = 5;
            columnTypes[14] = 5;
        }
        DatabaseMetaDataTest.assertMetaDataResultSet(rs, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN", "SCOPE_CATLOG"}, columnTypes, nullability);
    }

    private void checkTablesShape(ResultSet rs) throws SQLException {
        DatabaseMetaDataTest.assertMetaDataResultSet(rs, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12}, new boolean[]{false, false, false, true, false, true, true, true, true, true});
    }

    private void checkCatalogsShape(ResultSet rs) throws SQLException {
        DatabaseMetaDataTest.assertMetaDataResultSet(rs, new String[]{"TABLE_CAT"}, new int[]{1}, new boolean[]{false});
    }

    private static void checkVersionColumnsShape(ResultSet[] rs) throws SQLException {
        String[] columnNames = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] columnTypes = new int[]{5, 12, 4, 12, 4, 4, 5, 5};
        DatabaseMetaDataTest.assertMetaDataResultSet(rs[0], columnNames, columnTypes, null);
        columnTypes[2] = 5;
        DatabaseMetaDataTest.assertMetaDataResultSet(rs[1], columnNames, columnTypes, null);
    }

    public static void assertMetaDataResultSet(ResultSet rs, String[] columnNames, int[] columnTypes, boolean[] nullability) throws SQLException {
        DatabaseMetaDataTest.assertEquals((int)1003, (int)rs.getType());
        DatabaseMetaDataTest.assertEquals((int)1007, (int)rs.getConcurrency());
        if (columnNames != null) {
            JDBC.assertDatabaseMetaDataColumns(rs, nullability, columnTypes, columnNames);
        }
    }

    public void testNumericFunctions() throws SQLException {
        this.escapedFunctions(NUMERIC_FUNCTIONS, this.getDMD().getNumericFunctions());
    }

    public void testStringFunctions() throws SQLException {
        this.escapedFunctions(STRING_FUNCTIONS, this.getDMD().getStringFunctions());
    }

    public void testTimeDataFunctions() throws SQLException {
        this.escapedFunctions(TIMEDATE_FUNCTIONS, this.getDMD().getTimeDateFunctions());
    }

    public void testSystemFunctions() throws SQLException {
        this.escapedFunctions(SYSTEM_FUNCTIONS, this.getDMD().getSystemFunctions());
    }

    private void escapedFunctions(String[][] specList, String metaDataList) throws SQLException {
        boolean[] seenFunction = new boolean[specList.length];
        StringTokenizer st = new StringTokenizer(metaDataList, ",");
        while (st.hasMoreTokens()) {
            String function = st.nextToken();
            boolean isSpecFunction = false;
            for (int f = 0; f < specList.length; ++f) {
                String[] specDetails = specList[f];
                if (!function.equals(specDetails[0])) continue;
                if (seenFunction[f]) {
                    DatabaseMetaDataTest.fail((String)("Function in list twice: " + function));
                }
                seenFunction[f] = true;
                isSpecFunction = true;
                this.executeEscaped(specDetails);
                break;
            }
            if (isSpecFunction) continue;
            DatabaseMetaDataTest.fail((String)("Non-JDBC spec function in list: " + function));
        }
        for (int f = 0; f < specList.length; ++f) {
            String[] specDetails;
            if (seenFunction[f] || "CHAR".equals((specDetails = specList[f])[0])) continue;
            try {
                this.executeEscaped(specDetails);
                DatabaseMetaDataTest.fail((String)("function works but not declared in list: " + specDetails[0]));
                continue;
            }
            catch (SQLException e) {
                DatabaseMetaDataTest.assertSQLState("42X01", e);
            }
        }
    }

    private void executeEscaped(String[] specDetails) throws SQLException {
        String sql = "VALUES { fn " + specDetails[0] + "(";
        for (int p = 0; p < specDetails.length - 1; ++p) {
            if (p != 0) {
                sql = sql + ", ";
            }
            sql = sql + specDetails[p + 1];
        }
        sql = sql + ") }";
        PreparedStatement ps = this.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        JDBC.assertDrainResults(rs);
        rs.close();
        ps.close();
    }

    public static List<String> getSQLTypes(Connection conn) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        Random rand = new Random();
        ResultSet rs = conn.getMetaData().getTypeInfo();
        while (rs.next()) {
            String typeName = rs.getString("TYPE_NAME");
            if ("OBJECT".equals(typeName)) continue;
            String createParams = rs.getString("CREATE_PARAMS");
            if (createParams == null) {
                list.add(typeName);
                continue;
            }
            if (createParams.contains("length")) {
                int maxLength = rs.getInt("PRECISION");
                int length = rand.nextInt(maxLength) + 1;
                int paren = typeName.indexOf(40);
                if (paren == -1) {
                    list.add(typeName + "(" + length + ")");
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(typeName.substring(0, paren + 1));
                sb.append(length);
                sb.append(typeName.substring(paren + 1));
                list.add(sb.toString());
                continue;
            }
            if (createParams.contains("scale")) {
                int maxPrecision = rs.getInt("PRECISION");
                StringBuilder sb = new StringBuilder();
                int precision = rand.nextInt(maxPrecision) + 1;
                sb.append(typeName);
                sb.append("(");
                sb.append(precision);
                if (rand.nextInt(100) < 95) {
                    sb.append(",");
                    sb.append(rand.nextInt(precision + 1));
                }
                sb.append(")");
                list.add(sb.toString());
                continue;
            }
            if (createParams.contains("precision")) {
                list.add(typeName);
                continue;
            }
            DatabaseMetaDataTest.fail((String)("unknown how to generate valid type for " + typeName + " CREATE_PARAMS=" + createParams));
        }
        return list;
    }

    public static int getJDBCType(String type) {
        if ("SMALLINT".equals(type)) {
            return 5;
        }
        if ("INTEGER".equals(type) || "INT".equals(type)) {
            return 4;
        }
        if ("BIGINT".equals(type)) {
            return -5;
        }
        if (type.equals("FLOAT") || type.startsWith("FLOAT(")) {
            return 6;
        }
        if (type.equals("REAL")) {
            return 7;
        }
        if ("DOUBLE".equals(type) || "DOUBLE PRECISION".equals(type)) {
            return 8;
        }
        if ("DATE".equals(type)) {
            return 91;
        }
        if ("TIME".equals(type)) {
            return 92;
        }
        if ("TIMESTAMP".equals(type)) {
            return 93;
        }
        if (type.equals("DECIMAL") || type.startsWith("DECIMAL(")) {
            return 3;
        }
        if (type.equals("NUMERIC") || type.startsWith("NUMERIC(")) {
            return 2;
        }
        if (type.endsWith("FOR BIT DATA")) {
            if (type.startsWith("CHAR")) {
                return -2;
            }
            if (type.startsWith("CHARACTER")) {
                return -2;
            }
            if (type.startsWith("VARCHAR")) {
                return -3;
            }
            if (type.startsWith("CHARACTER VARYING")) {
                return -3;
            }
            if (type.startsWith("CHAR VARYING")) {
                return -3;
            }
        }
        if ("LONG VARCHAR".equals(type)) {
            return -1;
        }
        if ("LONG VARCHAR FOR BIT DATA".equals(type)) {
            return -4;
        }
        if (type.equals("CHAR") || type.startsWith("CHAR(")) {
            return 1;
        }
        if (type.equals("CHARACTER") || type.startsWith("CHARACTER(")) {
            return 1;
        }
        if (type.equals("VARCHAR") || type.startsWith("VARCHAR(")) {
            return 12;
        }
        if (type.equals("CHARACTER VARYING") || type.startsWith("CHARACTER VARYING(")) {
            return 12;
        }
        if (type.equals("CHAR VARYING") || type.startsWith("CHAR VARYING(")) {
            return 12;
        }
        if (type.equals("BLOB") || type.startsWith("BLOB(")) {
            return 2004;
        }
        if (type.equals("BINARY LARGE OBJECT") || type.startsWith("BINARY LARGE OBJECT(")) {
            return 2004;
        }
        if (type.equals("CLOB") || type.startsWith("CLOB(")) {
            return 2005;
        }
        if (type.equals("CHARACTER LARGE OBJECT") || type.startsWith("CHARACTER LARGE OBJECT(")) {
            return 2005;
        }
        if ("XML".equals(type)) {
            return 2009;
        }
        if (type.equals("BOOLEAN")) {
            return 16;
        }
        DatabaseMetaDataTest.fail((String)("Unexpected SQL type: " + type));
        return 0;
    }

    public static int getPrecision(int jdbcType, String type) {
        switch (jdbcType) {
            case -3: 
            case -2: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                int lp = type.indexOf(40);
                int rp = type.indexOf(41);
                int precision = Integer.parseInt(type.substring(lp + 1, rp));
                return precision;
            }
        }
        return 0;
    }

    public void testGetXXportedKeysODBC() throws SQLException, IOException {
        Statement st = this.createStatement();
        st.execute("create table pkt1 (i int not null, c char(1) not null)");
        st.execute("create table pkt2 (i int not null, c char(1) not null)");
        st.execute("create table pkt3 (i int not null, c char(1) not null)");
        st.execute("alter table pkt1 add constraint pk1 primary key (i)");
        st.execute("alter table pkt2 add constraint pk2 primary key (c)");
        st.execute("alter table pkt3 add constraint pk3 primary key (i, c)");
        st.execute("create table fkt1 (fi int, fc char(1), vc varchar(80))");
        st.execute("create table fkt2 (fi int, fc char(1), vc varchar(80))");
        st.execute("alter table fkt1 add constraint fk1 foreign key (fi) references pkt1(i)");
        st.execute("alter table fkt1 add constraint fk2 foreign key (fc) references pkt2(c)");
        st.execute("alter table fkt2 add constraint fk3 foreign key (fi, fc) references pkt3(i, c)");
        this.checkODBCKeys(null, this.schema, null, null, null, null);
        this.checkODBCKeys(null, this.schema, null, null, null, "FKT1");
        this.checkODBCKeys(null, this.schema, "PKT1", null, null, null);
        this.checkODBCKeys(null, this.schema, "PKT1", null, null, "FKT1");
        this.checkODBCKeys(null, this.schema, null, null, null, "FKT2");
        this.checkODBCKeys(null, this.schema, "PKT2", null, null, null);
        this.checkODBCKeys(null, this.schema, "PKT2", null, null, "FKT2");
        this.checkODBCKeys(null, this.schema, null, null, null, "FKT3");
        this.checkODBCKeys(null, this.schema, "PKT3", null, null, null);
        this.checkODBCKeys(null, this.schema, "PKT3", null, null, "FKT3");
        this.checkODBCKeys(null, this.schema, "FKT1", null, null, null);
        this.checkODBCKeys(null, this.schema, null, null, null, "PKT3");
        this.checkODBCKeys(null, this.schema, "FKT1", null, null, "PKT1");
        this.checkODBCKeys(null, this.schema, "FKT2", null, null, "PKT2");
        this.checkODBCKeys(null, this.schema, "FKT3", null, null, "PKT3");
        this.checkODBCKeys(null, this.schema, "PKT1", null, null, "FKT2");
        this.checkODBCKeys(null, this.schema, "PKT1", null, null, "FKT3");
        this.checkODBCKeys(null, this.schema, "PKT2", null, null, "FKT3");
        this.checkODBCKeys(null, this.schema, "FKT1", null, null, "PKT2");
        this.checkODBCKeys(null, this.schema, "FKT1", null, null, "PKT3");
        this.checkODBCKeys(null, this.schema, "FKT2", null, null, "PKT3");
        st.execute("drop table fkt1");
        st.execute("drop table fkt2");
        st.execute("drop table pkt1");
        st.execute("drop table pkt2");
        st.execute("drop table pkt3");
        st.close();
    }

    private void checkODBCKeys(String pCatalog, String pSchema, String pTable, String fCatalog, String fSchema, String fTable) throws SQLException, IOException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLFOREIGNKEYS(?, ?, ?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        cs.setString(1, pCatalog);
        cs.setString(2, pSchema);
        cs.setString(3, pTable);
        cs.setString(4, fCatalog);
        cs.setString(5, fSchema);
        cs.setString(6, fTable);
        cs.execute();
        ResultSet odbcrs = cs.getResultSet();
        DatabaseMetaDataTest.assertNotNull((Object)odbcrs);
        this.checkODBCKeysShape(odbcrs);
        ResultSet dmdrs = null;
        if (pTable != null && fTable == null) {
            dmdrs = this.getDMD().getExportedKeys(pCatalog, pSchema, pTable);
        } else if (pTable == null && fTable != null) {
            dmdrs = this.getDMD().getImportedKeys(fCatalog, fSchema, fTable);
        } else if (pTable != null) {
            dmdrs = this.getDMD().getCrossReference(pCatalog, pSchema, pTable, fCatalog, fSchema, fTable);
        } else {
            JDBC.assertFullResultSet(odbcrs, new String[][]{{"", this.schema, "PKT1", "I", "", this.schema, "FKT1", "FI", "1", "3", "3", "FK1", "PK1", "7"}, {"", this.schema, "PKT2", "C", "", this.schema, "FKT1", "FC", "1", "3", "3", "FK2", "PK2", "7"}, {"", this.schema, "PKT3", "I", "", this.schema, "FKT2", "FI", "1", "3", "3", "FK3", "PK3", "7"}, {"", this.schema, "PKT3", "C", "", this.schema, "FKT2", "FC", "2", "3", "3", "FK3", "PK3", "7"}});
            try {
                this.getDMD().getCrossReference(pCatalog, pSchema, pTable, fCatalog, fSchema, fTable);
                DatabaseMetaDataTest.fail((String)"Expected error from call to DMD.getCrossReference() with NULL primary and foreign key tables.");
            }
            catch (SQLException se) {
                DatabaseMetaDataTest.assertSQLState(DatabaseMetaDataTest.usingEmbedded() ? "XJ103" : "XJ110", se);
            }
        }
        if (dmdrs != null) {
            JDBC.assertSameContents(odbcrs, dmdrs);
        }
        cs.close();
    }

    private void checkODBCKeysShape(ResultSet rs) throws SQLException {
        DatabaseMetaDataTest.assertMetaDataResultSet(rs, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5}, new boolean[]{false, false, false, false, false, false, false, false, true, true, true, false, false, true});
    }

    public void testGetBestRowIdentifier() throws SQLException {
        Statement st = this.createStatement();
        st.execute("create table brit1 (i int not null primary key, j int)");
        st.execute("create table brit2 (i int not null unique, j int)");
        st.execute("create table brit3 (i int not null unique, j int not null unique)");
        st.execute("create table brit4 (i int, j int)");
        st.execute("create unique index brit4i on brit4(i)");
        st.execute("create table brit5 (i int, j int)");
        st.execute("create table brit6 (i int not null unique, j int not null primary key)");
        st.execute("create table brit7 (i int not null, j int not null primary key)");
        st.execute("create unique index brit7i on brit7(i)");
        st.execute("create table brit8 (i int not null, j int not null unique)");
        st.execute("create unique index brit8i on brit8(i)");
        st.execute("create table brit9 (i int, j int)");
        st.execute("create index brit9i on brit9(i)");
        st.execute("create table brit10 (i int unique not null , j int not null, primary key (i,j))");
        st.execute("create table brit11 (i int not null, j int not null, primary key (i,j))");
        st.execute("create unique index brit11i on brit11(i)");
        st.execute("create table brit12 (i int not null, j int not null, unique (i,j))");
        st.execute("create unique index brit12i on brit12(i)");
        st.execute("create table brit13 (i int not null, j int)");
        st.execute("create table brit14 (i int not null unique, j int not null, k int, unique (i,j))");
        st.execute("create table brit15 (i int not null, j int not null, k int)");
        st.execute("create unique index brit15ij on brit15(i,j)");
        st.execute("create unique index brit15i on brit15(i)");
        st.execute("create table brit16 (i int not null primary key, j int)");
        st.execute("create table brit17 (i int not null default 10, s smallint not null, c30 char(30) not null, vc10 varchar(10) not null default 'asdf', constraint PRIMKEY primary key(vc10, i), constraint UNIQUEKEY unique(c30, s), ai bigint generated always as identity (start with -10, increment by 2001))");
        st.execute("create unique index brit17i on brit17(s, i)");
        st.execute("create index brit17ij on brit17(s)");
        this.getConnection().setAutoCommit(false);
        String[][] expRSI = new String[][]{{"2", "I", "4", "INTEGER", "4", null, "10", "1"}};
        String[][] expRSJ = new String[][]{{"2", "J", "4", "INTEGER", "4", null, "10", "1"}};
        String[][] expRSIJ = new String[][]{{"2", "I", "4", "INTEGER", "4", null, "10", "1"}, {"2", "J", "4", "INTEGER", "4", null, "10", "1"}};
        ResultSet[] rs = this.getBestRowIdentifier(null, this.schema, "BRIT1", 0, true);
        this.verifyBRIResults(rs, expRSI);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT2", 0, true);
        this.verifyBRIResults(rs, expRSI);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT3", 0, true);
        this.verifyBRIResults(rs, expRSI);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT4", 0, true);
        this.verifyBRIResults(rs, expRSI);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT5", 0, true);
        this.verifyBRIResults(rs, expRSIJ);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT6", 0, true);
        this.verifyBRIResults(rs, expRSJ);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT7", 0, true);
        this.verifyBRIResults(rs, expRSJ);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT8", 0, true);
        this.verifyBRIResults(rs, expRSJ);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT9", 0, true);
        this.verifyBRIResults(rs, expRSIJ);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT10", 0, true);
        this.verifyBRIResults(rs, expRSIJ);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT11", 0, true);
        this.verifyBRIResults(rs, expRSIJ);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT12", 0, true);
        this.verifyBRIResults(rs, expRSIJ);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT13", 0, false);
        this.verifyBRIResults(rs, expRSI);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT13", 0, true);
        this.verifyBRIResults(rs, expRSIJ);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT14", 0, true);
        this.verifyBRIResults(rs, expRSI);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT15", 0, true);
        this.verifyBRIResults(rs, expRSI);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT16", 1, true);
        this.verifyBRIResults(rs, expRSI);
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT16", 2, true);
        this.verifyBRIResults(rs, expRSI);
        try {
            rs = this.getBestRowIdentifier(null, this.schema, "BRIT16", -1, true);
        }
        catch (SQLException sqle) {
            DatabaseMetaDataTest.assertSQLState("42XAT", sqle);
        }
        try {
            rs = this.getBestRowIdentifier(null, this.schema, "BRIT16", 3, true);
        }
        catch (SQLException sqle) {
            DatabaseMetaDataTest.assertSQLState("42XAT", sqle);
        }
        rs = this.getBestRowIdentifier(null, this.schema, "BRIT17", 0, true);
        Object[][] expRS = new String[][]{{"2", "I", "4", "INTEGER", "4", null, "10", "1"}, {"2", "VC10", "12", "VARCHAR", "10", null, null, "1"}};
        JDBC.assertFullResultSet(rs[0], expRS, true);
        expRS[0][5] = "4";
        expRS[1][5] = "20";
        JDBC.assertFullResultSet(rs[1], expRS, true);
        try {
            this.getBestRowIdentifier(null, this.schema, null, 0, true);
        }
        catch (SQLException sqle) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sqle);
        }
        rs = this.getBestRowIdentifier(null, "SYS", "SYSTABLES", 0, true);
        expRS = new String[][]{{"2", "TABLEID", "1", "CHAR", "36", null, null, "1"}};
        JDBC.assertFullResultSet(rs[0], expRS, true);
        expRS[0][5] = "72";
        JDBC.assertFullResultSet(rs[1], expRS, true);
        this.getConnection().setAutoCommit(true);
        st.execute("drop table brit1");
        st.execute("drop table brit2");
        st.execute("drop table brit3");
        st.execute("drop index brit4i");
        st.execute("drop table brit4");
        st.execute("drop table brit5");
        st.execute("drop table brit6");
        st.execute("drop index brit7i");
        st.execute("drop table brit7");
        st.execute("drop index brit8i");
        st.execute("drop table brit8");
        st.execute("drop index brit9i");
        st.execute("drop table brit9");
        st.execute("drop table brit10");
        st.execute("drop index brit11i");
        st.execute("drop table brit11");
        st.execute("drop index brit12i");
        st.execute("drop table brit12");
        st.execute("drop table brit13");
        st.execute("drop table brit14");
        st.execute("drop index brit15i");
        st.execute("drop index brit15ij");
        st.execute("drop table brit15");
        st.execute("drop table brit16");
        st.execute("drop index brit17i");
        st.execute("drop index brit17ij");
        st.execute("drop table brit17");
        st.close();
    }

    private ResultSet getBestRowIdentifierODBC(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLSPECIALCOLUMNS(1, ?, ?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        cs.setString(1, catalog);
        cs.setString(2, schema);
        cs.setString(3, table);
        cs.setInt(4, scope);
        cs.setBoolean(5, nullable);
        cs.execute();
        return cs.getResultSet();
    }

    private ResultSet[] getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        ResultSet[] rss = new ResultSet[2];
        DatabaseMetaData dmd = this.getDMD();
        rss[0] = dmd.getBestRowIdentifier(catalog, schema, table, scope, nullable);
        rss[1] = this.getBestRowIdentifierODBC(catalog, schema, table, scope, nullable);
        String[] columnNames = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] columnTypes = new int[]{5, 12, 4, 12, 4, 4, 5, 5};
        int[] odbcColumnTypes = new int[]{5, 12, 5, 12, 4, 4, 5, 5};
        boolean[] nullability = new boolean[]{true, false, true, true, true, true, true, true};
        if (scope != 0 && scope != 1 && scope != 2) {
            nullability = new boolean[]{false, false, false, false, false, false, false, false};
            odbcColumnTypes = columnTypes;
        }
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[0], columnNames, columnTypes, nullability);
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[1], columnNames, odbcColumnTypes, nullability);
        return rss;
    }

    public void verifyBRIResults(ResultSet[] rss, String[][] expRS) throws SQLException {
        JDBC.assertFullResultSet(rss[0], (Object[][])expRS, true);
        for (String[] expRS1 : expRS) {
            expRS1[5] = "4";
        }
        JDBC.assertFullResultSet(rss[1], (Object[][])expRS, true);
        for (String[] expRS1 : expRS) {
            expRS1[5] = null;
        }
    }

    public void testGetColumnPrivileges() throws SQLException {
        try {
            this.getColumnPrivileges(null, null, null, null);
            DatabaseMetaDataTest.fail((String)"expected error XJ103");
        }
        catch (SQLException sqle) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sqle);
        }
        ResultSet[] rs = this.getColumnPrivileges(null, null, "", null);
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
        rs = this.getColumnPrivileges("", "", "", "");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
        rs = this.getColumnPrivileges("%", "%", "%", "%");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
        rs = this.getColumnPrivileges(null, "SYS", "SYSTABLES", "TABLEID");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
    }

    private ResultSet getColumnPrivilegesODBC(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLCOLPRIVILEGES(?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        cs.setString(1, catalog);
        cs.setString(2, schema);
        cs.setString(3, table);
        cs.setString(4, columnNamePattern);
        cs.execute();
        return cs.getResultSet();
    }

    private ResultSet[] getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        ResultSet[] rss = new ResultSet[2];
        DatabaseMetaData dmd = this.getDMD();
        rss[0] = dmd.getColumnPrivileges(catalog, schema, table, columnNamePattern);
        rss[1] = this.getColumnPrivilegesODBC(catalog, schema, table, columnNamePattern);
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] columnTypes = new int[]{12, 12, 12, 12, 12, 12, 12, 12};
        boolean[] nullability = new boolean[]{false, false, false, false, false, false, false, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[0], columnNames, columnTypes, nullability);
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[1], columnNames, columnTypes, nullability);
        return rss;
    }

    public void testGetTablePrivileges() throws SQLException {
        ResultSet[] rs = this.getTablePrivileges(null, null, null);
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
        rs = this.getTablePrivileges("", "", "");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
        rs = this.getTablePrivileges("%", "%", "%");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
        rs = this.getTablePrivileges(null, "SYS", "SYSTABLES");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
    }

    private ResultSet getTablePrivilegesODBC(String catalog, String schema, String tableNamePattern) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLTABLEPRIVILEGES(?, ?, ?, 'DATATYPE=''ODBC''')");
        cs.setString(1, catalog);
        cs.setString(2, schema);
        cs.setString(3, tableNamePattern);
        cs.execute();
        return cs.getResultSet();
    }

    private ResultSet[] getTablePrivileges(String catalog, String schema, String tableNamePattern) throws SQLException {
        ResultSet[] rss = new ResultSet[2];
        DatabaseMetaData dmd = this.getDMD();
        rss[0] = dmd.getTablePrivileges(catalog, schema, tableNamePattern);
        rss[1] = this.getTablePrivilegesODBC(catalog, schema, tableNamePattern);
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] columnTypes = new int[]{12, 12, 12, 12, 12, 12, 12};
        boolean[] nullability = new boolean[]{false, false, false, false, false, false, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[0], columnNames, columnTypes, nullability);
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[1], columnNames, columnTypes, nullability);
        return rss;
    }

    public void testGetIndexInfo() throws SQLException {
        try {
            this.getIndexInfo(null, null, null, true, true);
            DatabaseMetaDataTest.fail((String)"expected error XJ103");
        }
        catch (SQLException sqle) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sqle);
        }
        ResultSet[] rss = this.getIndexInfo("", "SYS", "SYSCOLUMNS", true, false);
        String[][] expRS = new String[][]{{"", "SYS", "SYSCOLUMNS", "false", "", "SYSCOLUMNS_INDEX1", "3", "1", "REFERENCEID", "A", null, null, null}, {"", "SYS", "SYSCOLUMNS", "false", "", "SYSCOLUMNS_INDEX1", "3", "2", "COLUMNNAME", "A", null, null, null}};
        this.assertFullResultSet(rss, expRS, true);
        rss = this.getIndexInfo("", "SYS", "SYSCOLUMNS", false, false);
        expRS = new String[][]{{"", "SYS", "SYSCOLUMNS", "false", "", "SYSCOLUMNS_INDEX1", "3", "1", "REFERENCEID", "A", null, null, null}, {"", "SYS", "SYSCOLUMNS", "false", "", "SYSCOLUMNS_INDEX1", "3", "2", "COLUMNNAME", "A", null, null, null}, {"", "SYS", "SYSCOLUMNS", "true", "", "SYSCOLUMNS_INDEX2", "3", "1", "COLUMNDEFAULTID", "A", null, null, null}};
        this.assertFullResultSet(rss, expRS, true);
        rss = this.getIndexInfo("", "SYS", "SYSTABLES", true, false);
        expRS = new String[][]{{"", "SYS", "SYSTABLES", "false", "", "SYSTABLES_INDEX1", "3", "1", "TABLENAME", "A", null, null, null}, {"", "SYS", "SYSTABLES", "false", "", "SYSTABLES_INDEX1", "3", "2", "SCHEMAID", "A", null, null, null}, {"", "SYS", "SYSTABLES", "false", "", "SYSTABLES_INDEX2", "3", "1", "TABLEID", "A", null, null, null}};
        this.assertFullResultSet(rss, expRS, true);
        rss = this.getIndexInfo("", "SYS", "SYSSTABLES", true, false);
        JDBC.assertEmpty(rss[0]);
        JDBC.assertEmpty(rss[1]);
    }

    public void testMoreGetIndexInfo() throws SQLException {
        Statement st = this.createStatement();
        st.execute("create table iit (i int not null, j int)");
        st.execute("create unique index iii on iit(i asc, j desc)");
        DatabaseMetaData dmd = this.getDMD();
        ResultSet rs = dmd.getIndexInfo("", this.schema, "IIT", false, false);
        boolean more = rs.next();
        if (more) {
            DatabaseMetaDataTest.assertEquals((String)"A", (String)rs.getString(10));
        }
        if (more = rs.next()) {
            DatabaseMetaDataTest.assertEquals((String)"D", (String)rs.getString(10));
        }
        if (more = (rs = this.getIndexInfoODBC("", this.schema, "IIT", false, false)).next()) {
            DatabaseMetaDataTest.assertEquals((String)"A", (String)rs.getString(10));
        }
        if (more = rs.next()) {
            DatabaseMetaDataTest.assertEquals((String)"D", (String)rs.getString(10));
        }
        st.execute("drop index iii");
        st.execute("drop table iit");
        st.close();
    }

    private ResultSet getIndexInfoODBC(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLSTATISTICS(?, ?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        cs.setString(1, catalog);
        cs.setString(2, schema);
        cs.setString(3, table);
        cs.setBoolean(4, !unique);
        cs.setBoolean(5, approximate);
        cs.execute();
        return cs.getResultSet();
    }

    private ResultSet[] getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        ResultSet[] rss = new ResultSet[2];
        DatabaseMetaData dmd = this.getDMD();
        rss[0] = dmd.getIndexInfo(catalog, schema, table, unique, approximate);
        rss[1] = this.getIndexInfoODBC(catalog, schema, table, unique, approximate);
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        int[] columnTypes = new int[]{12, 12, 12, 16, 12, 12, 5, 5, 12, 1, -5, -5, 12};
        boolean[] nullability = new boolean[]{false, false, false, false, false, true, true, true, false, false, true, true, true};
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[0], columnNames, columnTypes, nullability);
        columnTypes[3] = 5;
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[1], columnNames, columnTypes, nullability);
        return rss;
    }

    private void assertFullResultSet(ResultSet[] rs, String[][] expRS, boolean trim) throws SQLException {
        JDBC.assertFullResultSet(rs[0], (Object[][])expRS, trim);
        JDBC.assertFullResultSet(rs[1], (Object[][])expRS, trim);
    }

    private void assertFullUnorderedResultSet(ResultSet[] rs, String[][] expRS, boolean trim) throws SQLException {
        JDBC.assertUnorderedResultSet(rs[0], expRS, trim);
        JDBC.assertUnorderedResultSet(rs[1], expRS, trim);
    }

    private void createObjectsForKeysTests() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table kt1 (i int not null default 10, s smallint not null, c30 char(30) not null, vc10 varchar(10) not null default 'asdf', constraint PRIMKEY primary key(vc10, i), constraint UNIQUEKEY unique(c30, s), ai bigint generated always as identity (start with -10, increment by 2001))");
        s.execute("create unique index u1 on kt1(s, i)");
        s.execute("create index u2 on kt1(s)");
        s.execute("create view kv as select * from kt1");
        s.execute("create table reftab (vc10 varchar(10), i int, s smallint, c30 char(30), s2 smallint, c302 char(30), dprim decimal(5,1) not null, dfor decimal(5,1) not null, constraint PKEY_REFTAB primary key (dprim), constraint FKEYSELF foreign key (dfor) references reftab, constraint FKEY1 foreign key(vc10, i) references kt1, constraint FKEY2 foreign key(c30, s2) references kt1 (c30, s), constraint FKEY3 foreign key(c30, s) references kt1 (c30, s))");
        s.execute("create table reftab2 (t2_vc10 varchar(10), t2_i int, constraint T2_FKEY1 foreign key(t2_vc10, t2_i) references kt1)");
        this.commit();
        this.getConnection().setAutoCommit(true);
    }

    private void dropObjectsForKeysTests() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("drop table reftab2");
        s.execute("drop table reftab");
        this.commit();
        s.execute("drop view kv");
        s.execute("drop index u2");
        s.execute("drop index u1");
        s.execute("drop table kt1");
        this.commit();
        this.getConnection().setAutoCommit(true);
    }

    public void testGetPrimaryKeys() throws SQLException {
        String[][] expRS = new String[][]{{"", this.schema, "KT1", "I", "2", "PRIMKEY"}, {"", this.schema, "KT1", "VC10", "1", "PRIMKEY"}};
        this.createObjectsForKeysTests();
        ResultSet[] rs = this.getPrimaryKeys("", "%", "KT1");
        this.assertFullResultSet(rs, expRS, true);
        rs = this.getPrimaryKeys(null, this.schema, "KT1");
        this.assertFullResultSet(rs, expRS, true);
        rs = this.getPrimaryKeys(null, null, "KT1");
        this.assertFullResultSet(rs, expRS, true);
        rs = this.getPrimaryKeys(null, "", "KT1");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
        DatabaseMetaData dmd = this.getDMD();
        try {
            rs[0] = dmd.getPrimaryKeys(null, null, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sqle) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sqle);
        }
        try {
            rs[1] = this.getPrimaryKeysODBC(null, null, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sqle) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sqle);
        }
        rs = this.getPrimaryKeys(null, null, "%");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
        this.dropObjectsForKeysTests();
    }

    private ResultSet getPrimaryKeysODBC(String catalog, String schema, String table) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLPRIMARYKEYS(?, ?, ?, 'DATATYPE=''ODBC''')");
        cs.setString(1, catalog);
        cs.setString(2, schema);
        cs.setString(3, table);
        cs.execute();
        return cs.getResultSet();
    }

    private ResultSet[] getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet[] rss = new ResultSet[2];
        DatabaseMetaData dmd = this.getDMD();
        rss[0] = dmd.getPrimaryKeys(catalog, schema, table);
        rss[1] = this.getPrimaryKeysODBC(catalog, schema, table);
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
        int[] columnTypes = new int[]{12, 12, 12, 12, 5, 12};
        boolean[] nullability = new boolean[]{false, false, false, false, true, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[0], columnNames, columnTypes, nullability);
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[1], columnNames, columnTypes, nullability);
        return rss;
    }

    public void testGetXXportedKeys() throws SQLException {
        String[][] expRS1 = new String[][]{{"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB", "VC10", "1", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB", "I", "2", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S", "2", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S2", "2", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "REFTAB", "DPRIM", "", this.schema, "REFTAB", "DFOR", "1", "3", "3", "FKEYSELF", "PKEY_REFTAB", "7"}};
        String[][] expRS2 = new String[][]{{"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB2", "T2_VC10", "1", "3", "3", "T2_FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB2", "T2_I", "2", "3", "3", "T2_FKEY1", "PRIMKEY", "7"}};
        this.createObjectsForKeysTests();
        ResultSet[] rs = this.getImportedKeys("", "%", "REFTAB");
        this.assertFullUnorderedResultSet(rs, expRS1, true);
        rs = this.getImportedKeys("", "%", "REFTAB2");
        this.assertFullResultSet(rs, expRS2, true);
        rs = this.getImportedKeys(null, this.schema, "REFTAB");
        this.assertFullUnorderedResultSet(rs, expRS1, true);
        rs = this.getImportedKeys(null, this.schema, "REFTAB2");
        this.assertFullResultSet(rs, expRS2, true);
        rs = this.getImportedKeys(null, null, "REFTAB");
        this.assertFullUnorderedResultSet(rs, expRS1, true);
        rs = this.getImportedKeys(null, "", "REFTAB");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
        DatabaseMetaData dmd = this.getDMD();
        try {
            rs[0] = dmd.getImportedKeys(null, null, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sqle) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sqle);
        }
        try {
            rs[1] = this.getImportedKeysODBC(null, null, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sqle) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sqle);
        }
        rs = this.getImportedKeys(null, null, "%");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
        expRS1 = new String[][]{{"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB", "VC10", "1", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB", "I", "2", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S2", "2", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S", "2", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB2", "T2_VC10", "1", "3", "3", "T2_FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB2", "T2_I", "2", "3", "3", "T2_FKEY1", "PRIMKEY", "7"}};
        expRS2 = new String[][]{{"", this.schema, "REFTAB", "DPRIM", "", this.schema, "REFTAB", "DFOR", "1", "3", "3", "FKEYSELF", "PKEY_REFTAB", "7"}};
        rs = this.getExportedKeys("", "%", "KT1");
        this.assertFullResultSet(rs, expRS1, true);
        rs = this.getExportedKeys("", "%", "REFTAB");
        this.assertFullResultSet(rs, expRS2, true);
        rs = this.getExportedKeys(null, this.schema, "KT1");
        this.assertFullResultSet(rs, expRS1, true);
        rs = this.getExportedKeys(null, this.schema, "REFTAB");
        this.assertFullResultSet(rs, expRS2, true);
        rs = this.getExportedKeys(null, null, "KT1");
        this.assertFullResultSet(rs, expRS1, true);
        rs = this.getExportedKeys(null, "", "KT1");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
        try {
            rs[0] = dmd.getExportedKeys(null, this.schema, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sqle) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sqle);
        }
        try {
            rs[1] = this.getExportedKeysODBC(null, this.schema, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sqle) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sqle);
        }
        rs = this.getExportedKeys(null, null, "%");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertEmpty(rs[1]);
        expRS1 = new String[][]{{"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB", "VC10", "1", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB", "I", "2", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S2", "2", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S", "2", "3", "3", "FKEY3", "UNIQUEKEY", "7"}};
        expRS2 = new String[][]{{"", this.schema, "REFTAB", "DPRIM", "", this.schema, "REFTAB", "DFOR", "1", "3", "3", "FKEYSELF", "PKEY_REFTAB", "7"}};
        rs = this.getCrossReference("", this.schema, "KT1", "", this.schema, "REFTAB");
        this.assertFullResultSet(rs, expRS1, true);
        rs = this.getCrossReference("", this.schema, "REFTAB", "", this.schema, "REFTAB");
        this.assertFullResultSet(rs, expRS2, true);
        rs = this.getCrossReference("", this.schema, "KT1", "", this.schema, "REFTAB");
        this.assertFullResultSet(rs, expRS1, true);
        rs = this.getCrossReference("", this.schema, "REFTAB", "", this.schema, "REFTAB");
        this.assertFullResultSet(rs, expRS2, true);
        rs = this.getCrossReference(null, this.schema, "KT1", null, this.schema, "REFTAB");
        this.assertFullResultSet(rs, expRS1, true);
        rs = this.getCrossReference(null, this.schema, "REFTAB", null, this.schema, "REFTAB");
        this.assertFullResultSet(rs, expRS2, true);
        rs = this.getCrossReference(null, this.schema, "%", null, this.schema, "%");
        JDBC.assertEmpty(rs[0]);
        Object[][] expRS = new String[][]{{"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB", "VC10", "1", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB", "I", "2", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S2", "2", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S", "2", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "REFTAB", "DPRIM", "", this.schema, "REFTAB", "DFOR", "1", "3", "3", "FKEYSELF", "PKEY_REFTAB", "7"}, {"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB2", "T2_VC10", "1", "3", "3", "T2_FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB2", "T2_I", "2", "3", "3", "T2_FKEY1", "PRIMKEY", "7"}};
        JDBC.assertFullResultSet(rs[1], expRS, true);
        rs = this.getCrossReference(null, null, "%", null, null, "%");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertResultSetContains(rs[1], expRS);
        try {
            rs[0] = dmd.getCrossReference(null, null, null, null, null, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sqle) {
            if (DatabaseMetaDataTest.usingDerbyNetClient()) {
                DatabaseMetaDataTest.assertSQLState("XJ110", sqle);
            }
            DatabaseMetaDataTest.assertSQLState("XJ103", sqle);
        }
        try {
            rs[1] = this.getCrossReferenceODBC(null, this.schema, null, null, this.schema, null);
        }
        catch (SQLException sqle) {
            if (DatabaseMetaDataTest.usingDerbyNetClient()) {
                DatabaseMetaDataTest.assertSQLState("XJ110", sqle);
            }
            DatabaseMetaDataTest.assertSQLState("XJ103", sqle);
        }
        try {
            rs[0] = dmd.getCrossReference(null, null, "", null, null, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sqle) {
            if (DatabaseMetaDataTest.usingDerbyNetClient()) {
                DatabaseMetaDataTest.assertSQLState("XJ111", sqle);
            }
            DatabaseMetaDataTest.assertSQLState("XJ103", sqle);
        }
        try {
            rs[1] = this.getCrossReferenceODBC(null, this.schema, "", null, this.schema, null);
        }
        catch (SQLException sqle) {
            if (DatabaseMetaDataTest.usingDerbyNetClient()) {
                DatabaseMetaDataTest.assertSQLState("XJ111", sqle);
            }
            DatabaseMetaDataTest.assertSQLState("XJ103", sqle);
        }
        rs = this.getCrossReference(null, this.schema, "%", null, this.schema, "%");
        JDBC.assertEmpty(rs[0]);
        JDBC.assertFullResultSet(rs[1], expRS, true);
        rs[0].close();
        rs[1].close();
        this.dropObjectsForKeysTests();
    }

    private ResultSet getImportedKeysODBC(String catalog, String schema, String table) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLFOREIGNKEYS(null, null, null, ?, ?, ?, 'IMPORTEDKEY=1;DATATYPE=''ODBC''')");
        cs.setString(1, catalog);
        cs.setString(2, schema);
        cs.setString(3, table);
        cs.execute();
        return cs.getResultSet();
    }

    private ResultSet[] getImportedKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet[] rss = new ResultSet[2];
        DatabaseMetaData dmd = this.getDMD();
        rss[0] = dmd.getImportedKeys(catalog, schema, table);
        rss[1] = this.getImportedKeysODBC(catalog, schema, table);
        this.assertGetImportedAndExportedKeysShape(rss);
        return rss;
    }

    private void assertGetImportedAndExportedKeysShape(ResultSet[] rss) throws SQLException {
        String[] columnNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] columnTypes = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5};
        boolean[] nullability = new boolean[]{false, false, false, false, false, false, false, false, true, true, true, false, false, true};
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[0], columnNames, columnTypes, nullability);
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[1], columnNames, columnTypes, nullability);
    }

    private ResultSet getExportedKeysODBC(String catalog, String schema, String table) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLFOREIGNKEYS(?, ?, ?, null, null, null, 'EXPORTEDKEY=1;DATATYPE=''ODBC''')");
        cs.setString(1, catalog);
        cs.setString(2, schema);
        cs.setString(3, table);
        cs.execute();
        return cs.getResultSet();
    }

    private ResultSet[] getExportedKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet[] rss = new ResultSet[2];
        DatabaseMetaData dmd = this.getDMD();
        rss[0] = dmd.getExportedKeys(catalog, schema, table);
        rss[1] = this.getExportedKeysODBC(catalog, schema, table);
        this.assertGetImportedAndExportedKeysShape(rss);
        return rss;
    }

    private ResultSet getCrossReferenceODBC(String parentcatalog, String parentschema, String parenttable, String foreigncatalog, String foreignschema, String foreigntable) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLFOREIGNKEYS(?, ?, ?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        cs.setString(1, parentcatalog);
        cs.setString(2, parentschema);
        cs.setString(3, parenttable);
        cs.setString(4, foreigncatalog);
        cs.setString(5, foreignschema);
        cs.setString(6, foreigntable);
        cs.execute();
        return cs.getResultSet();
    }

    private ResultSet[] getCrossReference(String parentcatalog, String parentschema, String parenttable, String foreigncatalog, String foreignschema, String foreigntable) throws SQLException {
        ResultSet[] rss = new ResultSet[2];
        DatabaseMetaData dmd = this.getDMD();
        rss[0] = dmd.getCrossReference(parentcatalog, parentschema, parenttable, foreigncatalog, foreignschema, foreigntable);
        rss[1] = this.getCrossReferenceODBC(parentcatalog, parentschema, parenttable, foreigncatalog, foreignschema, foreigntable);
        this.assertGetImportedAndExportedKeysShape(rss);
        return rss;
    }

    public void testReferentialAction() throws SQLException {
        int i;
        Statement s = this.createStatement();
        this.getConnection().setAutoCommit(false);
        s.execute("create table refaction1(a int not null primary key)");
        s.execute("create table refactnone(a int references refaction1(a))");
        s.execute("create table refactrestrict(a int references refaction1(a) on delete restrict)");
        s.execute("create table refactnoaction(a int references refaction1(a) on delete no action)");
        s.execute("create table refactcascade(a int references refaction1(a) on delete cascade)");
        s.execute("create table refactsetnull(a int references refaction1(a) on delete set null)");
        s.execute("create table refactupdrestrict(a int references refaction1(a) on update restrict)");
        s.execute("create table refactupdnoaction(a int references refaction1(a) on update no action)");
        short restrict = 1;
        short no_action = 3;
        short cascade = 0;
        short setnull = 2;
        int setdefault = 4;
        ResultSet[] rs = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTNONE");
        this.verifyReferentialAction(rs, new short[]{no_action, no_action});
        rs = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTRESTRICT");
        this.verifyReferentialAction(rs, new short[]{no_action, restrict});
        rs = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTNOACTION");
        this.verifyReferentialAction(rs, new short[]{no_action, no_action});
        rs = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTCASCADE");
        this.verifyReferentialAction(rs, new short[]{no_action, cascade});
        rs = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTSETNULL");
        this.verifyReferentialAction(rs, new short[]{no_action, setnull});
        rs = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTUPDRESTRICT");
        this.verifyReferentialAction(rs, new short[]{restrict, no_action});
        rs = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTUPDNOACTION");
        this.verifyReferentialAction(rs, new short[]{no_action, no_action});
        rs = this.getImportedKeys(null, this.schema, "REFACTNONE");
        this.verifyReferentialAction(rs, new short[]{no_action, no_action});
        rs = this.getImportedKeys(null, this.schema, "REFACTRESTRICT");
        this.verifyReferentialAction(rs, new short[]{restrict, restrict});
        rs = this.getImportedKeys(null, this.schema, "REFACTNOACTION");
        this.verifyReferentialAction(rs, new short[]{no_action, no_action});
        rs = this.getImportedKeys(null, this.schema, "REFACTCASCADE");
        this.verifyReferentialAction(rs, new short[]{no_action, cascade});
        rs = this.getImportedKeys(null, this.schema, "REFACTSETNULL");
        this.verifyReferentialAction(rs, new short[]{no_action, setnull});
        rs = this.getImportedKeys(null, this.schema, "REFACTUPDRESTRICT");
        this.verifyReferentialAction(rs, new short[]{no_action, no_action});
        rs = this.getImportedKeys(null, this.schema, "REFACTUPDNOACTION");
        this.verifyReferentialAction(rs, new short[]{no_action, no_action});
        rs = this.getExportedKeys(null, this.schema, "REFACTION1");
        short[][] expkeyresults = new short[][]{{no_action, cascade}, {no_action, no_action}, {no_action, no_action}, {no_action, restrict}, {no_action, setnull}, {no_action, no_action}, {restrict, no_action}};
        for (i = 0; i < 6; ++i) {
            rs[0].next();
            DatabaseMetaDataTest.assertEquals((short)expkeyresults[i][0], (short)rs[0].getShort(10));
            DatabaseMetaDataTest.assertEquals((short)expkeyresults[i][1], (short)rs[0].getShort(11));
        }
        for (i = 0; i < 6; ++i) {
            rs[1].next();
            DatabaseMetaDataTest.assertEquals((short)expkeyresults[i][0], (short)rs[1].getShort(10));
            DatabaseMetaDataTest.assertEquals((short)expkeyresults[i][1], (short)rs[1].getShort(11));
        }
        s.execute("drop table refactnone");
        s.execute("drop table refactupdrestrict");
        s.execute("drop table refactupdnoaction");
        s.execute("drop table refactrestrict");
        s.execute("drop table refactnoaction");
        s.execute("drop table refactcascade");
        s.execute("drop table refactsetnull");
        s.execute("drop table refaction1");
        this.commit();
        rs[0].close();
        rs[1].close();
        s.close();
        this.getConnection().setAutoCommit(true);
    }

    public void verifyReferentialAction(ResultSet[] rs, short[] expRes) throws SQLException {
        rs[0].next();
        DatabaseMetaDataTest.assertEquals((short)expRes[0], (short)rs[0].getShort(10));
        DatabaseMetaDataTest.assertEquals((short)expRes[1], (short)rs[0].getShort(11));
        rs[1].next();
        DatabaseMetaDataTest.assertEquals((short)expRes[0], (short)rs[1].getShort(10));
        DatabaseMetaDataTest.assertEquals((short)expRes[1], (short)rs[1].getShort(11));
    }

    public void testGetProceduresGetProcColumns() throws Exception {
        boolean supportsBoolean = true;
        Version dataVersion = this.getDataVersion(this.getConnection());
        if (dataVersion.compareTo(new Version(10, 7, 0, 0)) < 0) {
            supportsBoolean = false;
        }
        Statement s = this.createStatement();
        this.getConnection().setAutoCommit(false);
        s.execute("create procedure GETPCTEST1 (out outb VARCHAR(3), a VARCHAR(3), b NUMERIC, c SMALLINT, e SMALLINT, f INTEGER, g BIGINT, h FLOAT, i DOUBLE PRECISION, k DATE, l TIME, T TIMESTAMP )language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc' parameter style java");
        s.execute("create procedure GETPCTEST2 (pa INTEGER, pb BIGINT)language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc' parameter style java");
        s.execute("create procedure GETPCTEST3A (STRING1 VARCHAR(5), out STRING2 VARCHAR(5))language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc' parameter style java");
        s.execute("create procedure GETPCTEST3B (in STRING3 VARCHAR(5), inout STRING4 VARCHAR(5))language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc' parameter style java");
        s.execute("create procedure GETPCTEST4A()  language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc4a' parameter style java");
        s.execute("create procedure GETPCTEST4B() language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc4b' parameter style java");
        s.execute("create procedure GETPCTEST4Bx(out retparam INTEGER) language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc4b' parameter style java");
        if (supportsBoolean) {
            s.execute("create procedure GETPCTEST5(in inarg boolean, out outarg boolean, inout inoutarg boolean) language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.foo' parameter style java");
        }
        JDBC.GeneratedId genid = new JDBC.GeneratedId();
        String classname = ((Object)((Object)this)).getClass().getName();
        String getpc = classname + ".getpc";
        String getpc4a = classname + ".getpc4a";
        String getpc4b = classname + ".getpc4b";
        String foo = classname + ".foo";
        ResultSet[] rs = this.getProcedures(null, "%", "GETPCTEST%");
        Object[][] expRS = new Object[][]{{"", this.schema, "GETPCTEST1", null, null, null, getpc, DatabaseMetaDataTest.i(1), genid}, {"", this.schema, "GETPCTEST2", null, null, null, getpc, DatabaseMetaDataTest.i(1), genid}, {"", this.schema, "GETPCTEST3A", null, null, null, getpc, DatabaseMetaDataTest.i(1), genid}, {"", this.schema, "GETPCTEST3B", null, null, null, getpc, DatabaseMetaDataTest.i(1), genid}, {"", this.schema, "GETPCTEST4A", null, null, null, getpc4a, DatabaseMetaDataTest.i(1), genid}, {"", this.schema, "GETPCTEST4B", null, null, null, getpc4b, DatabaseMetaDataTest.i(1), genid}, {"", this.schema, "GETPCTEST4BX", null, null, null, getpc4b, DatabaseMetaDataTest.i(1), genid}};
        if (supportsBoolean) {
            expRS = this.appendArray(expRS, new Object[][]{{"", this.schema, "GETPCTEST5", null, null, null, foo, DatabaseMetaDataTest.i(1), genid}});
        }
        JDBC.assertFullResultSet(rs[0], expRS, false);
        for (int i = 0; i < expRS.length; ++i) {
            Object[] jdbcRow = expRS[i];
            Object[] odbcRow = new Object[jdbcRow.length - 1];
            System.arraycopy(jdbcRow, 0, odbcRow, 0, odbcRow.length);
            expRS[i] = odbcRow;
        }
        JDBC.assertFullResultSet(rs[1], expRS, false);
        rs = this.getProcedureColumns(null, "%", "GETPCTEST%", "%");
        expRS = new Object[][]{{null, this.schema, "GETPCTEST1", "OUTB", DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(6), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(12), null, DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(1), "YES", genid, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(0)}, {null, this.schema, "GETPCTEST1", "A", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(6), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(12), null, DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(2), "YES", genid, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(1)}, {null, this.schema, "GETPCTEST1", "B", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(2), "NUMERIC", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(14), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(2), null, null, DatabaseMetaDataTest.i(3), "YES", genid, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(2)}, {null, this.schema, "GETPCTEST1", "C", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(5), "SMALLINT", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(5), null, null, DatabaseMetaDataTest.i(4), "YES", genid, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(3)}, {null, this.schema, "GETPCTEST1", "E", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(5), "SMALLINT", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(5), null, null, DatabaseMetaDataTest.i(5), "YES", genid, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(4)}, {null, this.schema, "GETPCTEST1", "F", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(4), "INTEGER", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(4), null, null, DatabaseMetaDataTest.i(6), "YES", genid, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(5)}, {null, this.schema, "GETPCTEST1", "G", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(-5), "BIGINT", DatabaseMetaDataTest.i(19), DatabaseMetaDataTest.i(40), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(-5), null, null, DatabaseMetaDataTest.i(7), "YES", genid, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(6)}, {null, this.schema, "GETPCTEST1", "H", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(8), "DOUBLE", DatabaseMetaDataTest.i(52), DatabaseMetaDataTest.i(8), null, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(8), null, null, DatabaseMetaDataTest.i(8), "YES", genid, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(7)}, {null, this.schema, "GETPCTEST1", "I", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(8), "DOUBLE", DatabaseMetaDataTest.i(52), DatabaseMetaDataTest.i(8), null, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(8), null, null, DatabaseMetaDataTest.i(9), "YES", genid, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(8)}, {null, this.schema, "GETPCTEST1", "K", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(91), "DATE", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(9), DatabaseMetaDataTest.i(1), null, DatabaseMetaDataTest.i(10), "YES", genid, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(9)}, {null, this.schema, "GETPCTEST1", "L", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(92), "TIME", DatabaseMetaDataTest.i(8), DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(9), DatabaseMetaDataTest.i(2), null, DatabaseMetaDataTest.i(11), "YES", genid, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(10)}, {null, this.schema, "GETPCTEST1", "T", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(93), "TIMESTAMP", DatabaseMetaDataTest.i(29), DatabaseMetaDataTest.i(16), DatabaseMetaDataTest.i(9), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(9), DatabaseMetaDataTest.i(3), null, DatabaseMetaDataTest.i(12), "YES", genid, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(11)}, {null, this.schema, "GETPCTEST2", "PA", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(4), "INTEGER", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(4), null, null, DatabaseMetaDataTest.i(1), "YES", genid, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(0)}, {null, this.schema, "GETPCTEST2", "PB", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(-5), "BIGINT", DatabaseMetaDataTest.i(19), DatabaseMetaDataTest.i(40), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(-5), null, null, DatabaseMetaDataTest.i(2), "YES", genid, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1)}, {null, this.schema, "GETPCTEST3A", "STRING1", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(10), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(12), null, DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), "YES", genid, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(0)}, {null, this.schema, "GETPCTEST3A", "STRING2", DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(10), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(12), null, DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(2), "YES", genid, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1)}, {null, this.schema, "GETPCTEST3B", "STRING3", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(10), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(12), null, DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), "YES", genid, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(0)}, {null, this.schema, "GETPCTEST3B", "STRING4", DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(10), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(12), null, DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(2), "YES", genid, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1)}, {null, this.schema, "GETPCTEST4BX", "RETPARAM", DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(4), "INTEGER", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(4), null, null, DatabaseMetaDataTest.i(1), "YES", genid, DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(0)}};
        if (supportsBoolean) {
            expRS = this.appendArray(expRS, new Object[][]{{null, this.schema, "GETPCTEST5", "INARG", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(16), "BOOLEAN", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(16), null, null, DatabaseMetaDataTest.i(1), "YES", genid, DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(0)}, {null, this.schema, "GETPCTEST5", "OUTARG", DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(16), "BOOLEAN", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(16), null, null, DatabaseMetaDataTest.i(2), "YES", genid, DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(1)}, {null, this.schema, "GETPCTEST5", "INOUTARG", DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(16), "BOOLEAN", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(16), null, null, DatabaseMetaDataTest.i(3), "YES", genid, DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(2)}});
        }
        Object[][] jdbcExpRS = new Object[expRS.length][];
        Object[][] odbcExpRS = new Object[expRS.length][];
        for (int i = 0; i < jdbcExpRS.length; ++i) {
            Object[] row = expRS[i];
            Object[] jdbcRow = (Object[])row.clone();
            jdbcRow[15] = null;
            jdbcRow[14] = null;
            ArrayList<Object> odbcRow = new ArrayList<Object>(Arrays.asList(row));
            odbcRow.remove(19);
            if (i == 9) {
                odbcRow.set(9, null);
            }
            if (i >= 9 && i <= 11) {
                odbcRow.set(10, DatabaseMetaDataTest.i(2));
            }
            jdbcExpRS[i] = jdbcRow;
            odbcExpRS[i] = odbcRow.toArray();
        }
        JDBC.assertFullResultSet(rs[0], jdbcExpRS, false);
        JDBC.assertFullResultSet(rs[1], odbcExpRS, false);
        if (supportsBoolean) {
            s.execute("drop procedure GETPCTEST5");
        }
        s.execute("drop procedure GETPCTEST4Bx");
        s.execute("drop procedure GETPCTEST4B");
        s.execute("drop procedure GETPCTEST4A");
        s.execute("drop procedure GETPCTEST3B");
        s.execute("drop procedure GETPCTEST3A");
        s.execute("drop procedure GETPCTEST2");
        s.execute("drop procedure GETPCTEST1");
        this.commit();
    }

    private Object[][] appendArray(Object[][] target, Object[][] suffix) {
        int targetLength = target.length;
        int suffixLength = suffix.length;
        int resultLength = targetLength + suffixLength;
        Object[][] result = new Object[resultLength][];
        System.arraycopy(target, 0, result, 0, targetLength);
        System.arraycopy(suffix, 0, result, targetLength, suffixLength);
        DatabaseMetaDataTest.println("Appended array");
        return result;
    }

    private ResultSet getProceduresODBC(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLPROCEDURES(?, ?, ?, 'DATATYPE=''ODBC''')");
        cs.setString(1, catalog);
        cs.setString(2, schemaPattern);
        cs.setString(3, procedureNamePattern);
        cs.execute();
        return cs.getResultSet();
    }

    private ResultSet[] getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        ResultSet[] rs = new ResultSet[2];
        DatabaseMetaData dmd = this.getDMD();
        rs[0] = dmd.getProcedures(catalog, schemaPattern, procedureNamePattern);
        rs[1] = this.getProceduresODBC(catalog, schemaPattern, procedureNamePattern);
        String[] columnNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "RESERVED1", "RESERVED2", "RESERVED3", "REMARKS", "PROCEDURE_TYPE", "SPECIFIC_NAME"};
        int[] columnTypes = new int[]{12, 12, 12, 4, 4, 4, 12, 5, 12};
        boolean[] nullability = new boolean[]{false, false, false, true, true, true, true, true, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(rs[0], columnNames, columnTypes, nullability);
        String[] odbcColumnNames = new String[columnNames.length - 1];
        System.arraycopy(columnNames, 0, odbcColumnNames, 0, odbcColumnNames.length);
        int[] odbcColumnTypes = new int[columnTypes.length - 1];
        System.arraycopy(columnTypes, 0, odbcColumnTypes, 0, odbcColumnTypes.length);
        boolean[] odbcNullability = new boolean[nullability.length - 1];
        System.arraycopy(nullability, 0, odbcNullability, 0, odbcNullability.length);
        odbcColumnNames[3] = "NUM_INPUT_PARAMS";
        odbcColumnNames[4] = "NUM_OUTPUT_PARAMS";
        odbcColumnNames[5] = "NUM_RESULT_SETS";
        DatabaseMetaDataTest.assertMetaDataResultSet(rs[1], odbcColumnNames, odbcColumnTypes, odbcNullability);
        return rs;
    }

    private ResultSet getProcedureColumnsODBC(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.SQLPROCEDURECOLS(?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        cs.setString(1, catalog);
        cs.setString(2, schemaPattern);
        cs.setString(3, procedureNamePattern);
        cs.setString(4, columnNamePattern);
        cs.execute();
        return cs.getResultSet();
    }

    private ResultSet[] getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        ResultSet[] rss = new ResultSet[2];
        DatabaseMetaData dmd = this.getDMD();
        rss[0] = dmd.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        rss[1] = this.getProcedureColumnsODBC(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        String[] columnNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME", "METHOD_ID", "PARAMETER_ID"};
        int[] columnTypes = new int[]{12, 12, 12, 12, 5, 4, 12, 4, 4, 5, 5, 5, 12, 12, 4, 4, 4, 4, 12, 12, 5, 5};
        boolean[] nullability = new boolean[]{true, false, false, false, false, false, false, false, false, true, true, false, true, true, true, true, true, false, false, false, false, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[0], columnNames, columnTypes, nullability);
        String[] odbcColumnNames = new String[columnNames.length - 1];
        System.arraycopy(columnNames, 0, odbcColumnNames, 0, 19);
        System.arraycopy(columnNames, 20, odbcColumnNames, 19, 2);
        int[] odbcColumnTypes = new int[columnTypes.length - 1];
        System.arraycopy(columnTypes, 0, odbcColumnTypes, 0, 19);
        System.arraycopy(columnTypes, 20, odbcColumnTypes, 19, 2);
        boolean[] odbcNullability = new boolean[]{true, false, false, false, false, false, false, false, false, true, true, false, true, true, false, true, true, false, false, false, false};
        odbcColumnNames[7] = "COLUMN_SIZE";
        odbcColumnNames[8] = "BUFFER_LENGTH";
        odbcColumnNames[9] = "DECIMAL_DIGITS";
        odbcColumnNames[10] = "NUM_PREC_RADIX";
        odbcColumnTypes[5] = 5;
        odbcColumnTypes[14] = 5;
        odbcColumnTypes[15] = 5;
        DatabaseMetaDataTest.assertMetaDataResultSet(rss[1], odbcColumnNames, odbcColumnTypes, odbcNullability);
        return rss;
    }

    public void testGetFunctionColumns() throws Exception {
        boolean supportsBoolean = true;
        Version dataVersion = this.getDataVersion(this.getConnection());
        if (dataVersion.compareTo(new Version(10, 7, 0, 0)) < 0) {
            supportsBoolean = false;
        }
        if (dataVersion.compareTo(new Version(10, 2, 0, 0)) < 0) {
            return;
        }
        DatabaseMetaData dmd = this.getDMD();
        Statement s = this.createStatement();
        this.getConnection().setAutoCommit(false);
        s.execute("create function f_gfc_1 (a VARCHAR(3), b NUMERIC, c SMALLINT, e CHAR(3), f INTEGER, g BIGINT, h FLOAT, i DOUBLE PRECISION, k DATE, l TIME, T TIMESTAMP ) returns int language java external name 'org.apache.derbyTesting.BlahBlah.blah' parameter style java");
        if (supportsBoolean) {
            s.execute("create function f_gfc_2 ( a boolean) returns boolean language java external name 'org.apache.derbyTesting.functionTests.BlahBlah.blah' parameter style java");
        }
        Method gfcMethod = dmd.getClass().getMethod("getFunctionColumns", String.class, String.class, String.class, String.class);
        ResultSet rs = (ResultSet)gfcMethod.invoke((Object)dmd, (Object[])new String[]{null, "%", "F_GFC_%", "%"});
        JDBC.GeneratedId genid = new JDBC.GeneratedId();
        Object[][] expRS = new Object[][]{{null, this.schema, "F_GFC_1", "", DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(4), "INTEGER", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(0), "YES", genid, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(-1)}, {null, this.schema, "F_GFC_1", "A", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(6), null, null, DatabaseMetaDataTest.i(1), null, DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(1), "YES", genid, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(0)}, {null, this.schema, "F_GFC_1", "B", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(2), "NUMERIC", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(14), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(2), "YES", genid, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(1)}, {null, this.schema, "F_GFC_1", "C", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(5), "SMALLINT", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(3), "YES", genid, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(2)}, {null, this.schema, "F_GFC_1", "E", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(1), "CHAR", DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(6), null, null, DatabaseMetaDataTest.i(1), null, DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(4), "YES", genid, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(3)}, {null, this.schema, "F_GFC_1", "F", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(4), "INTEGER", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(5), "YES", genid, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(4)}, {null, this.schema, "F_GFC_1", "G", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(-5), "BIGINT", DatabaseMetaDataTest.i(19), DatabaseMetaDataTest.i(40), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(6), "YES", genid, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(5)}, {null, this.schema, "F_GFC_1", "H", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(8), "DOUBLE", DatabaseMetaDataTest.i(52), DatabaseMetaDataTest.i(8), null, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(7), "YES", genid, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(6)}, {null, this.schema, "F_GFC_1", "I", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(8), "DOUBLE", DatabaseMetaDataTest.i(52), DatabaseMetaDataTest.i(8), null, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(8), "YES", genid, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(7)}, {null, this.schema, "F_GFC_1", "K", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(91), "DATE", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(9), "YES", genid, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(8)}, {null, this.schema, "F_GFC_1", "L", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(92), "TIME", DatabaseMetaDataTest.i(8), DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(10), "YES", genid, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(9)}, {null, this.schema, "F_GFC_1", "T", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(93), "TIMESTAMP", DatabaseMetaDataTest.i(29), DatabaseMetaDataTest.i(16), DatabaseMetaDataTest.i(9), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(11), "YES", genid, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(10)}};
        if (supportsBoolean) {
            expRS = this.appendArray(expRS, new Object[][]{{null, this.schema, "F_GFC_2", "", DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(16), "BOOLEAN", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(0), "YES", genid, DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(-1)}, {null, this.schema, "F_GFC_2", "A", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(16), "BOOLEAN", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(1), "YES", genid, DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(0)}});
        }
        JDBC.assertFullResultSet(rs, expRS, false);
        if (supportsBoolean) {
            s.execute("drop function f_gfc_2");
        }
        s.execute("drop function f_gfc_1");
        this.commit();
    }

    private static Integer i(int i) {
        return i;
    }

    public void test_jdbc4_1() throws Exception {
        Version dataVersion = this.getDataVersion(this.getConnection());
        if (dataVersion.compareTo(new Version(10, 8, 0, 0)) < 0) {
            return;
        }
        Statement s = this.createStatement();
        DatabaseMetaData dmd = this.getDMD();
        DatabaseMetaDataTest.println("Testing JDBC 4.1 methods on a " + dmd.getClass().getName());
        Wrapper41DBMD wrapper = new Wrapper41DBMD(dmd);
        DatabaseMetaDataTest.assertEquals((boolean)true, (boolean)wrapper.generatedKeyAlwaysReturned());
        ResultSet rs = wrapper.getPseudoColumns(null, null, null, null);
        DatabaseMetaDataTest.assertMetaDataResultSet(rs, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "COLUMN_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "COLUMN_USAGE", "REMARKS", "CHAR_OCTET_LENGTH", "IS_NULLABLE"}, new int[]{12, 12, 12, 12, 4, 4, 4, 4, 12, 12, 4, 12}, new boolean[]{true, true, false, false, false, false, true, true, false, true, true, false});
        JDBC.assertFullResultSet(rs, new String[0][]);
        s.execute("create table t_jdbc41( a int, b int, c generated always as ( -a ) )");
        ResultSet rs2 = dmd.getColumns(null, this.schema, "T_JDBC41", null);
        String[][] expectedRows = new String[][]{{"", this.schema, "T_JDBC41", "A", "4", "INTEGER", "10", null, "0", "10", "1", "", null, null, null, null, "1", "YES", null, null, null, null, "NO", "NO", null}, {"", this.schema, "T_JDBC41", "B", "4", "INTEGER", "10", null, "0", "10", "1", "", null, null, null, null, "2", "YES", null, null, null, null, "NO", "NO", null}, {"", this.schema, "T_JDBC41", "C", "4", "INTEGER", "10", null, "0", "10", "1", "", "GENERATED ALWAYS AS ( -a )", null, null, null, "3", "YES", null, null, null, null, "NO", "YES", null}};
        JDBC.assertFullResultSet(rs2, expectedRows);
        s.execute("drop table t_jdbc41");
    }

    public void test_jdbc4_2() throws Exception {
        Version dataVersion = this.getDataVersion(this.getConnection());
        if (dataVersion.compareTo(new Version(10, 10, 0, 0)) < 0) {
            return;
        }
        Statement s = this.createStatement();
        DatabaseMetaData dmd = this.getDMD();
        DatabaseMetaDataTest.println("Testing JDBC 4.2 methods on a " + dmd.getClass().getName());
        Wrapper42DBMD wrapper = new Wrapper42DBMD(dmd);
        DatabaseMetaDataTest.assertEquals((long)0L, (long)wrapper.getMaxLogicalLobSize());
        DatabaseMetaDataTest.assertEquals((boolean)false, (boolean)wrapper.supportsRefCursors());
    }

    public void testBugFixes() throws SQLException {
        Statement s = this.createStatement();
        this.getConnection().setAutoCommit(false);
        DatabaseMetaData dmd = this.getDMD();
        s.execute("CREATE TABLE Derby655t1(c11_ID BIGINT NOT NULL)");
        s.execute("CREATE TABLE Derby655t2 (c21_ID BIGINT NOT NULL primary key)");
        s.execute("ALTER TABLE Derby655t1 ADD CONSTRAINT F_12 Foreign Key (c11_ID) REFERENCES Derby655t2 (c21_ID) ON DELETE CASCADE ON UPDATE NO ACTION");
        s.execute("CREATE TABLE Derby655t3(c31_ID BIGINT NOT NULL primary key)");
        s.execute("ALTER TABLE Derby655t2 ADD CONSTRAINT F_443 Foreign Key (c21_ID) REFERENCES Derby655t3(c31_ID) ON DELETE CASCADE ON UPDATE NO ACTION");
        ResultSet rs = dmd.getImportedKeys("", this.schema, "DERBY655T1");
        JDBC.assertDrainResults(rs, 1);
        s.execute("drop table Derby655t1");
        s.execute("drop table Derby655t2");
        s.execute("drop table Derby655t3");
        if (JDBC.vmSupportsJDBC3()) {
            s.execute("create procedure isReadO() language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.isro' parameter style java");
            s.execute("call isReadO()");
        }
    }

    public static void isro() throws SQLException {
        DriverManager.getConnection("jdbc:default:connection").getMetaData().isReadOnly();
    }

    public void testGetColumns_DERBY5274() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        long bignum = 0x8FFFFFFFFFFFFE8L;
        s.execute("create table derby5274(x bigint not null generated always as identity (start with 648518346341351400, increment by 648518346341351400))");
        String[][] expected = new String[][]{{"TABLE_SCHEM", this.schema}, {"TABLE_NAME", "DERBY5274"}, {"COLUMN_NAME", "X"}, {"COLUMN_DEF", "AUTOINCREMENT: start 648518346341351400 increment 648518346341351400"}, {"IS_NULLABLE", "NO"}};
        ResultSet rs = this.getDMD().getColumns(null, null, "DERBY5274", null);
        DatabaseMetaDataTest.assertTrue((String)"No columns found", (boolean)rs.next());
        for (String[] expected1 : expected) {
            String label = expected1[0];
            String expectedVal = expected1[1];
            DatabaseMetaDataTest.assertEquals((String)label, (String)expectedVal, (String)rs.getString(label));
        }
        JDBC.assertEmpty(rs);
        this.rollback();
    }

    public static byte[] getpc(String a, BigDecimal b, short c, byte d, short e, int f, long g, float h, double i, byte[] j, Date k, Time l, Timestamp T) {
        return j;
    }

    public static void getpc(int a, long[] b) {
    }

    private static void getpc(int a, long b) {
    }

    public void getpc(String a, String b) {
    }

    public static void getpc4a() {
    }

    public static int getpc4b() {
        return 4;
    }

    public void testDMDconnClosed() throws SQLException {
        ResultSet rs_ = this.getConnection().getMetaData().getTables("%", "%", "%", null);
        this.getConnection().close();
        try {
            rs_.next();
            DatabaseMetaDataTest.fail((String)"No Exception throw when getting metadata.");
        }
        catch (SQLException sqle) {
            DatabaseMetaDataTest.assertSQLState("XCL16", sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Version getDataVersion(Connection conn) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement("values syscs_util.syscs_get_database_property('DataDictionaryVersion')");
            rs = ps.executeQuery();
            rs.next();
            String retval = rs.getString(1);
            int dotIdx = retval.indexOf(46);
            int major = Integer.parseInt(retval.substring(0, dotIdx));
            int minor = Integer.parseInt(retval.substring(dotIdx + 1, retval.length()));
            Version version = new Version(major, minor, 0, 0);
            return version;
        }
        catch (Exception se) {
            DatabaseMetaDataTest.printStackTrace(se);
            Version version = null;
            return version;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }
}

