/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BigDecimalHandler;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ParameterMappingTest
extends BaseJDBCTestCase {
    private static final boolean HAVE_BIG_DECIMAL = !JDBC.vmSupportsJSR169();
    private static final String BAD_TYPE = "42962";
    private static final String UTF8 = "UTF-8";
    private static final long BIG_INTEGER_SEED = 98L;
    private static final long DATE_SEED = 50L;
    private static final long CALENDAR_SEED = 60L;
    private static final String DATE_METHOD_NAME = "setObject(java.util.Date)";
    private static final String CALENDAR_METHOD_NAME = "setObject(java.util.Calendar)";
    private static final String WONT_FIT = "22003";
    private static final String TRUNCATED = "22001";
    private static int[] jdbcTypes = new int[]{-6, 5, 4, -5, 7, 6, 8, 3, 2, -7, 16, 1, 12, -1, 0, -3, 0, 91, 92, 93, 2005, 2004};
    private static String[] SQLTypes = new String[]{null, "SMALLINT", "INTEGER", "BIGINT", "REAL", "FLOAT", "DOUBLE", "DECIMAL(10,5)", null, null, "BOOLEAN", "CHAR(60)", "VARCHAR(60)", "LONG VARCHAR", "CHAR(60) FOR BIT DATA", "VARCHAR(60) FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", "DATE", "TIME", "TIMESTAMP", "CLOB(1k)", "BLOB(1k)"};
    private static String[] validString = new String[]{null, "98", "98", "98", "98", "98", "98", "98", null, null, "TRUE", "98", "98", "98", "0x4", "0x4", "0x4", "2004-02-14", "00:00:00", "2004-02-14 00:00:00", "98", "0x4"};
    private static Class[] B3_GET_OBJECT = HAVE_BIG_DECIMAL ? new Class[]{Integer.class, Integer.class, Integer.class, Long.class, Float.class, Double.class, Double.class, BigDecimal.class, BigDecimal.class, Boolean.class, Boolean.class, String.class, String.class, String.class, byte[].class, byte[].class, byte[].class, Date.class, Time.class, Timestamp.class, Clob.class, Blob.class} : new Class[]{Integer.class, Integer.class, Integer.class, Long.class, Float.class, Double.class, Double.class, String.class, String.class, Boolean.class, Boolean.class, String.class, String.class, String.class, byte[].class, byte[].class, byte[].class, Date.class, Time.class, Timestamp.class, Clob.class, Blob.class};
    private static final boolean n = false;
    private static final boolean X = true;
    public static final boolean[][] B6 = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
    public static boolean[][] B2_MOD = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
    public static boolean[][] B5 = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, true, true, true, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, true, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}};
    public static final boolean[][] allowRegisterOut = new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
    private static final BigDecimal bdMaxShortValue = BigDecimal.valueOf(32767L);
    private static final BigDecimal bdMinShortValue = BigDecimal.valueOf(-32768L);
    private static final BigDecimal bdMaxIntValue = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal bdMinIntValue = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal bdMaxLongValue = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal bdMinLongValue = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal bdMaxFloatValue = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal bdMinFloatValue = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal bdSmallestPosFloatValue = new BigDecimal(1.4E-45f);
    private static final BigDecimal bdSmallestNegFloatValue = new BigDecimal(-1.4E-45f);
    private static final BigDecimal bdMaxDoubleValue = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal bdMinDoubleValue = new BigDecimal(-1.7976931348623157E308);
    private static final BigDecimal bdSmallestPosDoubleValue = new BigDecimal(Double.MIN_VALUE);
    private static final BigDecimal bdSmallestNegDoubleValue = new BigDecimal(-4.9E-324);
    static final float DB2_SMALLEST_REAL = -3.402E38f;
    static final float DB2_LARGEST_REAL = 3.402E38f;
    static final float DB2_SMALLEST_POSITIVE_REAL = 1.175E-37f;
    static final float DB2_LARGEST_NEGATIVE_REAL = -1.175E-37f;
    static final double DB2_SMALLEST_DOUBLE = -1.79769E308;
    static final double DB2_LARGEST_DOUBLE = 1.79769E308;
    static final double DB2_SMALLEST_POSITIVE_DOUBLE = 2.225E-307;
    static final double DB2_LARGEST_NEGATIVE_DOUBLE = -2.225E-307;
    private static final int _X = -1;
    private static final int XXX_BYTE = 0;
    private static final int XXX_SHORT = 1;
    private static final int XXX_INT = 2;
    private static final int XXX_LONG = 3;
    private static final int XXX_FLOAT = 4;
    private static final int XXX_DOUBLE = 5;

    public ParameterMappingTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        Statement scb = conn.createStatement();
        scb.execute("CREATE TABLE PM.LOB_GET(ID INT, B BLOB, C CLOB)");
        PreparedStatement pscb = conn.prepareStatement("INSERT INTO PM.LOB_GET VALUES (?, ?, ?)");
        pscb.setInt(1, 0);
        pscb.setNull(2, 2004);
        pscb.setNull(3, 2005);
        pscb.executeUpdate();
        pscb.setInt(1, 1);
        byte[] data = new byte[]{4, 3, 114, 67, 0, 55};
        pscb.setBinaryStream(2, (InputStream)new ByteArrayInputStream(data), 6);
        pscb.setCharacterStream(3, (Reader)new StringReader("72"), 2);
        pscb.executeUpdate();
        scb.close();
        pscb.close();
        conn.commit();
    }

    public void helperTestDerby6214(int numberOfRowsToUpdate, int testVariation) throws Exception {
        int size = 53000;
        StringBuilder sb = new StringBuilder(53000);
        for (int i = 0; i < 53000; i += 10) {
            sb.append("1234567890");
        }
        PreparedStatement ps = this.prepareStatement("UPDATE Test3 SET C16 = ?, I07 = I07 + 1 WHERE S02 IN (?, ?)");
        switch (testVariation) {
            case 1: {
                ps.setString(1, "abc");
                break;
            }
            case 2: {
                ps.setString(1, sb.toString());
                break;
            }
            case 3: {
                ps.setObject(1, (Object)"abc", 2005);
                break;
            }
            case 4: {
                ps.setObject(1, (Object)sb.toString(), 2005);
            }
        }
        ps.setObject(2, (Object)"AAAAA", 12);
        if (numberOfRowsToUpdate == 1) {
            ps.setObject(3, (Object)"AAAAA", 12);
        } else {
            ps.setObject(3, (Object)"EEEEE", 12);
        }
        ps.execute();
    }

    public void testDerby6214() throws Exception {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE Test3 (S02 VARCHAR(64) NOT NULL, I07 INTEGER, C16 CLOB)");
        s.executeUpdate("INSERT INTO Test3 (S02, I07) VALUES ('AAAAA', 1)");
        s.executeUpdate("INSERT INTO Test3 (S02, I07) VALUES ('EEEEE', 1)");
        for (int i = 1; i < 3; ++i) {
            for (int j = 1; j < 5; ++j) {
                if (ParameterMappingTest.usingDerbyNetClient() && i == 2 && (j == 2 || j == 3 || j == 4)) continue;
                this.helperTestDerby6214(i, j);
            }
        }
    }

    public void testDerby2073() throws Exception {
        if (!JDBC.vmSupportsJDBC3()) {
            return;
        }
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE DERBY_2073_TAB (dc DECIMAL(10,2), db double, r real, i int)");
        PreparedStatement ps = this.prepareStatement("INSERT INTO DERBY_2073_TAB VALUES(?,?,?,?)");
        BigDecimal value = new BigDecimal("123.45");
        ps.setBigDecimal(1, value);
        ps.setBigDecimal(2, value);
        ps.setBigDecimal(3, value);
        ps.setBigDecimal(4, value);
        ps.executeUpdate();
        ps.setBigDecimal(1, null);
        ps.setBigDecimal(2, null);
        ps.setBigDecimal(3, null);
        ps.setBigDecimal(4, null);
        ps.executeUpdate();
        value = JDBC.vmSupportsJDBC4() ? new BigDecimal(new BigInteger("2"), -3) : new BigDecimal("2000");
        ps.setBigDecimal(1, value);
        ps.setBigDecimal(2, value);
        ps.setBigDecimal(3, value);
        ps.setBigDecimal(4, value);
        ps.executeUpdate();
        value = new BigDecimal("123.45");
        ps.setObject(1, (Object)value, 3, 2);
        ps.setObject(2, (Object)value, 3, 2);
        ps.setObject(3, (Object)value, 3, 2);
        ps.setObject(4, (Object)value, 3, 2);
        ps.executeUpdate();
        ps.setObject(1, (Object)value, 3, 0);
        ps.setObject(2, (Object)value, 3, 0);
        ps.setObject(3, (Object)value, 3, 0);
        ps.setObject(4, (Object)value, 3, 0);
        ps.executeUpdate();
        ps.setObject(1, (Object)value, 3);
        ps.setObject(2, (Object)value, 3);
        ps.setObject(3, (Object)value, 3);
        ps.setObject(4, (Object)value, 3);
        ps.executeUpdate();
        ps.setObject(1, value);
        ps.setObject(2, value);
        ps.setObject(3, value);
        ps.setObject(4, value);
        ps.executeUpdate();
        value = JDBC.vmSupportsJDBC4() ? new BigDecimal(new BigInteger("2"), -3) : new BigDecimal("2000");
        ps.setObject(1, value);
        ps.setObject(2, value);
        ps.setObject(3, value);
        ps.setObject(4, value);
        ps.executeUpdate();
        ResultSet rs = s.executeQuery("SELECT * FROM DERBY_2073_TAB");
        String[][] expectedResults = new String[][]{{"123.45", "123.45", "123.45", "123"}, {null, null, null, null}, {"2000.00", "2000.0", "2000.0", "2000"}, {"123.45", "123.45", "123.45", "123"}, {"123.00", "123.0", "123.0", "123"}, {"123.00", "123.0", "123.0", "123"}, {"123.45", "123.45", "123.45", "123"}, {"2000.00", "2000.0", "2000.0", "2000"}};
        if (ParameterMappingTest.usingDerbyNetClient()) {
            JDBC.assertFullResultSet(rs, expectedResults);
        }
        s.executeUpdate("DROP TABLE DERBY_2073_TAB");
    }

    public void testParameterMapping() throws Exception {
        Connection conn = this.getConnection();
        for (int type = 0; type < SQLTypes.length; ++type) {
            String sqlType = SQLTypes[type];
            if (sqlType == null || jdbcTypes[type] == 0) continue;
            Statement s = conn.createStatement();
            try {
                s.execute("DROP TABLE PM.TYPE_AS");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            s.execute("CREATE TABLE PM.TYPE_AS(VAL " + SQLTypes[type] + ")");
            PreparedStatement psi = conn.prepareStatement("INSERT INTO PM.TYPE_AS(VAL) VALUES(?)");
            psi.setNull(1, jdbcTypes[type]);
            psi.executeUpdate();
            PreparedStatement psq = conn.prepareStatement("SELECT VAL FROM PM.TYPE_AS");
            ResultSet rs = psq.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            ParameterMappingTest.assertEquivalentDataType(jdbcTypes[type], rsmd.getColumnType(1));
            rs.close();
            ParameterMappingTest.getXXX(psq, type, true);
            s.execute("DELETE FROM PM.TYPE_AS");
            if (ParameterMappingTest.setValidValue(psi, 1, jdbcTypes[type])) {
                psi.executeUpdate();
                ParameterMappingTest.getXXX(psq, type, false);
            }
            ParameterMappingTest.setXXX(s, psi, psq, type);
            psi.close();
            psq.close();
            s.execute("DROP TABLE PM.TYPE_AS");
            conn.commit();
            try {
                s.execute("DROP PROCEDURE PMP.TYPE_AS");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            String procSQL = "CREATE PROCEDURE PMP.TYPE_AS(IN P1 " + SQLTypes[type] + ", INOUT P2 " + SQLTypes[type] + ", OUT P3 " + SQLTypes[type] + ") LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL " + " EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMappingTest.pmap'";
            try {
                if (!HAVE_BIG_DECIMAL && SQLTypes[type].equals("DECIMAL(10,5)")) continue;
                ParameterMappingTest.println(procSQL);
                s.execute(procSQL);
            }
            catch (SQLException sqle) {
                if (BAD_TYPE.equals(sqle.getSQLState())) continue;
                ParameterMappingTest.fail((String)(sqle.getSQLState() + ":" + sqle.getMessage()));
                continue;
            }
            for (int opt = 0; opt < jdbcTypes.length; ++opt) {
                int jopt = jdbcTypes[opt];
                if (jopt == 0) continue;
                CallableStatement csp = conn.prepareCall("CALL PMP.TYPE_AS(?, ?, ?)");
                boolean bothRegistered = true;
                try {
                    csp.registerOutParameter(2, jopt);
                }
                catch (SQLException sqle) {
                    ParameterMappingTest.assertFalse((String)("INOUT " + sqlType + " registerOutParameter(" + JDBC.sqlNameFromJdbc(jopt) + ") failed"), (boolean)allowRegisterOut[type][opt]);
                    if (!"XCL25".equals(sqle.getSQLState())) {
                        ParameterMappingTest.fail((String)("-- " + sqle.getSQLState()));
                    }
                    bothRegistered = false;
                }
                try {
                    csp.registerOutParameter(3, jopt);
                }
                catch (SQLException sqle) {
                    if (!"XCL25".equals(sqle.getSQLState())) {
                        ParameterMappingTest.fail((String)("-- " + sqle.getSQLState()));
                    }
                    ParameterMappingTest.assertFalse((String)("OUT " + sqlType + " registerOutParameter(" + JDBC.sqlNameFromJdbc(jopt) + "failed"), (boolean)allowRegisterOut[type][opt]);
                    bothRegistered = false;
                }
                if (bothRegistered) {
                    try {
                        if (ParameterMappingTest.setValidValue(csp, 1, jdbcTypes[type]) && ParameterMappingTest.setValidValue(csp, 2, jopt)) {
                            csp.execute();
                            ParameterMappingTest.getOutValue(csp, 2, jopt, type);
                            ParameterMappingTest.getOutValue(csp, 3, jopt, type);
                        }
                    }
                    catch (SQLException sqle) {
                        boolean expectedConversionError;
                        boolean bl = expectedConversionError = "22018".equals(sqle.getSQLState()) || "22007".equals(sqle.getSQLState()) || "22005".equals(sqle.getSQLState());
                        if (!expectedConversionError) {
                            ParameterMappingTest.printStackTrace(sqle);
                        }
                        ParameterMappingTest.assertTrue((String)("FAIL: Unexpected exception" + sqle.getSQLState() + ":" + sqle.getMessage()), (boolean)expectedConversionError);
                    }
                }
                csp.close();
            }
            s.execute("DROP PROCEDURE PMP.TYPE_AS");
            s.close();
            conn.commit();
        }
    }

    public void testClobMapping() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement ps = this.chattyPrepare(conn, "create procedure clobIn\n( in c clob, out result varchar( 100 ) )\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".clobIn'\n");
        ps.execute();
        ps.close();
        CallableStatement cs = this.chattyPrepareCall(conn, "call clobIn( cast( 'def' as clob ), ? )");
        cs.registerOutParameter(1, 12);
        cs.execute();
        ParameterMappingTest.assertEquals((String)"def", (String)cs.getString(1));
        cs.close();
        cs = this.chattyPrepareCall(conn, "call clobIn( ?, ? )");
        cs.setClob(1, (Clob)new HarmonySerialClob("ghi"));
        cs.registerOutParameter(2, 12);
        cs.execute();
        ParameterMappingTest.assertEquals((String)"ghi", (String)cs.getString(2));
        cs.close();
        ps = this.chattyPrepare(conn, "create procedure clobOut\n( out c clob )\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".clobOut'\n");
        ps.execute();
        ps.close();
        cs = this.chattyPrepareCall(conn, "call clobOut( ? )");
        cs.registerOutParameter(1, 2005);
        cs.execute();
        Clob outVal = cs.getClob(1);
        ParameterMappingTest.assertEquals((String)"abc", (String)outVal.getSubString(1L, (int)outVal.length()));
        cs.close();
        ps = this.chattyPrepare(conn, "create procedure clobInOut\n( inout c clob )\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".clobInOut'\n");
        ps.execute();
        ps.close();
        cs = this.chattyPrepareCall(conn, "call clobInOut( ? )");
        cs.setClob(1, (Clob)new HarmonySerialClob("ghi"));
        cs.registerOutParameter(1, 2005);
        cs.execute();
        outVal = cs.getClob(1);
        ParameterMappingTest.assertEquals((String)"ihg", (String)outVal.getSubString(1L, (int)outVal.length()));
        Clob inValue = this.makeBigClob();
        cs.setClob(1, inValue);
        cs.execute();
        Clob outValue = cs.getClob(1);
        this.compareClobs(inValue, outValue);
        cs.close();
    }

    private Clob makeBigClob() throws Exception {
        char[] template = "abcdefghijklmnopqrstuvwxyz".toCharArray();
        int templateLength = template.length;
        int multiplier = 50000;
        char[] value = new char[templateLength * multiplier];
        int idx = 0;
        for (int i = 0; i < multiplier; ++i) {
            for (int j = 0; j < templateLength; ++j) {
                value[idx++] = template[j];
            }
        }
        return new HarmonySerialClob(new String(value));
    }

    private void compareClobs(Clob left, Clob right) throws Exception {
        long leftLength = left.length();
        long rightLength = right.length();
        ParameterMappingTest.println("Left clob has " + leftLength + " characters and right clob has " + rightLength + " characters.");
        ParameterMappingTest.assertEquals((long)leftLength, (long)rightLength);
        if (leftLength == rightLength) {
            // empty if block
        }
        String leftString = left.getSubString(1L, (int)leftLength);
        String rightString = right.getSubString(1L, (int)rightLength);
        int i = 0;
        while ((long)i < leftLength) {
            char rightC;
            int leftIdx = i++;
            int rightIdx = (int)(leftLength - (long)leftIdx - 1L);
            char leftC = leftString.charAt(leftIdx);
            if (leftC != (rightC = rightString.charAt(rightIdx))) {
                ParameterMappingTest.println("left[ " + leftIdx + " ] = " + leftC + " but right[ " + rightIdx + " ] = " + rightC);
                return;
            }
            ParameterMappingTest.assertEquals((char)leftC, (char)rightC);
        }
    }

    public void testBlobMapping() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement ps = this.chattyPrepare(conn, "create procedure blobIn\n( in c blob, out result varchar( 100 ) )\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".blobIn'\n");
        ps.execute();
        ps.close();
        CallableStatement cs = this.chattyPrepareCall(conn, "call blobIn( ?, ? )");
        cs.setBlob(1, (Blob)new HarmonySerialBlob("ghi".getBytes(UTF8)));
        cs.registerOutParameter(2, 12);
        cs.execute();
        ParameterMappingTest.assertEquals((String)"ghi", (String)cs.getString(2));
        cs.close();
        ps = this.chattyPrepare(conn, "create procedure blobOut\n( out c blob )\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".blobOut'\n");
        ps.execute();
        ps.close();
        cs = this.chattyPrepareCall(conn, "call blobOut( ? )");
        cs.registerOutParameter(1, 2004);
        cs.execute();
        Blob outVal = cs.getBlob(1);
        ParameterMappingTest.assertEquals((String)"abc", (String)ParameterMappingTest.getBlobValue(outVal));
        cs.close();
        ps = this.chattyPrepare(conn, "create procedure blobInOut\n( inout c blob )\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".blobInOut'\n");
        ps.execute();
        ps.close();
        cs = this.chattyPrepareCall(conn, "call blobInOut( ? )");
        cs.setBlob(1, (Blob)new HarmonySerialBlob("ghi".getBytes(UTF8)));
        cs.registerOutParameter(1, 2004);
        cs.execute();
        outVal = cs.getBlob(1);
        ParameterMappingTest.assertEquals((String)"ihg", (String)ParameterMappingTest.getBlobValue(outVal));
        Blob inValue = this.makeBigBlob();
        cs.setBlob(1, inValue);
        cs.execute();
        Blob outValue = cs.getBlob(1);
        this.compareBlobs(inValue, outValue);
        cs.close();
    }

    private Blob makeBigBlob() throws Exception {
        byte[] template = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int templateLength = template.length;
        int multiplier = 110000;
        byte[] value = new byte[templateLength * multiplier];
        int idx = 0;
        for (int i = 0; i < multiplier; ++i) {
            for (int j = 0; j < templateLength; ++j) {
                value[idx++] = template[j];
            }
        }
        return new HarmonySerialBlob(value);
    }

    private void compareBlobs(Blob left, Blob right) throws Exception {
        long leftLength = left.length();
        long rightLength = right.length();
        ParameterMappingTest.println("Left blob has " + leftLength + " bytes and right blob has " + rightLength + " bytes.");
        ParameterMappingTest.assertEquals((long)leftLength, (long)rightLength);
        if (leftLength == rightLength) {
            // empty if block
        }
        byte[] leftBytes = left.getBytes(1L, (int)leftLength);
        byte[] rightBytes = right.getBytes(1L, (int)rightLength);
        int i = 0;
        while ((long)i < leftLength) {
            byte leftC;
            int leftIdx;
            int rightIdx = (int)(leftLength - (long)leftIdx - 1L);
            byte rightC = rightBytes[rightIdx];
            if ((leftC = leftBytes[leftIdx = i++]) != rightC) {
                ParameterMappingTest.println("left[ " + leftIdx + " ] = " + leftC + " but right[ " + rightIdx + " ] = " + rightC);
                return;
            }
            ParameterMappingTest.assertEquals((byte)leftC, (byte)rightC);
        }
    }

    public void test_jdbc4_1_objectMappings() throws Exception {
        Connection conn = this.getConnection();
        Statement s = conn.createStatement();
        try {
            s.execute("drop table t_object_map");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        s.execute("create table t_object_map( a int, b timestamp, c bigint )");
        PreparedStatement ps = conn.prepareStatement("insert into t_object_map( a, b, c ) values ( ?, ?, ? )");
        ps.setInt(1, 1);
        ps.setObject(2, new java.util.Date(50L));
        ps.setObject(3, null);
        ps.executeUpdate();
        ps.setInt(1, 2);
        ps.setObject(2, ParameterMappingTest.makeCalendar(60L));
        ps.setObject(3, null);
        ps.executeUpdate();
        ps.setInt(1, 3);
        ps.setObject(2, null);
        ps.setObject(3, new BigInteger(Long.toString(98L)));
        ps.executeUpdate();
        ps.close();
        ps = conn.prepareStatement("select * from t_object_map order by a");
        ResultSet rs = ps.executeQuery();
        rs.next();
        ParameterMappingTest.assertEquals((long)50L, (long)rs.getTimestamp(2).getTime());
        rs.next();
        ParameterMappingTest.assertEquals((long)60L, (long)rs.getTimestamp(2).getTime());
        rs.next();
        ParameterMappingTest.assertEquals((long)98L, (long)rs.getLong(3));
        rs.close();
        ps.close();
    }

    private static Calendar makeCalendar(long calendarSeed) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new java.util.Date(calendarSeed));
        return calendar;
    }

    public void testBigInteger() throws Exception {
        Connection conn = this.getConnection();
        Statement s = conn.createStatement();
        try {
            s.execute("drop table t2_object_map");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        s.execute("create table t2_object_map( smallint_col smallint, int_col int, bigint_col bigint, real_col real, float_col float, double_col double, decimal_col decimal( 31 ), numeric_col numeric( 31 ), char_col char( 10 ), varchar_col varchar( 10 ) )");
        String[] allColumns = new String[]{"smallint_col", "int_col", "bigint_col", "real_col", "float_col", "double_col", "decimal_col", "numeric_col", "char_col", "varchar_col"};
        HashSet<String> smallIntColumns = new HashSet<String>();
        for (int i = 0; i < allColumns.length; ++i) {
            String colName = allColumns[i];
            if (!colName.endsWith("int_col")) continue;
            smallIntColumns.add(colName);
        }
        HashSet<String> smallCharColumns = new HashSet<String>();
        for (int i = 0; i < allColumns.length; ++i) {
            String colName = allColumns[i];
            if (!colName.endsWith("char_col")) continue;
            smallCharColumns.add(colName);
        }
        this.vetBigInteger(conn, "1", allColumns, new HashSet(), new HashSet());
        this.vetBigInteger(conn, "9223372036854775808", allColumns, smallIntColumns, smallCharColumns);
        this.vetBigInteger(conn, "-9223372036854775809", allColumns, smallIntColumns, smallCharColumns);
    }

    private void vetBigInteger(Connection conn, String seed, String[] allColumns, HashSet undersizedIntColumns, HashSet undersizedStringColumns) throws Exception {
        for (int i = 0; i < allColumns.length; ++i) {
            String columnName = allColumns[i];
            String errorState = null;
            if (undersizedIntColumns.contains(columnName)) {
                errorState = WONT_FIT;
            } else if (undersizedStringColumns.contains(columnName)) {
                errorState = TRUNCATED;
            }
            this.vetBigInteger(conn, seed, columnName, errorState);
        }
    }

    private void vetBigInteger(Connection conn, String seed, String columnName, String errorState) throws Exception {
        PreparedStatement ps = conn.prepareStatement("delete from t2_object_map");
        ps.executeUpdate();
        ps.close();
        String insertText = "insert into t2_object_map( " + columnName + " ) values ( ? )";
        ps = conn.prepareStatement(insertText);
        try {
            ps.setObject(1, new BigInteger(seed));
            ps.executeUpdate();
            if (errorState != null) {
                ParameterMappingTest.fail((String)("Expected '" + insertText + "' to fail for BigInteger( " + seed + " )."));
            }
        }
        catch (SQLException se) {
            ParameterMappingTest.assertEquals((String)("Expecting failure for seed = " + seed + " and insertText = '" + insertText + "'"), (String)errorState, (String)se.getSQLState());
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        this.dropTable("PM.LOB_GET");
        this.commit();
        super.tearDown();
    }

    private static void getXXX(PreparedStatement ps, int type, boolean isNull) throws SQLException, IOException {
        boolean worked;
        int jdbcType;
        boolean worked2;
        boolean wn;
        boolean worked3;
        boolean wn2;
        int expectedInt = ps.getMetaData().getColumnType(1) == 16 ? 1 : 32;
        ResultSet rs = ps.executeQuery();
        rs.next();
        SQLException sqleResult = null;
        try {
            byte b = rs.getByte(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertEquals((int)expectedInt, (int)b);
            }
            worked3 = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked3 = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked3, sqleResult, 0, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            short s = rs.getShort(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertEquals((int)expectedInt, (int)s);
            }
            worked3 = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked3 = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked3, sqleResult, 1, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            int i = rs.getInt(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertFalse((boolean)isNull);
                ParameterMappingTest.assertEquals((int)expectedInt, (int)i);
            }
            worked3 = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked3 = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked3, sqleResult, 2, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            long l = rs.getLong(1);
            wn = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn);
            } else {
                ParameterMappingTest.assertEquals((long)expectedInt, (long)l);
                ParameterMappingTest.assertFalse((boolean)wn);
            }
            worked3 = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked3 = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked3, sqleResult, 3, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            float f = rs.getFloat(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertEquals((double)expectedInt, (double)f, (double)1.0E-6);
            }
            worked3 = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked3 = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked3, sqleResult, 4, type);
        rs = ps.executeQuery();
        rs.next();
        SQLException sqleResult2 = null;
        try {
            double d = rs.getDouble(1);
            wn = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn);
                ParameterMappingTest.assertEquals((double)expectedInt, (double)d, (double)1.0E-5);
            }
            worked2 = true;
        }
        catch (SQLException sqle) {
            sqleResult2 = sqle;
            worked2 = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked2, sqleResult2, 5, type);
        if (HAVE_BIG_DECIMAL) {
            rs = ps.executeQuery();
            rs.next();
            sqleResult = null;
            try {
                BigDecimal bd = rs.getBigDecimal(1);
                wn2 = rs.wasNull();
                if (isNull) {
                    ParameterMappingTest.assertTrue((boolean)wn2);
                    ParameterMappingTest.assertNull((Object)bd);
                } else {
                    ParameterMappingTest.assertFalse((boolean)wn2);
                    ParameterMappingTest.assertEquals((String)"BigDecimal comparison failed", (int)0, (int)BigDecimal.valueOf(expectedInt).compareTo(bd));
                }
                worked = true;
            }
            catch (SQLException sqle) {
                sqleResult = sqle;
                worked = false;
            }
            rs.close();
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 6, type);
        }
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            boolean b = rs.getBoolean(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertTrue((boolean)b);
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked, sqleResult, 7, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            String s = rs.getString(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)s);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                s = s.trim();
                jdbcType = jdbcTypes[type];
                switch (jdbcType) {
                    case -5: 
                    case -1: 
                    case 1: 
                    case 4: 
                    case 5: 
                    case 12: {
                        ParameterMappingTest.assertEquals((String)Integer.toString(expectedInt), (String)s);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        ParameterMappingTest.assertEquals((String)(expectedInt + ".0"), (String)s);
                        break;
                    }
                    case 2: 
                    case 3: {
                        ParameterMappingTest.assertEquals((String)(expectedInt + ".00000"), (String)s);
                        break;
                    }
                    case -3: 
                    case -2: {
                        ParameterMappingTest.assertEquals((String)"0403fdc373", (String)s);
                        break;
                    }
                    case 91: {
                        ParameterMappingTest.assertEquals((String)"2004-02-14", (String)s);
                        break;
                    }
                    case 92: {
                        ParameterMappingTest.assertEquals((String)"17:14:24", (String)s);
                        break;
                    }
                    case 93: {
                        ParameterMappingTest.assertEquals((String)"2004-02-14 17:14:24.097625551", (String)s);
                        break;
                    }
                    case 2005: {
                        ParameterMappingTest.assertEquals((String)"67", (String)s);
                        break;
                    }
                    case 2004: {
                        ParameterMappingTest.assertEquals((String)"8243cafe0032", (String)s);
                    }
                }
                ParameterMappingTest.assertFalse((boolean)wn2);
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked, sqleResult, 8, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            byte[] data = rs.getBytes(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)data);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                jdbcType = jdbcTypes[type];
                switch (jdbcType) {
                    case -4: 
                    case -3: 
                    case -2: {
                        ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(data));
                        break;
                    }
                    case 2004: {
                        ParameterMappingTest.assertEquals((String)"0x82,0x43", (String)ParameterMappingTest.showFirstTwo(data));
                    }
                }
                ParameterMappingTest.assertNotNull((Object)data);
                ParameterMappingTest.assertFalse((boolean)wn2);
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        rs.close();
        ParameterMappingTest.judge_getXXX(worked, sqleResult, 9, type);
        sqleResult = null;
        ResultSet rs2 = null;
        try {
            rs2 = ps.executeQuery();
            rs2.next();
            Date d = rs2.getDate(1);
            wn2 = rs2.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)d);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertEquals((String)"2004-02-14", (String)d.toString());
                ParameterMappingTest.assertNotNull((Object)d);
                ParameterMappingTest.assertFalse((boolean)wn2);
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = "22007".equals(sqle.getSQLState());
        }
        catch (Throwable t) {
            worked = false;
        }
        if (rs2 != null) {
            rs2.close();
        }
        ParameterMappingTest.judge_getXXX(worked, sqleResult, 10, type);
        sqleResult = null;
        rs2 = null;
        try {
            rs2 = ps.executeQuery();
            rs2.next();
            Time t = rs2.getTime(1);
            wn2 = rs2.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)t);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertEquals((String)"17:14:24", (String)t.toString());
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = "22007".equals(sqle.getSQLState());
        }
        catch (Throwable t) {
            worked = false;
        }
        if (rs2 != null) {
            rs2.close();
        }
        ParameterMappingTest.judge_getXXX(worked, sqleResult, 11, type);
        sqleResult = null;
        rs2 = null;
        try {
            rs2 = ps.executeQuery();
            rs2.next();
            Timestamp ts = rs2.getTimestamp(1);
            wn2 = rs2.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)ts);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else {
                if (type == 91 || type == 93) {
                    ParameterMappingTest.assertEquals((String)"2004-02-14 00:00:00.0", (String)ts.toString());
                }
                ParameterMappingTest.assertFalse((boolean)rs2.wasNull());
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = "22007".equals(sqle.getSQLState());
        }
        catch (Throwable t) {
            worked = false;
        }
        if (rs2 != null) {
            rs2.close();
        }
        ParameterMappingTest.judge_getXXX(worked, sqleResult, 12, type);
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            InputStream is = rs.getAsciiStream(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
                ParameterMappingTest.assertNull((Object)is);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                if (B6[13][type]) {
                    ParameterMappingTest.assertNotNull((Object)ParameterMappingTest.showFirstTwo(is));
                }
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        boolean judge = B6[13][type] || ParameterMappingTest.specificCheck(rs, worked, sqleResult, isNull);
        rs.close();
        if (judge) {
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 13, type);
        }
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            InputStream is = rs.getBinaryStream(1);
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)rs.wasNull());
                ParameterMappingTest.assertNull((Object)is);
            } else if (B6[14][type]) {
                ParameterMappingTest.assertNotNull((Object)ParameterMappingTest.showFirstTwo(is));
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        judge = B6[14][type] || ParameterMappingTest.specificCheck(rs, worked, sqleResult, isNull);
        rs.close();
        if (judge) {
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 14, type);
        }
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            Reader r = rs.getCharacterStream(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)r);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else if (B6[15][type]) {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertNotNull((Object)ParameterMappingTest.showFirstTwo(r));
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        judge = B6[15][type] || ParameterMappingTest.specificCheck(rs, worked, sqleResult, isNull);
        rs.close();
        if (judge) {
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 15, type);
        }
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            Clob clob = rs.getClob(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertNull((Object)clob);
                ParameterMappingTest.assertTrue((boolean)wn2);
            } else if (B6[16][type]) {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertNotNull((Object)clob.getSubString(1L, 10));
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        judge = B6[16][type] || ParameterMappingTest.specificCheck(rs, worked, sqleResult, isNull);
        rs.close();
        if (judge) {
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 16, type);
        }
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            Blob blob = rs.getBlob(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
                ParameterMappingTest.assertNull((Object)blob);
            } else if (B6[17][type]) {
                ParameterMappingTest.assertNotNull((Object)ParameterMappingTest.showFirstTwo(blob.getBinaryStream()));
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        judge = B6[17][type] || ParameterMappingTest.specificCheck(rs, worked, sqleResult, isNull);
        rs.close();
        if (judge) {
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 17, type);
        }
        rs = ps.executeQuery();
        rs.next();
        sqleResult = null;
        try {
            InputStream is = rs.getUnicodeStream(1);
            wn2 = rs.wasNull();
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn2);
                ParameterMappingTest.assertNull((Object)is);
            } else {
                ParameterMappingTest.assertFalse((boolean)wn2);
                ParameterMappingTest.assertNotNull((Object)is);
            }
            worked = true;
        }
        catch (NoSuchMethodError e) {
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        rs.close();
        if (JDBC.vmSupportsJDBC3()) {
            ParameterMappingTest.judge_getXXX(worked, sqleResult, 18, type);
        }
        rs = ps.executeQuery();
        rs.next();
        if (!SQLTypes[type].equals("DECIMAL(10,5)") || HAVE_BIG_DECIMAL) {
            Object o = rs.getObject(1);
            boolean wn3 = rs.wasNull();
            Class cgo = B3_GET_OBJECT[type];
            if (cgo.equals(byte[].class)) {
                String cname = "byte[]";
            } else {
                String cname = cgo.getName();
            }
            if (isNull) {
                ParameterMappingTest.assertTrue((boolean)wn3);
                ParameterMappingTest.assertNull((Object)o);
                worked = true;
            } else if (cgo.isInstance(o)) {
                worked = true;
            } else {
                worked = false;
                ParameterMappingTest.fail((String)("FAIL NOT :" + cgo.getName() + " is " + o.getClass().getName()));
            }
        } else {
            worked = true;
        }
        ParameterMappingTest.assertTrue((boolean)worked);
        rs.close();
    }

    private static boolean specificCheck(ResultSet rs, boolean worked, SQLException sqleResult, boolean isNull) throws SQLException {
        boolean judge = true;
        if (worked && isNull && rs.wasNull()) {
            if (ParameterMappingTest.usingDerbyNetClient()) {
                judge = false;
            }
        } else if (!worked && isNull && ParameterMappingTest.usingDerbyNetClient() && "22005".equals(sqleResult.getSQLState())) {
            judge = false;
        }
        return judge;
    }

    private static void judge_getXXX(boolean worked, SQLException sqleResult, int whichCall, int type) {
        boolean validSQLState = false;
        if (B6[whichCall][type] && !worked) {
            ParameterMappingTest.fail((String)(" JDBC FAIL " + SQLTypes[type] + " " + sqleResult));
        } else if (!worked) {
            String sqlState = sqleResult.getSQLState();
            if ("0A000".equals(sqlState)) {
                validSQLState = true;
            }
            if ("0A000".equals(sqlState)) {
                validSQLState = true;
            }
            if ("22005".equals(sqlState)) {
                validSQLState = true;
            } else if (sqlState == null && sqleResult.getMessage().indexOf("Wrong result column type for requested conversion") != -1) {
                validSQLState = true;
            }
            ParameterMappingTest.assertTrue((String)("FAIL: Expected conversion error but got " + sqleResult), (boolean)validSQLState);
        }
    }

    private static void judge_setXXX(boolean worked, SQLException sqleResult, int whichCall, int type) {
        String msg;
        boolean shouldWork = B2_MOD[whichCall][type];
        if (worked && shouldWork) {
            msg = " JDBC MATCH(OK)";
        } else if (worked) {
            msg = " CLOUD EXT (OK)";
        } else if (sqleResult != null && "0A000".equals(sqleResult.getSQLState())) {
            msg = " Not Implemented (OK)";
        } else if (shouldWork) {
            if (sqleResult != null) {
                ParameterMappingTest.showException(sqleResult);
            }
            msg = " JDBC FAIL " + SQLTypes[type];
        } else {
            msg = ParameterMappingTest.checkForInvalidConversion(sqleResult);
            if (msg == null) {
                return;
            }
        }
        if (msg.startsWith("JDBC FAIL")) {
            ParameterMappingTest.fail((String)(" JDBC FAIL " + SQLTypes[type]));
        }
    }

    private static void judge_setObject(boolean worked, SQLException sqleResult, int b5o, int type) {
        String msg;
        boolean shouldWork = B5[b5o][type];
        if (worked && shouldWork) {
            msg = " JDBC MATCH(OK)";
        } else if (worked) {
            msg = " CLOUD EXT (OK)";
        } else if ("0A000".equals(sqleResult.getSQLState())) {
            msg = " Not Implemented (OK)";
        } else if (shouldWork) {
            if (sqleResult != null) {
                ParameterMappingTest.showException(sqleResult);
            }
            msg = " JDBC FAIL " + SQLTypes[type];
        } else {
            msg = ParameterMappingTest.checkForInvalidConversion(sqleResult);
            if (msg == null) {
                return;
            }
        }
        if (msg.startsWith("JDBC FAIL")) {
            ParameterMappingTest.fail((String)(" JDBC FAIL " + SQLTypes[type]));
        }
    }

    private static String checkForInvalidConversion(SQLException sqle) {
        if (sqle == null) {
            return null;
        }
        boolean unknownException = true;
        for (SQLException e = sqle; e != null && unknownException; e = e.getNextException()) {
            if (!"22005".equals(e.getSQLState()) && !"XCL12".equals(e.getSQLState()) && e.getMessage().indexOf("Illegal Conv") == -1) continue;
            unknownException = false;
            if (!"0A000".equals(e.getSQLState()) || e.getMessage().indexOf("setUnicodeStream") == -1) break;
            unknownException = false;
            break;
        }
        if (unknownException) {
            ParameterMappingTest.showException(sqle);
        }
        return " JDBC MATCH (INVALID)";
    }

    private static void setXXX(Statement s, PreparedStatement psi, PreparedStatement psq, int type) throws SQLException, IOException {
        Object tester;
        ResultSet rsc;
        byte[] data;
        boolean worked;
        s.execute("DELETE FROM PM.TYPE_AS");
        SQLException sqleResult = null;
        try {
            psi.setByte(1, (byte)98);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setByte");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 0, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setByte(1, (byte)98);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setByte");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 0, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setShort(1, (short)98);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setShort");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 1, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setShort(1, (short)98);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setShort");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 1, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setInt(1, 98);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setInt");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 2, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setInt(1, 98);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setInt");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 2, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setLong(1, 98L);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setLong");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 3, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setLong(1, 98L);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setLong");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 3, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setFloat(1, 98.4f);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setFloat");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 4, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setFloat(1, 98.4f);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setFloat");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 4, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setDouble(1, 98.5);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setDouble");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 5, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setDouble(1, 98.5);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setDouble");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 5, type);
        if (HAVE_BIG_DECIMAL) {
            s.execute("DELETE FROM PM.TYPE_AS");
            sqleResult = null;
            try {
                psi.setBigDecimal(1, new BigDecimal(98.0));
                psi.executeUpdate();
                ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBigDecimal");
                worked = true;
            }
            catch (SQLException sqle) {
                sqleResult = sqle;
                worked = false;
            }
            ParameterMappingTest.judge_setXXX(worked, sqleResult, 6, type);
            s.execute("DELETE FROM PM.TYPE_AS");
            sqleResult = null;
            try {
                psi.setBigDecimal(1, new BigDecimal(98.0));
                psi.addBatch();
                psi.executeBatch();
                ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBigDecimal");
                worked = true;
            }
            catch (SQLException sqle) {
                sqleResult = sqle;
                worked = false;
            }
            ParameterMappingTest.judge_setXXX(worked, sqleResult, 6, type);
            s.execute("DELETE FROM PM.TYPE_AS");
            sqleResult = null;
            try {
                psi.setBigDecimal(1, null);
                psi.executeUpdate();
                ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBigDecimal");
                worked = true;
            }
            catch (SQLException sqle) {
                sqleResult = sqle;
                worked = false;
            }
            ParameterMappingTest.judge_setXXX(worked, sqleResult, 6, type);
            s.execute("DELETE FROM PM.TYPE_AS");
            sqleResult = null;
            try {
                psi.setBigDecimal(1, null);
                psi.addBatch();
                psi.executeBatch();
                ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBigDecimal");
                worked = true;
            }
            catch (SQLException sqle) {
                sqleResult = sqle;
                worked = false;
            }
            ParameterMappingTest.judge_setXXX(worked, sqleResult, 6, type);
        }
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBoolean(1, true);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBoolean");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 7, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBoolean(1, true);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBoolean");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 7, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setString(1, validString[type]);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setString");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        catch (Throwable t) {
            worked = false;
            sqleResult = null;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 8, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setString(1, validString[type]);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setString");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        catch (Throwable t) {
            worked = false;
            sqleResult = null;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 8, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setString(1, null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setString");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        catch (Throwable t) {
            worked = false;
            sqleResult = null;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 8, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setString(1, null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setString");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        catch (Throwable t) {
            worked = false;
            sqleResult = null;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 8, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        ParameterMappingTest.testSetStringInvalidValue(type, psi);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{4, 3, -3, -61, 115};
            psi.setBytes(1, data);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBytes");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 9, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{4, 3, -3, -61, 115};
            psi.setBytes(1, data);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBytes");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 9, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBytes(1, null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBytes");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 9, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBytes(1, null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBytes");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 9, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setDate(1, Date.valueOf("2004-02-14"));
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setDate");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 10, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setDate(1, Date.valueOf("2004-02-14"));
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setDate");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 10, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setDate(1, null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setDate");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 10, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setDate(1, null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setDate");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 10, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTime(1, Time.valueOf("00:00:00"));
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTime");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 11, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTime(1, Time.valueOf("00:00:00"));
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTime");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 11, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTime(1, null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTime");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 11, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTime(1, null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTime");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 11, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTimestamp(1, Timestamp.valueOf("2004-02-14 00:00:00.0"));
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTimestamp");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 12, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTimestamp(1, Timestamp.valueOf("2004-02-14 00:00:00.0"));
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTimestamp");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 12, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTimestamp(1, null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTimestamp");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 12, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setTimestamp(1, null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setTimestamp");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 12, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{101, 103, 48, 49, 50, 100};
            psi.setAsciiStream(1, (InputStream)new ByteArrayInputStream(data), 6);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setAsciiStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 13, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{101, 103, 48, 49, 50, 100};
            psi.setAsciiStream(1, (InputStream)new ByteArrayInputStream(data), 6);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setAsciiStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 13, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setAsciiStream(1, (InputStream)null, 0);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setAsciiStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 13, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setAsciiStream(1, (InputStream)null, 0);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setAsciiStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 13, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{4, 3, -54, -2, 0, 50};
            psi.setBinaryStream(1, (InputStream)new ByteArrayInputStream(data), 6);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBinaryStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 14, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{4, 3, -54, -2, 0, 50};
            psi.setBinaryStream(1, (InputStream)new ByteArrayInputStream(data), 6);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "getBinaryStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 14, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBinaryStream(1, (InputStream)null, 0);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBinaryStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 14, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBinaryStream(1, (InputStream)null, 0);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBinaryStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 14, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setCharacterStream(1, (Reader)new StringReader("89"), 2);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setCharacterStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 15, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setCharacterStream(1, (Reader)new StringReader("89"), 2);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setCharacterStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 15, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setCharacterStream(1, (Reader)null, 0);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setCharacterStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 15, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setCharacterStream(1, (Reader)null, 0);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setCharacterStream");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 15, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            rsc = s.executeQuery("SELECT C FROM PM.LOB_GET WHERE ID = 1");
            rsc.next();
            tester = rsc.getClob(1);
            rsc.close();
            psi.setClob(1, (Clob)tester);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setClob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 16, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            rsc = s.executeQuery("SELECT C FROM PM.LOB_GET WHERE ID = 1");
            rsc.next();
            tester = rsc.getClob(1);
            rsc.close();
            psi.setClob(1, (Clob)tester);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setClob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 16, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setClob(1, (Clob)null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setClob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 16, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setClob(1, (Clob)null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setClob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 16, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            rsc = s.executeQuery("SELECT B FROM PM.LOB_GET WHERE ID = 1");
            rsc.next();
            tester = rsc.getBlob(1);
            rsc.close();
            psi.setBlob(1, (Blob)tester);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBlob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 17, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            rsc = s.executeQuery("SELECT B FROM PM.LOB_GET WHERE ID = 1");
            rsc.next();
            tester = rsc.getBlob(1);
            rsc.close();
            psi.setBlob(1, (Blob)tester);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBlob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 17, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBlob(1, (Blob)null);
            psi.executeUpdate();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBlob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 17, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            psi.setBlob(1, (Blob)null);
            psi.addBatch();
            psi.executeBatch();
            ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setBlob");
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setXXX(worked, sqleResult, 17, type);
        s.execute("DELETE FROM PM.TYPE_AS");
        sqleResult = null;
        try {
            data = new byte[]{4, 3, -54, -2, 0, 50};
            ParameterMappingTest.setUnicodeStream(psi, 1, new ByteArrayInputStream(data), 6);
            if (JDBC.vmSupportsJDBC3()) {
                psi.executeUpdate();
                ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setUnicodeStream");
            }
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        if (JDBC.vmSupportsJDBC3()) {
            ParameterMappingTest.judge_setXXX(worked, sqleResult, 14, type);
        }
        ParameterMappingTest.setXXX_setObjectNullNoTypeSpec(s, psi, psq, type);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, validString[type], "java.lang.String", 0);
        if (HAVE_BIG_DECIMAL) {
            ParameterMappingTest.setXXX_setObject(s, psi, psq, type, BigDecimal.valueOf(98L), "java.math.BigDecimal", 1);
        }
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, Boolean.TRUE, "java.lang.Boolean", 2);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, (byte)98, "java.lang.Byte", 1);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, (short)98, "java.lang.Short", 2);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, 98, "java.lang.Integer", 3);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, 98, "java.lang.Long", 4);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, Float.valueOf(98.0f), "java.lang.Float", 5);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, 98.0, "java.lang.Double", 6);
        byte[] data2 = new byte[]{4, 3};
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, data2, "byte[]", 7);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, Date.valueOf("2004-02-14"), "java.sql.Date", 8);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, Time.valueOf("00:00:00"), "java.sql.Time", 9);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, Timestamp.valueOf("2004-02-14 00:00:00.0"), "java.sql.Timestamp", 10);
        s.getConnection().commit();
        ResultSet rsc2 = s.executeQuery("SELECT B FROM PM.LOB_GET WHERE ID = 1");
        rsc2.next();
        Object tester2 = rsc2.getBlob(1);
        rsc2.close();
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, tester2, "java.sql.Blob", 11);
        rsc2 = s.executeQuery("SELECT C FROM PM.LOB_GET WHERE ID = 1");
        rsc2.next();
        tester2 = rsc2.getClob(1);
        rsc2.close();
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, tester2, "java.sql.Clob", 12);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, new BigInteger(Long.toString(98L)), "java.math.BigInteger", 15);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, new java.util.Date(50L), "java.util.Date", 16);
        ParameterMappingTest.setXXX_setObject(s, psi, psq, type, ParameterMappingTest.makeCalendar(60L), "java.util.Calendar", 17);
    }

    private static void setUnicodeStream(PreparedStatement ps, int parameterIndex, InputStream stream, int length) throws SQLException {
        ps.setUnicodeStream(parameterIndex, stream, length);
    }

    private static void setXXX_setObject(Statement s, PreparedStatement psi, PreparedStatement psq, int type, Object value, String className, int b5o) throws SQLException, IOException {
        ParameterMappingTest.setXXX_setObject_doWork(s, psi, psq, type, value, className, b5o, false, false);
        ParameterMappingTest.setXXX_setObject_doWork(s, psi, psq, type, value, className, b5o, false, true);
        ParameterMappingTest.setXXX_setObject_doWork(s, psi, psq, type, value, className, b5o, true, false);
        ParameterMappingTest.setXXX_setObject_doWork(s, psi, psq, type, value, className, b5o, true, true);
    }

    private static void setXXX_setObject_doWork(Statement s, PreparedStatement psi, PreparedStatement psq, int type, Object value, String className, int b5o, boolean withTypeFlag, boolean batchExecution) throws SQLException, IOException {
        boolean worked;
        int jdbcType = jdbcTypes[type];
        String method = "setObject(" + className + ")";
        s.execute("DELETE FROM PM.TYPE_AS");
        SQLException sqleResult = null;
        try {
            if (withTypeFlag) {
                psi.setObject(1, value, jdbcType);
            } else {
                psi.setObject(1, value);
            }
            if (batchExecution) {
                psi.addBatch();
                psi.executeBatch();
            } else {
                psi.executeUpdate();
            }
            ParameterMappingTest.getValidValue(psq, jdbcType, method);
            worked = true;
        }
        catch (SQLException sqle) {
            sqleResult = sqle;
            worked = false;
        }
        ParameterMappingTest.judge_setObject(worked, sqleResult, b5o, type);
    }

    private static void setXXX_setObjectNullNoTypeSpec(Statement s, PreparedStatement psi, PreparedStatement psq, int type) throws SQLException, IOException {
        s.execute("DELETE FROM PM.TYPE_AS");
        psi.setObject(1, null);
        psi.executeUpdate();
        ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setObject");
        s.execute("DELETE FROM PM.TYPE_AS");
        psi.setObject(1, null);
        psi.addBatch();
        psi.executeBatch();
        ParameterMappingTest.getValidValue(psq, jdbcTypes[type], "setObject");
    }

    private static void showException(SQLException sqle) {
        String msg;
        String state = sqle.getSQLState();
        if (state == null) {
            state = "?????";
        }
        if ((msg = sqle.getMessage()) == null) {
            msg = "?? no message ??";
        }
        ParameterMappingTest.fail(" (" + state + "):" + msg, sqle);
    }

    private static boolean setValidValue(PreparedStatement ps, int param, int jdbcType) throws SQLException {
        switch (jdbcType) {
            case -7: 
            case 16: {
                ps.setBoolean(param, true);
                return true;
            }
            case -6: {
                ps.setByte(param, (byte)32);
                return true;
            }
            case 5: {
                ps.setShort(param, (short)32);
                return true;
            }
            case 4: {
                ps.setInt(param, 32);
                return true;
            }
            case -5: {
                ps.setLong(param, 32L);
                return true;
            }
            case 7: {
                ps.setFloat(param, 32.0f);
                return true;
            }
            case 6: 
            case 8: {
                ps.setDouble(param, 32.0);
                return true;
            }
            case 3: {
                BigDecimalHandler.setBigDecimalString(ps, param, "32.0");
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                ps.setString(param, "32");
                return true;
            }
            case -3: 
            case -2: {
                byte[] data = new byte[]{4, 3, -3, -61, 115};
                ps.setBytes(param, data);
                return true;
            }
            case 91: {
                ps.setDate(param, Date.valueOf("2004-02-14"));
                return true;
            }
            case 92: {
                ps.setTime(param, Time.valueOf("17:14:24"));
                return true;
            }
            case 93: {
                ps.setTimestamp(param, Timestamp.valueOf("2004-02-14 17:14:24.097625551"));
                return true;
            }
            case 2005: {
                ps.setCharacterStream(param, (Reader)new StringReader("67"), 2);
                return true;
            }
            case 2004: {
                byte[] data = new byte[]{-126, 67, -54, -2, 0, 50};
                ps.setBinaryStream(param, (InputStream)new ByteArrayInputStream(data), 6);
                return true;
            }
        }
        return false;
    }

    private static boolean getValidValue(PreparedStatement ps, int jdbcType, String method) throws SQLException, IOException {
        ResultSet rs = ps.executeQuery();
        rs.next();
        switch (jdbcType) {
            case 5: {
                short val = rs.getShort(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertEquals((int)0, (int)val);
                } else if (ParameterMappingTest.isBooleanMethod(method)) {
                    ParameterMappingTest.assertEquals((int)1, (int)val);
                } else {
                    ParameterMappingTest.assertEquals((int)98, (int)val);
                }
                return true;
            }
            case 4: {
                int val = rs.getInt(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertEquals((int)0, (int)val);
                } else if (ParameterMappingTest.isBooleanMethod(method)) {
                    ParameterMappingTest.assertEquals((int)1, (int)val);
                } else {
                    ParameterMappingTest.assertEquals((int)98, (int)val);
                }
                return true;
            }
            case -5: {
                long val = rs.getLong(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertEquals((long)0L, (long)val);
                } else if (ParameterMappingTest.isBooleanMethod(method)) {
                    ParameterMappingTest.assertEquals((long)1L, (long)val);
                } else {
                    ParameterMappingTest.assertEquals((long)98L, (long)val);
                }
                return true;
            }
            case 7: {
                float val = rs.getFloat(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertEquals((double)0.0, (double)val, (double)0.001);
                } else if (ParameterMappingTest.isBooleanMethod(method)) {
                    ParameterMappingTest.assertEquals((double)1.0, (double)val, (double)0.001);
                } else if (method.equals("setFloat")) {
                    ParameterMappingTest.assertEquals((double)98.4, (double)val, (double)0.001);
                } else if (method.equals("setDouble")) {
                    ParameterMappingTest.assertEquals((double)98.5, (double)val, (double)0.001);
                } else {
                    ParameterMappingTest.assertEquals((double)98.0, (double)val, (double)0.001);
                }
                return true;
            }
            case 6: 
            case 8: {
                double val = rs.getDouble(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertEquals((double)0.0, (double)val, (double)0.001);
                } else if (ParameterMappingTest.isBooleanMethod(method)) {
                    ParameterMappingTest.assertEquals((double)1.0, (double)val, (double)0.001);
                } else if (method.equals("setFloat")) {
                    ParameterMappingTest.assertEquals((double)98.4, (double)val, (double)0.001);
                } else if (method.equals("setDouble")) {
                    ParameterMappingTest.assertEquals((double)98.5, (double)val, (double)0.001);
                } else {
                    ParameterMappingTest.assertEquals((double)98.0, (double)val, (double)0.001);
                }
                return true;
            }
            case 3: {
                String val = BigDecimalHandler.getBigDecimalString(rs, 1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)val);
                } else if (ParameterMappingTest.isBooleanMethod(method)) {
                    ParameterMappingTest.assertEquals((String)"1.00000", (String)val);
                } else if (method.equals("setFloat")) {
                    ParameterMappingTest.assertEquals((String)"98.40000", (String)val);
                } else if (method.equals("setDouble")) {
                    ParameterMappingTest.assertEquals((String)"98.50000", (String)val);
                } else {
                    ParameterMappingTest.assertEquals((String)"98.00000", (String)val);
                }
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                String s = rs.getString(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)s);
                } else {
                    if (s.startsWith("com.ibm.db2.jcc.") || s.startsWith("org.apache.derby.client")) {
                        s = "<OBJECT.toString()>";
                    }
                    boolean hasNonAscii = false;
                    for (int si = 0; si < s.length(); ++si) {
                        char c = s.charAt(si);
                        if (c >= ' ' && c < '\u007f') continue;
                        hasNonAscii = true;
                        break;
                    }
                    if (hasNonAscii) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("EncodedString: >");
                        for (int si = 0; si < s.length(); ++si) {
                            sb.append(' ');
                            sb.append((int)s.charAt(si));
                        }
                        sb.append(" <");
                        s = sb.toString();
                    }
                    ParameterMappingTest.checkValidStringValue(method, s);
                }
                return true;
            }
            case -3: 
            case -2: {
                byte[] data = rs.getBytes(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)data);
                } else {
                    ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(data));
                }
                return true;
            }
            case -4: {
                InputStream is = rs.getBinaryStream(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)is);
                } else {
                    ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(is));
                }
                return true;
            }
            case 91: {
                Date d = rs.getDate(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)d);
                } else if (DATE_METHOD_NAME.equals(method)) {
                    ParameterMappingTest.assertEquals((String)new Date(50L).toString(), (String)d.toString());
                } else if (CALENDAR_METHOD_NAME.equals(method)) {
                    ParameterMappingTest.assertEquals((String)new Date(60L).toString(), (String)d.toString());
                } else {
                    ParameterMappingTest.assertEquals((Object)Date.valueOf("2004-02-14"), (Object)d);
                }
                return true;
            }
            case 92: {
                Time t = rs.getTime(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)t);
                } else if (DATE_METHOD_NAME.equals(method)) {
                    ParameterMappingTest.assertEquals((String)new Time(50L).toString(), (String)t.toString());
                } else if (CALENDAR_METHOD_NAME.equals(method)) {
                    ParameterMappingTest.assertEquals((String)new Time(60L).toString(), (String)t.toString());
                } else {
                    ParameterMappingTest.assertEquals((Object)Time.valueOf("00:00:00"), (Object)t);
                }
                return true;
            }
            case 93: {
                Timestamp ts = rs.getTimestamp(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)rs.getTimestamp(1));
                } else if (DATE_METHOD_NAME.equals(method)) {
                    ParameterMappingTest.assertEquals((String)new Timestamp(50L).toString(), (String)ts.toString());
                } else if (CALENDAR_METHOD_NAME.equals(method)) {
                    ParameterMappingTest.assertEquals((String)new Timestamp(60L).toString(), (String)ts.toString());
                } else {
                    ParameterMappingTest.assertEquals((Object)Timestamp.valueOf("2004-02-14 00:00:00.0"), (Object)ts);
                }
                return true;
            }
            case 2005: {
                Clob clob = rs.getClob(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)clob);
                } else {
                    char[] charray = new char[20];
                    int numchar = clob.getCharacterStream().read(charray);
                    String s = new String(charray, 0, numchar);
                    if ("setString".equals(method)) {
                        ParameterMappingTest.assertEquals((String)"98", (String)s);
                    } else if ("setAsciiStream".equals(method)) {
                        ParameterMappingTest.assertEquals((String)"eg012d", (String)s);
                    } else if ("setCharacterStream".equals(method)) {
                        ParameterMappingTest.assertEquals((String)"89", (String)s);
                    } else if ("setClob".equals(method)) {
                        ParameterMappingTest.assertEquals((String)"72", (String)s);
                    } else if ("setObject(java.lang.String)".equals(method)) {
                        ParameterMappingTest.assertEquals((String)"98", (String)s);
                    } else if ("setObject(java.lang.Clob)".equals(method)) {
                        ParameterMappingTest.assertEquals((String)"72", (String)s);
                    }
                }
                return true;
            }
            case 2004: {
                Blob blob = rs.getBlob(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertNull((Object)blob);
                } else {
                    ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(blob.getBinaryStream()));
                }
                return true;
            }
            case 16: {
                boolean b = rs.getBoolean(1);
                boolean wn = rs.wasNull();
                if (wn) {
                    ParameterMappingTest.assertFalse((boolean)b);
                } else {
                    ParameterMappingTest.assertTrue((boolean)b);
                }
                return true;
            }
        }
        ParameterMappingTest.fail((String)("FAIL JDBC TYPE IN getValidValue " + JDBC.sqlNameFromJdbc(jdbcType)));
        return false;
    }

    private static void checkValidStringValue(String method, String s) {
        s = s.trim();
        if (ParameterMappingTest.isBooleanMethod(method)) {
            ParameterMappingTest.assertEquals((String)"true", (String)s);
        } else if ("setBytes".equals(method) || "setObject(byte[])".equals(method)) {
            ParameterMappingTest.assertEquals((String)"EncodedString: > 1027 ", (String)s.substring(0, 22));
        } else if ("setFloat".equals(method)) {
            ParameterMappingTest.assertEquals((String)"98.4", (String)s);
        } else if ("setDouble".equals(method)) {
            ParameterMappingTest.assertEquals((String)"98.5", (String)s);
        } else if ("setDate".equals(method) || "setObject(java.sql.Date)".equals(method)) {
            ParameterMappingTest.assertEquals((String)"2004-02-14", (String)s);
        } else if ("setTime".equals(method) || "setObject(java.sql.Time)".equals(method)) {
            ParameterMappingTest.assertEquals((String)"00:00:00", (String)s);
        } else if ("setTimestamp".equals(method) || "setObject(java.sql.Timestamp)".equals(method)) {
            ParameterMappingTest.assertEquals((String)"2004-02-14 00:00:00.0", (String)s);
        } else if ("setAsciiStream".equals(method)) {
            ParameterMappingTest.assertEquals((String)"eg012d", (String)s);
        } else if ("setCharacterStream".equals(method)) {
            ParameterMappingTest.assertEquals((String)"89", (String)s);
        } else if ("setObject(java.lang.Float)".equals(method) || "setObject(java.lang.Double)".equals(method)) {
            ParameterMappingTest.assertEquals((String)"98.0", (String)s);
        } else if (DATE_METHOD_NAME.equals(method)) {
            ParameterMappingTest.assertEquals((String)new Timestamp(50L).toString(), (String)s);
        } else if (CALENDAR_METHOD_NAME.equals(method)) {
            ParameterMappingTest.assertEquals((String)new Timestamp(60L).toString(), (String)s);
        } else {
            ParameterMappingTest.assertEquals((String)"98", (String)s.trim());
        }
    }

    private static boolean isBooleanMethod(String method) {
        return method.equals("setBoolean") || method.equals("setObject(java.lang.Boolean)");
    }

    private static boolean getOutValue(CallableStatement cs, int param, int regJdbcType, int paramType) throws SQLException, IOException {
        int paramJdbcType = jdbcTypes[paramType];
        switch (regJdbcType) {
            case -7: 
            case 16: {
                boolean val = cs.getBoolean(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.assertTrue((boolean)val);
                }
                return true;
            }
            case -6: {
                byte val = cs.getByte(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 5: {
                short val = cs.getShort(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 4: {
                int val = cs.getInt(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case -5: {
                long val = cs.getLong(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 7: {
                float val = cs.getFloat(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 6: 
            case 8: {
                double val = cs.getDouble(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 3: {
                String val = BigDecimalHandler.getBigDecimalString(cs, param, regJdbcType);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                String val = cs.getString(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val.trim());
                }
                return true;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] data = cs.getBytes(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, data);
                }
                return true;
            }
            case 91: {
                Date val = cs.getDate(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 92: {
                Time val = cs.getTime(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 93: {
                Timestamp val = cs.getTimestamp(param);
                boolean wn = cs.wasNull();
                if (!wn) {
                    ParameterMappingTest.checkProcedureOutput(param, paramType, val);
                }
                return true;
            }
            case 2005: {
                Clob clob = cs.getClob(param);
                boolean wn = cs.wasNull();
                return true;
            }
            case 2004: {
                Blob blob = cs.getBlob(param);
                boolean wn = cs.wasNull();
                return true;
            }
        }
        ParameterMappingTest.fail((String)("FAIL JDBC TYPE IN getOutValue " + JDBC.sqlNameFromJdbc(regJdbcType)));
        return false;
    }

    private static void checkProcedureOutput(int param, int paramType, byte val) {
        ParameterMappingTest.checkProcedureOutput(param, paramType, (long)val);
    }

    private static void checkProcedureOutput(int param, int paramType, short val) {
        ParameterMappingTest.checkProcedureOutput(param, paramType, (long)val);
    }

    private static void checkProcedureOutput(int param, int paramType, int val) {
        ParameterMappingTest.checkProcedureOutput(param, paramType, (long)val);
    }

    private static void checkProcedureOutput(int param, int paramType, long val) {
        switch (jdbcTypes[paramType]) {
            case 5: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)38L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)77L, (long)val);
                break;
            }
            case 4: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)41L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)88L, (long)val);
                break;
            }
            case -5: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)40L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)99L, (long)val);
                break;
            }
            case 6: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)35L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)66L, (long)val);
                break;
            }
            case 7: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)41L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)88L, (long)val);
                break;
            }
            case 3: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)34L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)84L, (long)val);
                break;
            }
            case 8: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((long)35L, (long)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((long)66L, (long)val);
            }
        }
    }

    private static void checkProcedureOutput(int param, int paramType, float val) {
        ParameterMappingTest.checkProcedureOutput(param, paramType, (double)val);
    }

    private static void checkProcedureOutput(int param, int paramType, double val) {
        switch (jdbcTypes[paramType]) {
            case 5: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)38.0, (double)val, (double)1.0E-5);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)77.0, (double)val, (double)1.0E-5);
                break;
            }
            case 4: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)41.0, (double)val, (double)1.0E-5);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)88.0, (double)val, (double)1.0E-5);
                break;
            }
            case -5: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)40.0, (double)val, (double)1.0E-5);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)99.0, (double)val, (double)1.0E-5);
                break;
            }
            case 6: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)35.9, (double)val, (double)1.0E-5);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)66.8, (double)val, (double)1.0E-5);
                break;
            }
            case 7: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)41.9, (double)val, (double)1.0E-5);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)88.8, (double)val, (double)1.0E-5);
                break;
            }
            case 3: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)34.29999, (double)val, (double)1.0E-4);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)84.09999, (double)val, (double)1.0E-4);
                break;
            }
            case 8: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((double)35.9, (double)val, (double)1.0E-5);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((double)66.8, (double)val, (double)1.0E-5);
            }
        }
    }

    private static void checkProcedureOutput(int param, int paramType, String val) {
        switch (jdbcTypes[paramType]) {
            case 5: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"38", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"77", (String)val);
                break;
            }
            case 4: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"41", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"88", (String)val);
                break;
            }
            case -5: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"40", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"99", (String)val);
                break;
            }
            case 6: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"35.9", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"66.8", (String)val);
                break;
            }
            case 7: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"41.9", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"88.8", (String)val);
                break;
            }
            case 3: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"34.29999", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"84.09999", (String)val);
                break;
            }
            case 8: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"35.9", (String)val);
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"66.8", (String)val);
            }
        }
    }

    private static void checkProcedureOutput(int param, int paramType, byte[] val) {
        boolean isBlob;
        boolean bl = isBlob = jdbcTypes[paramType] == 2004;
        if (param == 2) {
            if (isBlob) {
                ParameterMappingTest.assertEquals((String)"0x82,0x43", (String)ParameterMappingTest.showFirstTwo(val));
            } else {
                ParameterMappingTest.assertEquals((String)"0x4,0x3", (String)ParameterMappingTest.showFirstTwo(val));
            }
        } else if (param == 3) {
            if (isBlob) {
                ParameterMappingTest.assertEquals((String)"0x1,0x2", (String)ParameterMappingTest.showFirstTwo(val));
            } else {
                ParameterMappingTest.assertEquals((String)"0x9,0xfe", (String)ParameterMappingTest.showFirstTwo(val));
            }
        }
    }

    private static void checkProcedureOutput(int param, int paramType, Date val) {
        switch (jdbcTypes[paramType]) {
            case 91: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"2004-03-08", (String)val.toString());
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"2005-03-08", (String)val.toString());
                break;
            }
            case 93: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"2004-03-12", (String)val.toString());
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"2004-04-12", (String)val.toString());
            }
        }
    }

    private static void checkProcedureOutput(int param, int paramType, Time val) {
        switch (jdbcTypes[paramType]) {
            case 92: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"19:44:42", (String)val.toString());
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"20:44:42", (String)val.toString());
                break;
            }
            case 93: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"21:14:24", (String)val.toString());
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"04:25:26", (String)val.toString());
            }
        }
    }

    private static void checkProcedureOutput(int param, int paramType, Timestamp val) {
        switch (jdbcTypes[paramType]) {
            case 91: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"2004-03-08 00:00:00.0", (String)val.toString());
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"2005-03-08 00:00:00.0", (String)val.toString());
                break;
            }
            case 92: {
                ParameterMappingTest.assertNotNull((Object)val);
                break;
            }
            case 93: {
                if (param == 2) {
                    ParameterMappingTest.assertEquals((String)"2004-03-12 21:14:24.938222433", (String)val.toString());
                    break;
                }
                if (param != 3) break;
                ParameterMappingTest.assertEquals((String)"2004-04-12 04:25:26.462983731", (String)val.toString());
            }
        }
    }

    static void dumpSQLExceptions(SQLException se) {
        while (se != null) {
            System.out.println("SQLSTATE(" + se.getSQLState() + "): " + se.toString());
            se = se.getNextException();
        }
    }

    private static void testSetStringInvalidValue(int type, PreparedStatement psi) {
        switch (jdbcTypes[type]) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return;
            }
        }
        String sqlType = SQLTypes[type];
        try {
            psi.setString(1, "Invalid Value");
            psi.executeUpdate();
            String string = "FAIL - setString(1,\"Invalld Value\") for type " + sqlType + " did not throw an exception as expected";
        }
        catch (SQLException sqle) {
            if (!("22018".equals(sqle.getSQLState()) || "XCL12".equals(sqle.getSQLState()) || "22007".equals(sqle.getSQLState()) || "22005".equals(sqle.getSQLState()) || sqle.getMessage().indexOf("Invalid data conversion") != -1 || sqle.getMessage().indexOf("Illegal Conversion") != -1)) {
                ParameterMappingTest.fail((String)("FAIL:" + sqle.getMessage()));
            }
        }
        catch (Exception e) {
            ParameterMappingTest.fail((String)("FAIL: Unexpected Exception " + e.getMessage()));
        }
    }

    private static String showFirstTwo(Reader in) throws IOException {
        int b1 = in.read();
        int b2 = in.read();
        in.close();
        return "0x" + Integer.toHexString(b1) + "," + "0x" + Integer.toHexString(b2);
    }

    private static String showFirstTwo(InputStream in) throws IOException {
        int b1 = in.read();
        int b2 = in.read();
        in.close();
        return "0x" + Integer.toHexString(b1) + "," + "0x" + Integer.toHexString(b2);
    }

    private static String showFirstTwo(byte[] data) {
        byte b1 = data[0];
        byte b2 = data[1];
        return "0x" + Integer.toHexString(b1 & 0xFF) + "," + "0x" + Integer.toHexString(b2 & 0xFF);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ParameterMappingTest.class);
    }

    public static void pmap(short in, short[] inout, short[] out) {
        inout[0] = (short)(inout[0] + 6);
        out[0] = 77;
    }

    public static void pmap(int in, int[] inout, int[] out) {
        inout[0] = inout[0] + 9;
        out[0] = 88;
    }

    public static void pmap(boolean in, boolean[] inout, boolean[] out) {
        inout[0] = true;
        out[0] = true;
    }

    public static void pmap(long in, long[] inout, long[] out) {
        inout[0] = inout[0] + 8L;
        out[0] = 99L;
    }

    public static void pmap(float in, float[] inout, float[] out) {
        inout[0] = inout[0] + 9.9f;
        out[0] = 88.8f;
    }

    public static void pmap(double in, double[] inout, double[] out) {
        inout[0] = inout[0] + 3.9;
        out[0] = 66.8;
    }

    public static void pmap(byte[] in, byte[][] inout, byte[][] out) {
        inout[0][2] = 86;
        out[0] = new byte[4];
        out[0][0] = 9;
        out[0][1] = -2;
        out[0][2] = -19;
        out[0][3] = 2;
    }

    public static void pmap(Date in, Date[] inout, Date[] out) {
        inout[0] = Date.valueOf("2004-03-08");
        out[0] = Date.valueOf("2005-03-08");
    }

    public static void pmap(Time in, Time[] inout, Time[] out) {
        inout[0] = Time.valueOf("19:44:42");
        out[0] = Time.valueOf("20:44:42");
    }

    public static void pmap(Timestamp in, Timestamp[] inout, Timestamp[] out) {
        inout[0] = Timestamp.valueOf("2004-03-12 21:14:24.938222433");
        out[0] = Timestamp.valueOf("2004-04-12 04:25:26.462983731");
    }

    public static void pmap(String in, String[] inout, String[] out) {
        inout[0] = inout[0].trim().concat("P2-PMAP");
        out[0] = "P3-PMAP";
    }

    public static void pmap(BigDecimal in, BigDecimal[] inout, BigDecimal[] out) {
        inout[0] = inout[0].add(new BigDecimal(2.3));
        out[0] = new BigDecimal(84.1);
    }

    public static void pmap(Blob in, Blob[] inout, Blob[] out) throws SQLException {
        int leftLength = (int)in.length();
        int rightLength = (int)inout[0].length();
        byte[] left = in.getBytes(1L, leftLength);
        byte[] right = inout[0].getBytes(1L, rightLength);
        byte[] retval = new byte[leftLength + rightLength];
        System.arraycopy(left, 0, retval, 0, leftLength);
        System.arraycopy(right, 0, retval, leftLength, rightLength);
        inout[0] = new HarmonySerialBlob(retval);
        out[0] = new HarmonySerialBlob(new byte[]{1, 2, 3});
    }

    public static void pmap(Clob in, Clob[] inout, Clob[] out) throws SQLException {
        inout[0] = new HarmonySerialClob(in.getSubString(1L, (int)in.length()) + inout[0].getSubString(1L, (int)inout[0].length()));
        out[0] = new HarmonySerialClob("abc");
    }

    public static void clobIn(Clob c, String[] result) throws SQLException {
        result[0] = ParameterMappingTest.getClobValue(c);
    }

    public static void clobOut(Clob[] c) throws SQLException {
        c[0] = new HarmonySerialClob("abc");
    }

    public static void clobInOut(Clob[] c) throws SQLException {
        String value = ParameterMappingTest.getClobValue(c[0]);
        char[] inValue = value.toCharArray();
        char[] outValue = ParameterMappingTest.reverse(inValue);
        c[0] = new HarmonySerialClob(new String(outValue));
    }

    private static String getClobValue(Clob c) throws SQLException {
        return c.getSubString(1L, (int)c.length());
    }

    private static char[] reverse(char[] in) {
        int count = in.length;
        char[] retval = new char[count];
        for (int i = 0; i < count; ++i) {
            retval[i] = in[count - i - 1];
        }
        return retval;
    }

    public static void blobIn(Blob c, String[] result) throws Exception {
        result[0] = ParameterMappingTest.getBlobValue(c);
    }

    public static void blobOut(Blob[] c) throws Exception {
        c[0] = new HarmonySerialBlob("abc".getBytes(UTF8));
    }

    public static void blobInOut(Blob[] c) throws Exception {
        String value = ParameterMappingTest.getBlobValue(c[0]);
        char[] inValue = value.toCharArray();
        char[] outValue = ParameterMappingTest.reverse(inValue);
        c[0] = new HarmonySerialBlob(new String(outValue).getBytes(UTF8));
    }

    private static String getBlobValue(Blob c) throws Exception {
        byte[] bytes = c.getBytes(1L, (int)c.length());
        return new String(bytes, UTF8);
    }

    @Override
    protected PreparedStatement chattyPrepare(Connection conn, String text) throws SQLException {
        ParameterMappingTest.println("Preparing statement:\n\t" + text);
        return conn.prepareStatement(text);
    }

    @Override
    protected CallableStatement chattyPrepareCall(Connection conn, String text) throws SQLException {
        ParameterMappingTest.println("Preparing statement:\n\t" + text);
        return conn.prepareCall(text);
    }

    @Override
    protected void expectCompilationError(String sqlState, String query) {
        ParameterMappingTest.println("\nExpecting " + sqlState + " when preparing:\n\t" + query);
        this.assertCompileError(sqlState, query);
    }

    public void testDerby5533GetXXX() throws SQLException {
        String createTableString = "CREATE TABLE MultiTypeTable (F01 SMALLINT,F02 INTEGER,F03 BIGINT,F04 REAL,F05 FLOAT,F06 DOUBLE,F07 DECIMAL(31),F08 NUMERIC,F09 CHAR(100),F10 VARCHAR(256),F11 BOOLEAN)";
        Statement stmt = this.createStatement();
        stmt.executeUpdate(createTableString);
        PreparedStatement ps = this.prepareStatement("insert into MultiTypeTable values(?,?,?,?,?,?,?,?,?,?,?)");
        ps.setShort(1, (short)128);
        ps.setInt(2, 32768);
        ps.setLong(3, 0x80000000L);
        ps.setFloat(4, 9.223372E19f);
        ps.setFloat(5, 9.223372E19f);
        ps.setDouble(6, 3.4028234663852886E39);
        ps.setBigDecimal(7, new BigDecimal("9999999999999999999999999999999"));
        ps.setInt(8, -1);
        ps.setString(9, " ");
        ps.setString(10, " ");
        ps.setBoolean(11, true);
        ps.executeUpdate();
        PreparedStatement plainSelect = this.prepareStatement("select * from MultiTypeTable");
        ResultSet rs = plainSelect.executeQuery();
        rs.next();
        this.assertGetState(rs, "F01", 0, WONT_FIT);
        this.assertGetState(rs, "F02", 0, WONT_FIT);
        this.assertGetState(rs, "F03", 0, WONT_FIT);
        this.assertGetState(rs, "F04", 0, WONT_FIT);
        this.assertGetState(rs, "F05", 0, WONT_FIT);
        this.assertGetState(rs, "F06", 0, WONT_FIT);
        this.assertGetState(rs, "F07", 0, WONT_FIT);
        this.assertGetState(rs, "F02", 1, WONT_FIT);
        this.assertGetState(rs, "F03", 1, WONT_FIT);
        this.assertGetState(rs, "F04", 1, WONT_FIT);
        this.assertGetState(rs, "F05", 1, WONT_FIT);
        this.assertGetState(rs, "F06", 1, WONT_FIT);
        this.assertGetState(rs, "F07", 1, WONT_FIT);
        this.assertGetState(rs, "F03", 2, WONT_FIT);
        this.assertGetState(rs, "F04", 2, WONT_FIT);
        this.assertGetState(rs, "F05", 2, WONT_FIT);
        this.assertGetState(rs, "F06", 2, WONT_FIT);
        this.assertGetState(rs, "F07", 2, WONT_FIT);
        this.assertGetState(rs, "F04", 3, WONT_FIT);
        this.assertGetState(rs, "F05", 3, WONT_FIT);
        this.assertGetState(rs, "F06", 3, WONT_FIT);
        this.assertGetState(rs, "F07", 3, WONT_FIT);
        rs.close();
        PreparedStatement uSelect = this.prepareStatement("SELECT * FROM MultiTypeTable", 1003, 1008);
        rs = uSelect.executeQuery();
        rs.next();
        rs.updateDouble("F06", 3.4028234663852886E39);
        rs.updateRow();
        rs = plainSelect.executeQuery();
        rs.next();
        this.assertGetState(rs, "F06", 4, WONT_FIT);
        PreparedStatement psDelete = this.prepareStatement("delete from MultiTypeTable");
        psDelete.executeUpdate();
        ps.setShort(1, (short)-129);
        ps.setInt(2, -32769);
        ps.setLong(3, -2147483649L);
        ps.setFloat(4, -9.223372E19f);
        ps.setFloat(5, -9.223372E19f);
        ps.setDouble(6, -3.4028234663852886E39);
        ps.setBigDecimal(7, new BigDecimal("-999999999999999999999999999999"));
        ps.setInt(8, -1);
        ps.setString(9, " ");
        ps.setString(10, " ");
        ps.setBoolean(11, false);
        ps.executeUpdate();
        rs = plainSelect.executeQuery();
        rs.next();
        this.assertGetState(rs, "F01", 0, WONT_FIT);
        this.assertGetState(rs, "F02", 0, WONT_FIT);
        this.assertGetState(rs, "F03", 0, WONT_FIT);
        this.assertGetState(rs, "F04", 0, WONT_FIT);
        this.assertGetState(rs, "F05", 0, WONT_FIT);
        this.assertGetState(rs, "F06", 0, WONT_FIT);
        this.assertGetState(rs, "F07", 0, WONT_FIT);
        this.assertGetState(rs, "F02", 1, WONT_FIT);
        this.assertGetState(rs, "F03", 1, WONT_FIT);
        this.assertGetState(rs, "F04", 1, WONT_FIT);
        this.assertGetState(rs, "F05", 1, WONT_FIT);
        this.assertGetState(rs, "F06", 1, WONT_FIT);
        this.assertGetState(rs, "F07", 1, WONT_FIT);
        this.assertGetState(rs, "F03", 2, WONT_FIT);
        this.assertGetState(rs, "F04", 2, WONT_FIT);
        this.assertGetState(rs, "F05", 2, WONT_FIT);
        this.assertGetState(rs, "F06", 2, WONT_FIT);
        this.assertGetState(rs, "F07", 2, WONT_FIT);
        this.assertGetState(rs, "F04", 3, WONT_FIT);
        this.assertGetState(rs, "F05", 3, WONT_FIT);
        this.assertGetState(rs, "F06", 3, WONT_FIT);
        rs.close();
        rs = uSelect.executeQuery();
        rs.next();
        rs.updateDouble("F06", -3.4028234663852886E39);
        rs.updateRow();
        rs = plainSelect.executeQuery();
        rs.next();
        this.assertGetState(rs, "F06", 4, WONT_FIT);
    }

    public void testDerby5533UpdateXXX() throws SQLException {
        String createTableString = "CREATE TABLE MultiTypeTable (F01 SMALLINT,F02 INTEGER,F03 BIGINT,F04 REAL,F05 FLOAT,F06 DOUBLE,F07 DECIMAL(31),F08 NUMERIC,F09 CHAR(100),F10 VARCHAR(256),F11 BOOLEAN)";
        Statement stmt = this.createStatement();
        stmt.executeUpdate(createTableString);
        PreparedStatement ps = this.prepareStatement("insert into MultiTypeTable values(?,?,?,?,?,?,?,?,?,?,?)");
        PreparedStatement psDelete = this.prepareStatement("delete from MultiTypeTable");
        ps.setShort(1, (short)1);
        ps.setInt(2, 1);
        ps.setLong(3, 1L);
        ps.setFloat(4, 1.0f);
        ps.setDouble(5, 1.0);
        ps.setDouble(6, 1.0);
        ps.setString(7, "1");
        ps.setString(8, "1");
        ps.setString(9, "1");
        ps.setString(10, "1");
        ps.setBoolean(11, true);
        ps.executeUpdate();
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery("SELECT * FROM MultiTypeTable");
        rs.next();
        this.assertUpdateState(rs, "F01", 32768L, -1.0, 2, WONT_FIT);
        this.assertUpdateState(rs, "F01", -1L, 32768.0, 5, WONT_FIT);
        this.assertUpdateState(rs, "F01", 32768L, -1.0, 3, WONT_FIT);
        this.assertUpdateState(rs, "F01", -1L, 32768.0, 4, WONT_FIT);
        this.assertUpdateState(rs, "F01", bdMaxShortValue.add(BigDecimal.ONE), WONT_FIT);
        this.assertUpdateState(rs, "F01", -32769L, -1.0, 2, WONT_FIT);
        this.assertUpdateState(rs, "F01", -1L, -32769.0, 5, WONT_FIT);
        this.assertUpdateState(rs, "F01", -32769L, -1.0, 3, WONT_FIT);
        this.assertUpdateState(rs, "F01", -1L, -32769.0, 4, WONT_FIT);
        this.assertUpdateState(rs, "F01", bdMinShortValue.subtract(BigDecimal.ONE), WONT_FIT);
        this.assertUpdateState(rs, "F02", 0x80000000L, -1.0, 3, WONT_FIT);
        this.assertUpdateState(rs, "F02", -1L, 2.147483648E10, 4, WONT_FIT);
        this.assertUpdateState(rs, "F02", -1L, 2.147483647E10, 5, WONT_FIT);
        this.assertUpdateState(rs, "F02", bdMaxIntValue.add(BigDecimal.ONE), WONT_FIT);
        this.assertUpdateState(rs, "F02", -2147483649L, -1.0, 3, WONT_FIT);
        this.assertUpdateState(rs, "F02", -1L, -2.147483648E10, 4, WONT_FIT);
        this.assertUpdateState(rs, "F02", -1L, -2.147483648E10, 5, WONT_FIT);
        this.assertUpdateState(rs, "F02", bdMinIntValue.subtract(BigDecimal.ONE), WONT_FIT);
        this.assertUpdateState(rs, "F03", -1L, 9.223372036854776E19, 4, WONT_FIT);
        this.assertUpdateState(rs, "F03", -1L, 9.223372036854776E19, 5, WONT_FIT);
        this.assertUpdateState(rs, "F03", bdMaxLongValue.add(BigDecimal.ONE), WONT_FIT);
        this.assertUpdateState(rs, "F03", -1L, -9.223372036854776E19, 4, WONT_FIT);
        this.assertUpdateState(rs, "F03", -1L, -9.223372036854776E19, 5, WONT_FIT);
        this.assertUpdateState(rs, "F03", bdMinLongValue.subtract(BigDecimal.ONE), WONT_FIT);
        Float maxF = Float.valueOf(Float.MAX_VALUE);
        this.assertUpdateState(rs, "F04", -1L, maxF.doubleValue() * 10.0, 5, WONT_FIT);
        this.assertUpdateState(rs, "F04", -1L, Double.NEGATIVE_INFINITY, 4, WONT_FIT);
        this.assertUpdateState(rs, "F04", bdMaxFloatValue.multiply(BigDecimal.TEN), WONT_FIT);
        this.assertUpdateState(rs, "F04", -1L, -maxF.doubleValue() * 10.0, 5, WONT_FIT);
        this.assertUpdateState(rs, "F04", -1L, Double.POSITIVE_INFINITY, 4, WONT_FIT);
        this.assertUpdateState(rs, "F04", -1L, Double.NEGATIVE_INFINITY, 4, WONT_FIT);
        this.assertUpdateState(rs, "F04", bdMinFloatValue.multiply(BigDecimal.TEN), WONT_FIT);
        this.assertUpdateOK(rs, "F04", -1L, 1.4E-45f, 4);
        this.assertUpdateOK(rs, "F04", -1L, -1.4E-45f, 4);
        if (ParameterMappingTest.usingEmbedded()) {
            this.assertUpdateState(rs, "F04", -1L, Double.NaN, 4, WONT_FIT);
            this.assertUpdateState(rs, "F04", -1L, Double.MIN_VALUE, 5, WONT_FIT);
            this.assertUpdateState(rs, "F04", -1L, -4.9E-324, 5, WONT_FIT);
        }
        if (ParameterMappingTest.usingEmbedded()) {
            this.assertUpdateState(rs, "F04", bdSmallestPosDoubleValue, WONT_FIT);
            this.assertUpdateState(rs, "F04", bdSmallestNegDoubleValue, WONT_FIT);
        }
        String[] dfCols = new String[]{"F05", "F06"};
        for (int i = 0; i < 2; ++i) {
            this.assertUpdateState(rs, dfCols[i], -1L, Double.POSITIVE_INFINITY, 4, WONT_FIT);
            this.assertUpdateState(rs, dfCols[i], -1L, Double.POSITIVE_INFINITY, 5, WONT_FIT);
            this.assertUpdateState(rs, dfCols[i], bdMaxDoubleValue.multiply(BigDecimal.TEN), WONT_FIT);
            this.assertUpdateState(rs, dfCols[i], -1L, Double.NEGATIVE_INFINITY, 4, WONT_FIT);
            this.assertUpdateState(rs, dfCols[i], -1L, Double.NEGATIVE_INFINITY, 5, WONT_FIT);
            this.assertUpdateState(rs, dfCols[i], bdMinDoubleValue.multiply(BigDecimal.TEN), WONT_FIT);
            if (ParameterMappingTest.usingEmbedded()) {
                this.assertUpdateState(rs, dfCols[i], -1L, Double.NaN, 5, WONT_FIT);
            }
            if (ParameterMappingTest.usingEmbedded()) {
                this.assertUpdateState(rs, dfCols[i], bdSmallestPosDoubleValue.divide(BigDecimal.TEN), WONT_FIT);
                this.assertUpdateState(rs, dfCols[i], bdSmallestNegDoubleValue.divide(BigDecimal.TEN), WONT_FIT);
            }
            this.assertUpdateOK(rs, dfCols[i], -1L, Double.MIN_VALUE, 5);
            this.assertUpdateOK(rs, dfCols[i], -1L, -4.9E-324, 5);
        }
    }

    public void testDerby5536() throws SQLException {
        BigDecimal[] vBelow = new BigDecimal[]{new BigDecimal(123456789012345678L), new BigDecimal(-12345678901234567L)};
        BigDecimal[] vAbove = new BigDecimal[]{new BigDecimal(1234567890123456789L), new BigDecimal(-123456789012345678L)};
        this.createStatement().executeUpdate("create table t5536(d1 decimal(19,1),                   d2 decimal(20,1),                   i int generated always as identity                         (start with 1, increment by 1))");
        PreparedStatement ps5536 = this.prepareStatement("insert into t5536 values (?, ?, default)");
        for (int scale = 0; scale < 2; ++scale) {
            for (int i = 0; i < vBelow.length; ++i) {
                ps5536.setBigDecimal(1, new BigDecimal(vBelow[i].toBigInteger(), scale));
                ps5536.setBigDecimal(2, new BigDecimal(vAbove[i].toBigInteger(), scale));
                ps5536.execute();
            }
        }
        ResultSet rs = this.createStatement().executeQuery("select * from t5536 order by i");
        BigDecimal[] divisor = new BigDecimal[]{BigDecimal.ONE, BigDecimal.TEN};
        for (int scale = 0; scale < 2; ++scale) {
            for (int i = 0; i < vBelow.length; ++i) {
                rs.next();
                ParameterMappingTest.assertEquals((String)"round-trip conversion error", (long)vBelow[i].divide(divisor[scale], RoundingMode.DOWN).longValue(), (long)rs.getLong(1));
                ParameterMappingTest.assertEquals((String)"round-trip conversion error", (long)vAbove[i].divide(divisor[scale], RoundingMode.DOWN).longValue(), (long)rs.getLong(2));
            }
        }
        rs.close();
    }

    private void assertUpdateState(ResultSet rs, String colName, BigDecimal value, String expected) throws SQLException {
        try {
            rs.updateBigDecimal(colName, value);
            ParameterMappingTest.fail((String)"exception expected");
        }
        catch (SQLException e) {
            ParameterMappingTest.println(e.toString());
            ParameterMappingTest.assertSQLState(expected, e);
        }
    }

    private void assertUpdateOK(ResultSet rs, String colName, long value, double dvalue, int updateType) throws SQLException {
        this.assertUpdateState(rs, colName, value, dvalue, updateType, null);
    }

    private void assertUpdateState(ResultSet rs, String colName, long value, double dvalue, int updateType, String expected) throws SQLException {
        try {
            switch (updateType) {
                case 0: {
                    rs.updateByte(colName, (byte)value);
                    break;
                }
                case 1: {
                    rs.updateShort(colName, (short)value);
                }
                case 2: {
                    rs.updateInt(colName, (int)value);
                    break;
                }
                case 3: {
                    rs.updateLong(colName, value);
                    break;
                }
                case 4: {
                    rs.updateFloat(colName, (float)dvalue);
                    break;
                }
                case 5: {
                    rs.updateDouble(colName, dvalue);
                    break;
                }
                default: {
                    ParameterMappingTest.fail((String)"wrong argument");
                }
            }
            if (expected != null) {
                ParameterMappingTest.fail((String)"exception expected");
            }
        }
        catch (SQLException e) {
            if (expected == null) {
                throw e;
            }
            ParameterMappingTest.println(e.toString());
            ParameterMappingTest.assertSQLState(expected, e);
        }
    }

    private void assertGetState(ResultSet rs, String colName, int getType, String expected) throws SQLException {
        try {
            switch (getType) {
                case 0: {
                    rs.getByte(colName);
                    break;
                }
                case 1: {
                    rs.getShort(colName);
                    break;
                }
                case 2: {
                    rs.getInt(colName);
                    break;
                }
                case 3: {
                    rs.getLong(colName);
                    break;
                }
                case 4: {
                    rs.getFloat(colName);
                    break;
                }
                case 5: {
                    rs.getDouble(colName);
                    break;
                }
                default: {
                    ParameterMappingTest.fail((String)"wrong argument");
                }
            }
            ParameterMappingTest.fail((String)"exception expected");
        }
        catch (SQLException e) {
            ParameterMappingTest.println(e.toString());
            ParameterMappingTest.assertSQLState(expected, e);
        }
    }

    private static boolean compareClobReader2CharArray(char[] cArray, Reader charReader) throws Exception {
        char[] clobChars = new char[cArray.length];
        int readChars = 0;
        int totalCharsRead = 0;
        do {
            if ((readChars = charReader.read(clobChars, totalCharsRead, cArray.length - totalCharsRead)) == -1) continue;
            totalCharsRead += readChars;
        } while (readChars != -1 && totalCharsRead < cArray.length);
        charReader.close();
        return Arrays.equals(cArray, clobChars);
    }

    public void testUpdateSetCharacterStreamClob() throws Exception {
        this.helperTestClobOrVarchar(true);
    }

    public void testUpdateSetCharacterStreamVarchar() throws Exception {
        this.helperTestClobOrVarchar(false);
    }

    private void helperTestClobOrVarchar(boolean testCLOB) throws Exception {
        Statement s = this.createStatement();
        this.dropTable("TESTUPDATECHARSTREAM");
        s.executeUpdate("CREATE TABLE TestUpdateCharStream (c1 VARCHAR(64) NOT NULL, c2 INTEGER, c3 CLOB, c4 VARCHAR(32000))");
        s.executeUpdate("INSERT INTO TestUpdateCharStream (c1, c2) VALUES ('AAAAA', 1)");
        s.executeUpdate("INSERT INTO TestUpdateCharStream (c1, c2) VALUES ('EEEEE', 1)");
        this.helperTestDerby6237(1, 1, testCLOB);
        this.helperTestDerby6237(1, 2, testCLOB);
        if (!testCLOB) {
            this.helperTestDerby6237(2, 1, testCLOB);
        }
        if (!testCLOB) {
            this.helperTestDerby6237(2, 2, testCLOB);
        }
        this.dropTable("TESTUPDATECHARSTREAM");
        s.close();
    }

    private void helperTestDerby6237(int numberOfRowsToUpdate, int testVariation, boolean testCLOB) throws Exception {
        CharAlphabet a1 = CharAlphabet.singleChar('a');
        PreparedStatement ps = this.prepareStatement("UPDATE TestUpdateCharStream SET " + (testCLOB ? "c3" : "c4") + " = ?, " + "c2 = c2 + 1 WHERE c1 IN (?, ?)");
        switch (testVariation) {
            case 1: {
                ps.setCharacterStream(1, (Reader)new LoopingAlphabetReader(50L, a1), 50);
                break;
            }
            case 2: {
                if (testCLOB) {
                    ps.setCharacterStream(1, (Reader)new LoopingAlphabetReader(50000L, a1), 50000);
                    break;
                }
                ps.setCharacterStream(1, (Reader)new LoopingAlphabetReader(32000L, a1), 32000);
            }
        }
        ps.setCharacterStream(2, (Reader)new CharArrayReader("AAAAA".toCharArray()), 5);
        if (numberOfRowsToUpdate == 1) {
            ps.setObject(3, (Object)"AAAAA", 12);
        } else {
            ps.setObject(3, (Object)"EEEEE", 12);
        }
        ps.execute();
        ps = this.prepareStatement("select " + (testCLOB ? "c3 " : "c4 ") + "from TestUpdateCharStream " + "WHERE c1 IN (?, ?)");
        ps.setCharacterStream(1, (Reader)new CharArrayReader("AAAAA".toCharArray()), 5);
        if (numberOfRowsToUpdate == 1) {
            ps.setObject(2, (Object)"AAAAA", 12);
        } else {
            ps.setObject(2, (Object)"EEEEE", 12);
        }
        ResultSet rs = ps.executeQuery();
        char[] c = testVariation == 1 ? new char[50] : (testCLOB ? new char[50000] : new char[32000]);
        Arrays.fill(c, 'a');
        for (int i = 0; i < numberOfRowsToUpdate; ++i) {
            rs.next();
            if (ParameterMappingTest.compareClobReader2CharArray(c, rs.getCharacterStream(1))) continue;
            System.out.println("FAIL: " + (testCLOB ? "CLOB " : "VARCHAR ") + "data should have matched");
            rs.close();
            ps.close();
            return;
        }
        rs.close();
        ps.close();
    }
}

