/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.derby.tools.ij;

public class SetQueryTimeoutTest {
    private static final int TIMEOUT = 1;
    private static final int CONNECTIONS = 100;

    private static void printSQLException(SQLException e) {
        while (e != null) {
            e.printStackTrace();
            e = e.getNextException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exec(Connection connection, String queryString, Collection ignoreExceptions) throws TestFailedException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(queryString);
        }
        catch (SQLException e) {
            String sqlState = e.getSQLState();
            if (!ignoreExceptions.contains(sqlState)) {
                throw new TestFailedException(e);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ee) {
                    throw new TestFailedException(ee);
                }
            }
        }
    }

    private static void exec(Connection connection, String queryString) throws TestFailedException {
        SetQueryTimeoutTest.exec(connection, queryString, Collections.EMPTY_SET);
    }

    private static void dropTables(Connection conn, String tablePrefix) throws TestFailedException {
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("42Y55");
        SetQueryTimeoutTest.exec(conn, "drop table " + tablePrefix + "_orig", ignore);
        SetQueryTimeoutTest.exec(conn, "drop table " + tablePrefix + "_copy", ignore);
    }

    private static void prepareTables(Connection conn, String tablePrefix) throws TestFailedException {
        System.out.println("Initializing tables with prefix " + tablePrefix);
        SetQueryTimeoutTest.dropTables(conn, tablePrefix);
        SetQueryTimeoutTest.exec(conn, "create table " + tablePrefix + "_orig (a int)");
        SetQueryTimeoutTest.exec(conn, "create table " + tablePrefix + "_copy (a int)");
        SetQueryTimeoutTest.exec(conn, "insert into " + tablePrefix + "_orig" + " values(0),(1),(2),(3),(4),(5),(6)");
    }

    public static int delay(int seconds, int value) throws SQLException {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value;
    }

    private static void prepareForTimedQueries(Connection conn) throws TestFailedException {
        System.out.println("Preparing for testing queries with timeout");
        try {
            conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new TestFailedException("Should not happen", e);
        }
        try {
            SetQueryTimeoutTest.exec(conn, "DROP FUNCTION DELAY");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SetQueryTimeoutTest.exec(conn, "CREATE FUNCTION DELAY(SECONDS INTEGER, VALUE INTEGER) RETURNS INTEGER PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.jdbcapi.SetQueryTimeoutTest.delay'");
        SetQueryTimeoutTest.prepareTables(conn, "t");
    }

    private static String getFetchQuery(String tablePrefix) {
        return "select a from " + tablePrefix + "_orig where mod(DELAY(1,a),3)=0";
    }

    private static String getExecQuery(String tablePrefix) {
        return "insert into " + tablePrefix + "_copy select a from " + tablePrefix + "_orig where DELAY(1,1)=1";
    }

    private static void expectException(String expectSqlState, SQLException sqlException, String failMsg) throws TestFailedException {
        if (sqlException == null) {
            throw new TestFailedException(failMsg);
        }
        String sqlState = sqlException.getSQLState();
        if (!expectSqlState.equals(sqlState)) {
            throw new TestFailedException(sqlException);
        }
    }

    private static PreparedStatement prepare(Connection conn, String query) throws TestFailedException {
        try {
            return conn.prepareStatement(query);
        }
        catch (SQLException e) {
            throw new TestFailedException(e);
        }
    }

    private static void testTimeoutWithFetch(Connection conn1, Connection conn2) throws TestFailedException {
        int i;
        System.out.println("Testing timeout with fetch operations");
        try {
            conn1.setAutoCommit(false);
            conn2.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new TestFailedException("Should not happen", e);
        }
        PreparedStatement statementA = SetQueryTimeoutTest.prepare(conn1, SetQueryTimeoutTest.getFetchQuery("t"));
        PreparedStatement statementB = SetQueryTimeoutTest.prepare(conn1, SetQueryTimeoutTest.getFetchQuery("t"));
        PreparedStatement statementC = SetQueryTimeoutTest.prepare(conn2, SetQueryTimeoutTest.getFetchQuery("t"));
        PreparedStatement statementD = SetQueryTimeoutTest.prepare(conn2, SetQueryTimeoutTest.getFetchQuery("t"));
        StatementExecutor[] statementExecutor = new StatementExecutor[]{new StatementExecutor(statementA, true, 1), new StatementExecutor(statementB, true, 0), new StatementExecutor(statementC, true, 0), new StatementExecutor(statementD, true, 0)};
        for (i = 3; i >= 0; --i) {
            statementExecutor[i].start();
        }
        for (i = 0; i < 4; ++i) {
            try {
                statementExecutor[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new TestFailedException("Should never happen", e);
            }
        }
        SetQueryTimeoutTest.expectException("XCL52", statementExecutor[0].getSQLException(), "fetch did not time out. Highest execution time: " + statementExecutor[0].getHighestRunTime() + " ms");
        System.out.println("Statement 0 timed out");
        for (i = 1; i < 4; ++i) {
            SQLException sqlException = statementExecutor[i].getSQLException();
            if (sqlException != null) {
                throw new TestFailedException("Unexpected exception in " + i, sqlException);
            }
            System.out.println("Statement " + i + " completed");
        }
        try {
            statementA.close();
            statementB.close();
            statementC.close();
            statementD.close();
            conn1.commit();
            conn2.commit();
        }
        catch (SQLException e) {
            throw new TestFailedException(e);
        }
    }

    private static void testTimeoutWithExec(Connection[] connections) throws TestFailedException {
        int timeout;
        int i;
        System.out.println("Testing timeout with an execute operation");
        for (int i2 = 0; i2 < connections.length; ++i2) {
            try {
                connections[i2].setAutoCommit(true);
                continue;
            }
            catch (SQLException e) {
                throw new TestFailedException("Should not happen", e);
            }
        }
        PreparedStatement[] statements = new PreparedStatement[connections.length];
        for (int i3 = 0; i3 < statements.length; ++i3) {
            statements[i3] = SetQueryTimeoutTest.prepare(connections[i3], SetQueryTimeoutTest.getExecQuery("t"));
        }
        StatementExecutor[] executors = new StatementExecutor[statements.length];
        for (i = 0; i < executors.length; ++i) {
            timeout = i % 2 == 0 ? 1 : 0;
            executors[i] = new StatementExecutor(statements[i], false, timeout);
        }
        for (i = 0; i < executors.length; ++i) {
            executors[i].start();
        }
        for (i = 0; i < executors.length; ++i) {
            try {
                executors[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new TestFailedException("Should never happen", e);
            }
        }
        for (i = 0; i < executors.length; ++i) {
            int n = timeout = i % 2 == 0 ? 1 : 0;
            if (timeout > 0) {
                SetQueryTimeoutTest.expectException("XCL52", executors[i].getSQLException(), "exec did not time out. Execution time: " + executors[i].getHighestRunTime() + " ms");
                continue;
            }
            SQLException sqlException = executors[i].getSQLException();
            if (sqlException == null) continue;
            throw new TestFailedException(sqlException);
        }
        System.out.println("Statements that should time out timed out, and statements that should complete completed");
        for (i = 0; i < statements.length; ++i) {
            try {
                statements[i].close();
                continue;
            }
            catch (SQLException e) {
                throw new TestFailedException(e);
            }
        }
    }

    private static void testInvalidTimeoutValue(Connection conn) throws TestFailedException {
        System.out.println("Testing setting a negative timeout value");
        try {
            conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new TestFailedException("Should not happen", e);
        }
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("select * from sys.systables");
        }
        catch (SQLException e) {
            throw new TestFailedException("Should not happen", e);
        }
        try {
            stmt.setQueryTimeout(-1);
        }
        catch (SQLException e) {
            SetQueryTimeoutTest.expectException("XJ074", e, "negative timeout value should give exception");
        }
        System.out.println("Negative timeout value caused exception, as expected");
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery();
            System.out.println("Execute returned a ResultSet");
            rs.close();
        }
        catch (SQLException e) {
            throw new TestFailedException("Should not happen", e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw new TestFailedException("close should not throw", e);
            }
        }
    }

    private static void testTimeoutWithExecuteUpdate(Connection conn) throws TestFailedException {
        System.out.println("Testing timeout with executeUpdate call.");
        try {
            Statement stmt = conn.createStatement();
            stmt.setQueryTimeout(1);
            stmt.executeUpdate(SetQueryTimeoutTest.getExecQuery("t"));
        }
        catch (SQLException sqle) {
            SetQueryTimeoutTest.expectException("XCL52", sqle, "Should have timed out.");
        }
    }

    private static void testRememberTimeoutValue(Connection conn) throws TestFailedException {
        String sql = SetQueryTimeoutTest.getFetchQuery("t");
        try {
            Statement stmt = conn.createStatement();
            SetQueryTimeoutTest.testStatementRemembersTimeout(stmt);
            PreparedStatement ps = conn.prepareStatement(sql);
            SetQueryTimeoutTest.testStatementRemembersTimeout(ps);
            CallableStatement cs = conn.prepareCall(sql);
            SetQueryTimeoutTest.testStatementRemembersTimeout(cs);
        }
        catch (SQLException sqle) {
            throw new TestFailedException("Should not happen", sqle);
        }
    }

    private static void testStatementRemembersTimeout(Statement stmt) throws SQLException, TestFailedException {
        System.out.println("Testing that Statement remembers timeout.");
        stmt.setQueryTimeout(1);
        long runTime = 0L;
        for (int i = 0; i < 3; ++i) {
            try {
                long startTime = System.currentTimeMillis();
                ResultSet rs = stmt.executeQuery(SetQueryTimeoutTest.getFetchQuery("t"));
                while (rs.next()) {
                }
                long endTime = System.currentTimeMillis();
                runTime = endTime - startTime;
                throw new TestFailedException("Should have timed out, for statement, iteration: " + i + ", took (millis): " + runTime);
            }
            catch (SQLException sqle) {
                SetQueryTimeoutTest.expectException("XCL52", sqle, "Should have timed out, got unexpected exception, for statement, iteration: " + i + ", time taken (millis): " + runTime);
                continue;
            }
        }
        stmt.close();
    }

    private static void testStatementRemembersTimeout(PreparedStatement ps) throws SQLException, TestFailedException {
        String name = ps instanceof CallableStatement ? "CallableStatement" : "PreparedStatement";
        System.out.println("Testing that " + name + " remembers timeout.");
        ps.setQueryTimeout(1);
        for (int i = 0; i < 3; ++i) {
            long runTime = 0L;
            try {
                long startTime = System.currentTimeMillis();
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                }
                long endTime = System.currentTimeMillis();
                runTime = endTime - startTime;
                throw new TestFailedException("Should have timed out, for " + name + ", on iteration " + i + ", runtime(millis): " + runTime);
            }
            catch (SQLException sqle) {
                SetQueryTimeoutTest.expectException("XCL52", sqle, "Should have timed out, got unexpected exception, for " + name + ", on iteration " + i + ", runtime(millis): " + runTime);
                continue;
            }
        }
        ps.close();
    }

    public static void main(String[] args) {
        new SetQueryTimeoutTest().go(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go(String[] args) {
        int i;
        System.out.println("Test SetQueryTimeoutTest starting");
        Connection[] connections = new Connection[100];
        try {
            ij.getPropertyArg((String[])args);
            for (i = 0; i < connections.length; ++i) {
                connections[i] = ij.startJBMS();
            }
            System.out.println("Got connections");
            for (i = 0; i < connections.length; ++i) {
                connections[i].setTransactionIsolation(1);
            }
            SetQueryTimeoutTest.prepareForTimedQueries(connections[0]);
            SetQueryTimeoutTest.testTimeoutWithFetch(connections[0], connections[1]);
            SetQueryTimeoutTest.testTimeoutWithExec(connections);
            SetQueryTimeoutTest.testInvalidTimeoutValue(connections[0]);
            SetQueryTimeoutTest.testRememberTimeoutValue(connections[0]);
            SetQueryTimeoutTest.testTimeoutWithExecuteUpdate(connections[0]);
            System.out.println("Test SetQueryTimeoutTest PASSED");
        }
        catch (Throwable e) {
            System.out.println("Test SetQueryTimeoutTest FAILED");
            e.printStackTrace();
        }
        finally {
            for (i = connections.length - 1; i >= 0; --i) {
                if (connections[i] == null) continue;
                try {
                    connections[i].close();
                    continue;
                }
                catch (SQLException ex) {
                    SetQueryTimeoutTest.printSQLException(ex);
                }
            }
            System.out.println("Closed connections");
        }
    }

    public static class StatementExecutor
    extends Thread {
        private PreparedStatement statement;
        private boolean doFetch;
        private int timeout;
        private SQLException sqlException;
        private String name;
        private long highestRunTime;

        public StatementExecutor(PreparedStatement statement, boolean doFetch, int timeout) {
            this.statement = statement;
            this.doFetch = doFetch;
            this.timeout = timeout;
            this.highestRunTime = 0L;
            this.sqlException = null;
            if (timeout > 0) {
                try {
                    statement.setQueryTimeout(timeout);
                }
                catch (SQLException e) {
                    this.sqlException = e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setHighestRunTime(long runTime) {
            StatementExecutor statementExecutor = this;
            synchronized (statementExecutor) {
                this.highestRunTime = runTime;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getHighestRunTime() {
            StatementExecutor statementExecutor = this;
            synchronized (statementExecutor) {
                return this.highestRunTime;
            }
        }

        private boolean fetchRow(ResultSet resultSet) throws SQLException {
            long startTime = System.currentTimeMillis();
            boolean hasNext = resultSet.next();
            long endTime = System.currentTimeMillis();
            long runTime = endTime - startTime;
            if (runTime > this.highestRunTime) {
                this.setHighestRunTime(runTime);
            }
            return hasNext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.sqlException != null) {
                return;
            }
            ResultSet resultSet = null;
            try {
                long startTime;
                if (this.doFetch) {
                    startTime = System.currentTimeMillis();
                    resultSet = this.statement.executeQuery();
                    long endTime = System.currentTimeMillis();
                    this.setHighestRunTime(endTime - startTime);
                    while (this.fetchRow(resultSet)) {
                        StatementExecutor.yield();
                    }
                } else {
                    startTime = System.currentTimeMillis();
                    this.statement.execute();
                    long endTime = System.currentTimeMillis();
                    this.setHighestRunTime(endTime - startTime);
                }
            }
            catch (SQLException e) {
                StatementExecutor statementExecutor = this;
                synchronized (statementExecutor) {
                    this.sqlException = e;
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException ex) {
                        if (this.sqlException != null) {
                            System.err.println("Discarding previous exception");
                            this.sqlException.printStackTrace();
                        }
                        this.sqlException = ex;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SQLException getSQLException() {
            StatementExecutor statementExecutor = this;
            synchronized (statementExecutor) {
                return this.sqlException;
            }
        }
    }

    private static class TestFailedException
    extends Exception {
        private Throwable cause;

        public TestFailedException(Throwable t) {
            this.cause = t;
        }

        public TestFailedException(String message) {
            super(message);
            this.cause = null;
        }

        public TestFailedException(String message, Throwable t) {
            super(message);
            this.cause = t;
        }

        @Override
        public String toString() {
            if (this.cause != null) {
                return super.toString() + ": " + this.cause.toString();
            }
            return super.toString();
        }

        @Override
        public void printStackTrace() {
            super.printStackTrace();
            if (this.cause != null) {
                if (this.cause instanceof SQLException) {
                    SetQueryTimeoutTest.printSQLException((SQLException)this.cause);
                } else {
                    this.cause.printStackTrace();
                }
            }
        }
    }
}

