/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.Wrapper41Statement;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementJdbc20Test
extends BaseJDBCTestCase {
    private static final String METHOD_NOT_ALLOWED = "XJ016";
    private static final String CLOSED_STATEMENT = "XJ012";

    public StatementJdbc20Test(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("StatementJdbc20Test");
        suite.addTest(StatementJdbc20Test.baseSuite("StatementJdbc20Test:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(StatementJdbc20Test.baseSuite("StatementJdbc20Test:client")));
        return suite;
    }

    private static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(StatementJdbc20Test.class);
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                Connection conn = this.getConnection();
                stmt.execute("create table tab1 (i int, s smallint, r real)");
                stmt.executeUpdate("insert into tab1 values(1, 2, 3.1)");
                stmt.execute("create procedure dynamic_results() language java parameter style java external name '" + StatementJdbc20Test.class.getName() + ".dynamicResults' " + "dynamic result sets 2");
                stmt.execute("create table t_autogen( a int generated always as identity, b int )");
            }
        };
    }

    public void testWrongVaues() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.setFetchSize(25);
        stmt.setFetchDirection(1001);
        stmt.setEscapeProcessing(true);
        try {
            stmt.setFetchSize(-1000);
            StatementJdbc20Test.fail((String)"setFetchSize(-1000) expected to fail");
        }
        catch (SQLException e) {
            StatementJdbc20Test.assertSQLState("XJ065", e);
        }
        try {
            stmt.setFetchDirection(-1000);
            StatementJdbc20Test.fail((String)"setFetchDirection(-1000) expected to fail");
        }
        catch (SQLException e) {
            StatementJdbc20Test.assertSQLState("XJ064", e);
        }
        StatementJdbc20Test.assertEquals((int)stmt.getFetchSize(), (int)25);
        StatementJdbc20Test.assertEquals((int)stmt.getFetchDirection(), (int)1001);
        stmt.close();
    }

    public void testReadingData() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select * from tab1");
        while (rs.next()) {
            StatementJdbc20Test.assertEquals((int)rs.getInt(1), (int)1);
            StatementJdbc20Test.assertEquals((int)rs.getShort(2), (int)2);
            StatementJdbc20Test.assertEquals((double)rs.getDouble(3), (double)3.1, (double)0.01);
        }
        rs.close();
        stmt.close();
    }

    public void testLocalValuesOfResultSet() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.setFetchSize(25);
        stmt.setFetchDirection(1001);
        stmt.setEscapeProcessing(true);
        ResultSet rs = stmt.executeQuery("select * from tab1");
        StatementJdbc20Test.assertEquals((int)rs.getFetchSize(), (int)25);
        StatementJdbc20Test.assertEquals((int)rs.getFetchDirection(), (int)1001);
        rs.setFetchSize(250);
        try {
            rs.setFetchDirection(1000);
        }
        catch (SQLException e) {
            if (StatementJdbc20Test.usingEmbedded()) {
                StatementJdbc20Test.assertSQLState("XJ061", e);
            }
            StatementJdbc20Test.assertSQLState("XJ125", e);
        }
        StatementJdbc20Test.assertEquals((int)rs.getFetchSize(), (int)250);
        StatementJdbc20Test.assertEquals((int)rs.getFetchDirection(), (int)1001);
        stmt.setMaxRows(10);
        rs.setFetchSize(100);
        try {
            rs.setFetchSize(-2000);
            StatementJdbc20Test.fail((String)"setFetchSize(-2000) expected to fail");
        }
        catch (SQLException e) {
            StatementJdbc20Test.assertSQLState("XJ062", e);
        }
        try {
            rs.setFetchDirection(-2000);
        }
        catch (SQLException e) {
            if (StatementJdbc20Test.usingEmbedded()) {
                StatementJdbc20Test.assertSQLState("XJ061", e);
            }
            StatementJdbc20Test.assertSQLState("XJ125", e);
        }
        rs.setFetchSize(0);
        stmt.setFetchSize(0);
        rs.close();
    }

    public void testCreateTableWithExecuteQuery() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("create table trash(c1 int)");
        }
        catch (SQLException e) {
            if (StatementJdbc20Test.usingEmbedded()) {
                StatementJdbc20Test.assertSQLState("X0Y78", e);
            }
            StatementJdbc20Test.assertSQLState("XJ207", e);
        }
        try {
            ResultSet rs = stmt.executeQuery("select * from trash");
            System.out.println("select from trash expected to fail");
        }
        catch (SQLException e) {
            StatementJdbc20Test.assertSQLState("42X05", e);
        }
        try {
            stmt.executeUpdate("values 1");
        }
        catch (SQLException e) {
            StatementJdbc20Test.assertSQLState("X0Y79", e);
        }
        stmt.close();
        this.commit();
    }

    public void testAddBatchClarification_jdbc4_1() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select * from sys.systables");
        CallableStatement cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        try {
            ps.addBatch("select * from sys.systables");
            StatementJdbc20Test.fail((String)"Oops. ps.addBatch() worked.");
        }
        catch (SQLException se) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, se);
        }
        try {
            cs.addBatch("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
            StatementJdbc20Test.fail((String)"Oops. cs.addBatch() worked.");
        }
        catch (SQLException se) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, se);
        }
    }

    public void testCompletionClosure_jdbc4_1() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        this.vetClosure(false, false);
        this.vetClosure(false, true);
        this.vetClosure(true, false);
        this.vetClosure(true, true);
    }

    private void vetClosure(boolean closeOnCompletion, boolean delayClosureCall) throws Exception {
        this.vetClosedSelect(closeOnCompletion, delayClosureCall);
        this.vetClosedCall(closeOnCompletion, delayClosureCall);
        this.vetClosedPS(closeOnCompletion, delayClosureCall);
        this.vetClosedAutoGen(closeOnCompletion, delayClosureCall);
    }

    private void vetClosedSelect(boolean closeOnCompletion, boolean delayClosureCall) throws Exception {
        Statement stmt = this.createStatement();
        StatementJdbc20Test.println("Verifying SELECT wrapper on " + stmt.getClass().getName() + " with closeOnCompletion = " + closeOnCompletion + " and delayClosureCall = " + delayClosureCall);
        Wrapper41Statement wrapper = new Wrapper41Statement(stmt);
        if (!delayClosureCall) {
            this.setCloseOnCompletion(wrapper, closeOnCompletion);
        }
        ResultSet rs = stmt.executeQuery("select * from tab1");
        if (delayClosureCall) {
            this.setCloseOnCompletion(wrapper, closeOnCompletion);
        }
        rs.close();
        StatementJdbc20Test.assertEquals((boolean)closeOnCompletion, (boolean)wrapper.isClosed());
        this.vetSuccessfulClosure(wrapper, closeOnCompletion);
    }

    private void vetClosedCall(boolean closeOnCompletion, boolean delayClosureCall) throws Exception {
        Statement stmt = this.createStatement();
        StatementJdbc20Test.println("Verifying CALL wrapper on " + stmt.getClass().getName() + " with closeOnCompletion = " + closeOnCompletion + " and delayClosureCall = " + delayClosureCall);
        Wrapper41Statement wrapper = new Wrapper41Statement(stmt);
        if (!delayClosureCall) {
            this.setCloseOnCompletion(wrapper, closeOnCompletion);
        }
        StatementJdbc20Test.assertTrue((boolean)stmt.execute("call dynamic_results()"));
        StatementJdbc20Test.assertFalse((boolean)wrapper.isClosed());
        ResultSet rs1 = stmt.getResultSet();
        if (delayClosureCall) {
            this.setCloseOnCompletion(wrapper, closeOnCompletion);
        }
        StatementJdbc20Test.assertTrue((boolean)stmt.getMoreResults());
        StatementJdbc20Test.assertFalse((boolean)wrapper.isClosed());
        ResultSet rs2 = stmt.getResultSet();
        rs2.close();
        StatementJdbc20Test.assertEquals((boolean)closeOnCompletion, (boolean)wrapper.isClosed());
        this.vetSuccessfulClosure(wrapper, closeOnCompletion);
    }

    private void vetClosedPS(boolean closeOnCompletion, boolean delayClosureCall) throws Exception {
        PreparedStatement ps = this.getConnection().prepareStatement("select * from tab1");
        StatementJdbc20Test.println("Verifying PreparedStatement wrapper on " + ps.getClass().getName() + " with closeOnCompletion = " + closeOnCompletion + " and delayClosureCall = " + delayClosureCall);
        Wrapper41Statement wrapper = new Wrapper41Statement(ps);
        if (!delayClosureCall) {
            this.setCloseOnCompletion(wrapper, closeOnCompletion);
        }
        ResultSet rs = ps.executeQuery();
        if (delayClosureCall) {
            this.setCloseOnCompletion(wrapper, closeOnCompletion);
        }
        rs.close();
        StatementJdbc20Test.assertEquals((boolean)closeOnCompletion, (boolean)wrapper.isClosed());
        this.vetSuccessfulClosure(wrapper, closeOnCompletion);
        if (!wrapper.isClosed()) {
            ps.close();
        }
    }

    private void vetClosedAutoGen(boolean closeOnCompletion, boolean delayClosureCall) throws Exception {
        Statement stmt = this.createStatement();
        StatementJdbc20Test.println("Verifying AUTOGENERATED KEYS wrapper on " + stmt.getClass().getName() + " with closeOnCompletion = " + closeOnCompletion + " and delayClosureCall = " + delayClosureCall);
        Wrapper41Statement wrapper = new Wrapper41Statement(stmt);
        if (!delayClosureCall) {
            this.setCloseOnCompletion(wrapper, closeOnCompletion);
        }
        stmt.executeUpdate("insert into t_autogen( b ) values ( 1 )", 1);
        ResultSet rs = stmt.getGeneratedKeys();
        if (delayClosureCall) {
            this.setCloseOnCompletion(wrapper, closeOnCompletion);
        }
        StatementJdbc20Test.assertFalse((boolean)wrapper.isClosed());
        rs.close();
        StatementJdbc20Test.assertEquals((boolean)closeOnCompletion, (boolean)wrapper.isClosed());
        this.vetSuccessfulClosure(wrapper, closeOnCompletion);
    }

    private void setCloseOnCompletion(Wrapper41Statement wrapper, boolean closeOnCompletion) throws Exception {
        StatementJdbc20Test.assertFalse((boolean)wrapper.isCloseOnCompletion());
        if (closeOnCompletion) {
            wrapper.closeOnCompletion();
        }
        StatementJdbc20Test.assertEquals((boolean)closeOnCompletion, (boolean)wrapper.isCloseOnCompletion());
    }

    private void vetSuccessfulClosure(Wrapper41Statement wrapper, boolean closeOnCompletion) throws Exception {
        if (closeOnCompletion) {
            try {
                wrapper.closeOnCompletion();
                StatementJdbc20Test.fail((String)"Expected closed statement failure.");
            }
            catch (SQLException se) {
                StatementJdbc20Test.assertSQLState(CLOSED_STATEMENT, se);
            }
            try {
                wrapper.isCloseOnCompletion();
                StatementJdbc20Test.fail((String)"Expected closed statement failure.");
            }
            catch (SQLException se) {
                StatementJdbc20Test.assertSQLState(CLOSED_STATEMENT, se);
            }
        }
    }

    public void test_clarification_jdbc4_1() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement ps = conn.prepareStatement("select * from sys.syscolumns");
        CallableStatement cs = conn.prepareCall("call dynamic_results()");
        this.vetNotAllowed(ps);
        this.vetNotAllowed(cs);
        ps.close();
        cs.close();
    }

    private void vetNotAllowed(Statement stmt) throws Exception {
        StatementJdbc20Test.println("Vetting a " + stmt.getClass().getName());
        try {
            stmt.execute("select * from sys.systables");
            this.failVNA();
        }
        catch (SQLException se) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, se);
        }
        try {
            stmt.execute("select * from sys.systables", 2);
            this.failVNA();
        }
        catch (SQLException se) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, se);
        }
        try {
            stmt.execute("select * from sys.systables", new int[]{1});
            this.failVNA();
        }
        catch (SQLException se) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, se);
        }
        try {
            stmt.execute("select * from sys.systables", new String[]{"COLUMNNAME"});
            this.failVNA();
        }
        catch (SQLException se) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, se);
        }
        try {
            stmt.executeQuery("select * from sys.systables");
            this.failVNA();
        }
        catch (SQLException se) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, se);
        }
        try {
            stmt.executeUpdate("insert into tab1 values(1, 2, 3.1)");
            this.failVNA();
        }
        catch (SQLException se) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, se);
        }
        try {
            stmt.executeUpdate("insert into tab1 values(1, 2, 3.1)", 2);
            this.failVNA();
        }
        catch (SQLException se) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, se);
        }
        try {
            stmt.executeUpdate("insert into tab1 values(1, 2, 3.1)", new int[]{1});
            this.failVNA();
        }
        catch (SQLException se) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, se);
        }
        try {
            stmt.executeUpdate("insert into tab1 values(1, 2, 3.1)", new String[]{"COLUMNNAME"});
            this.failVNA();
        }
        catch (SQLException se) {
            StatementJdbc20Test.assertSQLState(METHOD_NOT_ALLOWED, se);
        }
    }

    private void failVNA() throws Exception {
        StatementJdbc20Test.fail((String)"Should have failed when run on a PreparedStatement or CallableStatement");
    }

    public static void dynamicResults(ResultSet[] rs1, ResultSet[] rs2) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        rs2[0] = c.createStatement().executeQuery("VALUES(2)");
    }
}

