/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.shared.common.error.DerbySQLIntegrityConstraintViolationException;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ForeignKeysDeferrableTest
extends BaseJDBCTestCase {
    private static final String LANG_DEFERRED_DUPLICATE_KEY_CONSTRAINT_T = "23506";
    private static final String LANG_DEFERRED_FK_CONSTRAINT_T = "23516";
    private static final String LANG_DEFERRED_FK_CONSTRAINT_S = "23517";
    private static final String LANG_ADD_FK_CONSTRAINT_VIOLATION = "X0Y45";
    private static final String LANG_FK_VIOLATION = "23503";
    private static String expImpDataFile;
    private static boolean exportFilesCreatedEmbedded;
    private static boolean exportFilesCreatedClient;

    public ForeignKeysDeferrableTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite();
        suite.addTest((Test)new SupportFilesSetup(TestConfiguration.embeddedSuite(ForeignKeysDeferrableTest.class)));
        suite.addTest((Test)new SupportFilesSetup(TestConfiguration.clientServerSuite(ForeignKeysDeferrableTest.class)));
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Statement s = this.createStatement();
        s.executeUpdate("create table ref_d_r(i int primary key, j int default 2)");
        s.executeUpdate("create table ref_d_c(i int primary key, j int default 2)");
        s.executeUpdate("create table ref_d_na(i int primary key, j int default 2)");
        s.executeUpdate("create table ref_d_nu(i int primary key, j int default 2)");
        s.executeUpdate("create table ref_u_r(i int primary key, j int default 2)");
        s.executeUpdate("create table ref_u_na(i int primary key, j int default 2)");
        s.executeUpdate("insert into ref_d_r values (1, default)");
        s.executeUpdate("insert into ref_d_c values (1, default)");
        s.executeUpdate("insert into ref_d_na values (1, default)");
        s.executeUpdate("insert into ref_d_nu values (1, default)");
        s.executeUpdate("insert into ref_u_r values (1, default)");
        s.executeUpdate("insert into ref_u_na values (1, default)");
        s.executeUpdate("create table t_d_r(i int, j int default 2,   constraint c_d_r foreign key (i) references ref_d_r(i)    on delete restrict deferrable initially immediate)");
        s.executeUpdate("create table t_d_c(i int, j int default 2,   constraint c_d_c foreign key (i) references ref_d_c(i)    on delete cascade deferrable initially immediate)");
        s.executeUpdate("create table t_d_na(i int, j int default 2,   constraint c_d_na foreign key (i) references ref_d_na(i)    on delete no action deferrable initially immediate)");
        s.executeUpdate("create table t_d_nu(i int, j int default 2,   constraint c_d_nu foreign key (i) references ref_d_nu(i)    on delete set null deferrable initially immediate)");
        s.executeUpdate("create table t_u_r(i int, j int default 2,   constraint c_u_r foreign key (i) references ref_u_r(i)    on update restrict deferrable initially immediate)");
        s.executeUpdate("create table t_u_na(i int, j int default 2,   constraint c_u_na foreign key (i) references ref_u_na(i)    on update no action deferrable initially immediate)");
        s.executeUpdate("insert into t_d_r   values (1, default)");
        s.executeUpdate("insert into t_d_c   values (1, default)");
        s.executeUpdate("insert into t_d_na  values (1, default)");
        s.executeUpdate("insert into t_d_nu  values (1, default)");
        s.executeUpdate("insert into t_u_r   values (1, default)");
        s.executeUpdate("insert into t_u_na  values (1, default)");
        if (ForeignKeysDeferrableTest.usingEmbedded() && !exportFilesCreatedEmbedded || ForeignKeysDeferrableTest.usingDerbyNetClient() && !exportFilesCreatedClient) {
            if (ForeignKeysDeferrableTest.usingEmbedded()) {
                exportFilesCreatedEmbedded = true;
            } else {
                exportFilesCreatedClient = true;
            }
            expImpDataFile = SupportFilesSetup.getReadWrite("t.data").getPath();
            s.executeUpdate("create table t(i int, j int)");
            s.executeUpdate("insert into t values (1,2),(2,2)");
            s.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "'," + "    null, null , null)");
            s.executeUpdate("drop table t");
        }
        this.setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        this.setAutoCommit(true);
        Statement s = this.createStatement();
        this.dropTable("t_d_r");
        this.dropTable("t_d_c");
        this.dropTable("t_d_na");
        this.dropTable("t_d_nu");
        this.dropTable("t_u_r");
        this.dropTable("t_u_na");
        this.dropTable("ref_d_r");
        this.dropTable("ref_d_c");
        this.dropTable("ref_d_na");
        this.dropTable("ref_d_nu");
        this.dropTable("ref_u_r");
        this.dropTable("ref_u_na");
        super.tearDown();
    }

    public void testInsertDirect() throws SQLException {
        Statement s = this.createStatement();
        String DIRECT_INSERT_SQL = "insert into t_d_r values (2, default)";
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "insert into t_d_r values (2, default)");
        try {
            s.execute("insert into t_d_r values (2, default)");
            ForeignKeysDeferrableTest.fail();
        }
        catch (DerbySQLIntegrityConstraintViolationException dsicve) {
            ForeignKeysDeferrableTest.assertSQLState(LANG_FK_VIOLATION, (SQLException)((Object)dsicve));
            ForeignKeysDeferrableTest.assertEquals((String)"T_D_R", (String)dsicve.getTableName());
            ForeignKeysDeferrableTest.assertEquals((String)"C_D_R", (String)dsicve.getConstraintName());
        }
        s.executeUpdate("set constraints c_d_r deferred");
        s.executeUpdate("insert into t_d_r values (2, default)");
        try {
            this.getConnection().commit();
            ForeignKeysDeferrableTest.fail();
        }
        catch (DerbySQLIntegrityConstraintViolationException dsicve) {
            ForeignKeysDeferrableTest.assertSQLState(LANG_DEFERRED_FK_CONSTRAINT_T, (SQLException)((Object)dsicve));
            ForeignKeysDeferrableTest.assertEquals((String)"\"APP\".\"T_D_R\"", (String)dsicve.getTableName());
            ForeignKeysDeferrableTest.assertEquals((String)"C_D_R", (String)dsicve.getConstraintName());
        }
        s.executeUpdate("set constraints c_d_r deferred");
        s.executeUpdate("insert into t_d_r values (2, default)");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_d_r immediate");
        s.executeUpdate("insert into ref_d_r values (2, default)");
        this.commit();
        s.executeUpdate("set constraints c_d_r deferred");
        s.executeUpdate("insert into t_d_r values (2, default)".replaceAll("2", "3"));
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_d_r immediate");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_d_r immediate");
        try {
            s.execute("set constraints c_d_r immediate");
            ForeignKeysDeferrableTest.fail();
        }
        catch (DerbySQLIntegrityConstraintViolationException dsicve) {
            ForeignKeysDeferrableTest.assertSQLState(LANG_DEFERRED_FK_CONSTRAINT_S, (SQLException)((Object)dsicve));
            ForeignKeysDeferrableTest.assertEquals((String)"\"APP\".\"T_D_R\"", (String)dsicve.getTableName());
            ForeignKeysDeferrableTest.assertEquals((String)"C_D_R", (String)dsicve.getConstraintName());
        }
        s.executeUpdate("delete from t_d_r where i=3");
        this.commit();
    }

    public void testInsertDeferred() throws SQLException {
        Statement s = this.createStatement();
        String DEFERRED_INSERT_SQL = "insert into t_d_r select i+1,j from t_d_r";
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "insert into t_d_r select i+1,j from t_d_r");
        s.executeUpdate("set constraints c_d_r deferred");
        s.executeUpdate("insert into t_d_r select i+1,j from t_d_r");
        ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        s.executeUpdate("set constraints c_d_r deferred");
        s.executeUpdate("insert into t_d_r select i+1,j from t_d_r");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_d_r immediate");
        s.executeUpdate("insert into ref_d_r values (2, default)");
        this.commit();
        s.executeUpdate("set constraints c_d_r deferred");
        s.executeUpdate("insert into t_d_r select i+1,j from t_d_r");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_d_r immediate");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_d_r immediate");
        s.executeUpdate("delete from t_d_r where i=3");
        this.commit();
    }

    public void testUpdateDirect() throws SQLException {
        Statement s = this.createStatement();
        String RESTRICTED_UPDATE_CHILD_SQL = "update t_u_r set i=2 where j=2";
        String NO_ACTION_UPDATE_CHILD_SQL = "update t_u_na set i=2 where j=2";
        String[] constraint = new String[]{"c_u_r", "c_u_na"};
        String[] sql = new String[]{"update t_u_r set i=2 where j=2", "update t_u_na set i=2 where j=2"};
        for (int i = 0; i < 2; ++i) {
            ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, sql[i]);
            String setDeferred = "set constraints " + constraint[i] + " deferred";
            String setImmediate = "set constraints " + constraint[i] + " immediate";
            s.executeUpdate(setDeferred);
            s.executeUpdate(sql[i]);
            ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, setImmediate);
            ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, setImmediate);
            ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        }
    }

    public void testUpdateDeferred() throws SQLException {
        Statement s = this.createStatement();
        String RESTRICTED_UPDATE_CHILD_SQL = "update t_u_r set i=2 where i=1";
        String NO_ACTION_UPDATE_CHILD_SQL = "update t_u_na set i=2 where i=1";
        String RESTRICTED_UPDATE_PARENT_SQL = "update ref_u_r set i = 2 where i = 1";
        String NO_ACTION_UPDATE_PARENT_SQL = "update ref_u_na set i = 2 where i = 1";
        String[] constraint = new String[]{"c_u_r", "c_u_na"};
        String[] sql = new String[]{"update t_u_r set i=2 where i=1", "update t_u_na set i=2 where i=1"};
        for (int i = 0; i < 2; ++i) {
            ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, sql[i]);
            String setDeferred = "set constraints " + constraint[i] + " deferred";
            String setImmediate = "set constraints " + constraint[i] + " immediate";
            s.executeUpdate(setDeferred);
            s.executeUpdate(sql[i]);
            ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, setImmediate);
            ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, setImmediate);
            ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        }
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "update ref_u_r set i = 2 where i = 1");
        s.executeUpdate("set constraints c_u_r deferred");
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "update ref_u_r set i = 2 where i = 1");
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "update ref_u_na set i = 2 where i = 1");
        s.executeUpdate("set constraints c_u_na deferred");
        s.executeUpdate("update ref_u_na set i = 2 where i = 1");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_u_na immediate");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_u_na immediate");
        ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        s.executeUpdate("set constraints c_u_na deferred");
        s.executeUpdate("update ref_u_na set i = 2 where i = 1");
        s.executeUpdate("update ref_u_na set i=1 where i=2");
        this.commit();
        s.executeUpdate("set constraints c_u_na deferred");
        s.executeUpdate("update t_u_na set i=2 where i=1");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_u_na immediate");
        s.executeUpdate("update t_u_na set i=1 where i=2");
        this.commit();
    }

    public void testDeleteDirect() throws SQLException {
        Statement s = this.createStatement();
        String RESTRICTED_DELETE_SQL = "delete from ref_d_r where i = 1";
        String NO_ACTION_DELETE_SQL = "delete from ref_d_na where i = 1";
        String CASCADE_DELETE_SQL = "delete from ref_d_c where i = 1";
        String SET_NULL_DELETE_SQL = "delete from ref_d_nu where i = 1";
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "delete from ref_d_r where i = 1");
        s.executeUpdate("set constraints c_d_r deferred");
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "delete from ref_d_r where i = 1");
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "delete from ref_d_na where i = 1");
        s.executeUpdate("set constraints c_d_na deferred");
        s.executeUpdate("delete from ref_d_na where i = 1");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_d_na immediate");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_d_na immediate");
        ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        s.executeUpdate("set constraints c_d_na deferred");
        s.executeUpdate("delete from ref_d_na where i = 1");
        s.executeUpdate("delete from t_d_na where i=1");
        this.commit();
        s.executeUpdate("insert into ref_d_na values (1, default)");
        s.executeUpdate("insert into t_d_na values (1, default)");
        this.commit();
        s.executeUpdate("set constraints c_d_na deferred");
        s.executeUpdate("delete from ref_d_na where i = 1");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_d_na immediate");
        s.executeUpdate("insert into ref_d_na values (1, default)");
        this.commit();
        s.executeUpdate("delete from ref_d_c where i = 1");
        JDBC.assertEmpty(s.executeQuery("select * from t_d_c"));
        this.rollback();
        s.executeUpdate("set constraints c_d_c deferred");
        s.executeUpdate("delete from ref_d_c where i = 1");
        JDBC.assertEmpty(s.executeQuery("select * from t_d_c"));
        this.commit();
        s.executeUpdate("delete from ref_d_nu where i = 1");
        this.assertResults(s.executeQuery("select i from t_d_nu"), new String[][]{{null}}, false);
        this.rollback();
        s.executeUpdate("set constraints c_d_nu deferred");
        s.executeUpdate("delete from ref_d_nu where i = 1");
        this.assertResults(s.executeQuery("select i from t_d_nu"), new String[][]{{null}}, false);
        this.commit();
    }

    public void testDeleteDeferred() throws SQLException {
        Statement s = this.createStatement();
        String RESTRICTED_DELETE_SQL = "delete from ref_d_r where i = 1 and     i in (select i from ref_d_r)";
        String NO_ACTION_DELETE_SQL = "delete from ref_d_na where i = 1 and     i in (select i from ref_d_na)";
        String CASCADE_DELETE_SQL = "delete from ref_d_c where i = 1 and     i in (select i from ref_d_c)";
        String SET_NULL_DELETE_SQL = "delete from ref_d_nu where i = 1 and     i in (select i from ref_d_nu)";
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "delete from ref_d_r where i = 1 and     i in (select i from ref_d_r)");
        s.executeUpdate("set constraints c_d_r deferred");
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "delete from ref_d_r where i = 1 and     i in (select i from ref_d_r)");
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "delete from ref_d_na where i = 1 and     i in (select i from ref_d_na)");
        s.executeUpdate("set constraints c_d_na deferred");
        s.executeUpdate("delete from ref_d_na where i = 1 and     i in (select i from ref_d_na)");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_d_na immediate");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_d_na immediate");
        ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        s.executeUpdate("set constraints c_d_na deferred");
        s.executeUpdate("delete from ref_d_na where i = 1 and     i in (select i from ref_d_na)");
        s.executeUpdate("delete from t_d_na where i=1");
        this.commit();
        s.executeUpdate("insert into ref_d_na values (1, default)");
        s.executeUpdate("insert into t_d_na values (1, default)");
        this.commit();
        s.executeUpdate("set constraints c_d_na deferred");
        s.executeUpdate("delete from ref_d_na where i = 1 and     i in (select i from ref_d_na)");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, s, "set constraints c_d_na immediate");
        s.executeUpdate("insert into ref_d_na values (1, default)");
        this.commit();
        s.executeUpdate("delete from ref_d_c where i = 1 and     i in (select i from ref_d_c)");
        JDBC.assertEmpty(s.executeQuery("select * from t_d_c"));
        this.rollback();
        s.executeUpdate("set constraints c_d_c deferred");
        s.executeUpdate("delete from ref_d_c where i = 1 and     i in (select i from ref_d_c)");
        JDBC.assertEmpty(s.executeQuery("select * from t_d_c"));
        this.commit();
        s.executeUpdate("delete from ref_d_nu where i = 1 and     i in (select i from ref_d_nu)");
        this.assertResults(s.executeQuery("select i from t_d_nu"), new String[][]{{null}}, false);
        this.rollback();
        s.executeUpdate("set constraints c_d_nu deferred");
        s.executeUpdate("delete from ref_d_nu where i = 1 and     i in (select i from ref_d_nu)");
        this.assertResults(s.executeQuery("select i from t_d_nu"), new String[][]{{null}}, false);
        this.commit();
    }

    public void testBulkInsert() throws SQLException {
        Statement s = this.createStatement();
        for (int addOrReplace = 0; addOrReplace < 2; ++addOrReplace) {
            ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T_D_R' , '" + expImpDataFile + "'," + "    null, null , null, " + addOrReplace + ")");
            s.executeUpdate("set constraints c_d_r deferred");
            ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_T, s, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T_D_R' , '" + expImpDataFile + "'," + "    null, null , null, " + addOrReplace + ")");
        }
    }

    public void testAddConstraint() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t2(i int)");
        try {
            s.executeUpdate("insert into t2 values 1,2");
            this.commit();
            ForeignKeysDeferrableTest.assertStatementError(LANG_ADD_FK_CONSTRAINT_VIOLATION, s, "alter table t2 add constraint     c2 foreign key(i) references ref_d_r(i)");
            s.executeUpdate("delete from t2 where i=2");
            s.executeUpdate("alter table t2 add constraint c2 foreign key(i) references ref_d_r(i)");
            this.rollback();
            s.executeUpdate("delete from t2");
            s.executeUpdate("insert into t2 values 1,2");
            this.commit();
            s.executeUpdate("alter table t2 add constraint     c2 foreign key(i) references ref_d_r(i)     initially deferred");
            ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        }
        finally {
            this.dropTable("t2");
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFKPlusUnique() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = null;
        try {
            String[] refActions;
            for (String refAct : refActions = new String[]{"ON DELETE NO ACTION ON UPDATE NO ACTION", "ON DELETE RESTRICT ON UPDATE RESTRICT"}) {
                s.executeUpdate("create table ref_t(i int, j int, constraint ct     primary key(i) deferrable initially deferred)");
                s.executeUpdate("create table t(i int unique not null, c char(1),    constraint c foreign key (i) references ref_t(i) " + refAct + ")");
                s.executeUpdate("insert into ref_t values (1,2),(1,3),(1,4)");
                s.executeUpdate("insert into t values (1, 'c')");
                rs = s.executeQuery("select * from ref_t");
                rs.next();
                rs.deleteRow();
                rs.next();
                rs.deleteRow();
                this.commit();
                s.executeUpdate("insert into ref_t values (1,5),(1,6)");
                s.executeUpdate("delete from ref_t where j > 4 ");
                this.commit();
                s.executeUpdate("insert into ref_t values (1,3)");
                rs = s.executeQuery("select * from ref_t");
                rs.next();
                rs.deleteRow();
                rs.next();
                try {
                    rs.deleteRow();
                    ForeignKeysDeferrableTest.fail();
                }
                catch (SQLException e) {
                    ForeignKeysDeferrableTest.assertSQLState(LANG_FK_VIOLATION, e);
                }
                s.executeUpdate("insert into ref_t values (1,4), (1,5)");
                ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "delete from ref_t");
                ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "delete from ref_t where i = 1 and     i in (select i from ref_t)");
                s.executeUpdate("delete from ref_t where i = 1 and     i in (select i from ref_t) and j >= 4");
                s.executeUpdate("insert into ref_t values (1,4), (1,5)");
                s.executeUpdate("delete from ref_t where j >= 4");
                JDBC.assertFullResultSet(s.executeQuery("select * from ref_t"), new String[][]{{"1", "3"}});
                this.commit();
                s.executeUpdate("insert into ref_t values (1,4)");
                s.executeUpdate("update ref_t set i = 2 where j = 4");
                s.executeUpdate("insert into ref_t values (1,4)");
                ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, s, "update ref_t set i = 2");
                rs = s.executeQuery("select * from ref_t");
                rs.next();
                rs.updateInt(1, 3);
                rs.updateRow();
                rs.close();
                this.commit();
                this.dropTable("t");
                this.dropTable("ref_t");
                this.commit();
            }
            for (String refAct : refActions) {
                String expected;
                s.executeUpdate("create table ref_t(c char(1), i int, j int, k int,    constraint c primary key (k, i) initially deferred)");
                s.executeUpdate("create table t(l bigint, i int, j int, k int,    constraint c2 foreign key(i,k)     references ref_t(k, i)" + refAct + ")");
                s.executeUpdate("insert into ref_t values ('a', 100, -1, 1),('a', 100, -2, 1),('a', 100, -3, 1),('a', 100, -1, 2),('a', 100, -2, 3),('a', 100, -3, 3)");
                s.executeUpdate("insert into t values (-11, 1, -4, 100),(-12, 2, -5, 100),(-13, 3, -6, 100)");
                try {
                    s.executeUpdate("delete from ref_t where j < -1 and     k in (select k from ref_t)");
                    ForeignKeysDeferrableTest.fail();
                }
                catch (SQLException e) {
                    ForeignKeysDeferrableTest.assertSQLState(LANG_FK_VIOLATION, e);
                    expected = "DELETE on table 'REF_T' caused a violation of foreign key constraint 'C2' for key (3,100).  The statement has been rolled back.";
                    ForeignKeysDeferrableTest.assertEquals((String)expected, (String)e.getMessage());
                }
                s.executeUpdate("delete from ref_t where j < -1 and     k in (select k from ref_t where k < 3)");
                s.executeUpdate("delete from ref_t where j < -2 and     k in (select k from ref_t where k >= 3)");
                this.commit();
                this.dropTable("t");
                this.dropTable("ref_t");
                this.commit();
                s.executeUpdate("create table ref_t(c char(1), i int, j int, k int,    constraint c primary key (k, i) initially deferred)");
                s.executeUpdate("create table t(l bigint, i int, j int, k int,    constraint c2 foreign key(i,k)     references ref_t(k, i)" + refAct + ")");
                s.executeUpdate("insert into ref_t values ('a', 100, -1, 1),('a', 100, -2, 1),('a', 100, -3, 1),('a', 100, -1, 2),('a', 100, -2, 3),('a', 100, -3, 3)");
                s.executeUpdate("insert into t values (-11, 1, -4, 100),(-12, 2, -5, 100),(-13, 3, -6, 100)");
                try {
                    s.executeUpdate("update ref_t set k=k*100 where j < -1 and     k in (select k from ref_t)");
                    ForeignKeysDeferrableTest.fail();
                }
                catch (SQLException e) {
                    ForeignKeysDeferrableTest.assertSQLState(LANG_FK_VIOLATION, e);
                    expected = "UPDATE on table 'REF_T' caused a violation of foreign key constraint 'C2' for key (3,100).  The statement has been rolled back.";
                    ForeignKeysDeferrableTest.assertEquals((String)expected, (String)e.getMessage());
                }
                s.executeUpdate("update ref_t set k=k*100 where j < -1 and     k in (select k from ref_t where k < 3)");
                s.executeUpdate("update ref_t set k=k*100 where j < -2 and     k in (select k from ref_t where k >= 3)");
                this.dropTable("t");
                this.dropTable("ref_t");
                this.commit();
            }
            s.executeUpdate("create table ref_t(c char(1), i int, j int, k int,    constraint c primary key (k, i))");
            s.executeUpdate("create table t(l bigint, i int, j int, k int,    constraint c2 foreign key(i,k) references ref_t(k, i)     on delete cascade)");
            s.executeUpdate("insert into ref_t values ('a', 100, -3, 3)");
            s.executeUpdate("insert into t values (-11, 3, -4, 100)");
            s.executeUpdate("delete from ref_t where j < -1 and     k in (select k from ref_t)");
            JDBC.assertEmpty(s.executeQuery("select * from ref_t"));
            JDBC.assertEmpty(s.executeQuery("select * from t"));
            this.dropTable("t");
            this.dropTable("ref_t");
            this.commit();
            s.executeUpdate("create table ref_t(c char(1), i int, j int, k int,    constraint c primary key (k, i) initially deferred)");
            ForeignKeysDeferrableTest.assertStatementError("X0Y47", s, "create table t(l bigint, i int, j int, k int,    constraint c2 foreign key(i,k) references ref_t(k, i)     on delete cascade)");
            this.dropTable("t");
            this.dropTable("ref_t");
            this.commit();
            s.executeUpdate("create table ref_t(c char(1), i int, j int, k int,    constraint c primary key (k, i))");
            s.executeUpdate("create table t(l bigint, i int, j int, k int,    constraint c2 foreign key(i,k) references ref_t(k, i)     on delete set null)");
            s.executeUpdate("insert into ref_t values ('a', 100, -3, 3)");
            s.executeUpdate("insert into t values (-11, 3, -4, 100)");
            s.executeUpdate("delete from ref_t");
            JDBC.assertEmpty(s.executeQuery("select * from ref_t"));
            JDBC.assertFullResultSet(s.executeQuery("select * from t"), new String[][]{{"-11", null, "-4", null}});
            this.dropTable("t");
            this.dropTable("ref_t");
            this.commit();
            s.executeUpdate("create table ref_t(c char(1), i int, j int, k int,    constraint c primary key (k, i) initially deferred)");
            ForeignKeysDeferrableTest.assertStatementError("X0Y47", s, "create table t(l bigint, i int, j int, k int,    constraint c2 foreign key(i,k) references ref_t(k, i)     on delete set null)");
            this.commit();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.dropTable("t");
            this.dropTable("ref_t");
            this.commit();
        }
    }

    public void testSelfReferential() throws SQLException {
        Statement s = this.createStatement();
        try {
            s.executeUpdate("create table t(name varchar(10) primary key                    deferrable initially deferred,               boss varchar(10) references t(name)                    on delete restrict, i int)");
            s.executeUpdate("insert into t values ('daisy', null, 1)");
            s.executeUpdate("insert into t values ('daisy', null, 2)");
            s.executeUpdate("insert into t values ('donald', 'daisy', 3)");
            s.executeUpdate("delete from t where name like 'daisy%' and i = 1");
            JDBC.assertFullResultSet(s.executeQuery("select * from t"), new String[][]{{"daisy", null, "2"}, {"donald", "daisy", "3"}});
            this.commit();
            s.executeUpdate("create table employees(name char(40),     constraint ec primary key(name) initially deferred,     address char(40))");
            ForeignKeysDeferrableTest.assertStatementError("X0Y47", s, "create table teammember(name char(40) primary key references employees(name) on delete cascade, boss char(40) references teammember(name) on delete cascade)");
        }
        finally {
            this.dropTable("t");
            this.dropTable("employees");
            this.dropTable("teammember");
            this.commit();
        }
    }

    public void testInsertTrigger() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table d6664_t1(pk int primary key)");
        s.execute("create table d6664_t2(x int references d6664_t1 initially deferred)");
        s.execute("create table d6664_t3(y int)");
        s.execute("create trigger d6664_tr after insert on d6664_t3 referencing new as new for each row insert into d6664_t2 values new.y");
        s.execute("insert into d6664_t3 values 1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from d6664_t2"), "1");
        ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
    }

    public void test_6668() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table tunique_6668\n(\n  a int not null unique\n)\n");
        this.goodStatement(conn, "create table tref_6668\n(\n  a int references tunique_6668( a ) initially deferred\n)\n");
        ForeignKeysDeferrableTest.assertStatementError("XCL48", conn.prepareStatement("truncate table tunique_6668"));
    }

    public void testSharedConglomerates() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table d6665_t1(x int primary key)");
        s.execute("create table d6665_t2(x int primary key)");
        s.execute("create table d6665_t3(x int references d6665_t1 initially deferred references d6665_t2 initially deferred)");
        s.execute("insert into d6665_t1 values 1");
        s.execute("insert into d6665_t3 values 1");
        s.execute("insert into d6665_t2 values 1");
        s.execute("delete from d6665_t1");
        ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        s.execute("create table d6665_t4(x int primary key)");
        s.execute("create table d6665_t5(x int primary key initially deferred references d6665_t4 initially deferred)");
        s.execute("insert into d6665_t5 values 1");
        s.execute("insert into d6665_t4 values 1");
        s.execute("insert into d6665_t5 values 1");
        try {
            this.getConnection().commit();
            ForeignKeysDeferrableTest.fail();
        }
        catch (DerbySQLIntegrityConstraintViolationException dsicve) {
            ForeignKeysDeferrableTest.assertSQLState(LANG_DEFERRED_DUPLICATE_KEY_CONSTRAINT_T, (SQLException)((Object)dsicve));
            ForeignKeysDeferrableTest.assertEquals((String)"D6665_T5", (String)dsicve.getTableName());
            ForeignKeysDeferrableTest.assertTrue((boolean)dsicve.getConstraintName().startsWith("SQL"));
        }
    }

    static {
        exportFilesCreatedEmbedded = false;
        exportFilesCreatedClient = false;
    }
}

