/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InsertTest
extends BaseJDBCTestCase {
    private static final String PARAMETER_IN_SELECT_LIST = "42X34";
    private static final String TOO_MANY_RESULT_COLUMNS = "42X06";

    public InsertTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(InsertTest.class);
    }

    public void zztestDerby6788() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE M1 (K varchar(64), S decimal)");
        s.execute("CREATE TABLE M2 (K varchar(64), S decimal)");
        s.execute("CREATE TABLE V  (S DECIMAL)");
        s.execute("INSERT INTO M1 VALUES ('Bug', 2015)");
        s.execute("INSERT INTO M2 VALUES ('Bug', 1957)");
        JDBC.assertFullResultSet(s.executeQuery("SELECT res.* FROM (SELECT d2.s FROM m1 LEFT JOIN (SELECT k,s FROM m2) AS d2 ON m1.k=d2.k) AS res"), new String[][]{{"1957"}});
        s.execute("INSERT INTO V (SELECT res.* FROM (SELECT d2.s FROM m1 LEFT JOIN (SELECT k,s FROM m2) AS d2 ON m1.k=d2.k) AS res)");
        JDBC.assertFullResultSet(s.executeQuery("SELECT * FROM V"), new String[][]{{"1957"}});
        s.execute("INSERT INTO V (SELECT res.* FROM (SELECT d2.s*1 FROM m1 LEFT JOIN (SELECT k,s FROM m2) AS d2 ON m1.k=d2.k) AS res)");
        JDBC.assertFullResultSet(s.executeQuery("SELECT * FROM V"), new String[][]{{"1957"}, {"1957"}});
        s.execute("DROP   TABLE M1");
        s.execute("DROP   TABLE M2");
        s.execute("DROP   TABLE V");
    }

    public void testDerby6786Case1() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE K1 (K VARCHAR(64), S DECIMAL)");
        s.execute("CREATE TABLE K2 (K VARCHAR(64), S DECIMAL)");
        s.execute("CREATE TABLE T  (S DECIMAL)");
        s.execute("INSERT INTO K1 VALUES ('110007', 224)");
        s.execute("INSERT INTO K2 VALUES ('110007', 361)");
        this.derby6786QueriesToRun(s, "");
        this.derby6786QueriesToRun(s, "insert into t ");
        s.execute("DROP   TABLE K1");
        s.execute("DROP   TABLE K2");
        s.execute("DROP   TABLE T");
    }

    public void testDerby6786InsertIntoSelectCase2() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE K1 (K VARCHAR(64), S DECIMAL)");
        s.execute("CREATE TABLE K2 (K VARCHAR(64), S DECIMAL)");
        s.execute("CREATE TABLE T  (S DECIMAL)");
        s.execute("INSERT INTO K1 VALUES ('110007', 224)");
        s.execute("INSERT INTO K2 VALUES ('110007', null)");
        this.derby6786QueriesToRun(s, "");
        this.derby6786QueriesToRun(s, "insert into t ");
        s.execute("DROP   TABLE K1");
        s.execute("DROP   TABLE K2");
        s.execute("DROP   TABLE T");
    }

    public void zztestDerby6786InsertIntoSelectCase3() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE K1 (K VARCHAR(64), S DECIMAL)");
        s.execute("CREATE TABLE K2 (K VARCHAR(64), S DECIMAL)");
        s.execute("CREATE TABLE T  (S DECIMAL)");
        s.execute("INSERT INTO K1 VALUES ('110007', 224)");
        s.execute("INSERT INTO K2 VALUES ('110019', null)");
        this.derby6786QueriesToRun(s, "");
        this.derby6786QueriesToRun(s, "insert into t ");
        s.execute("DROP   TABLE K1");
        s.execute("DROP   TABLE K2");
        s.execute("DROP   TABLE T");
    }

    private void derby6786QueriesToRun(Statement s, String insertInto) throws SQLException {
        s.execute(insertInto + "select erg.* from ( " + "select d1.s from (select k,s from k1) as d1 " + "left join " + "(select k,s from k2) as d2 on d1.k=d2.k" + ") as erg " + "where s > 10");
        s.execute(insertInto + "select erg.* from ( " + "select d2.s from (select k,s from k1) as d1 " + "left join " + "(select k,s from k2) as d2 on d1.k=d2.k" + ") as erg " + "where s > 10");
        s.execute(insertInto + "select erg.* from ( " + "select d2.s from k1 " + "left join " + "(select k,s from k2) as d2 on k1.k=d2.k" + ") as erg " + "where s > 10");
        s.execute(insertInto + "select erg.* from ( " + "select d1.s from (select k,s from k1) as d1 " + "right join " + "(select k,s from k2) as d2 on d1.k=d2.k" + ") as erg " + "where s > 10");
        s.execute(insertInto + "select erg.* from ( " + "select d2.s from (select k,s from k1) as d1 " + "right join " + "(select k,s from k2) as d2 on d1.k=d2.k" + ") as erg " + "where s > 10");
    }

    public void testInsertIntoSelectFromWithLongVarchar() throws SQLException {
        String[][] data = new String[100][2];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = Integer.toString(i);
            data[i][1] = "-1";
        }
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t1(a long varchar)");
        PreparedStatement insT1 = this.prepareStatement("insert into t1 values ?");
        for (int i = 0; i < data.length; ++i) {
            insT1.setString(1, data[i][0]);
            insT1.executeUpdate();
        }
        s.execute("create table t2(a long varchar, b int default -1 not null)");
        s.execute("insert into t2(a) select * from t1");
        JDBC.assertFullResultSet(s.executeQuery("select * from t2 order by int(cast (a as varchar(10)))"), data);
    }

    public void testInsertFromExceptOrIntersect() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t1(x int)");
        s.execute("insert into t1 values 1,2,3");
        s.execute("create table t2(x int)");
        s.execute("insert into t2 values 2,3,4");
        s.execute("create table t3(x int)");
        s.execute("insert into t3 select * from t1 intersect select * from t2");
        JDBC.assertFullResultSet(s.executeQuery("select * from t3 order by x"), new String[][]{{"2"}, {"3"}});
        s.execute("delete from t3");
        s.execute("insert into t3 select * from t1 intersect all select * from t2");
        JDBC.assertFullResultSet(s.executeQuery("select * from t3 order by x"), new String[][]{{"2"}, {"3"}});
        s.execute("delete from t3");
        s.execute("insert into t3 select * from t1 except select * from t2");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from t3 order by x"), "1");
        s.execute("delete from t3");
        s.execute("insert into t3 select * from t1 except all select * from t2");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from t3 order by x"), "1");
        s.execute("delete from t3");
    }

    public void testInsertFromSelectWithParameters() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table derby4671(x int)");
        s.execute("insert into derby4671 values (1), (2)");
        PreparedStatement ins1 = this.prepareStatement("insert into derby4671 select ? from derby4671");
        ins1.setInt(1, 7);
        InsertTest.assertUpdateCount(ins1, 2);
        JDBC.assertFullResultSet(s.executeQuery("select * from derby4671 order by x"), new String[][]{{"1"}, {"2"}, {"7"}, {"7"}});
        PreparedStatement ins2 = this.prepareStatement("insert into derby4671 select (x+?)*10 from derby4671");
        ins2.setInt(1, 77);
        InsertTest.assertUpdateCount(ins2, 4);
        JDBC.assertFullResultSet(s.executeQuery("select * from derby4671 order by x"), new String[][]{{"1"}, {"2"}, {"7"}, {"7"}, {"780"}, {"790"}, {"840"}, {"840"}});
        this.assertCompileError(PARAMETER_IN_SELECT_LIST, "insert into derby4671 select ? from derby4671 union select ? from derby4671");
        this.assertCompileError(PARAMETER_IN_SELECT_LIST, "insert into derby4671 select ? from derby4671 except select ? from derby4671");
        this.assertCompileError(PARAMETER_IN_SELECT_LIST, "insert into derby4671 select ? from derby4671 intersect select ? from derby4671");
    }

    public void testInsertTooManyDefaultColumns() throws SQLException {
        this.createStatement().execute("create table derby4449(x int)");
        this.assertCompileError(TOO_MANY_RESULT_COLUMNS, "insert into derby4449 values (default, default)");
        this.assertCompileError(TOO_MANY_RESULT_COLUMNS, "insert into derby4449 (x) values (default, default)");
    }

    public void testDerby6443() throws SQLException {
        Statement s = this.createStatement();
        this.setAutoCommit(false);
        s.execute("CREATE SCHEMA d6443");
        s.execute("SET SCHEMA d6443");
        s.execute("CREATE TABLE foo (name VARCHAR(20), val DOUBLE)");
        s.execute("CREATE TABLE summary (name VARCHAR(20), aver DOUBLE, size INT)");
        s.execute("CREATE TRIGGER trg_foo AFTER INSERT ON foo REFERENCING NEW TABLE AS changed FOR EACH STATEMENT INSERT INTO summary (name, aver, size) SELECT name, FLOOR(AVG(LOG10(val))), COUNT(*) FROM changed GROUP BY name");
        s.execute("INSERT INTO foo (name, val) VALUES ('A', 10), ('A', 20), ('B', 30), ('C', 40)");
        JDBC.assertFullResultSet(s.executeQuery("select * from foo order by val"), new String[][]{{"A", "10.0"}, {"A", "20.0"}, {"B", "30.0"}, {"C", "40.0"}});
        JDBC.assertFullResultSet(s.executeQuery("select * from summary order by name"), new String[][]{{"A", "1.0", "2"}, {"B", "1.0", "1"}, {"C", "1.0", "1"}});
        s.execute("create table t1(x int)");
        s.execute("insert into t1 values 1");
        s.execute("create table t2(x int)");
        s.execute("insert into t2 select floor(avg(x)) from t1");
        s.execute("create function f(x int) returns int language java parameter style java external name 'java.lang.Math.abs'");
        s.execute("insert into t2 select f(avg(x)) from t1");
        s.execute("insert into t2 select f((select x from t1)) from t1");
        JDBC.assertFullResultSet(s.executeQuery("select * from t2"), new String[][]{{"1"}, {"1"}, {"1"}});
    }
}

