/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.IntegerArrayVTI;
import org.apache.derbyTesting.functionTests.tests.lang.Permission;
import org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class MergeStatementTest
extends GeneratedColumnsHelper {
    private static final String TRACE_FILE_NAME = "mergeStatementTest.xml";
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String FRANK = "FRANK";
    private static final String TONY = "TONY";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH", "FRANK", "TONY"};
    private static final String TARGET_MUST_BE_BASE = "42XAK";
    private static final String SOURCE_MUST_BE_BASE_VIEW_OR_VTI = "42XAL";
    private static final String SAME_EXPOSED_NAME = "42XAM";
    private static final String DUPLICATE_COLUMNS = "42X13";
    private static final String COLUMN_NOT_IN_TABLE = "42X14";
    private static final String COLUMN_COUNT_MISMATCH = "42802";
    private static final String DUPLICATE_SET_COLUMNS = "42X16";
    private static final String MISSING_TABLE = "42X05";
    private static final String NO_ROWS_AFFECTED = "02000";
    private static final String NO_DML_IN_BEFORE_TRIGGERS = "42Z9D";
    private static final String NO_SUBQUERIES_IN_MATCHED_CLAUSE = "42XAO";
    private static final String NO_SYNONYMS_IN_MERGE = "42XAP";
    private static final String NO_DCL_IN_MERGE = "42XAQ";
    private static final String PARAMETER_NOT_SET = "07000";
    private static final String CARDINALITY_VIOLATION = "21000";
    private static final String NO_AGGREGATE_IN_MATCHING = "42Z09";
    private static final String[] TRIGGER_HISTORY_COLUMNS = new String[]{"ACTION", "ACTION_VALUE"};
    private static final String BEGIN_HTML = "<html>";
    private static final String END_HTML = "</html>";
    private static ArrayList<String[]> _triggerHistory = new ArrayList();

    public MergeStatementTest(String name) {
        super(name);
    }

    public String expectedCollation() {
        return "UCS_BASIC";
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite();
        suite.addTest(MergeStatementTest.standardDecoration(false));
        suite.addTest(MergeStatementTest.standardDecoration(true));
        return suite;
    }

    private static Test standardDecoration(boolean withCollation) {
        Object cleanTest = withCollation ? Decorator.territoryCollatedDatabase(TestConfiguration.embeddedSuite(Collated.class), "en") : new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(MergeStatementTest.class));
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthentication(cleanTest, LEGAL_USERS, "MergeStatementPermissions");
        Test authorizedTest = TestConfiguration.sqlAuthorizationDecorator(authenticatedTest);
        return new SupportFilesSetup(authorizedTest);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.enableSQLAuthorization();
    }

    public void test_001_badSyntax() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1( c1 int generated always as identity, c2 int, c3 int generated always as ( c1 + c2 ), c1_4 int )");
        this.goodStatement(dboConnection, "create table t2( c1 int generated always as identity, c2 int, c3 int, c4 int, c5 varchar( 5 ) )");
        this.goodStatement(dboConnection, "create table t3( c1 int generated always as identity, c2 int, c3 int )");
        this.goodStatement(dboConnection, "create view v1 as select * from t1");
        this.goodStatement(dboConnection, "create view v2 as select * from t2");
        this.goodStatement(dboConnection, "create function integerList()\nreturns table( s_r int, s_nr int, ns_r int, ns_nr int )\nlanguage java\nparameter style derby_jdbc_result_set\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest.integerList'\n");
        this.goodStatement(dboConnection, "create function illegalFunction() returns int\nlanguage java parameter style java contains sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.illegalFunction'\n");
        this.expectCompilationError(dboConnection, "42X01", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched then insert\n");
        this.expectCompilationError(dboConnection, "42X01", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched then delete\n");
        this.expectCompilationError(dboConnection, "42X01", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched then update\n");
        this.expectCompilationError(dboConnection, TARGET_MUST_BE_BASE, "merge into v1\nusing t2\non v1.c1 = t2.c1\nwhen matched then delete\n");
        this.expectCompilationError(dboConnection, TARGET_MUST_BE_BASE, "merge into table( integerList() ) i\nusing t2\non i.s_r = t2.c1\nwhen matched then delete\n");
        this.expectCompilationError(dboConnection, TARGET_MUST_BE_BASE, "merge into (t1 left join t3 on t1.c3 = t3.c3)\nusing t2\non c4 is not null\nwhen matched then delete\n");
        this.expectCompilationError(dboConnection, TARGET_MUST_BE_BASE, "merge into v1 v\nusing t2 t\non v.c1 = t.c1\nwhen matched then delete\n");
        this.expectCompilationError(dboConnection, SOURCE_MUST_BE_BASE_VIEW_OR_VTI, "merge into t1\nusing ( t3 left join t2 on t3.c3 = t2.c3 )\non t1.c1 is not null\nwhen matched then delete\n");
        this.expectCompilationError(dboConnection, SAME_EXPOSED_NAME, "merge into t1 t2\nusing t2\non c4 is null\nwhen matched then delete\n");
        this.expectCompilationError(dboConnection, SAME_EXPOSED_NAME, "merge into t1\nusing t2 t1\non c4 is not null\nwhen matched then delete\n");
        this.expectCompilationError(dboConnection, SAME_EXPOSED_NAME, "merge into t1 v\nusing t2 v\non c4 is not null\nwhen matched then delete\n");
        this.expectCompilationError(dboConnection, "42X04", "merge into t1\nusing t2\non t3.c1 = t2.c1\nwhen matched then delete\n");
        this.expectCompilationError(dboConnection, "42X04", "merge into t1 using t2 on no_such_column when matched then delete");
        this.expectCompilationError(dboConnection, "42X04", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched and t3.c2 is null then insert ( c2 ) values ( t2.c2 )\n");
        this.expectCompilationError(dboConnection, "42X04", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched and t3.c2 = t2.c2 then update set c1_4 = t2.c3\n");
        this.expectCompilationError(dboConnection, "42X04", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched and t3.c2 = t2.c2 then delete\n");
        this.expectCompilationError(dboConnection, "42X04", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched and t1.c2 is null then insert ( c2 ) values ( t2.c2 )\n");
        this.expectCompilationError(dboConnection, "42XA5", "merge into t1\nusing t2\non t1.c1 = t2.c1 and t2.c2 = illegalFunction()\nwhen matched then delete\n");
        this.expectCompilationError(dboConnection, "42XA5", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched and t2.c2 = illegalFunction() then delete\n");
        this.expectCompilationError(dboConnection, "42XA5", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched and t2.c2 = illegalFunction() then update set c2 = t2.c2\n");
        this.expectCompilationError(dboConnection, "42XA5", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched and t2.c2 = illegalFunction() then insert ( c2 ) values ( t2.c2 )\n");
        this.expectCompilationError(dboConnection, "42Z23", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched then insert ( c1, c2 ) values ( t2.c1, t2.c2 )\n");
        this.expectCompilationError(dboConnection, "42XA3", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched then insert ( c2, c3 ) values ( t2.c2, t2.c3 )\n");
        this.expectCompilationError(dboConnection, "42Z23", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched and t1.c2 != t2.c2 then update set c1 = t2.c2\n");
        this.expectCompilationError(dboConnection, "42XA3", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched and t1.c2 != t2.c2 then update set c3 = t2.c2\n");
        this.expectCompilationError(dboConnection, DUPLICATE_COLUMNS, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched then insert ( c2, c2 ) values ( t2.c2, t2.c3 )\n");
        this.expectCompilationError(dboConnection, COLUMN_NOT_IN_TABLE, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched then insert ( c2, c5 ) values ( t2.c2, t2.c3 )\n");
        this.expectCompilationError(dboConnection, "42821", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched then insert ( c2 ) values ( t2.c5 )\n");
        this.expectCompilationError(dboConnection, "42X04", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched then insert ( c2 ) values ( c1_4 )\n");
        this.expectCompilationError(dboConnection, COLUMN_COUNT_MISMATCH, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched then insert ( c2, c1_4 ) values ( t2.c2 )\n");
        this.expectCompilationError(dboConnection, COLUMN_COUNT_MISMATCH, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched then insert ( c2 ) values ( t2.c2, t2.c3 )\n");
        this.expectCompilationError(dboConnection, TARGET_MUST_BE_BASE, "create trigger trig1 after update on t1\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into new_cor\nusing t2\non new_cor.c1 = t2.c1\nwhen not matched then insert ( c2 ) values ( t2.c2 )\n");
        this.expectCompilationError(dboConnection, TARGET_MUST_BE_BASE, "create trigger trig2 after update on t1\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into old_cor\nusing t2\non old_cor.c1 = t2.c1\nwhen not matched then insert ( c2 ) values ( t2.c2 )\n");
        this.expectCompilationError(dboConnection, DUPLICATE_SET_COLUMNS, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched and t1.c2 != t2.c2 then update set c2 = t2.c2, c2 = t2.c1\n");
        this.expectCompilationError(dboConnection, COLUMN_NOT_IN_TABLE, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched and t1.c2 != t2.c2 then update set c5 = t2.c2\n");
        this.expectCompilationError(dboConnection, "42821", "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched and t1.c2 != t2.c2 then update set c2 = t2.c5\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched then delete\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched and t1.c2 = t2.c2 then delete\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched then insert ( c2 ) values ( t2.c2 )\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched and t2.c2 is null then insert ( c2 ) values ( t2.c2 )\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched then insert ( c1, c2 ) values ( default, t2.c2 )\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen not matched then insert ( c2, c3 ) values ( t2.c2, default )\n");
        this.expectNoWarning(dboConnection, "merge into t1\nusing table( integerList() ) i\non t1.c1 = i.s_r\nwhen matched then delete\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched then update set c2 = t2.c3\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched and t1.c2 = t2.c2 then update set c2 = t2.c3\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched and t1.c2 != t2.c2 then update set c2 = t2.c2\nwhen not matched then insert ( c2 ) values ( t2.c2 )\n");
        this.goodStatement(dboConnection, "create trigger trig3 after update on t2\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into t1\nusing new_cor\non t1.c1 = new_cor.c1\nwhen matched then delete\n");
        this.goodStatement(dboConnection, "create trigger trig4 after update on t2\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into t1\nusing old_cor\non t1.c1 = old_cor.c1\nwhen matched then delete\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into t1\nusing t2\non t1.c1 = t2.c1\nwhen matched and t1.c2 != t2.c2 then update set c3 = default, c2 = t2.c2\n");
        this.goodStatement(dboConnection, "drop function illegalFunction");
        this.goodStatement(dboConnection, "drop function integerList");
        this.goodStatement(dboConnection, "drop view v2");
        this.goodStatement(dboConnection, "drop view v1");
        this.goodStatement(dboConnection, "drop table t3");
        this.goodStatement(dboConnection, "drop table t2");
        this.goodStatement(dboConnection, "drop table t1");
        MergeStatementTest.truncateTriggerHistory();
    }

    public void test_002_deleteAction() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_002( c1 int, c2 int, c3 int generated always as ( c1 + c2 ), c1_4 int )");
        this.goodStatement(dboConnection, "create table t2_002( c1 int, c2 int, c3 int, c4 int, c5 varchar( 5 ) )");
        this.vet_002(dboConnection, "merge into t1_002\nusing t2_002\non 2 * t1_002.c2 = 2 * t2_002.c2\nwhen matched then delete\n", 4, new String[][]{{"5", "5", "10", "5"}, {"6", "20", "26", "40"}});
        this.vet_002(dboConnection, "merge into t1_002\nusing t2_002\non 2 * t1_002.c2 = 2 * t2_002.c2\nwhen matched and c1_4 = 5 then delete\n", 3, new String[][]{{"1", "2", "3", "4"}, {"5", "5", "10", "5"}, {"6", "20", "26", "40"}});
        this.goodStatement(dboConnection, "drop table t2_002");
        this.goodStatement(dboConnection, "drop table t1_002");
        MergeStatementTest.truncateTriggerHistory();
    }

    private void vet_002(Connection conn, String query, int rowsAffected, String[][] expectedResults) throws Exception {
        this.vet_002(conn, query, rowsAffected, expectedResults, false);
        this.vet_002(conn, query, rowsAffected, expectedResults, true);
    }

    private void vet_002(Connection conn, String query, int rowsAffected, String[][] expectedResults, boolean useHashJoinStrategy) throws Exception {
        if (useHashJoinStrategy) {
            query = this.makeHashJoinMerge(query);
        }
        this.populate_002(conn);
        this.goodUpdate(conn, query, rowsAffected);
        this.assertResults(conn, "select * from t1_002 order by c1", expectedResults, false);
    }

    private void populate_002(Connection conn) throws Exception {
        this.goodStatement(conn, "delete from t2_002");
        this.goodStatement(conn, "delete from t1_002");
        this.goodStatement(conn, "insert into t1_002( c1, c2, c1_4 ) values ( 1, 2, 4 ), (2, 2, 5), (3, 3, 5), (4, 4, 5), (5, 5, 5), ( 6, 20, 40 )");
        this.goodStatement(conn, "insert into t2_002( c1, c2, c3, c4, c5 ) values ( 1, 2, 3, 4, 'five' ), ( 2, 3, 3, 4, 'five' ), ( 3, 4, 3, 4, 'five' ), ( 4, 200, 300, 400, 'five' )");
    }

    public void test_003_cascadingDeleteAction() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_003( c1 int, c2 int primary key, c3 int )");
        this.goodStatement(dboConnection, "create table t2_003( c4 int, c5 int, c6 int )");
        this.goodStatement(dboConnection, "create table t3_003( c1 int, c2 int references t1_003( c2 ) on delete cascade, c3 int )");
        this.vet_003(dboConnection, "merge into t1_003\nusing t2_003\non 2 * t1_003.c1 = 2 * t2_003.c4\nwhen matched then delete\n", 2, new String[][]{{"-3", "30", "200"}, {"5", "50", "500"}, {"6", "60", "600"}}, new String[][]{{"-3", "30", "300"}, {"5", "50", "500"}, {"6", "60", "600"}});
        this.vet_003(dboConnection, "merge into t1_003\nusing t2_003\non 2 * t1_003.c1 = 2 * t2_003.c4\nwhen matched and c3 = 200 then delete\n", 1, new String[][]{{"-3", "30", "200"}, {"1", "10", "100"}, {"5", "50", "500"}, {"6", "60", "600"}}, new String[][]{{"-3", "30", "300"}, {"1", "10", "100"}, {"5", "50", "500"}, {"6", "60", "600"}});
        this.goodStatement(dboConnection, "drop table t3_003");
        this.goodStatement(dboConnection, "drop table t2_003");
        this.goodStatement(dboConnection, "drop table t1_003");
        MergeStatementTest.truncateTriggerHistory();
    }

    private void vet_003(Connection conn, String query, int rowsAffected, String[][] expectedT1Results, String[][] expectedT3Results) throws Exception {
        this.vet_003(conn, query, rowsAffected, expectedT1Results, expectedT3Results, false);
        this.vet_003(conn, query, rowsAffected, expectedT1Results, expectedT3Results, true);
    }

    private void vet_003(Connection conn, String query, int rowsAffected, String[][] expectedT1Results, String[][] expectedT3Results, boolean useHashJoinStrategy) throws Exception {
        if (useHashJoinStrategy) {
            query = this.makeHashJoinMerge(query);
        }
        this.populate_003(conn);
        this.goodUpdate(conn, query, rowsAffected);
        this.assertResults(conn, "select * from t1_003 order by c1", expectedT1Results, false);
        this.assertResults(conn, "select * from t3_003 order by c1", expectedT3Results, false);
    }

    private void populate_003(Connection conn) throws Exception {
        this.goodStatement(conn, "delete from t3_003");
        this.goodStatement(conn, "delete from t2_003");
        this.goodStatement(conn, "delete from t1_003");
        this.goodStatement(conn, "insert into t1_003( c1, c2, c3 ) values ( 1, 10, 100 ), (2, 20, 200), ( -3, 30, 200 ), ( 5, 50, 500 ), ( 6, 60, 600 )");
        this.goodStatement(conn, "insert into t2_003( c4, c5, c6 ) values ( 1, 10, 100 ), (2, 20, 200), ( 3, 30, 300 ), ( 4, 40, 400 )");
        this.goodStatement(conn, "insert into t3_003( c1, c2, c3 ) values ( 1, 10, 100 ), (2, 20, 200), ( -3, 30, 300 ), ( 5, 50, 500 ), ( 6, 60, 600 )");
    }

    public void test_004_deleteActionStatementTriggers() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_004( c1 int, c2 int, c3 int )");
        this.goodStatement(dboConnection, "create table t2_004( c1 int generated always as identity, c2 int )");
        this.goodStatement(dboConnection, "create procedure countRows_004\n(\n    candidateName varchar( 20 ),\n    actionString varchar( 20 )\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.countRows'\n");
        this.goodStatement(dboConnection, "create procedure truncateTriggerHistory_004()\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.truncateTriggerHistory'\n");
        this.goodStatement(dboConnection, "create function history_004()\nreturns table\n(\n    action varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.history'\n");
        this.goodStatement(dboConnection, "create trigger t1_004_del_before\nno cascade before delete on t1_004\nfor each statement\ncall countRows_004( 't1_004', 'before' )\n");
        this.goodStatement(dboConnection, "create trigger t1_004_del_after\nafter delete on t1_004\nfor each statement\ncall countRows_004( 't1_004', 'after' )\n");
        this.vet_004(dboConnection, "merge into t1_004\nusing t2_004\non 2 * t1_004.c2 = 2 * t2_004.c2\nwhen matched then delete\n", 4, new String[][]{{"3", "30", "300"}}, new String[][]{{"before", "5"}, {"after", "1"}});
        this.vet_004(dboConnection, "merge into t1_004\nusing t2_004\non 2 * t1_004.c2 = 2 * t2_004.c2\nwhen matched and c3 = 200 then delete\n", 1, new String[][]{{"1", "10", "100"}, {"3", "30", "300"}, {"4", "40", "400"}, {"5", "50", "500"}}, new String[][]{{"before", "5"}, {"after", "4"}});
        this.goodStatement(dboConnection, "drop trigger t1_004_del_before");
        this.goodStatement(dboConnection, "drop trigger t1_004_del_after");
        this.goodStatement(dboConnection, "drop function history_004");
        this.goodStatement(dboConnection, "drop procedure truncateTriggerHistory_004");
        this.goodStatement(dboConnection, "drop procedure countRows_004");
        this.goodStatement(dboConnection, "drop table t2_004");
        this.goodStatement(dboConnection, "drop table t1_004");
        MergeStatementTest.truncateTriggerHistory();
    }

    private void vet_004(Connection conn, String query, int rowsAffected, String[][] expectedT1Results, String[][] expectedHistoryResults) throws Exception {
        this.vet_004(conn, query, rowsAffected, expectedT1Results, expectedHistoryResults, false);
        this.vet_004(conn, query, rowsAffected, expectedT1Results, expectedHistoryResults, true);
    }

    private void vet_004(Connection conn, String query, int rowsAffected, String[][] expectedT1Results, String[][] expectedHistoryResults, boolean useHashJoinStrategy) throws Exception {
        if (useHashJoinStrategy) {
            query = this.makeHashJoinMerge(query);
        }
        this.populate_004(conn);
        this.goodUpdate(conn, query, rowsAffected);
        this.assertResults(conn, "select * from t1_004 order by c1", expectedT1Results, false);
        this.assertResults(conn, "select * from table( history_004() ) s", expectedHistoryResults, false);
    }

    private void populate_004(Connection conn) throws Exception {
        this.goodStatement(conn, "delete from t2_004");
        this.goodStatement(conn, "delete from t1_004");
        this.goodStatement(conn, "call truncateTriggerHistory_004()");
        this.goodStatement(conn, "insert into t1_004( c1, c2, c3 ) values ( 1, 10, 100 ), ( 2, 20, 200 ), ( 3, 30, 300 ), ( 4, 40, 400 ), ( 5, 50, 500 )");
        this.goodStatement(conn, "insert into t2_004( c2 ) values ( 10 ), ( 20 ), ( 40 ), ( 50 ), ( 60 ), ( 70 )");
    }

    public void test_005_deleteActionRowTriggers() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_005( c1 int, c2 int, c3 int )");
        this.goodStatement(dboConnection, "create table t2_005( c1 int generated always as identity, c2 int )");
        this.goodStatement(dboConnection, "create procedure addHistoryRow_005\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(dboConnection, "create procedure truncateTriggerHistory_005()\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.truncateTriggerHistory'\n");
        this.goodStatement(dboConnection, "create function history_005()\nreturns table\n(\n    action varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.history'\n");
        this.goodStatement(dboConnection, "create trigger t1_005_del_before\nno cascade before delete on t1_005\nreferencing old as old\nfor each row\ncall addHistoryRow_005( 'before', old.c1 )\n");
        this.goodStatement(dboConnection, "create trigger t1_005_del_after\nafter delete on t1_005\nreferencing old as old\nfor each row\ncall addHistoryRow_005( 'after', old.c1 )\n");
        this.goodStatement(dboConnection, "insert into t1_005( c1, c2, c3 ) values ( 1, 10, 100 ), ( 2, 20, 200 ), ( 3, 30, 300 ), ( 4, 40, 400 ), ( 5, 50, 500 )");
        this.goodStatement(dboConnection, "insert into t2_005( c2 ) values ( 10 ), ( 20 ), ( 40 ), ( 50 ), ( 60 ), ( 70 )");
        this.vet_005(dboConnection, "merge into t1_005\nusing t2_005\non 2 * t1_005.c2 = 2 * t2_005.c2\nwhen matched then delete\n", 4, new String[][]{{"3", "30", "300"}}, new String[][]{{"before", "1"}, {"before", "2"}, {"before", "4"}, {"before", "5"}, {"after", "1"}, {"after", "2"}, {"after", "4"}, {"after", "5"}});
        this.vet_005(dboConnection, "merge into t1_005\nusing t2_005\non 2 * t1_005.c2 = 2 * t2_005.c2\nwhen matched and c3 = 200 then delete\n", 1, new String[][]{{"1", "10", "100"}, {"3", "30", "300"}, {"4", "40", "400"}, {"5", "50", "500"}}, new String[][]{{"before", "2"}, {"after", "2"}});
        this.goodStatement(dboConnection, "drop trigger t1_005_del_before");
        this.goodStatement(dboConnection, "drop trigger t1_005_del_after");
        this.goodStatement(dboConnection, "drop function history_005");
        this.goodStatement(dboConnection, "drop procedure truncateTriggerHistory_005");
        this.goodStatement(dboConnection, "drop procedure addHistoryRow_005");
        this.goodStatement(dboConnection, "drop table t2_005");
        this.goodStatement(dboConnection, "drop table t1_005");
        MergeStatementTest.truncateTriggerHistory();
    }

    private void vet_005(Connection conn, String query, int rowsAffected, String[][] expectedT1Results, String[][] expectedHistoryResults) throws Exception {
        this.vet_005(conn, query, rowsAffected, expectedT1Results, expectedHistoryResults, false);
        this.vet_005(conn, query, rowsAffected, expectedT1Results, expectedHistoryResults, true);
    }

    private void vet_005(Connection conn, String query, int rowsAffected, String[][] expectedT1Results, String[][] expectedHistoryResults, boolean useHashJoinStrategy) throws Exception {
        if (useHashJoinStrategy) {
            query = this.makeHashJoinMerge(query);
        }
        this.populate_005(conn);
        this.goodUpdate(conn, query, rowsAffected);
        this.assertResults(conn, "select * from t1_005 order by c1", expectedT1Results, false);
        this.assertResults(conn, "select * from table( history_005() ) s", expectedHistoryResults, false);
    }

    private void populate_005(Connection conn) throws Exception {
        this.goodStatement(conn, "delete from t2_005");
        this.goodStatement(conn, "delete from t1_005");
        this.goodStatement(conn, "call truncateTriggerHistory_005()");
        this.goodStatement(conn, "insert into t1_005( c1, c2, c3 ) values ( 1, 10, 100 ), ( 2, 20, 200 ), ( 3, 30, 300 ), ( 4, 40, 400 ), ( 5, 50, 500 )");
        this.goodStatement(conn, "insert into t2_005( c2 ) values ( 10 ), ( 20 ), ( 40 ), ( 50 ), ( 60 ), ( 70 )");
    }

    public void test_006_deleteWithTransitionTableSource() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_006( c1 int, c2 int, c3 int generated always as ( c1 + c2 ), c1_4 int )");
        this.goodStatement(dboConnection, "create table t2_006( c1 int, c2 int, c3 int, c4 int, c5 varchar( 5 ) )");
        this.vet_006("create trigger trig1_006 after update on t2_006\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into t1_006\nusing new_cor\non 2 * t1_006.c2 = 2 * new_cor.c2\nwhen matched then delete\n", new String[][]{{"2", "2", "4", "200"}, {"4", "4", "8", "400"}});
        this.vet_006("create trigger trig1_006 after update on t2_006\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into t1_006\nusing new_cor\non 2 * t1_006.c2 = 2 * new_cor.c2\nwhen matched and c1_4 = 300 then delete\n", new String[][]{{"1", "1", "2", "100"}, {"2", "2", "4", "200"}, {"4", "4", "8", "400"}});
        this.vet_006("create trigger trig1_006 after update on t2_006\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into t1_006\nusing old_cor\non 2 * t1_006.c2 = 2 * old_cor.c2\nwhen matched then delete\n", new String[][]{{"1", "1", "2", "100"}, {"3", "3", "6", "300"}});
        this.vet_006("create trigger trig1_006 after update on t2_006\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into t1_006\nusing old_cor\non 2 * t1_006.c2 = 2 * old_cor.c2\nwhen matched and c1_4 = 200 then delete\n", new String[][]{{"1", "1", "2", "100"}, {"3", "3", "6", "300"}, {"4", "4", "8", "400"}});
        dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "drop table t2_006");
        this.goodStatement(dboConnection, "drop table t1_006");
        MergeStatementTest.truncateTriggerHistory();
    }

    private void vet_006(String triggerDefinition, String[][] expectedT1Results) throws Exception {
        this.vet_006(triggerDefinition, expectedT1Results, false);
        this.vet_006(triggerDefinition, expectedT1Results, true);
    }

    private void vet_006(String triggerDefinition, String[][] expectedT1Results, boolean useHashJoinStrategy) throws Exception {
        this.vet_006(triggerDefinition, expectedT1Results, useHashJoinStrategy, false);
        this.vet_006(triggerDefinition, expectedT1Results, useHashJoinStrategy, true);
    }

    private void vet_006(String triggerDefinition, String[][] expectedT1Results, boolean useHashJoinStrategy, boolean bounceDatabase) throws Exception {
        Connection conn = this.openUserConnection(TEST_DBO);
        if (useHashJoinStrategy) {
            triggerDefinition = this.makeHashJoinMerge(triggerDefinition);
        }
        this.goodStatement(conn, triggerDefinition);
        this.populate_006(conn);
        if (bounceDatabase) {
            conn = this.bounceDatabase(TEST_DBO);
        }
        this.goodStatement(conn, "update t2_006 set c2 = -c2");
        this.assertResults(conn, "select * from t1_006 order by c1", expectedT1Results, false);
        this.goodStatement(conn, "drop trigger trig1_006");
    }

    private Connection bounceDatabase(String newUser) throws Exception {
        MergeStatementTest.println("Bouncing the database...");
        this.getTestConfiguration().shutdownDatabase();
        return this.openUserConnection(newUser);
    }

    private void populate_006(Connection conn) throws Exception {
        this.goodStatement(conn, "delete from t2_006");
        this.goodStatement(conn, "delete from t1_006");
        this.goodStatement(conn, "insert into t1_006( c1, c2, c1_4 ) values ( 1, 1, 100 ), ( 2, 2, 200 ), ( 3, 3, 300 ), ( 4, 4, 400 )");
        this.goodStatement(conn, "insert into t2_006( c1, c2, c3, c4, c5 ) values ( 1, -1, -10, -100, 'one' ), ( 2, 2, -2, -200, 'two' ), ( 3, -3, -30, -300, 'three' ), ( 4, 4, -40, -400, 'four' )");
    }

    public void test_007_insertGeneratedColumnsAndDefaults() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_007\n(\n    c1 int generated always as identity,\n    c2 int,\n    c3 int generated always as ( c1 + c2 ),\n    c1_4 int,\n    c5 int default 1000\n)\n");
        this.goodStatement(dboConnection, "create table t2_007( c1 int generated always as identity, c2 int, c3 int, c4 int, c5 varchar( 5 ) )\n");
        this.goodStatement(dboConnection, "create table t3_007\n(\n    c1 int generated by default as identity,\n    c2 int,\n    c3 int generated always as ( c1 + c2 ),\n    c1_4 int,\n    c5 int default 1000\n)\n");
        this.goodStatement(dboConnection, "create function nop_007( a int ) returns int\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.nop'\n");
        this.goodStatement(dboConnection, "insert into t1_007( c2, c1_4 ) values ( 1, 100 ), (2, 200 ), ( 3, 300 ), ( 4, 400 )\n");
        this.goodStatement(dboConnection, "insert into t2_007( c2, c3, c4, c5 ) values\n( -1, -101, -100, 'one' ), ( 2, -201, -200, 'two' ), ( -3, -301, -300, 'three' ), ( 4, -401, -400, 'four' )\n");
        this.goodStatement(dboConnection, "insert into t3_007( c2, c1_4 ) values ( 1, 100 ), (2, 200 ), ( 3, 300 ), ( 4, 400 )\n");
        this.goodUpdate(dboConnection, "merge into t1_007\nusing t2_007\non t1_007.c2 = t2_007.c2\nwhen not matched then insert ( c2, c1_4 ) values ( 10 * t2_007.c2, t2_007.c3 )\n", 2);
        this.assertResults(dboConnection, "select * from t1_007 order by c1", new String[][]{{"1", "1", "2", "100", "1000"}, {"2", "2", "4", "200", "1000"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "400", "1000"}, {"5", "-10", "-5", "-101", "1000"}, {"6", "-30", "-24", "-301", "1000"}}, false);
        this.goodUpdate(dboConnection, "merge into t1_007\nusing t2_007\non t1_007.c2 = t2_007.c2\nwhen not matched and t2_007.c5 = 'three'\n    then insert ( c1, c2, c3, c1_4, c5 ) values ( default, 100 * t2_007.c2, default, t2_007.c3, default )\n", 1);
        this.assertResults(dboConnection, "select * from t1_007 order by c1", new String[][]{{"1", "1", "2", "100", "1000"}, {"2", "2", "4", "200", "1000"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "400", "1000"}, {"5", "-10", "-5", "-101", "1000"}, {"6", "-30", "-24", "-301", "1000"}, {"7", "-300", "-293", "-301", "1000"}}, false);
        this.goodUpdate(dboConnection, "merge into t3_007\nusing t2_007\non t3_007.c2 = t2_007.c2\nwhen not matched then insert ( c2, c1_4 ) values ( 10 * t2_007.c2, t2_007.c3 )\n", 2);
        this.assertResults(dboConnection, "select * from t3_007 order by c1", new String[][]{{"1", "1", "2", "100", "1000"}, {"2", "2", "4", "200", "1000"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "400", "1000"}, {"5", "-10", "-5", "-101", "1000"}, {"6", "-30", "-24", "-301", "1000"}}, false);
        this.goodUpdate(dboConnection, "merge into t3_007\nusing t2_007\non t3_007.c2 = t2_007.c2\nwhen not matched and t2_007.c5 = 'three'\n    then insert ( c1, c2, c3, c1_4, c5 ) values ( default, 100 * t2_007.c2, default, t2_007.c3, default )\n", 1);
        this.assertResults(dboConnection, "select * from t3_007 order by c1", new String[][]{{"1", "1", "2", "100", "1000"}, {"2", "2", "4", "200", "1000"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "400", "1000"}, {"5", "-10", "-5", "-101", "1000"}, {"6", "-30", "-24", "-301", "1000"}, {"7", "-300", "-293", "-301", "1000"}}, false);
        this.goodUpdate(dboConnection, "merge into t1_007\nusing t2_007\non t1_007.c2 = t2_007.c2\nwhen not matched and t2_007.c5 = 'three'\n    then insert ( c1 ) values ( default )\n", 1);
        this.expectCompilationError(dboConnection, "42Z23", "merge into t1_007\nusing t2_007\non t1_007.c2 = t2_007.c2\nwhen not matched and t2_007.c5 = 'three'\n    then insert ( c1 ) values ( -1 )\n");
        this.expectCompilationError(dboConnection, "42Z23", "merge into t1_007\nusing t2_007\non t1_007.c2 = t2_007.c2\nwhen not matched and t2_007.c5 = 'three'\n    then insert ( c1 ) values ( null )\n");
        this.assertResults(dboConnection, "select * from t1_007 order by c1", new String[][]{{"1", "1", "2", "100", "1000"}, {"2", "2", "4", "200", "1000"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "400", "1000"}, {"5", "-10", "-5", "-101", "1000"}, {"6", "-30", "-24", "-301", "1000"}, {"7", "-300", "-293", "-301", "1000"}, {"8", null, null, null, "1000"}}, false);
        this.goodUpdate(dboConnection, "merge into t3_007\nusing t2_007\non t3_007.c2 = t2_007.c2\nwhen not matched and t2_007.c5 = 'three'\n    then insert ( c1 ) values ( default )\n", 1);
        this.goodUpdate(dboConnection, "merge into t3_007\nusing t2_007\non t3_007.c2 = t2_007.c2\nwhen not matched and t2_007.c5 = 'three'\n    then insert ( c1 ) values ( -1 )\n", 1);
        this.expectCompilationError(dboConnection, "23502", "merge into t3_007\nusing t2_007\non t3_007.c2 = t2_007.c2\nwhen not matched and t2_007.c5 = 'three'\n    then insert ( c1 ) values ( null )\n");
        this.goodUpdate(dboConnection, "merge into t3_007\nusing t2_007\non t3_007.c2 = t2_007.c2\nwhen not matched and t2_007.c5 = 'three'\n    then insert ( c1 ) values ( nop_007( -2 ) )\n", 1);
        this.expectExecutionError(dboConnection, "23502", "merge into t3_007\nusing t2_007\non t3_007.c2 = t2_007.c2\nwhen not matched and t2_007.c5 = 'three'\n    then insert ( c1 ) values ( nop_007( null ) )\n");
        this.assertResults(dboConnection, "select * from t3_007 order by c1", new String[][]{{"-2", null, null, null, "1000"}, {"-1", null, null, null, "1000"}, {"1", "1", "2", "100", "1000"}, {"2", "2", "4", "200", "1000"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "400", "1000"}, {"5", "-10", "-5", "-101", "1000"}, {"6", "-30", "-24", "-301", "1000"}, {"7", "-300", "-293", "-301", "1000"}, {"8", null, null, null, "1000"}}, false);
        this.goodStatement(dboConnection, "drop function nop_007");
        this.goodStatement(dboConnection, "drop table t3_007");
        this.goodStatement(dboConnection, "drop table t2_007");
        this.goodStatement(dboConnection, "drop table t1_007");
        MergeStatementTest.truncateTriggerHistory();
    }

    public void test_008_insertAndCheckConstraint() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_008\n(\n    c1 int generated always as identity,\n    c2 int,\n    c3 int generated always as ( c1 + c2 ),\n    c1_4 int,\n    c5 int default 1000,\n    check( (c1_4 + c3) > -325 )\n)\n");
        this.goodStatement(dboConnection, "create table t2_008( c1 int generated always as identity, c2 int, c3 int, c4 int, c5 varchar( 5 ) )\n");
        this.goodStatement(dboConnection, "insert into t1_008( c2, c1_4 ) values ( 1, 100 ), (2, 200 ), ( 3, 300 ), ( 4, 400 )\n");
        this.goodStatement(dboConnection, "insert into t2_008( c2, c3, c4, c5 ) values\n( -1, -101, -100, 'one' ), ( 2, -201, -200, 'two' ), ( -3, -301, -300, 'three' ), ( 4, -401, -400, 'four' )\n");
        this.expectExecutionError(dboConnection, "23513", "merge into t1_008\nusing t2_008\non t1_008.c2 = t2_008.c2\nwhen not matched then insert ( c2, c1_4 ) values ( 10 * t2_008.c2, t2_008.c3 )\n");
        this.goodUpdate(dboConnection, "merge into t1_008\nusing t2_008\non t1_008.c2 = t2_008.c2\nwhen not matched then insert ( c2, c1_4 ) values ( ( 10 * t2_008.c2 ) + 1, t2_008.c3 )\n", 2);
        this.assertResults(dboConnection, "select * from t1_008 order by c1", new String[][]{{"1", "1", "2", "100", "1000"}, {"2", "2", "4", "200", "1000"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "400", "1000"}, {"7", "-9", "-2", "-101", "1000"}, {"8", "-29", "-21", "-301", "1000"}}, false);
        this.goodStatement(dboConnection, "drop table t2_008");
        this.goodStatement(dboConnection, "drop table t1_008");
        MergeStatementTest.truncateTriggerHistory();
    }

    public void test_009_insertAndUniqueForeignConstraint() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t3_009( c2 int primary key )\n");
        this.goodStatement(dboConnection, "create table t1_009\n(\n    c1 int generated always as identity primary key,\n    c2 int unique,\n    c3 int generated always as ( c1 + c2 ),\n    c1_4 int,\n    c5 int default 1000,\n    foreign key ( c2 ) references t3_009( c2 )\n)\n");
        this.goodStatement(dboConnection, "create table t2_009( c1 int generated always as identity, c2 int, c3 int, c4 int, c5 varchar( 5 ) )\n");
        this.goodStatement(dboConnection, "insert into t3_009( c2 ) values ( 1 ), ( 2 ), ( 3 ), ( 4 ), ( -10 ), ( -30 ), ( -100 )\n");
        this.goodStatement(dboConnection, "insert into t1_009( c2, c1_4 ) values ( 1, 100 ), (2, 200 ), ( 3, 300 ), ( 4, 400 )\n");
        this.goodStatement(dboConnection, "insert into t2_009( c2, c3, c4, c5 ) values\n( -1, -101, -100, 'one' ), ( 2, -201, -200, 'two' ), ( -3, -301, -300, 'three' ), ( 4, -401, -400, 'four' )\n");
        String nonRepeatableMerge = "merge into t1_009\nusing t2_009\non t1_009.c2 = t2_009.c2\nwhen not matched then insert ( c2, c1_4 ) values ( 10 * t2_009.c2, t2_009.c3 )\n";
        this.goodUpdate(dboConnection, nonRepeatableMerge, 2);
        this.expectExecutionError(dboConnection, "23505", nonRepeatableMerge);
        this.expectExecutionError(dboConnection, "23505", nonRepeatableMerge);
        this.expectExecutionError(dboConnection, "23503", "merge into t1_009\nusing t2_009\non t1_009.c2 = t2_009.c2\nwhen not matched then insert ( c2, c1_4 ) values ( 100 * t2_009.c2, t2_009.c3 )\n");
        this.assertResults(dboConnection, "select * from t1_009 order by c1", new String[][]{{"1", "1", "2", "100", "1000"}, {"2", "2", "4", "200", "1000"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "400", "1000"}, {"5", "-10", "-5", "-101", "1000"}, {"6", "-30", "-24", "-301", "1000"}}, false);
        this.goodStatement(dboConnection, "drop table t2_009");
        this.goodStatement(dboConnection, "drop table t1_009");
        this.goodStatement(dboConnection, "drop table t3_009");
        MergeStatementTest.truncateTriggerHistory();
    }

    public void test_010_insertStatementTriggers() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_010( c1 int generated always as identity, c2 int, c3 int )\n");
        this.goodStatement(dboConnection, "create table t2_010( c1 int generated always as identity, c2 int )\n");
        this.goodStatement(dboConnection, "create procedure countRows_010\n(\n    candidateName varchar( 20 ),\n    actionString varchar( 20 )\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.countRows'\n");
        this.goodStatement(dboConnection, "create function history_010()\nreturns table\n(\n    action varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.history'\n");
        this.goodStatement(dboConnection, "insert into t1_010( c2, c3 ) values ( 10, 100 ), ( -20, 200 ), ( 30, 300 ), ( -40, 400 ), ( 50, 500 ), ( -60, 600 )\n");
        this.goodStatement(dboConnection, "insert into t2_010( c2 ) values ( 10 ), ( 20 ), ( 30 ), ( 50 ), ( 100 )\n");
        this.goodStatement(dboConnection, "create trigger t1_010_del_before\nno cascade before insert on t1_010\nfor each statement\ncall countRows_010( 't1_010', 'before' )\n");
        this.goodStatement(dboConnection, "create trigger t1_010_del_after\nafter insert on t1_010\nfor each statement\ncall countRows_010( 't1_010', 'after' )\n");
        MergeStatementTest.truncateTriggerHistory();
        this.goodUpdate(dboConnection, "merge into t1_010\nusing t2_010\non t1_010.c2 = t2_010.c2\nwhen not matched then insert ( c2, c3 ) values ( 10 * t2_010.c2, t2_010.c1 )\n", 2);
        this.assertResults(dboConnection, "select * from t1_010 order by c1", new String[][]{{"1", "10", "100"}, {"2", "-20", "200"}, {"3", "30", "300"}, {"4", "-40", "400"}, {"5", "50", "500"}, {"6", "-60", "600"}, {"7", "200", "2"}, {"8", "1000", "5"}}, false);
        this.assertResults(dboConnection, "select * from table( history_010() ) s", new String[][]{{"before", "6"}, {"after", "8"}}, false);
        this.goodStatement(dboConnection, "drop table t2_010");
        this.goodStatement(dboConnection, "drop table t1_010");
        this.goodStatement(dboConnection, "drop procedure countRows_010");
        this.goodStatement(dboConnection, "drop function history_010");
        MergeStatementTest.truncateTriggerHistory();
    }

    public void test_011_insertRowTriggers() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_011( c1 int generated always as identity, c2 int, c3 int )\n");
        this.goodStatement(dboConnection, "create table t2_011( c1 int generated always as identity, c2 int )\n");
        this.goodStatement(dboConnection, "create procedure addHistoryRow_011\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(dboConnection, "create function history_011()\nreturns table\n(\n    action varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.history'\n");
        this.goodStatement(dboConnection, "insert into t1_011( c2, c3 ) values ( 10, 100 ), ( -20, 200 ), ( 30, 300 ), ( -40, 400 ), ( 50, 500 ), ( -60, 600 )\n");
        this.goodStatement(dboConnection, "insert into t2_011( c2 ) values ( 10 ), ( 20 ), ( 30 ), ( 50 ), ( 100 )\n");
        this.goodStatement(dboConnection, "create trigger t1_011_ins_before\nno cascade before insert on t1_011\nreferencing new as new\nfor each row\ncall addHistoryRow_011( 'before', new.c1 )\n");
        this.goodStatement(dboConnection, "create trigger t1_011_ins_after\nafter insert on t1_011\nreferencing new as new\nfor each row\ncall addHistoryRow_011( 'after', new.c1 )\n");
        MergeStatementTest.truncateTriggerHistory();
        this.goodUpdate(dboConnection, "merge into t1_011\nusing t2_011\non t1_011.c2 = t2_011.c2\nwhen not matched then insert ( c2, c3 ) values ( 10 * t2_011.c2, t2_011.c1 )\n", 2);
        this.assertResults(dboConnection, "select * from t1_011 order by c1", new String[][]{{"1", "10", "100"}, {"2", "-20", "200"}, {"3", "30", "300"}, {"4", "-40", "400"}, {"5", "50", "500"}, {"6", "-60", "600"}, {"7", "200", "2"}, {"8", "1000", "5"}}, false);
        this.assertResults(dboConnection, "select * from table( history_011() ) s", new String[][]{{"before", "7"}, {"before", "8"}, {"after", "7"}, {"after", "8"}}, false);
        this.goodStatement(dboConnection, "drop table t2_011");
        this.goodStatement(dboConnection, "drop table t1_011");
        this.goodStatement(dboConnection, "drop procedure addHistoryRow_011");
        this.goodStatement(dboConnection, "drop function history_011");
        MergeStatementTest.truncateTriggerHistory();
    }

    public void test_012_insertWithTransitionTableSource() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_012( c1 int, c2 int, c3 int generated always as ( c1 + c2 ), c1_4 int )\n");
        this.goodStatement(dboConnection, "create table t2_012( c1 int, c2 int, c3 int, c4 int, c5 varchar( 5 ) )\n");
        String update = "update t2_012 set c2 = -c2";
        this.vet_012("create trigger trig1_012 after update on t2_012\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into t1_012\nusing new_cor\non t1_012.c2 = new_cor.c2\nwhen not matched then insert ( c1, c2, c1_4 ) values ( new_cor.c1, new_cor.c2, new_cor.c4 )\n", update, new String[][]{{"1", "1", "2", "100"}, {"2", "-2", "0", "-200"}, {"2", "2", "4", "200"}, {"3", "3", "6", "300"}, {"4", "-4", "0", "-400"}, {"4", "4", "8", "400"}});
        this.vet_012("create trigger trig1_012 after update on t2_012\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into t1_012\nusing old_cor\non t1_012.c2 = old_cor.c2\nwhen not matched then insert ( c1, c2, c1_4 ) values ( old_cor.c1, old_cor.c2, old_cor.c4 )\n", update, new String[][]{{"1", "-1", "0", "-100"}, {"1", "1", "2", "100"}, {"2", "2", "4", "200"}, {"3", "-3", "0", "-300"}, {"3", "3", "6", "300"}, {"4", "4", "8", "400"}});
        dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "drop table t2_012");
        this.goodStatement(dboConnection, "drop table t1_012");
    }

    private void vet_012(String triggerDefinition, String update, String[][] expectedResults) throws Exception {
        this.vet_012(triggerDefinition, update, expectedResults, false);
        this.vet_012(triggerDefinition, update, expectedResults, true);
    }

    private void vet_012(String triggerDefinition, String update, String[][] expectedResults, boolean bounceDatabase) throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.populate_012(dboConnection);
        this.goodStatement(dboConnection, triggerDefinition);
        if (bounceDatabase) {
            dboConnection = this.bounceDatabase(TEST_DBO);
        }
        this.goodUpdate(dboConnection, update, 4);
        this.assertResults(dboConnection, "select * from t1_012 order by c1, c2", expectedResults, false);
        this.goodStatement(dboConnection, "drop trigger trig1_012");
    }

    private void populate_012(Connection conn) throws Exception {
        this.goodStatement(conn, "delete from t1_012");
        this.goodStatement(conn, "delete from t2_012");
        this.goodStatement(conn, "insert into t1_012( c1, c2, c1_4 ) values ( 1, 1, 100 ), ( 2, 2, 200 ), ( 3, 3, 300 ), ( 4, 4, 400 )\n");
        this.goodStatement(conn, "insert into t2_012( c1, c2, c3, c4, c5 ) values ( 1, -1, -10, -100, 'one' ), ( 2, 2, -2, -200, 'two' ), ( 3, -3, -30, -300, 'three' ), ( 4, 4, -40, -400, 'four' )\n");
    }

    public void test_013_insertAndDelete() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_013\n(\n    c1 int generated always as identity,\n    c2 int,\n    c3 int generated always as ( c1 + c2 ),\n    c1_4 int,\n    c5 int default 1000\n)\n");
        this.goodStatement(dboConnection, "create table t2_013( c1 int generated always as identity, c2 int, c3 int, c4 int, c5 varchar( 5 ) )\n");
        this.goodStatement(dboConnection, "insert into t1_013( c2, c1_4 ) values ( 1, 100 ), (2, 200 ), ( 3, 300 ), ( 4, 400 )\n");
        this.goodStatement(dboConnection, "insert into t2_013( c2, c3, c4, c5 ) values\n( -1, -101, -100, 'one' ), ( 2, -201, -200, 'two' ), ( -3, -301, -300, 'three' ), ( 4, -401, -400, 'four' )\n");
        this.goodUpdate(dboConnection, "merge into t1_013\nusing t2_013\non t1_013.c2 = t2_013.c2\nwhen not matched then insert ( c2, c1_4 ) values ( 10 * t2_013.c2, t2_013.c3 )\nwhen matched and c1_4 = 200 then delete\n", 3);
        this.assertResults(dboConnection, "select * from t1_013 order by c1", new String[][]{{"1", "1", "2", "100", "1000"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "400", "1000"}, {"5", "-10", "-5", "-101", "1000"}, {"6", "-30", "-24", "-301", "1000"}}, false);
        this.goodUpdate(dboConnection, "merge into t1_013\nusing t2_013\non t1_013.c2 = t2_013.c2\nwhen matched and c1_4 = 400 then delete\nwhen not matched then insert ( c2, c1_4 ) values ( 10 * t2_013.c2, t2_013.c3 )\n", 4);
        this.assertResults(dboConnection, "select * from t1_013 order by c1", new String[][]{{"1", "1", "2", "100", "1000"}, {"3", "3", "6", "300", "1000"}, {"5", "-10", "-5", "-101", "1000"}, {"6", "-30", "-24", "-301", "1000"}, {"7", "-10", "-3", "-101", "1000"}, {"8", "20", "28", "-201", "1000"}, {"9", "-30", "-21", "-301", "1000"}}, false);
        this.goodStatement(dboConnection, "drop table t2_013");
        this.goodStatement(dboConnection, "drop table t1_013");
    }

    public void test_014_basicUpdate() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_014\n(\n    c1 int generated always as identity,\n    c2 int,\n    c3 int generated always as ( c1 + c2 ),\n    c1_4 int,\n    c5 int default 1000\n)\n");
        this.goodStatement(dboConnection, "create table t2_014( c1 int generated always as identity, c2 int, c3 int, c4 int, c5 varchar( 5 ) )\n");
        this.goodStatement(dboConnection, "insert into t1_014( c2, c1_4 ) values ( 1, 100 ), (2, 200 ), ( 3, 300 ), ( 4, 400 )\n");
        this.goodStatement(dboConnection, "insert into t2_014( c2, c3, c4, c5 ) values\n( -1, -101, -100, 'one' ), ( 2, -201, -200, 'two' ), ( -3, -301, -300, 'three' ), ( 4, -401, -400, 'four' )\n");
        this.goodUpdate(dboConnection, "merge into t1_014\nusing t2_014\non t1_014.c2 = t2_014.c2\nwhen matched then update set c1_4 = (2 * c1_4) / 2\n", 2);
        this.goodUpdate(dboConnection, "merge into t1_014\nusing t2_014\non t1_014.c2 = t2_014.c2\nwhen matched and c1_4 = 200 then update set c5 = 10 * t2_014.c1\n", 1);
        this.assertResults(dboConnection, "select * from t1_014 order by c1", new String[][]{{"1", "1", "2", "100", "1000"}, {"2", "2", "4", "200", "20"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "400", "1000"}}, false);
        this.goodUpdate(dboConnection, "merge into t1_014\nusing t2_014\non t1_014.c1 = t2_014.c1\nwhen matched and t1_014.c2 != t2_014.c2 then update set c3 = default, c2 = t2_014.c2\n", 2);
        this.assertResults(dboConnection, "select * from t1_014 order by c1", new String[][]{{"1", "-1", "0", "100", "1000"}, {"2", "2", "4", "200", "20"}, {"3", "-3", "0", "300", "1000"}, {"4", "4", "8", "400", "1000"}}, false);
        this.goodUpdate(dboConnection, "merge into t1_014\nusing t2_014\non t1_014.c2 = t2_014.c2\nwhen matched then update set c3 = default, c2 = 10 * t2_014.c2, c5 = default\n", 4);
        this.assertResults(dboConnection, "select * from t1_014 order by c1", new String[][]{{"1", "-10", "-9", "100", "1000"}, {"2", "20", "22", "200", "1000"}, {"3", "-30", "-27", "300", "1000"}, {"4", "40", "44", "400", "1000"}}, false);
        this.goodStatement(dboConnection, "drop table t2_014");
        this.goodStatement(dboConnection, "drop table t1_014");
    }

    public void atest_015_bug_6414() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_bug_6414( a int generated always as identity, b int )");
        this.goodStatement(dboConnection, "create table t2_bug_6414( a int generated by default as identity, b int )");
        this.goodStatement(dboConnection, "create table t3_bug_6414( a int generated always as identity, b int )");
        this.goodStatement(dboConnection, "insert into t1_bug_6414( a, b ) values ( default, 100 )");
        this.goodStatement(dboConnection, "insert into t2_bug_6414( a, b ) values ( default, 100 )");
        this.goodStatement(dboConnection, "insert into t3_bug_6414( a, b ) values ( default, 100 )");
        this.goodStatement(dboConnection, "update t1_bug_6414 set a = default, b = -b");
        this.expectCompilationError(dboConnection, "42Z23", "merge into t1_bug_6414\nusing t3_bug_6414\non t1_bug_6414.a = t3_bug_6414.a\nwhen matched then update set a = default, b = -t3_bug_6414.b\n");
        this.expectExecutionError(dboConnection, "23502", "update t2_bug_6414 set a = default, b = -b\n");
        this.expectExecutionError(dboConnection, "23502", "merge into t2_bug_6414\nusing t3_bug_6414\non t2_bug_6414.a = t3_bug_6414.a\nwhen matched then update set a = default, b = -t3_bug_6414.b\n");
        this.goodStatement(dboConnection, "drop table t3_bug_6414");
        this.goodStatement(dboConnection, "drop table t2_bug_6414");
        this.goodStatement(dboConnection, "drop table t1_bug_6414");
    }

    public void test_016_updateWithStatementTriggers() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_016( c1 int, c2 int, c3 int )\n");
        this.goodStatement(dboConnection, "create table t2_016( c1 int generated always as identity, c2 int )\n");
        this.goodStatement(dboConnection, "create procedure sumColumn_016\n(\n    candidateName varchar( 20 ),\n    columnName varchar( 20 ),\n    actionString varchar( 20 )\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.sumColumn'\n");
        this.goodStatement(dboConnection, "create procedure truncateTriggerHistory_016()\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.truncateTriggerHistory'\n");
        this.goodStatement(dboConnection, "create function history_016()\nreturns table\n(\n    action varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.history'\n");
        this.goodStatement(dboConnection, "create trigger t1_016_upd_before\nno cascade before update on t1_016\nfor each statement\ncall sumColumn_016( 't1_016', 'c3', 'before' )\n");
        this.goodStatement(dboConnection, "create trigger t1_016_upd_after\nafter update on t1_016\nfor each statement\ncall sumColumn_016( 't1_016', 'c3', 'after' )\n");
        this.goodStatement(dboConnection, "call truncateTriggerHistory_016()\n");
        this.goodStatement(dboConnection, "insert into t1_016( c1, c2, c3 ) values ( 1, 10, 100 ), ( 2, 20, 200 ), ( 3, 30, 300 ), ( 4, 40, 400 ), ( 5, 50, 500 )\n");
        this.goodStatement(dboConnection, "insert into t2_016( c2 ) values ( 10 ), ( 20 ), ( 40 ), ( 50 ), ( 60 ), ( 70 )\n");
        this.goodUpdate(dboConnection, "merge into t1_016\nusing t2_016\non   t1_016.c2 =   t2_016.c2\nwhen matched then update set c3 = -100\n", 4);
        this.assertResults(dboConnection, "select * from t1_016 order by c1", new String[][]{{"1", "10", "-100"}, {"2", "20", "-100"}, {"3", "30", "300"}, {"4", "40", "-100"}, {"5", "50", "-100"}}, false);
        this.assertResults(dboConnection, "select * from table( history_016() ) s", new String[][]{{"before", "1500"}, {"after", "-100"}}, false);
        this.goodStatement(dboConnection, "update t1_016 set c3 = 100 * c1");
        this.goodStatement(dboConnection, "call truncateTriggerHistory_016()");
        this.goodUpdate(dboConnection, "merge into t1_016\nusing t2_016\non   t1_016.c2 =   t2_016.c2\nwhen matched and c3 = 200 then update set c3 = -200\n", 1);
        this.assertResults(dboConnection, "select * from t1_016 order by c1", new String[][]{{"1", "10", "100"}, {"2", "20", "-200"}, {"3", "30", "300"}, {"4", "40", "400"}, {"5", "50", "500"}}, false);
        this.assertResults(dboConnection, "select * from table( history_016() ) s", new String[][]{{"before", "1500"}, {"after", "1100"}}, false);
        this.goodStatement(dboConnection, "drop table t1_016");
        this.goodStatement(dboConnection, "drop table t2_016");
        this.goodStatement(dboConnection, "drop procedure truncateTriggerHistory_016");
        this.goodStatement(dboConnection, "drop procedure sumColumn_016");
        this.goodStatement(dboConnection, "drop function history_016");
        MergeStatementTest.truncateTriggerHistory();
    }

    public void test_017_updateWithRowTriggers() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_017( c1 int, c2 int, c3 int )\n");
        this.goodStatement(dboConnection, "create table t2_017( c1 int generated always as identity, c2 int )\n");
        this.goodStatement(dboConnection, "create procedure addHistoryRow_017\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(dboConnection, "create procedure truncateTriggerHistory_017()\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.truncateTriggerHistory'\n");
        this.goodStatement(dboConnection, "create function history_017()\nreturns table\n(\n    action varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.history'\n");
        this.goodStatement(dboConnection, "create trigger t1_017_upd_before\nno cascade before update on t1_017\nreferencing old as old\nfor each row\ncall addHistoryRow_017( 'before', old.c1 )\n");
        this.goodStatement(dboConnection, "create trigger t1_017_upd_after\nafter update on t1_017\nreferencing old as old\nfor each row\ncall addHistoryRow_017( 'after', old.c1 )\n");
        this.goodStatement(dboConnection, "insert into t1_017( c1, c2, c3 ) values ( 1, 10, 100 ), ( 2, 20, 200 ), ( 3, 30, 300 ), ( 4, 40, 400 ), ( 5, 50, 500 )\n");
        this.goodStatement(dboConnection, "insert into t2_017( c2 ) values ( 10 ), ( 20 ), ( 40 ), ( 50 ), ( 60 ), ( 70 )\n");
        this.goodStatement(dboConnection, "call truncateTriggerHistory_017()");
        this.goodUpdate(dboConnection, "merge into t1_017\nusing t2_017\non t1_017.c2 = t2_017.c2\nwhen matched then update set c3 = -100\n", 4);
        this.assertResults(dboConnection, "select * from t1_017 order by c1", new String[][]{{"1", "10", "-100"}, {"2", "20", "-100"}, {"3", "30", "300"}, {"4", "40", "-100"}, {"5", "50", "-100"}}, false);
        this.assertResults(dboConnection, "select * from table( history_017() ) s", new String[][]{{"before", "1"}, {"before", "2"}, {"before", "4"}, {"before", "5"}, {"after", "1"}, {"after", "2"}, {"after", "4"}, {"after", "5"}}, false);
        this.goodStatement(dboConnection, "update t1_017 set c3 = 100 * c1");
        this.goodStatement(dboConnection, "call truncateTriggerHistory_017()");
        this.goodUpdate(dboConnection, "merge into t1_017\nusing t2_017\non t1_017.c2 = t2_017.c2\nwhen matched and c3 = 200 then update set c3 = -200\n", 1);
        this.assertResults(dboConnection, "select * from t1_017 order by c1", new String[][]{{"1", "10", "100"}, {"2", "20", "-200"}, {"3", "30", "300"}, {"4", "40", "400"}, {"5", "50", "500"}}, false);
        this.assertResults(dboConnection, "select * from table( history_017() ) s", new String[][]{{"before", "2"}, {"after", "2"}}, false);
        this.goodStatement(dboConnection, "drop table t1_017");
        this.goodStatement(dboConnection, "drop table t2_017");
        this.goodStatement(dboConnection, "drop procedure truncateTriggerHistory_017");
        this.goodStatement(dboConnection, "drop procedure addHistoryRow_017");
        this.goodStatement(dboConnection, "drop function history_017");
        MergeStatementTest.truncateTriggerHistory();
    }

    public void test_018_updateFromTriggerTransitionTables() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_018( c1 int, c2 int, c3 int generated always as ( c1 + c2 ), c1_4 int )\n");
        this.goodStatement(dboConnection, "create table t2_018( c1 int, c2 int, c3 int, c4 int, c5 varchar( 5 ) )\n");
        this.vet_018("create trigger trig1_018 after update on t2_018\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into t1_018\nusing new_cor\non t1_018.c2 = new_cor.c2\nwhen matched then update set c1_4 = 2 * c1_4\n", new String[][]{{"1", "1", "2", "200"}, {"2", "2", "4", "200"}, {"3", "3", "6", "600"}, {"4", "4", "8", "400"}});
        this.vet_018("create trigger trig1_018 after update on t2_018\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into t1_018\nusing new_cor\non   t1_018.c2 =   new_cor.c2\nwhen matched and c1_4 = 300 then update set c1_4 = 2 * c1_4\n", new String[][]{{"1", "1", "2", "100"}, {"2", "2", "4", "200"}, {"3", "3", "6", "600"}, {"4", "4", "8", "400"}});
        this.vet_018("create trigger trig1_018 after update on t2_018\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into t1_018\nusing old_cor\non t1_018.c2 = old_cor.c2\nwhen matched then update set c1_4 = 2 * c1_4\n", new String[][]{{"1", "1", "2", "100"}, {"2", "2", "4", "400"}, {"3", "3", "6", "300"}, {"4", "4", "8", "800"}});
        this.vet_018("create trigger trig1_018 after update on t2_018\nreferencing old table as old_cor new table as new_cor\nfor each statement\nmerge into t1_018\nusing old_cor\non t1_018.c2 = old_cor.c2\nwhen matched and c1_4 = 200 then update set c1_4 = 2 * c1_4\n", new String[][]{{"1", "1", "2", "100"}, {"2", "2", "4", "400"}, {"3", "3", "6", "300"}, {"4", "4", "8", "400"}});
        dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "drop table t1_018");
        this.goodStatement(dboConnection, "drop table t2_018");
    }

    private void vet_018(String triggerDefinition, String[][] expectedResults) throws Exception {
        this.vet_018(triggerDefinition, expectedResults, false);
        this.vet_018(triggerDefinition, expectedResults, true);
    }

    private void vet_018(String triggerDefinition, String[][] expectedResults, boolean bounceDatabase) throws Exception {
        Connection conn = this.openUserConnection(TEST_DBO);
        this.populate_018(conn);
        this.goodStatement(conn, triggerDefinition);
        if (bounceDatabase) {
            conn = this.bounceDatabase(TEST_DBO);
        }
        this.goodUpdate(conn, "update t2_018 set c2 = -c2", 4);
        this.assertResults(conn, "select * from t1_018 order by c1", expectedResults, false);
        this.goodStatement(conn, "drop trigger trig1_018");
    }

    private void populate_018(Connection conn) throws Exception {
        this.goodStatement(conn, "delete from t2_018");
        this.goodStatement(conn, "delete from t1_018");
        this.goodStatement(conn, "insert into t1_018( c1, c2, c1_4 ) values ( 1, 1, 100 ), ( 2, 2, 200 ), ( 3, 3, 300 ), ( 4, 4, 400 )\n");
        this.goodStatement(conn, "insert into t2_018( c1, c2, c3, c4, c5 ) values ( 1, -1, -10, -100, 'one' ), ( 2, 2, -2, -200, 'two' ), ( 3, -3, -30, -300, 'three' ), ( 4, 4, -40,    -400, 'four' )\n");
    }

    public void test_019_insertUpdateDelete() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_019\n(\n    c1 int,\n    c2 int,\n    c3 int generated always as ( c1 + c2 ),\n    c1_4 int,\n    c5 int default 1000\n)\n");
        this.goodStatement(dboConnection, "create table t2_019( c1 int generated always as identity, c2 int, c3 int, c4 int, c5 varchar( 5 ) )\n");
        this.goodStatement(dboConnection, "insert into t2_019( c2, c3, c4, c5 ) values\n( -1, -101, -100, 'one' ), ( 2, -201, -200, 'two' ), ( -3, -301, -300, 'three' ), ( 4, -401, -400, 'four' )\n");
        this.vet_019(dboConnection, "merge into t1_019\nusing t2_019\non t1_019.c2 = t2_019.c2\nwhen not matched then insert ( c2, c1_4 ) values ( 10 * t2_019.c2, t2_019.c3 )\nwhen matched and c1_4 = 200 then delete\nwhen matched and c1_4 = 400 then update set c1_4 = t2_019.c4, c5 = 2 * t2_019.c1\n");
        this.vet_019(dboConnection, "merge into t1_019\nusing t2_019\non t1_019.c2 = t2_019.c2\nwhen matched and c1_4 = 200 then delete\nwhen matched and c1_4 = 400 then update set c1_4 = t2_019.c4, c5 = 2 * t2_019.c1\nwhen not matched then insert ( c2, c1_4 ) values ( 10 * t2_019.c2, t2_019.c3 )\n");
        this.vet_019(dboConnection, "merge into t1_019\nusing t2_019\non t1_019.c2 = t2_019.c2\nwhen matched and c1_4 = 400 then update set c1_4 = t2_019.c4, c5 = 2 * t2_019.c1\nwhen not matched then insert ( c2, c1_4 ) values ( 10 * t2_019.c2, t2_019.c3 )\nwhen matched and c1_4 = 200 then delete\n");
        this.goodStatement(dboConnection, "drop table t2_019");
        this.goodStatement(dboConnection, "drop table t1_019");
    }

    private void vet_019(Connection conn, String mergeStatement) throws Exception {
        this.populate_019(conn);
        this.goodUpdate(conn, mergeStatement, 4);
        this.assertResults(conn, "select * from t1_019 order by c2", new String[][]{{null, "-30", null, "-301", "1000"}, {null, "-10", null, "-101", "1000"}, {"1", "1", "2", "100", "1000"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "-400", "8"}, {"5", "5", "10", "500", "1000"}}, false);
    }

    private void populate_019(Connection conn) throws Exception {
        this.goodStatement(conn, "delete from t1_019");
        this.goodStatement(conn, "insert into t1_019( c1, c2, c1_4 ) values ( 1, 1, 100 ), ( 2, 2, 200 ), ( 3, 3, 300 ), ( 4, 4, 400 ), ( 5, 5, 500 )\n");
    }

    public void test_020_updateWithCheckConstraint() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_020\n(\n    c1 int generated always as identity,\n    c2 int,\n    c3 int generated always as ( c1 + c2 ),\n    c1_4 int,\n    c5 int default 1000,\n    check( c1_4 > 2 * c3 )\n)\n");
        this.goodStatement(dboConnection, "create table t2_020( c1 int generated always as identity, c2 int, c3 int, c4 int, c5 varchar( 5 ) )\n");
        this.goodStatement(dboConnection, "insert into t1_020( c2, c1_4 ) values ( 1, 100 ), (2, 200 ), ( 3, 300 ), ( 4, 400 )\n");
        this.goodStatement(dboConnection, "insert into t2_020( c2, c3, c4, c5 ) values\n( -1, -101, -100, 'one' ), ( 2, -201, -200, 'two' ), ( -3, -301, -300, 'three' ), ( 4, -401, -400, 'four' )\n");
        this.expectExecutionError(dboConnection, "23513", "merge into t1_020\nusing t2_020\non t1_020.c2 = t2_020.c2\nwhen matched then update set c1_4 = -c1_4\n");
        this.goodUpdate(dboConnection, "merge into t1_020\nusing t2_020\non t1_020.c2 = t2_020.c2\nwhen matched then update set c1_4 = 2 * c1_4\n", 2);
        this.assertResults(dboConnection, "select * from t1_020 order by c1", new String[][]{{"1", "1", "2", "100", "1000"}, {"2", "2", "4", "400", "1000"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "800", "1000"}}, false);
        this.goodStatement(dboConnection, "drop table t2_020");
        this.goodStatement(dboConnection, "drop table t1_020");
    }

    public void test_021_updateWithForeignAndCheckConstraint() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t3_021\n(\n    c2 int,\n    c4 int,\n    primary key( c2, c4 )\n)\n");
        this.goodStatement(dboConnection, "create table t1_021\n(\n    c1 int generated always as identity,\n    c2 int,\n    c3 int generated always as ( c1 + c2 ),\n    c1_4 int,\n    c5 int default 1000,\n    check( c1_4 > 2 * c3 ),\n    foreign key ( c2, c1_4 ) references t3_021( c2, c4 )\n)\n");
        this.goodStatement(dboConnection, "create table t2_021( c1 int generated always as identity, c2 int, c3 int, c4 int, c5 varchar( 5 ) )\n");
        this.goodStatement(dboConnection, "insert into t3_021( c2, c4 ) values ( 1, 100 ), (2, 200 ), ( 3, 300 ), ( 4, 400 ), ( 4, 500 )\n");
        this.goodStatement(dboConnection, "insert into t1_021( c2, c1_4 ) values ( 1, 100 ), (2, 200 ), ( 3, 300 ), ( 4, 400 )\n");
        this.goodStatement(dboConnection, "insert into t2_021( c2, c3, c4, c5 ) values\n( -1, -101, -100, 'one' ), ( 2, -201, -200, 'two' ), ( -3, -301, -300, 'three' ), ( 4, -401, -400, 'four' )\n");
        this.expectExecutionError(dboConnection, "23503", "merge into t1_021\nusing t2_021\non t1_021.c2 = t2_021.c2\nwhen matched and c1_4 = 400 then update set c1_4 = 600\n");
        this.goodUpdate(dboConnection, "merge into t1_021\nusing t2_021\non t1_021.c2 = t2_021.c2\nwhen matched and c1_4 = 400 then update set c1_4 = 500\n", 1);
        this.assertResults(dboConnection, "select * from t1_021 order by c1", new String[][]{{"1", "1", "2", "100", "1000"}, {"2", "2", "4", "200", "1000"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "500", "1000"}}, false);
        this.goodStatement(dboConnection, "drop table t2_021");
        this.goodStatement(dboConnection, "drop table t1_021");
        this.goodStatement(dboConnection, "drop table t3_021");
    }

    public void test_022_updateWithForeignPrimaryAndCheckConstraint() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t3_022\n(\n    c2 int,\n    c4 int,\n    primary key( c2, c4 )\n)\n");
        this.goodStatement(dboConnection, "create table t1_022\n(\n    c1 int generated always as identity,\n    c2 int,\n    c3 int generated always as ( c1 + c2 ),\n    c1_4 int primary key,\n    c5 int default 1000,\n    check( c1_4 > 2 * c3 ),\n    foreign key ( c2, c1_4 ) references t3_022( c2, c4 )\n)\n");
        this.goodStatement(dboConnection, "create table t2_022( c1 int generated always as identity, c2 int, c3 int, c4 int, c5 varchar( 5 ) )\n");
        this.goodStatement(dboConnection, "insert into t3_022( c2, c4 ) values ( 1, 100 ), (2, 200 ), ( 3, 300 ), ( 4, 400 ), ( 4, 300 ), ( 4, 500 ), ( 5, 500 )\n");
        this.goodStatement(dboConnection, "insert into t1_022( c2, c1_4 ) values ( 1, 100 ), (2, 200 ), ( 3, 300 ), ( 4, 400 )\n");
        this.goodStatement(dboConnection, "insert into t2_022( c2, c3, c4, c5 ) values\n( -1, -101, -100, 'one' ), ( 2, -201, -200, 'two' ), ( -3, -301, -300, 'three' ), ( 4, -401, -400, 'four' )\n");
        this.expectExecutionError(dboConnection, "23505", "merge into t1_022\nusing t2_022\non t1_022.c2 = t2_022.c2\nwhen matched and c1_4 = 400 then update set c1_4 = 300\n");
        this.goodUpdate(dboConnection, "merge into t1_022\nusing t2_022\non t1_022.c2 = t2_022.c2\nwhen matched and c1_4 = 400 then update set c1_4 = 500\n", 1);
        this.assertResults(dboConnection, "select * from t1_022 order by c1", new String[][]{{"1", "1", "2", "100", "1000"}, {"2", "2", "4", "200", "1000"}, {"3", "3", "6", "300", "1000"}, {"4", "4", "8", "500", "1000"}}, false);
        this.goodStatement(dboConnection, "drop table t2_022");
        this.goodStatement(dboConnection, "drop table t1_022");
        this.goodStatement(dboConnection, "drop table t3_022");
    }

    public void test_023_correlationNames() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_023\n(\n    a_public int primary key,\n    b_select_t1_ruth int,\n    c_select_t1_alice int,\n    d_select_t1_frank int,\n    e_update_t1_ruth int,\n    f_update_t1_alice int,\n    g_update_t1_frank int,\n    h_select_t1_ruth generated always as ( a_public )\n)\n");
        this.goodStatement(dboConnection, "create table t2_023\n(\n    a_public int primary key,\n    b_select_t2_ruth int,\n    c_select_t2_alice int,\n    d_select_t2_frank int,\n    e_select_t2_ruth generated always as ( a_public )\n)\n");
        this.goodStatement(dboConnection, "create table t3_023\n(\n    a int primary key,\n    b int,\n    c int,\n    d int,\n    e int,\n    f int,\n    g int,\n    h generated always as ( a )\n)\n");
        this.goodStatement(dboConnection, "create table t4_023\n(\n    a int primary key,\n    b int,\n    c int,\n    d int,\n    e generated always as ( a )\n)\n");
        this.goodStatement(dboConnection, "create function integerList_023()\nreturns table( a int, b int, c int, d int )\nlanguage java\nparameter style derby_jdbc_result_set\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.integerList_023'\n");
        this.populate_023(dboConnection);
        this.goodUpdate(dboConnection, "merge into test_dbo.t1_023 a using test_dbo.t2_023 b\non a.a_public = b.a_public\nwhen matched and a.b_select_t1_ruth = 11 then delete\n", 1);
        this.assertResults(dboConnection, "select * from t1_023 order by a_public", new String[][]{{"2", "12", "102", "1002", "10002", "100002", "1000002", "2"}, {"3", "13", "103", "1003", "10003", "100003", "1000003", "3"}}, false);
        this.populate_023(dboConnection);
        this.goodUpdate(dboConnection, "merge into test_dbo.t1_023 a using test_dbo.t2_023 b\non a.a_public = b.a_public\nwhen matched and a.b_select_t1_ruth = 12 then update set e_update_t1_ruth = a.g_update_t1_frank + b.c_select_t2_alice\n", 1);
        this.assertResults(dboConnection, "select * from t1_023 order by a_public", new String[][]{{"1", "11", "101", "1001", "10001", "100001", "1000001", "1"}, {"2", "12", "102", "1002", "1000104", "100002", "1000002", "2"}, {"3", "13", "103", "1003", "10003", "100003", "1000003", "3"}}, false);
        this.populate_023(dboConnection);
        this.goodUpdate(dboConnection, "merge into test_dbo.t1_023 a using test_dbo.t2_023 b\non a.a_public = b.a_public\nwhen not matched and b.b_select_t2_ruth = 14 then insert\n(\n    a_public,\n    b_select_t1_ruth,\n    c_select_t1_alice,\n    d_select_t1_frank,\n    e_update_t1_ruth,\n    f_update_t1_alice,\n    g_update_t1_frank\n)\nvalues ( b.a_public, 18, 108, 1008, 10008, 100008, 1000008 )\n", 1);
        this.assertResults(dboConnection, "select * from t1_023 order by a_public", new String[][]{{"1", "11", "101", "1001", "10001", "100001", "1000001", "1"}, {"2", "12", "102", "1002", "10002", "100002", "1000002", "2"}, {"3", "13", "103", "1003", "10003", "100003", "1000003", "3"}, {"4", "18", "108", "1008", "10008", "100008", "1000008", "4"}}, false);
        this.populate_023(dboConnection);
        this.goodUpdate(dboConnection, "merge into test_dbo.t1_023 a using test_dbo.t2_023 b\non a.a_public = b.a_public\nwhen matched and a.b_select_t1_ruth = 11 then delete\nwhen matched and a.b_select_t1_ruth = 12 then update set e_update_t1_ruth = a.g_update_t1_frank + b.c_select_t2_alice\nwhen not matched and b.b_select_t2_ruth = 14 then insert\n(\n    a_public,\n    b_select_t1_ruth,\n    c_select_t1_alice,\n    d_select_t1_frank,\n    e_update_t1_ruth,\n    f_update_t1_alice,\n    g_update_t1_frank\n)\nvalues ( b.a_public, 18, 108, 1008, 10008, 100008, 1000008 )\n", 3);
        this.assertResults(dboConnection, "select * from t1_023 order by a_public", new String[][]{{"2", "12", "102", "1002", "1000104", "100002", "1000002", "2"}, {"3", "13", "103", "1003", "10003", "100003", "1000003", "3"}, {"4", "18", "108", "1008", "10008", "100008", "1000008", "4"}}, false);
        this.populate_023(dboConnection);
        this.goodUpdate(dboConnection, "merge into test_dbo.t1_023 a using test_dbo.t2_023 b\non a.a_public = b.a_public\nwhen matched and b_select_t1_ruth = 11 then delete\nwhen matched and b_select_t1_ruth = 12 then update set e_update_t1_ruth = g_update_t1_frank + c_select_t2_alice\nwhen not matched and b_select_t2_ruth = 14 then insert\n(\n    a_public,\n    b_select_t1_ruth,\n    c_select_t1_alice,\n    d_select_t1_frank,\n    e_update_t1_ruth,\n    f_update_t1_alice,\n    g_update_t1_frank\n)\nvalues ( b.a_public, 18, 108, 1008, 10008, 100008, 1000008 )\n", 3);
        this.assertResults(dboConnection, "select * from t1_023 order by a_public", new String[][]{{"2", "12", "102", "1002", "1000104", "100002", "1000002", "2"}, {"3", "13", "103", "1003", "10003", "100003", "1000003", "3"}, {"4", "18", "108", "1008", "10008", "100008", "1000008", "4"}}, false);
        this.populate_023_2(dboConnection);
        this.goodUpdate(dboConnection, "merge into test_dbo.t3_023 a using test_dbo.t4_023 b\non a.a = b.a\nwhen matched and a.b = 11 then delete\nwhen matched and a.b = 12 then update set e = a.g + b.c\nwhen not matched and b.b = 14 then insert\n(\n    a,\n    b,\n    c,\n    d,\n    e,\n    f,\n    g\n)\nvalues ( b.a, 18, 108, 1008, 10008, 100008, 1000008 )\n", 3);
        this.assertResults(dboConnection, "select * from t3_023 order by a", new String[][]{{"2", "12", "102", "1002", "1000104", "100002", "1000002", "2"}, {"3", "13", "103", "1003", "10003", "100003", "1000003", "3"}, {"4", "18", "108", "1008", "10008", "100008", "1000008", "4"}}, false);
        this.populate_023(dboConnection);
        this.populate_023_2(dboConnection);
        this.goodUpdate(dboConnection, "merge into test_dbo.t1_023 using test_dbo.t4_023\non a_public = a\nwhen matched and b_select_t1_ruth = 11 then delete\nwhen matched and b_select_t1_ruth = 12 then update set e_update_t1_ruth = g_update_t1_frank + c\nwhen not matched and b = 14 then insert\n(\n    a_public,\n    b_select_t1_ruth,\n    c_select_t1_alice,\n    d_select_t1_frank,\n    e_update_t1_ruth,\n    f_update_t1_alice,\n    g_update_t1_frank\n)\nvalues ( a, 18, 108, 1008, 10008, 100008, 1000008 )\n", 3);
        this.assertResults(dboConnection, "select * from t1_023 order by a_public", new String[][]{{"2", "12", "102", "1002", "1000104", "100002", "1000002", "2"}, {"3", "13", "103", "1003", "10003", "100003", "1000003", "3"}, {"4", "18", "108", "1008", "10008", "100008", "1000008", "4"}}, false);
        this.populate_023(dboConnection);
        this.populate_023_2(dboConnection);
        this.goodUpdate(dboConnection, "merge into test_dbo.t1_023 using test_dbo.t4_023\non t1_023.a_public = t4_023.a\nwhen matched and t1_023.b_select_t1_ruth = 11 then delete\nwhen matched and t1_023.b_select_t1_ruth = 12 then update set e_update_t1_ruth = t1_023.g_update_t1_frank + t4_023.c\nwhen not matched and t4_023.b = 14 then insert\n(\n    a_public,\n    b_select_t1_ruth,\n    c_select_t1_alice,\n    d_select_t1_frank,\n    e_update_t1_ruth,\n    f_update_t1_alice,\n    g_update_t1_frank\n)\nvalues ( t4_023.a, 18, 108, 1008, 10008, 100008, 1000008 )\n", 3);
        this.assertResults(dboConnection, "select * from t1_023 order by a_public", new String[][]{{"2", "12", "102", "1002", "1000104", "100002", "1000002", "2"}, {"3", "13", "103", "1003", "10003", "100003", "1000003", "3"}, {"4", "18", "108", "1008", "10008", "100008", "1000008", "4"}}, false);
        this.populate_023(dboConnection);
        this.populate_023_2(dboConnection);
        this.goodUpdate(dboConnection, "merge into t1_023 using t4_023\non t1_023.a_public = t4_023.a\nwhen matched and t1_023.b_select_t1_ruth = 11 then delete\nwhen matched and t1_023.b_select_t1_ruth = 12 then update set e_update_t1_ruth = t1_023.g_update_t1_frank + t4_023.c\nwhen not matched and t4_023.b = 14 then insert\n(\n    a_public,\n    b_select_t1_ruth,\n    c_select_t1_alice,\n    d_select_t1_frank,\n    e_update_t1_ruth,\n    f_update_t1_alice,\n    g_update_t1_frank\n)\nvalues ( t4_023.a, 18, 108, 1008, 10008, 100008, 1000008 )\n", 3);
        this.assertResults(dboConnection, "select * from t1_023 order by a_public", new String[][]{{"2", "12", "102", "1002", "1000104", "100002", "1000002", "2"}, {"3", "13", "103", "1003", "10003", "100003", "1000003", "3"}, {"4", "18", "108", "1008", "10008", "100008", "1000008", "4"}}, false);
        this.populate_023(dboConnection);
        this.populate_023_2(dboConnection);
        this.goodUpdate(dboConnection, "merge into test_dbo.t3_023 a using test_dbo.t4_023 b\non a.a = b.a\nwhen matched and a.b = 11 then delete\nwhen matched and a.b = 12 then update set e = a.g + b.c\nwhen not matched and b.b = 14 then insert\n(\n    a,\n    b,\n    c,\n    d,\n    e,\n    f,\n    g\n)\nvalues ( b.a, 18, 108, 1008, 10008, 100008, 1000008 )\n", 3);
        this.assertResults(dboConnection, "select * from t3_023 order by a", new String[][]{{"2", "12", "102", "1002", "1000104", "100002", "1000002", "2"}, {"3", "13", "103", "1003", "10003", "100003", "1000003", "3"}, {"4", "18", "108", "1008", "10008", "100008", "1000008", "4"}}, false);
        this.populate_023(dboConnection);
        this.populate_023_2(dboConnection);
        this.goodUpdate(dboConnection, "merge into test_dbo.t1_023 using table( test_dbo.integerList_023() ) i\non a_public = a\nwhen matched and b = 11 then delete\nwhen matched and b = 12 then update set e_update_t1_ruth = g_update_t1_frank + c\nwhen not matched and b = 14 then insert\n(\n    a_public,\n    b_select_t1_ruth,\n    c_select_t1_alice,\n    d_select_t1_frank,\n    e_update_t1_ruth,\n    f_update_t1_alice,\n    g_update_t1_frank\n)\nvalues ( a, 18, 108, 1008, 10008, 100008, 1000008 )\n", 3);
        this.assertResults(dboConnection, "select * from t1_023 order by a_public", new String[][]{{"2", "12", "102", "1002", "1000104", "100002", "1000002", "2"}, {"3", "13", "103", "1003", "10003", "100003", "1000003", "3"}, {"4", "18", "108", "1008", "10008", "100008", "1000008", "4"}}, false);
        this.populate_023(dboConnection);
        this.populate_023_2(dboConnection);
        this.goodUpdate(dboConnection, "merge into test_dbo.t1_023 a using table( test_dbo.integerList_023() ) i\non a.a_public = i.a\nwhen matched and i.b = 11 then delete\nwhen matched and i.b = 12 then update set e_update_t1_ruth = a.g_update_t1_frank + i.c\nwhen not matched and i.b = 14 then insert\n(\n    a_public,\n    b_select_t1_ruth,\n    c_select_t1_alice,\n    d_select_t1_frank,\n    e_update_t1_ruth,\n    f_update_t1_alice,\n    g_update_t1_frank\n)\nvalues ( i.a, 18, 108, 1008, 10008, 100008, 1000008 )\n", 3);
        this.assertResults(dboConnection, "select * from t1_023 order by a_public", new String[][]{{"2", "12", "102", "1002", "1000104", "100002", "1000002", "2"}, {"3", "13", "103", "1003", "10003", "100003", "1000003", "3"}, {"4", "18", "108", "1008", "10008", "100008", "1000008", "4"}}, false);
        this.populate_023(dboConnection);
        this.populate_023_2(dboConnection);
        this.goodUpdate(dboConnection, "merge into t1_023 a using table( integerList_023() ) i\non a.a_public = i.a\nwhen matched and i.b = 11 then delete\nwhen matched and i.b = 12 then update set e_update_t1_ruth = a.g_update_t1_frank + i.c\nwhen not matched and i.b = 14 then insert\n(\n    a_public,\n    b_select_t1_ruth,\n    c_select_t1_alice,\n    d_select_t1_frank,\n    e_update_t1_ruth,\n    f_update_t1_alice,\n    g_update_t1_frank\n)\nvalues ( i.a, 18, 108, 1008, 10008, 100008, 1000008 )\n", 3);
        this.assertResults(dboConnection, "select * from t1_023 order by a_public", new String[][]{{"2", "12", "102", "1002", "1000104", "100002", "1000002", "2"}, {"3", "13", "103", "1003", "10003", "100003", "1000003", "3"}, {"4", "18", "108", "1008", "10008", "100008", "1000008", "4"}}, false);
        this.goodStatement(dboConnection, "drop function integerList_023");
        this.goodStatement(dboConnection, "drop table t4_023");
        this.goodStatement(dboConnection, "drop table t3_023");
        this.goodStatement(dboConnection, "drop table t2_023");
        this.goodStatement(dboConnection, "drop table t1_023");
    }

    private void populate_023(Connection conn) throws Exception {
        this.goodStatement(conn, "delete from t2_023");
        this.goodStatement(conn, "delete from t1_023");
        this.goodStatement(conn, "insert into t1_023\n(\n    a_public,\n    b_select_t1_ruth,\n    c_select_t1_alice,\n    d_select_t1_frank,\n    e_update_t1_ruth,\n    f_update_t1_alice,\n    g_update_t1_frank\n)\nvalues\n( 1, 11, 101, 1001, 10001, 100001, 1000001 ),\n( 2, 12, 102, 1002, 10002, 100002, 1000002 ),\n( 3, 13, 103, 1003, 10003, 100003, 1000003 )\n");
        this.goodStatement(conn, "insert into t2_023\n(\n    a_public,\n    b_select_t2_ruth,\n    c_select_t2_alice,\n    d_select_t2_frank\n)\nvalues\n( 1, 11, 101, 1001 ),\n( 2, 12, 102, 1002 ),\n( 3, 13, 103, 1003 ),\n( 4, 14, 104, 1004 )\n");
    }

    private void populate_023_2(Connection conn) throws Exception {
        this.goodStatement(conn, "delete from t4_023");
        this.goodStatement(conn, "delete from t3_023");
        this.goodStatement(conn, "insert into t3_023\n(\n    a,\n    b,\n    c,\n    d,\n    e,\n    f,\n    g\n)\nvalues\n( 1, 11, 101, 1001, 10001, 100001, 1000001 ),\n( 2, 12, 102, 1002, 10002, 100002, 1000002 ),\n( 3, 13, 103, 1003, 10003, 100003, 1000003 )\n");
        this.goodStatement(conn, "insert into t4_023\n(\n    a,\n    b,\n    c,\n    d\n)\nvalues\n( 1, 11, 101, 1001 ),\n( 2, 12, 102, 1002 ),\n( 3, 13, 103, 1003 ),\n( 4, 14, 104, 1004 )\n");
    }

    public void test_024_mergeNotAllowedInBeforeTriggers() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_024( c1 int, c2 int, c3 int generated always as ( c1 + c2 ), c1_4 int )");
        this.goodStatement(dboConnection, "create table t2_024( c1 int, c2 int, c3 int, c4 int, c5 varchar( 5 ) )");
        this.goodStatement(dboConnection, "create table t3_024( a int )");
        this.expectCompilationError(dboConnection, NO_DML_IN_BEFORE_TRIGGERS, "create trigger t3_024_del_insert_before\nno cascade before delete on t3_024\nfor each statement\ninsert into t1_024( c1, c2 ) values ( 1, 2 )\n");
        this.expectCompilationError(dboConnection, NO_DML_IN_BEFORE_TRIGGERS, "create trigger t3_024_del_update_before\nno cascade before delete on t3_024\nfor each statement\nupdate t1_024 set c1 = 1\n");
        this.expectCompilationError(dboConnection, NO_DML_IN_BEFORE_TRIGGERS, "create trigger t3_024_del_delete_before\nno cascade before delete on t3_024\nfor each statement\ndelete from t1_024\n");
        this.expectCompilationError(dboConnection, NO_DML_IN_BEFORE_TRIGGERS, "create trigger t3_024_del_merge_before\nno cascade before delete on t3_024\nfor each statement\nmerge into t1_024\nusing t2_024\non t1_024.c1 = t2_024.c1\nwhen matched then delete\n");
        this.expectCompilationError(dboConnection, NO_DML_IN_BEFORE_TRIGGERS, "create trigger t3_024_ins_insert_before\nno cascade before insert on t3_024\nfor each statement\ninsert into t1_024( c1, c2 ) values ( 1, 2 )\n");
        this.expectCompilationError(dboConnection, NO_DML_IN_BEFORE_TRIGGERS, "create trigger t3_024_ins_update_before\nno cascade before insert on t3_024\nfor each statement\nupdate t1_024 set c1 = 1\n");
        this.expectCompilationError(dboConnection, NO_DML_IN_BEFORE_TRIGGERS, "create trigger t3_024_ins_delete_before\nno cascade before insert on t3_024\nfor each statement\ndelete from t1_024\n");
        this.expectCompilationError(dboConnection, NO_DML_IN_BEFORE_TRIGGERS, "create trigger t3_024_ins_merge_before\nno cascade before insert on t3_024\nfor each statement\nmerge into t1_024\nusing t2_024\non t1_024.c1 = t2_024.c1\nwhen matched then delete\n");
        this.expectCompilationError(dboConnection, NO_DML_IN_BEFORE_TRIGGERS, "create trigger t3_024_upd_insert_before\nno cascade before update on t3_024\nfor each statement\ninsert into t1_024( c1, c2 ) values ( 1, 2 )\n");
        this.expectCompilationError(dboConnection, NO_DML_IN_BEFORE_TRIGGERS, "create trigger t3_024_upd_update_before\nno cascade before update on t3_024\nfor each statement\nupdate t1_024 set c1 = 1\n");
        this.expectCompilationError(dboConnection, NO_DML_IN_BEFORE_TRIGGERS, "create trigger t3_024_upd_delete_before\nno cascade before update on t3_024\nfor each statement\ndelete from t1_024\n");
        this.expectCompilationError(dboConnection, NO_DML_IN_BEFORE_TRIGGERS, "create trigger t3_024_upd_merge_before\nno cascade before update on t3_024\nfor each statement\nmerge into t1_024\nusing t2_024\non t1_024.c1 = t2_024.c1\nwhen matched then delete\n");
        this.goodStatement(dboConnection, "drop table t3_024");
        this.goodStatement(dboConnection, "drop table t2_024");
        this.goodStatement(dboConnection, "drop table t1_024");
    }

    public void test_025_noInsertList() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_025( a int, b int )");
        this.goodStatement(dboConnection, "create table t2_025( a int, b int )");
        this.goodStatement(dboConnection, "insert into t1_025 values ( 1, 100 ), ( 2, 200 )");
        this.goodStatement(dboConnection, "insert into t2_025 values ( 1, 100 ), ( 3, 300 )");
        this.goodStatement(dboConnection, "merge into t1_025\nusing t2_025 on t1_025.a = t2_025.a\nwhen not matched then insert values ( t2_025.a, t2_025.b )\n");
        this.assertResults(dboConnection, "select * from t1_025 order by a", new String[][]{{"1", "100"}, {"2", "200"}, {"3", "300"}}, false);
        this.expectCompilationError(dboConnection, COLUMN_COUNT_MISMATCH, "merge into t1_025\nusing t2_025 on t1_025.a = t2_025.a\nwhen not matched then insert values ( t2_025.a )\n");
        this.goodStatement(dboConnection, "drop table t2_025");
        this.goodStatement(dboConnection, "drop table t1_025");
    }

    public void test_026_otherTableTypes() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_026( a int )");
        this.goodStatement(dboConnection, "declare global temporary table session.t2_temp_026( a int )\non commit preserve rows not logged\n");
        this.goodStatement(dboConnection, "merge into t1_026 t\nusing sys.syscolumns c on t.a = c.columnNumber\nwhen not matched then insert ( a ) values ( c.columnNumber )\n");
        this.expectCompilationError(dboConnection, TARGET_MUST_BE_BASE, "merge into sys.syscolumns c\nusing t1_026 t on t.a = c.columnNumber\nwhen not matched then insert ( columnNumber ) values ( t.a )\n");
        this.goodStatement(dboConnection, "delete from t1_026");
        this.goodStatement(dboConnection, "insert into t1_026 values ( 1 )");
        this.goodStatement(dboConnection, "insert into session.t2_temp_026 values ( 1 ), ( 2 )");
        this.goodUpdate(dboConnection, "merge into t1_026\nusing session.t2_temp_026 s on s.a = t1_026.a\nwhen not matched then insert values ( s.a )\n", 1);
        this.assertResults(dboConnection, "select * from t1_026 order by a", new String[][]{{"1"}, {"2"}}, false);
        this.goodStatement(dboConnection, "delete from t1_026");
        this.goodStatement(dboConnection, "delete from session.t2_temp_026");
        this.goodStatement(dboConnection, "insert into t1_026 values ( 1 ), ( 2 )");
        this.goodStatement(dboConnection, "insert into session.t2_temp_026 values ( 1 )");
        this.goodUpdate(dboConnection, "merge into session.t2_temp_026 s\nusing t1_026 on t1_026.a = s.a\nwhen not matched then insert values ( t1_026.a )\n", 1);
        this.assertResults(dboConnection, "select * from session.t2_temp_026 order by a", new String[][]{{"1"}, {"2"}}, false);
        this.goodStatement(dboConnection, "drop table session.t2_temp_026");
        this.goodStatement(dboConnection, "drop table t1_026");
    }

    public void test_027_correlationNamesInSetClauses() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_027( a int, b int )");
        this.goodStatement(dboConnection, "create table t2_027( c int, d int )");
        this.goodStatement(dboConnection, "insert into t1_027 values ( 1, 100 ), ( 2, 200 )");
        this.goodStatement(dboConnection, "insert into t2_027 values ( 1, 1000 ), (2, 2000), ( 3, 3000 ), ( 4, 4000 )");
        this.goodUpdate(dboConnection, "merge into t1_027 x\nusing t2_027 y on x.a = y.c\nwhen matched and x.b > 100 then update set x.b = y.d\nwhen matched and x.b <= 100 then delete\nwhen not matched and y.d > 3000 then insert values ( y.c, y.d )\n", 3);
        this.assertResults(dboConnection, "select * from t1_027 order by a", new String[][]{{"2", "2000"}, {"4", "4000"}}, false);
        this.goodStatement(dboConnection, "drop table t2_027");
        this.goodStatement(dboConnection, "drop table t1_027");
    }

    public void test_028_basicRowTrigger() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create function singlerow_028() returns table\n( x int )\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.singlerow_028'\n");
        this.goodStatement(dboConnection, "create table t1_028( x int )");
        this.goodStatement(dboConnection, "create table t2_028( y int )");
        this.goodStatement(dboConnection, "create trigger tr after insert on t1_028\nreferencing new as new\nfor each row\nmerge into t2_028\nusing table( singlerow_028() ) sr on t2_028.y = new.x\nwhen not matched then insert ( y ) values ( new.x )\n");
        this.goodStatement(dboConnection, "insert into t1_028 values 1,2,3,4,5,4,3,2,1,1,1,2,3,100");
        this.assertResults(dboConnection, "select * from t2_028 order by y", new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"100"}}, false);
        this.goodStatement(dboConnection, "drop table t1_028");
        this.goodStatement(dboConnection, "drop table t2_028");
        this.goodStatement(dboConnection, "drop function singlerow_028");
    }

    public void test_029_scanViaIndex() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_029(x int primary key)");
        this.goodStatement(dboConnection, "create table t2_029(x int)");
        this.goodStatement(dboConnection, "insert into t2_029 values( 33 )");
        this.goodUpdate(dboConnection, "merge into t1_029\nusing t2_029 on t1_029.x = 42\nwhen not matched then insert (x) values (42)\n", 1);
        this.assertResults(dboConnection, "select  * from t1_029 order by x", new String[][]{{"42"}}, false);
        this.goodStatement(dboConnection, "drop table t1_029");
        this.goodStatement(dboConnection, "drop table t2_029");
    }

    public void test_030_SQLRef_serialization() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_030(x int, y varchar(100))");
        this.goodStatement(dboConnection, "create table t2_030(x int)");
        this.goodStatement(dboConnection, "insert into t2_030 values 1, 1, 2");
        this.goodStatement(dboConnection, "insert into t1_030 values (1, null), (2, '')");
        this.goodUpdate(dboConnection, "merge into t1_030\nusing t2_030 on t1_030.x = t2_030.x\nwhen matched and y is not null then update set y = y || 'x'\n", 1);
        this.assertResults(dboConnection, "select  * from t1_030 order by x, y", new String[][]{{"1", null}, {"2", "x"}}, false);
        this.goodStatement(dboConnection, "drop table t1_030");
        this.goodStatement(dboConnection, "drop table t2_030");
    }

    public void test_032_noSubqueriesInMatchedClauses() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_032( a int )");
        this.goodStatement(dboConnection, "create table t2_032( a int )");
        this.goodStatement(dboConnection, "create table t3_032( a int )");
        this.expectCompilationError(dboConnection, NO_SUBQUERIES_IN_MATCHED_CLAUSE, "merge into t1_032\nusing t2_032 on t1_032.a = t2_032.a\nwhen matched and t1_032.a > (select max( a ) from t3_032 ) then update set a = t2_032.a * 2\n");
        this.expectCompilationError(dboConnection, NO_SUBQUERIES_IN_MATCHED_CLAUSE, "merge into t1_032\nusing t2_032 on t1_032.a = t2_032.a\nwhen matched then update set a = (select max( a ) from t3_032 )\n");
        this.expectCompilationError(dboConnection, NO_SUBQUERIES_IN_MATCHED_CLAUSE, "merge into t1_032\nusing t2_032 on t1_032.a = t2_032.a\nwhen matched and t1_032.a > (select max( a ) from t3_032 ) then delete\n");
        this.expectCompilationError(dboConnection, NO_SUBQUERIES_IN_MATCHED_CLAUSE, "merge into t1_032\nusing t2_032 on t1_032.a = t2_032.a\nwhen not matched and t1_032.a > (select max( a ) from t3_032 ) then insert values ( 1 )\n");
        this.expectCompilationError(dboConnection, NO_SUBQUERIES_IN_MATCHED_CLAUSE, "merge into t1_032\nusing t2_032 on t1_032.a = t2_032.a\nwhen not matched then insert values ( (select max( a ) from t3_032 ) )\n");
        this.goodStatement(dboConnection, "drop table t3_032");
        this.goodStatement(dboConnection, "drop table t2_032");
        this.goodStatement(dboConnection, "drop table t1_032");
    }

    public void test_033_identicalNames() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        Connection aliceConnection = this.openUserConnection(ALICE);
        this.goodStatement(ruthConnection, "create table t1_033( x int, y int )");
        this.goodStatement(aliceConnection, "create table t1_033( x int, y int )");
        this.goodStatement(ruthConnection, "insert into t1_033 values ( 1, 100 ), ( 2, 200 ), ( 3, 300 )");
        this.goodStatement(aliceConnection, "insert into t1_033 values ( 1, 1000 ), ( 3, 3000 ), ( 4, 4000 )");
        this.goodUpdate(dboConnection, "merge into ruth.t1_033 r\nusing alice.t1_033 a on r.x = a.x\nwhen matched then update set x = a.x * 10\n", 2);
        this.assertResults(dboConnection, "select * from ruth.t1_033 order by x", new String[][]{{"2", "200"}, {"10", "100"}, {"30", "300"}}, false);
        this.goodStatement(ruthConnection, "drop table t1_033");
        this.goodStatement(aliceConnection, "drop table t1_033");
    }

    public void test_034_noSynonyms() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_034( x int, y int )");
        this.goodStatement(dboConnection, "create table t2_034( x int, y int )");
        this.goodStatement(dboConnection, "create synonym syn_t1_034 for t1_034");
        this.goodStatement(dboConnection, "create synonym syn_t2_034 for t2_034");
        this.expectCompilationError(dboConnection, NO_SYNONYMS_IN_MERGE, "merge into syn_t1_034\nusing t2_034 on syn_t1_034.x  = t2_034.x\nwhen matched then update set syn_t1_034.y = t2_034.y\n");
        this.expectCompilationError(dboConnection, NO_SYNONYMS_IN_MERGE, "merge into syn_t1_034 a\nusing t2_034 on a.x  = t2_034.x\nwhen matched then update set a.y = t2_034.y\n");
        this.expectCompilationError(dboConnection, NO_SYNONYMS_IN_MERGE, "merge into t1_034\nusing syn_t2_034 on t1_034.x = syn_t2_034.x\nwhen matched then update set t1_034.y = syn_t2_034.y\n");
        this.expectCompilationError(dboConnection, NO_SYNONYMS_IN_MERGE, "merge into t1_034\nusing syn_t2_034 a on t1_034.x = a.x\nwhen matched then update set t1_034.y = a.y\n");
        this.goodStatement(dboConnection, "drop synonym syn_t2_034");
        this.goodStatement(dboConnection, "drop synonym syn_t1_034");
        this.goodStatement(dboConnection, "drop table t2_034");
        this.goodStatement(dboConnection, "drop table t1_034");
    }

    public void test_035_leftSideOfSet() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_035( x int, y int )");
        this.goodStatement(dboConnection, "create table t2_035( x int, y int )");
        this.vet_035(dboConnection, "merge into t1_035\nusing t2_035 on t1_035.x = t2_035.x\nwhen matched then update set t1_035.y = t2_035.y\n");
        this.vet_035(dboConnection, "merge into t1_035\nusing t2_035 on t1_035.x = t2_035.x\nwhen matched then update set y = t2_035.y\n");
        this.vet_035(dboConnection, "merge into t1_035 a\nusing t2_035 on a.x = t2_035.x\nwhen matched then update set a.y = t2_035.y\n");
        this.vet_035(dboConnection, "merge into t1_035 a\nusing t2_035 on a.x = t2_035.x\nwhen matched then update set y = t2_035.y\n");
        this.goodStatement(dboConnection, "drop table t2_035");
        this.goodStatement(dboConnection, "drop table t1_035");
    }

    private void vet_035(Connection conn, String query) throws Exception {
        this.goodStatement(conn, "delete from t1_035");
        this.goodStatement(conn, "delete from t2_035");
        this.goodStatement(conn, "insert into t1_035 values ( 1, 100 ), ( 2, 200 ), ( 3, 300 )");
        this.goodStatement(conn, "insert into t2_035 values ( 1, 1000 ), ( 3, 3000 ), ( 4, 4000 )");
        String[][] expectedResults = new String[][]{{"1", "1000"}, {"2", "200"}, {"3", "3000"}};
        this.goodUpdate(conn, query, 2);
        this.assertResults(conn, "select * from t1_035 order by x", expectedResults, false);
    }

    public void test_036_derivedColumnLists() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_036( a int )");
        this.goodStatement(dboConnection, "create table t2_036( a int )");
        this.expectCompilationError(dboConnection, NO_DCL_IN_MERGE, "merge into t1_036 r( x )\nusing t2_036 on r.x = t2_036.a\nwhen matched then delete\n");
        this.expectCompilationError(dboConnection, NO_DCL_IN_MERGE, "merge into t1_036\nusing t2_036 r( x ) on t1_036.a = r.x\nwhen matched then delete\n");
        this.goodStatement(dboConnection, "drop table t2_036");
        this.goodStatement(dboConnection, "drop table t1_036");
    }

    public void test_037_parameters() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_037( x int )");
        this.goodStatement(dboConnection, "create table t2_037( x int )");
        this.goodStatement(dboConnection, "insert into t2_037 values ( 100 ), ( 200 )");
        PreparedStatement ps = this.chattyPrepare(dboConnection, "merge into t1_037 using t2_037 on ? when not matched then insert values ( t2_037.x )");
        try {
            ps.execute();
            MergeStatementTest.fail((String)"Expected statement to raise an error because a parameter isn't set.");
        }
        catch (SQLException se) {
            MergeStatementTest.assertEquals((String)PARAMETER_NOT_SET, (String)se.getSQLState());
        }
        ps.setBoolean(1, true);
        ps.execute();
        this.assertResults(dboConnection, "select * from t1_037 order by x", new String[][]{{"100"}, {"200"}}, false);
        this.goodStatement(dboConnection, "drop table t2_037");
        this.goodStatement(dboConnection, "drop table t1_037");
    }

    public void test_038_parameters() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_038( x int, y int, z int )");
        this.goodStatement(dboConnection, "create table t2_038( x int, y int, z int )");
        this.goodStatement(dboConnection, "insert into t1_038 values \n( 1, -1, 100 ), ( 2, -2, 200 ), ( 3, -3, 300 ), ( 5, -5, 500 ),\n( 100, -10, 100 ), ( 200, -20, 200 ), ( 300, -30, 300 ), ( 500, -50, 500 )\n");
        this.goodStatement(dboConnection, "insert into t2_038 values\n( 10, -100, 1000 ), ( 30, -300, 3000), ( 40, -400, 4000 ), ( 40, -401, 4001 ), ( 50, -500, 5000 ), ( 50, -501, 5001 ),\n( -1000, -10, 1000 ), ( -3000, -30, 3000), ( -4000, -40, 4000 ), ( -4000, -41, 4001 ),\n( -5000, -50, 5000 ), ( -5000, -51, 5001 )\n");
        PreparedStatement ps = this.chattyPrepare(dboConnection, "merge into t1_038\nusing t2_038 on t2_038.x = t1_038.x * ?\nwhen not matched and t2_038.y = ? then insert values (  t2_038.x, t2_038.y, t2_038.z * ? )\nwhen matched and t2_038.y = ? then delete\nwhen matched and t2_038.y = ? then update set z = t2_038.z * ?");
        ps.setInt(1, 10);
        ps.setInt(2, -401);
        ps.setInt(3, 2);
        ps.setInt(4, -300);
        ps.setInt(5, -501);
        ps.setInt(6, 3);
        ps.execute();
        this.assertResults(dboConnection, "select * from t1_038 order by x, y, z", new String[][]{{"1", "-1", "100"}, {"2", "-2", "200"}, {"5", "-5", "15003"}, {"40", "-401", "8002"}, {"100", "-10", "100"}, {"200", "-20", "200"}, {"300", "-30", "300"}, {"500", "-50", "500"}}, false);
        ps.setInt(1, -10);
        ps.setInt(2, -41);
        ps.setInt(3, 3);
        ps.setInt(4, -30);
        ps.setInt(5, -51);
        ps.setInt(6, 4);
        ps.execute();
        this.assertResults(dboConnection, "select * from t1_038 order by x, y, z", new String[][]{{"-4000", "-41", "12003"}, {"1", "-1", "100"}, {"2", "-2", "200"}, {"5", "-5", "15003"}, {"40", "-401", "8002"}, {"100", "-10", "100"}, {"200", "-20", "200"}, {"500", "-50", "20004"}}, false);
        this.goodStatement(dboConnection, "drop table t2_038");
        this.goodStatement(dboConnection, "drop table t1_038");
    }

    public void test_039_indexProbe() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create function sr_039() returns table\n( i int )\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.singlerow_028'\n");
        this.goodStatement(dboConnection, "create table t1_039( x int, y int, z int )");
        this.goodStatement(dboConnection, "create unique index idx on t1_039( x, y )");
        this.goodStatement(dboConnection, "insert into t1_039 values ( 1, 100, 1000 ), ( 2, 200, 2000 )");
        this.goodUpdate(dboConnection, "merge into t1_039\nusing table( sr_039() ) sr on ( x = 1 )\nwhen matched then delete\n", 1);
        this.assertResults(dboConnection, "select * from t1_039 order by x", new String[][]{{"2", "200", "2000"}}, false);
        this.goodStatement(dboConnection, "drop function sr_039");
        this.goodStatement(dboConnection, "drop table t1_039");
    }

    public void test_040_valuesView() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create function sr_040() returns table\n( i int )\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.singlerow_028'\n");
        this.goodStatement(dboConnection, "create table t1_040( x int, y int, z int )");
        this.goodStatement(dboConnection, "create unique index idx on t1_040( x, y )");
        this.goodStatement(dboConnection, "insert into t1_040 values\n( 1, 100, 1000 ), ( 1, 101, 1000 ), ( 1, 102, 1000 ), ( 1, 103, 1000 ), ( 2, 200, 2000 )\n");
        this.goodUpdate(dboConnection, "merge into t1_040\nusing table( sr_040() ) sr on ( x = 1 )\nwhen matched and y = 101 then delete\nwhen matched and y = 102 then update set z = -1000\nwhen not matched and i > 1 then insert values ( -1, i, 0 )\n", 2);
        this.assertResults(dboConnection, "select * from t1_040 order by x, y, z", new String[][]{{"1", "100", "1000"}, {"1", "102", "-1000"}, {"1", "103", "1000"}, {"2", "200", "2000"}}, false);
        this.goodUpdate(dboConnection, "merge into t1_040\nusing table( sr_040() ) sr on ( x = 3 )\nwhen matched and y = 103 then delete\nwhen matched and y = 102 then update set z = -10000\nwhen not matched and i = 1 then insert values ( -1, i, 0 )\n", 1);
        this.assertResults(dboConnection, "select * from t1_040 order by x, y, z", new String[][]{{"-1", "1", "0"}, {"1", "100", "1000"}, {"1", "102", "-1000"}, {"1", "103", "1000"}, {"2", "200", "2000"}}, false);
        this.goodStatement(dboConnection, "drop function sr_040");
        this.goodStatement(dboConnection, "drop table t1_040");
    }

    public void test_041_cardinalityViolations() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create function sr_041() returns table\n( i int )\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.tworow_041'\n");
        this.goodStatement(dboConnection, "create table t1_041( x int, y int, z int )");
        this.goodStatement(dboConnection, "create unique index idx on t1_041( x, y )");
        this.goodStatement(dboConnection, "create table t2_041( x int, y int, z int )");
        this.goodStatement(dboConnection, "create table t3_041( x int, y int, z int )");
        this.goodStatement(dboConnection, "create unique index t2_idx_041 on t2_041( x, y )");
        this.goodStatement(dboConnection, "create unique index t3_idx_041 on t3_041( x, y )");
        this.goodStatement(dboConnection, "insert into t1_041 values\n( 1, 100, 1000 ), ( 1, 101, 1000 ), ( 1, 102, 1000 ), ( 1, 103, 1000 ), ( 2, 200, 2000 )\n");
        this.goodStatement(dboConnection, "insert into t2_041 values\n( 1, 100, 1000 ), ( 1, 101, 1000 ), ( 2, 200, 2000 )\n");
        this.goodStatement(dboConnection, "insert into t3_041 values\n( 1, 100, 1000 ), ( 1, -101, 1000 ), ( 3, 300, 3000 )\n");
        this.expectExecutionError(dboConnection, CARDINALITY_VIOLATION, "merge into t1_041\nusing table( sr_041() ) sr on ( x = 1 )\nwhen matched and y = 101 then delete\nwhen matched and y = 102 then update set z = -1000\nwhen not matched and i > 1 then insert values ( -1, i, 0 )\n");
        this.expectExecutionError(dboConnection, CARDINALITY_VIOLATION, "merge into t2_041\nusing t3_041 on t2_041.x = t3_041.x\nwhen matched and t2_041.y = 101 then delete\n");
        this.expectExecutionError(dboConnection, CARDINALITY_VIOLATION, "merge into t2_041\nusing t3_041 on t2_041.x = t3_041.x\nwhen matched and t2_041.y = 101 then update set z = t3_041.z\n");
        this.expectExecutionError(dboConnection, CARDINALITY_VIOLATION, "merge into t2_041\nusing t3_041 on t2_041.x = t3_041.x\nwhen matched and t2_041.y = t3_041.y then delete\nwhen matched and t2_041.y = 100 and -101 = t3_041.y then update set z = 2 * t3_041.z\n");
        this.expectExecutionError(dboConnection, CARDINALITY_VIOLATION, "merge into t2_041\nusing t3_041 on t2_041.x = t3_041.x\nwhen matched and t2_041.y = 100 and -101 = t3_041.y then update set z = 2 * t3_041.z\nwhen matched and t2_041.y = t3_041.y then delete\n");
        this.goodStatement(dboConnection, "drop function sr_041");
        this.goodStatement(dboConnection, "drop table t1_041");
        this.goodStatement(dboConnection, "drop table t2_041");
        this.goodStatement(dboConnection, "drop table t3_041");
    }

    public void test_042_missingSchema() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.goodStatement(dboConnection, "create table deleteTable_042\n(\n    publicSelectColumn int\n)\n");
        this.goodStatement(dboConnection, "create table selectTable_042\n(\n    selectColumn int\n)\n");
        this.goodStatement(dboConnection, "grant select on  selectTable_042 to public");
        this.goodStatement(dboConnection, "grant select on  deleteTable_042 to public");
        this.goodStatement(dboConnection, "grant delete on deleteTable_042 to ruth");
        String mergeStatement = "merge into test_dbo.deleteTable_042\nusing test_dbo.selectTable_042\non publicSelectColumn = selectColumn\nwhen matched then delete\n";
        this.expectExecutionWarning(ruthConnection, NO_ROWS_AFFECTED, mergeStatement);
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, mergeStatement);
        this.goodStatement(dboConnection, "drop table deleteTable_042");
        this.goodStatement(dboConnection, "drop table selectTable_042");
    }

    public void test_043_correlationNamesAddedColumns() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create type BeforeTriggerType_043 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type AfterTriggerType_043 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create function beforeTriggerFunction_043( hashMap BeforeTriggerType_043, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create function afterTriggerFunction_043( hashMap AfterTriggerType_043, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create procedure addHistoryRow_043\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(dboConnection, "create table primaryTable_043\n(\n    key1 int primary key\n)\n");
        this.goodStatement(dboConnection, "create table sourceTable_043\n(\n    sourceChange int,\n    sourceOnClauseColumn int,\n    sourceMatchingClauseColumn int\n)\n");
        this.goodStatement(dboConnection, "create table targetTable_043\n(\n    privateForeignColumn int references primaryTable_043( key1 ),\n    privatePrimaryColumn int primary key,\n    privateBeforeTriggerSource BeforeTriggerType_043,\n    privateAfterTriggerSource AfterTriggerType_043,\n    targetOnClauseColumn int,\n    targetMatchingClauseColumn int\n)\n");
        this.goodStatement(dboConnection, "create table foreignTable_043\n(\n    key1 int references targetTable_043( privatePrimaryColumn )\n)\n");
        this.goodStatement(dboConnection, "create trigger beforeDeleteTrigger_043\nno cascade before delete on targetTable_043\nreferencing old as old\nfor each row\ncall addHistoryRow_043( 'before', beforeTriggerFunction_043( old.privateBeforeTriggerSource, 'foo' ) )\n");
        this.goodStatement(dboConnection, "create trigger afterDeleteTrigger_043\nafter delete on targetTable_043\nreferencing old as old\nfor each row\ncall addHistoryRow_043( 'after', afterTriggerFunction_043( old.privateAfterTriggerSource, 'foo' ) )\n");
        this.goodStatement(dboConnection, "create trigger beforeUpdateTrigger_043\nno cascade before update on targetTable_043\nreferencing old as old\nfor each row\ncall addHistoryRow_043( 'before', beforeTriggerFunction_043( old.privateBeforeTriggerSource, 'foo' ) )\n");
        this.goodStatement(dboConnection, "create trigger afterUpdateTrigger_043\nafter update on targetTable_043\nreferencing old as old\nfor each row\ncall addHistoryRow_043( 'after', afterTriggerFunction_043( old.privateAfterTriggerSource, 'foo' ) )\n");
        this.goodStatement(dboConnection, "create trigger beforeInsertTrigger_043\nno cascade before insert on targetTable_043\nreferencing new as new\nfor each row\ncall addHistoryRow_043( 'before', beforeTriggerFunction_043( new.privateBeforeTriggerSource, 'foo' ) )\n");
        this.goodStatement(dboConnection, "create trigger afterInsertTrigger_043\nafter insert on targetTable_043\nreferencing new as new\nfor each row\ncall addHistoryRow_043( 'after', afterTriggerFunction_043( new.privateAfterTriggerSource, 'foo' ) )\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043\nusing sourceTable_043\non targetOnClauseColumn = sourceOnClauseColumn\nwhen matched and targetMatchingClauseColumn = sourceMatchingClauseColumn\n     then delete\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043 t\nusing sourceTable_043 s\non targetOnClauseColumn = sourceOnClauseColumn\nwhen matched and targetMatchingClauseColumn = sourceMatchingClauseColumn\n     then delete\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043 t\nusing sourceTable_043 s\non targetOnClauseColumn = s.sourceOnClauseColumn\nwhen matched and targetMatchingClauseColumn = s.sourceMatchingClauseColumn\n     then delete\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043 t\nusing sourceTable_043 s\non t.targetOnClauseColumn = s.sourceOnClauseColumn\nwhen matched and t.targetMatchingClauseColumn = s.sourceMatchingClauseColumn\n     then delete\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043\nusing sourceTable_043\non targetOnClauseColumn = sourceOnClauseColumn\nwhen matched and targetMatchingClauseColumn = sourceMatchingClauseColumn\n     then update set privateForeignColumn = sourceChange\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043 t\nusing sourceTable_043 s\non targetOnClauseColumn = sourceOnClauseColumn\nwhen matched and targetMatchingClauseColumn = sourceMatchingClauseColumn\n     then update set privateForeignColumn = sourceChange\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043 t\nusing sourceTable_043 s\non targetOnClauseColumn = s.sourceOnClauseColumn\nwhen matched and targetMatchingClauseColumn = s.sourceMatchingClauseColumn\n     then update set privateForeignColumn = s.sourceChange\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043 t\nusing sourceTable_043 s\non t.targetOnClauseColumn = s.sourceOnClauseColumn\nwhen matched and t.targetMatchingClauseColumn = s.sourceMatchingClauseColumn\n     then update set t.privateForeignColumn = s.sourceChange\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043\nusing sourceTable_043\non targetOnClauseColumn = sourceOnClauseColumn\nwhen not matched and 1 = sourceMatchingClauseColumn\n     then insert ( privateForeignColumn ) values ( sourceChange )\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043 t\nusing sourceTable_043 s\non targetOnClauseColumn = sourceOnClauseColumn\nwhen not matched and 1 = sourceMatchingClauseColumn\n     then insert ( privateForeignColumn ) values ( sourceChange )\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043 t\nusing sourceTable_043 s\non targetOnClauseColumn = s.sourceOnClauseColumn\nwhen not matched and 1 = s.sourceMatchingClauseColumn\n     then insert ( privateForeignColumn ) values ( s.sourceChange )\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043\nusing sourceTable_043\non targetOnClauseColumn = sourceOnClauseColumn\nwhen matched and targetMatchingClauseColumn = sourceMatchingClauseColumn\n     then delete\nwhen matched and targetMatchingClauseColumn = sourceMatchingClauseColumn\n     then update set privateForeignColumn = sourceChange\nwhen not matched and 1 = sourceMatchingClauseColumn\n     then insert ( privateForeignColumn ) values ( sourceChange )\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043 t\nusing sourceTable_043 s\non targetOnClauseColumn = sourceOnClauseColumn\nwhen matched and targetMatchingClauseColumn = sourceMatchingClauseColumn\n     then delete\nwhen matched and targetMatchingClauseColumn = sourceMatchingClauseColumn\n     then update set privateForeignColumn = sourceChange\nwhen not matched and 1 = sourceMatchingClauseColumn\n     then insert ( privateForeignColumn ) values ( sourceChange )\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043 t\nusing sourceTable_043 s\non targetOnClauseColumn = s.sourceOnClauseColumn\nwhen matched and targetMatchingClauseColumn = s.sourceMatchingClauseColumn\n     then delete\nwhen matched and targetMatchingClauseColumn = s.sourceMatchingClauseColumn\n     then update set privateForeignColumn = s.sourceChange\nwhen not matched and 1 = s.sourceMatchingClauseColumn\n     then insert ( privateForeignColumn ) values ( s.sourceChange )\n");
        this.expectExecutionWarning(dboConnection, NO_ROWS_AFFECTED, "merge into targetTable_043 t\nusing sourceTable_043 s\non t.targetOnClauseColumn = s.sourceOnClauseColumn\nwhen matched and t.targetMatchingClauseColumn = s.sourceMatchingClauseColumn\n     then delete\nwhen matched and t.targetMatchingClauseColumn = s.sourceMatchingClauseColumn\n     then update set t.privateForeignColumn = s.sourceChange\nwhen not matched and 1 = s.sourceMatchingClauseColumn\n     then insert ( privateForeignColumn ) values ( s.sourceChange )\n");
        this.goodStatement(dboConnection, "drop table foreignTable_043");
        this.goodStatement(dboConnection, "drop table targetTable_043");
        this.goodStatement(dboConnection, "drop table sourceTable_043");
        this.goodStatement(dboConnection, "drop table primaryTable_043");
        this.goodStatement(dboConnection, "drop procedure addHistoryRow_043");
        this.goodStatement(dboConnection, "drop function afterTriggerFunction_043");
        this.goodStatement(dboConnection, "drop function beforeTriggerFunction_043");
        this.goodStatement(dboConnection, "drop type AfterTriggerType_043 restrict");
        this.goodStatement(dboConnection, "drop type BeforeTriggerType_043 restrict");
    }

    public void test_044_deletePrivileges() throws Exception {
        Permission[] permissions;
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.goodStatement(dboConnection, "create type SourceOnClauseType_044 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type SourceMatchingClauseType_044 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type BeforeTriggerType_044 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type AfterTriggerType_044 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create function sourceOnClauseFunction_044( hashMap SourceOnClauseType_044, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create function sourceMatchingClauseFunction_044( hashMap SourceMatchingClauseType_044, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create function beforeTriggerFunction_044( hashMap BeforeTriggerType_044, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create function afterTriggerFunction_044( hashMap AfterTriggerType_044, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create procedure addHistoryRow_044\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(dboConnection, "create table primaryTable_044\n(\n    key1 int primary key\n)\n");
        this.goodStatement(dboConnection, "create table sourceTable_044\n(\n    sourceUnreferencedColumn int,\n    sourceOnClauseColumn SourceOnClauseType_044,\n    sourceMatchingClauseColumn SourceMatchingClauseType_044\n)\n");
        this.goodStatement(dboConnection, "create table targetTable_044\n(\n    privateForeignColumn int references primaryTable_044( key1 ),\n    privatePrimaryColumn int primary key,\n    privateBeforeTriggerSource BeforeTriggerType_044,\n    privateAfterTriggerSource AfterTriggerType_044,\n    targetOnClauseColumn int,\n    targetMatchingClauseColumn int\n)\n");
        this.goodStatement(dboConnection, "create table foreignTable_044\n(\n    key1 int references targetTable_044( privatePrimaryColumn )\n)\n");
        this.goodStatement(dboConnection, "create trigger beforeDeleteTrigger_044\nno cascade before delete on targetTable_044\nreferencing old as old\nfor each row\ncall addHistoryRow_044( 'before', beforeTriggerFunction_044( old.privateBeforeTriggerSource, 'foo' ) )\n");
        this.goodStatement(dboConnection, "create trigger afterDeleteTrigger_044\nafter delete on targetTable_044\nreferencing old as old\nfor each row\ncall addHistoryRow_044( 'after', afterTriggerFunction_044( old.privateAfterTriggerSource, 'foo' ) )\n");
        for (Permission permission : permissions = new Permission[]{new Permission("delete on targetTable_044", "42500"), new Permission("execute on function sourceOnClauseFunction_044", "42504"), new Permission("execute on function sourceMatchingClauseFunction_044", "42504"), new Permission("select ( sourceOnClauseColumn ) on sourceTable_044", "42502"), new Permission("select ( sourceMatchingClauseColumn ) on sourceTable_044", "42502"), new Permission("select ( targetOnClauseColumn ) on targetTable_044", "42502"), new Permission("select ( targetMatchingClauseColumn ) on targetTable_044", "42502")}) {
            this.grantPermission(dboConnection, permission.text);
        }
        String mergeStatement = "merge into test_dbo.targetTable_044\nusing test_dbo.sourceTable_044\non targetOnClauseColumn = test_dbo.sourceOnClauseFunction_044( sourceOnClauseColumn, 'foo' )\nwhen matched and targetMatchingClauseColumn = test_dbo.sourceMatchingClauseFunction_044( sourceMatchingClauseColumn, 'foo' )\n      then delete\n";
        this.expectExecutionWarning(ruthConnection, NO_ROWS_AFFECTED, mergeStatement);
        for (Permission permission : permissions) {
            this.vetPermission(permission, dboConnection, ruthConnection, mergeStatement);
        }
        this.goodStatement(dboConnection, "drop table foreignTable_044");
        this.goodStatement(dboConnection, "drop table targetTable_044");
        this.goodStatement(dboConnection, "drop table sourceTable_044");
        this.goodStatement(dboConnection, "drop table primaryTable_044");
        this.goodStatement(dboConnection, "drop procedure addHistoryRow_044");
        this.goodStatement(dboConnection, "drop function afterTriggerFunction_044");
        this.goodStatement(dboConnection, "drop function beforeTriggerFunction_044");
        this.goodStatement(dboConnection, "drop function sourceMatchingClauseFunction_044");
        this.goodStatement(dboConnection, "drop function sourceOnClauseFunction_044");
        this.goodStatement(dboConnection, "drop type AfterTriggerType_044 restrict");
        this.goodStatement(dboConnection, "drop type BeforeTriggerType_044 restrict");
        this.goodStatement(dboConnection, "drop type SourceMatchingClauseType_044 restrict");
        this.goodStatement(dboConnection, "drop type SourceOnClauseType_044 restrict");
    }

    private void vetPermission(Permission permission, Connection dboConnection, Connection ruthConnection, String mergeStatement) throws Exception {
        this.revokePermission(dboConnection, permission.text);
        this.expectExecutionError(ruthConnection, permission.sqlStateWhenMissing, mergeStatement);
        this.grantPermission(dboConnection, permission.text);
        this.expectExecutionWarning(ruthConnection, NO_ROWS_AFFECTED, mergeStatement);
    }

    private void grantPermission(Connection conn, String permission) throws Exception {
        String command = "grant " + permission + " to ruth";
        this.goodStatement(conn, command);
    }

    private void revokePermission(Connection conn, String permission) throws Exception {
        String command = "revoke " + permission + " from ruth";
        if (permission.startsWith("execute") || permission.startsWith("usage")) {
            command = command + " restrict";
        }
        this.goodStatement(conn, command);
    }

    public void test_045_insertPrivileges() throws Exception {
        Permission[] permissions;
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.goodStatement(dboConnection, "create type SourceOnClauseType_045 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type SourceMatchingClauseType_045 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type SourceValueType_045 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type TargetValueType_045 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type BeforeTriggerType_045 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type AfterTriggerType_045 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create function sourceOnClauseFunction_045( hashMap SourceOnClauseType_045, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create function sourceMatchingClauseFunction_045( hashMap SourceMatchingClauseType_045, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create function sourceValueFunction_045( hashMap SourceValueType_045, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create function targetValueFunction_045( hashKey varchar( 32672 ), hashValue int ) returns TargetValueType_045\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.makeHashMap'\n");
        this.goodStatement(dboConnection, "create function beforeTriggerFunction_045( hashMap BeforeTriggerType_045, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create function afterTriggerFunction_045( hashMap AfterTriggerType_045, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create procedure addHistoryRow_045\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(dboConnection, "create table primaryTable_045\n(\n    key1 int primary key\n)\n");
        this.goodStatement(dboConnection, "create table sourceTable_045\n(\n    sourceUnreferencedColumn int,\n    sourceOnClauseColumn SourceOnClauseType_045,\n    sourceMatchingClauseColumn SourceMatchingClauseType_045,\n    sourceValueColumn SourceValueType_045\n)\n");
        this.goodStatement(dboConnection, "create table targetTable_045\n(\n    privateForeignColumn int references primaryTable_045( key1 ),\n    privatePrimaryColumn int primary key,\n    privateBeforeTriggerSource BeforeTriggerType_045,\n    privateAfterTriggerSource AfterTriggerType_045,\n    targetOnClauseColumn int,\n    targetMatchingClauseColumn int,\n    targetValueColumn TargetValueType_045\n)\n");
        this.goodStatement(dboConnection, "create table foreignTable_045\n(\n    key1 int references targetTable_045( privatePrimaryColumn )\n)\n");
        this.goodStatement(dboConnection, "create trigger beforeInsertTrigger_045\nno cascade before insert on targetTable_045\nreferencing new as new\nfor each row\ncall addHistoryRow_045( 'before', beforeTriggerFunction_045( new.privateBeforeTriggerSource, 'foo' ) )\n");
        this.goodStatement(dboConnection, "create trigger afterInsertTrigger_045\nafter insert on targetTable_045\nreferencing new as new\nfor each row\ncall addHistoryRow_045( 'after', afterTriggerFunction_045( new.privateAfterTriggerSource, 'foo' ) )\n");
        for (Permission permission : permissions = new Permission[]{new Permission("insert on targetTable_045", "42500"), new Permission("execute on function sourceOnClauseFunction_045", "42504"), new Permission("execute on function sourceMatchingClauseFunction_045", "42504"), new Permission("execute on function sourceValueFunction_045", "42504"), new Permission("execute on function targetValueFunction_045", "42504"), new Permission("select ( sourceOnClauseColumn ) on sourceTable_045", "42502"), new Permission("select ( sourceMatchingClauseColumn ) on sourceTable_045", "42502"), new Permission("select ( sourceValueColumn ) on sourceTable_045", "42502"), new Permission("select ( targetOnClauseColumn ) on targetTable_045", "42502")}) {
            this.grantPermission(dboConnection, permission.text);
        }
        String mergeStatement = "merge into test_dbo.targetTable_045\nusing test_dbo.sourceTable_045\non targetOnClauseColumn = test_dbo.sourceOnClauseFunction_045( sourceOnClauseColumn, 'foo' )\nwhen not matched and 1 = test_dbo.sourceMatchingClauseFunction_045( sourceMatchingClauseColumn, 'foo' )\n     then insert ( targetValueColumn ) values\n     (\n        test_dbo.targetValueFunction_045( 'foo', test_dbo.sourceValueFunction_045( sourceValueColumn, 'foo' ) )\n     )\n";
        this.expectExecutionWarning(ruthConnection, NO_ROWS_AFFECTED, mergeStatement);
        for (Permission permission : permissions) {
            this.vetPermission(permission, dboConnection, ruthConnection, mergeStatement);
        }
        this.goodStatement(dboConnection, "drop table foreignTable_045");
        this.goodStatement(dboConnection, "drop table targetTable_045");
        this.goodStatement(dboConnection, "drop table sourceTable_045");
        this.goodStatement(dboConnection, "drop procedure addHistoryRow_045");
        this.goodStatement(dboConnection, "drop function afterTriggerFunction_045");
        this.goodStatement(dboConnection, "drop function beforeTriggerFunction_045");
        this.goodStatement(dboConnection, "drop function targetValueFunction_045");
        this.goodStatement(dboConnection, "drop function sourceValueFunction_045");
        this.goodStatement(dboConnection, "drop function sourceMatchingClauseFunction_045");
        this.goodStatement(dboConnection, "drop function sourceOnClauseFunction_045");
        this.goodStatement(dboConnection, "drop type AfterTriggerType_045 restrict");
        this.goodStatement(dboConnection, "drop type BeforeTriggerType_045 restrict");
        this.goodStatement(dboConnection, "drop type TargetValueType_045 restrict");
        this.goodStatement(dboConnection, "drop type SourceValueType_045 restrict");
        this.goodStatement(dboConnection, "drop type SourceMatchingClauseType_045 restrict");
        this.goodStatement(dboConnection, "drop type SourceOnClauseType_045 restrict");
    }

    public void test_046_udtCasts() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.goodStatement(dboConnection, "create type OnClauseType_046 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type MatchingClauseType_046 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type TargetValueType_046 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create table sourceTable_046\n(\n    sourceUnreferencedColumn int\n)\n");
        this.goodStatement(dboConnection, "create table targetTable_046\n(\n    privateUnreferencedColumn int,\n    publicUnreferencedColumn int,\n    targetValueColumn TargetValueType_046\n)\n");
        this.goodStatement(dboConnection, "grant select ( publicUnreferencedColumn ) on targetTable_046 to ruth");
        this.goodStatement(dboConnection, "grant insert on targetTable_046 to ruth");
        this.goodStatement(dboConnection, "grant delete on targetTable_046 to ruth");
        this.goodStatement(dboConnection, "grant select on sourceTable_046 to ruth");
        String insertStatement = "merge into test_dbo.targetTable_046\nusing test_dbo.sourceTable_046\non cast( null as test_dbo.OnClauseType_046 ) is null\nwhen not matched and cast( null as test_dbo.MatchingClauseType_046 ) is null\n     then insert ( targetValueColumn ) values ( cast( null as test_dbo.TargetValueType_046 ) )\n";
        String deleteStatement = "merge into test_dbo.targetTable_046\nusing test_dbo.sourceTable_046\non cast( null as test_dbo.OnClauseType_046 ) is null\nwhen matched and cast( null as test_dbo.MatchingClauseType_046 ) is null\n     then delete\n";
        this.expectExecutionError(ruthConnection, "42504", insertStatement);
        this.expectExecutionError(ruthConnection, "42504", deleteStatement);
        this.goodStatement(dboConnection, "grant usage on type MatchingClauseType_046 to ruth");
        this.expectExecutionError(ruthConnection, "42504", insertStatement);
        this.expectExecutionError(ruthConnection, "42504", deleteStatement);
        this.goodStatement(dboConnection, "grant usage on type OnClauseType_046 to ruth");
        this.expectExecutionError(ruthConnection, "42504", insertStatement);
        this.goodStatement(dboConnection, "grant usage on type TargetValueType_046 to ruth");
        this.expectExecutionWarning(ruthConnection, NO_ROWS_AFFECTED, insertStatement);
        this.expectExecutionWarning(ruthConnection, NO_ROWS_AFFECTED, deleteStatement);
        this.goodStatement(dboConnection, "drop table sourceTable_046");
        this.goodStatement(dboConnection, "drop table targetTable_046");
        this.goodStatement(dboConnection, "drop type TargetValueType_046 restrict");
        this.goodStatement(dboConnection, "drop type MatchingClauseType_046 restrict");
        this.goodStatement(dboConnection, "drop type OnClauseType_046 restrict");
    }

    public void test_047_updatePrivileges() throws Exception {
        Permission[] permissions;
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.goodStatement(dboConnection, "create type SourceOnClauseType_047 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type SourceMatchingClauseType_047 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type SourceValueType_047 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type TargetValueType_047 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type TargetValueInputType_047 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type BeforeTriggerType_047 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type AfterTriggerType_047 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create function sourceOnClauseFunction_047( hashMap SourceOnClauseType_047, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create function sourceMatchingClauseFunction_047( hashMap SourceMatchingClauseType_047, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create function sourceValueFunction_047( hashMap SourceValueType_047, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create function targetValueInputFunction_047( hashMap TargetValueInputType_047, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create function targetValueFunction_047( hashKey varchar( 32672 ), hashValue int ) returns TargetValueType_047\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.makeHashMap'\n");
        this.goodStatement(dboConnection, "create function beforeTriggerFunction_047( hashMap BeforeTriggerType_047, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create function afterTriggerFunction_047( hashMap AfterTriggerType_047, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'\n");
        this.goodStatement(dboConnection, "create procedure addHistoryRow_047\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(dboConnection, "create table primaryTable_047\n(\n    key1 int primary key\n)\n");
        this.goodStatement(dboConnection, "create table sourceTable_047\n(\n    sourceUnreferencedColumn int,\n    sourceOnClauseColumn SourceOnClauseType_047,\n    sourceMatchingClauseColumn SourceMatchingClauseType_047,\n    sourceValueColumn SourceValueType_047\n)\n");
        this.goodStatement(dboConnection, "create table targetTable_047\n(\n    privateForeignColumn int references primaryTable_047( key1 ),\n    privatePrimaryColumn int primary key,\n    privateBeforeTriggerSource BeforeTriggerType_047,\n    privateAfterTriggerSource AfterTriggerType_047,\n    targetOnClauseColumn int,\n    targetMatchingClauseColumn int,\n    targetValueInputColumn TargetValueInputType_047,\n    targetValueColumn TargetValueType_047\n)\n");
        this.goodStatement(dboConnection, "create table foreignTable_047\n(\n    key1 int references targetTable_047( privatePrimaryColumn )\n)\n");
        this.goodStatement(dboConnection, "create trigger beforeUpdateTrigger_047\nno cascade before update on targetTable_047\nreferencing new as new\nfor each row\ncall addHistoryRow_047( 'before', beforeTriggerFunction_047( new.privateBeforeTriggerSource, 'foo' ) )\n");
        this.goodStatement(dboConnection, "create trigger afterUpdateTrigger_047\nafter update on targetTable_047\nreferencing new as new\nfor each row\ncall addHistoryRow_047( 'after', afterTriggerFunction_047( new.privateAfterTriggerSource, 'foo' ) )\n");
        for (Permission permission : permissions = new Permission[]{new Permission("update ( targetValueColumn ) on targetTable_047", "42502"), new Permission("execute on function sourceOnClauseFunction_047", "42504"), new Permission("execute on function sourceMatchingClauseFunction_047", "42504"), new Permission("execute on function sourceValueFunction_047", "42504"), new Permission("execute on function targetValueInputFunction_047", "42504"), new Permission("execute on function targetValueFunction_047", "42504"), new Permission("select ( sourceOnClauseColumn ) on sourceTable_047", "42502"), new Permission("select ( sourceMatchingClauseColumn ) on sourceTable_047", "42502"), new Permission("select ( sourceValueColumn ) on sourceTable_047", "42502"), new Permission("select ( targetOnClauseColumn ) on targetTable_047", "42502"), new Permission("select ( targetMatchingClauseColumn ) on targetTable_047", "42502"), new Permission("select ( targetValueInputColumn ) on targetTable_047", "42502")}) {
            this.grantPermission(dboConnection, permission.text);
        }
        String mergeStatement = "merge into test_dbo.targetTable_047\nusing test_dbo.sourceTable_047\non targetOnClauseColumn = test_dbo.sourceOnClauseFunction_047( sourceOnClauseColumn, 'foo' )\nwhen matched\n  and targetMatchingClauseColumn = test_dbo.sourceMatchingClauseFunction_047( sourceMatchingClauseColumn, 'foo' )\n     then update set targetValueColumn =\n     test_dbo.targetValueFunction_047\n     (\n        'foo',\n        test_dbo.sourceValueFunction_047( sourceValueColumn, 'foo' ) +\n        test_dbo.targetValueInputFunction_047( targetValueInputColumn, 'foo' )\n     )\n";
        this.expectExecutionWarning(ruthConnection, NO_ROWS_AFFECTED, mergeStatement);
        for (Permission permission : permissions) {
            this.vetPermission(permission, dboConnection, ruthConnection, mergeStatement);
        }
        this.goodStatement(dboConnection, "drop table foreignTable_047");
        this.goodStatement(dboConnection, "drop table targetTable_047");
        this.goodStatement(dboConnection, "drop table sourceTable_047");
        this.goodStatement(dboConnection, "drop table primaryTable_047");
        this.goodStatement(dboConnection, "drop procedure addHistoryRow_047");
        this.goodStatement(dboConnection, "drop function afterTriggerFunction_047");
        this.goodStatement(dboConnection, "drop function beforeTriggerFunction_047");
        this.goodStatement(dboConnection, "drop function targetValueFunction_047");
        this.goodStatement(dboConnection, "drop function targetValueInputFunction_047");
        this.goodStatement(dboConnection, "drop function sourceValueFunction_047");
        this.goodStatement(dboConnection, "drop function sourceMatchingClauseFunction_047");
        this.goodStatement(dboConnection, "drop function sourceOnClauseFunction_047");
        this.goodStatement(dboConnection, "drop type AfterTriggerType_047 restrict");
        this.goodStatement(dboConnection, "drop type BeforeTriggerType_047 restrict");
        this.goodStatement(dboConnection, "drop type TargetValueInputType_047 restrict");
        this.goodStatement(dboConnection, "drop type TargetValueType_047 restrict");
        this.goodStatement(dboConnection, "drop type SourceValueType_047 restrict");
        this.goodStatement(dboConnection, "drop type SourceMatchingClauseType_047 restrict");
        this.goodStatement(dboConnection, "drop type SourceOnClauseType_047 restrict");
    }

    public void test_048_updateUdtCasts() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.goodStatement(dboConnection, "create type SourceOnClauseType_048 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type SourceMatchingClauseType_048 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type TargetValueType_048 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create table sourceTable_048\n(\n    sourceUnreferencedColumn int\n)\n");
        this.goodStatement(dboConnection, "create table targetTable_048\n(\n    targetValueColumn TargetValueType_048\n)\n");
        this.goodStatement(dboConnection, "grant update ( targetValueColumn ) on targetTable_048 to ruth");
        this.goodStatement(dboConnection, "grant select on sourceTable_048 to ruth");
        String updateStatement = "merge into test_dbo.targetTable_048\nusing test_dbo.sourceTable_048\non cast( null as test_dbo.SourceOnClauseType_048 ) is not null\nwhen matched and cast( null as test_dbo.SourceMatchingClauseType_048 ) is not null\n     then update set targetValueColumn = cast( null as test_dbo.TargetValueType_048 )\n";
        this.expectExecutionError(ruthConnection, "42504", updateStatement);
        this.goodStatement(dboConnection, "grant usage on type SourceMatchingClauseType_048 to ruth");
        this.expectExecutionError(ruthConnection, "42504", updateStatement);
        this.goodStatement(dboConnection, "grant usage on type TargetValueType_048 to ruth");
        this.expectExecutionError(ruthConnection, "42504", updateStatement);
        this.goodStatement(dboConnection, "grant usage on type SourceOnClauseType_048 to ruth");
        this.goodStatement(ruthConnection, updateStatement);
        this.goodStatement(dboConnection, "drop table targetTable_048");
        this.goodStatement(dboConnection, "drop table sourceTable_048");
        this.goodStatement(dboConnection, "drop type TargetValueType_048 restrict");
        this.goodStatement(dboConnection, "drop type SourceMatchingClauseType_048 restrict");
        this.goodStatement(dboConnection, "drop type SourceOnClauseType_048 restrict");
    }

    public void test_049_allPrivileges() throws Exception {
        Permission[] permissions;
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.goodStatement(dboConnection, "create type SourceOnClauseType_049 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type SourceMatchingClauseType_049 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type SourceValueType_049 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type TargetValueType_049 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type TargetValueInputType_049 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type BeforeTriggerType_049 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create type AfterTriggerType_049 external name 'java.util.HashMap' language java");
        this.goodStatement(dboConnection, "create function sourceOnClauseFunction_049( hashMap SourceOnClauseType_049, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'");
        this.goodStatement(dboConnection, "create function sourceMatchingClauseFunction_049( hashMap SourceMatchingClauseType_049, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'");
        this.goodStatement(dboConnection, "create function sourceValueFunction_049( hashMap SourceValueType_049, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'");
        this.goodStatement(dboConnection, "create function targetValueInputFunction_049( hashMap TargetValueInputType_049, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'");
        this.goodStatement(dboConnection, "create function targetValueFunction_049( hashKey varchar( 32672 ), hashValue int ) returns TargetValueType_049\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.makeHashMap'");
        this.goodStatement(dboConnection, "create function beforeTriggerFunction_049( hashMap BeforeTriggerType_049, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'");
        this.goodStatement(dboConnection, "create function afterTriggerFunction_049( hashMap AfterTriggerType_049, hashKey varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.getIntValue'");
        this.goodStatement(dboConnection, "create procedure addHistoryRow_049\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(dboConnection, "create table primaryTable_049\n(\n    key1 int primary key\n)\n");
        this.goodStatement(dboConnection, "create table sourceTable_049\n(\n    sourceUnreferencedColumn int,\n    sourceOnClauseColumn SourceOnClauseType_049,\n    sourceMatchingClauseColumn SourceMatchingClauseType_049,\n    sourceValueColumn SourceValueType_049\n)\n");
        this.goodStatement(dboConnection, "create table targetTable_049\n(\n    privateForeignColumn int references primaryTable_049( key1 ),\n    privatePrimaryColumn int primary key,\n    privateBeforeTriggerSource BeforeTriggerType_049,\n    privateAfterTriggerSource AfterTriggerType_049,\n    targetOnClauseColumn int,\n    targetMatchingClauseColumn int,\n    targetValueInputColumn TargetValueInputType_049,\n    targetValueColumn TargetValueType_049\n)\n");
        this.goodStatement(dboConnection, "create table foreignTable_049\n(\n    key1 int references targetTable_049( privatePrimaryColumn )\n)\n");
        this.goodStatement(dboConnection, "create trigger beforeDeleteTrigger_049\nno cascade before delete on targetTable_049\nreferencing old as old\nfor each row\ncall addHistoryRow_049( 'before', beforeTriggerFunction_049( old.privateBeforeTriggerSource, 'foo' ) )\n");
        this.goodStatement(dboConnection, "create trigger afterDeleteTrigger_049\nafter delete on targetTable_049\nreferencing old as old\nfor each row\ncall addHistoryRow_049( 'after', afterTriggerFunction_049( old.privateAfterTriggerSource, 'foo' ) )\n");
        this.goodStatement(dboConnection, "create trigger beforeInsertTrigger_049\nno cascade before insert on targetTable_049\nreferencing new as new\nfor each row\ncall addHistoryRow_049( 'before', beforeTriggerFunction_049( new.privateBeforeTriggerSource, 'foo' ) )\n");
        this.goodStatement(dboConnection, "create trigger afterInsertTrigger_049\nafter insert on targetTable_049\nreferencing new as new\nfor each row\ncall addHistoryRow_049( 'after', afterTriggerFunction_049( new.privateAfterTriggerSource, 'foo' ) )\n");
        this.goodStatement(dboConnection, "create trigger beforeUpdateTrigger_049\nno cascade before update on targetTable_049\nreferencing new as new\nfor each row\ncall addHistoryRow_049( 'before', beforeTriggerFunction_049( new.privateBeforeTriggerSource, 'foo' ) )\n");
        this.goodStatement(dboConnection, "create trigger afterUpdateTrigger_049\nafter update on targetTable_049\nreferencing new as new\nfor each row\ncall addHistoryRow_049( 'after', afterTriggerFunction_049( new.privateAfterTriggerSource, 'foo' ) )\n");
        for (Permission permission : permissions = new Permission[]{new Permission("delete on targetTable_049", "42500"), new Permission("insert on targetTable_049", "42500"), new Permission("update ( targetValueColumn ) on targetTable_049", "42502"), new Permission("execute on function sourceOnClauseFunction_049", "42504"), new Permission("execute on function sourceMatchingClauseFunction_049", "42504"), new Permission("execute on function sourceValueFunction_049", "42504"), new Permission("execute on function targetValueInputFunction_049", "42504"), new Permission("execute on function targetValueFunction_049", "42504"), new Permission("select ( sourceOnClauseColumn ) on sourceTable_049", "42502"), new Permission("select ( sourceMatchingClauseColumn ) on sourceTable_049", "42502"), new Permission("select ( sourceValueColumn ) on sourceTable_049", "42502"), new Permission("select ( targetOnClauseColumn ) on targetTable_049", "42502"), new Permission("select ( targetMatchingClauseColumn ) on targetTable_049", "42502"), new Permission("select ( targetValueInputColumn ) on targetTable_049", "42502")}) {
            this.grantPermission(dboConnection, permission.text);
        }
        String mergeStatement = "merge into test_dbo.targetTable_049\nusing test_dbo.sourceTable_049\non targetOnClauseColumn = test_dbo.sourceOnClauseFunction_049( sourceOnClauseColumn, 'foo' )\nwhen matched\n  and targetMatchingClauseColumn = test_dbo.sourceMatchingClauseFunction_049( sourceMatchingClauseColumn, 'foo' )\n     then update set targetValueColumn =\n     test_dbo.targetValueFunction_049\n     (\n        'foo',\n        test_dbo.sourceValueFunction_049( sourceValueColumn, 'foo' ) +\n        test_dbo.targetValueInputFunction_049( targetValueInputColumn, 'foo' )\n     )\nwhen matched\n  and targetMatchingClauseColumn = 2 * test_dbo.sourceMatchingClauseFunction_049( sourceMatchingClauseColumn, 'foo' )\n     then delete\nwhen not matched\n  and 0 = test_dbo.sourceMatchingClauseFunction_049( sourceMatchingClauseColumn, 'foo' )\n     then insert( targetValueColumn ) values\n     (\n        test_dbo.targetValueFunction_049\n        ( 'foo', test_dbo.sourceValueFunction_049( sourceValueColumn, 'foo' ) )\n     )\n";
        this.expectExecutionWarning(ruthConnection, NO_ROWS_AFFECTED, mergeStatement);
        for (Permission permission : permissions) {
            this.vetPermission(permission, dboConnection, ruthConnection, mergeStatement);
        }
        this.goodStatement(dboConnection, "drop table foreignTable_049");
        this.goodStatement(dboConnection, "drop table targetTable_049");
        this.goodStatement(dboConnection, "drop table sourceTable_049");
        this.goodStatement(dboConnection, "drop table primaryTable_049");
        this.goodStatement(dboConnection, "drop procedure addHistoryRow_049");
        this.goodStatement(dboConnection, "drop function afterTriggerFunction_049");
        this.goodStatement(dboConnection, "drop function beforeTriggerFunction_049");
        this.goodStatement(dboConnection, "drop function targetValueFunction_049");
        this.goodStatement(dboConnection, "drop function targetValueInputFunction_049");
        this.goodStatement(dboConnection, "drop function sourceValueFunction_049");
        this.goodStatement(dboConnection, "drop function sourceMatchingClauseFunction_049");
        this.goodStatement(dboConnection, "drop function sourceOnClauseFunction_049");
        this.goodStatement(dboConnection, "drop type AfterTriggerType_049 restrict");
        this.goodStatement(dboConnection, "drop type BeforeTriggerType_049 restrict");
        this.goodStatement(dboConnection, "drop type TargetValueInputType_049 restrict");
        this.goodStatement(dboConnection, "drop type TargetValueType_049 restrict");
        this.goodStatement(dboConnection, "drop type SourceValueType_049 restrict");
        this.goodStatement(dboConnection, "drop type SourceMatchingClauseType_049 restrict");
        this.goodStatement(dboConnection, "drop type SourceOnClauseType_049 restrict");
    }

    public void test_050_allDatatypes() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create function lv_equals_050( leftV long varchar, rightV long varchar ) returns boolean\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.equals'\n");
        this.goodStatement(dboConnection, "create function clob_equals_050( leftV clob, rightV clob ) returns boolean\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.equals'\n");
        this.goodStatement(dboConnection, "create function vb( inputVal int... ) returns varchar( 10 ) for bit data\nlanguage java parameter style derby deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.makeByteArray'\n");
        this.goodStatement(dboConnection, "create function vb_reverse( inputVal varchar( 10 ) for bit data ) returns varchar( 10 ) for bit data\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.reverse'\n");
        this.goodStatement(dboConnection, "create function vb_add( leftV varchar( 10 ) for bit data, rightV varchar( 10 ) for bit data ) returns varchar( 10 ) for bit data\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.add'\n");
        this.goodStatement(dboConnection, "create function ch( inputVal int... ) returns char( 10 ) for bit data\nlanguage java parameter style derby deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.makeByteArray'\n");
        this.goodStatement(dboConnection, "create function ch_reverse( inputVal char( 10 ) for bit data ) returns char( 10 ) for bit data\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.reverse'\n");
        this.goodStatement(dboConnection, "create function ch_add( leftV char( 10 ) for bit data, rightV char( 10 ) for bit data ) returns char( 10 ) for bit data\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.add'\n");
        this.goodStatement(dboConnection, "create function vbl( inputVal int... ) returns blob\nlanguage java parameter style derby deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.makeBlob'\n");
        this.goodStatement(dboConnection, "create function vbl_reverse( inputVal blob ) returns blob\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.reverse'\n");
        this.goodStatement(dboConnection, "create function vbl_add( leftV blob, rightV blob ) returns blob\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.add'\n");
        this.goodStatement(dboConnection, "create function vbl_equals( leftV blob, rightV blob ) returns boolean\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.equals'\n");
        this.goodStatement(dboConnection, "create function xmlX( val varchar( 32672 ) ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.xmlX'\n");
        this.goodStatement(dboConnection, "create type IntArray external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray' language java");
        this.goodStatement(dboConnection, "create function mia( vals int... ) returns IntArray\nlanguage java parameter style derby deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray.makeIntArray'\n");
        this.goodStatement(dboConnection, "create function gc( val IntArray, cellNumber int ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray.getCell'\n");
        String intTargetValues = "( 1, 'orig', 1, 100, 1000 ), ( 2, 'orig: will delete', 1, 101, 1001 ), ( 3, 'orig: will update', 2, 200, 2000 ),\n( 4, 'orig', 2, 201, 2000 ), ( 5, 'orig', 4, 400, 4000 )\n";
        String intSourceValues = "( 1, 101, 10000 ), ( 2, -200, -20000 ), ( 3, 300, 30000 ), ( 5, 5, -5 )\n";
        String intMergeStatement = "merge into targetTable_050 t\nusing sourceTable_050 s on t.onClauseColumn = s.onClauseColumn\nwhen matched and t.matchingClauseColumn = s.matchingClauseColumn\n     then delete\nwhen matched and t.matchingClauseColumn = -s.matchingClauseColumn\n     then update set valueColumn = t.valueColumn + s.valueColumn, description = 'updated'\nwhen not matched and s.onClauseColumn = s.matchingClauseColumn\n     then insert values ( 6, 'inserted', s.onClauseColumn, s.matchingClauseColumn, s.valueColumn )\n";
        String[][] intExpectedValues = new String[][]{{"1", "orig", "1", "100", "1000"}, {"3", "updated", "2", "200", "-18000"}, {"4", "orig", "2", "201", "2000"}, {"5", "orig", "4", "400", "4000"}, {"6", "inserted", "5", "5", "-5"}};
        this.vet_050(dboConnection, "int", true, intTargetValues, intSourceValues, intMergeStatement, intExpectedValues);
        this.vet_050(dboConnection, "bigint", true, intTargetValues, intSourceValues, intMergeStatement, intExpectedValues);
        this.vet_050(dboConnection, "smallint", true, intTargetValues, intSourceValues, intMergeStatement, intExpectedValues);
        this.vet_050(dboConnection, "decimal", true, intTargetValues, intSourceValues, intMergeStatement, intExpectedValues);
        this.vet_050(dboConnection, "numeric", true, intTargetValues, intSourceValues, intMergeStatement, intExpectedValues);
        String[][] doubleExpectedValues = new String[][]{{"1", "orig", "1.0", "100.0", "1000.0"}, {"3", "updated", "2.0", "200.0", "-18000.0"}, {"4", "orig", "2.0", "201.0", "2000.0"}, {"5", "orig", "4.0", "400.0", "4000.0"}, {"6", "inserted", "5.0", "5.0", "-5.0"}};
        this.vet_050(dboConnection, "double", true, intTargetValues, intSourceValues, intMergeStatement, doubleExpectedValues);
        this.vet_050(dboConnection, "float", true, intTargetValues, intSourceValues, intMergeStatement, doubleExpectedValues);
        this.vet_050(dboConnection, "real", true, intTargetValues, intSourceValues, intMergeStatement, doubleExpectedValues);
        String stringTargetValues = "( 1, 'orig', 'b', 'baa', 'baaa' ), ( 2, 'orig: will delete', 'b', 'bab', 'baab' ), ( 3, 'orig: will update', 'c', 'caa', 'caaa' ),\n( 4, 'orig', 'c', 'cab', 'caaa' ), ( 5, 'orig', 'e', 'eaa', 'eaaa' )\n";
        String stringSourceValues = "( 'b', 'bab', 'baaaa' ), ( 'c', '-caa', '-caaaa' ), ( 'd', 'daa', 'daaaa' ), ( 'f', 'f', '-f' )\n";
        String stringMergeStatement = "merge into targetTable_050 t\nusing sourceTable_050 s on t.onClauseColumn = s.onClauseColumn\nwhen matched and t.matchingClauseColumn = s.matchingClauseColumn\n     then delete\nwhen matched and '-' || trim( t.matchingClauseColumn ) = trim( s.matchingClauseColumn )\n     then update set valueColumn = trim( t.valueColumn ) || trim( s.valueColumn ), description = 'updated'\nwhen not matched and s.onClauseColumn = s.matchingClauseColumn\n     then insert values ( 6, 'inserted', s.onClauseColumn, s.matchingClauseColumn, s.valueColumn )\n";
        String[][] stringExpectedValues = new String[][]{{"1", "orig", "b", "baa", "baaa"}, {"3", "updated", "c", "caa", "caaa-caaaa"}, {"4", "orig", "c", "cab", "caaa"}, {"5", "orig", "e", "eaa", "eaaa"}, {"6", "inserted", "f", "f", "-f"}};
        this.vet_050(dboConnection, "varchar( 10 )", true, stringTargetValues, stringSourceValues, stringMergeStatement, stringExpectedValues);
        this.vet_050(dboConnection, "char( 10 )", true, stringTargetValues, stringSourceValues, stringMergeStatement, stringExpectedValues);
        String lvMergeStatement = "merge into targetTable_050 t\nusing sourceTable_050 s on lv_equals_050( t.onClauseColumn, s.onClauseColumn )\nwhen matched and lv_equals_050( t.matchingClauseColumn, s.matchingClauseColumn )\n     then delete\nwhen matched and lv_equals_050( '-' || t.matchingClauseColumn, s.matchingClauseColumn )\n     then update set valueColumn = t.valueColumn || s.valueColumn, description = 'updated'\nwhen not matched and lv_equals_050( s.onClauseColumn, s.matchingClauseColumn )\n     then insert values ( 6, 'inserted', s.onClauseColumn, s.matchingClauseColumn, s.valueColumn )\n";
        this.vet_050(dboConnection, "long varchar", false, stringTargetValues, stringSourceValues, lvMergeStatement, stringExpectedValues);
        String clobMergeStatement = "merge into targetTable_050 t\nusing sourceTable_050 s on clob_equals_050( t.onClauseColumn, s.onClauseColumn )\nwhen matched and clob_equals_050( t.matchingClauseColumn, s.matchingClauseColumn )\n     then delete\nwhen matched and clob_equals_050( '-' || t.matchingClauseColumn, s.matchingClauseColumn )\n     then update set valueColumn = t.valueColumn || s.valueColumn, description = 'updated'\nwhen not matched and clob_equals_050( s.onClauseColumn, s.matchingClauseColumn )\n     then insert values ( 6, 'inserted', s.onClauseColumn, s.matchingClauseColumn, s.valueColumn )\n";
        this.vet_050(dboConnection, "clob", false, stringTargetValues, stringSourceValues, clobMergeStatement, stringExpectedValues);
        String varbinaryTargetValues = "( 1, 'orig', vb( 1 ), vb( 1, 0, 0 ), vb( 1, 0, 0, 0 ) ),\n( 2, 'orig: will delete', vb( 1 ), vb( 1, 0, 1 ), vb( 1, 0, 0, 1 ) ),\n( 3, 'orig: will update', vb( 2 ), vb( 2, 0, 0 ), vb( 2, 0, 0, 0 ) ),\n( 4, 'orig', vb( 2 ), vb( 2, 0, 1 ), vb( 2, 0, 0, 0 ) ),\n( 5, 'orig', vb( 4 ), vb( 4, 0, 0 ), vb( 4, 0, 0, 0 ) )\n";
        String varbinarySourceValues = "( vb( 1 ), vb( 1, 0, 1 ), vb( 1, 0, 0, 0, 0 ) ),\n( vb( 2 ), vb( 0, 0, 2 ), vb( -2, 0, 0, 0, 0 ) ),\n( vb( 3 ), vb( 3, 0, 0 ), vb( 3, 0, 0, 0, 0 ) ),\n( vb( 5 ), vb( 5 ), vb( -5 ) )\n";
        String varbinaryMergeStatement = "merge into targetTable_050 t\nusing sourceTable_050 s on t.onClauseColumn = s.onClauseColumn\nwhen matched and t.matchingClauseColumn = s.matchingClauseColumn\n     then delete\nwhen matched and t.matchingClauseColumn = vb_reverse( s.matchingClauseColumn )\n     then update set valueColumn = vb_add( t.valueColumn, s.valueColumn ), description = 'updated'\nwhen not matched and s.onClauseColumn = s.matchingClauseColumn\n     then insert values ( 6, 'inserted', s.onClauseColumn, s.matchingClauseColumn, s.valueColumn )\n";
        String[][] varbinaryExpectedValues = new String[][]{{"1", "orig", "01", "010000", "01000000"}, {"3", "updated", "02", "020000", "00000000"}, {"4", "orig", "02", "020001", "02000000"}, {"5", "orig", "04", "040000", "04000000"}, {"6", "inserted", "05", "05", "fb"}};
        this.vet_050(dboConnection, "varchar( 10 ) for bit data", true, varbinaryTargetValues, varbinarySourceValues, varbinaryMergeStatement, varbinaryExpectedValues);
        String binaryTargetValues = "( 1, 'orig', ch( 1 ), ch( 1, 0, 0 ), ch( 1, 0, 0, 0 ) ),\n( 2, 'orig: will delete', ch( 1 ), ch( 1, 0, 1 ), ch( 1, 0, 0, 1 ) ),\n( 3, 'orig: will update', ch( 2 ), ch( 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 ), ch( 2, 0, 0, 0 ) ),\n( 4, 'orig', ch( 2 ), ch( 2, 0, 1 ), ch( 2, 0, 0, 0 ) ),\n( 5, 'orig', ch( 4 ), ch( 4, 0, 0 ), ch( 4, 0, 0, 0 ) )\n";
        String binarySourceValues = "( ch( 1 ), ch( 1, 0, 1 ), ch( 1, 0, 0, 0, 0 ) ),\n( ch( 2 ), ch( 0, 0, 0, 0, 0, 0, 0, 0, 0, 2 ), ch( -2, 0, 0, 0, 0 ) ),\n( ch( 3 ), ch( 3, 0, 0 ), ch( 3, 0, 0, 0, 0 ) ),\n( ch( 5 ), ch( 5 ), ch( -5 ) )\n";
        String binaryMergeStatement = "merge into targetTable_050 t\nusing sourceTable_050 s on t.onClauseColumn = s.onClauseColumn\nwhen matched and t.matchingClauseColumn = s.matchingClauseColumn\n     then delete\nwhen matched and t.matchingClauseColumn = ch_reverse( s.matchingClauseColumn )\n     then update set valueColumn = ch_add( t.valueColumn, s.valueColumn ), description = 'updated'\nwhen not matched and s.onClauseColumn = s.matchingClauseColumn\n     then insert values ( 6, 'inserted', s.onClauseColumn, s.matchingClauseColumn, s.valueColumn )\n";
        String[][] binaryExpectedValues = new String[][]{{"1", "orig", "01202020202020202020", "01000020202020202020", "01000000202020202020"}, {"3", "updated", "02202020202020202020", "02000000000000000000", "00000000204040404040"}, {"4", "orig", "02202020202020202020", "02000120202020202020", "02000000202020202020"}, {"5", "orig", "04202020202020202020", "04000020202020202020", "04000000202020202020"}, {"6", "inserted", "05202020202020202020", "05202020202020202020", "fb202020202020202020"}};
        this.vet_050(dboConnection, "char( 10 ) for bit data", true, binaryTargetValues, binarySourceValues, binaryMergeStatement, binaryExpectedValues);
        String blobTargetValues = "( 1, 'orig', vbl( 1 ), vbl( 1, 0, 0 ), vbl( 1, 0, 0, 0 ) ),\n( 2, 'orig: will delete', vbl( 1 ), vbl( 1, 0, 1 ), vbl( 1, 0, 0, 1 ) ),\n( 3, 'orig: will update', vbl( 2 ), vbl( 2, 0, 0 ), vbl( 2, 0, 0, 0 ) ),\n( 4, 'orig', vbl( 2 ), vbl( 2, 0, 1 ), vbl( 2, 0, 0, 0 ) ),\n( 5, 'orig', vbl( 4 ), vbl( 4, 0, 0 ), vbl( 4, 0, 0, 0 ) )\n";
        String blobSourceValues = "( vbl( 1 ), vbl( 1, 0, 1 ), vbl( 1, 0, 0, 0, 0 ) ),\n( vbl( 2 ), vbl( 0, 0, 2 ), vbl( -2, 0, 0, 0, 0 ) ),\n( vbl( 3 ), vbl( 3, 0, 0 ), vbl( 3, 0, 0, 0, 0 ) ),\n( vbl( 5 ), vbl( 5 ), vbl( -5 ) )\n";
        String blobMergeStatement = "merge into targetTable_050 t\nusing sourceTable_050 s on vbl_equals( t.onClauseColumn, s.onClauseColumn )\nwhen matched and vbl_equals( t.matchingClauseColumn, s.matchingClauseColumn )\n     then delete\nwhen matched and vbl_equals( t.matchingClauseColumn, vbl_reverse( s.matchingClauseColumn ) )\n     then update set valueColumn = vbl_add( t.valueColumn, s.valueColumn ), description = 'updated'\nwhen not matched and vbl_equals( s.onClauseColumn, s.matchingClauseColumn )\n     then insert values ( 6, 'inserted', s.onClauseColumn, s.matchingClauseColumn, s.valueColumn )\n";
        this.vet_050(dboConnection, "blob", false, blobTargetValues, blobSourceValues, blobMergeStatement, varbinaryExpectedValues);
        String booleanTargetValues = "( 1, 'orig', true, true, false ), ( 2, 'orig: will delete', true, true, true ), ( 3, 'orig: will update', false, false, true )\n";
        String booleanSourceValues = "( true, true, true ), ( null, true, false ), ( false, false, false )\n";
        String booleanMergeStatement = "merge into targetTable_050 t\nusing sourceTable_050 s on t.onClauseColumn = s.onClauseColumn and t.valueColumn\nwhen matched and t.matchingClauseColumn = s.matchingClauseColumn and s.valueColumn\n     then delete\nwhen matched and t.matchingClauseColumn = s.matchingClauseColumn\n     then update set valueColumn = t.valueColumn and s.valueColumn, description = 'updated'\nwhen not matched and s.matchingClauseColumn\n     then insert values ( 6, 'inserted', s.onClauseColumn, s.matchingClauseColumn, s.valueColumn )\n";
        String[][] booleanExpectedValues = new String[][]{{"1", "orig", "true", "true", "false"}, {"3", "updated", "false", "false", "false"}, {"6", "inserted", null, "true", "false"}};
        this.vet_050(dboConnection, "boolean", true, booleanTargetValues, booleanSourceValues, booleanMergeStatement, booleanExpectedValues);
        String dateTargetValues = "( 1, 'orig', date( '0001-02-23' ), date( '0100-02-23' ), date( '1000-02-23' ) ),\n( 2, 'orig: will delete', date( '0001-02-23' ), date( '0101-02-23' ), date( '1001-02-23' ) ),\n( 3, 'orig: will update', date( '0002-02-23' ), date( '0200-02-23' ), date( '2000-02-23' ) ),\n( 4, 'orig', date( '0002-02-23' ), date( '0201-02-23' ), date( '2000-02-23' ) ),\n( 5, 'orig', date( '0004-02-23' ), date( '0400-02-23' ), date( '4000-02-23' ) )\n";
        String dateSourceValues = "( date( '0001-02-23' ), date( '0101-02-23' ), date( '1000-01-23' ) ),\n( date( '0002-02-23' ), date( '0202-02-23' ), date( '2000-12-23' ) ),\n( date( '0003-02-23' ), date( '0300-02-23' ), date( '3000-01-23' ) ),\n( date( '0005-02-23' ), date( '0005-02-23' ), date( '5000-01-23' ) )\n";
        String dateMergeStatement = "merge into targetTable_050 t\nusing sourceTable_050 s on t.onClauseColumn = s.onClauseColumn\nwhen matched and t.matchingClauseColumn = s.matchingClauseColumn\n     then delete\nwhen matched and year( t.matchingClauseColumn ) = year( s.matchingClauseColumn ) - 2\n     then update set valueColumn = date( month( t.valueColumn ) + month( s.valueColumn ) ), description = 'updated'\nwhen not matched and s.onClauseColumn = s.matchingClauseColumn\n     then insert values ( 6, 'inserted', s.onClauseColumn, s.matchingClauseColumn, s.valueColumn )\n";
        String[][] dateExpectedValues = new String[][]{{"1", "orig", "0001-02-23", "0100-02-23", "1000-02-23"}, {"3", "updated", "0002-02-23", "0200-02-23", "1970-01-14"}, {"4", "orig", "0002-02-23", "0201-02-23", "2000-02-23"}, {"5", "orig", "0004-02-23", "0400-02-23", "4000-02-23"}, {"6", "inserted", "0005-02-23", "0005-02-23", "5000-01-23"}};
        this.vet_050(dboConnection, "date", true, dateTargetValues, dateSourceValues, dateMergeStatement, dateExpectedValues);
        String timeTargetValues = "( 1, 'orig', time( '01:00:01' ), time( '01:01:00' ), time( '01:10:00' ) ),\n( 2, 'orig: will delete', time( '01:00:01' ), time( '01:01:01' ), time( '01:10:01' ) ),\n( 3, 'orig: will update', time( '01:00:02' ), time( '01:02:00' ), time( '01:20:00' ) ),\n( 4, 'orig', time( '01:00:02' ), time( '01:02:01' ), time( '01:20:00' ) ),\n( 5, 'orig', time( '01:00:04' ), time( '01:04:00' ), time( '01:40:00' ) )\n";
        String timeSourceValues = "( time( '01:00:01' ), time( '01:01:01' ), time( '01:00:00' ) ),\n( time( '01:00:02' ), time( '01:02:02' ), time( '20:02:00' ) ),\n( time( '01:00:03' ), time( '01:03:00' ), time( '03:00:00' ) ),\n( time( '01:00:05' ), time( '01:00:05' ), time( '05:00:00' ) )\n";
        String timeMergeStatement = "merge into targetTable_050 t\nusing sourceTable_050 s on t.onClauseColumn = s.onClauseColumn\nwhen matched and t.matchingClauseColumn = s.matchingClauseColumn\n     then delete\nwhen matched and second( t.matchingClauseColumn ) = second( s.matchingClauseColumn ) - 2\n     then update set valueColumn = coalesce( t.valueColumn, s.valueColumn ), description = 'updated'\nwhen not matched and s.onClauseColumn = s.matchingClauseColumn\n     then insert values ( 6, 'inserted', s.onClauseColumn, s.matchingClauseColumn, s.valueColumn )\n";
        String[][] timeExpectedValues = new String[][]{{"1", "orig", "01:00:01", "01:01:00", "01:10:00"}, {"3", "updated", "01:00:02", "01:02:00", "01:20:00"}, {"4", "orig", "01:00:02", "01:02:01", "01:20:00"}, {"5", "orig", "01:00:04", "01:04:00", "01:40:00"}, {"6", "inserted", "01:00:05", "01:00:05", "05:00:00"}};
        this.vet_050(dboConnection, "time", true, timeTargetValues, timeSourceValues, timeMergeStatement, timeExpectedValues);
        String timestampTargetValues = "( 1, 'orig', timestamp( '1960-01-01 01:00:01' ), timestamp( '1960-01-01 01:01:00' ), timestamp( '1960-01-01 01:10:00' ) ),\n( 2, 'orig: will delete', timestamp( '1960-01-01 01:00:01' ), timestamp( '1960-01-01 01:01:01' ), timestamp( '1960-01-01 01:10:01' ) ),\n  ( 3, 'orig: will update', timestamp( '1960-01-01 01:00:02' ), timestamp( '1960-01-01 01:02:00' ), timestamp( '1960-01-01 01:20:00' ) ),\n( 4, 'orig', timestamp( '1960-01-01 01:00:02' ), timestamp( '1960-01-01 01:02:01' ), timestamp( '1960-01-01 01:20:00' ) ),\n( 5, 'orig', timestamp( '1960-01-01 01:00:04' ), timestamp( '1960-01-01 01:04:00' ), timestamp( '1960-01-01 01:40:00' ) )\n";
        String timestampSourceValues = "( timestamp( '1960-01-01 01:00:01' ), timestamp( '1960-01-01 01:01:01' ), timestamp( '1960-01-01 01:00:00' ) ),\n( timestamp( '1960-01-01 01:00:02' ), timestamp( '1960-01-01 01:02:02' ), timestamp( '1960-01-01 20:02:00' ) ),\n( timestamp( '1960-01-01 01:00:03' ), timestamp( '1960-01-01 01:03:00' ), timestamp( '1960-01-01 03:00:00' ) ),\n( timestamp( '1960-01-01 01:00:05' ), timestamp( '1960-01-01 01:00:05' ), timestamp( '1960-01-01 05:00:00' ) )\n";
        String timestampMergeStatement = "merge into targetTable_050 t\nusing sourceTable_050 s on t.onClauseColumn = s.onClauseColumn\nwhen matched and t.matchingClauseColumn = s.matchingClauseColumn\n     then delete\nwhen matched and second( t.matchingClauseColumn ) = second( s.matchingClauseColumn ) - 2\n     then update set valueColumn = coalesce( t.valueColumn, s.valueColumn ), description = 'updated'\nwhen not matched and s.onClauseColumn = s.matchingClauseColumn\n     then insert values ( 6, 'inserted', s.onClauseColumn, s.matchingClauseColumn, s.valueColumn )\n";
        String[][] timestampExpectedValues = new String[][]{{"1", "orig", "1960-01-01 01:00:01.0", "1960-01-01 01:01:00.0", "1960-01-01 01:10:00.0"}, {"3", "updated", "1960-01-01 01:00:02.0", "1960-01-01 01:02:00.0", "1960-01-01 01:20:00.0"}, {"4", "orig", "1960-01-01 01:00:02.0", "1960-01-01 01:02:01.0", "1960-01-01 01:20:00.0"}, {"5", "orig", "1960-01-01 01:00:04.0", "1960-01-01 01:04:00.0", "1960-01-01 01:40:00.0"}, {"6", "inserted", "1960-01-01 01:00:05.0", "1960-01-01 01:00:05.0", "1960-01-01 05:00:00.0"}};
        this.vet_050(dboConnection, "timestamp", true, timestampTargetValues, timestampSourceValues, timestampMergeStatement, timestampExpectedValues);
        String xmlTargetValues = "(\n  1,\n  'orig',\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>1</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>100</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>1000</html>' preserve whitespace )\n),\n(\n  2,\n  'orig: will delete',\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>1</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>101</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>1001</html>' preserve whitespace )\n),\n(\n  3,\n  'orig: will update',\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>2</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>200</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>2000</html>' preserve whitespace )\n),\n(\n  4,\n  'orig',\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>2</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>201</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>2000</html>' preserve whitespace )\n),\n(\n  5,\n  'orig',\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>4</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>400</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>4000</html>' preserve whitespace )\n)\n";
        String xmlSourceValues = "(\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>1</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>101</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>10000</html>' preserve whitespace )\n),\n(\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>2</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>-200</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>-20000</html>' preserve whitespace )\n),\n(\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>3</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>300</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>30000</html>' preserve whitespace )\n  ),\n(\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>5</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>5</html>' preserve whitespace ),\n  xmlparse( document '<?xml version=\"1.0\" encoding=\"UTF-8\"?> <html>50000</html>' preserve whitespace )\n)\n";
        String xmlMergeStatement = "merge into targetTable_050 t\nusing sourceTable_050 s on xmlserialize( t.onClauseColumn as varchar(1000) ) = xmlserialize( s.onClauseColumn as varchar(1000) )\nwhen matched and xmlserialize( t.matchingClauseColumn as varchar(1000) ) = xmlserialize( s.matchingClauseColumn as varchar(1000) )\n     then delete\nwhen matched\n     and xmlX( xmlserialize( t.matchingClauseColumn as varchar(1000) ) ) =\n       -xmlX( xmlserialize( s.matchingClauseColumn as varchar(1000) ) )\n     then update set valueColumn = coalesce( t.valueColumn, s.valueColumn ), description = 'updated'\nwhen not matched and xmlserialize( s.onClauseColumn as varchar(1000) ) = xmlserialize( s.matchingClauseColumn as varchar(1000) )\n     then insert values ( 6, 'inserted', s.onClauseColumn, s.matchingClauseColumn, s.valueColumn )\n";
        String[][] xmlExpectedValues = new String[][]{{"1", "orig", "1", "100", "1000"}, {"3", "updated", "2", "200", "2000"}, {"4", "orig", "2", "201", "2000"}, {"5", "orig", "4", "400", "4000"}, {"6", "inserted", "5", "5", "50000"}};
        this.vet_050(dboConnection, "xml", false, xmlTargetValues, xmlSourceValues, xmlMergeStatement, xmlExpectedValues, "select\n  primaryKey,\n  description,\n  xmlX( xmlserialize( onClauseColumn as varchar(1000) ) ),\n  xmlX( xmlserialize( matchingClauseColumn as varchar(1000) ) ),\n  xmlX( xmlserialize( valueColumn as varchar(1000) ) )\nfrom targetTable_050 order by primaryKey\n");
        String udtTargetValues = "( 1, 'orig', mia( 1 ), mia( 100 ), mia( 1000 ) ),\n( 2, 'orig: will delete', mia( 1 ), mia( 101 ), mia( 1001 ) ),\n( 3, 'orig: will update', mia( 2 ), mia( 200 ), mia( 2000 ) ),\n( 4, 'orig', mia( 2 ), mia( 201 ), mia( 2000 ) ),\n( 5, 'orig', mia( 4 ), mia( 400 ), mia( 4000 ) )\n";
        String udtSourceValues = "( mia( 1 ), mia( 101 ), mia( 10000 ) ),\n( mia( 2 ), mia( -200 ), mia( -20000 ) ),\n( mia( 3 ), mia( 300 ), mia( 30000 ) ),\n( mia( 5 ), mia( 5 ), mia( -5 ) )\n";
        String udtMergeStatement = "merge into targetTable_050 t\nusing sourceTable_050 s on gc( t.onClauseColumn, 0 ) = gc( s.onClauseColumn, 0 )\nwhen matched and gc( t.matchingClauseColumn, 0 ) = gc( s.matchingClauseColumn, 0 )\n     then delete\nwhen matched and gc( t.matchingClauseColumn, 0 ) = -gc( s.matchingClauseColumn, 0 )\n     then update set valueColumn = mia( gc( t.valueColumn, 0 ) + gc( s.valueColumn, 0 ) ), description = 'updated'\nwhen not matched and gc( s.onClauseColumn, 0 ) = gc( s.matchingClauseColumn, 0 )\n     then insert values ( 6, 'inserted', s.onClauseColumn, s.matchingClauseColumn, s.valueColumn )\n";
        String udtSelectStatement = "select\n  primaryKey,\n  description,\n  gc( onClauseColumn, 0 ),\n  gc( matchingClauseColumn, 0 ),\n  gc( valueColumn, 0 )\nfrom targetTable_050 order by primaryKey\n";
        this.vet_050(dboConnection, "IntArray", false, udtTargetValues, udtSourceValues, udtMergeStatement, intExpectedValues, udtSelectStatement);
        this.goodStatement(dboConnection, "drop function lv_equals_050");
        this.goodStatement(dboConnection, "drop function clob_equals_050");
        this.goodStatement(dboConnection, "drop function vb");
        this.goodStatement(dboConnection, "drop function vb_reverse");
        this.goodStatement(dboConnection, "drop function vb_add");
        this.goodStatement(dboConnection, "drop function ch");
        this.goodStatement(dboConnection, "drop function ch_reverse");
        this.goodStatement(dboConnection, "drop function ch_add");
        this.goodStatement(dboConnection, "drop function vbl");
        this.goodStatement(dboConnection, "drop function vbl_reverse");
        this.goodStatement(dboConnection, "drop function vbl_add");
        this.goodStatement(dboConnection, "drop function vbl_equals");
        this.goodStatement(dboConnection, "drop function xmlX");
        this.goodStatement(dboConnection, "drop function mia");
        this.goodStatement(dboConnection, "drop function gc");
        this.goodStatement(dboConnection, "drop type IntArray restrict");
    }

    private void vet_050(Connection conn, String datatype, boolean indexable, String initialTargetValues, String initialSourceValues, String mergeStatement, String[][] expectedResults) throws Exception {
        String selectStatement = "select * from targetTable_050 order by primaryKey";
        this.vet_050(conn, datatype, indexable, initialTargetValues, initialSourceValues, mergeStatement, expectedResults, selectStatement);
    }

    private void vet_050(Connection conn, String datatype, boolean indexable, String initialTargetValues, String initialSourceValues, String mergeStatement, String[][] expectedResults, String selectStatement) throws Exception {
        this.goodStatement(conn, "create table targetTable_050\n(\n    primaryKey int,\n    description varchar( 20 ),\n    onClauseColumn " + datatype + ",\n" + "    matchingClauseColumn " + datatype + ",\n" + "    valueColumn " + datatype + "\n" + ")\n");
        this.goodStatement(conn, "create table sourceTable_050\n(\n    onClauseColumn " + datatype + ",\n" + "    matchingClauseColumn " + datatype + ",\n" + "    valueColumn " + datatype + "\n" + ")\n");
        this.vet_050(conn, initialTargetValues, initialSourceValues, mergeStatement, expectedResults, selectStatement);
        if (indexable) {
            this.goodStatement(conn, "create index tt_050_idx on targetTable_050( onClauseColumn )");
            this.goodStatement(conn, "create index st_050_idx on sourceTable_050( onClauseColumn )");
            this.vet_050(conn, initialTargetValues, initialSourceValues, mergeStatement, expectedResults, selectStatement);
        }
        this.goodStatement(conn, "drop table targetTable_050");
        this.goodStatement(conn, "drop table sourceTable_050");
    }

    private void vet_050(Connection conn, String initialTargetValues, String initialSourceValues, String mergeStatement, String[][] expectedResults, String selectStatement) throws Exception {
        this.populate_050(conn, initialTargetValues, initialSourceValues);
        this.goodUpdate(conn, mergeStatement, 3);
        this.assertResults(conn, selectStatement, expectedResults, true);
    }

    private void populate_050(Connection conn, String initialTargetValues, String initialSourceValues) throws Exception {
        this.goodStatement(conn, "delete from targetTable_050");
        this.goodStatement(conn, "delete from sourceTable_050");
        this.goodStatement(conn, "insert into targetTable_050 values " + initialTargetValues);
        this.goodStatement(conn, "insert into sourceTable_050 values " + initialSourceValues);
    }

    public void test_051_multiBlob() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create function mb_051( repeatCount int, vals int... ) returns blob\nlanguage java parameter style derby deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.makeBlob'\n");
        this.goodStatement(dboConnection, "create function bequals_051( leftV blob, rightV blob ) returns boolean\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.equals'\n");
        this.goodStatement(dboConnection, "create function reverse_051( leftV blob ) returns blob\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.reverse'\n");
        this.goodStatement(dboConnection, "create function gc_051( leftV blob, idx bigint ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.getCell'\n");
        this.goodStatement(dboConnection, "create function add_051( leftV blob, rightV blob ) returns blob\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.add'\n");
        this.goodStatement(dboConnection, "create table targetTable_051\n(\n    primaryKey int,\n    description varchar( 20 ),\n    valueColumn blob,\n    generatedColumn generated always as ( reverse_051( valueColumn ) )\n)\n");
        this.goodStatement(dboConnection, "create table sourceTable_051\n(\n    primaryKey int,\n    valueColumn blob\n)\n");
        this.goodStatement(dboConnection, "insert into targetTable_051 ( primaryKey, description, valueColumn ) values\n( 1, 'orig', mb_051( 10000, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 ) ),\n( 2, 'orig: will delete', mb_051( 20000, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 ) ),\n( 3, 'orig: will update', mb_051( 30000, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 ) ),\n( 4, 'orig', mb_051( 10000, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39 ) ),\n( 5, 'orig: will update', mb_051( 30000, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 ) ),\n( 6, 'orig: will delete', mb_051( 20000, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 ) )\n");
        this.goodStatement(dboConnection, "insert into sourceTable_051 values\n( 20, mb_051( 20000, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 ) ),\n( 21, mb_051( 30000, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 ) ),\n( 22, mb_051( 5000, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69 ) ),\n( 23, mb_051( 6000, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59 ) )\n");
        this.goodUpdate(dboConnection, "merge into targetTable_051 t\nusing sourceTable_051 s on bequals_051( t.valueColumn, s.valueColumn )\nwhen matched and gc_051( t.valueColumn, 1000 ) = 10\n     then delete\nwhen matched and gc_051( t.valueColumn, 1001 ) = 21\n     then update set valueColumn = add_051( t.valueColumn, s.valueColumn ), description = 'updated'\nwhen not matched and mod( gc_051( s.valueColumn, 3002 ), 10 ) = 2\n     then insert ( primaryKey, description, valueColumn ) values ( s.primarykey, 'inserted', s.valueColumn )\n", 6);
        this.assertResults(dboConnection, "select\n  primaryKey,\n  description,\n  gc_051( valueColumn, 2001 ),\n  gc_051( generatedColumn, 2001 )\nfrom targetTable_051 order by primaryKey\n", new String[][]{{"1", "orig", "1", "8"}, {"3", "updated", "42", "56"}, {"4", "orig", "31", "38"}, {"5", "updated", "42", "56"}, {"22", "inserted", "61", "68"}, {"23", "inserted", "51", "58"}}, false);
        this.goodStatement(dboConnection, "drop table sourceTable_051");
        this.goodStatement(dboConnection, "drop table targetTable_051");
        this.goodStatement(dboConnection, "drop function mb_051");
        this.goodStatement(dboConnection, "drop function bequals_051");
        this.goodStatement(dboConnection, "drop function reverse_051");
        this.goodStatement(dboConnection, "drop function gc_051");
        this.goodStatement(dboConnection, "drop function add_051");
    }

    public void test_052_multiClob() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create function mc_052( repeatCount int, vals varchar( 32672 )... ) returns clob\nlanguage java parameter style derby deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.makeClob'\n");
        this.goodStatement(dboConnection, "create function cequals_052( leftV clob, rightV clob ) returns boolean\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.equals'\n");
        this.goodStatement(dboConnection, "create function reverse_052( leftV clob ) returns clob\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.reverse'\n");
        this.goodStatement(dboConnection, "create function gc_052( leftV clob, idx bigint ) returns varchar( 1 )\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.getCell'\n");
        this.goodStatement(dboConnection, "create function add_052( leftV clob, rightV clob ) returns clob\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.add'\n");
        this.goodStatement(dboConnection, "create table targetTable_052\n(\n    primaryKey int,\n    description varchar( 20 ),\n    valueColumn clob,\n    generatedColumn generated always as ( reverse_052( valueColumn ) )\n)\n");
        this.goodStatement(dboConnection, "create table sourceTable_052\n(\n    primaryKey int,\n    valueColumn clob\n)\n");
        this.goodStatement(dboConnection, "insert into targetTable_052 ( primaryKey, description, valueColumn ) values\n( 1, 'orig', mc_052( 10000, 'abcdefghij' ) ),\n( 2, 'orig: will delete', mc_052( 20000, 'klmnopqrst' ) ),\n( 3, 'orig: will update', mc_052( 30000, 'tuvwxyzabc' ) ),\n( 4, 'orig', mc_052( 10000, 'defghijklm' ) ),\n( 5, 'orig: will update', mc_052( 30000, 'tuvwxyzabc' ) ),\n( 6, 'orig: will delete', mc_052( 20000, 'klmnopqrst' ) )\n");
        this.goodStatement(dboConnection, "insert into sourceTable_052 values\n( 20, mc_052( 20000, 'klmnopqrst' ) ),\n( 21, mc_052( 30000, 'tuvwxyzabc' ) ),\n( 22, mc_052( 5000, 'opqrstuvwx' ) ),\n( 23, mc_052( 6000, 'opqrstuvwx' ) )\n");
        this.goodUpdate(dboConnection, "merge into targetTable_052 t\nusing sourceTable_052 s on cequals_052( t.valueColumn, s.valueColumn )\nwhen matched and gc_052( t.valueColumn, 1000 ) = 'k'\n     then delete\nwhen matched and gc_052( t.valueColumn, 1001 ) = 'u'\n     then update set valueColumn = add_052( t.valueColumn, s.valueColumn ), description = 'updated'\nwhen not matched and gc_052( s.valueColumn, 3002 ) = 'q'\n     then insert ( primaryKey, description, valueColumn ) values ( s.primarykey, 'inserted', s.valueColumn )\n", 6);
        this.assertResults(dboConnection, "select\n  primaryKey,\n  description,\n  gc_052( valueColumn, 2001 ),\n  gc_052( generatedColumn, 2001 )\nfrom targetTable_052 order by primaryKey\n", new String[][]{{"1", "orig", "b", "i"}, {"3", "updated", "u", "b"}, {"4", "orig", "e", "l"}, {"5", "updated", "u", "b"}, {"22", "inserted", "p", "w"}, {"23", "inserted", "p", "w"}}, false);
        this.goodStatement(dboConnection, "drop table sourceTable_052");
        this.goodStatement(dboConnection, "drop table targetTable_052");
        this.goodStatement(dboConnection, "drop function mc_052");
        this.goodStatement(dboConnection, "drop function cequals_052");
        this.goodStatement(dboConnection, "drop function reverse_052");
        this.goodStatement(dboConnection, "drop function gc_052");
        this.goodStatement(dboConnection, "drop function add_052");
    }

    public void test_053_nullGeneratedColumns() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table targetTable_053\n(\n    primaryKey int,\n    description varchar( 20 ),\n    valueColumn int,\n    notUpdatedColumn int,\n    generatedColumn generated always as ( valueColumn + notUpdatedColumn )\n)\n");
        this.goodStatement(dboConnection, "create table sourceTable_053\n(\n    primaryKey int,\n    valueColumn int\n)\n");
        this.goodStatement(dboConnection, "insert into targetTable_053 ( primaryKey, description, valueColumn, notUpdatedColumn ) values\n( 1, 'orig', 1, 100 ),\n( 2, 'orig: will delete', 2, 200 ),\n( 3, 'orig: will update', 3, 300 ),\n( 4, 'orig', 4, 400 ),\n( 5, 'orig: will update', 5, 500 ),\n( 6, 'orig: will delete', 6, 600 )\n");
        this.goodStatement(dboConnection, "insert into sourceTable_053 values\n( 2, -1 ),\n( 3, 300 ),\n( 5, null ),\n( 6, -1 ),\n( 7, 100 ),\n( 8, null ),\n( 100, null )\n");
        this.goodUpdate(dboConnection, "merge into targetTable_053 t\nusing sourceTable_053 s on t.primaryKey = s.primaryKey\nwhen matched and s.valueColumn < 0 then delete\nwhen matched and s.valueColumn > 0 or t.valueColumn = 5\n     then update set valueColumn = t.valueColumn + s.valueColumn, description = 'updated'\nwhen not matched and s.primaryKey < 10\n     then insert ( primaryKey, description, valueColumn, notUpdatedColumn ) values ( s.primarykey, 'inserted', s.valueColumn, 1 )\n", 6);
        this.assertResults(dboConnection, "select * from targetTable_053 order by primaryKey", new String[][]{{"1", "orig", "1", "100", "101"}, {"3", "updated", "303", "300", "603"}, {"4", "orig", "4", "400", "404"}, {"5", "updated", null, "500", null}, {"7", "inserted", "100", "1", "101"}, {"8", "inserted", null, "1", null}}, false);
        this.goodStatement(dboConnection, "drop table sourceTable_053");
        this.goodStatement(dboConnection, "drop table targetTable_053");
    }

    public void test_054_triggersOnGeneratedColumns() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create procedure truncateTriggerHistory_054()\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.truncateTriggerHistory'\n");
        this.goodStatement(dboConnection, "create procedure addHistoryRow_054\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(dboConnection, "create function history_054()\nreturns table\n(\n    action varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.history'\n");
        this.goodStatement(dboConnection, "create table targetTable_054\n(\n    primaryKey int,\n    description varchar( 20 ),\n    valueColumn int,\n    notUpdatedColumn int,\n    generatedColumn generated always as ( valueColumn + notUpdatedColumn )\n)\n");
        this.goodStatement(dboConnection, "create table sourceTable_054\n(\n    primaryKey int,\n    valueColumn int\n)\n");
        this.goodStatement(dboConnection, "create trigger t1_054_del_before\nno cascade before delete on targetTable_054\nreferencing old as old\nfor each row\ncall addHistoryRow_054( 'before delete', old.generatedColumn )\n");
        this.goodStatement(dboConnection, "create trigger t1_054_del_after\nafter delete on targetTable_054\nreferencing old as old\nfor each row\ncall addHistoryRow_054( 'after delete', old.generatedColumn )\n");
        this.goodStatement(dboConnection, "create trigger t1_054_ins_after\nafter insert on targetTable_054\nreferencing new as new\nfor each row\ncall addHistoryRow_054( 'after insert', new.generatedColumn )\n");
        this.goodStatement(dboConnection, "create trigger t1_054_upd_before\nno cascade before update on targetTable_054\nreferencing old as old\nfor each row\ncall addHistoryRow_054( 'before update', old.generatedColumn )\n");
        this.goodStatement(dboConnection, "create trigger t1_054_upd_after\nafter update on targetTable_054\nreferencing new as new\nfor each row\ncall addHistoryRow_054( 'after update', new.generatedColumn )\n");
        this.goodStatement(dboConnection, "insert into targetTable_054 ( primaryKey, description, valueColumn, notUpdatedColumn ) values\n( 1, 'orig', 1, 100 ),\n( 2, 'orig: will delete', 2, 200 ),\n( 3, 'orig: will update', 3, 300 ),\n( 4, 'orig', 4, 400 ),\n( 5, 'orig: will update', 5, 500 ),\n( 6, 'orig: will delete', 6, 600 )\n");
        this.goodStatement(dboConnection, "insert into sourceTable_054 values\n( 2, -1 ),\n( 3, 300 ),\n( 5, null ),\n( 6, -1 ),\n( 7, 100 ),\n( 8, null ),\n( 100, null )\n");
        this.goodStatement(dboConnection, "call truncateTriggerHistory_054()");
        this.goodUpdate(dboConnection, "merge into targetTable_054 t\nusing sourceTable_054 s on t.primaryKey = s.primaryKey\nwhen matched and s.valueColumn < 0 then delete\nwhen matched and s.valueColumn > 0 or t.valueColumn = 5\n     then update set valueColumn = t.valueColumn + s.valueColumn, description = 'updated'\nwhen not matched and s.primaryKey < 10\n     then insert ( primaryKey, description, valueColumn, notUpdatedColumn ) values ( s.primarykey, 'inserted', s.valueColumn, 1 )\n", 6);
        this.assertResults(dboConnection, "select * from targetTable_054 order by primaryKey", new String[][]{{"1", "orig", "1", "100", "101"}, {"3", "updated", "303", "300", "603"}, {"4", "orig", "4", "400", "404"}, {"5", "updated", null, "500", null}, {"7", "inserted", "100", "1", "101"}, {"8", "inserted", null, "1", null}}, false);
        this.assertResults(dboConnection, "select * from table( history_054() ) h", new String[][]{{"before delete", "202"}, {"before delete", "606"}, {"after delete", "202"}, {"after delete", "606"}, {"before update", "303"}, {"before update", "505"}, {"after update", "603"}, {"after update", null}, {"after insert", "101"}, {"after insert", null}}, false);
        this.goodStatement(dboConnection, "drop table sourceTable_054");
        this.goodStatement(dboConnection, "drop table targetTable_054");
        this.goodStatement(dboConnection, "drop function history_054");
        this.goodStatement(dboConnection, "drop procedure addHistoryRow_054");
        this.goodStatement(dboConnection, "drop procedure truncateTriggerHistory_054");
    }

    public void test_055_triggersMultiBlob() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create procedure truncateTriggerHistory_055()\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.truncateTriggerHistory'\n");
        this.goodStatement(dboConnection, "create procedure addHistoryRow_055\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(dboConnection, "create function history_055()\nreturns table\n(\n    action varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.history'\n");
        this.goodStatement(dboConnection, "create function mb_055( repeatCount int, vals int... ) returns blob\nlanguage java parameter style derby deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.makeBlob'\n");
        this.goodStatement(dboConnection, "create function bequals_055( leftV blob, rightV blob ) returns boolean\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.equals'\n");
        this.goodStatement(dboConnection, "create function reverse_055( leftV blob ) returns blob\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.reverse'\n");
        this.goodStatement(dboConnection, "create function gc_055( leftV blob, idx bigint ) returns int\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.getCell'\n");
        this.goodStatement(dboConnection, "create function add_055( leftV blob, rightV blob ) returns blob\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.add'\n");
        this.goodStatement(dboConnection, "create table targetTable_055\n(\n    primaryKey int,\n    description varchar( 20 ),\n    valueColumn blob,\n    generatedColumn generated always as ( reverse_055( valueColumn ) )\n)\n");
        this.goodStatement(dboConnection, "create table sourceTable_055\n(\n    primaryKey int,\n    valueColumn blob\n)\n");
        this.goodStatement(dboConnection, "create trigger t1_055_del_before\nno cascade before delete on targetTable_055\nreferencing old as old\nfor each row\ncall addHistoryRow_055( 'before delete', gc_055( old.generatedColumn, 50153 ) + gc_055( old.generatedColumn, 50154 ) )\n");
        this.goodStatement(dboConnection, "create trigger t1_055_del_after\nafter delete on targetTable_055\nreferencing old as old\nfor each row\ncall addHistoryRow_055( 'after delete', gc_055( old.generatedColumn, 50153 ) + gc_055( old.generatedColumn, 50154 ) )\n");
        this.goodStatement(dboConnection, "create trigger t1_055_ins_after\nafter insert on targetTable_055\nreferencing new as new\nfor each row\ncall addHistoryRow_055( 'after insert', gc_055( new.generatedColumn, 50153 ) + gc_055( new.generatedColumn, 50154 ) )\n");
        this.goodStatement(dboConnection, "create trigger t1_055_upd_before\nno cascade before update on targetTable_055\nreferencing old as old\nfor each row\ncall addHistoryRow_055( 'before update', gc_055( old.generatedColumn, 50153 ) + gc_055( old.generatedColumn, 50154 ) )\n");
        this.goodStatement(dboConnection, "create trigger t1_055_upd_after\nafter update on targetTable_055\nreferencing new as new\nfor each row\ncall addHistoryRow_055( 'after update', gc_055( new.generatedColumn, 50153 ) + gc_055( new.generatedColumn, 50154 ) )\n");
        this.goodStatement(dboConnection, "insert into targetTable_055 ( primaryKey, description, valueColumn ) values\n( 1, 'orig', mb_055( 10000, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 ) ),\n( 2, 'orig: will delete', mb_055( 20000, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 ) ),\n( 3, 'orig: will update', mb_055( 30000, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 ) ),\n( 4, 'orig', mb_055( 10000, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39 ) ),\n( 5, 'orig: will update', mb_055( 30000, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 ) ),\n( 6, 'orig: will delete', mb_055( 20000, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 ) )\n");
        this.goodStatement(dboConnection, "insert into sourceTable_055 values\n( 20, mb_055( 20000, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 ) ),\n( 21, mb_055( 30000, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 ) ),\n( 22, mb_055( 7000, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69 ) ),\n( 23, mb_055( 6000, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59 ) )\n");
        this.goodStatement(dboConnection, "call truncateTriggerHistory_055()");
        this.goodUpdate(dboConnection, "merge into targetTable_055 t\nusing sourceTable_055 s on bequals_055( t.valueColumn, s.valueColumn )\nwhen matched and gc_055( t.valueColumn, 1000 ) = 10\n     then delete\nwhen matched and gc_055( t.valueColumn, 1001 ) = 21\n     then update set valueColumn = add_055( t.valueColumn, s.valueColumn ), description = 'updated'\nwhen not matched and mod( gc_055( s.valueColumn, 3002 ), 10 ) = 2\n     then insert ( primaryKey, description, valueColumn ) values ( s.primarykey, 'inserted', s.valueColumn )\n", 6);
        this.assertResults(dboConnection, "select\n  primaryKey,\n  description,\n  gc_055( valueColumn, 2001 ),\n  gc_055( generatedColumn, 2001 )\nfrom targetTable_055 order by primaryKey\n", new String[][]{{"1", "orig", "1", "8"}, {"3", "updated", "42", "56"}, {"4", "orig", "31", "38"}, {"5", "updated", "42", "56"}, {"22", "inserted", "61", "68"}, {"23", "inserted", "51", "58"}}, false);
        this.assertResults(dboConnection, "select * from table( history_055() ) h", new String[][]{{"before delete", "31"}, {"before delete", "31"}, {"after delete", "31"}, {"after delete", "31"}, {"before update", "51"}, {"before update", "51"}, {"after update", "102"}, {"after update", "102"}, {"after insert", "131"}, {"after insert", "111"}}, false);
        this.goodStatement(dboConnection, "drop table sourceTable_055");
        this.goodStatement(dboConnection, "drop table targetTable_055");
        this.goodStatement(dboConnection, "drop function add_055");
        this.goodStatement(dboConnection, "drop function gc_055");
        this.goodStatement(dboConnection, "drop function reverse_055");
        this.goodStatement(dboConnection, "drop function bequals_055");
        this.goodStatement(dboConnection, "drop function mb_055");
        this.goodStatement(dboConnection, "drop function history_055");
        this.goodStatement(dboConnection, "drop procedure addHistoryRow_055");
        this.goodStatement(dboConnection, "drop procedure truncateTriggerHistory_055");
    }

    public void test_056_triggersMultiClob() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create procedure truncateTriggerHistory_056()\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.truncateTriggerHistory'\n");
        this.goodStatement(dboConnection, "create procedure addHistoryRow_056\n(\n    actionString varchar( 20 ),\n    actionValue varchar( 20 )\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(dboConnection, "create function history_056()\nreturns table\n(\n    action varchar( 20 ),\n    actionValue varchar( 20 )\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.history'\n");
        this.goodStatement(dboConnection, "create function mc_056( repeatCount int, vals varchar( 32672 )... ) returns clob\nlanguage java parameter style derby deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.makeClob'\n");
        this.goodStatement(dboConnection, "create function cequals_056( leftV clob, rightV clob ) returns boolean\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.equals'\n");
        this.goodStatement(dboConnection, "create function reverse_056( leftV clob ) returns clob\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.reverse'\n");
        this.goodStatement(dboConnection, "create function gc_056( leftV clob, idx bigint ) returns varchar( 1 )\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.getCell'\n");
        this.goodStatement(dboConnection, "create function add_056( leftV clob, rightV clob ) returns clob\nlanguage java parameter style java deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.add'\n");
        this.goodStatement(dboConnection, "create table targetTable_056\n(\n    primaryKey int,\n    description varchar( 20 ),\n    valueColumn clob,\n    generatedColumn generated always as ( reverse_056( valueColumn ) )\n)\n");
        this.goodStatement(dboConnection, "create table sourceTable_056\n(\n    primaryKey int,\n    valueColumn clob\n)\n");
        this.goodStatement(dboConnection, "create trigger t1_056_del_before\nno cascade before delete on targetTable_056\nreferencing old as old\nfor each row\ncall addHistoryRow_056( 'before delete', gc_056( old.generatedColumn, 50153 ) || gc_056( old.generatedColumn, 50154 ) )\n");
        this.goodStatement(dboConnection, "create trigger t1_056_del_after\nafter delete on targetTable_056\nreferencing old as old\nfor each row\ncall addHistoryRow_056( 'after delete', gc_056( old.generatedColumn, 50153 ) || gc_056( old.generatedColumn, 50154 ) )\n");
        this.goodStatement(dboConnection, "create trigger t1_056_ins_after\nafter insert on targetTable_056\nreferencing new as new\nfor each row\ncall addHistoryRow_056( 'after insert', gc_056( new.generatedColumn, 50153 ) || gc_056( new.generatedColumn, 50154 ) )\n");
        this.goodStatement(dboConnection, "create trigger t1_056_upd_before\nno cascade before update on targetTable_056\nreferencing old as old\nfor each row\ncall addHistoryRow_056( 'before update', gc_056( old.generatedColumn, 50153 ) || gc_056( old.generatedColumn, 50154 ) )\n");
        this.goodStatement(dboConnection, "create trigger t1_056_upd_after\nafter update on targetTable_056\nreferencing new as new\nfor each row\ncall addHistoryRow_056( 'after update', gc_056( new.generatedColumn, 50153 ) || gc_056( new.generatedColumn, 50154 ) )\n");
        this.goodStatement(dboConnection, "insert into targetTable_056 ( primaryKey, description, valueColumn ) values\n( 1, 'orig', mc_056( 10000, 'abcdefghij' ) ),\n( 2, 'orig: will delete', mc_056( 20000, 'klmnopqrst' ) ),\n( 3, 'orig: will update', mc_056( 30000, 'uvwxyzabcd' ) ),\n( 4, 'orig', mc_056( 10000, 'efghijklmn' ) ),\n( 5, 'orig: will update', mc_056( 30000, 'uvwxyzabcd' ) ),\n( 6, 'orig: will delete', mc_056( 20000, 'klmnopqrst' ) )\n");
        this.goodStatement(dboConnection, "insert into sourceTable_056 values\n( 20, mc_056( 20000, 'klmnopqrst' ) ),\n( 21, mc_056( 30000, 'uvwxyzabcd' ) ),\n( 22, mc_056( 7000, 'efghijklmn' ) ),\n( 23, mc_056( 6000, 'opqrstuvwx' ) )\n");
        this.goodStatement(dboConnection, "call truncateTriggerHistory_056()");
        this.goodUpdate(dboConnection, "merge into targetTable_056 t\nusing sourceTable_056 s on cequals_056( t.valueColumn, s.valueColumn )\nwhen matched and gc_056( t.valueColumn, 1000 ) = 'k'\n     then delete\nwhen matched and gc_056( t.valueColumn, 1001 ) = 'v'\n     then update set valueColumn = add_056( t.valueColumn, s.valueColumn ), description = 'updated'\nwhen not matched and gc_056( s.valueColumn, 3002 ) = 'g' or gc_056( s.valueColumn, 3003 ) = 'r'\n     then insert ( primaryKey, description, valueColumn ) values ( s.primarykey, 'inserted', s.valueColumn )\n", 6);
        this.assertResults(dboConnection, "select\n  primaryKey,\n  description,\n  gc_056( valueColumn, 2001 ),\n  gc_056( generatedColumn, 2001 )\nfrom targetTable_056 order by primaryKey\n", new String[][]{{"1", "orig", "b", "i"}, {"3", "updated", "v", "c"}, {"4", "orig", "f", "m"}, {"5", "updated", "v", "c"}, {"22", "inserted", "f", "m"}, {"23", "inserted", "p", "w"}}, false);
        this.assertResults(dboConnection, "select * from table( history_056() ) h", new String[][]{{"before delete", "qp"}, {"before delete", "qp"}, {"after delete", "qp"}, {"after delete", "qp"}, {"before update", "az"}, {"before update", "az"}, {"after update", "az"}, {"after update", "az"}, {"after insert", "kj"}, {"after insert", "ut"}}, false);
        this.goodStatement(dboConnection, "drop table sourceTable_056");
        this.goodStatement(dboConnection, "drop table targetTable_056");
        this.goodStatement(dboConnection, "drop function add_056");
        this.goodStatement(dboConnection, "drop function gc_056");
        this.goodStatement(dboConnection, "drop function reverse_056");
        this.goodStatement(dboConnection, "drop function cequals_056");
        this.goodStatement(dboConnection, "drop function mc_056");
        this.goodStatement(dboConnection, "drop function history_056");
        this.goodStatement(dboConnection, "drop procedure addHistoryRow_056");
        this.goodStatement(dboConnection, "drop procedure truncateTriggerHistory_056");
    }

    public void test_057_deferredDelete() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create procedure truncateTriggerHistory_057()\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.truncateTriggerHistory'\n");
        this.goodStatement(dboConnection, "create procedure addHistoryRow_057\n(\n    actionString varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.addHistoryRow'\n");
        this.goodStatement(dboConnection, "create function history_057()\nreturns table\n(\n    action varchar( 20 ),\n    actionValue int\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.history'\n");
        this.goodStatement(dboConnection, "create table targetTable_057\n(\n    primaryKey int,\n    description varchar( 20 ),\n    valueColumn int,\n    triggerColumn int\n)\n");
        this.goodStatement(dboConnection, "create table sourceTable_057\n(\n    primaryKey int,\n    valueColumn int\n)\n");
        this.goodStatement(dboConnection, "create trigger t1_057_del_before\nno cascade before delete on targetTable_057\nreferencing old as old\nfor each row\ncall addHistoryRow_057( 'before delete', old.triggerColumn )\n");
        this.goodStatement(dboConnection, "create trigger t1_057_del_after\nafter delete on targetTable_057\nreferencing old as old\nfor each row\ncall addHistoryRow_057( 'after delete', old.triggerColumn )\n");
        this.goodStatement(dboConnection, "create trigger t1_057_ins_after\nafter insert on targetTable_057\nreferencing new as new\nfor each row\ncall addHistoryRow_057( 'after insert', new.triggerColumn )\n");
        this.goodStatement(dboConnection, "create trigger t1_057_upd_before\nno cascade before update on targetTable_057\nreferencing old as old\nfor each row\ncall addHistoryRow_057( 'before update', old.triggerColumn )\n");
        this.goodStatement(dboConnection, "create trigger t1_057_upd_after\nafter update on targetTable_057\nreferencing new as new\nfor each row\ncall addHistoryRow_057( 'after update', new.triggerColumn )\n");
        this.goodStatement(dboConnection, "insert into targetTable_057 ( primaryKey, description, valueColumn, triggerColumn ) values\n( 1, 'orig', 10, 100 ),\n( 2, 'orig: will delete', 20, 200 ),\n( 3, 'orig: will update', 30, 300 ),\n( 4, 'orig', 40, 400 ),\n( 5, 'orig: will update', 30, 500 ),\n( 6, 'orig: will delete', 20, 100 )\n");
        this.goodStatement(dboConnection, "insert into sourceTable_057 values\n( 20, 20 ),\n( 21, 30 ),\n( 22, 70 ),\n( 23, 80 )\n");
        this.goodStatement(dboConnection, "call truncateTriggerHistory_057()");
        this.goodUpdate(dboConnection, "merge into targetTable_057 t\nusing sourceTable_057 s on t.valueColumn = s.valueColumn\nwhen matched and t.valueColumn = 20\n     then delete\nwhen matched and t.valueColumn = 30\n     then update set valueColumn = t.valueColumn + s.valueColumn, description = 'updated'\nwhen not matched and s.valueColumn = 70 or s.valueColumn = 80\n     then insert ( primaryKey, description, valueColumn ) values ( s.primarykey, 'inserted', s.valueColumn )\n", 6);
        this.assertResults(dboConnection, "select * from targetTable_057 order by primaryKey", new String[][]{{"1", "orig", "10", "100"}, {"3", "updated", "60", "300"}, {"4", "orig", "40", "400"}, {"5", "updated", "60", "500"}, {"22", "inserted", "70", null}, {"23", "inserted", "80", null}}, false);
        this.assertResults(dboConnection, "select * from table( history_057() ) h", new String[][]{{"before delete", "200"}, {"before delete", "100"}, {"after delete", "200"}, {"after delete", "100"}, {"before update", "300"}, {"before update", "500"}, {"after update", "300"}, {"after update", "500"}, {"after insert", null}, {"after insert", null}}, false);
        this.goodStatement(dboConnection, "drop table sourceTable_057");
        this.goodStatement(dboConnection, "drop table targetTable_057");
        this.goodStatement(dboConnection, "drop function history_057");
        this.goodStatement(dboConnection, "drop procedure addHistoryRow_057");
        this.goodStatement(dboConnection, "drop procedure truncateTriggerHistory_057");
    }

    public void test_058_collation() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.assertResults(dboConnection, "values syscs_util.syscs_get_database_property( 'derby.database.collation' )", new String[][]{{this.expectedCollation()}}, true);
    }

    public void test_059_targetIndex() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        File traceFile = SupportFilesSetup.getReadWrite(TRACE_FILE_NAME);
        SupportFilesSetup.deleteFile(traceFile);
        this.goodStatement(dboConnection, "create function mb_059( repeatCount int, vals int... ) returns blob\nlanguage java parameter style derby deterministic no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.makeBlob'\n");
        this.goodStatement(dboConnection, "create table targetTable_059\n(\n    valueColumn int,\n    unreferencedBlobColumn blob\n)\n");
        this.goodStatement(dboConnection, "create unique index target_059_primary on targetTable_059( valueColumn )");
        this.goodStatement(dboConnection, "create table sourceTable_059\n(\n    valueColumn int\n)\n");
        this.goodStatement(dboConnection, "create unique index source_059_primary on sourceTable_059( valueColumn )");
        this.goodStatement(dboConnection, "insert into sourceTable_059 values\n( 0 ),\n( 2 ),\n( 4 ),\n( 8 )\n");
        PreparedStatement ps = this.chattyPrepare(dboConnection, "insert into targetTable_059 ( valueColumn, unreferencedBlobColumn ) values\n( ?, mb_059( 100000, ? ) )\n");
        for (int i = 0; i < 100; ++i) {
            if (i % 20 == 0) {
                MergeStatementTest.println("Inserting row " + i);
            }
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
        }
        this.goodStatement(dboConnection, "delete from targetTable_059 where valueColumn = 4 or valueColumn = 8");
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'optimizerTracing', true, 'xml' )");
        this.goodUpdate(dboConnection, "merge into targetTable_059 t\nusing sourceTable_059 s on t.valueColumn = s.valueColumn\nwhen matched and t.valueColumn = 0\n     then delete\nwhen matched and t.valueColumn = 2\n     then update set valueColumn = -t.valueColumn\nwhen not matched and s.valueColumn = 4\n     then insert ( valueColumn ) values ( -s.valueColumn )\n", 3);
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'optimizerTracing', false, '" + traceFile.getPath() + "' )");
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'optimizerTracingViews', true, '" + traceFile.getPath() + "' )");
        this.assertResults(dboConnection, "select stmtid, qbid, summary from planCost\nwhere type = 'bestPlan'\norder by stmtid, qbid\n", new String[][]{{"1", "1", "ProjectRestrictNode"}, {"1", "2", "\"TEST_DBO\".\"SOURCE_059_PRIMARY\""}, {"1", "3", "\"TEST_DBO\".\"TARGET_059_PRIMARY\""}}, false);
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'optimizerTracingViews', false )");
        this.assertResults(dboConnection, "select valueColumn from targetTable_059 where valueColumn < 10 order by valueColumn", new String[][]{{"-4"}, {"-2"}, {"1"}, {"3"}, {"5"}, {"6"}, {"7"}, {"9"}}, false);
        this.goodStatement(dboConnection, "drop table sourceTable_059");
        this.goodStatement(dboConnection, "drop table targetTable_059");
        this.goodStatement(dboConnection, "drop function mb_059");
    }

    public void test_060_transitionTableSimpleColumn() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create table t1_060( x int, x1 int )");
        this.goodStatement(dboConnection, "create table t2_060( y int, y1 int )");
        this.goodStatement(dboConnection, "create trigger tr1 after insert on t1_060\nreferencing new table as new\nmerge into t2_060\nusing new on x1 = y1\nwhen matched then update set y = x\n");
        this.goodStatement(dboConnection, "insert into t2_060 values ( 1, 100 ), ( 2, 200 )");
        this.goodStatement(dboConnection, "insert into t1_060 values ( 1000, 100 ), ( 3000, 300 )");
        this.assertResults(dboConnection, "select * from t2_060 order by y, y1", new String[][]{{"2", "200"}, {"1000", "100"}}, false);
        this.goodStatement(dboConnection, "drop table t1_060");
        this.goodStatement(dboConnection, "drop table t2_060");
    }

    public void test_061_Derby6693() throws SQLException {
        Statement s = this.createStatement();
        try {
            s.execute("create table t2(x int)");
            s.execute("create table t1(x int)");
            s.execute("insert into t2 values 3,4");
            this.assertCompileError(NO_AGGREGATE_IN_MATCHING, "merge into t1 using t2 on (t1.x=t2.x) when not matched then insert values (max(t2.x))");
        }
        finally {
            this.dropTable("t1");
            this.dropTable("t2");
        }
    }

    public void test_062_Derby6550() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t(a bigint generated always as identity     ( start with 9223372036854775806 ),b int)");
        s.execute("create function integerList()\nreturns table(a int,b int,c int,d int)\nlanguage java\nparameter style derby_jdbc_result_set\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.MergeStatementTest.integerList_023'\n");
        MergeStatementTest.assertStatementError("2200H", s, "insert into t( b ) values ( 1 ), ( 2 ), ( 3 ), ( 4 ), ( 5 )");
        MergeStatementTest.assertStatementError("2200H", s, "insert into t( b ) select b from table( integerList() ) il");
        JDBC.assertEmpty(s.executeQuery("select * from t"));
    }

    public static int illegalFunction() throws Exception {
        Connection conn = MergeStatementTest.getNestedConnection();
        conn.prepareStatement("insert into t1( c2 ) values ( 1 )").executeUpdate();
        return 1;
    }

    public static void truncateTriggerHistory() {
        _triggerHistory.clear();
    }

    public static ResultSet history() {
        String[][] rows = new String[_triggerHistory.size()][];
        _triggerHistory.toArray((T[])rows);
        return new StringArrayVTI(TRIGGER_HISTORY_COLUMNS, rows);
    }

    public static IntegerArrayVTI integerList_023() {
        return new IntegerArrayVTI(new String[]{"A", "B", "C", "D"}, (int[][])new int[][]{{1, 11, 101, 1001}, {2, 12, 102, 1002}, {3, 13, 103, 1003}, {4, 14, 104, 1004}, {5, 15, 105, 1005}});
    }

    public static IntegerArrayVTI singlerow_028() {
        return new IntegerArrayVTI(new String[]{"X"}, (int[][])new int[][]{{1}});
    }

    public static IntegerArrayVTI tworow_041() {
        return new IntegerArrayVTI(new String[]{"I"}, (int[][])new int[][]{{1}, {3}});
    }

    public static void countRows(String candidateName, String actionString) throws SQLException {
        Connection conn = MergeStatementTest.getNestedConnection();
        String selectCount = "select count(*) from " + candidateName;
        ResultSet selectRS = conn.prepareStatement(selectCount).executeQuery();
        selectRS.next();
        int rowCount = selectRS.getInt(1);
        selectRS.close();
        MergeStatementTest.addHistoryRow(actionString, rowCount);
    }

    public static void sumColumn(String candidateName, String columnName, String actionString) throws SQLException {
        Connection conn = MergeStatementTest.getNestedConnection();
        String selectSum = "select sum( " + columnName + " ) from " + candidateName;
        ResultSet selectRS = conn.prepareStatement(selectSum).executeQuery();
        selectRS.next();
        int sum = selectRS.getInt(1);
        selectRS.close();
        MergeStatementTest.addHistoryRow(actionString, sum);
    }

    public static void addHistoryRow(String actionString, Integer actionValue) {
        _triggerHistory.add(new String[]{actionString, actionValue == null ? null : actionValue.toString()});
    }

    public static void addHistoryRow(String actionString, String actionValue) {
        _triggerHistory.add(new String[]{actionString, actionValue});
    }

    public static boolean equals(String left, String right) {
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }

    public static boolean equals(Clob left, Clob right) throws SQLException {
        if (left == null) {
            return false;
        }
        if (right == null) {
            return false;
        }
        String leftString = left.getSubString(1L, (int)left.length());
        String rightString = right.getSubString(1L, (int)right.length());
        return leftString.equals(rightString);
    }

    public static boolean equals(Blob left, Blob right) throws SQLException {
        if (left == null) {
            return false;
        }
        if (right == null) {
            return false;
        }
        return Arrays.equals(left.getBytes(1L, (int)left.length()), right.getBytes(1L, (int)right.length()));
    }

    public static byte[] reverse(byte[] input) {
        if (input == null) {
            return null;
        }
        int count = input.length;
        byte[] output = new byte[count];
        for (int i = 0; i < count; ++i) {
            output[count - i - 1] = input[i];
        }
        return output;
    }

    public static String reverse(String inputString) {
        if (inputString == null) {
            return null;
        }
        char[] input = inputString.toCharArray();
        int count = input.length;
        char[] output = new char[count];
        for (int i = 0; i < count; ++i) {
            output[count - i - 1] = input[i];
        }
        return new String(output);
    }

    public static Blob reverse(Blob inputBlob) throws SQLException {
        if (inputBlob == null) {
            return null;
        }
        return new HarmonySerialBlob(MergeStatementTest.reverse(inputBlob.getBytes(1L, (int)inputBlob.length())));
    }

    public static Clob reverse(Clob inputClob) throws SQLException {
        if (inputClob == null) {
            return null;
        }
        return new HarmonySerialClob(MergeStatementTest.reverse(inputClob.getSubString(1L, (int)inputClob.length())));
    }

    public static byte[] add(byte[] left, byte[] right) {
        if (left == null) {
            return null;
        }
        if (right == null) {
            return null;
        }
        int count = Math.min(left.length, right.length);
        byte[] retval = new byte[count];
        for (int i = 0; i < count; ++i) {
            retval[i] = (byte)(left[i] + right[i]);
        }
        return retval;
    }

    public static Blob add(Blob left, Blob right) throws SQLException {
        if (left == null) {
            return null;
        }
        if (right == null) {
            return null;
        }
        return new HarmonySerialBlob(MergeStatementTest.add(left.getBytes(1L, (int)left.length()), right.getBytes(1L, (int)right.length())));
    }

    public static Clob add(Clob left, Clob right) throws SQLException {
        if (left == null) {
            return null;
        }
        if (right == null) {
            return null;
        }
        return new HarmonySerialClob(left.getSubString(1L, (int)left.length()) + right.getSubString(1L, (int)right.length()));
    }

    public static byte[] makeByteArray(Integer ... inputs) {
        if (inputs == null) {
            return null;
        }
        byte[] retval = new byte[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            retval[i] = (byte)inputs[i].intValue();
        }
        return retval;
    }

    public static Blob makeBlob(int ... inputs) {
        return MergeStatementTest.makeBlob(1, inputs);
    }

    public static Blob makeBlob(int repeatCount, int ... inputs) {
        if (inputs == null) {
            return null;
        }
        if (inputs.length == 0 || repeatCount == 0) {
            return null;
        }
        byte[] retval = new byte[repeatCount * inputs.length];
        int idx = 0;
        for (int i = 0; i < repeatCount; ++i) {
            for (int val : inputs) {
                retval[idx++] = (byte)val;
            }
        }
        return new HarmonySerialBlob(retval);
    }

    public static Clob makeClob(int repeatCount, String ... inputs) {
        if (inputs == null) {
            return null;
        }
        if (inputs.length == 0 || repeatCount == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean idx = false;
        for (int i = 0; i < repeatCount; ++i) {
            for (String val : inputs) {
                buffer.append(val);
            }
        }
        return new HarmonySerialClob(buffer.toString());
    }

    public static int getCell(Blob blob, long idx) throws Exception {
        byte[] bytes = blob.getBytes(idx + 1L, 1);
        return bytes[0];
    }

    public static String getCell(Clob clob, long idx) throws Exception {
        return clob.getSubString(idx + 1L, 1);
    }

    public static Integer nop(Integer value) {
        return value;
    }

    public static int xmlX(String doc) throws Exception {
        int startIdx = doc.indexOf(BEGIN_HTML) + BEGIN_HTML.length();
        int endIdx = doc.indexOf(END_HTML);
        String number = doc.substring(startIdx, endIdx);
        return Integer.parseInt(number);
    }

    public static Connection getNestedConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    private String makeHashJoinMerge(String original) {
        return original.replace("2 *", " ");
    }

    private void enableSQLAuthorization() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        try (ResultSet rs = this.chattyPrepare(dboConnection, "values syscs_util.syscs_get_database_property( 'derby.database.sqlAuthorization' )").executeQuery();){
            if (rs.next() && "true".equals(rs.getString(1))) {
                return;
            }
        }
        this.goodStatement(dboConnection, "call syscs_util.syscs_set_database_property( 'derby.database.sqlAuthorization', 'true' )");
        this.bounceDatabase(TEST_DBO);
    }

    public static class Collated
    extends MergeStatementTest {
        public Collated(String name) {
            super(name);
        }

        @Override
        public String expectedCollation() {
            return "TERRITORY_BASED";
        }
    }
}

