/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class KillMaster
extends BaseJDBCTestCase {
    private static String masterJvmVersion = null;
    private static String derbyMasterVersion = null;
    private static String masterServerHost = null;
    private static int masterServerPort = -1;
    private static ReplicationRun repRun = new ReplicationRun("KillMaster");

    public KillMaster(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() throws Exception {
        System.out.println("**** KillMaster.suite()");
        System.out.println("'KillMaster' can not be run outside the 'ReplicationRun' framework.");
        BaseTestSuite suite = new BaseTestSuite("KillMaster");
        String masterHostName = System.getProperty("test.serverHost", "localhost");
        int masterPortNo = Integer.parseInt(System.getProperty("test.serverPort", "1527"));
        masterServerHost = masterHostName;
        masterServerPort = masterPortNo;
        repRun.initEnvironment();
        masterJvmVersion = ReplicationRun.masterJvmVersion;
        derbyMasterVersion = ReplicationRun.derbyMasterVersion;
        suite.addTest(KillMaster.suite(masterHostName, masterPortNo));
        return suite;
    }

    public static Test suite(String serverHost, int serverPort) throws IOException {
        System.out.println("*** KillMaster.replSuite(serverHost,serverPort)");
        Test t = TestConfiguration.existingServerSuite(KillMaster.class, false, serverHost, serverPort);
        System.out.println("*** Done TestConfiguration.defaultExistingServerSuite(KillMaster.class,false,serverHost,serverPort)");
        return t;
    }

    public void testKillMaster() throws Exception {
        Statement s;
        Connection conn;
        block3: {
            int i;
            System.out.println("**** KillMaster.testKillMaster() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName());
            conn = this.getConnection();
            s = conn.createStatement();
            s.executeUpdate("create table t (i integer primary key, vc varchar(20))");
            PreparedStatement pSt = this.prepareStatement("insert into t values (?,?)");
            try {
                for (i = 0; i < 1000; ++i) {
                    pSt.setInt(1, i);
                    pSt.setString(2, "i" + i);
                    pSt.execute();
                    System.out.println("i: " + i);
                    if (i != 500) continue;
                    repRun.killMaster(masterServerHost, masterServerPort);
                }
            }
            catch (SQLException se) {
                System.out.println("SQLException @ i=" + i + " (" + se.getMessage() + ")");
                if (i > 500) break block3;
                KillMaster.fail((String)("**** Unexpected SQLException @ i=" + i + " (" + se.getMessage() + ")"));
            }
        }
        conn.close();
        Thread.sleep(5000L);
        repRun.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, ReplicationRun.masterDbSubPath);
        conn = this.getConnection();
        s = conn.createStatement();
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
        System.out.println("count: " + count);
    }
}

