/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;

public class CryptoCrashRecoveryTest
extends BaseJDBCTestCase {
    private static boolean USE_ENC_PWD = true;
    private static boolean USE_ENC_KEY = false;
    private static final int OP_ENCRYPT = 0;
    private static final int OP_DECRYPT = 1;
    private static final int OP_REENCRYPT = 2;
    private static final String TEST_TABLE_NAME = "emp";
    private static final String OLD_PASSWORD = "xyz1234abc";
    private static final String NEW_PASSWORD = "new1234xyz";
    private static final String OLD_KEY = "6162636465666768";
    private static final String NEW_KEY = "5666768616263646";
    private static final String TEST_REENCRYPT_CRASH_BEFORE_COMMT = "TEST_REENCRYPT_CRASH_BEFORE_COMMT";
    private static final String TEST_REENCRYPT_CRASH_AFTER_COMMT = "TEST_REENCRYPT_CRASH_AFTER_COMMT";
    private static final String TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY = "TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY";
    private static final String TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT = "TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT";
    private static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE = "TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE";
    private static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY = "TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY";
    private static final String TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP = "TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP";

    public CryptoCrashRecoveryTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("CryptoCrashRecovery disabled due to non-debug build");
        CryptoCrashRecoveryTest.println("CryptoCrashRecoveryTest disabled due to non-debug build");
        return suite;
    }

    public void testDecryptionWithBootPassword() throws Exception {
        String db = "wombat_pwd_de";
        DataSource ds = JDBCDataSource.getDataSource(db);
        this.runCrashRecoveryTestCases(ds, 1, USE_ENC_PWD);
        CryptoCrashRecoveryTest.assertDirectoryDeleted(new File("system", db));
    }

    public void testDecryptionWithEncryptionKey() throws Exception {
        String db = "wombat_key_de";
        DataSource ds = JDBCDataSource.getDataSource(db);
        this.runCrashRecoveryTestCases(ds, 1, USE_ENC_KEY);
        CryptoCrashRecoveryTest.assertDirectoryDeleted(new File("system", db));
    }

    public void testEncryptionWithBootPassword() throws Exception {
        String db = "wombat_pwd_en";
        DataSource ds = JDBCDataSource.getDataSource(db);
        this.runCrashRecoveryTestCases(ds, 0, USE_ENC_PWD);
        CryptoCrashRecoveryTest.assertDirectoryDeleted(new File("system", db));
    }

    public void testEncryptionWithEncryptionKey() throws Exception {
        String db = "wombat_key_en";
        DataSource ds = JDBCDataSource.getDataSource(db);
        this.runCrashRecoveryTestCases(ds, 0, USE_ENC_KEY);
        CryptoCrashRecoveryTest.assertDirectoryDeleted(new File("system", db));
    }

    public void testReEncryptionWithBootPassword() throws Exception {
        String db = "wombat_pwd_ren";
        DataSource ds = JDBCDataSource.getDataSource(db);
        this.runCrashRecoveryTestCases(ds, 2, USE_ENC_PWD);
        CryptoCrashRecoveryTest.assertDirectoryDeleted(new File("system", db));
    }

    public void testReEncryptionWithEncryptionKey() throws Exception {
        String db = "wombat_key_ren";
        DataSource ds = JDBCDataSource.getDataSource(db);
        this.runCrashRecoveryTestCases(ds, 2, USE_ENC_KEY);
        CryptoCrashRecoveryTest.assertDirectoryDeleted(new File("system", db));
    }

    private void runCrashRecoveryTestCases(DataSource ds, int operation, boolean useEncPwd) throws SQLException {
        Connection con = null;
        switch (operation) {
            case 1: 
            case 2: {
                con = this.createEncryptedDatabase(ds, useEncPwd);
                break;
            }
            case 0: {
                con = this.createDatabase(ds);
                break;
            }
            default: {
                CryptoCrashRecoveryTest.fail((String)("unsupported operation: " + operation));
            }
        }
        this.createTable(con, TEST_TABLE_NAME);
        this.insert(con, TEST_TABLE_NAME, 100);
        con.commit();
        con.close();
        JDBCDataSource.shutdownDatabase(ds);
        Boolean useNewCredential = operation == 2 ? Boolean.FALSE : null;
        this.crash(ds, operation, useEncPwd, TEST_REENCRYPT_CRASH_BEFORE_COMMT);
        this.crash(ds, operation, useEncPwd, TEST_REENCRYPT_CRASH_AFTER_COMMT);
        this.crashInRecovery(ds, useEncPwd, useNewCredential, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE);
        this.crashInRecovery(ds, useEncPwd, useNewCredential, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY);
        this.crashInRecovery(ds, useEncPwd, useNewCredential, TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP);
        this.crash(ds, operation, useEncPwd, TEST_REENCRYPT_CRASH_AFTER_COMMT);
        this.crashInRecovery(ds, useEncPwd, useNewCredential, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE);
        this.crash(ds, operation, useEncPwd, TEST_REENCRYPT_CRASH_AFTER_COMMT);
        this.crash(ds, operation, useEncPwd, TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY);
        this.crashInRecovery(ds, useEncPwd, useNewCredential, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE);
        this.crashInRecovery(ds, useEncPwd, useNewCredential, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY);
        this.crashInRecovery(ds, useEncPwd, useNewCredential, TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP);
        this.crash(ds, operation, useEncPwd, TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY);
        this.crashInRecovery(ds, useEncPwd, useNewCredential, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY);
        this.crash(ds, operation, useEncPwd, TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY);
        this.crashInRecovery(ds, useEncPwd, useNewCredential, TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP);
        useNewCredential = operation == 2 ? Boolean.TRUE : Boolean.FALSE;
        this.crash(ds, operation, useEncPwd, TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT);
        this.crashInRecovery(ds, useEncPwd, useNewCredential, TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP);
        if (operation == 1) {
            useNewCredential = null;
        }
        this.recover(ds, useEncPwd, useNewCredential);
        JDBCDataSource.shutdownDatabase(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crash(DataSource ds, int operation, boolean useEncPwd, String debugFlag) {
        CryptoCrashRecoveryTest.println("Testing crash at " + debugFlag);
        this.setDebugFlag(debugFlag);
        try {
            switch (operation) {
                case 2: {
                    this.reEncryptDatabase(ds, useEncPwd);
                    break;
                }
                case 0: {
                    this.encryptDatabase(ds, useEncPwd);
                    break;
                }
                case 1: {
                    this.decryptDatabase(ds, useEncPwd);
                    break;
                }
                default: {
                    CryptoCrashRecoveryTest.fail((String)"unsupported operation");
                }
            }
            CryptoCrashRecoveryTest.fail((String)"crypto operation didn't crash as expected");
        }
        catch (SQLException sqle) {
            this.verifyBootException(sqle, debugFlag);
        }
        finally {
            this.clearDebugFlag(debugFlag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crashInRecovery(DataSource ds, boolean useEncPwd, Boolean useNewCredential, String debugFlag) throws SQLException {
        CryptoCrashRecoveryTest.println("Recovery crash at " + debugFlag);
        this.setDebugFlag(debugFlag);
        try {
            this.bootDatabase(ds, useEncPwd, useNewCredential);
            CryptoCrashRecoveryTest.fail((String)"database booted unexpectedly");
        }
        catch (SQLException sqle) {
            this.verifyBootException(sqle, debugFlag);
        }
        finally {
            this.clearDebugFlag(debugFlag);
        }
    }

    private void recover(DataSource ds, boolean useEncKey, Boolean useNewCredential) throws SQLException {
        Connection con = this.bootDatabase(ds, useEncKey, useNewCredential);
        this.runConsistencyChecker(con, TEST_TABLE_NAME);
        this.insert(con, TEST_TABLE_NAME, 100);
        con.commit();
        con.close();
    }

    private void setDebugFlag(String debugFlag) {
    }

    private void clearDebugFlag(String debugFlag) {
    }

    private void verifyBootException(SQLException sqle, String debugFlag) {
        CryptoCrashRecoveryTest.assertSQLState("XJ040", sqle);
        for (SQLException ne = sqle.getNextException(); ne != null; ne = ne.getNextException()) {
            String message = ne.getMessage();
            if (message.indexOf(debugFlag) == -1) continue;
            return;
        }
        CryptoCrashRecoveryTest.fail("real error or wrong debug flag triggered crash", sqle);
    }

    private void createTable(Connection con, String tableName) throws SQLException {
        Statement s = con.createStatement();
        s.executeUpdate("CREATE TABLE " + tableName + "(id INT," + "name VARCHAR(200))");
        s.executeUpdate("create index " + tableName + "_id_idx on " + tableName + "(id)");
        s.close();
    }

    private void runConsistencyChecker(Connection con, String tableName) throws SQLException {
        Statement stmt = con.createStatement();
        stmt.execute("values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP',  'EMP')");
        this.verifyContents(con, tableName);
    }

    private void insert(Connection con, String tableName, int rowCount) throws SQLException {
        PreparedStatement ps = con.prepareStatement("INSERT INTO " + tableName + " VALUES(?,?)");
        int startId = this.findMaxId(con, tableName);
        int endId = rowCount + startId;
        for (int i = startId; i < endId; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "skywalker" + i);
            ps.executeUpdate();
        }
        ps.close();
        con.commit();
    }

    private int findMaxId(Connection con, String tableName) throws SQLException {
        Statement s = con.createStatement();
        ResultSet rs = s.executeQuery("SELECT max(ID) from " + tableName);
        CryptoCrashRecoveryTest.assertTrue((boolean)rs.next());
        int max = rs.getInt(1);
        rs.close();
        s.close();
        return max;
    }

    private void verifyContents(Connection con, String tableName) throws SQLException {
        Statement s = con.createStatement();
        ResultSet rs = s.executeQuery("SELECT ID, name from " + tableName + " order by id");
        int count = 0;
        int id = 0;
        while (rs.next()) {
            int tid = rs.getInt(1);
            String name = rs.getString(2);
            CryptoCrashRecoveryTest.assertEquals((String)("skywalker" + id), (String)name);
            CryptoCrashRecoveryTest.assertEquals((int)id, (int)tid);
            ++id;
            ++count;
        }
        rs.close();
        s.close();
        con.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection createEncryptedDatabase(DataSource ds, boolean useEncPwd) throws SQLException {
        String connAttrs = "dataEncryption=true;";
        connAttrs = useEncPwd ? connAttrs + "bootPassword=xyz1234abc" : connAttrs + "encryptionKey=6162636465666768";
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", connAttrs);
        try {
            Connection connection = ds.getConnection();
            return connection;
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(ds, "createDatabase");
            JDBCDataSource.clearStringBeanProperty(ds, "connectionAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection createDatabase(DataSource ds) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        try {
            Connection con = ds.getConnection();
            JDBC.assertNoWarnings(con.getWarnings());
            Connection connection = con;
            return connection;
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(ds, "createDatabase");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection reEncryptDatabase(DataSource ds, boolean useEncPwd) throws SQLException {
        String connAttrs = useEncPwd ? "bootPassword=xyz1234abc;newBootPassword=new1234xyz" : "encryptionKey=6162636465666768;newEncryptionKey=5666768616263646";
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", connAttrs);
        CryptoCrashRecoveryTest.println("re-encrypting " + CryptoCrashRecoveryTest.db(ds) + " with " + connAttrs);
        try {
            Connection connection = ds.getConnection();
            return connection;
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(ds, "connectionAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection encryptDatabase(DataSource ds, boolean useEncPwd) throws SQLException {
        String connAttrs = "dataEncryption=true;";
        connAttrs = useEncPwd ? connAttrs + "bootPassword=xyz1234abc" : connAttrs + "encryptionKey=6162636465666768";
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", connAttrs);
        CryptoCrashRecoveryTest.println("encrypting " + CryptoCrashRecoveryTest.db(ds) + " with " + connAttrs);
        try {
            Connection connection = ds.getConnection();
            return connection;
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(ds, "connectionAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection decryptDatabase(DataSource ds, boolean useEncPwd) throws SQLException {
        String connAttrs = "decryptDatabase=true;";
        connAttrs = useEncPwd ? connAttrs + "bootPassword=xyz1234abc" : connAttrs + "encryptionKey=6162636465666768";
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", connAttrs);
        CryptoCrashRecoveryTest.println("decrypting " + CryptoCrashRecoveryTest.db(ds) + " with " + connAttrs);
        try {
            Connection connection = ds.getConnection();
            return connection;
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(ds, "connectionAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection bootDatabase(DataSource ds, boolean useEncPwd, Boolean useNewCredential) throws SQLException {
        String connAttrs = "";
        if (useEncPwd) {
            if (Boolean.TRUE.equals(useNewCredential)) {
                connAttrs = "bootPassword=new1234xyz";
            } else if (Boolean.FALSE.equals(useNewCredential)) {
                connAttrs = "bootPassword=xyz1234abc";
            }
        } else if (Boolean.TRUE.equals(useNewCredential)) {
            connAttrs = "encryptionKey=5666768616263646";
        } else if (Boolean.FALSE.equals(useNewCredential)) {
            connAttrs = "encryptionKey=6162636465666768";
        }
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", connAttrs);
        CryptoCrashRecoveryTest.println("booting " + CryptoCrashRecoveryTest.db(ds) + (connAttrs.length() > 0 ? " with " + connAttrs : ""));
        try {
            Connection connection = ds.getConnection();
            return connection;
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(ds, "connectionAttributes");
        }
    }

    private static String db(DataSource ds) {
        try {
            return (String)JDBCDataSource.getBeanProperty(ds, "databaseName");
        }
        catch (Exception e) {
            return "<unknown/error>";
        }
    }
}

