/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OCRecoveryTest
extends BaseJDBCTestCase {
    private static final String tableName = "RECTEST1";

    public OCRecoveryTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("OCRecoveryTest");
        if (BaseTestCase.isJ9Platform()) {
            return suite;
        }
        suite.addTest(OCRecoveryTest.decorateTest());
        return suite;
    }

    private static Test decorateTest() {
        Test test = TestConfiguration.embeddedSuite(OCRecoveryTest.class);
        return TestConfiguration.singleUseDatabaseDecorator(test, "OCRecoveryDB");
    }

    public void testOCRecovery() throws Exception {
        OCRecoveryTest.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.store.OCRecoveryTest.launchOCRecovery_1", "OCRecoveryDB");
        OCRecoveryTest.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.store.OCRecoveryTest.launchOCRecovery_2", "OCRecoveryDB");
        OCRecoveryTest.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.store.OCRecoveryTest.launchOCRecovery_3", "OCRecoveryDB");
        OCRecoveryTest.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.store.OCRecoveryTest.launchOCRecovery_4", "OCRecoveryDB");
    }

    public void launchOCRecovery_1() throws Exception {
        this.getConnection();
        this.setAutoCommit(false);
        this.createAndLoadTable(tableName, true, 5000, 0);
        Statement st = this.createStatement();
        st.executeUpdate("DELETE FROM RECTEST1");
        this.commit();
        this.callCompress(tableName, true, true, true, true);
        st.close();
    }

    public void launchOCRecovery_2() throws Exception {
        this.setAutoCommit(false);
        this.assertCheckTable(tableName);
        this.createAndLoadTable(tableName, false, 6000, 0);
        this.assertCheckTable(tableName);
        String table_name = "RECTEST1_2";
        this.createAndLoadTable(table_name, true, 2000, 0);
        Statement st = this.createStatement();
        st.executeUpdate("DELETE FROM RECTEST1");
        this.commit();
        this.callCompress(tableName, true, true, true, true);
        st.close();
    }

    public void launchOCRecovery_3() throws SQLException {
        this.setAutoCommit(false);
        String table_name = "RECTEST1_2";
        this.assertCheckTable(table_name);
        this.createAndLoadTable(tableName, false, 2000, 0);
        this.assertCheckTable(tableName);
        this.createAndLoadTable(table_name, false, 4000, 2000);
        Statement st = this.createStatement();
        st.executeUpdate("DELETE FROM " + table_name);
        this.commit();
        this.callCompress(table_name, true, true, true, false);
        st.close();
    }

    public void launchOCRecovery_4() throws SQLException {
        this.setAutoCommit(false);
        String table_name = "RECTEST1_2";
        this.assertCheckTable(table_name);
        this.createAndLoadTable(table_name, false, 6000, 0);
        this.assertCheckTable(table_name);
    }

    private void createAndLoadTable(String tblname, boolean create_table, int num_rows, int start_value) throws SQLException {
        if (create_table) {
            Statement s = this.createStatement();
            s.execute("CREATE TABLE " + tblname + "(keycol int, indcol1 int, indcol2 int, indcol3 int, " + "data1 varchar(2000), data2 varchar(2000))");
            s.close();
            OCRecoveryTest.println("table created: " + tblname);
        }
        PreparedStatement insert_stmt = this.prepareStatement("INSERT INTO " + tblname + " VALUES(?, ?, ?, ?, ?, ?)");
        char[] data1_data = new char[500];
        char[] data2_data = new char[500];
        for (int i = 0; i < data1_data.length; ++i) {
            data1_data[i] = 97;
            data2_data[i] = 98;
        }
        String data1_str = new String(data1_data);
        String data2_str = new String(data2_data);
        int row_count = 0;
        int i = start_value;
        while (row_count < num_rows) {
            insert_stmt.setInt(1, i);
            insert_stmt.setInt(2, i * 10);
            insert_stmt.setInt(3, i * 100);
            insert_stmt.setInt(4, -i);
            insert_stmt.setString(5, data1_str);
            insert_stmt.setString(6, data2_str);
            insert_stmt.execute();
            ++row_count;
            ++i;
        }
        if (create_table) {
            Statement s = this.createStatement();
            s.execute("create index " + tblname + "_idx_keycol on " + tblname + "(keycol)");
            s.execute("create index " + tblname + "_idx_indcol1 on " + tblname + "(indcol1)");
            s.execute("create index " + tblname + "_idx_indcol2 on " + tblname + "(indcol2)");
            s.execute("create unique index " + tblname + "_idx_indcol3 on " + tblname + "(indcol3)");
            s.close();
        }
        this.commit();
    }

    private void callCompress(String tableName, boolean purgeRows, boolean defragmentRows, boolean truncateEnd, boolean commit_operation) throws SQLException {
        CallableStatement cstmt = this.prepareCall("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, ?, ?, ?)");
        cstmt.setString(1, this.getTestConfiguration().getUserName());
        cstmt.setString(2, tableName);
        cstmt.setInt(3, purgeRows ? 1 : 0);
        cstmt.setInt(4, defragmentRows ? 1 : 0);
        cstmt.setInt(5, truncateEnd ? 1 : 0);
        cstmt.execute();
        if (commit_operation) {
            this.commit();
        }
    }
}

