/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.store.OnlineBackup;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class OnlineBackupTest1 {
    private static final String TEST_DATABASE_NAME = "wombat";
    private static final String TEST_TABLE_NAME = "emp";
    private static final String TEST_TABLE_NAME_1 = "emp_1";
    private static final String TEST_TABLE_NAME_2 = "emp_2";
    private static final String BACKUP_PATH = "extinout/onlinebackuptest1";

    public static void main(String[] argv) throws Throwable {
        OnlineBackupTest1 test = new OnlineBackupTest1();
        ij.getPropertyArg((String[])argv);
        try {
            test.runTest();
        }
        catch (SQLException sqle) {
            OnlineBackupTest1.dumpSQLException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest() throws Exception {
        this.logMessage("Begin Online Backup Test1");
        Connection conn = ij.startJBMS();
        conn.setAutoCommit(false);
        DatabaseActions dbActions = new DatabaseActions(conn);
        dbActions.createTable(TEST_TABLE_NAME);
        dbActions.createTable(TEST_TABLE_NAME_1);
        dbActions.createTable(TEST_TABLE_NAME_2);
        conn.commit();
        dbActions.startUnloggedAction(TEST_TABLE_NAME_1);
        this.logMessage("First Transaction with Unlogged Operation Started");
        Connection conn1 = ij.startJBMS();
        conn1.setAutoCommit(false);
        DatabaseActions dbActions1 = new DatabaseActions(conn1);
        dbActions1.startUnloggedAction(TEST_TABLE_NAME_2);
        this.logMessage("Second Transaction with Unlogged Operation Started");
        OnlineBackup backup = new OnlineBackup(TEST_DATABASE_NAME, BACKUP_PATH);
        Thread backupThread = new Thread((Runnable)backup, "BACKUP");
        Connection dmlConn = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        DatabaseActions dmlActions = new DatabaseActions(1, dmlConn);
        Thread dmlThread = new Thread((Runnable)dmlActions, "DML_THREAD");
        Connection ddlConn = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        DatabaseActions ddlActions = new DatabaseActions(2, ddlConn);
        Thread ddlThread = new Thread((Runnable)ddlActions, "DDL_THREAD");
        try {
            backupThread.start();
            backup.waitForBackupToBegin();
            this.logMessage("BACKUP STARTED");
            dmlThread.start();
            ddlThread.start();
            Thread.sleep(50000L);
            if (!backup.isRunning()) {
                this.logMessage("Backup is not waiting for unlogged actions to commit");
            }
            dbActions.endUnloggedAction(TEST_TABLE_NAME_1);
            dbActions1.endUnloggedAction(TEST_TABLE_NAME_2);
            backup.waitForBackupToEnd();
        }
        finally {
            backupThread.join();
            dmlActions.stopActivity();
            ddlActions.stopActivity();
            dmlThread.join();
            ddlThread.join();
        }
        conn.close();
        conn1.close();
        dmlConn.close();
        ddlConn.close();
        this.shutdown(TEST_DATABASE_NAME);
        backup.restoreFromBackup();
        this.logMessage("Restored From the Backup");
        this.runConsistencyChecker(TEST_DATABASE_NAME);
        this.logMessage("Consistency Check is Done");
        this.shutdown(TEST_DATABASE_NAME);
        this.logMessage("End Online Backup Test1");
    }

    void runConsistencyChecker(String dbName) throws SQLException {
        Connection conn = TestUtil.getConnection(dbName, null);
        Statement stmt = conn.createStatement();
        stmt.execute("values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP',  'EMP')");
        DatabaseActions dbActions = new DatabaseActions(conn);
        dbActions.select(TEST_TABLE_NAME);
        dbActions.select(TEST_TABLE_NAME_1);
        dbActions.select(TEST_TABLE_NAME_2);
        conn.close();
    }

    void shutdown(String dbName) {
        try {
            TestUtil.getConnection(dbName, "shutdown=true");
        }
        catch (SQLException se) {
            if (se.getSQLState() != null && se.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            }
            OnlineBackupTest1.dumpSQLException(se);
        }
    }

    void logMessage(String str) {
        System.out.println(str);
    }

    private static void dumpSQLException(SQLException sqle) {
        JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
        sqle.printStackTrace(System.out);
    }

    class DatabaseActions
    implements Runnable {
        public static final int DMLACTIONS = 1;
        public static final int CREATEDROPS = 2;
        private static final int COMMIT = 1;
        private static final int ROLLBACK = 2;
        private static final int OPENTX = 3;
        private int action = 0;
        private volatile boolean stopActivity = false;
        private Connection conn;

        DatabaseActions(Connection conn) {
            this.conn = conn;
        }

        DatabaseActions(int action, Connection conn) {
            this.action = action;
            this.conn = conn;
        }

        public void stopActivity() {
            this.stopActivity = true;
        }

        @Override
        public void run() {
            try {
                this.conn.setAutoCommit(false);
                switch (this.action) {
                    case 1: {
                        this.performDmlActions();
                        break;
                    }
                    case 2: {
                        this.performCreateDropTables();
                    }
                }
            }
            catch (SQLException sqle) {
                JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
                sqle.printStackTrace(System.out);
            }
        }

        void performDmlActions() throws SQLException {
            while (!this.stopActivity) {
                this.insert(OnlineBackupTest1.TEST_TABLE_NAME, 100, 1, 10);
                this.insert(OnlineBackupTest1.TEST_TABLE_NAME, 100, 2, 10);
                this.update(OnlineBackupTest1.TEST_TABLE_NAME, 50, 2, 10);
                this.select(OnlineBackupTest1.TEST_TABLE_NAME);
            }
        }

        void startUnloggedAction(String tableName) throws SQLException {
            this.insert(tableName, 100, 1, 10);
            Statement s = this.conn.createStatement();
            s.executeUpdate("create index " + tableName + "_name_idx on " + tableName + "(name) ");
            s.close();
        }

        void endUnloggedAction(String tableName) throws SQLException {
            this.insert(tableName, 1000, 3, 10);
            this.conn.commit();
        }

        void performCreateDropTables() throws SQLException {
            Statement s = this.conn.createStatement();
            while (!this.stopActivity) {
                String tableName;
                int i;
                for (i = 0; i < 10; ++i) {
                    tableName = OnlineBackupTest1.TEST_TABLE_NAME + i;
                    this.createTable(tableName);
                    this.insert(tableName, 100, 3, 10);
                    if (i % 2 == 0) {
                        this.conn.commit();
                        continue;
                    }
                    this.conn.rollback();
                }
                for (i = 0; i < 10; i += 2) {
                    tableName = OnlineBackupTest1.TEST_TABLE_NAME + i;
                    s.executeUpdate("drop TABLE emp" + i);
                    this.conn.commit();
                }
            }
            s.close();
        }

        void insert(String tableName, int rowCount, int txStatus, int commitCount) throws SQLException {
            PreparedStatement ps = this.conn.prepareStatement("INSERT INTO " + tableName + " VALUES(?,?,?)");
            for (int i = 0; i < rowCount; ++i) {
                ps.setInt(1, i);
                ps.setString(2, "skywalker" + i);
                ps.setFloat(3, i * 2000);
                ps.executeUpdate();
                if (i % commitCount != 0) continue;
                this.endTransaction(txStatus);
            }
            this.endTransaction(txStatus);
            ps.close();
        }

        void endTransaction(int txStatus) throws SQLException {
            switch (txStatus) {
                case 1: {
                    this.conn.commit();
                    break;
                }
                case 2: {
                    this.conn.rollback();
                    break;
                }
            }
        }

        void update(String tableName, int rowCount, int txStatus, int commitCount) throws SQLException {
            PreparedStatement ps = this.conn.prepareStatement("update " + tableName + " SET name = ?  where id=?");
            for (int i = 0; i < rowCount; ++i) {
                ps.setString(1, "moonwalker" + i);
                ps.setInt(2, i);
                ps.executeUpdate();
                if (i % commitCount != 0) continue;
                this.endTransaction(txStatus);
            }
            this.endTransaction(txStatus);
            ps.close();
        }

        void select(String tableName) throws SQLException {
            Statement s = this.conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT ID, name from " + tableName + " order by id");
            int count = 0;
            int id = 0;
            while (rs.next()) {
                int tid = rs.getInt(1);
                String name = rs.getString(2);
                if (name.equals("skywalker" + id) && tid != id) {
                    OnlineBackupTest1.this.logMessage("DATA IN THE TABLE IS NOT AS EXPECTED");
                    OnlineBackupTest1.this.logMessage("Got :ID=" + tid + " Name=:" + name);
                    OnlineBackupTest1.this.logMessage("Expected: ID=" + id + "Name=" + "skywalker" + id);
                }
                ++id;
                ++count;
            }
            rs.close();
            s.close();
            this.conn.commit();
        }

        void createTable(String tableName) throws SQLException {
            Statement s = this.conn.createStatement();
            s.executeUpdate("CREATE TABLE " + tableName + "(id INT," + "name CHAR(200)," + "salary float)");
            s.executeUpdate("create index " + tableName + "_id_idx on " + tableName + "(id)");
            s.close();
        }
    }
}

