/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.TestUtil;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StreamingColumnTest
extends BaseJDBCTestCase {
    public static final int DB2_LONGVARCHAR_MAXWIDTH = 32700;
    public static final int DB2_VARCHAR_MAXWIDTH = 32672;
    static String[] fileName;
    static long[] fileLength;
    private static final int LONGVARCHAR = 1;
    private static final int CLOB = 2;
    private static final int VARCHAR = 3;

    public StreamingColumnTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStream1() throws Exception {
        String resultString;
        InputStream fin;
        Statement stmt = this.createStatement();
        for (int i = 0; i < fileName.length; ++i) {
            File file = new File(fileName[i]);
            StreamingColumnTest.fileLength[i] = PrivilegedFileOpsForTests.length(file);
            FileInputStream fileIn = PrivilegedFileOpsForTests.getFileInputStream(file);
            StreamingColumnTest.println("===>  testing " + fileName[i] + " with length = " + fileLength[i]);
            PreparedStatement ps = this.prepareStatement("insert into testLongVarChar1 values(?, ?)");
            ps.setInt(1, 100 + i);
            ps.setAsciiStream(2, (InputStream)fileIn, (int)fileLength[i]);
            try {
                ps.executeUpdate();
                if (32700L < fileLength[i]) {
                    StreamingColumnTest.fail((String)"Attempting to insert data longer than 32700 should have thrownan exception.");
                }
                StreamingColumnTest.println("No truncation and hence no error");
                continue;
            }
            catch (SQLException e) {
                if (fileLength[i] > 32700L) {
                    if (i == 2 && StreamingColumnTest.usingDerbyNetClient()) {
                        StreamingColumnTest.assertSQLState("XJ001", e);
                    } else {
                        StreamingColumnTest.assertSQLState("22001", e);
                    }
                    StreamingColumnTest.println("expected exception for data > 32700 in length");
                    continue;
                }
                throw e;
            }
            finally {
                ((InputStream)fileIn).close();
            }
        }
        ResultSet rs = stmt.executeQuery("select a, b from testLongVarChar1");
        byte[] buff = new byte[128];
        while (rs.next()) {
            int size;
            int a = rs.getInt("a");
            fin = rs.getAsciiStream(2);
            int columnSize = 0;
            while ((size = fin.read(buff)) != -1) {
                columnSize += size;
            }
            this.verifyLength(a, columnSize, fileLength);
        }
        rs = stmt.executeQuery("select a, b from testLongVarChar1 order by a");
        rs.getMetaData();
        while (rs.next()) {
            int size;
            int a = rs.getInt("a");
            fin = rs.getAsciiStream(2);
            int columnSize = 0;
            while ((size = fin.read(buff)) != -1) {
                columnSize += size;
            }
            this.verifyLength(a, columnSize, fileLength);
        }
        rs = stmt.executeQuery("select a, b from testLongVarChar1");
        while (rs.next()) {
            int a = rs.getInt("a");
            resultString = rs.getString(2);
            this.verifyLength(a, resultString.length(), fileLength);
        }
        rs = stmt.executeQuery("select a, b from testLongVarChar1 order by a");
        while (rs.next()) {
            int a = rs.getInt("a");
            resultString = rs.getString(2);
            this.verifyLength(a, resultString.length(), fileLength);
        }
        rs = stmt.executeQuery("select a, b from testLongVarChar1 where b like 'test data: a string column inserted as an object'");
        while (rs.next()) {
            int a = rs.getInt("a");
            resultString = rs.getString(2);
            this.verifyLength(a, resultString.length(), fileLength);
        }
        this.insertLongString(10, "ssssssssss", false, "foo1");
        this.insertLongString(0, "", false, "foo1");
        this.insertLongString(1, "1", false, "foo1");
        this.insertLongString(-1, null, false, "foo1");
        this.insertLongString(20, "XXXXXXXXXXXXXXXXXXXX", false, "foo1");
        rs = stmt.executeQuery("select a, b from foo1");
        StreamingColumnTest.println("Expect to get null string back");
        while (rs.next()) {
            int a = rs.getInt("a");
            resultString = rs.getString(2);
            StreamingColumnTest.assertEquals((String)("FAIL - failed to get string back, expect " + a + " got " + (resultString == null ? "null resultString" : "" + resultString.length())), (int)a, (int)(resultString == null ? -1 : resultString.length()));
        }
        this.updateLongString(1, 3000, "foo1");
        this.updateLongString(0, 800, "foo1");
        this.updateLongString(3000, 0, "foo1");
        this.updateLongString(0, 51, "foo1");
        this.updateLongString(20, 0, "foo1");
        rs = stmt.executeQuery("select a, b from foo1");
        while (rs.next()) {
            int a = rs.getInt("a");
            resultString = rs.getString(2);
            StreamingColumnTest.assertEquals((String)("FAIL - failed to get string back, expect " + a + " got " + (resultString == null ? "null resultString" : "" + resultString.length())), (int)a, (int)(resultString == null ? -1 : resultString.length()));
        }
        rs.close();
        stmt.close();
    }

    public void testStream2_1500() throws Exception {
        long length = 1500L;
        this.streamTest2(length, "foo2_1500");
    }

    public void testStream2_5000() throws Exception {
        long length = 5000L;
        this.streamTest2(length, "foo2_5000");
    }

    public void testStream2_10000() throws Exception {
        long length = 10000L;
        this.streamTest2(length, "foo2_10000");
    }

    private void streamTest2(long length, String tableName) throws Exception {
        Statement sourceStmt = this.createStatement();
        this.insertLongString(1, StreamingColumnTest.pad("Broadway", length), false, tableName);
        this.insertLongString(2, StreamingColumnTest.pad("Franklin", length), false, tableName);
        this.insertLongString(3, StreamingColumnTest.pad("Webster", length), false, tableName);
        sourceStmt.executeUpdate("insert into " + tableName + " select a+100, " + "b from " + tableName);
        this.verifyExistence(1, "Broadway", length, tableName);
        this.verifyExistence(2, "Franklin", length, tableName);
        this.verifyExistence(3, "Webster", length, tableName);
        this.verifyExistence(101, "Broadway", length, tableName);
        this.verifyExistence(102, "Franklin", length, tableName);
        this.verifyExistence(103, "Webster", length, tableName);
    }

    public void testStream3_0() throws Exception {
        long length = 0L;
        String tableName = "foo3_0";
        this.streamTest3(0L, "foo3_0");
    }

    public void testStream3_1500() throws Exception {
        long length = 1500L;
        String tableName = "foo3_1500";
        this.streamTest3(1500L, "foo3_1500");
    }

    public void testStream3_5000() throws Exception {
        long length = 5000L;
        String tableName = "foo3_5000";
        this.streamTest3(5000L, "foo3_5000");
    }

    public void testStream3_10000() throws Exception {
        long length = 10000L;
        String tableName = "foo3_10000";
        this.streamTest3(10000L, "foo3_10000");
    }

    private void streamTest3(long length, String tableName) throws Exception {
        this.insertLongString(1, StreamingColumnTest.pad("Broadway", length), false, tableName);
        this.insertLongString(2, StreamingColumnTest.pad("Franklin", length), false, tableName);
        this.insertLongString(3, StreamingColumnTest.pad("Webster", length), false, tableName);
        PreparedStatement ps = this.prepareStatement("update " + tableName + " set " + "a=a+1000, b=? where a<99 and a in (select a from " + tableName + ")");
        File file = new File("extin/short.data");
        FileInputStream fileIn = PrivilegedFileOpsForTests.getFileInputStream(file);
        ps.setAsciiStream(1, (InputStream)fileIn, (int)PrivilegedFileOpsForTests.length(file));
        ps.executeUpdate();
        ((InputStream)fileIn).close();
        ps = this.prepareStatement("update " + tableName + " set a=a+1000, b=? where a<99 and a " + "in (select a from " + tableName + ")");
        file = new File("extin/shortbanner");
        fileIn = PrivilegedFileOpsForTests.getFileInputStream(file);
        ps.setAsciiStream(1, (InputStream)fileIn, (int)PrivilegedFileOpsForTests.length(file));
        ps.executeUpdate();
        ((InputStream)fileIn).close();
    }

    public void testStream4() throws Exception {
        String resultString;
        int size;
        InputStream fin;
        Statement stmt = this.createStatement();
        stmt.execute("insert into testLongVarBinary4 values(1, CAST (" + TestUtil.stringToHexLiteral("") + "AS BLOB(1G)))");
        stmt.execute("insert into testLongVarBinary4 values(2,CAST (" + TestUtil.stringToHexLiteral("test data: a string column inserted as an object") + "AS BLOB(1G)))");
        for (int i = 0; i < fileName.length; ++i) {
            File file = new File(fileName[i]);
            StreamingColumnTest.fileLength[i] = PrivilegedFileOpsForTests.length(file);
            FileInputStream fileIn = PrivilegedFileOpsForTests.getFileInputStream(file);
            StreamingColumnTest.println("Testing with " + fileName[i] + " length = " + fileLength[i]);
            PreparedStatement ps = this.prepareStatement("insert into testLongVarBinary4 values(?, ?)");
            ps.setInt(1, 100 + i);
            ps.setBinaryStream(2, (InputStream)fileIn, (int)fileLength[i]);
            ps.executeUpdate();
            ((InputStream)fileIn).close();
        }
        ResultSet rs = stmt.executeQuery("select a, b from testLongVarBinary4");
        rs.getMetaData();
        byte[] buff = new byte[128];
        while (rs.next()) {
            int a = rs.getInt("a");
            fin = rs.getBinaryStream(2);
            int columnSize = 0;
            while ((size = fin.read(buff, 0, 100)) != -1) {
                columnSize += size;
            }
            this.verifyLength(a, columnSize, fileLength);
        }
        rs = stmt.executeQuery("select a, b from testLongVarBinary4 order by a");
        rs.getMetaData();
        while (rs.next()) {
            int a = rs.getInt("a");
            fin = rs.getBinaryStream(2);
            int columnSize = 0;
            while ((size = fin.read(buff)) != -1) {
                columnSize += size;
            }
            this.verifyLength(a, columnSize, fileLength);
        }
        rs = stmt.executeQuery("select a, b from testLongVarBinary4");
        while (rs.next()) {
            int a = rs.getInt("a");
            resultString = rs.getString(2);
            this.verifyLength(a, resultString.length() / 2, fileLength);
        }
        rs = stmt.executeQuery("select a, b from testLongVarBinary4 order by a");
        while (rs.next()) {
            int a = rs.getInt("a");
            resultString = rs.getString(2);
            StreamingColumnTest.println(resultString);
            this.verifyLength(a, resultString.length() / 2, fileLength);
        }
        rs.close();
        stmt.close();
    }

    public void testStream5_0() throws Exception {
        long length = 0L;
        String tableName = "foo5_0";
        this.streamTest5(0L, "foo5_0");
    }

    public void testStream5_1500() throws Exception {
        long length = 1500L;
        String tableName = "foo5_1500";
        this.streamTest5(1500L, "foo5_1500");
    }

    public void testStream5_5000() throws Exception {
        long length = 5000L;
        String tableName = "foo5_5000";
        this.streamTest5(5000L, "foo5_5000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamTest5(long length, String tableName) throws Exception {
        try (InputStream fileIn = null;){
            this.insertLongString(1, StreamingColumnTest.pad("Broadway", length), true, tableName);
            this.insertLongString(2, StreamingColumnTest.pad("Franklin", length), true, tableName);
            this.insertLongString(3, StreamingColumnTest.pad("Webster", length), true, tableName);
            this.insertLongString(4, StreamingColumnTest.pad("Broadway", length), true, tableName);
            this.insertLongString(5, StreamingColumnTest.pad("Franklin", length), true, tableName);
            this.insertLongString(6, StreamingColumnTest.pad("Webster", length), true, tableName);
            PreparedStatement ps = this.prepareStatement("update " + tableName + " set a=a+1000, " + "b=? where a<99 and a in (select a from " + tableName + ")");
            File file = new File("extin/short.data");
            fileIn = PrivilegedFileOpsForTests.getFileInputStream(file);
            ps.setBinaryStream(1, fileIn, (int)PrivilegedFileOpsForTests.length(file));
            ps.executeUpdate();
            fileIn.close();
            ps = this.prepareStatement("update " + tableName + " set a=a+1000, b=? where a<99 " + "and a in (select a from " + tableName + ")");
            file = new File("extin/shortbanner");
            fileIn = PrivilegedFileOpsForTests.getFileInputStream(file);
            ps.setBinaryStream(1, fileIn, (int)PrivilegedFileOpsForTests.length(file));
            ps.executeUpdate();
            ps.close();
        }
    }

    public void testStream6() throws Exception {
        long length = 5000L;
        String tableName = "foo_6";
        Statement sourceStmt = this.createStatement();
        this.insertLongString(1, StreamingColumnTest.pad("Broadway", 5000L), false, "foo_6");
        this.insertLongString(2, StreamingColumnTest.pad("Franklin", 5000L), false, "foo_6");
        this.insertLongString(3, StreamingColumnTest.pad("Webster", 5000L), false, "foo_6");
        PreparedStatement ps = this.prepareStatement("update foo_6 set a=a+1000, b=? where a<99 and a in (select a from foo_6)");
        StreamingColumnTest.streamInLongCol(ps, StreamingColumnTest.pad("Grand", 5000L));
        ps.close();
        sourceStmt.close();
    }

    public void testStream7() throws Exception {
        this.setAutoCommit(false);
        StreamingColumnTest.println("streamTest7");
        PreparedStatement ps1 = this.prepareStatement("insert into testlvc7 values (?, 'filler for column b on null column', null, 'filler for column d')");
        PreparedStatement ps2 = this.prepareStatement("insert into testlvc7 values (?, 'filler for column b on empty string column', ?, 'filler2 for column d')");
        for (int i = 0; i < 100; ++i) {
            ps1.setInt(1, i);
            ps1.executeUpdate();
            ByteArrayInputStream emptyString = new ByteArrayInputStream(new byte[0]);
            ps2.setInt(1, i);
            ps2.setAsciiStream(2, (InputStream)emptyString, 0);
            ps2.executeUpdate();
        }
        ps1.close();
        ps2.close();
        this.commit();
        PreparedStatement ps = this.prepareStatement("update testlvc7 set lvc = ? where a = ?");
        String longString = "this is a relatively long string, hopefully the row will be split or otherwise become long ???  I don't think it will become long but maybe if it rolls back it will become strange";
        for (int i = 0; i < 100; ++i) {
            ByteArrayInputStream string1 = new ByteArrayInputStream(longString.getBytes("US-ASCII"));
            ps.setAsciiStream(1, (InputStream)string1, longString.length());
            ps.setInt(2, i);
            ps.executeUpdate();
            if (i % 2 == 0) {
                this.rollback();
            } else {
                this.commit();
            }
            ByteArrayInputStream emptyString = new ByteArrayInputStream(new byte[0]);
            ps.setAsciiStream(1, (InputStream)emptyString, 0);
            ps.executeUpdate();
            if (i % 3 == 0) {
                this.rollback();
                continue;
            }
            this.commit();
        }
        ps.close();
    }

    public void testStream8_10_2500() throws Exception {
        int stream1_len = 10;
        int stream2_len = 2500;
        String tableName = "t8_10_2500";
        StreamingColumnTest.println("Starting testStream8_10_2500(" + stream1_len + ", " + stream2_len + ")");
        this.streamTest8(stream1_len, stream2_len, tableName);
        StreamingColumnTest.println("Finishing testStream8_10_2500(" + stream1_len + ", " + stream2_len + ")");
    }

    public void testStream8_2500_10() throws Exception {
        int stream1_len = 2500;
        int stream2_len = 10;
        String tableName = "t8_2500_10";
        StreamingColumnTest.println("Starting streamTest8_2500_10(" + stream1_len + ", " + stream2_len + ")");
        this.streamTest8(stream1_len, stream2_len, tableName);
        StreamingColumnTest.println("Finishing streamTest8_2500_10(" + stream1_len + ", " + stream2_len + ")");
    }

    private void streamTest8(int stream1_len, int stream2_len, String tableName) throws Exception {
        StreamingColumnTest.println("Starting streamTest8(" + stream1_len + ", " + stream2_len + ")");
        String insertsql = new String("insert into " + tableName + " values (?, ?, ?) ");
        int numStrings = 10;
        byte[][] stream1_byte_array = new byte[numStrings][];
        byte[][] stream2_byte_array = new byte[numStrings][];
        for (int i = 0; i < numStrings; ++i) {
            int j;
            stream1_byte_array[i] = new byte[stream1_len];
            for (j = 0; j < stream1_len; ++j) {
                stream1_byte_array[i][j] = (byte)(97 + i);
            }
            stream2_byte_array[i] = new byte[stream2_len];
            for (j = 0; j < stream2_len; ++j) {
                stream2_byte_array[i][j] = (byte)(65 + i);
            }
        }
        this.setAutoCommit(false);
        Statement stmt = this.createStatement();
        PreparedStatement insert_ps = this.prepareStatement(insertsql);
        for (int i = 0; i < numStrings; ++i) {
            insert_ps.setInt(1, i);
            insert_ps.setAsciiStream(2, (InputStream)new ByteArrayInputStream(stream1_byte_array[i]), stream1_len);
            insert_ps.setAsciiStream(3, (InputStream)new ByteArrayInputStream(stream2_byte_array[i]), stream2_len);
            insert_ps.executeUpdate();
            String checkSQL = "insert into " + tableName + " select * from " + tableName + " where a = -6363";
            stmt.execute(checkSQL);
        }
        insert_ps.close();
        this.commit();
        ResultSet rs = stmt.executeQuery("select a, b, c from " + tableName);
        while (rs.next()) {
            int a = rs.getInt("a");
            String resultString = rs.getString(2);
            String canon = new String(stream1_byte_array[a], "US-ASCII");
            StreamingColumnTest.assertEquals((String)("FAIL -- bad result string:canon: " + canon + "resultString: " + resultString), (int)0, (int)canon.compareTo(resultString));
            resultString = rs.getString(3);
            canon = new String(stream2_byte_array[a], "US-ASCII");
            StreamingColumnTest.assertEquals((String)("FAIL -- bad result string:canon: " + canon + "resultString: " + resultString), (int)0, (int)canon.compareTo(resultString));
        }
        rs.close();
        stmt.execute("insert into " + tableName + " select * from " + tableName + " ");
        stmt.close();
        this.commit();
        StreamingColumnTest.println("Finishing streamTest8(" + stream1_len + ", " + stream2_len + ")");
    }

    public void testStream9_10_2500() throws Exception {
        int stream1_len = 10;
        int stream2_len = 2500;
        String tableName = "t9_10_2500";
        StreamingColumnTest.println("Starting testStream9_10_2500(" + stream1_len + ", " + stream2_len + ")");
        this.streamTest9(stream1_len, stream2_len, tableName);
        StreamingColumnTest.println("Finishing testStream_10_2500(" + stream1_len + ", " + stream2_len + ")");
    }

    public void testStream9_2500_10() throws Exception {
        int stream1_len = 2500;
        int stream2_len = 10;
        String tableName = "t9_2500_10";
        StreamingColumnTest.println("Starting streamTest9_2500_10(" + stream1_len + ", " + stream2_len + ")");
        this.streamTest9(stream1_len, stream2_len, tableName);
        StreamingColumnTest.println("Finishing testStream9_2500_10(" + stream1_len + ", " + stream2_len + ")");
    }

    private void streamTest9(int stream1_len, int stream2_len, String tableName) throws SQLException {
        String insertsql = new String("insert into " + tableName + " values (?, ?, ?) ");
        int numStrings = 10;
        byte[][] stream1_byte_array = new byte[numStrings][];
        byte[][] stream2_byte_array = new byte[numStrings][];
        for (int i = 0; i < numStrings; ++i) {
            int j;
            stream1_byte_array[i] = new byte[stream1_len];
            for (j = 0; j < stream1_len; ++j) {
                stream1_byte_array[i][j] = (byte)(97 + i);
            }
            stream2_byte_array[i] = new byte[stream2_len];
            for (j = 0; j < stream2_len; ++j) {
                stream2_byte_array[i][j] = (byte)(65 + i);
            }
        }
        this.setAutoCommit(false);
        Statement stmt = this.createStatement();
        PreparedStatement insert_ps = this.prepareStatement(insertsql);
        for (int i = 0; i < numStrings; ++i) {
            insert_ps.setInt(1, i);
            insert_ps.setBinaryStream(2, (InputStream)new ByteArrayInputStream(stream1_byte_array[i]), stream1_len);
            insert_ps.setBinaryStream(3, (InputStream)new ByteArrayInputStream(stream2_byte_array[i]), stream2_len);
            insert_ps.executeUpdate();
            String checkSQL = "insert into " + tableName + " select * from " + tableName + " where a = -6363";
            stmt.execute(checkSQL);
        }
        insert_ps.close();
        this.commit();
        ResultSet rs = stmt.executeQuery("select a, b, c from " + tableName);
        while (rs.next()) {
            int a = rs.getInt("a");
            byte[] resultString = rs.getBytes(2);
            byte[] canon = stream1_byte_array[a];
            StreamingColumnTest.assertTrue((String)("FAIL -- bad result byte array 1:canon: " + canon + "resultString: " + resultString), (boolean)Arrays.equals(canon, resultString));
            resultString = rs.getBytes(3);
            canon = stream2_byte_array[a];
            StreamingColumnTest.assertTrue((String)("FAIL -- bad result byte array 2:canon: " + canon + "resultString: " + resultString), (boolean)Arrays.equals(canon, resultString));
        }
        rs.close();
        stmt.execute("insert into " + tableName + " select * from " + tableName);
        stmt.close();
        this.commit();
        StreamingColumnTest.println("Finishing streamTest9(" + stream1_len + ", " + stream2_len + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStream10() throws Exception {
        StreamingColumnTest.println("Test 10 starts from here");
        Statement stmt = this.createStatement();
        for (int i = 0; i < fileName.length; ++i) {
            StreamingColumnTest.println("i:" + i + " fileName:" + fileName[i]);
            File file = new File(fileName[i]);
            StreamingColumnTest.fileLength[i] = PrivilegedFileOpsForTests.length(file);
            FileInputStream fileIn = PrivilegedFileOpsForTests.getFileInputStream(file);
            StreamingColumnTest.println("===> testing " + fileName[i] + " length = " + fileLength[i]);
            PreparedStatement ps = this.prepareStatement("insert into tab10 values(?, ?, ?)");
            ps.setInt(1, 100 + i);
            ps.setInt(2, 100 + i);
            ps.setAsciiStream(3, (InputStream)fileIn, (int)fileLength[i]);
            try {
                StreamingColumnTest.println(ps.toString());
                ps.executeUpdate();
                if (i == 2) {
                    StreamingColumnTest.fail((String)"Length 414000 should have thrown a truncation error!");
                }
                StreamingColumnTest.println("No truncation and hence no error");
                continue;
            }
            catch (SQLException e) {
                StreamingColumnTest.println(i + " " + fileName[i]);
                if (fileLength[i] > 32700L) {
                    if (StreamingColumnTest.usingDerbyNetClient() && i == 2) {
                        StreamingColumnTest.assertSQLState("XJ001", e);
                    } else {
                        StreamingColumnTest.assertSQLState("22001", e);
                    }
                    StreamingColumnTest.println("expected exception for data > 32700 in length");
                    continue;
                }
                throw e;
            }
            finally {
                ((InputStream)fileIn).close();
            }
        }
        CallableStatement cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, ?)");
        cs.setString(1, "APP");
        cs.setString(2, "TESTLONGVARCHAR1");
        cs.setInt(3, 0);
        cs.execute();
        stmt.execute("CREATE FUNCTION ConsistencyChecker() RETURNS VARCHAR(128) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_ConsistencyChecker.runConsistencyChecker' LANGUAGE JAVA PARAMETER STYLE JAVA");
        stmt.execute("VALUES ConsistencyChecker()");
        stmt.close();
        StreamingColumnTest.println("Test 10 ends here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStream11() throws Exception {
        StreamingColumnTest.println("Test 11 - Can't pass negative length as the stream length for various setXXXStream methods");
        File file = new File("extin/short.data");
        FileInputStream fileIn = PrivilegedFileOpsForTests.getFileInputStream(file);
        PreparedStatement ps = this.prepareStatement("insert into testLongVarCharInvalidStreamLength11 values(?, ?, ?)");
        ps.setInt(1, 100);
        try {
            StreamingColumnTest.println("===> testing using setAsciiStream with -2 as length");
            ps.setAsciiStream(2, (InputStream)fileIn, -2);
            StreamingColumnTest.fail((String)"FAIL -- should have gotten exception for -2 param value to setAsciiStream");
        }
        catch (SQLException e) {
            StreamingColumnTest.assertSQLState("XJ025", e);
            StreamingColumnTest.println("Expected exception:" + e.toString());
        }
        finally {
            ((InputStream)fileIn).close();
        }
        InputStreamReader filer = new InputStreamReader((InputStream)fileIn, "US-ASCII");
        try {
            StreamingColumnTest.println("===> testing using setCharacterStream with -1 as length");
            ps.setCharacterStream(2, (Reader)filer, -1);
            StreamingColumnTest.fail((String)"FAIL -- should have gotten exception for -1 param value to setCharacterStream");
        }
        catch (SQLException e) {
            StreamingColumnTest.assertSQLState("XJ025", e);
            StreamingColumnTest.println("PASS -- expected exception:" + e.toString());
        }
        finally {
            ((InputStream)fileIn).close();
        }
        try {
            StreamingColumnTest.println("===> testing using setBinaryStream with -1 as length");
            ps.setBinaryStream(3, (InputStream)fileIn, -1);
            StreamingColumnTest.fail((String)"FAIL -- should have gotten exception for -1 param value to setBinaryStream");
        }
        catch (SQLException e) {
            StreamingColumnTest.assertSQLState("XJ025", e);
            StreamingColumnTest.println("Expected exception:" + e.toString());
        }
        finally {
            ((InputStream)fileIn).close();
        }
        StreamingColumnTest.println("Test 11 - negative stream length tests end in here");
    }

    public void testStream12() throws Exception {
        String fileName1 = "extin/char32675trailingblanks.data";
        String fileName2 = "extin/char32675.data";
        StreamingColumnTest.println("Test 12 - varchar truncation tests start from here");
        Statement stmt = this.createStatement();
        String largeStringA16350 = new String(Formatters.repeatChar("a", 16350));
        String largeStringA16336 = new String(Formatters.repeatChar("a", 16336));
        PreparedStatement ps = this.prepareStatement("insert into testConcatenation12 values (?, ?, ?, ?)");
        ps.setString(1, largeStringA16350);
        ps.setString(2, largeStringA16350);
        ps.setString(3, largeStringA16336);
        ps.setString(4, largeStringA16336);
        ps.executeUpdate();
        ps = this.prepareStatement("insert into testVarChar12 values(?, ?)");
        StreamingColumnTest.insertDataUsingAsciiStream(ps, 1, fileName1, 32672, 12);
        StreamingColumnTest.insertDataUsingCharacterStream(ps, 2, fileName1, 32672, 12);
        StreamingColumnTest.insertDataUsingStringOrObject(ps, 3, 32672, true, true, 12);
        StreamingColumnTest.insertDataUsingStringOrObject(ps, 4, 32672, true, false, 12);
        StreamingColumnTest.println("===> testing trailing blanks using concatenation");
        StreamingColumnTest.insertDataUsingConcat(stmt, 5, 32672, true, 3, "testConcatenation12");
        StreamingColumnTest.insertDataUsingAsciiStream(ps, 6, fileName2, 32672, 12);
        StreamingColumnTest.insertDataUsingCharacterStream(ps, 7, fileName2, 32672, 12);
        StreamingColumnTest.insertDataUsingStringOrObject(ps, 8, 32672, false, true, 12);
        StreamingColumnTest.insertDataUsingStringOrObject(ps, 9, 32672, false, false, 12);
        StreamingColumnTest.println("===> testing trailing non-blank characters using concatenation");
        StreamingColumnTest.insertDataUsingConcat(stmt, 10, 32672, false, 3, "testConcatenation12");
        ResultSet rs = stmt.executeQuery("select a, b from testVarChar12");
        StreamingColumnTest.streamTestDataVerification(rs, 32672);
        StreamingColumnTest.println("Test 12 - varchar truncation tests end in here");
    }

    public void testStream13() throws Exception {
        String fileName1 = "extin/char32703trailingblanks.data";
        String fileName2 = "extin/char32703.data";
        StreamingColumnTest.println("testStream13 - long varchar truncation tests start from here");
        Statement stmt = this.createStatement();
        PreparedStatement ps = this.prepareStatement("insert into testLongVarChars13 values(?, ?)");
        StreamingColumnTest.insertDataUsingAsciiStream(ps, 1, fileName1, 32700, 13);
        StreamingColumnTest.insertDataUsingCharacterStream(ps, 2, fileName1, 32700, 13);
        StreamingColumnTest.insertDataUsingStringOrObject(ps, 3, 32700, true, true, 13);
        StreamingColumnTest.insertDataUsingStringOrObject(ps, 4, 32700, true, false, 13);
        StreamingColumnTest.insertDataUsingAsciiStream(ps, 6, fileName2, 32700, 13);
        StreamingColumnTest.insertDataUsingCharacterStream(ps, 7, fileName2, 32700, 13);
        StreamingColumnTest.insertDataUsingStringOrObject(ps, 7, 32700, false, true, 13);
        StreamingColumnTest.insertDataUsingStringOrObject(ps, 9, 32700, false, false, 13);
        ResultSet rs = stmt.executeQuery("select a, b from testLongVarChars13");
        StreamingColumnTest.streamTestDataVerification(rs, 32700);
        StreamingColumnTest.println("Test 13 - long varchar truncation tests end in here");
    }

    public void testStream14() throws Exception {
        String fileName1 = "extin/char32675trailingblanks.data";
        String fileName2 = "extin/char32675.data";
        StreamingColumnTest.println("testStream 14 - clob truncation tests start from here");
        Statement stmt = this.createStatement();
        String largeStringA16350 = new String(Formatters.repeatChar("a", 16350));
        String largeStringA16336 = new String(Formatters.repeatChar("a", 16336));
        PreparedStatement ps = this.prepareStatement("insert into testConcatenation14 values (?, ?, ?, ?)");
        ps.setString(1, largeStringA16350);
        ps.setString(2, largeStringA16350);
        ps.setString(3, largeStringA16336);
        ps.setString(4, largeStringA16336);
        ps.executeUpdate();
        ps = this.prepareStatement("insert into testClob14 values(?, ?)");
        StreamingColumnTest.insertDataUsingAsciiStream(ps, 1, fileName1, 32672, 14);
        StreamingColumnTest.insertDataUsingCharacterStream(ps, 2, fileName1, 32672, 14);
        StreamingColumnTest.insertDataUsingStringOrObject(ps, 3, 32672, true, true, 14);
        StreamingColumnTest.insertDataUsingStringOrObject(ps, 4, 32672, true, false, 14);
        StreamingColumnTest.println("testStream14 - Testing trailing blanks using concatenation");
        StreamingColumnTest.insertDataUsingConcat(stmt, 5, 32672, true, 2, "testConcatenation14");
        StreamingColumnTest.insertDataUsingAsciiStream(ps, 6, fileName2, 32672, 14);
        StreamingColumnTest.insertDataUsingCharacterStream(ps, 7, fileName2, 32672, 14);
        StreamingColumnTest.insertDataUsingStringOrObject(ps, 8, 32672, false, true, 14);
        StreamingColumnTest.insertDataUsingStringOrObject(ps, 9, 32672, false, false, 14);
        StreamingColumnTest.println("testStream14 - Testing trailing non-blank characters using concatenation");
        StreamingColumnTest.insertDataUsingConcat(stmt, 10, 32672, false, 2, "testConcatenation14");
        ResultSet rs = stmt.executeQuery("select a, b from testVarChar12");
        StreamingColumnTest.streamTestDataVerification(rs, 32672);
        StreamingColumnTest.println("Test 14 - clob truncation tests end in here");
    }

    public void testDerby500() throws Exception {
        StreamingColumnTest.println("======================================");
        StreamingColumnTest.println("START  DERBY-500 TEST ");
        Statement stmt = this.createStatement();
        this.setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into test500 values (?,?,?,?,?)");
        int rowCount = 0;
        int len = 10000;
        byte[] buf = new byte[len];
        char[] cbuf = new char[len];
        int orig = 99;
        for (int i = 0; i < len; ++i) {
            buf[i] = (byte)orig;
            cbuf[i] = orig;
        }
        int randomOffset = 9998;
        buf[randomOffset] = 101;
        cbuf[randomOffset] = 101;
        StreamingColumnTest.println("Inserting rows ");
        for (int i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "mname" + i);
            ps.setInt(3, 0);
            ps.setBinaryStream(4, (InputStream)new ByteArrayInputStream(buf), len);
            ps.setAsciiStream(5, (InputStream)new ByteArrayInputStream(buf), len);
            rowCount += ps.executeUpdate();
        }
        this.commit();
        StreamingColumnTest.println("Rows inserted =" + rowCount);
        PreparedStatement pss = this.prepareStatement(" select chardata,bytedata from test500 where id = ?");
        this.verifyDerby500Test(pss, buf, cbuf, 0, 10, true);
        PreparedStatement psu = this.prepareStatement("update test500 set bytedata = ? , chardata = ? where mvalue = ?  ");
        buf[randomOffset + 1] = 117;
        cbuf[randomOffset + 1] = 117;
        rowCount = 0;
        StreamingColumnTest.println("Update qualifies many rows + streams");
        try {
            psu.setBinaryStream(1, (InputStream)new ByteArrayInputStream(buf), len);
            psu.setCharacterStream(2, (Reader)new CharArrayReader(cbuf), len);
            psu.setInt(3, 0);
            StreamingColumnTest.println("DERBY500 #1 Rows updated  =" + (rowCount += psu.executeUpdate()));
            StreamingColumnTest.fail((String)"Attempting to reuse stream should have thrown an exception!");
        }
        catch (SQLException sqle) {
            StreamingColumnTest.assertSQLState("XJ001", sqle);
            StreamingColumnTest.println("EXPECTED EXCEPTION - streams cannot be re-used");
            this.rollback();
        }
        buf[randomOffset + 1] = (byte)orig;
        cbuf[randomOffset + 1] = orig;
        this.verifyDerby500Test(pss, buf, cbuf, 0, 10, true);
        PreparedStatement psu2 = this.prepareStatement("update test500 set bytedata = ? , chardata = ? where id = ?  ");
        buf[randomOffset + 1] = 117;
        cbuf[randomOffset + 1] = 117;
        rowCount = 0;
        psu2.setBinaryStream(1, (InputStream)new ByteArrayInputStream(buf), len);
        psu2.setAsciiStream(2, (InputStream)new ByteArrayInputStream(buf), len);
        psu2.setInt(3, 0);
        StreamingColumnTest.println("DERBY500 #2 Rows updated  =" + (rowCount += psu2.executeUpdate()));
        this.commit();
        this.verifyDerby500Test(pss, buf, cbuf, 0, 1, true);
        PreparedStatement psd = this.prepareStatement("delete from test500 where mvalue = ?");
        rowCount = 0;
        psd.setInt(1, 0);
        rowCount += psd.executeUpdate();
        StreamingColumnTest.println("DERBY500 #3 Rows deleted =" + (rowCount += psd.executeUpdate()));
        this.commit();
        this.verifyDerby500Test(pss, buf, cbuf, 0, 10, true);
        PreparedStatement psd2 = this.prepareStatement("delete from test500 where id = ?");
        rowCount = 0;
        psd2.setInt(1, 0);
        StreamingColumnTest.println("DERBY500 #4 Rows deleted  =" + (rowCount += psd2.executeUpdate()));
        this.commit();
        this.verifyDerby500Test(pss, buf, cbuf, 1, 2, true);
        try {
            ps.setInt(1, 11);
            rowCount += ps.executeUpdate();
            StreamingColumnTest.fail((String)"Attempting to reuse stream should have thrown an exception!");
        }
        catch (SQLException sqle) {
            if (StreamingColumnTest.usingDerbyNetClient()) {
                StreamingColumnTest.assertSQLState("XN017", sqle);
            } else {
                StreamingColumnTest.assertSQLState("XJ001", sqle);
                StreamingColumnTest.println("EXPECTED EXCEPTION - streams cannot be re-used");
            }
            this.rollback();
        }
        this.commit();
        stmt.close();
        pss.close();
        psu2.close();
        psu.close();
        psd.close();
        psd2.close();
        StreamingColumnTest.println("END  DERBY-500 TEST ");
        StreamingColumnTest.println("======================================");
    }

    public void testDerby500_verifyVarcharStreams() throws Exception {
        StreamingColumnTest.println("======================================");
        StreamingColumnTest.println("START  DERBY-500 TEST for varchar ");
        Statement stmt = this.createStatement();
        PreparedStatement ps = this.prepareStatement("insert into test500_verify values (?,?,?,?,?)");
        int rowCount = 0;
        int len = 10000;
        byte[] buf = new byte[len];
        char[] cbuf = new char[len];
        int orig = 99;
        for (int i = 0; i < len; ++i) {
            buf[i] = (byte)orig;
            cbuf[i] = orig;
        }
        int randomOffset = 9998;
        buf[randomOffset] = 101;
        cbuf[randomOffset] = 101;
        for (int i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "mname" + i);
            ps.setInt(3, 0);
            ps.setCharacterStream(4, (Reader)new CharArrayReader(cbuf), len);
            ps.setAsciiStream(5, (InputStream)new ByteArrayInputStream(buf), len);
            rowCount += ps.executeUpdate();
        }
        this.commit();
        StreamingColumnTest.println("Rows inserted =" + rowCount);
        try {
            ps.setInt(1, 11);
            rowCount += ps.executeUpdate();
            if (StreamingColumnTest.usingDerbyNetClient()) {
                StreamingColumnTest.fail((String)"Expected second executeUpdate with client driver to fail");
            }
        }
        catch (SQLException sqle) {
            if (StreamingColumnTest.usingDerbyNetClient()) {
                String expectedState = "XN017";
                if (sqle.getSQLState().equals("XN014")) {
                    expectedState = "XN014";
                }
                StreamingColumnTest.assertSQLState(expectedState, sqle);
            }
            StreamingColumnTest.println("UNEXPECTED EXCEPTION - streams cannot be re-used but in case of varchar, stream is materialized the first time around. So multiple executions using streams should  work fine. ");
            throw sqle;
        }
        PreparedStatement pss = this.prepareStatement(" select lvc,vc from test500_verify where id = ?");
        this.verifyDerby500Test(pss, buf, cbuf, 0, 10, false);
        PreparedStatement psu = this.prepareStatement("update test500_verify set vc = ? , lvc = ? where mvalue = ?  ");
        buf[randomOffset + 1] = 117;
        cbuf[randomOffset + 1] = 117;
        rowCount = 0;
        psu.setAsciiStream(1, (InputStream)new ByteArrayInputStream(buf), len);
        psu.setCharacterStream(2, (Reader)new CharArrayReader(cbuf), len);
        psu.setInt(3, 0);
        StreamingColumnTest.println("DERBY500 for varchar #1 Rows updated  =" + (rowCount += psu.executeUpdate()));
        this.verifyDerby500Test(pss, buf, cbuf, 0, 10, false);
        PreparedStatement psu2 = this.prepareStatement("update test500_verify set vc = ? , lvc = ? where id = ?  ");
        buf[randomOffset + 1] = 104;
        cbuf[randomOffset + 1] = 104;
        rowCount = 0;
        psu2.setAsciiStream(1, (InputStream)new ByteArrayInputStream(buf), len);
        psu2.setAsciiStream(2, (InputStream)new ByteArrayInputStream(buf), len);
        psu2.setInt(3, 0);
        this.commit();
        StreamingColumnTest.println("DERBY500 for varchar #2 Rows updated  =" + (rowCount += psu2.executeUpdate()));
        this.verifyDerby500Test(pss, buf, cbuf, 0, 1, false);
        PreparedStatement psd = this.prepareStatement("delete from test500_verify where mvalue = ?");
        rowCount = 0;
        psd.setInt(1, 0);
        rowCount += psd.executeUpdate();
        StreamingColumnTest.println("DERBY500 for varchar #3 Rows deleted =" + (rowCount += psd.executeUpdate()));
        this.verifyDerby500Test(pss, buf, cbuf, 0, 10, false);
        PreparedStatement psd2 = this.prepareStatement("delete from test500_verify where id = ?");
        rowCount = 0;
        psd2.setInt(1, 0);
        this.commit();
        StreamingColumnTest.println("DERBY500 for varchar #4 Rows deleted  =" + (rowCount += psd2.executeUpdate()));
        this.verifyDerby500Test(pss, buf, cbuf, 1, 2, false);
        this.commit();
        stmt.close();
        pss.close();
        psu2.close();
        psu.close();
        psd.close();
        psd2.close();
        StreamingColumnTest.println("END  DERBY-500 TEST  for varchar");
        StreamingColumnTest.println("======================================");
    }

    private void verifyDerby500Test(PreparedStatement ps, byte[] buf, char[] cbuf, int startId, int endId, boolean binaryType) throws Exception {
        int rowCount = 0;
        ResultSet rs = null;
        for (int i = startId; i < endId; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            if (!rs.next()) continue;
            StreamingColumnTest.compareCharArray(rs.getCharacterStream(1), cbuf, cbuf.length);
            if (binaryType) {
                Arrays.equals(rs.getBytes(2), buf);
            } else {
                StreamingColumnTest.compareCharArray(rs.getCharacterStream(2), cbuf, cbuf.length);
            }
            ++rowCount;
        }
        StreamingColumnTest.println("Rows selected =" + rowCount);
        rs.close();
    }

    private static void compareCharArray(Reader stream, char[] compare, int length) throws Exception {
        int c1 = 0;
        int i = 0;
        do {
            c1 = stream.read();
            StreamingColumnTest.assertEquals((String)("MISMATCH in data stored versus data retrieved at " + (i - 1)), (int)c1, (int)compare[i++]);
        } while (c1 != -1 && --length > 0);
    }

    private static void streamTestDataVerification(ResultSet rs, int maxValueAllowed) throws Exception {
        rs.getMetaData();
        byte[] buff = new byte[128];
        while (rs.next()) {
            int size;
            int a = rs.getInt("a");
            InputStream fin = rs.getAsciiStream(2);
            int columnSize = 0;
            while ((size = fin.read(buff)) != -1) {
                columnSize += size;
            }
            if (a >= 1 && a <= 5 && columnSize == maxValueAllowed) {
                StreamingColumnTest.println("===> verified length " + maxValueAllowed);
                continue;
            }
            StreamingColumnTest.println("test failed, columnSize should be " + maxValueAllowed + " but it is" + columnSize);
        }
    }

    private static void insertDataUsingConcat(Statement stmt, int intValue, int maxValueAllowed, boolean blankPadding, int tblType, String tableName) throws Exception {
        String sql;
        boolean throwsException = false;
        switch (tblType) {
            case 1: {
                sql = "insert into testLongVarChars13 select " + intValue + ", a||b||";
                break;
            }
            case 2: {
                sql = "insert into testClob14 select " + intValue + ", c||d||";
                throwsException = true;
                break;
            }
            default: {
                sql = "insert into testVarChar12 select " + intValue + ", c||d||";
                throwsException = true;
            }
        }
        sql = blankPadding ? sql.concat("'   ' from " + tableName) : sql.concat("'123' from " + tableName);
        try {
            stmt.execute(sql);
            if (throwsException && !blankPadding) {
                StreamingColumnTest.fail((String)"Truncation sould have thrown an exception!");
            }
            StreamingColumnTest.println("No truncation and hence no error.");
        }
        catch (SQLException e) {
            StreamingColumnTest.assertSQLState("22001", e);
            StreamingColumnTest.println("expected exception for data > " + maxValueAllowed + " in length");
        }
    }

    private static void insertDataUsingStringOrObject(PreparedStatement ps, int intValue, int maxValueAllowed, boolean blankPadding, boolean testUsingString, int test) throws Exception {
        StringBuffer sb = new StringBuffer(maxValueAllowed);
        for (int i = 0; i < maxValueAllowed; ++i) {
            sb.append('q');
        }
        String largeString = new String(sb);
        if (blankPadding) {
            largeString = largeString.concat("   ");
            StreamingColumnTest.println("===> testing trailing blanks(using ");
        } else {
            largeString = largeString.concat("123");
            StreamingColumnTest.println("===> testing trailing non-blanks(using ");
        }
        ps.setInt(1, intValue);
        if (testUsingString) {
            StreamingColumnTest.println("setString) length = " + largeString.length());
            ps.setString(2, largeString);
        } else {
            StreamingColumnTest.println("setObject) length = " + largeString.length());
            ps.setObject(2, largeString);
        }
        try {
            ps.executeUpdate();
            if (!blankPadding) {
                StreamingColumnTest.fail((String)"Should have thrown a truncation error");
            }
            StreamingColumnTest.println("No truncation and hence no error");
        }
        catch (SQLException e) {
            if (largeString.length() > maxValueAllowed) {
                if (!blankPadding && StreamingColumnTest.usingDerbyNetClient()) {
                    StreamingColumnTest.assertSQLState("XJ001", e);
                } else if (test == 13 && StreamingColumnTest.usingDerbyNetClient()) {
                    StreamingColumnTest.assertSQLState("XJ001", e);
                } else {
                    StreamingColumnTest.assertSQLState("22001", e);
                }
                StreamingColumnTest.println("expected exception for data > " + maxValueAllowed + " in length");
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertDataUsingCharacterStream(PreparedStatement ps, int intValue, String fileName, int maxValueAllowed, int test) throws Exception {
        block15: {
            File file = new File(fileName);
            FileInputStream fileIn = PrivilegedFileOpsForTests.getFileInputStream(file);
            InputStreamReader filer = new InputStreamReader((InputStream)fileIn, "US-ASCII");
            StreamingColumnTest.println("===> testing(using setCharacterStream) " + fileName + " length = " + PrivilegedFileOpsForTests.length(file));
            ps.setInt(1, intValue);
            ps.setCharacterStream(2, (Reader)filer, (int)PrivilegedFileOpsForTests.length(file));
            try {
                ps.executeUpdate();
                if ("extin/char32675.data".equals(fileName)) {
                    StreamingColumnTest.fail((String)"Should have thrown a truncation error");
                }
                StreamingColumnTest.println("No truncation and hence no error");
            }
            catch (SQLException e) {
                if (PrivilegedFileOpsForTests.length(file) > (long)maxValueAllowed) {
                    if (test == 12) {
                        if (StreamingColumnTest.usingDerbyNetClient() && "extin/char32675.data".equals(fileName)) {
                            StreamingColumnTest.assertSQLState("XJ001", e);
                        } else {
                            StreamingColumnTest.assertSQLState("22001", e);
                        }
                    } else if (test == 13) {
                        if (StreamingColumnTest.usingDerbyNetClient()) {
                            StreamingColumnTest.assertSQLState("XJ001", e);
                        } else {
                            StreamingColumnTest.assertSQLState("22001", e);
                        }
                    } else {
                        StreamingColumnTest.assertSQLState("XJ001", e);
                    }
                    StreamingColumnTest.println("expected exception for data > " + maxValueAllowed + " in length");
                    break block15;
                }
                throw e;
            }
            finally {
                ((Reader)filer).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertDataUsingAsciiStream(PreparedStatement ps, int intValue, String fileName, int maxValueAllowed, int test) throws Exception {
        block18: {
            File file = new File(fileName);
            FileInputStream fileIn = PrivilegedFileOpsForTests.getFileInputStream(file);
            StreamingColumnTest.println("===> testing(using setAsciiStream) " + fileName + " length = " + PrivilegedFileOpsForTests.length(file));
            ps.setInt(1, intValue);
            ps.setAsciiStream(2, (InputStream)fileIn, (int)PrivilegedFileOpsForTests.length(file));
            try {
                ps.executeUpdate();
                if ("extin/char32675.data".equals(fileName)) {
                    StreamingColumnTest.fail((String)"Should have thrown a truncation error");
                }
                StreamingColumnTest.println("No truncation and hence no error");
            }
            catch (SQLException e) {
                if (PrivilegedFileOpsForTests.length(file) > (long)maxValueAllowed) {
                    if (test == 12) {
                        if (StreamingColumnTest.usingDerbyNetClient() && "extin/char32675.data".equals(fileName)) {
                            StreamingColumnTest.assertSQLState("XJ001", e);
                        } else {
                            StreamingColumnTest.assertSQLState("22001", e);
                        }
                    } else if (test == 13) {
                        if (StreamingColumnTest.usingDerbyNetClient()) {
                            StreamingColumnTest.assertSQLState("XJ001", e);
                        } else {
                            StreamingColumnTest.assertSQLState("22001", e);
                        }
                    } else if (test == 14) {
                        if ("extin/char32675.data".equals(fileName)) {
                            StreamingColumnTest.assertSQLState("XJ001", e);
                        } else {
                            StreamingColumnTest.assertSQLState("22001", e);
                        }
                    }
                    StreamingColumnTest.println("expected exception for data > " + maxValueAllowed + " in length");
                    break block18;
                }
                throw e;
            }
            finally {
                ((InputStream)fileIn).close();
            }
        }
    }

    private void verifyLength(int a, int columnSize, long[] fileLength) {
        for (int i = 0; i < fileLength.length; ++i) {
            if (a != 100 + i && a != 10000 + i) continue;
            StreamingColumnTest.assertEquals((String)("ColumnSize should be " + fileLength[i] + ", but it is " + columnSize + ", i = " + i), (long)fileLength[i], (long)columnSize);
        }
    }

    private void verifyExistence(int key, String base, long length, String tableName) throws Exception {
        StreamingColumnTest.assertEquals((String)("failed to find value " + base + "... at key " + key), (String)StreamingColumnTest.pad(base, length), (String)this.getLongString(key, tableName));
    }

    private String getLongString(int key, String tableName) throws Exception {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select b from " + tableName + " where a = " + key);
        StreamingColumnTest.assertTrue((String)("There weren't any rows for key = " + key), (boolean)rs.next());
        String answer = rs.getString(1);
        StreamingColumnTest.assertFalse((String)("There were multiple rows for key = " + key), (boolean)rs.next());
        rs.close();
        s.close();
        return answer;
    }

    static String pad(String base, long length) {
        StringBuffer b = new StringBuffer(base);
        long i = 1L;
        while ((long)b.length() < length) {
            b.append(" " + i);
            ++i;
        }
        return b.toString();
    }

    private int insertLongString(int key, String data, boolean binaryColumn, String tableName) throws Exception {
        PreparedStatement ps = this.prepareStatement("insert into " + tableName + " values(" + key + ", ?)");
        return this.streamInStringCol(ps, data, binaryColumn);
    }

    private int updateLongString(int oldkey, int newkey, String tableName) throws Exception {
        PreparedStatement ps = this.prepareStatement("update " + tableName + " set a = ?, b = ? where a = " + oldkey);
        String updateString = StreamingColumnTest.pad("", newkey);
        ByteArrayInputStream bais = new ByteArrayInputStream(updateString.getBytes("US-ASCII"));
        ps.setInt(1, newkey);
        ps.setAsciiStream(2, (InputStream)bais, updateString.length());
        int nRows = ps.executeUpdate();
        ps.close();
        return nRows;
    }

    private int streamInStringCol(PreparedStatement ps, String data, boolean binaryColumn) throws Exception {
        int nRows = 0;
        if (data == null) {
            ps.setAsciiStream(1, (InputStream)null, 0);
            nRows = ps.executeUpdate();
        } else {
            ByteArrayInputStream bais = new ByteArrayInputStream(data.getBytes("US-ASCII"));
            if (binaryColumn) {
                ps.setBinaryStream(1, (InputStream)bais, data.length());
            } else {
                ps.setAsciiStream(1, (InputStream)bais, data.length());
            }
            nRows = ps.executeUpdate();
            bais.close();
        }
        return nRows;
    }

    private static int streamInLongCol(PreparedStatement ps, Object data) throws Exception {
        String s = (String)data;
        ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes("US-ASCII"));
        ps.setAsciiStream(1, (InputStream)bais, s.length());
        int nRows = ps.executeUpdate();
        bais.close();
        return nRows;
    }

    public static Test suite() {
        Properties strColProperties = new Properties();
        strColProperties.setProperty("derby.storage.sortBufferMax", "5");
        strColProperties.setProperty("derby.debug.true", "testSort");
        BaseTestSuite suite = new BaseTestSuite("StreamingColumnTest");
        suite.addTest(StreamingColumnTest.baseSuite("StreamingColumnTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(StreamingColumnTest.baseSuite("StreamingColumnTest:client")));
        return new SystemPropertyTestSetup((Test)suite, strColProperties);
    }

    protected static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(StreamingColumnTest.class);
        SupportFilesSetup test = new SupportFilesSetup((Test)suite, new String[]{"functionTests/tests/store/short.data", "functionTests/tests/store/shortbanner", "functionTests/tests/store/derby.banner", "functionTests/tests/store/empty.data", "functionTests/tests/store/char32703trailingblanks.data", "functionTests/tests/store/char32703.data", "functionTests/tests/store/char32675trailingblanks.data", "functionTests/tests/store/char32675.data"});
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)test, 2, 4)){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.execute("create table testLongVarChar1 (a int, b long varchar)");
                stmt.execute("insert into testLongVarChar1 values(1, '')");
                stmt.execute("insert into testLongVarChar1 values(2, 'test data: a string column inserted as an object')");
                stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
                stmt.execute("create table foo1 (a int not null, b long varchar, primary key (a))");
                stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
                stmt.execute("create table foo2_1500 (a int not null, b long varchar, primary key (a))");
                stmt.execute("create table foo2_5000 (a int not null, b long varchar, primary key (a))");
                stmt.execute("create table foo2_10000 (a int not null, b long varchar, primary key (a))");
                stmt.execute("create table foo3_0 (a int not null constraint pk3_0 primary key, b long varchar)");
                stmt.execute("create table foo3_1500 (a int not null constraint pk3_1500 primary key, b long varchar)");
                stmt.execute("create table foo3_5000 (a int not null constraint pk3_5000 primary key, b long varchar)");
                stmt.execute("create table foo3_10000 (a int not null constraint pk3_10000 primary key, b long varchar)");
                stmt.execute("create table testLongVarBinary4 (a int, b BLOB(1G))");
                long length = 0L;
                String binaryType = length > 32700L ? "BLOB(1G)" : "long varchar for bit data";
                stmt.execute("create table foo5_0 (a int not null constraint pk5_0 primary key, b " + binaryType + " )");
                length = 1500L;
                binaryType = length > 32700L ? "BLOB(1G)" : "long varchar for bit data";
                stmt.execute("create table foo5_1500 (a int not null constraint pk5_1500 primary key, b " + binaryType + " )");
                length = 5000L;
                binaryType = length > 32700L ? "BLOB(1G)" : "long varchar for bit data";
                stmt.executeUpdate("create table foo5_5000 (a int not null constraint pk5_5000 primary key, b " + binaryType + " )");
                length = 100000L;
                binaryType = length > 32700L ? "BLOB(1G)" : "long varchar for bit data";
                stmt.executeUpdate("create table foo5_100000 (a int not null constraint pk5_100000 primary key, b " + binaryType + " )");
                stmt.executeUpdate("create table foo_6 (a int not null constraint pk6 primary key, b long varchar)");
                stmt.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
                stmt.execute("create table testlvc7 (a int, b char(100), lvc long varchar, d char(100))");
                stmt.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
                stmt.execute("create table t8_10_2500(a int, b long varchar, c long varchar)");
                stmt.execute("create table t8_2500_10(a int, b long varchar, c long varchar)");
                stmt.execute("create table t9_10_2500(a int, b long varchar for bit data, c long varchar for bit data)");
                stmt.execute("create table t9_2500_10(a int, b long varchar for bit data, c long varchar for bit data)");
                stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
                stmt.execute("create table tab10 (a int, b int, c long   varchar)");
                stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
                stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
                stmt.execute("create index i_a on tab10 (a)");
                stmt.execute("create index i_ab on tab10 (a, b)");
                stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
                stmt.execute("insert into tab10 values(1, 1, '')");
                stmt.execute("insert into tab10 values(2, 2, 'test data: a string column inserted as an object')");
                stmt.execute("create table testLongVarCharInvalidStreamLength11 (a int, b long varchar, c long varchar for bit data)");
                stmt.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
                stmt.execute("create table testVarChar12 (a int, b varchar(32672))");
                stmt.execute("create table testConcatenation12 (a varchar(16350), b varchar(16350), c varchar(16336), d varchar(16336))");
                stmt.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
                stmt.execute("create table testLongVarChars13 (a int, b long varchar)");
                stmt.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
                stmt.execute("create table testClob14 (a int, b clob(32672))");
                stmt.execute("create table testConcatenation14 (a clob(16350), b clob(16350), c clob(16336), d clob(16336))");
                stmt.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
                stmt.execute("CREATE TABLE test500 (id INTEGER NOT NULL,mname VARCHAR( 254 ) NOT NULL,mvalue INT NOT NULL,bytedata BLOB NOT NULL,chardata CLOB NOT NULL,PRIMARY KEY ( id ))");
                stmt.execute("CREATE TABLE test500_verify (id INTEGER NOT NULL,mname VARCHAR( 254 ) NOT NULL,mvalue INT NOT NULL,vc varchar(32500),lvc long varchar NOT NULL,PRIMARY KEY ( id ))");
            }
        };
    }

    static {
        int numFiles = 4;
        fileName = new String[numFiles];
        fileLength = new long[numFiles];
        StreamingColumnTest.fileName[0] = "extin/short.data";
        StreamingColumnTest.fileName[1] = "extin/shortbanner";
        StreamingColumnTest.fileName[2] = "extin/derby.banner";
        StreamingColumnTest.fileName[3] = "extin/empty.data";
    }
}

