/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import junit.framework.Assert;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.DriverUnloader;
import org.apache.derbyTesting.junit.BaseTestCase;

public class UpgradeClassLoader {
    private static final String[] jarFiles = new String[]{"derby.jar"};
    static final String oldVersionsPath = UpgradeClassLoader.getSystemProperty("derbyTesting.oldVersionsPath");
    static final String jarPath = UpgradeClassLoader.getSystemProperty("derbyTesting.oldReleasePath");

    private static String getSystemProperty(final String key) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }

    protected static String getTextVersion(int[] iv) {
        String version = iv[0] + "." + iv[1] + "." + iv[2] + "." + iv[3];
        return version;
    }

    public static ClassLoader makeClassLoader(final int[] version) {
        ClassLoader oldLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return UpgradeClassLoader.createClassLoader(version);
            }
        });
        if (oldLoader == null) {
            BaseTestCase.traceit("Empty: Skip upgrade Tests (no jars) for " + UpgradeClassLoader.getTextVersion(version));
        }
        return oldLoader;
    }

    private static String getOldJarLocation(int[] oldVersion) {
        if (jarPath == null || jarPath.length() == 0) {
            return null;
        }
        String version = UpgradeClassLoader.getTextVersion(oldVersion);
        String jarLocation = jarPath + File.separator + version;
        return jarLocation;
    }

    private static String getOldJarURLLocation(int[] oldVersion) {
        String oldJarUrl = "http://svn.apache.org/repos/asf/db/derby/jars";
        String version = UpgradeClassLoader.getTextVersion(oldVersion);
        String jarLocation = oldJarUrl + "/" + version;
        return jarLocation;
    }

    private static ClassLoader createClassLoader(int[] version) {
        URL[] url = new URL[jarFiles.length];
        String jarLocation = UpgradeClassLoader.getOldJarLocation(version);
        if (jarLocation != null) {
            File lib = new File(jarLocation);
            if (!lib.exists()) {
                BaseTestCase.alarm("Non-existing location for jar files: '" + jarLocation + "'. Upgrade tests can NOT be run!");
                return null;
            }
            for (int i = 0; i < jarFiles.length; ++i) {
                try {
                    url[i] = new File(lib, jarFiles[i]).toURI().toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    Assert.fail((String)e.toString());
                }
            }
        } else {
            String oldURLJarLocation = UpgradeClassLoader.getOldJarURLLocation(version);
            for (int i = 0; i < jarFiles.length; ++i) {
                try {
                    url[i] = new URL(oldURLJarLocation + "/" + jarFiles[i]);
                    Object e = url[i].getContent();
                    continue;
                }
                catch (MalformedURLException e) {
                    Assert.fail((String)e.toString());
                    continue;
                }
                catch (IOException e) {
                    BaseTestCase.alarm("IOException connecting to location: " + oldURLJarLocation + ", msg: '" + e.getMessage() + "'." + " Upgrade tests can NOT be run!");
                    e.printStackTrace();
                    return null;
                }
            }
        }
        URLClassLoader oldVersionLoader = new URLClassLoader(url, Connection.class.getClassLoader());
        return new ClassLoader(oldVersionLoader){

            protected Class findClass(String name) throws ClassNotFoundException {
                if (name.equals(DriverUnloader.class.getName())) {
                    try {
                        byte[] b = UpgradeClassLoader.fetchDriverUnloaderBytes();
                        return this.defineClass(name, b, 0, b.length);
                    }
                    catch (IOException ioe) {
                        throw new ClassNotFoundException(name, ioe);
                    }
                }
                throw new ClassNotFoundException(name);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] fetchDriverUnloaderBytes() throws IOException {
        try (InputStream in = DriverUnloader.class.getResourceAsStream("DriverUnloader.class");){
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

