/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.lang.reflect.Method;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.AdditionalDb;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.BasicSetup;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_1;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_10;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_11;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_12;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_13;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_2;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_3;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_4;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_5;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_6;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_7;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Changes10_9;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.PhaseChanger;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeClassLoader;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

class UpgradeRun
extends UpgradeClassLoader {
    static final AdditionalDb[] ADDITIONAL_DBS = new AdditionalDb[]{new AdditionalDb("COLLATED_DB_10_3", true), new AdditionalDb("NO_ENCRYPT_10_2", true), new AdditionalDb("ENCRYPT_10_2", true), new AdditionalDb("ROLES_10_5", false), new AdditionalDb("BUILTIN_10_9", false), new AdditionalDb("DERBY-4753", true)};

    UpgradeRun() {
    }

    public static Test suite(int[] version, boolean useCreateOnUpgrade) {
        ClassLoader oldLoader = UpgradeRun.makeClassLoader(version);
        if (oldLoader == null) {
            BaseTestSuite suite = new BaseTestSuite("Empty: Skipped upgrade Tests (no jars) for " + UpgradeRun.getTextVersion(version));
            return suite;
        }
        BaseTestSuite suite = new BaseTestSuite("Upgrade Tests from " + UpgradeRun.getTextVersion(version));
        BaseTestCase.traceit("Prepare to run upgrade tests from " + UpgradeRun.getTextVersion(version));
        for (int phase = 0; phase < UpgradeChange.PHASES.length; ++phase) {
            ClassLoader loader = null;
            switch (phase) {
                case 0: 
                case 2: 
                case 4: {
                    loader = oldLoader;
                    break;
                }
            }
            Test phaseTests = UpgradeRun.baseSuite(UpgradeRun.getTextVersion(version) + " Upgrade Phase: " + UpgradeChange.PHASES[phase] + " ", phase, version);
            PhaseChanger phaseSet = new PhaseChanger(phaseTests, phase, loader, version, useCreateOnUpgrade);
            phaseSet = UpgradeRun.handleJavaSE6(phase, version, (Test)phaseSet);
            suite.addTest((Test)phaseSet);
        }
        TestSetup setup = TestConfiguration.singleUseDatabaseDecorator((Test)suite);
        for (int i = 0; i < ADDITIONAL_DBS.length; ++i) {
            setup = UpgradeRun.ADDITIONAL_DBS[i].shutDown ? TestConfiguration.additionalDatabaseDecorator((Test)setup, UpgradeRun.ADDITIONAL_DBS[i].logicalName) : TestConfiguration.additionalDatabaseDecoratorNoShutdown((Test)setup, UpgradeRun.ADDITIONAL_DBS[i].logicalName);
        }
        Properties preReleaseUpgrade = new Properties();
        preReleaseUpgrade.setProperty("derby.database.allowPreReleaseUpgrade", "true");
        setup = new SystemPropertyTestSetup((Test)setup, preReleaseUpgrade);
        return SecurityManagerSetup.noSecurityManager((Test)setup);
    }

    private static Test baseSuite(String name, int phase, int[] version) {
        BaseTestSuite suite = new BaseTestSuite(name);
        int oldMajor = version[0];
        int oldMinor = version[1];
        if (phase != 4) {
            suite.addTest(BasicSetup.suite());
            if (oldMajor == 10) {
                if (oldMinor < 1) {
                    suite.addTest(Changes10_1.suite());
                }
                if (oldMinor < 2) {
                    suite.addTest(Changes10_2.suite());
                }
                if (oldMinor < 3) {
                    suite.addTest(Changes10_3.suite(phase));
                }
                if (oldMinor < 4) {
                    suite.addTest(Changes10_4.suite(phase));
                }
                if (oldMinor < 5) {
                    suite.addTest(Changes10_5.suite(phase));
                }
                if (oldMinor < 6) {
                    suite.addTest(Changes10_6.suite(phase));
                }
                if (oldMinor < 7) {
                    suite.addTest(Changes10_7.suite(phase));
                }
                if (oldMinor < 9) {
                    suite.addTest(Changes10_9.suite(phase));
                }
                if (oldMinor < 10) {
                    suite.addTest(Changes10_10.suite(phase));
                }
                if (oldMinor < 11) {
                    suite.addTest(Changes10_11.suite(phase));
                }
                if (oldMinor < 12) {
                    suite.addTest(Changes10_12.suite(phase));
                }
                if (oldMinor < 13) {
                    suite.addTest(Changes10_13.suite(phase));
                }
            }
            switch (phase) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: 
                case 3: {
                    UpgradeRun.runDataBaseMetaDataTest(suite, oldMinor);
                }
            }
        } else {
            suite.addTest((Test)new BasicSetup("noConnectionAfterHardUpgrade"));
        }
        if (phase == 1 && UpgradeRun.suffersFromDerby4835or5289(version)) {
            suite.addTest((Test)new BasicSetup("dropAllTriggerPlans"));
        }
        return TestConfiguration.connectionDSDecorator((Test)suite);
    }

    private static boolean suffersFromDerby4835or5289(int[] version) {
        return UpgradeRun.lessThan(new int[]{10, 5, 0, 0}, version) && UpgradeRun.lessThan(version, new int[]{10, 5, 3, 2}) || UpgradeRun.lessThan(new int[]{10, 6, 0, 0}, version) && UpgradeRun.lessThan(version, new int[]{10, 6, 2, 3}) || UpgradeRun.lessThan(new int[]{10, 7, 0, 0}, version) && UpgradeRun.lessThan(version, new int[]{10, 7, 1, 4}) || UpgradeRun.lessThan(new int[]{10, 8, 0, 0}, version) && UpgradeRun.lessThan(version, new int[]{10, 8, 2, 2});
    }

    static boolean lessThan(int[] left, int[] right) {
        for (int i = 0; i < left.length; ++i) {
            if (left[i] < right[i]) {
                return true;
            }
            if (left[i] <= right[i]) continue;
            return false;
        }
        return false;
    }

    private static Test handleJavaSE6(int phase, int[] version, Test test) {
        boolean oldReleaseNeedsJDBC3 = false;
        switch (phase) {
            case 0: 
            case 2: {
                if (version[0] != 10 || version[1] >= 3 || version[1] >= 2 && version[2] >= 2) break;
                oldReleaseNeedsJDBC3 = true;
                break;
            }
        }
        if (oldReleaseNeedsJDBC3) {
            return TestConfiguration.forceJDBC3Embedded(test);
        }
        return test;
    }

    private static void runDataBaseMetaDataTest(BaseTestSuite suite, int oldMinor) {
        BaseTestSuite dmdSuite = new BaseTestSuite("DatabaseMetaData subsuite");
        Method[] methods = DatabaseMetaDataTest.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name;
            Method m = methods[i];
            if (m.getParameterTypes().length > 0 || !m.getReturnType().equals(Void.TYPE) || !(name = m.getName()).startsWith("test") || name.equals("testGetTablesModify") && oldMinor < 1 || name.equals("testGetTablePrivileges") && oldMinor < 2 || name.equals("testGetColumnPrivileges") && oldMinor < 2) continue;
            dmdSuite.addTest((Test)new DatabaseMetaDataTest(name));
        }
        suite.addTest(TestConfiguration.changeUserDecorator((Test)dmdSuite, "DMDT", "DMDT"));
    }
}

