/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.ChangeSSLSetup;
import org.apache.derbyTesting.junit.ChangeUserSetup;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.ConnectorSetup;
import org.apache.derbyTesting.junit.DataSourceConnector;
import org.apache.derbyTesting.junit.DatabaseChangeSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.DropDatabaseSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.JDBCClientSetup;
import org.apache.derbyTesting.junit.NetworkServerControlWrapper;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.ReleaseRepository;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.ServerSetup;

public final class TestConfiguration {
    private static final String DEFAULT_DBNAME = "wombat";
    private static final String DEFAULT_DBNAME_SQL = "dbsqlauth";
    private static final String DEFAULT_USER_NAME = "APP";
    private static final String DEFAULT_USER_PASSWORD = "APP";
    private static final int DEFAULT_PORT = 1527;
    private static final String DEFAULT_FRAMEWORK = "embedded";
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int LOCKFILETIMEOUT = 300000;
    private static final int MAX_PORTS_USED = 22;
    private static final int basePort;
    private static int lastAssignedPort;
    private static final int bogusPort;
    private static int assignedPortCount;
    private FileOutputStream serverOutput;
    private static final int SLEEP_TIME = 1000;
    private static final String KEY_DBNAME = "databaseName";
    private static final String KEY_FRAMEWORK = "framework";
    private static final String KEY_USER_PASSWORD = "password";
    private static final String KEY_USER_NAME = "user";
    private static final String KEY_HOSTNAME = "hostName";
    private static final String KEY_PORT = "port";
    private static final String KEY_VERBOSE = "derby.tests.debug";
    private static final String KEY_LOGIN_TIMEOUT = "derby.tests.login.timeout";
    private static final String KEY_TRACE = "derby.tests.trace";
    public static final String KEY_OMIT_LUCENE = "derby.tests.omitLucene";
    public static final String KEY_OMIT_JSON = "derby.tests.omitJson";
    private static final String KEY_STOP_AFTER_FIRST_FAIL = "derby.tests.stopAfterFirstFail";
    private static final String KEY_SSL = "ssl";
    private static final String KEY_JMX_PORT = "jmxPort";
    private static int uniqueDB;
    private static ReleaseRepository releaseRepository;
    private static final TestConfiguration JUNIT_CONFIG;
    private static final TestConfiguration DEFAULT_CONFIG;
    private static final ThreadLocal<TestConfiguration> CURRENT_CONFIG;
    private final String defaultDbName;
    private final ArrayList<String> usedDbNames = new ArrayList();
    private final HashMap<String, String> logicalDbMapping = new HashMap();
    private final String url;
    private final String userName;
    private final String userPassword;
    private final int port;
    private final String hostName;
    private final JDBCClient jdbcClient;
    private final int jmxPort;
    private boolean isVerbose;
    private boolean doTrace;
    private boolean stopAfterFirstFail;
    private String ssl;
    private Properties connectionAttributes;
    private String passwordToken = "";
    Connector connector;

    public static TestConfiguration getCurrent() {
        return CURRENT_CONFIG.get();
    }

    public static synchronized ReleaseRepository getReleaseRepository() {
        if (releaseRepository == null) {
            try {
                releaseRepository = ReleaseRepository.getInstance();
            }
            catch (IOException ioe) {
                BaseTestCase.printStackTrace(ioe);
                Assert.fail((String)("failed to initialize the release repository: " + ioe.getMessage()));
            }
        }
        return releaseRepository;
    }

    static void setCurrent(TestConfiguration config) {
        CURRENT_CONFIG.set(config);
    }

    public static Test defaultSuite(Class testClass) {
        return TestConfiguration.defaultSuite(testClass, true);
    }

    public static Test defaultSuite(Class testClass, boolean cleanDB) {
        BaseTestSuite suite = new BaseTestSuite(TestConfiguration.suiteName(testClass));
        if (cleanDB) {
            suite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(testClass)));
            suite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.clientServerSuite(testClass)));
        } else {
            suite.addTest(TestConfiguration.embeddedSuite(testClass));
            suite.addTest(TestConfiguration.clientServerSuite(testClass));
        }
        return suite;
    }

    public static Test defaultExistingServerSuite(Class testClass) {
        return TestConfiguration.defaultExistingServerSuite(testClass, true);
    }

    public static Test defaultExistingServerSuite(Class testClass, boolean cleanDB) {
        BaseTestSuite suite = new BaseTestSuite(TestConfiguration.suiteName(testClass));
        if (cleanDB) {
            suite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.clientExistingServerSuite(testClass)));
        } else {
            suite.addTest(TestConfiguration.clientExistingServerSuite(testClass));
        }
        return suite;
    }

    public static Test existingServerSuite(Class testClass, boolean cleanDB, String hostName, int portNumber) {
        BaseTestSuite suite = new BaseTestSuite(TestConfiguration.suiteName(testClass));
        if (cleanDB) {
            suite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.clientExistingServerSuite(testClass, hostName, portNumber)));
        } else {
            suite.addTest(TestConfiguration.clientExistingServerSuite(testClass, hostName, portNumber));
        }
        return suite;
    }

    public static Test existingServerSuite(Class testClass, boolean cleanDB, String hostName, int portNumber, String dbPath) {
        BaseTestSuite suite = new BaseTestSuite(TestConfiguration.suiteName(testClass));
        if (cleanDB) {
            suite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.clientExistingServerSuite(testClass, hostName, portNumber, dbPath)));
        } else {
            suite.addTest(TestConfiguration.clientExistingServerSuite(testClass, hostName, portNumber, dbPath));
        }
        return suite;
    }

    public static Test forceJDBC3Suite(Class testClass) {
        BaseTestSuite suite = new BaseTestSuite(TestConfiguration.suiteName(testClass));
        suite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.forceJDBC3Embedded(TestConfiguration.embeddedSuite(testClass))));
        suite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.forceJDBC3NetClient(TestConfiguration.clientServerSuite(testClass))));
        return suite;
    }

    static String suiteName(Class testClass) {
        int lastDot = testClass.getName().lastIndexOf(46);
        String suiteName = testClass.getName();
        if (lastDot != -1) {
            suiteName = suiteName.substring(lastDot + 1, suiteName.length());
        }
        return suiteName;
    }

    public static Test embeddedSuite(Class testClass) {
        return new BaseTestSuite(testClass, TestConfiguration.suiteName(testClass) + ":embedded");
    }

    public static Test clientServerSuite(Class testClass) {
        return TestConfiguration.clientServerDecorator(TestConfiguration.bareClientServerSuite(testClass));
    }

    public static Test clientServerSuiteWithAlternativePort(Class testClass) {
        return TestConfiguration.clientServerDecoratorWithAlternativePort(TestConfiguration.bareClientServerSuite(testClass));
    }

    public static Test clientExistingServerSuite(Class testClass) {
        return TestConfiguration.defaultExistingServerDecorator(TestConfiguration.bareClientServerSuite(testClass));
    }

    public static Test clientExistingServerSuite(Class testClass, String hostName, int portNumber) {
        return TestConfiguration.existingServerDecorator(TestConfiguration.bareClientServerSuite(testClass), hostName, portNumber);
    }

    public static Test clientExistingServerSuite(Class testClass, String hostName, int portNumber, String dbPath) {
        return TestConfiguration.existingServerDecorator(TestConfiguration.bareClientServerSuite(testClass), hostName, portNumber, dbPath);
    }

    public static Test clientServerDecorator(Test suite) {
        NetworkServerTestSetup test = new NetworkServerTestSetup(suite, false);
        return TestConfiguration.defaultServerDecorator((Test)test);
    }

    public static Test clientServerDecoratorWithPort(Test suite, int port) {
        NetworkServerTestSetup test = new NetworkServerTestSetup(suite, false);
        return TestConfiguration.existingServerDecorator((Test)test, DEFAULT_HOSTNAME, port);
    }

    public static Test clientServerDecoratorWithAlternativePort(Test suite) {
        NetworkServerTestSetup test = new NetworkServerTestSetup(suite, false);
        return TestConfiguration.defaultServerDecoratorWithAlternativePort((Test)test);
    }

    public static Test defaultExistingServerDecorator(Test test) {
        if (!Derby.hasClient() || JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("empty: no network server support in JSR169 (or derbyclient.jar missing).");
        }
        ServerSetup r = new ServerSetup(test, DEFAULT_HOSTNAME, TestConfiguration.getCurrent().getPort());
        r.setJDBCClient(JDBCClient.DERBYNETCLIENT);
        return r;
    }

    public static Test defaultServerDecorator(Test test) {
        if (!TestConfiguration.supportsClientServer()) {
            return new BaseTestSuite("empty: no network server support");
        }
        return new ServerSetup(test, DEFAULT_HOSTNAME, TestConfiguration.getCurrent().getPort());
    }

    public static Test existingServerDecorator(Test test, String hostName, int PortNumber) {
        if (!TestConfiguration.supportsClientServer()) {
            return new BaseTestSuite("empty: no network server support");
        }
        ServerSetup r = new ServerSetup(test, hostName, PortNumber);
        r.setJDBCClient(JDBCClient.DERBYNETCLIENT);
        return r;
    }

    public static Test existingServerDecorator(Test test, String hostName, int PortNumber, String dbPath) {
        if (!TestConfiguration.supportsClientServer()) {
            return new BaseTestSuite("empty: no network server support");
        }
        ServerSetup r = new ServerSetup(test, hostName, PortNumber);
        r.setJDBCClient(JDBCClient.DERBYNETCLIENT);
        r.setDbPath(dbPath);
        return r;
    }

    public static Test defaultServerDecoratorWithAlternativePort(Test test) {
        if (!TestConfiguration.supportsClientServer()) {
            return new BaseTestSuite("empty: no network server support");
        }
        int port = TestConfiguration.getCurrent().getNextAvailablePort();
        return new ServerSetup(test, DEFAULT_HOSTNAME, port);
    }

    private static boolean supportsClientServer() {
        return JDBC.vmSupportsJDBC3() && Derby.hasClient() && Derby.hasServer();
    }

    private static Test bareClientServerSuite(Class testClass) {
        BaseTestSuite suite = new BaseTestSuite(TestConfiguration.suiteName(testClass) + ":client");
        if (TestConfiguration.supportsClientServer()) {
            suite.addTestSuite(testClass);
        }
        return suite;
    }

    public static synchronized String generateUniqueDatabaseName() {
        String dbName = "singleUse/oneuse";
        dbName = dbName.concat(Integer.toHexString(uniqueDB++));
        return dbName;
    }

    public static TestSetup singleUseDatabaseDecorator(Test test) {
        String dbName = TestConfiguration.generateUniqueDatabaseName();
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, dbName), dbName, dbName, true);
    }

    public static TestSetup singleUseDatabaseDecorator(Test test, String dbName) {
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, dbName), dbName, dbName, true);
    }

    public static TestSetup singleUseDatabaseDecoratorNoShutdown(Test test) {
        String dbName = TestConfiguration.generateUniqueDatabaseName();
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, dbName, false), dbName, dbName, true);
    }

    public static DatabaseChangeSetup additionalDatabaseDecorator(Test test, String logicalDbName) {
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, logicalDbName), logicalDbName, TestConfiguration.generateUniqueDatabaseName(), false);
    }

    public static DatabaseChangeSetup additionalDatabaseDecoratorNoShutdown(Test test, String logicalDbName) {
        return TestConfiguration.additionalDatabaseDecoratorNoShutdown(test, logicalDbName, false);
    }

    public static DatabaseChangeSetup additionalDatabaseDecoratorNoShutdown(Test test, String logicalDbName, boolean defaultDB) {
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, logicalDbName, false), logicalDbName, TestConfiguration.generateUniqueDatabaseName(), defaultDB);
    }

    public static DatabaseChangeSetup additionalDatabaseDecoratorNoShutdown(Test test, String logicalDbName, String physicalDbName) {
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, logicalDbName, false), logicalDbName, physicalDbName, false);
    }

    public static Test changeUserDecorator(Test test, String user, String password) {
        return new ChangeUserSetup(test, user, password);
    }

    public static Test sqlAuthorizationDecorator(Test test) {
        Properties sqlAuth = new Properties();
        sqlAuth.setProperty("derby.database.sqlAuthorization", "true");
        DatabasePropertyTestSetup setSQLAuthMode = DatabasePropertyTestSetup.getNoTeardownInstance(test, sqlAuth, true);
        return TestConfiguration.changeUserDecorator((Test)new DatabaseChangeSetup((Test)setSQLAuthMode, DEFAULT_DBNAME_SQL, DEFAULT_DBNAME_SQL, true), "TEST_DBO", "dummy");
    }

    public static Test sqlAuthorizationDecoratorSingleUse(Test test) {
        return TestConfiguration.sqlAuthorizationDecoratorSingleUse(test, DEFAULT_DBNAME_SQL, false);
    }

    public static Test sqlAuthorizationDecoratorSingleUse(Test test, String dbName, boolean shutdownDatabase) {
        Properties sqlAuth = new Properties();
        sqlAuth.setProperty("derby.database.sqlAuthorization", "true");
        TestSetup setSQLAuthMode = DatabasePropertyTestSetup.getNoTeardownInstance(test, sqlAuth, true);
        setSQLAuthMode = new DropDatabaseSetup((Test)setSQLAuthMode, dbName, shutdownDatabase);
        setSQLAuthMode = new DatabaseChangeSetup((Test)setSQLAuthMode, dbName, dbName, true);
        return TestConfiguration.changeUserDecorator((Test)setSQLAuthMode, "TEST_DBO", "dummy");
    }

    public static Test sqlAuthorizationDecorator(Test test, String[] users, String passwordToken) {
        String[] usersWithDBO = new String[users.length + 1];
        usersWithDBO[0] = "TEST_DBO";
        System.arraycopy(users, 0, usersWithDBO, 1, users.length);
        return TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.builtinAuthentication(test, usersWithDBO, passwordToken));
    }

    public static Test connectionCPDecorator(Test test) {
        if (JDBC.vmSupportsJDBC3()) {
            return new ConnectorSetup(test, "org.apache.derbyTesting.junit.ConnectionPoolDataSourceConnector");
        }
        return new BaseTestSuite("ConnectionPoolDataSource not supported");
    }

    public static Test connectionXADecorator(Test test) {
        if (JDBC.vmSupportsJDBC3()) {
            return new ConnectorSetup(test, "org.apache.derbyTesting.junit.XADataSourceConnector");
        }
        return new BaseTestSuite("XADataSource not supported");
    }

    public static TestSetup connectionDSDecorator(Test test) {
        return new ConnectorSetup(test, "org.apache.derbyTesting.junit.DataSourceConnector");
    }

    public static Test forceJDBC3Embedded(Test test) {
        if (JDBC.vmSupportsJDBC4()) {
            test = new JDBCClientSetup((Test)test, JDBCClient.EMBEDDED_30);
        }
        return test;
    }

    public static Test forceJDBC3NetClient(Test test) {
        if (JDBC.vmSupportsJDBC4() && test instanceof ServerSetup) {
            ((ServerSetup)test).setJDBCClient(JDBCClient.DERBYNETCLIENT_30);
        }
        return test;
    }

    public static Test changeSSLDecorator(Test test, String ssl) {
        return new ChangeSSLSetup(test, ssl);
    }

    private TestConfiguration() {
        String propDefDbName = TestConfiguration.getSystemProperties().getProperty("derby.tests.defaultDatabaseName");
        this.defaultDbName = propDefDbName != null ? propDefDbName : DEFAULT_DBNAME;
        this.usedDbNames.add(DEFAULT_DBNAME);
        this.logicalDbMapping.put(DEFAULT_DBNAME, DEFAULT_DBNAME);
        this.userName = "APP";
        this.userPassword = "APP";
        this.connectionAttributes = new Properties();
        this.hostName = DEFAULT_HOSTNAME;
        this.port = basePort;
        this.isVerbose = Boolean.valueOf(TestConfiguration.getSystemProperties().getProperty(KEY_VERBOSE));
        this.doTrace = Boolean.valueOf(TestConfiguration.getSystemProperties().getProperty(KEY_TRACE));
        this.stopAfterFirstFail = Boolean.valueOf(TestConfiguration.getSystemProperties().getProperty(KEY_STOP_AFTER_FIRST_FAIL));
        this.jdbcClient = JDBCClient.getDefaultEmbedded();
        this.ssl = null;
        this.jmxPort = this.getNextAvailablePort();
        this.println("basePort=" + basePort + ", bogusPort=" + bogusPort + ", jmxPort=" + this.jmxPort);
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(null);
    }

    TestConfiguration(TestConfiguration copy) {
        this.defaultDbName = copy.defaultDbName;
        this.usedDbNames.addAll(copy.usedDbNames);
        this.logicalDbMapping.putAll(copy.logicalDbMapping);
        this.userName = copy.userName;
        this.userPassword = copy.userPassword;
        this.connectionAttributes = new Properties(copy.connectionAttributes);
        this.isVerbose = copy.isVerbose;
        this.doTrace = copy.doTrace;
        this.port = copy.port;
        this.jmxPort = copy.jmxPort;
        this.jdbcClient = copy.jdbcClient;
        this.hostName = copy.hostName;
        this.ssl = copy.ssl;
        this.url = copy.url;
        this.initConnector(copy.connector);
    }

    TestConfiguration(TestConfiguration copy, JDBCClient client, String hostName, int port) {
        this.defaultDbName = copy.defaultDbName;
        this.usedDbNames.addAll(copy.usedDbNames);
        this.logicalDbMapping.putAll(copy.logicalDbMapping);
        this.userName = copy.userName;
        this.userPassword = copy.userPassword;
        this.connectionAttributes = new Properties(copy.connectionAttributes);
        this.isVerbose = copy.isVerbose;
        this.doTrace = copy.doTrace;
        this.port = port;
        this.jmxPort = copy.jmxPort;
        if (bogusPort == port) {
            throw new IllegalStateException("port cannot equal bogusPort: " + bogusPort);
        }
        this.jdbcClient = client;
        this.hostName = hostName;
        this.ssl = copy.ssl;
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(copy.connector);
    }

    TestConfiguration(TestConfiguration copy, JDBCClient client, String hostName, int port, String dataBasePath) {
        this.defaultDbName = dataBasePath;
        this.usedDbNames.addAll(copy.usedDbNames);
        this.logicalDbMapping.putAll(copy.logicalDbMapping);
        this.userName = copy.userName;
        this.userPassword = copy.userPassword;
        this.connectionAttributes = new Properties(copy.connectionAttributes);
        this.isVerbose = copy.isVerbose;
        this.doTrace = copy.doTrace;
        this.port = port;
        this.jmxPort = copy.jmxPort;
        if (bogusPort == port) {
            throw new IllegalStateException("port cannot equal bogusPort: " + bogusPort);
        }
        this.jdbcClient = client;
        this.hostName = hostName;
        this.ssl = copy.ssl;
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(copy.connector);
    }

    TestConfiguration(TestConfiguration copy, String user, String password, String passwordToken) {
        this.defaultDbName = copy.defaultDbName;
        this.usedDbNames.addAll(copy.usedDbNames);
        this.logicalDbMapping.putAll(copy.logicalDbMapping);
        this.userName = user;
        this.userPassword = password;
        this.passwordToken = passwordToken == null ? copy.passwordToken : passwordToken;
        this.connectionAttributes = new Properties(copy.connectionAttributes);
        this.isVerbose = copy.isVerbose;
        this.doTrace = copy.doTrace;
        this.port = copy.port;
        this.jmxPort = copy.jmxPort;
        this.jdbcClient = copy.jdbcClient;
        this.hostName = copy.hostName;
        this.ssl = copy.ssl;
        this.url = copy.url;
        this.initConnector(copy.connector);
    }

    TestConfiguration(TestConfiguration copy, String ssl) {
        this(copy);
        this.ssl = ssl;
    }

    TestConfiguration(TestConfiguration copy, String logicalDbName, String dbName, boolean defaultDb) {
        this.usedDbNames.addAll(copy.usedDbNames);
        this.usedDbNames.add(dbName);
        this.logicalDbMapping.putAll(copy.logicalDbMapping);
        Assert.assertNull((Object)this.logicalDbMapping.put(logicalDbName, dbName));
        this.defaultDbName = defaultDb ? dbName : copy.defaultDbName;
        this.userName = copy.userName;
        this.userPassword = copy.userPassword;
        this.connectionAttributes = new Properties(copy.connectionAttributes);
        this.isVerbose = copy.isVerbose;
        this.doTrace = copy.doTrace;
        this.port = copy.port;
        this.jmxPort = copy.jmxPort;
        this.jdbcClient = copy.jdbcClient;
        this.hostName = copy.hostName;
        this.ssl = copy.ssl;
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(copy.connector);
    }

    private TestConfiguration(Properties props) throws NumberFormatException {
        this.defaultDbName = props.getProperty(KEY_DBNAME, DEFAULT_DBNAME);
        this.usedDbNames.add(this.defaultDbName);
        this.logicalDbMapping.put(this.defaultDbName, this.defaultDbName);
        this.userName = props.getProperty(KEY_USER_NAME, "APP");
        this.userPassword = props.getProperty(KEY_USER_PASSWORD, "APP");
        this.connectionAttributes = new Properties();
        this.hostName = props.getProperty(KEY_HOSTNAME, DEFAULT_HOSTNAME);
        this.isVerbose = Boolean.valueOf(props.getProperty(KEY_VERBOSE));
        this.doTrace = Boolean.valueOf(props.getProperty(KEY_TRACE));
        this.port = basePort;
        this.jmxPort = this.getNextAvailablePort();
        this.println("basePort=" + basePort + ", bogusPort=" + bogusPort + ", jmxPort=" + this.jmxPort);
        this.ssl = props.getProperty(KEY_SSL);
        String framework = props.getProperty(KEY_FRAMEWORK, DEFAULT_FRAMEWORK);
        this.jdbcClient = "DerbyNetClient".equals(framework) ? JDBCClient.DERBYNETCLIENT : ("DerbyNet".equals(framework) ? JDBCClient.DB2CLIENT : JDBCClient.getDefaultEmbedded());
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(null);
    }

    TestConfiguration addConnectionAttributes(Properties attrs) {
        TestConfiguration copy = new TestConfiguration(this);
        Enumeration<?> e = attrs.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = attrs.getProperty(key);
            copy.connectionAttributes.setProperty(key, val);
        }
        copy.initConnector(this.connector);
        return copy;
    }

    public static final Properties getSystemProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
    }

    private String createJDBCUrlWithDatabaseName(String name) {
        if (JDBC.vmSupportsJDBC3()) {
            String url = this.jdbcClient.isEmbedded() ? this.jdbcClient.getUrlBase() : this.jdbcClient.getUrlBase() + this.hostName + ":" + this.port + "/";
            return url.concat(name);
        }
        return null;
    }

    private void initConnector(Connector oldConnector) {
        Class<?> clazz;
        if (oldConnector != null) {
            try {
                clazz = Class.forName(oldConnector.getClass().getName());
                this.connector = (Connector)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        } else if (JDBC.vmSupportsJDBC3()) {
            try {
                clazz = Class.forName("org.apache.derbyTesting.junit.DriverManagerConnector");
                this.connector = (Connector)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        } else {
            this.connector = new DataSourceConnector();
        }
        this.connector.setConfiguration(this);
        try {
            String loginTimeoutString = BaseTestCase.getSystemProperty(KEY_LOGIN_TIMEOUT);
            if (loginTimeoutString != null) {
                int loginTimeout = Integer.parseInt(loginTimeoutString);
                this.connector.setLoginTimeout(loginTimeout);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public JDBCClient getJDBCClient() {
        return this.jdbcClient;
    }

    public String getJDBCUrl() {
        return this.url;
    }

    public String getJDBCUrl(String databaseName) {
        return this.createJDBCUrlWithDatabaseName(databaseName);
    }

    public String getDefaultDatabaseName() {
        return this.defaultDbName;
    }

    public String getPhysicalDatabaseName(String logicalName) {
        return this.logicalDbMapping.get(logicalName);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public Properties getConnectionAttributes() {
        return this.connectionAttributes;
    }

    String getConnectionAttributesString() {
        StringBuffer sb = new StringBuffer();
        Enumeration<?> e = this.connectionAttributes.propertyNames();
        boolean first = true;
        while (e.hasMoreElements()) {
            if (!first) {
                sb.append(';');
            }
            String key = (String)e.nextElement();
            sb.append(key);
            sb.append('=');
            sb.append(this.connectionAttributes.getProperty(key));
            first = false;
        }
        if (first) {
            return null;
        }
        return sb.toString();
    }

    public String getHostName() {
        return this.hostName;
    }

    public static boolean isDefaultBasePort() {
        return basePort == 1527;
    }

    public static int getBasePort() {
        return basePort;
    }

    public int getPort() {
        return this.port;
    }

    public int getNextAvailablePort() {
        if (assignedPortCount + 1 > 22) {
            Assert.fail((String)("Port " + (lastAssignedPort + 1) + " exceeeds expected maximum. " + "You may need to update TestConfiguration.MAX_PORTS_USED and " + "the Wiki page at http://wiki.apache.org/db-derby/DerbyJUnitTesting " + "if test runs now require more available ports"));
        }
        int possiblePort = lastAssignedPort + 1;
        ++assignedPortCount;
        lastAssignedPort = possiblePort;
        return possiblePort;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public int getBogusPort() {
        return bogusPort;
    }

    public String getSsl() {
        return this.ssl;
    }

    public Connection openDefaultConnection() throws SQLException {
        return this.connector.openConnection();
    }

    Connection openDefaultConnection(String user, String password) throws SQLException {
        return this.connector.openConnection(user, password);
    }

    Connection openConnection(String logicalDatabaseName) throws SQLException {
        return this.connector.openConnection(this.getAndVetPhysicalDatabaseName(logicalDatabaseName));
    }

    private String getAndVetPhysicalDatabaseName(String logicalDatabaseName) throws SQLException {
        String databaseName = this.getPhysicalDatabaseName(logicalDatabaseName);
        if (this.usedDbNames.contains(databaseName)) {
            return databaseName;
        }
        throw new SQLException("Database name \"" + logicalDatabaseName + "\" is not in a list of used databases." + "Use method TestConfiguration.additionalDatabaseDecorator first.");
    }

    public Connection openConnection(String logicalDatabaseName, String user, String password) throws SQLException {
        return this.connector.openConnection(this.getAndVetPhysicalDatabaseName(logicalDatabaseName), user, password);
    }

    public Connection openPhysicalConnection(String physicalDatabaseName, String user, String password, Properties props) throws SQLException {
        return this.connector.openConnection(physicalDatabaseName, user, password, props);
    }

    public void shutdownDatabase() {
        try {
            this.connector.shutDatabase();
            Assert.fail((String)"Database failed to shut down");
        }
        catch (SQLException e) {
            BaseJDBCTestCase.assertSQLState("Database shutdown", "08006", e);
        }
    }

    public void shutdownEngine() {
        try {
            this.connector.shutEngine(true);
            Assert.fail((String)"Engine failed to shut down");
        }
        catch (SQLException e) {
            BaseJDBCTestCase.assertSQLState("Engine shutdown", "XJ015", e);
        }
    }

    public void shutdownEngine(boolean deregisterDeriver) {
        try {
            this.connector.shutEngine(deregisterDeriver);
            Assert.fail((String)"Engine failed to shut down");
        }
        catch (SQLException e) {
            BaseJDBCTestCase.assertSQLState("Engine shutdown", "XJ015", e);
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this.connector.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.connector.setLoginTimeout(seconds);
    }

    public void waitForShutdownComplete(String physicalDatabaseName) {
        String path = this.getDatabasePath(physicalDatabaseName);
        boolean lockfilepresent = true;
        int timeout = 300000;
        int totalsleep = 0;
        File lockfile = new File(path + File.separatorChar + "db.lck");
        File exlockfile = new File(path + File.separatorChar + "dbex.lck");
        while (lockfilepresent) {
            if (totalsleep >= timeout) {
                System.out.println("TestConfigruation.waitForShutdownComplete: been looping waiting for lock files to be deleted for at least 5 minutes, giving up");
                break;
            }
            if (lockfile.exists() || exlockfile.exists()) {
                try {
                    System.out.println("TestConfiguration.waitForShutdownComplete: db*.lck files not deleted after " + totalsleep + " ms.");
                    Thread.sleep(1000L);
                    totalsleep += 1000;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            lockfilepresent = false;
        }
    }

    public void stopNetworkServer() {
        try {
            NetworkServerControlWrapper networkServer = new NetworkServerControlWrapper();
            networkServer.shutdown();
            if (this.serverOutput != null) {
                this.serverOutput.close();
            }
        }
        catch (Exception e) {
            SQLException se = new SQLException("Error shutting down server");
            se.initCause(e);
        }
    }

    public void startNetworkServer() throws SQLException {
        Exception failException = null;
        try {
            NetworkServerControlWrapper networkServer = new NetworkServerControlWrapper();
            this.serverOutput = AccessController.doPrivileged(new PrivilegedAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() {
                    File logs = new File("logs");
                    logs.mkdir();
                    File console = new File(logs, "serverConsoleOutput.log");
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(console.getPath(), true);
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    return fos;
                }
            });
            networkServer.start(new PrintWriter(this.serverOutput));
            boolean started = false;
            int retries = 10;
            while (!started && retries > 0) {
                try {
                    Thread.sleep(1000L);
                    networkServer.ping();
                    started = true;
                }
                catch (Exception e) {
                    --retries;
                    failException = e;
                }
            }
            if (!started) {
                throw failException;
            }
        }
        catch (Exception e) {
            SQLException se = new SQLException("Error starting network  server");
            se.initCause(failException);
            throw se;
        }
    }

    public void setVerbosity(boolean isChatty) {
        this.isVerbose = isChatty;
    }

    public void setTrace(boolean isChatty) {
        this.doTrace = isChatty;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    private void println(CharSequence msg) {
        if (this.isVerbose) {
            System.out.println("DEBUG: {TC@" + this.hashCode() + "} " + msg);
        }
    }

    public boolean doTrace() {
        return this.doTrace;
    }

    public boolean stopAfterFirstFail() {
        return this.stopAfterFirstFail;
    }

    public static boolean loadingFromJars() {
        return SecurityManagerSetup.isJars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getFailureFolder(TestCase test) {
        StringBuffer sb = new StringBuffer();
        sb.append("fail");
        sb.append(File.separatorChar);
        sb.append(this.getJDBCClient().getName());
        sb.append(File.separatorChar);
        String className = test.getClass().getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(lastDot + 1, className.length());
        }
        sb.append(className);
        sb.append(File.separatorChar);
        char[] tmpName = test.getName().toCharArray();
        block6: for (int i = 0; i < tmpName.length; ++i) {
            switch (tmpName[i]) {
                case '-': 
                case '_': {
                    continue block6;
                }
                default: {
                    if (Character.isLetterOrDigit(tmpName[i])) continue block6;
                    tmpName[i] = 95;
                }
            }
        }
        sb.append(tmpName);
        String base = sb.toString().intern();
        final File folder = new File(base);
        String string = base;
        synchronized (string) {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    if (folder.exists()) {
                        // empty if block
                    }
                    return folder.mkdirs();
                }
            });
        }
        return folder;
    }

    boolean defaultSecurityManagerSetup() {
        if (this.jdbcClient.isDB2Client()) {
            SecurityManagerSetup.noSecurityManager();
            return false;
        }
        if ("<NONE>".equals(BaseTestCase.getSystemProperty("java.security.policy"))) {
            return false;
        }
        SecurityManagerSetup.installSecurityManager();
        return true;
    }

    static final String getPassword(String user, String token) {
        return user.concat(token);
    }

    public final String getPassword(String user) {
        return TestConfiguration.getPassword(user, this.passwordToken);
    }

    public final String getDatabasePath(String physicalDatabaseName) {
        String dbName = physicalDatabaseName.replace('/', File.separatorChar);
        String dsh = BaseTestCase.getSystemProperty("derby.system.home");
        if (dsh == null) {
            Assert.fail((String)"not implemented");
        } else {
            dbName = dsh + File.separator + dbName;
        }
        return dbName;
    }

    static {
        String port = BaseTestCase.getSystemProperty("derby.tests.basePort");
        lastAssignedPort = port == null ? 1527 : Integer.parseInt(port);
        basePort = lastAssignedPort++;
        bogusPort = lastAssignedPort;
        assignedPortCount = 2;
        DEFAULT_CONFIG = JUNIT_CONFIG = new TestConfiguration();
        File dsh = new File("system");
        BaseTestCase.setSystemProperty("derby.system.home", dsh.getAbsolutePath());
        CURRENT_CONFIG = new ThreadLocal<TestConfiguration>(){

            @Override
            protected TestConfiguration initialValue() {
                return DEFAULT_CONFIG;
            }
        };
    }
}

