/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.optimizer.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.derbyTesting.system.optimizer.StaticValues;
import org.apache.derbyTesting.system.optimizer.utils.TestUtils;

public class GenericQuery {
    protected String description = "Custom Test Query";
    protected Connection conn = null;
    protected ArrayList<String> queries = new ArrayList();
    protected ArrayList<String[]> prepStmtRunResults = new ArrayList();
    protected ArrayList<String[]> stmtRunResults = new ArrayList();
    protected int[] rowsExpected = null;

    public void setConnection(Connection con) {
        this.conn = con;
    }

    public void generateQueries() {
    }

    public void generateQueries(Properties prop) {
        Enumeration<Object> qenum = prop.keys();
        while (qenum.hasMoreElements()) {
            String queryName = (String)qenum.nextElement();
            this.queries.add(prop.getProperty(queryName));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void executeQueries(boolean prepare, boolean verbose) throws SQLException {
        this.rowsExpected = new int[this.queries.size()];
        String query = "";
        if (prepare) {
            if (verbose) {
                System.out.println("=====================> Using java.sql.PreparedStatement <====================");
            }
        } else if (verbose) {
            System.out.println("=====================> Using java.sql.Statement <====================");
        }
        try {
            for (int k = 0; k < this.queries.size(); ++k) {
                query = this.queries.get(k);
                String[] times = new String[StaticValues.ITER];
                int rowsReturned = 0;
                for (int i = 0; i < StaticValues.ITER; ++i) {
                    Statement stmt = null;
                    ResultSet rs = null;
                    PreparedStatement pstmt = null;
                    if (prepare) {
                        pstmt = this.conn.prepareStatement(query);
                    } else {
                        stmt = this.conn.createStatement();
                    }
                    long start = System.currentTimeMillis();
                    rs = prepare ? pstmt.executeQuery() : stmt.executeQuery(query);
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int totalCols = rsmd.getColumnCount();
                    while (rs.next()) {
                        String row = "";
                        for (int j = 1; j <= totalCols; ++j) {
                            row = row + rs.getString(j) + " | ";
                        }
                        ++rowsReturned;
                    }
                    long time_taken = System.currentTimeMillis() - start;
                    if (verbose) {
                        System.out.println("Time required to execute:");
                        System.out.println(query);
                        System.out.println("Total Rows returned = " + rowsReturned);
                        System.out.println("==> " + time_taken + " milliseconds " + " OR " + TestUtils.getTime(time_taken));
                    }
                    times[i] = TestUtils.getTime(time_taken);
                    rs.close();
                    if (prepare) {
                        pstmt.close();
                    } else {
                        stmt.close();
                    }
                    this.rowsExpected[k] = rowsReturned;
                    rowsReturned = 0;
                }
                if (prepare) {
                    this.prepStmtRunResults.add(times);
                    continue;
                }
                this.stmtRunResults.add(times);
            }
        }
        catch (SQLException sqe) {
            throw new SQLException("Failed query:\n " + query + "\n SQLState= " + sqe.getSQLState() + "\n ErrorCode= " + sqe.getErrorCode() + "\n Message= " + sqe.getMessage());
        }
    }

    public ArrayList<String[]> getPrepStmtRunResults() {
        return this.prepStmtRunResults;
    }

    public ArrayList<String[]> getStmtRunResults() {
        return this.stmtRunResults;
    }

    public int getRowsExpected(int index) {
        return this.rowsExpected[index];
    }

    public ArrayList getQueries() {
        return this.queries;
    }
}

