/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.index.B2I;
import org.apache.derby.impl.store.access.btree.index.B2IController;
import org.apache.derby.impl.store.access.btree.index.B2IForwardScan;
import org.apache.derby.impl.store.access.conglomerate.TemplateRow;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiIterations;
import org.apache.derbyTesting.unitTests.store.T_ColumnOrderingImpl;
import org.apache.derbyTesting.unitTests.store.T_CreateConglomRet;
import org.apache.derbyTesting.unitTests.store.T_QualifierTest;
import org.apache.derbyTesting.unitTests.store.T_SecondaryIndexRow;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_b2i
extends T_MultiIterations {
    private static final String testService = "b2iTest";
    private Object store_module = null;
    private ContextService contextService = null;

    @Override
    protected void setupTest() throws T_Fail {
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            this.store_module = T_b2i.createPersistentService(this.getModuleToTestProtocolName(), testService, this.startParams);
            this.contextService = T_b2i.getContextService();
        }
        catch (StandardException mse) {
            throw T_Fail.exceptionFail(mse);
        }
    }

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.access.AccessFactory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTestSet() throws T_Fail {
        AccessFactory store = null;
        TransactionController tc = null;
        boolean pass = false;
        this.out.println("executing b2i test");
        store = (AccessFactory)this.store_module;
        if (store == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
        }
        ContextManager cm1 = this.contextService.newContextManager();
        this.contextService.setCurrentContextManager(cm1);
        this.REPORT("(unitTestMain) Testing b2iTest");
        try {
            tc = store.getTransaction(cm1);
            pass = true;
            if (this.t_005(tc) && this.t_001(tc) && this.t_003(tc) && this.t_004(tc) && this.t_005(tc) && this.t_006(tc) && this.t_009(tc) && this.t_010(tc) && this.t_011(tc) && this.t_012(tc) && this.t_013(tc) && this.t_014(tc) && this.t_017(tc) && this.t_018(tc) && this.t_019(tc) && this.t_020(tc) && this.t_021(tc)) {
                pass = true;
            }
            tc.commit();
            tc.destroy();
        }
        catch (StandardException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = ((Object)((Object)e)).getClass().getName();
            }
            this.REPORT(msg);
            e.printStackTrace(this.out.getPrintWriter());
            cm1.cleanupOnError((Throwable)e, this.isdbActive());
            pass = false;
        }
        catch (Throwable t) {
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.getClass().getName();
            }
            this.REPORT(msg);
            t.printStackTrace(this.out.getPrintWriter());
            cm1.cleanupOnError(t, this.isdbActive());
            pass = false;
        }
        finally {
            this.contextService.resetCurrentContextManager(cm1);
        }
        if (!pass) {
            throw T_Fail.testFailMsg("");
        }
    }

    void createCongloms(TransactionController tc, int num_cols, boolean unique, boolean varying_first_col, int max_btreerows_per_page, T_CreateConglomRet ret_val) throws StandardException {
        T_SecondaryIndexRow index_row = new T_SecondaryIndexRow();
        DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)num_cols);
        if (varying_first_col) {
            SQLChar string_col = new SQLChar();
            base_row[0] = string_col;
        }
        long base_conglomid = 0L;
        base_conglomid = tc.createConglomerate("heap", base_row, null, null, null, 0);
        ConglomerateController base_cc = tc.openConglomerate(base_conglomid, false, 4, 6, 5);
        RowLocation base_rowloc = base_cc.newRowLocationTemplate();
        index_row.init(base_row, base_rowloc, num_cols + 1);
        Properties properties = T_b2i.createProperties(null, false, num_cols + 1, unique ? num_cols : num_cols + 1, true, base_conglomid, num_cols);
        if (max_btreerows_per_page > 1 && BTree.PROPERTY_MAX_ROWS_PER_PAGE_PARAMETER != null) {
            properties.put(BTree.PROPERTY_MAX_ROWS_PER_PAGE_PARAMETER, String.valueOf(max_btreerows_per_page));
        }
        long index_conglomid = tc.createConglomerate("BTREE", index_row.getRow(), null, null, properties, 0);
        ret_val.base_conglomid = base_conglomid;
        ret_val.index_conglomid = index_conglomid;
        ret_val.index_template_row = index_row.getRow();
    }

    protected static Properties createProperties(Properties input_properties, boolean input_allowduplicates, int input_nkeyfields, int input_nuniquecolumns, boolean input_maintainparentlinks, long input_baseconglomerateid, int input_rowlocationcolumn) throws StandardException {
        Properties properties = input_properties == null ? new Properties() : input_properties;
        properties.put("allowDuplicates", String.valueOf(input_allowduplicates));
        properties.put("nKeyFields", String.valueOf(input_nkeyfields));
        properties.put("nUniqueColumns", String.valueOf(input_nuniquecolumns));
        properties.put("maintainParentLinks", String.valueOf(input_maintainparentlinks));
        properties.put("baseConglomerateId", String.valueOf(input_baseconglomerateid));
        properties.put("rowLocationColumn", String.valueOf(input_rowlocationcolumn));
        return properties;
    }

    protected boolean t_scan(TransactionController tc, long conglomid, DataValueDescriptor[] template, DataValueDescriptor[] start_key, int start_op, Qualifier[][] qualifier, DataValueDescriptor[] stop_key, int stop_op, int expect_numrows, int expect_key) throws StandardException {
        ScanController scan = tc.openScan(conglomid, false, 4, 6, 5, (FormatableBitSet)null, start_key, start_op, qualifier, stop_key, stop_op);
        long key = -42L;
        long numrows = 0L;
        while (scan.next()) {
            scan.fetch(template);
            key = ((SQLLongint)template[2]).getLong();
            if (key != (long)expect_key) {
                return this.FAIL("(t_scan) wrong key, expected (" + expect_key + ")" + "but got (" + key + ").");
            }
            ++expect_key;
            ++numrows;
        }
        ((B2IForwardScan)scan).checkConsistency();
        scan.close();
        if (numrows != (long)expect_numrows) {
            return this.FAIL("(t_scan) wrong number of rows. Expected " + expect_numrows + " rows, but got " + numrows + "rows.");
        }
        return true;
    }

    protected boolean t_delete(TransactionController tc, long conglomid, DataValueDescriptor[] search_key, boolean useUpdateLocks) throws StandardException {
        SQLLongint column0 = new SQLLongint(-1L);
        SQLLongint column1 = new SQLLongint(-1L);
        int openmode = 4;
        if (useUpdateLocks) {
            openmode |= 0x1000;
        }
        ScanController scan = tc.openScan(conglomid, false, openmode, 6, 5, (FormatableBitSet)null, search_key, 1, (Qualifier[][])null, search_key, -1);
        long expect_key = ((SQLLongint)search_key[1]).getLong();
        int numrows = 0;
        DataValueDescriptor[] partialRow = new DataValueDescriptor[]{column0, column1};
        while (scan.next()) {
            ++numrows;
            scan.fetch(partialRow);
            if (column0.getLong() != 1L) {
                return this.FAIL("(t_delete) column[0] value is not 1");
            }
            if (column1.getLong() != expect_key) {
                return this.FAIL("(t_delete) column[1]  value is not " + expect_key);
            }
            if (!scan.delete()) {
                return this.FAIL("(t_delete): delete of row failed");
            }
            if (!scan.delete()) continue;
            return this.FAIL("(t_delete): re-delete of row succeeded");
        }
        scan.close();
        if (numrows != 1) {
            return this.FAIL("(t_delete) wrong number of rows. Expected 1 row, but got " + numrows + "rows.");
        }
        return true;
    }

    protected boolean t_001(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("Starting t_001");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, false, 0, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        if (!(index_cc instanceof B2IController)) {
            throw T_Fail.testFailMsg("openConglomerate returned wrong type");
        }
        if (!index_cc.isKeyed()) {
            throw T_Fail.testFailMsg("btree is not keyed.");
        }
        index_cc.checkConsistency();
        DataValueDescriptor[] r1 = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow index_row1 = new T_SecondaryIndexRow();
        RowLocation base_rowloc1 = base_cc.newRowLocationTemplate();
        index_row1.init(r1, base_rowloc1, 3);
        ((SQLLongint)r1[0]).setValue(2);
        ((SQLLongint)r1[1]).setValue(2);
        base_cc.insertAndFetchLocation(r1, base_rowloc1);
        if (index_cc.insert(index_row1.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        DataValueDescriptor[] r2 = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow index_row2 = new T_SecondaryIndexRow();
        RowLocation base_rowloc2 = base_cc.newRowLocationTemplate();
        index_row2.init(r2, base_rowloc2, 3);
        if (!base_cc.fetch(base_rowloc1, r2, (FormatableBitSet)null)) {
            return this.FAIL("(t_001) insert into base table failed");
        }
        if (((SQLLongint)r2[0]).getLong() != 2L || ((SQLLongint)r2[1]).getLong() != 2L) {
            return this.FAIL("(t_001) insert into base table failed");
        }
        ScanController scan = tc.openScan(create_ret.index_conglomid, false, 4, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
        scan.next();
        scan.fetch(index_row2.getRow());
        if (scan.isCurrentPositionDeleted()) {
            throw T_Fail.testFailMsg("current row should not be deleted\n");
        }
        if (!scan.doesCurrentPositionQualify()) {
            throw T_Fail.testFailMsg("current row should still qualify\n");
        }
        scan.delete();
        if (!scan.isCurrentPositionDeleted()) {
            throw T_Fail.testFailMsg("current row should be deleted\n");
        }
        if (scan.doesCurrentPositionQualify()) {
            throw T_Fail.testFailMsg("deleted row should not qualify\n");
        }
        this.REPORT("Calling scan.tostring(): " + scan);
        if (scan.next() || ((SQLLongint)index_row2.getRow()[0]).getLong() != 2L || ((SQLLongint)index_row2.getRow()[1]).getLong() != 2L) {
            return this.FAIL("(t_001) insert into index failed in base cols");
        }
        ScanInfo scan_info = scan.getScanInfo();
        Properties prop = scan_info.getAllScanInfo(null);
        if (Integer.parseInt(prop.getProperty(MessageService.getTextMessage((String)"XSAJ1.U", (Object[])new Object[0]))) != 1) {
            throw T_Fail.testFailMsg("(scanInfo) wrong numPagesVisited.  Expected 1, got " + Integer.parseInt(prop.getProperty(MessageService.getTextMessage((String)"XSAJ1.U", (Object[])new Object[0]))));
        }
        if (Integer.parseInt(prop.getProperty(MessageService.getTextMessage((String)"XSAJ2.U", (Object[])new Object[0]))) != 1) {
            throw T_Fail.testFailMsg("(scanInfo) wrong numRowsVisited. Expected 1, got " + Integer.parseInt(prop.getProperty(MessageService.getTextMessage((String)"XSAJ2.U", (Object[])new Object[0]))));
        }
        if (Integer.parseInt(prop.getProperty(MessageService.getTextMessage((String)"XSAJ4.U", (Object[])new Object[0]))) != 1) {
            throw T_Fail.testFailMsg("(scanInfo) wrong numRowsQualified. Expected 1, got " + Integer.parseInt(prop.getProperty(MessageService.getTextMessage((String)"XSAJ4.U", (Object[])new Object[0]))));
        }
        int compare_result = base_rowloc1.compare((DataValueDescriptor)base_rowloc2);
        if (compare_result != 0) {
            return this.FAIL("(t_001) insert into index failed in recordhandle.\n\texpected RecordHandle = " + base_rowloc1 + "\n" + "\tgot      RecordHandle = " + base_rowloc2 + "\tcompare result = " + compare_result);
        }
        index_cc.checkConsistency();
        base_cc.close();
        index_cc.close();
        try {
            base_cc.insert(r1);
            return this.FAIL("(t_001) insert on closed conglomerate worked");
        }
        catch (StandardException standardException) {
            try {
                if (index_cc.insert(r1) != 0) {
                    throw T_Fail.testFailMsg("insert failed");
                }
                return this.FAIL("(t_001) insert on closed conglomerate worked");
            }
            catch (StandardException standardException2) {
                tc.commit();
                this.REPORT("Ending t_001");
                return true;
            }
        }
    }

    protected boolean t_002(TransactionController tc) throws StandardException, T_Fail {
        ScanController scan = null;
        this.REPORT("Starting t_002");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, false, 2, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        if (!(index_cc instanceof B2IController)) {
            throw T_Fail.testFailMsg("openConglomerate returned wrong type");
        }
        index_cc.checkConsistency();
        DataValueDescriptor[] r1 = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow index_row1 = new T_SecondaryIndexRow();
        RowLocation base_rowloc1 = base_cc.newRowLocationTemplate();
        index_row1.init(r1, base_rowloc1, 3);
        tc.commit();
        String[] debug_strings = new String[]{"leaf_split_growRoot1", "leaf_split_growRoot2", "leaf_split_growRoot3", "leaf_split_growRoot4", "leaf_split_growRoot5", "leaf_split_abort1", "leaf_split_abort2", "leaf_split_abort3", "leaf_split_abort4", "branch_split_abort1", "branch_split_abort2", "branch_split_abort3", "branch_split_abort4", "BTreeController_doIns2"};
        for (int errs = 0; errs < debug_strings.length; ++errs) {
            this.REPORT("Doing abort test: " + debug_strings[errs]);
            try {
                base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
                index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
                ((SQLLongint)r1[0]).setValue(2);
                ((SQLLongint)r1[1]).setValue(10000 + errs);
                base_cc.insertAndFetchLocation(r1, base_rowloc1);
                if (index_cc.insert(index_row1.getRow()) != 0) {
                    throw T_Fail.testFailMsg("insert failed");
                }
                for (int i = 100; i > 0; i -= 2) {
                    ((SQLLongint)r1[0]).setValue(2);
                    ((SQLLongint)r1[1]).setValue(i);
                    base_cc.insertAndFetchLocation(r1, base_rowloc1);
                    if (index_cc.insert(index_row1.getRow()) == 0) continue;
                    throw T_Fail.testFailMsg("insert failed");
                }
                throw T_Fail.testFailMsg("debug flag (" + debug_strings[errs] + ")did not cause exception.");
            }
            catch (StandardException e) {
                ContextService contextFactory = T_b2i.getContextService();
                ContextManager cm = contextFactory.getCurrentContextManager();
                cm.cleanupOnError((Throwable)e, this.isdbActive());
                scan = tc.openScan(create_ret.index_conglomid, false, 4, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
                index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
                index_cc.checkConsistency();
                index_cc.close();
                if (scan.next()) {
                    throw T_Fail.testFailMsg("t_002: there are still rows in table.");
                }
                scan.close();
                continue;
            }
        }
        tc.commit();
        base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        for (int i = 0; i < 3; ++i) {
            ((SQLLongint)r1[0]).setValue(2);
            ((SQLLongint)r1[1]).setValue(i);
            base_cc.insertAndFetchLocation(r1, base_rowloc1);
            if (index_cc.insert(index_row1.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        tc.abort();
        ScanController empty_scan = tc.openScan(create_ret.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
        if (empty_scan.next()) {
            throw T_Fail.testFailMsg("t_002: there are still rows in table.");
        }
        tc.commit();
        this.REPORT("Ending t_002");
        return true;
    }

    private boolean t_003_scan_test_cases(TransactionController tc, long index_conglomid, T_SecondaryIndexRow template) throws StandardException, T_Fail {
        boolean ret_val = true;
        DataValueDescriptor[] start_key = TemplateRow.newU8Row((int)1);
        DataValueDescriptor[] stop_key = TemplateRow.newU8Row((int)1);
        this.REPORT("scan (x = 5)");
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 3, 16, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x > 5)");
        ((SQLLongint)start_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, -1, null, null, 0, 3, 19, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x >= 5)");
        ((SQLLongint)start_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, null, 0, 6, 16, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x <= 5)");
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), null, 0, null, stop_key, -1, 8, 11, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x < 5)");
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), null, 0, null, stop_key, 1, 5, 11, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x >= 5 and x <= 7)");
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(7);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 5, 16, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 5 and y > 2)");
        start_key = TemplateRow.newU8Row((int)2);
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)start_key[1]).setValue(2);
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, -1, null, stop_key, -1, 2, 17, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 5 and y >= 2)");
        start_key = TemplateRow.newU8Row((int)2);
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)start_key[1]).setValue(2);
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 3, 16, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 5 and y < 5)");
        start_key = TemplateRow.newU8Row((int)1);
        stop_key = TemplateRow.newU8Row((int)2);
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(5);
        ((SQLLongint)stop_key[1]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, 1, 2, 16, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 2)");
        start_key = TemplateRow.newU8Row((int)1);
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(2);
        ((SQLLongint)stop_key[0]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 0, 0, 1)) {
            ret_val = false;
        }
        this.REPORT("max on btree, row locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 6, 5, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        long key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 21L) {
            throw T_Fail.testFailMsg("wrong max found.");
        }
        this.REPORT("max on btree, table locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 7, 5, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 21L) {
            throw T_Fail.testFailMsg("wrong max found.");
        }
        this.REPORT("max on btree, row locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 6, 2, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 21L) {
            throw T_Fail.testFailMsg("wrong max found.");
        }
        this.REPORT("max on btree, table locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 7, 2, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 21L) {
            throw T_Fail.testFailMsg("wrong max found.");
        }
        return ret_val;
    }

    protected boolean t_003(TransactionController tc) throws StandardException, T_Fail {
        int i;
        T_SecondaryIndexRow index_row = new T_SecondaryIndexRow();
        DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)4);
        base_row[3] = new SQLChar();
        String string_1500char = new String();
        for (int i2 = 0; i2 < 300; ++i2) {
            string_1500char = string_1500char + "mikem";
        }
        boolean ret_val = true;
        long value = -1L;
        long[] col1 = new long[]{1L, 3L, 4L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 9L};
        long[] col2 = new long[]{1L, 1L, 2L, 4L, 6L, 2L, 4L, 6L, 1L, 1L, 1L};
        long[] col3 = new long[]{11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L};
        long[] d_col1 = new long[]{0L, 2L, 3L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 8L, 10L, 11L, 12L};
        long[] d_col2 = new long[]{1L, 1L, 2L, 3L, 5L, 0L, 3L, 5L, 0L, 0L, 1L, 42L, 42L, 1L};
        long[] d_col3 = new long[]{91L, 92L, 93L, 94L, 95L, 96L, 97L, 98L, 99L, 100L, 101L, 102L, 103L, 104L};
        this.REPORT("Starting t_003");
        long base_conglomid = tc.createConglomerate("heap", base_row, null, null, null, 0);
        ConglomerateController base_cc = tc.openConglomerate(base_conglomid, false, 4, 6, 5);
        index_row.init(base_row, base_cc.newRowLocationTemplate(), 5);
        Properties properties = T_b2i.createProperties(null, false, 5, 5, true, base_conglomid, 4);
        long index_conglomid = tc.createConglomerate("BTREE", index_row.getRow(), null, null, properties, 0);
        ConglomerateController index_cc = tc.openConglomerate(index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow template = new T_SecondaryIndexRow();
        RowLocation row_loc = base_cc.newRowLocationTemplate();
        template.init(base_row, row_loc, 5);
        for (i = col1.length - 1; i >= 0; --i) {
            ((SQLLongint)template.getRow()[0]).setValue(col1[i]);
            ((SQLLongint)template.getRow()[1]).setValue(col2[i]);
            ((SQLLongint)template.getRow()[2]).setValue(col3[i]);
            base_row[3] = new SQLChar(string_1500char);
            base_cc.insertAndFetchLocation(base_row, row_loc);
            if (index_cc.insert(template.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        index_cc.checkConsistency();
        ((B2IController)index_cc).debugConglomerate();
        ret_val = this.t_003_scan_test_cases(tc, index_conglomid, template);
        for (i = d_col1.length - 1; i >= 0; --i) {
            ((SQLLongint)template.getRow()[0]).setValue(d_col1[i]);
            ((SQLLongint)template.getRow()[1]).setValue(d_col2[i]);
            ((SQLLongint)template.getRow()[2]).setValue(d_col3[i]);
            base_row[3] = new SQLChar(string_1500char);
            base_cc.insertAndFetchLocation(base_row, row_loc);
            if (index_cc.insert(template.getRow()) != 0) {
                throw T_Fail.testFailMsg("insert failed");
            }
            base_cc.delete(row_loc);
            ScanController delete_scan = tc.openScan(index_conglomid, false, 4, 6, 5, (FormatableBitSet)null, template.getRow(), 1, (Qualifier[][])null, template.getRow(), -1);
            if (!delete_scan.next()) {
                throw T_Fail.testFailMsg("delete could not find key");
            }
            delete_scan.delete();
            if (delete_scan.next()) {
                throw T_Fail.testFailMsg("delete found more than one key");
            }
            delete_scan.close();
        }
        ret_val = this.t_003_scan_test_cases(tc, index_conglomid, template);
        index_cc.close();
        tc.commit();
        this.REPORT("Ending t_003");
        return ret_val;
    }

    protected boolean t_004(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("Starting t_004");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, false, 0, create_ret);
        Properties properties = T_b2i.createProperties(null, false, 4, 4, true, create_ret.base_conglomid, 3);
        T_QualifierTest q_test = new T_QualifierTest("BTREE", properties, false, this.out, 1);
        boolean test_result = q_test.t_testqual(tc);
        this.REPORT("Ending t_004");
        return test_result;
    }

    protected boolean t_005(TransactionController tc) throws StandardException, T_Fail {
        int i;
        int i2;
        int i3;
        boolean ret_val = true;
        this.REPORT("Starting t_005");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, false, 0, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow index_row = new T_SecondaryIndexRow();
        RowLocation rowloc = base_cc.newRowLocationTemplate();
        DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)2);
        index_row.init(base_row, rowloc, 3);
        for (i3 = 200; i3 >= 0; i3 -= 4) {
            ((SQLLongint)base_row[0]).setValue(1);
            ((SQLLongint)base_row[1]).setValue(i3);
            base_cc.insertAndFetchLocation(base_row, rowloc);
            if (index_cc.insert(index_row.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        for (i3 = 199; i3 >= 0; i3 -= 4) {
            ((SQLLongint)base_row[0]).setValue(1);
            ((SQLLongint)base_row[1]).setValue(i3);
            base_cc.insertAndFetchLocation(base_row, rowloc);
            if (index_cc.insert(index_row.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        index_cc.checkConsistency();
        index_cc.close();
        tc.commit();
        DataValueDescriptor[] delete_key = TemplateRow.newU8Row((int)2);
        for (i2 = 200; i2 >= 0; i2 -= 4) {
            ((SQLLongint)delete_key[0]).setValue(1);
            ((SQLLongint)delete_key[1]).setValue(i2);
            if (this.t_delete(tc, create_ret.index_conglomid, delete_key, false)) continue;
            ret_val = false;
        }
        for (i2 = 199; i2 >= 0; i2 -= 4) {
            ((SQLLongint)delete_key[0]).setValue(1);
            ((SQLLongint)delete_key[1]).setValue(i2);
            if (this.t_delete(tc, create_ret.index_conglomid, delete_key, false)) continue;
            ret_val = false;
        }
        tc.commit();
        base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        RawStoreFactory rawstore = (RawStoreFactory)T_b2i.findServiceModule(this.store_module, "org.apache.derby.iapi.store.raw.RawStoreFactory");
        rawstore.idle();
        for (i = 200; i >= 0; i -= 3) {
            ((SQLLongint)base_row[0]).setValue(1);
            ((SQLLongint)base_row[1]).setValue(i);
            base_cc.insertAndFetchLocation(base_row, rowloc);
            if (index_cc.insert(index_row.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        for (i = 200; i >= 0; i -= 3) {
            ((SQLLongint)delete_key[0]).setValue(1);
            ((SQLLongint)delete_key[1]).setValue(i);
            if (this.t_delete(tc, create_ret.index_conglomid, delete_key, false)) continue;
            ret_val = false;
        }
        ScanController empty_scan = tc.openScan(create_ret.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
        if (empty_scan.next()) {
            throw T_Fail.testFailMsg("t_005: there are still rows in table.");
        }
        index_cc.checkConsistency();
        for (int i4 = 600; i4 >= 400; i4 -= 3) {
            ((SQLLongint)base_row[0]).setValue(1);
            ((SQLLongint)base_row[1]).setValue(i4);
            base_cc.insertAndFetchLocation(base_row, rowloc);
            if (index_cc.insert(index_row.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        index_cc.checkConsistency();
        tc.abort();
        empty_scan = tc.openScan(create_ret.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
        if (empty_scan.next()) {
            throw T_Fail.testFailMsg("t_005: there are still rows in table.");
        }
        this.REPORT("Ending t_005");
        return ret_val;
    }

    protected boolean t_006(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("Starting t_006");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, false, 0, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)2);
        RowLocation base_rowloc = base_cc.newRowLocationTemplate();
        T_SecondaryIndexRow index_row_from_base_row = new T_SecondaryIndexRow();
        index_row_from_base_row.init(base_row, base_rowloc, 3);
        ((SQLLongint)base_row[0]).setValue(1);
        T_SecondaryIndexRow index_row = new T_SecondaryIndexRow();
        index_row.init(TemplateRow.newU8Row((int)2), base_cc.newRowLocationTemplate(), 3);
        ((SQLLongint)base_row[1]).setValue(1000);
        base_cc.insertAndFetchLocation(base_row, base_rowloc);
        if (index_cc.insert(index_row_from_base_row.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        try {
            index_cc.delete(null);
            return this.FAIL("t_006: ConglomerateController.delete() succeeded.");
        }
        catch (StandardException standardException) {
            try {
                if (!index_cc.fetch(null, RowUtil.EMPTY_ROW, (FormatableBitSet)null)) {
                    return this.FAIL("t_006: ConglomerateController.fetch() bad ret.");
                }
                return this.FAIL("t_006: ConglomerateController.fetch() succeeded.");
            }
            catch (StandardException standardException2) {
                try {
                    index_cc.insertAndFetchLocation((DataValueDescriptor[])null, null);
                    return this.FAIL("t_006: ConglomerateController.insertAndFetchLocation() succeeded.");
                }
                catch (StandardException standardException3) {
                    try {
                        RowLocation rowloc2 = index_cc.newRowLocationTemplate();
                        return this.FAIL("t_006: ConglomerateController.newRowLocationTemplate() succeeded.");
                    }
                    catch (StandardException rowloc2) {
                        try {
                            index_cc.replace(null, null, null);
                            return this.FAIL("t_006: ConglomerateController.replace() succeeded.");
                        }
                        catch (StandardException rowloc2) {
                            index_cc.close();
                            ScanController scan = tc.openScan(create_ret.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
                            int numrows = 0;
                            while (scan.next()) {
                                ++numrows;
                                scan.fetch(index_row_from_base_row.getRow());
                                try {
                                    scan.fetchLocation(null);
                                    return this.FAIL("t_006: scan.fetchLocation() succeeded");
                                }
                                catch (StandardException standardException4) {
                                    try {
                                        RowLocation rowloc3 = scan.newRowLocationTemplate();
                                        return this.FAIL("t_006: scan.newRowLocationTemplate() succeeded");
                                    }
                                    catch (StandardException standardException5) {
                                        try {
                                            scan.replace(index_row_from_base_row.getRow(), (FormatableBitSet)null);
                                            return this.FAIL("t_006: scan.replace() succeeded");
                                        }
                                        catch (StandardException standardException6) {
                                        }
                                    }
                                }
                            }
                            if (scan.next()) {
                                return this.FAIL("t_006: scan.next() returned true after false.");
                            }
                            scan.close();
                            if (numrows != 1) {
                                return this.FAIL("(t_scan) wrong number of rows. Expected 1 row, but got " + numrows + "rows.");
                            }
                            this.REPORT("Ending t_006");
                            return true;
                        }
                    }
                }
            }
        }
    }

    protected boolean t_007(TransactionController tc) throws StandardException, T_Fail {
        boolean ret_val = true;
        this.REPORT("Starting t_007");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, false, 0, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow index_row = new T_SecondaryIndexRow();
        DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)2);
        RowLocation row_loc = base_cc.newRowLocationTemplate();
        index_row.init(base_row, row_loc, 3);
        ((SQLLongint)index_row.getRow()[0]).setValue(1);
        ((SQLLongint)index_row.getRow()[1]).setValue(3);
        base_cc.insertAndFetchLocation(base_row, row_loc);
        if (index_cc.insert(index_row.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLLongint)index_row.getRow()[1]).setValue(5);
        base_cc.insertAndFetchLocation(base_row, row_loc);
        if (index_cc.insert(index_row.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        ScanController scan = tc.openScan(create_ret.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
        scan.fetch(index_row.getRow());
        long key = ((SQLLongint)index_row.getRow()[1]).getLong();
        ((SQLLongint)index_row.getRow()[1]).setValue(1);
        base_cc.insertAndFetchLocation(base_row, row_loc);
        if (index_cc.insert(index_row.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLLongint)index_row.getRow()[1]).setValue(2);
        base_cc.insertAndFetchLocation(base_row, row_loc);
        if (index_cc.insert(index_row.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        scan.fetch(index_row.getRow());
        key = ((SQLLongint)index_row.getRow()[1]).getLong();
        scan.fetch(index_row.getRow());
        key = ((SQLLongint)index_row.getRow()[1]).getLong();
        index_cc.close();
        scan.close();
        this.REPORT("Ending t_007");
        return ret_val;
    }

    protected boolean t_008(TransactionController tc) throws StandardException, T_Fail {
        boolean ret_val = true;
        this.REPORT("Starting t_008");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, false, 0, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)2);
        RowLocation base_rowloc = base_cc.newRowLocationTemplate();
        T_SecondaryIndexRow index_row_from_base_row = new T_SecondaryIndexRow();
        index_row_from_base_row.init(base_row, base_rowloc, 3);
        ((SQLLongint)base_row[0]).setValue(1);
        T_SecondaryIndexRow index_row = new T_SecondaryIndexRow();
        index_row.init(TemplateRow.newU8Row((int)2), base_cc.newRowLocationTemplate(), 3);
        ((SQLLongint)base_row[1]).setValue(1000);
        base_cc.insertAndFetchLocation(base_row, base_rowloc);
        if (index_cc.insert(index_row_from_base_row.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        ScanController scan = tc.openScan(create_ret.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
        scan.fetch(index_row.getRow());
        long key = ((SQLLongint)index_row.getRow()[1]).getLong();
        for (int i = 0; i < 6; ++i) {
            ((SQLLongint)base_row[1]).setValue(i);
            base_cc.insertAndFetchLocation(base_row, base_rowloc);
            if (index_cc.insert(index_row_from_base_row.getRow()) != 0) {
                throw T_Fail.testFailMsg("insert failed");
            }
            if (i % 10 != 0) continue;
            scan.fetch(index_row.getRow());
            key = ((SQLLongint)index_row.getRow()[1]).getLong();
        }
        ((SQLLongint)base_row[1]).setValue(3000);
        base_cc.insertAndFetchLocation(base_row, base_rowloc);
        if (index_cc.insert(index_row_from_base_row.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        scan.fetch(index_row.getRow());
        key = ((SQLLongint)index_row.getRow()[1]).getLong();
        scan.fetch(index_row.getRow());
        key = ((SQLLongint)index_row.getRow()[1]).getLong();
        index_cc.checkConsistency();
        index_cc.close();
        scan.close();
        this.REPORT("Ending t_008");
        return ret_val;
    }

    protected boolean t_009(TransactionController tc) throws StandardException, T_Fail {
        Object scan = null;
        this.REPORT("Starting t_009");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, false, 2, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        DataValueDescriptor[] r1 = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow index_row1 = new T_SecondaryIndexRow();
        RowLocation base_rowloc1 = base_cc.newRowLocationTemplate();
        index_row1.init(r1, base_rowloc1, 3);
        ((SQLLongint)r1[0]).setValue(1);
        ((SQLLongint)r1[1]).setValue(1000);
        base_cc.insertAndFetchLocation(r1, base_rowloc1);
        if (index_cc.insert(index_row1.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        if (index_cc.insert(index_row1.getRow()) != 1) {
            throw T_Fail.testFailMsg("insert of duplicate returned wrong return value:");
        }
        DataValueDescriptor[] delete_key = TemplateRow.newU8Row((int)2);
        ((SQLLongint)delete_key[0]).setValue(1);
        ((SQLLongint)delete_key[1]).setValue(1000);
        if (!this.t_delete(tc, create_ret.index_conglomid, delete_key, false)) {
            throw T_Fail.testFailMsg("t_008: could not delete key.");
        }
        if (index_cc.insert(index_row1.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        tc.commit();
        create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, true, false, 2, create_ret);
        base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        r1 = TemplateRow.newU8Row((int)2);
        index_row1 = new T_SecondaryIndexRow();
        base_rowloc1 = base_cc.newRowLocationTemplate();
        index_row1.init(r1, base_rowloc1, 3);
        ((SQLLongint)r1[0]).setValue(1);
        ((SQLLongint)r1[1]).setValue(1000);
        base_cc.insertAndFetchLocation(r1, base_rowloc1);
        if (index_cc.insert(index_row1.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        base_cc.insertAndFetchLocation(r1, base_rowloc1);
        if (index_cc.insert(index_row1.getRow()) != 1) {
            throw T_Fail.testFailMsg("insert of duplicate returned wrong return value:");
        }
        delete_key = TemplateRow.newU8Row((int)2);
        ((SQLLongint)delete_key[0]).setValue(1);
        ((SQLLongint)delete_key[1]).setValue(1000);
        if (!this.t_delete(tc, create_ret.index_conglomid, delete_key, false)) {
            throw T_Fail.testFailMsg("t_008: could not delete key.");
        }
        if (index_cc.insert(index_row1.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        this.REPORT("Ending t_009");
        return true;
    }

    protected boolean t_010(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("Starting t_006");
        B2I testbtree = new B2I();
        testbtree.restoreToNull();
        if (!testbtree.isNull()) {
            throw T_Fail.testFailMsg("bad restoreToNull/isNull");
        }
        try {
            TransactionManager tm = (TransactionManager)tc;
            ConglomerateController cc = testbtree.open(tm, tm.getRawStoreXact(), false, 0, 0, (LockingPolicy)null, null, null);
            throw T_Fail.testFailMsg("bad open succeeded.");
        }
        catch (StandardException tm) {
            DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)2);
            T_SecondaryIndexRow index_row1 = new T_SecondaryIndexRow();
            long base_conglomid = tc.createConglomerate("heap", base_row, null, null, null, 0);
            ConglomerateController base_cc = tc.openConglomerate(base_conglomid, false, 0, 6, 5);
            RowLocation base_rowloc1 = base_cc.newRowLocationTemplate();
            index_row1.init(base_row, base_rowloc1, 3);
            Properties properties = T_b2i.createProperties(null, false, 3, 2, true, -42L, 2);
            TransactionManager tm2 = (TransactionManager)tc;
            try {
                testbtree.create(tm2, -1, 0L, index_row1.getRow(), null, null, null, 1);
                throw T_Fail.testFailMsg("bad create succeeded.");
            }
            catch (StandardException standardException) {
                properties = T_b2i.createProperties(null, false, 3, 1, true, -42L, 2);
                try {
                    long index_conglomid = tc.createConglomerate("BTREE", index_row1.getRow(), null, null, properties, 0);
                    throw T_Fail.testFailMsg("bad create succeeded.");
                }
                catch (Throwable throwable) {
                    this.REPORT("Ending t_010");
                    return true;
                }
            }
        }
    }

    protected boolean t_011(TransactionController tc) throws StandardException, T_Fail {
        int i;
        boolean ret_val = true;
        this.REPORT("Starting t_011");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, true, 0, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow index_row = new T_SecondaryIndexRow();
        RowLocation rowloc = base_cc.newRowLocationTemplate();
        DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)2);
        base_row[0] = new SQLChar("aaaaaaaaaa");
        index_row.init(base_row, rowloc, 3);
        ((SQLChar)base_row[0]).setValue(T_b2i.repeatString("a", 1000));
        ((SQLLongint)base_row[1]).setValue(1);
        base_cc.insertAndFetchLocation(base_row, rowloc);
        ((SQLChar)base_row[0]).setValue(T_b2i.repeatString("m", 1000));
        ((SQLLongint)base_row[1]).setValue(0);
        base_cc.insertAndFetchLocation(base_row, rowloc);
        if (index_cc.insert(index_row.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLChar)base_row[0]).setValue(T_b2i.repeatString("a", 1000));
        for (i = 0; i < 5; ++i) {
            ((SQLLongint)base_row[1]).setValue(i);
            base_cc.insertAndFetchLocation(base_row, rowloc);
            if (index_cc.insert(index_row.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLChar)base_row[0]).setValue(T_b2i.repeatString("z", 500));
        for (i = 10; i > 8; --i) {
            ((SQLLongint)base_row[1]).setValue(i);
            base_cc.insertAndFetchLocation(base_row, rowloc);
            if (index_cc.insert(index_row.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        index_cc.checkConsistency();
        index_cc.close();
        tc.dropConglomerate(create_ret.index_conglomid);
        tc.dropConglomerate(create_ret.base_conglomid);
        tc.abort();
        this.REPORT("Ending t_011");
        return ret_val;
    }

    protected boolean t_012(TransactionController tc) throws StandardException, T_Fail {
        int i;
        boolean ret_val = true;
        this.REPORT("Starting t_011");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, true, 0, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow index_row = new T_SecondaryIndexRow();
        RowLocation rowloc = base_cc.newRowLocationTemplate();
        DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)2);
        base_row[0] = new SQLChar("aaaaaaaaaa");
        index_row.init(base_row, rowloc, 3);
        ((SQLChar)base_row[0]).setValue(T_b2i.repeatString("a", 1000));
        ((SQLLongint)base_row[1]).setValue(1);
        base_cc.insertAndFetchLocation(base_row, rowloc);
        ((SQLChar)base_row[0]).setValue(T_b2i.repeatString("ma", 500));
        for (i = 0; i < 3; ++i) {
            ((SQLLongint)base_row[1]).setValue(i);
            base_cc.insertAndFetchLocation(base_row, rowloc);
            if (index_cc.insert(index_row.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLChar)base_row[0]).setValue(T_b2i.repeatString("m", 1000));
        for (i = 3; i < 23; ++i) {
            ((SQLLongint)base_row[1]).setValue(i);
            base_cc.insertAndFetchLocation(base_row, rowloc);
            if (index_cc.insert(index_row.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLChar)base_row[0]).setValue(T_b2i.repeatString("a", 600));
        for (i = 123; i > 111; --i) {
            ((SQLLongint)base_row[1]).setValue(i * 2);
            base_cc.insertAndFetchLocation(base_row, rowloc);
            if (index_cc.insert(index_row.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLLongint)base_row[1]).setValue(227);
        base_cc.insertAndFetchLocation(base_row, rowloc);
        if (index_cc.insert(index_row.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        tc.commit();
        index_cc.close();
        this.REPORT("Ending t_012");
        return ret_val;
    }

    protected boolean t_013(TransactionController tc) throws StandardException, T_Fail {
        int i;
        Object scan = null;
        this.REPORT("Starting t_013");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, true, false, 5, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        DataValueDescriptor[] r1 = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow index_row1 = new T_SecondaryIndexRow();
        RowLocation base_rowloc1 = base_cc.newRowLocationTemplate();
        index_row1.init(r1, base_rowloc1, 3);
        DataValueDescriptor[] r2 = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow index_row2 = new T_SecondaryIndexRow();
        RowLocation base_rowloc2 = base_cc.newRowLocationTemplate();
        index_row2.init(r2, base_rowloc2, 3);
        tc.commit();
        tc.commit();
        base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        ((SQLLongint)r1[0]).setValue(1);
        ((SQLLongint)r1[1]).setValue(100);
        base_cc.insertAndFetchLocation(r1, base_rowloc1);
        if (index_cc.insert(index_row1.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        for (i = 0; i < 10; ++i) {
            ((SQLLongint)r2[1]).setValue(i);
            base_cc.insertAndFetchLocation(r2, base_rowloc2);
            if (index_cc.insert(index_row2.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        if (!this.t_delete(tc, create_ret.index_conglomid, index_row1.getRow(), false)) {
            throw T_Fail.testFailMsg("t_008: could not delete key.");
        }
        base_cc.delete(base_rowloc1);
        for (i = 10; i < 20; ++i) {
            ((SQLLongint)r2[1]).setValue(i);
            base_cc.insertAndFetchLocation(r2, base_rowloc2);
            if (index_cc.insert(index_row2.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        ((SQLLongint)r1[1]).setValue(100);
        base_cc.insertAndFetchLocation(r1, base_rowloc1);
        if (index_cc.insert(index_row1.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        for (i = 20; i < 30; ++i) {
            ((SQLLongint)r2[1]).setValue(i);
            base_cc.insertAndFetchLocation(r2, base_rowloc2);
            if (index_cc.insert(index_row2.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        tc.abort();
        ScanController empty_scan = tc.openScan(create_ret.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
        if (empty_scan.next()) {
            throw T_Fail.testFailMsg("t_002: there are still rows in table.");
        }
        tc.commit();
        this.REPORT("Ending t_013");
        return true;
    }

    protected boolean t_014(TransactionController tc) throws StandardException, T_Fail {
        Object scan = null;
        this.REPORT("Starting t_014");
        DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow index_row1 = new T_SecondaryIndexRow();
        long base_conglomid = tc.createConglomerate("heap", base_row, null, null, null, 0);
        ConglomerateController base_cc = tc.openConglomerate(base_conglomid, false, 0, 6, 5);
        RowLocation base_rowloc1 = base_cc.newRowLocationTemplate();
        index_row1.init(base_row, base_rowloc1, 3);
        Properties properties = T_b2i.createProperties(null, false, 3, 2, true, base_conglomid, 2);
        properties.put("derby.storage.pageSize", "8192");
        properties.put("derby.storage.pageReservedSpace", "99");
        properties.put("derby.storage.minimumRecordSize", "42");
        TransactionManager tm = (TransactionManager)tc;
        long conglomid = tc.createConglomerate("BTREE", index_row1.getRow(), null, null, properties, 0);
        ConglomerateController cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
        Properties ret_prop = new Properties();
        ret_prop.put("derby.storage.pageSize", "");
        ret_prop.put("derby.storage.pageReservedSpace", "");
        ret_prop.put("derby.storage.minimumRecordSize", "");
        cc.getTableProperties(ret_prop);
        if (ret_prop.getProperty("derby.storage.pageSize").compareTo("8192") != 0 || ret_prop.getProperty("derby.storage.pageReservedSpace").compareTo("0") != 0 || ret_prop.getProperty("derby.storage.minimumRecordSize").compareTo("1") != 0) {
            throw T_Fail.testFailMsg("(getTableProperties) Did not get expected table propertes.\nGot pageSize = " + ret_prop.getProperty("derby.storage.pageSize") + "\nGot reserved = " + ret_prop.getProperty("derby.storage.pageReservedSpace") + "\nGot minimum record size = " + ret_prop.getProperty("derby.storage.minimumRecordSize"));
        }
        tc.commit();
        this.REPORT("Ending t_014");
        return true;
    }

    protected boolean t_015(TransactionController tc) throws StandardException, T_Fail {
        ScanController scan = null;
        this.REPORT("Starting t_015");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, false, 2, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        if (!(index_cc instanceof B2IController)) {
            throw T_Fail.testFailMsg("openConglomerate returned wrong type");
        }
        index_cc.checkConsistency();
        DataValueDescriptor[] r1 = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow index_row1 = new T_SecondaryIndexRow();
        RowLocation base_rowloc1 = base_cc.newRowLocationTemplate();
        index_row1.init(r1, base_rowloc1, 3);
        tc.commit();
        base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        for (int i = 100; i > 0; i -= 2) {
            ((SQLLongint)r1[0]).setValue(2);
            ((SQLLongint)r1[1]).setValue(i);
            base_cc.insertAndFetchLocation(r1, base_rowloc1);
            if (index_cc.insert(index_row1.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        String[] latch_debug_strings = new String[]{"B2iRowLocking3_1_lockScanRow1", "B2iRowLocking3_2_lockScanRow1", "BTreeScan_positionAtStartPosition1", "BTreeScan_fetchNextGroup1"};
        for (int errs = 0; errs < latch_debug_strings.length; ++errs) {
            this.REPORT("Doing latch release tests: " + latch_debug_strings[errs]);
            scan = tc.openScan(create_ret.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
            int row_count = 0;
            while (scan.next()) {
                ++row_count;
            }
            scan.close();
            if (row_count == 50) continue;
            throw T_Fail.testFailMsg("wrong scan count = " + row_count);
        }
        tc.abort();
        this.REPORT("Ending t_015");
        return true;
    }

    protected boolean t_016(TransactionController tc) throws StandardException, T_Fail {
        ScanController scan = null;
        this.REPORT("Starting t_016");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, false, 2, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        if (!(index_cc instanceof B2IController)) {
            throw T_Fail.testFailMsg("openConglomerate returned wrong type");
        }
        index_cc.checkConsistency();
        DataValueDescriptor[] r1 = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow index_row1 = new T_SecondaryIndexRow();
        RowLocation base_rowloc1 = base_cc.newRowLocationTemplate();
        index_row1.init(r1, base_rowloc1, 3);
        tc.commit();
        base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        for (int i = 100; i > 0; i -= 2) {
            ((SQLLongint)r1[0]).setValue(2);
            ((SQLLongint)r1[1]).setValue(i);
            base_cc.insertAndFetchLocation(r1, base_rowloc1);
            if (index_cc.insert(index_row1.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        tc.abort();
        String[] deadlock_debug_strings = new String[]{"B2iRowLocking3_1_lockScanRow2", "B2iRowLocking3_2_lockScanRow2", "BTreeScan_positionAtStartPosition2", "BTreeScan_fetchNextGroup2"};
        for (int errs = 0; errs < deadlock_debug_strings.length; ++errs) {
            try {
                this.REPORT("Doing deadlock tests: " + deadlock_debug_strings[errs]);
                scan = tc.openScan(create_ret.index_conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, (Qualifier[][])null, null, 0);
                int row_count = 0;
                while (scan.next()) {
                    ++row_count;
                }
                scan.close();
                throw T_Fail.testFailMsg("expected deadlock");
            }
            catch (StandardException e) {
                if (!e.getMessageId().equals("40001")) {
                    throw e;
                }
                ContextService contextFactory = T_b2i.getContextService();
                ContextManager cm = contextFactory.getCurrentContextManager();
                cm.cleanupOnError((Throwable)e, this.isdbActive());
                continue;
            }
        }
        tc.commit();
        this.REPORT("Ending t_016");
        return true;
    }

    protected boolean t_perf(TransactionController tc) throws StandardException, T_Fail {
        boolean ret_val = true;
        this.REPORT("Starting t_005");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, false, 0, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow index_row = new T_SecondaryIndexRow();
        RowLocation rowloc = base_cc.newRowLocationTemplate();
        DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)2);
        index_row.init(base_row, rowloc, 3);
        ((SQLLongint)base_row[0]).setValue(1);
        ((SQLLongint)base_row[1]).setValue(1);
        base_cc.insertAndFetchLocation(base_row, rowloc);
        long startms = System.currentTimeMillis();
        for (int i = 0; i < 2000; ++i) {
            ((SQLLongint)base_row[1]).setValue(i);
            if (index_cc.insert(index_row.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        tc.commit();
        long endms = System.currentTimeMillis();
        long elapsedms = endms - startms;
        System.out.println("  Elapsed (ms)      " + elapsedms);
        System.out.println("  inserts/second " + 1000000L / elapsedms);
        index_cc.close();
        this.REPORT("Ending t_011");
        return ret_val;
    }

    private boolean t_desc_scan_test_cases(TransactionController tc, long index_conglomid, T_SecondaryIndexRow template) throws StandardException, T_Fail {
        boolean ret_val = true;
        DataValueDescriptor[] start_key = TemplateRow.newU8Row((int)1);
        DataValueDescriptor[] stop_key = TemplateRow.newU8Row((int)1);
        this.REPORT("scan (x = 5)");
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 3, 18, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x > 5)");
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), null, 0, null, stop_key, 1, 3, 21, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x >= 5)");
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), null, 0, null, stop_key, -1, 6, 21, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x <= 5)");
        ((SQLLongint)start_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, null, 0, 8, 18, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x < 5)");
        ((SQLLongint)start_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, -1, null, null, 0, 5, 15, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x >= 5 and x <= 7)");
        ((SQLLongint)start_key[0]).setValue(7);
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 5, 20, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 5 and y > 2)");
        start_key = TemplateRow.newU8Row((int)1);
        stop_key = TemplateRow.newU8Row((int)2);
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(5);
        ((SQLLongint)stop_key[1]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, 1, 2, 18, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 5 and y >= 2)");
        start_key = TemplateRow.newU8Row((int)1);
        stop_key = TemplateRow.newU8Row((int)2);
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(5);
        ((SQLLongint)stop_key[1]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 3, 18, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 5 and y < 5)");
        start_key = TemplateRow.newU8Row((int)2);
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)start_key[1]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 2, 17, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 2)");
        start_key = TemplateRow.newU8Row((int)1);
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(2);
        ((SQLLongint)stop_key[0]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 0, 0, 4)) {
            ret_val = false;
        }
        this.REPORT("minimum on btree, row locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 6, 5, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no min.");
        }
        long key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 11L) {
            throw T_Fail.testFailMsg("wrong minimum found.");
        }
        this.REPORT("min on btree, table locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 7, 5, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no min.");
        }
        key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 11L) {
            throw T_Fail.testFailMsg("wrong min found.");
        }
        this.REPORT("min on btree, row locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 6, 2, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 11L) {
            throw T_Fail.testFailMsg("wrong min found.");
        }
        this.REPORT("min on btree, table locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 7, 2, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no min.");
        }
        key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 11L) {
            throw T_Fail.testFailMsg("wrong min found.");
        }
        return ret_val;
    }

    protected boolean t_017(TransactionController tc) throws StandardException, T_Fail {
        int i;
        T_SecondaryIndexRow index_row = new T_SecondaryIndexRow();
        DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)4);
        base_row[3] = new SQLChar();
        String string_1500char = new String();
        for (int i2 = 0; i2 < 300; ++i2) {
            string_1500char = string_1500char + "mikem";
        }
        boolean ret_val = true;
        long value = -1L;
        long[] col1 = new long[]{1L, 3L, 4L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 9L};
        long[] col2 = new long[]{1L, 1L, 2L, 4L, 6L, 2L, 4L, 6L, 1L, 1L, 1L};
        long[] col3 = new long[]{11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L};
        long[] d_col1 = new long[]{0L, 2L, 3L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 8L, 10L, 11L, 12L};
        long[] d_col2 = new long[]{1L, 1L, 2L, 3L, 5L, 0L, 3L, 5L, 0L, 0L, 1L, 42L, 42L, 1L};
        long[] d_col3 = new long[]{91L, 92L, 93L, 94L, 95L, 96L, 97L, 98L, 99L, 100L, 101L, 102L, 103L, 104L};
        this.REPORT("Starting t_017");
        long base_conglomid = tc.createConglomerate("heap", base_row, null, null, null, 0);
        ConglomerateController base_cc = tc.openConglomerate(base_conglomid, false, 4, 6, 5);
        index_row.init(base_row, base_cc.newRowLocationTemplate(), 5);
        Properties properties = T_b2i.createProperties(null, false, 5, 5, true, base_conglomid, 4);
        ColumnOrdering[] order = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, false), new T_ColumnOrderingImpl(1, false), new T_ColumnOrderingImpl(2, false), new T_ColumnOrderingImpl(3, false), new T_ColumnOrderingImpl(4, true)};
        long index_conglomid = tc.createConglomerate("BTREE", index_row.getRow(), order, null, properties, 0);
        ConglomerateController index_cc = tc.openConglomerate(index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow template = new T_SecondaryIndexRow();
        RowLocation row_loc = base_cc.newRowLocationTemplate();
        template.init(base_row, row_loc, 5);
        for (i = col1.length - 1; i >= 0; --i) {
            ((SQLLongint)template.getRow()[0]).setValue(col1[i]);
            ((SQLLongint)template.getRow()[1]).setValue(col2[i]);
            ((SQLLongint)template.getRow()[2]).setValue(col3[i]);
            base_row[3] = new SQLChar(string_1500char);
            base_cc.insertAndFetchLocation(base_row, row_loc);
            if (index_cc.insert(template.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        index_cc.checkConsistency();
        ((B2IController)index_cc).debugConglomerate();
        ret_val = this.t_desc_scan_test_cases(tc, index_conglomid, template);
        for (i = d_col1.length - 1; i >= 0; --i) {
            ((SQLLongint)template.getRow()[0]).setValue(d_col1[i]);
            ((SQLLongint)template.getRow()[1]).setValue(d_col2[i]);
            ((SQLLongint)template.getRow()[2]).setValue(d_col3[i]);
            base_row[3] = new SQLChar(string_1500char);
            base_cc.insertAndFetchLocation(base_row, row_loc);
            if (index_cc.insert(template.getRow()) != 0) {
                throw T_Fail.testFailMsg("insert failed");
            }
            base_cc.delete(row_loc);
            ScanController delete_scan = tc.openScan(index_conglomid, false, 4, 6, 5, (FormatableBitSet)null, template.getRow(), 1, (Qualifier[][])null, template.getRow(), -1);
            if (!delete_scan.next()) {
                throw T_Fail.testFailMsg("delete could not find key");
            }
            delete_scan.delete();
            if (delete_scan.next()) {
                throw T_Fail.testFailMsg("delete found more than one key");
            }
            delete_scan.close();
        }
        ret_val = this.t_desc_scan_test_cases(tc, index_conglomid, template);
        index_cc.close();
        tc.commit();
        this.REPORT("Ending t_017");
        return ret_val;
    }

    private boolean t_ascdesc_scan_test_cases(TransactionController tc, long index_conglomid, T_SecondaryIndexRow template) throws StandardException, T_Fail {
        boolean ret_val = true;
        DataValueDescriptor[] start_key = TemplateRow.newU8Row((int)1);
        DataValueDescriptor[] stop_key = TemplateRow.newU8Row((int)1);
        this.REPORT("scan (x = 5)");
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 3, 18, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x > 5)");
        ((SQLLongint)start_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, -1, null, null, 0, 3, 19, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x >= 5)");
        ((SQLLongint)start_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, null, 0, 6, 16, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x <= 5)");
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), null, 0, null, stop_key, -1, 8, 11, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x < 5)");
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), null, 0, null, stop_key, 1, 5, 11, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x >= 5 and x <= 7)");
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(7);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 5, 16, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 5 and y > 2)");
        start_key = TemplateRow.newU8Row((int)1);
        stop_key = TemplateRow.newU8Row((int)2);
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(5);
        ((SQLLongint)stop_key[1]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, 1, 2, 18, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 5 and y >= 2)");
        start_key = TemplateRow.newU8Row((int)1);
        stop_key = TemplateRow.newU8Row((int)2);
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(5);
        ((SQLLongint)stop_key[1]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 3, 18, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 5 and y < 5)");
        start_key = TemplateRow.newU8Row((int)2);
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)start_key[1]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 2, 17, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 2)");
        start_key = TemplateRow.newU8Row((int)1);
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(2);
        ((SQLLongint)stop_key[0]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 0, 0, 4)) {
            ret_val = false;
        }
        this.REPORT("minimum on btree, row locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 6, 5, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found last row in the last leaf.");
        }
        long key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 21L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf.");
        }
        this.REPORT("last row in the last leaf, table locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 7, 5, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no min.");
        }
        key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 21L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf found.");
        }
        this.REPORT("last row in the last leaf, row locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 6, 2, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 21L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf found.");
        }
        this.REPORT("last row in the last leaf, table locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 7, 2, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no last row in the last leaf");
        }
        key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 21L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf found.");
        }
        return ret_val;
    }

    protected boolean t_018(TransactionController tc) throws StandardException, T_Fail {
        int i;
        T_SecondaryIndexRow index_row = new T_SecondaryIndexRow();
        DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)4);
        base_row[3] = new SQLChar();
        String string_1500char = new String();
        for (int i2 = 0; i2 < 300; ++i2) {
            string_1500char = string_1500char + "mikem";
        }
        boolean ret_val = true;
        long value = -1L;
        long[] col1 = new long[]{1L, 3L, 4L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 9L};
        long[] col2 = new long[]{1L, 1L, 2L, 4L, 6L, 2L, 4L, 6L, 1L, 1L, 1L};
        long[] col3 = new long[]{11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L};
        long[] d_col1 = new long[]{0L, 2L, 3L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 8L, 10L, 11L, 12L};
        long[] d_col2 = new long[]{1L, 1L, 2L, 3L, 5L, 0L, 3L, 5L, 0L, 0L, 1L, 42L, 42L, 1L};
        long[] d_col3 = new long[]{91L, 92L, 93L, 94L, 95L, 96L, 97L, 98L, 99L, 100L, 101L, 102L, 103L, 104L};
        this.REPORT("Starting t_018");
        long base_conglomid = tc.createConglomerate("heap", base_row, null, null, null, 0);
        ConglomerateController base_cc = tc.openConglomerate(base_conglomid, false, 4, 6, 5);
        index_row.init(base_row, base_cc.newRowLocationTemplate(), 5);
        Properties properties = T_b2i.createProperties(null, false, 5, 5, true, base_conglomid, 4);
        ColumnOrdering[] order = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, true), new T_ColumnOrderingImpl(1, false), new T_ColumnOrderingImpl(2, true), new T_ColumnOrderingImpl(3, false), new T_ColumnOrderingImpl(4, true)};
        long index_conglomid = tc.createConglomerate("BTREE", index_row.getRow(), order, null, properties, 0);
        ConglomerateController index_cc = tc.openConglomerate(index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow template = new T_SecondaryIndexRow();
        RowLocation row_loc = base_cc.newRowLocationTemplate();
        template.init(base_row, row_loc, 5);
        for (i = col1.length - 1; i >= 0; --i) {
            ((SQLLongint)template.getRow()[0]).setValue(col1[i]);
            ((SQLLongint)template.getRow()[1]).setValue(col2[i]);
            ((SQLLongint)template.getRow()[2]).setValue(col3[i]);
            base_row[3] = new SQLChar(string_1500char);
            base_cc.insertAndFetchLocation(base_row, row_loc);
            if (index_cc.insert(template.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        index_cc.checkConsistency();
        ((B2IController)index_cc).debugConglomerate();
        ret_val = this.t_ascdesc_scan_test_cases(tc, index_conglomid, template);
        for (i = d_col1.length - 1; i >= 0; --i) {
            ((SQLLongint)template.getRow()[0]).setValue(d_col1[i]);
            ((SQLLongint)template.getRow()[1]).setValue(d_col2[i]);
            ((SQLLongint)template.getRow()[2]).setValue(d_col3[i]);
            base_row[3] = new SQLChar(string_1500char);
            base_cc.insertAndFetchLocation(base_row, row_loc);
            if (index_cc.insert(template.getRow()) != 0) {
                throw T_Fail.testFailMsg("insert failed");
            }
            base_cc.delete(row_loc);
            ScanController delete_scan = tc.openScan(index_conglomid, false, 4, 6, 5, (FormatableBitSet)null, template.getRow(), 1, (Qualifier[][])null, template.getRow(), -1);
            if (!delete_scan.next()) {
                throw T_Fail.testFailMsg("delete could not find key");
            }
            delete_scan.delete();
            if (delete_scan.next()) {
                throw T_Fail.testFailMsg("delete found more than one key");
            }
            delete_scan.close();
        }
        ret_val = this.t_ascdesc_scan_test_cases(tc, index_conglomid, template);
        index_cc.close();
        tc.commit();
        this.REPORT("Ending t_018");
        return ret_val;
    }

    private boolean t_ascdesc1_scan_test_cases(TransactionController tc, long index_conglomid, T_SecondaryIndexRow template) throws StandardException, T_Fail {
        boolean ret_val = true;
        DataValueDescriptor[] start_key = TemplateRow.newU8Row((int)1);
        DataValueDescriptor[] stop_key = TemplateRow.newU8Row((int)1);
        this.REPORT("scan (x = 5)");
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 3, 16, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x > 5)");
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), null, 0, null, stop_key, 1, 3, 21, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x >= 5)");
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), null, 0, null, stop_key, -1, 6, 16, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x <= 5)");
        ((SQLLongint)start_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, null, 0, 8, 11, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x < 5)");
        ((SQLLongint)start_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, -1, null, null, 0, 5, 11, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x >= 5 and x <= 7)");
        ((SQLLongint)start_key[0]).setValue(7);
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 5, 16, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 5 and y > 2)");
        start_key = TemplateRow.newU8Row((int)2);
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)start_key[1]).setValue(2);
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, -1, null, stop_key, -1, 2, 17, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 5 and y >= 2)");
        start_key = TemplateRow.newU8Row((int)2);
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)start_key[1]).setValue(2);
        ((SQLLongint)stop_key[0]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 3, 16, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 5 and y < 5)");
        start_key = TemplateRow.newU8Row((int)1);
        stop_key = TemplateRow.newU8Row((int)2);
        ((SQLLongint)start_key[0]).setValue(5);
        ((SQLLongint)stop_key[0]).setValue(5);
        ((SQLLongint)stop_key[1]).setValue(5);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 2, 16, 1)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 2)");
        start_key = TemplateRow.newU8Row((int)1);
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(2);
        ((SQLLongint)stop_key[0]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 0, 0, 4)) {
            ret_val = false;
        }
        this.REPORT("scan (x > 2)");
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)stop_key[0]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), null, 0, null, stop_key, 1, 10, 12, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x >= 2)");
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)stop_key[0]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), null, 0, null, stop_key, -1, 10, 12, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x < 2)");
        start_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, -1, null, null, 0, 1, 11, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x <= 2)");
        start_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, null, 0, 1, 11, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x >= 2 and x <= 7)");
        ((SQLLongint)start_key[0]).setValue(7);
        ((SQLLongint)stop_key[0]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 9, 12, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 2 and y > 2)");
        start_key = TemplateRow.newU8Row((int)2);
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(2);
        ((SQLLongint)start_key[1]).setValue(2);
        ((SQLLongint)stop_key[0]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, -1, null, stop_key, -1, 0, 0, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 2 and y >= 2)");
        start_key = TemplateRow.newU8Row((int)2);
        stop_key = TemplateRow.newU8Row((int)1);
        ((SQLLongint)start_key[0]).setValue(2);
        ((SQLLongint)start_key[1]).setValue(2);
        ((SQLLongint)stop_key[0]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 0, 0, 3)) {
            ret_val = false;
        }
        this.REPORT("scan (x = 4 and y <=2)");
        start_key = TemplateRow.newU8Row((int)1);
        stop_key = TemplateRow.newU8Row((int)2);
        ((SQLLongint)start_key[0]).setValue(4);
        ((SQLLongint)stop_key[0]).setValue(4);
        ((SQLLongint)stop_key[1]).setValue(2);
        if (!T_QualifierTest.t_scan(tc, index_conglomid, template.getRow(), template.getRow(), start_key, 1, null, stop_key, -1, 1, 13, 4)) {
            ret_val = false;
        }
        this.REPORT("last row in the last leaf, row locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 6, 5, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found last row in the last leaf.");
        }
        long key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 11L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf.");
        }
        this.REPORT("last row in the last leaf, table locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 7, 5, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no min.");
        }
        key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 11L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf found.");
        }
        this.REPORT("last row in the last leaf, row locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 6, 2, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no max.");
        }
        key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 11L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf found.");
        }
        this.REPORT("last row in the last leaf, table locked.");
        if (!tc.fetchMaxOnBtree(index_conglomid, 0, 7, 2, (FormatableBitSet)null, template.getRow())) {
            throw T_Fail.testFailMsg("found no last row in the last leaf");
        }
        key = ((SQLLongint)template.getRow()[2]).getLong();
        if (key != 11L) {
            throw T_Fail.testFailMsg("wrong last row in the last leaf found.");
        }
        return ret_val;
    }

    protected boolean t_019(TransactionController tc) throws StandardException, T_Fail {
        int i;
        T_SecondaryIndexRow index_row = new T_SecondaryIndexRow();
        DataValueDescriptor[] base_row = TemplateRow.newU8Row((int)4);
        base_row[3] = new SQLChar();
        String string_1500char = new String();
        for (int i2 = 0; i2 < 300; ++i2) {
            string_1500char = string_1500char + "mikem";
        }
        boolean ret_val = true;
        long value = -1L;
        long[] col1 = new long[]{1L, 3L, 4L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 9L};
        long[] col2 = new long[]{1L, 1L, 2L, 4L, 6L, 2L, 4L, 6L, 1L, 1L, 1L};
        long[] col3 = new long[]{11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L};
        long[] d_col1 = new long[]{0L, 2L, 3L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 8L, 10L, 11L, 12L};
        long[] d_col2 = new long[]{1L, 1L, 2L, 3L, 5L, 0L, 3L, 5L, 0L, 0L, 1L, 42L, 42L, 1L};
        long[] d_col3 = new long[]{91L, 92L, 93L, 94L, 95L, 96L, 97L, 98L, 99L, 100L, 101L, 102L, 103L, 104L};
        this.REPORT("Starting t_019");
        long base_conglomid = tc.createConglomerate("heap", base_row, null, null, null, 0);
        ConglomerateController base_cc = tc.openConglomerate(base_conglomid, false, 4, 6, 5);
        index_row.init(base_row, base_cc.newRowLocationTemplate(), 5);
        Properties properties = T_b2i.createProperties(null, false, 5, 5, true, base_conglomid, 4);
        ColumnOrdering[] order = new ColumnOrdering[]{new T_ColumnOrderingImpl(0, false), new T_ColumnOrderingImpl(1, true), new T_ColumnOrderingImpl(2, true), new T_ColumnOrderingImpl(3, false), new T_ColumnOrderingImpl(4, true)};
        long index_conglomid = tc.createConglomerate("BTREE", index_row.getRow(), order, null, properties, 0);
        ConglomerateController index_cc = tc.openConglomerate(index_conglomid, false, 4, 6, 5);
        T_SecondaryIndexRow template = new T_SecondaryIndexRow();
        RowLocation row_loc = base_cc.newRowLocationTemplate();
        template.init(base_row, row_loc, 5);
        for (i = col1.length - 1; i >= 0; --i) {
            ((SQLLongint)template.getRow()[0]).setValue(col1[i]);
            ((SQLLongint)template.getRow()[1]).setValue(col2[i]);
            ((SQLLongint)template.getRow()[2]).setValue(col3[i]);
            base_row[3] = new SQLChar(string_1500char);
            base_cc.insertAndFetchLocation(base_row, row_loc);
            if (index_cc.insert(template.getRow()) == 0) continue;
            throw T_Fail.testFailMsg("insert failed");
        }
        index_cc.checkConsistency();
        ((B2IController)index_cc).debugConglomerate();
        ret_val = this.t_ascdesc1_scan_test_cases(tc, index_conglomid, template);
        for (i = d_col1.length - 1; i >= 0; --i) {
            ((SQLLongint)template.getRow()[0]).setValue(d_col1[i]);
            ((SQLLongint)template.getRow()[1]).setValue(d_col2[i]);
            ((SQLLongint)template.getRow()[2]).setValue(d_col3[i]);
            base_row[3] = new SQLChar(string_1500char);
            base_cc.insertAndFetchLocation(base_row, row_loc);
            if (index_cc.insert(template.getRow()) != 0) {
                throw T_Fail.testFailMsg("insert failed");
            }
            base_cc.delete(row_loc);
            ScanController delete_scan = tc.openScan(index_conglomid, false, 4, 6, 5, (FormatableBitSet)null, template.getRow(), 1, (Qualifier[][])null, template.getRow(), -1);
            if (!delete_scan.next()) {
                throw T_Fail.testFailMsg("delete could not find key");
            }
            delete_scan.delete();
            if (delete_scan.next()) {
                throw T_Fail.testFailMsg("delete found more than one key");
            }
            delete_scan.close();
        }
        ret_val = this.t_ascdesc1_scan_test_cases(tc, index_conglomid, template);
        index_cc.close();
        tc.commit();
        this.REPORT("Ending t_019");
        return ret_val;
    }

    protected boolean t_020(TransactionController tc) throws StandardException, T_Fail {
        Object scan = null;
        this.REPORT("Starting t_020");
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, false, 2, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        DataValueDescriptor[] r1 = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow index_row1 = new T_SecondaryIndexRow();
        RowLocation base_rowloc1 = base_cc.newRowLocationTemplate();
        index_row1.init(r1, base_rowloc1, 3);
        base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        ((SQLLongint)r1[0]).setValue(2);
        ((SQLLongint)r1[1]).setValue(10000);
        base_cc.insertAndFetchLocation(r1, base_rowloc1);
        if (index_cc.insert(index_row1.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        tc.commit();
        tc.commit();
        this.REPORT("Ending t_020");
        return true;
    }

    protected boolean t_021(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("Starting t_021");
        boolean ret_val = true;
        T_CreateConglomRet create_ret = new T_CreateConglomRet();
        this.createCongloms(tc, 2, false, false, 2, create_ret);
        ConglomerateController base_cc = tc.openConglomerate(create_ret.base_conglomid, false, 4, 6, 5);
        ConglomerateController index_cc = tc.openConglomerate(create_ret.index_conglomid, false, 4, 6, 5);
        DataValueDescriptor[] r1 = TemplateRow.newU8Row((int)2);
        T_SecondaryIndexRow index_row1 = new T_SecondaryIndexRow();
        RowLocation base_rowloc1 = base_cc.newRowLocationTemplate();
        index_row1.init(r1, base_rowloc1, 3);
        ((SQLLongint)r1[0]).setValue(1);
        ((SQLLongint)r1[1]).setValue(1);
        base_cc.insertAndFetchLocation(r1, base_rowloc1);
        if (index_cc.insert(index_row1.getRow()) != 0) {
            throw T_Fail.testFailMsg("insert failed");
        }
        tc.commit();
        DataValueDescriptor[] delete_key = TemplateRow.newU8Row((int)2);
        ((SQLLongint)delete_key[0]).setValue(1);
        ((SQLLongint)delete_key[1]).setValue(1);
        if (!this.t_delete(tc, create_ret.index_conglomid, delete_key, true)) {
            ret_val = false;
        }
        tc.commit();
        this.REPORT("Ending t_021");
        return ret_val;
    }

    public static String repeatString(String data, int repeat) {
        String s = data;
        for (int i = 1; i < repeat; ++i) {
            s = s + data;
        }
        return s;
    }

    public boolean isdbActive() {
        LanguageConnectionContext lcc = (LanguageConnectionContext)T_b2i.getContextOrNull("LanguageConnectionContext");
        Database db = lcc != null ? lcc.getDatabase() : null;
        return db != null ? db.isActive() : false;
    }

    private static ContextService getContextService() {
        if (System.getSecurityManager() == null) {
            return ContextService.getFactory();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static Context getContextOrNull(final String contextID) {
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull((String)contextID);
            }
        });
    }

    private static Object findServiceModule(final Object serviceModule, final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule((Object)serviceModule, (String)factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException((Throwable)pae);
        }
    }

    private static Object createPersistentService(final String factoryInterface, final String serviceName, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.createPersistentService((String)factoryInterface, (String)serviceName, (Properties)properties);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException((Throwable)pae);
        }
    }
}

