/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTestSetup;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Test;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CallableStatementTest
extends Wrapper41Test {
    private CallableStatement cStmt = null;
    private static boolean _nullOutArgs;

    public CallableStatementTest(String string) {
        super(string);
    }

    protected void setUp() throws SQLException {
        this.cStmt = this.prepareCall("? = CALL FLOOR(?)");
        this.cStmt.registerOutParameter(1, 8);
    }

    @Override
    protected void tearDown() throws Exception {
        this.cStmt.close();
        this.cStmt = null;
        super.tearDown();
    }

    public void testNamedParametersAreNotSupported() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        CallableStatementTest.assertFalse((String)"Named parameters are not supported, but the metadata says they are", (boolean)databaseMetaData.supportsNamedParameters());
    }

    public void testGetDoubleIntOnInParameter() throws SQLException {
        this.cStmt.setDouble(2, 3.3);
        this.cStmt.execute();
        try {
            this.cStmt.getDouble(2);
            CallableStatementTest.fail((String)"Calling getDouble on an IN parameter should throw an exception");
        }
        catch (SQLException sQLException) {
            String string = CallableStatementTest.usingDerbyNetClient() ? "XJ091" : "XCL26";
            CallableStatementTest.assertSQLState("Unexpected SQLState", string, sQLException);
        }
    }

    public void testGetNClobIntNotImplemented() throws SQLException {
        try {
            this.cStmt.getNClob(1);
            CallableStatementTest.fail((String)"CallableStatement.getNClob(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNClobStringNotImplemented() throws SQLException {
        try {
            this.cStmt.getNClob("some-parameter-name");
            CallableStatementTest.fail((String)"CallableStatement.getNClob(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNStringIntNotImplemented() throws SQLException {
        try {
            this.cStmt.getNString(1);
            CallableStatementTest.fail((String)"CallableStatement.getNString(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNStringStringNotImplemented() throws SQLException {
        try {
            this.cStmt.getNString("some-parameter-name");
            CallableStatementTest.fail((String)"CallableStatement.getNString(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetCharacterStreamIntOnInvalidTypeDOUBLE() throws SQLException {
        this.cStmt.setDouble(2, 3.3);
        this.cStmt.execute();
        try {
            this.cStmt.getCharacterStream(1);
            CallableStatementTest.fail((String)"An exception signalling invalid data type conversion should have been thrown");
        }
        catch (SQLDataException sQLDataException) {
            CallableStatementTest.assertSQLState("Exception with invalid SQL state thrown on invalid data type conversion", "22005", sQLDataException);
        }
    }

    public void testGetCharacterStreamIntOnInParameterOfInvalidType() throws SQLException {
        this.cStmt.setDouble(2, 3.3);
        this.cStmt.execute();
        try {
            this.cStmt.getCharacterStream(2);
            CallableStatementTest.fail((String)"Calling getCharacterStream on an IN parameter should throw an exception");
        }
        catch (SQLException sQLException) {
            String string = CallableStatementTest.usingDerbyNetClient() ? "XJ091" : "XCL26";
            CallableStatementTest.assertSQLState("Exception with invalid SQL state thrown for getCharacterStream on IN parameter", string, sQLException);
        }
    }

    public void testGetCharacterStreamIntOnInParameterOfValidType() throws SQLException {
        this.cStmt = CallableStatementTestSetup.getBinaryDirectProcedure(this.getConnection());
        this.cStmt.setString(1, "A string");
        this.cStmt.execute();
        try {
            this.cStmt.getCharacterStream(1);
            CallableStatementTest.fail((String)"Calling getCharacterStream on an IN parameter should throw an exception");
        }
        catch (SQLException sQLException) {
            String string = CallableStatementTest.usingDerbyNetClient() ? "XJ091" : "XCL26";
            CallableStatementTest.assertSQLState("Exception with invalid SQL state thrown for getCharacterStream on IN parameter", string, sQLException);
        }
    }

    public void testGetCharacterStreamIntVARCHAR() throws IOException, SQLException {
        this.cStmt = CallableStatementTestSetup.getIntToStringFunction(this.getConnection());
        this.cStmt.setInt(2, 4509);
        CallableStatementTest.assertFalse((String)"No resultsets should be returned", (boolean)this.cStmt.execute());
        CallableStatementTest.assertEquals((String)"Incorrect updatecount", (int)-1, (int)this.cStmt.getUpdateCount());
        Reader reader = this.cStmt.getCharacterStream(1);
        CallableStatementTest.assertFalse((String)"Stream should not be null", (boolean)this.cStmt.wasNull());
        CallableStatementTest.assertNotNull((String)"Stream is null even though wasNull() returned false", (Object)reader);
        char[] cArray = new char[4];
        CallableStatementTest.assertEquals((String)"Wrong number of characters read", (int)4, (int)reader.read(cArray));
        CallableStatementTest.assertEquals((String)"Expected end of stream, but there were more data", (int)-1, (int)reader.read());
        reader.close();
        String string = new String(cArray);
        CallableStatementTest.assertEquals((String)"Incorrect result obtained through java.io.Reader", (String)"4509", (String)string);
    }

    public void testGetCharacterStreamIntVARBINARYDirect() throws IOException, SQLException {
        String string = "This is the test string.";
        this.cStmt = CallableStatementTestSetup.getBinaryDirectProcedure(this.getConnection());
        this.cStmt.setString(1, string);
        CallableStatementTest.assertFalse((String)"No resultsets should be returned", (boolean)this.cStmt.execute());
        CallableStatementTest.assertEquals((String)"Incorrect updatecount", (int)(CallableStatementTest.usingEmbedded() ? 0 : -1), (int)this.cStmt.getUpdateCount());
        Reader reader = this.cStmt.getCharacterStream(2);
        CallableStatementTest.assertFalse((String)"Stream should not be null", (boolean)this.cStmt.wasNull());
        CallableStatementTest.assertNotNull((String)"Stream is null even though wasNull() returned false", (Object)reader);
        char[] cArray = new char[string.length() * 4];
        int n = reader.read();
        int n2 = 0;
        while (n != -1) {
            cArray[n2] = (char)n;
            ++n2;
            n = reader.read();
        }
        reader.close();
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        String string2 = new String(cArray2);
        CallableStatementTest.assertEquals((String)"Incorrect result obtained through java.io.Reader", (String)string, (String)string2);
    }

    public void testGetCharacterStreamIntVARBINARYFromDb() throws IOException, SQLException {
        this.cStmt = CallableStatementTestSetup.getBinaryFromDbFunction(this.getConnection());
        this.cStmt.setInt(2, 1);
        CallableStatementTest.assertFalse((String)"No resultsets should be returned", (boolean)this.cStmt.execute());
        CallableStatementTest.assertEquals((String)"Incorrect updatecount", (int)-1, (int)this.cStmt.getUpdateCount());
        Reader reader = this.cStmt.getCharacterStream(1);
        CallableStatementTest.assertFalse((String)"Stream should not be null", (boolean)this.cStmt.wasNull());
        CallableStatementTest.assertNotNull((String)"Stream is null even though wasNull() returned false", (Object)reader);
        char[] cArray = new char[32672];
        int n = reader.read();
        int n2 = 0;
        while (n != -1) {
            cArray[n2] = (char)n;
            ++n2;
            n = reader.read();
        }
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        cArray = null;
        reader.close();
        String string = new String(cArray2);
        CallableStatementTest.assertEquals((String)"Strings not equal", (String)"This is a string, converted to bytes and inserted into the database", (String)string);
    }

    public void testGetCharacterStreamIntOnVARBINARYWithNull() throws SQLException {
        this.cStmt = CallableStatementTestSetup.getBinaryFromDbFunction(this.getConnection());
        this.cStmt.setInt(2, 2);
        CallableStatementTest.assertFalse((String)"No resultsets should be returned", (boolean)this.cStmt.execute());
        CallableStatementTest.assertEquals((String)"Incorrect updatecount", (int)-1, (int)this.cStmt.getUpdateCount());
        Reader reader = this.cStmt.getCharacterStream(1);
        CallableStatementTest.assertTrue((String)"Stream should be null", (boolean)this.cStmt.wasNull());
        CallableStatementTest.assertNull((String)"Stream is not null even though wasNull() returned true", (Object)reader);
    }

    public void testGetCharacterStreamIntOnVARCHARWithNull() throws SQLException {
        this.cStmt = CallableStatementTestSetup.getVarcharFromDbFunction(this.getConnection());
        this.cStmt.setInt(2, 2);
        CallableStatementTest.assertFalse((String)"No resultsets should be returned", (boolean)this.cStmt.execute());
        CallableStatementTest.assertEquals((String)"Incorrect updatecount", (int)-1, (int)this.cStmt.getUpdateCount());
        Reader reader = this.cStmt.getCharacterStream(1);
        CallableStatementTest.assertTrue((String)"Stream should be null", (boolean)this.cStmt.wasNull());
        CallableStatementTest.assertNull((String)"Stream is not null even though wasNull() returned true", (Object)reader);
    }

    public void testGetCharacterStreamStringNotImplemented() throws SQLException {
        try {
            this.cStmt.getCharacterStream("some-parameter-name");
            CallableStatementTest.fail((String)"CallableStatement.getCharacterStream(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNCharacterStreamIntNotImplemented() throws SQLException {
        try {
            this.cStmt.getNCharacterStream(1);
            CallableStatementTest.fail((String)"CallableStatement.getNCharacterStream(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNCharacterStreamStringNotImplemented() throws SQLException {
        try {
            this.cStmt.getNCharacterStream("some-parameter-name");
            CallableStatementTest.fail((String)"CallableStatement.getNCharacterStream(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetBlobNotImplemented() throws SQLException {
        try {
            this.cStmt.setBlob("some-parameter-name", (Blob)null);
            CallableStatementTest.fail((String)"CallableStatement.setBlob(String, Blob) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetClobNotImplemented() throws SQLException {
        try {
            this.cStmt.setClob("some-parameter-name", (Clob)null);
            CallableStatementTest.fail((String)"CallableStatement.setClob(String, Clob) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNCharacterStreamNotImplemented() throws SQLException {
        try {
            this.cStmt.setNCharacterStream("some-parameter-name", null, 0L);
            CallableStatementTest.fail((String)"CallableStatement.setNCharacterStream(String,Reader,long) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNClobNClobNotImplemented() throws SQLException {
        try {
            this.cStmt.setNClob("some-parameter-name", (NClob)null);
            CallableStatementTest.fail((String)"CallableStatement.setNClob(String, NClob) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNClobReaderNotImplemented() throws SQLException {
        try {
            this.cStmt.setNClob("some-parameter-name", null, 0L);
            CallableStatementTest.fail((String)"CallableStatement.setNClob(String, Reader, long) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetNStringNotImplemented() throws SQLException {
        try {
            this.cStmt.setNString("some-parameter-name", "some-value");
            CallableStatementTest.fail((String)"CallableStatement.setNString(String, String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetSQLXMLIntNotImplemented() throws SQLException {
        try {
            this.cStmt.getSQLXML(1);
            CallableStatementTest.fail((String)"CallableStatement.getSQLXML(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetSQLXMLStringNotImplemented() throws SQLException {
        try {
            this.cStmt.getSQLXML("some-parameter-name");
            CallableStatementTest.fail((String)"CallableStatement.getSQLXML(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetSQLXMLNotImplemented() throws SQLException {
        try {
            this.cStmt.setSQLXML("some-parameter-name", null);
            CallableStatementTest.fail((String)"CallableStatement.setSQLXML(String, SQLXML) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    private void testIsWrapperForXXXStatement(Class clazz) throws SQLException {
        CallableStatementTest.assertTrue((String)("The CallableStatement is not a wrapper for " + clazz.getName()), (boolean)this.cStmt.isWrapperFor(clazz));
    }

    public void testIsWrapperForStatement() throws SQLException {
        this.testIsWrapperForXXXStatement(Statement.class);
    }

    public void testIsWrapperForPreparedStatement() throws SQLException {
        this.testIsWrapperForXXXStatement(PreparedStatement.class);
    }

    public void testIsWrapperForCallableStatement() throws SQLException {
        this.testIsWrapperForXXXStatement(CallableStatement.class);
    }

    public void testIsNotWrapperForResultSet() throws SQLException {
        CallableStatementTest.assertFalse((boolean)this.cStmt.isWrapperFor(ResultSet.class));
    }

    public void testIsWrapperForSelf() throws SQLException {
        CallableStatementTest.assertTrue((boolean)this.cStmt.isWrapperFor(this.cStmt.getClass()));
    }

    public void testUnwrapStatement() throws SQLException {
        Statement statement = this.cStmt.unwrap(Statement.class);
        CallableStatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.cStmt, (Object)statement);
    }

    public void testUnwrapPreparedStatement() throws SQLException {
        PreparedStatement preparedStatement = this.cStmt.unwrap(PreparedStatement.class);
        CallableStatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.cStmt, (Object)preparedStatement);
    }

    public void testUnwrapCallableStatement() throws SQLException {
        Statement statement = this.cStmt.unwrap(CallableStatement.class);
        CallableStatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.cStmt, (Object)statement);
    }

    public void testUnwrapAsSelf() throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.cStmt.unwrap(this.cStmt.getClass());
        CallableStatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.cStmt, (Object)preparedStatement);
    }

    public void testUnwrapResultSet() {
        try {
            ResultSet resultSet = this.cStmt.unwrap(ResultSet.class);
            CallableStatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException sQLException) {
            CallableStatementTest.assertSQLState("XJ128", sQLException);
        }
    }

    public void testSetCharacterStream() throws SQLException {
        try {
            this.cStmt.setCharacterStream("Some String", null, 0L);
            CallableStatementTest.fail((String)"CallableStatement.setCharacterStream() should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetAsciiStream() throws SQLException {
        try {
            this.cStmt.setAsciiStream("Some String", null, 0L);
            CallableStatementTest.fail((String)"CallableStatement.setAsciiStream() should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testSetBinaryStream() throws SQLException {
        try {
            this.cStmt.setBinaryStream("Some String", null, 0L);
            CallableStatementTest.fail((String)"CallableStatement.setBinaryStream() should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testJDBC4_1() throws Exception {
        Connection connection = this.getConnection();
        this.vetDataTypeCount(connection);
        PreparedStatement preparedStatement = this.prepareStatement(connection, "create procedure allTypesProc\n(\n    out bigintCol bigint,\n    out blobCol blob,\n    out booleanCol boolean,\n    out charCol char(1),\n    out charForBitDataCol char(1) for bit data,\n    out clobCol clob,\n    out dateCol date,\n    out doubleCol double,\n    out floatCol float,\n    out intCol int,\n    out longVarcharCol long varchar,\n    out longVarcharForBitDataCol long varchar for bit data,\n    out numericCol numeric,\n    out realCol real,\n    out smallintCol smallint,\n    out timeCol time,\n    out timestampCol timestamp,\n    out varcharCol varchar( 2 ),\n    out varcharForBitDataCol varchar( 2 ) for bit data\n)\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTest.allTypesProc'\n");
        preparedStatement.execute();
        preparedStatement.close();
        CallableStatement callableStatement = this.prepareCall(connection, "call allTypesProc(  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
        int n = 1;
        callableStatement.registerOutParameter(n++, -5);
        callableStatement.registerOutParameter(n++, 2004);
        callableStatement.registerOutParameter(n++, 16);
        callableStatement.registerOutParameter(n++, 1);
        callableStatement.registerOutParameter(n++, -2);
        callableStatement.registerOutParameter(n++, 2005);
        callableStatement.registerOutParameter(n++, 91);
        callableStatement.registerOutParameter(n++, 8);
        callableStatement.registerOutParameter(n++, 6);
        callableStatement.registerOutParameter(n++, 4);
        callableStatement.registerOutParameter(n++, -1);
        callableStatement.registerOutParameter(n++, -4);
        callableStatement.registerOutParameter(n++, 2);
        callableStatement.registerOutParameter(n++, 7);
        callableStatement.registerOutParameter(n++, 5);
        callableStatement.registerOutParameter(n++, 92);
        callableStatement.registerOutParameter(n++, 93);
        callableStatement.registerOutParameter(n++, 12);
        callableStatement.registerOutParameter(n++, -3);
        _nullOutArgs = false;
        callableStatement.execute();
        this.examineJDBC4_1extensions(new Wrapper41(callableStatement), _nullOutArgs);
        _nullOutArgs = true;
        callableStatement.execute();
        this.examineJDBC4_1extensions(new Wrapper41(callableStatement), _nullOutArgs);
        callableStatement.close();
        preparedStatement = this.prepareStatement(connection, "drop procedure allTypesProc");
        preparedStatement.execute();
        preparedStatement.close();
    }

    private void vetDataTypeCount(Connection connection) throws Exception {
        ResultSet resultSet = connection.getMetaData().getTypeInfo();
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        resultSet.close();
        CallableStatementTest.assertEquals((int)22, (int)n);
    }

    public void test_4959() throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.prepareStatement(connection, "create procedure blobProc\n(\n    out blobCol blob\n)\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTest.blobProc'\n");
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = this.prepareStatement(connection, "create procedure clobProc\n(\n    out clobCol clob\n)\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTest.clobProc'\n");
        preparedStatement.execute();
        preparedStatement.close();
        CallableStatement callableStatement = this.prepareCall(connection, "call blobProc(  ? )");
        callableStatement.registerOutParameter(1, 2004);
        callableStatement.execute();
        CallableStatementTest.assertNull((Object)callableStatement.getBlob(1));
        callableStatement.close();
        callableStatement = this.prepareCall(connection, "call clobProc(  ? )");
        callableStatement.registerOutParameter(1, 2005);
        callableStatement.execute();
        CallableStatementTest.assertNull((Object)callableStatement.getClob(1));
        callableStatement.close();
        preparedStatement = this.prepareStatement(connection, "drop procedure blobProc");
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = this.prepareStatement(connection, "drop procedure clobProc");
        preparedStatement.execute();
        preparedStatement.close();
    }

    public static void allTypesProc(Long[] longArray, Blob[] blobArray, Boolean[] booleanArray, String[] stringArray, byte[][] byArray, Clob[] clobArray, Date[] dateArray, Double[] doubleArray, Double[] doubleArray2, Integer[] integerArray, String[] stringArray2, byte[][] byArray2, BigDecimal[] bigDecimalArray, Float[] floatArray, Integer[] integerArray2, Time[] timeArray, Timestamp[] timestampArray, String[] stringArray3, byte[][] byArray3) throws Exception {
        String string = "a";
        int n = 1;
        float f = 1.0f;
        String string2 = "abc";
        longArray[0] = _nullOutArgs ? null : Long.valueOf(n);
        blobArray[0] = _nullOutArgs ? null : new HarmonySerialBlob(BINARY_VALUE);
        booleanArray[0] = _nullOutArgs ? null : Boolean.TRUE;
        stringArray[0] = _nullOutArgs ? null : string;
        byArray[0] = _nullOutArgs ? null : BINARY_VALUE;
        clobArray[0] = _nullOutArgs ? null : new HarmonySerialClob(string2);
        dateArray[0] = _nullOutArgs ? null : new Date(761990400000L);
        doubleArray[0] = _nullOutArgs ? null : Double.valueOf(f);
        doubleArray2[0] = _nullOutArgs ? null : Double.valueOf(f);
        integerArray[0] = _nullOutArgs ? null : Integer.valueOf(n);
        stringArray2[0] = _nullOutArgs ? null : string;
        byArray2[0] = _nullOutArgs ? null : BINARY_VALUE;
        bigDecimalArray[0] = _nullOutArgs ? null : new BigDecimal("1.0");
        floatArray[0] = _nullOutArgs ? null : Float.valueOf(f);
        integerArray2[0] = _nullOutArgs ? null : Integer.valueOf(n);
        timeArray[0] = _nullOutArgs ? null : new Time(83342000L);
        timestampArray[0] = _nullOutArgs ? null : new Timestamp(-229527385766L);
        stringArray3[0] = _nullOutArgs ? null : string;
        byArray3[0] = _nullOutArgs ? null : BINARY_VALUE;
    }

    public static void blobProc(Blob[] blobArray) throws Exception {
        blobArray[0] = null;
    }

    public static void clobProc(Clob[] clobArray) throws Exception {
        clobArray[0] = null;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("CallableStatementTest suite");
        baseTestSuite.addTest(CallableStatementTest.baseSuite("CallableStatementTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(CallableStatementTest.baseSuite("CallableStatementTest:client")));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(TestConfiguration.connectionCPDecorator(CallableStatementTest.baseSuite("CallableStatementTest:logical"))));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(CallableStatementTest.class, string);
        return new CallableStatementTestSetup((Test)baseTestSuite);
    }
}

