/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.util.OutputWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;

public class SocketChannelOutputBuffer
extends InternalOutputBuffer {
    protected SocketChannel socketChannel;
    private ByteBuffer outputByteBuffer;
    private static final ByteBuffer ACK = ByteBuffer.wrap("HTTP/1.1 100 Continue\r\n\r\n".getBytes());
    private static final int MAX_BUFFERED_BYTES = 262144;
    private static int maxBufferedBytes = 262144;

    public SocketChannelOutputBuffer(Response response, int headerBufferSize, boolean useSocketBuffer) {
        super(response, headerBufferSize, useSocketBuffer);
        if (!useSocketBuffer) {
            this.outputStream = new NIOOutputStream();
            this.outputByteBuffer = ByteBuffer.allocate(headerBufferSize * 16);
        }
    }

    public void setChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public SocketChannel getChannel() {
        return this.socketChannel;
    }

    public void sendAck() throws IOException {
        if (!this.committed) {
            this.flushChannel(ACK.slice());
        }
    }

    public void realWriteBytes(byte[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            if (!this.useSocketBuffer) {
                int remaining = this.outputByteBuffer.remaining();
                if (len > remaining) {
                    if (this.outputByteBuffer.capacity() >= maxBufferedBytes) {
                        this.outputByteBuffer.put(cbuf, off, remaining);
                        this.flush();
                        this.realWriteBytes(cbuf, off + remaining, len - remaining);
                        return;
                    }
                    int size = Math.max(this.outputByteBuffer.capacity() * 2, len + this.outputByteBuffer.position());
                    ByteBuffer tmp = ByteBuffer.allocate(size);
                    this.outputByteBuffer.flip();
                    tmp.put(this.outputByteBuffer);
                    this.outputByteBuffer = tmp;
                }
                this.outputByteBuffer.put(cbuf, off, len);
            } else {
                this.flushChannel(ByteBuffer.wrap(cbuf, off, len));
            }
        }
    }

    public void flushChannel(ByteBuffer bb) throws IOException {
        OutputWriter.flushChannel((SelectableChannel)this.socketChannel, bb);
        bb.clear();
    }

    public void flush() throws IOException {
        super.flush();
        this.flushBuffer();
    }

    public void endRequest() throws IOException {
        super.endRequest();
        this.flushBuffer();
    }

    public void flushBuffer() throws IOException {
        if (!this.useSocketBuffer && this.outputByteBuffer.position() != 0) {
            this.outputByteBuffer.flip();
            this.flushChannel(this.outputByteBuffer);
            this.outputByteBuffer.clear();
        }
    }

    public void recycle() {
        this.response.recycle();
        this.socketBuffer.recycle();
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        if (this.outputByteBuffer != null) {
            this.outputByteBuffer.clear();
        }
        this.socketChannel = null;
    }

    public static int getMaxBufferedBytes() {
        return maxBufferedBytes;
    }

    public static void setMaxBufferedBytes(int aMaxBufferedBytes) {
        maxBufferedBytes = aMaxBufferedBytes;
    }

    private final class NIOOutputStream
    extends OutputStream {
        private NIOOutputStream() {
        }

        public void write(byte[] b, int off, int len) throws IOException {
            SocketChannelOutputBuffer.this.realWriteBytes(b, off, len);
        }

        public void write(int b) throws IOException {
            this.write((byte)b);
        }

        public void write(byte b) throws IOException {
            if (!SocketChannelOutputBuffer.this.outputByteBuffer.hasRemaining()) {
                ByteBuffer tmp = ByteBuffer.allocate(SocketChannelOutputBuffer.this.outputByteBuffer.capacity() * 2);
                SocketChannelOutputBuffer.this.outputByteBuffer.flip();
                tmp.put(SocketChannelOutputBuffer.this.outputByteBuffer);
                SocketChannelOutputBuffer.this.outputByteBuffer = tmp;
            }
            SocketChannelOutputBuffer.this.outputByteBuffer.put(b);
        }
    }
}

