/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.comet.CometSelector;
import com.sun.grizzly.comet.CometTask;
import com.sun.grizzly.comet.NotificationHandler;
import com.sun.grizzly.http.SelectorThread;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CometContext<E> {
    protected static final String INVALID_COMET_HANDLER = "CometHandler cannot be null. This CometHandler was probably resumed and an invalid reference was made to it.";
    private static final Logger logger = SelectorThread.logger();
    private ConcurrentHashMap attributes;
    private String contextPath;
    protected boolean cancelled = false;
    private ConcurrentHashMap<CometHandler, SelectionKey> handlers;
    private ConcurrentLinkedQueue<AsyncProcessorTask> asyncTasks;
    private CometSelector cometSelector;
    protected int continuationType = 1;
    private long expirationDelay = 30000L;
    private boolean blockingNotification = false;
    private NotificationHandler notificationHandler;
    private static ConcurrentLinkedQueue<SelectionKey> inProgressSelectionKey = null;

    public CometContext(String contextPath, int continuationType) {
        this.contextPath = contextPath;
        this.continuationType = continuationType;
        this.attributes = new ConcurrentHashMap();
        this.handlers = new ConcurrentHashMap();
        this.asyncTasks = new ConcurrentLinkedQueue();
        inProgressSelectionKey = new ConcurrentLinkedQueue();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void addAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public int addCometHandler(CometHandler handler, boolean completeExecution) {
        Long threadId = Thread.currentThread().getId();
        SelectionKey key = CometEngine.getEngine().activateContinuation(threadId, this, completeExecution);
        if (key == null) {
            throw new IllegalStateException("Grizzly Comet hasn't been registered");
        }
        if (handler == null) {
            throw new IllegalStateException(INVALID_COMET_HANDLER);
        }
        if (!completeExecution) {
            this.handlers.putIfAbsent(handler, key);
        } else {
            this.handlers.putIfAbsent(handler, new SelectionKey(){

                public void cancel() {
                }

                public SelectableChannel channel() {
                    throw new IllegalStateException();
                }

                public int interestOps() {
                    throw new IllegalStateException();
                }

                public SelectionKey interestOps(int ops) {
                    throw new IllegalStateException();
                }

                public boolean isValid() {
                    return true;
                }

                public int readyOps() {
                    throw new IllegalStateException();
                }

                public Selector selector() {
                    throw new IllegalStateException();
                }
            });
        }
        return handler.hashCode();
    }

    public int addCometHandler(CometHandler handler) {
        return this.addCometHandler(handler, false);
    }

    public CometHandler getCometHandler(int hashCode) {
        Iterator iterator = this.handlers.keySet().iterator();
        CometHandler cometHandler = null;
        while (iterator.hasNext()) {
            cometHandler = (CometHandler)iterator.next();
            if (cometHandler.hashCode() != hashCode) continue;
            return cometHandler;
        }
        return null;
    }

    protected CometHandler getCometHandler(SelectionKey key) {
        Iterator iterator = this.handlers.keySet().iterator();
        CometHandler cometHandler = null;
        while (iterator.hasNext()) {
            cometHandler = (CometHandler)iterator.next();
            if (this.handlers.get(cometHandler) != key) continue;
            return cometHandler;
        }
        return null;
    }

    protected void notify(CometEvent event, int eventType, SelectionKey key) throws IOException {
        CometHandler cometHandler = this.getCometHandler(key);
        if (cometHandler == null) {
            throw new IllegalStateException(INVALID_COMET_HANDLER);
        }
        event.setCometContext(this);
        cometHandler.onEvent(event);
    }

    public void removeCometHandler(CometHandler handler) {
        this.removeCometHandler(handler, true);
    }

    private void removeCometHandler(CometHandler handler, boolean resume) {
        SelectionKey key = this.handlers.remove(handler);
        if (resume && !this.handlers.containsValue(key)) {
            CometEngine.getEngine().resume(key, this);
        }
    }

    public void removeCometHandler(int hashCode) {
        Iterator iterator = this.handlers.keySet().iterator();
        CometHandler cometHandler = null;
        while (iterator.hasNext()) {
            cometHandler = (CometHandler)iterator.next();
            if (cometHandler.hashCode() != hashCode) continue;
            SelectionKey key = this.handlers.get(cometHandler);
            if (key == null) {
                throw new IllegalStateException("Invalid CometHandler");
            }
            if (inProgressSelectionKey.contains(key)) {
                throw new IllegalStateException("Cannot resume an in progress connection.");
            }
            iterator.remove();
            return;
        }
    }

    public void resumeCometHandler(CometHandler handler) {
        this.resumeCometHandler(handler, true);
    }

    protected void resumeCometHandler(CometHandler handler, boolean remove) {
        SelectionKey cometKey;
        SelectionKey key = this.handlers.get(handler);
        if (key == null) {
            throw new IllegalStateException("Invalid CometHandler");
        }
        if (inProgressSelectionKey.contains(key)) {
            throw new IllegalStateException("Cannot resume an in progress connection");
        }
        if (remove) {
            this.removeCometHandler(handler, false);
        }
        if ((cometKey = this.cometSelector.cometKeyFor(key.channel())) != null) {
            cometKey.attach(null);
            cometKey.cancel();
        }
        CometEngine.getEngine().resume(key, this);
    }

    public boolean isActive(CometHandler cometHandler) {
        if (cometHandler == null) {
            throw new IllegalStateException(INVALID_COMET_HANDLER);
        }
        SelectionKey key = this.handlers.get(cometHandler);
        return key != null && !inProgressSelectionKey.contains(key);
    }

    public void notify(E attachment) throws IOException {
        CometEvent<E> event = new CometEvent<E>();
        event.setType(1);
        event.attach(attachment);
        event.setCometContext(this);
        Iterator<CometHandler> iterator = this.handlers.keySet().iterator();
        this.notificationHandler.setBlockingNotification(this.blockingNotification);
        this.notificationHandler.notify(event, iterator);
        this.registerKeys();
    }

    public void notify(E attachment, int eventType, int cometHandlerID) throws IOException {
        CometHandler cometHandler = this.getCometHandler(cometHandlerID);
        if (cometHandler == null) {
            throw new IllegalStateException(INVALID_COMET_HANDLER);
        }
        CometEvent<E> event = new CometEvent<E>();
        event.setType(eventType);
        event.attach(attachment);
        event.setCometContext(this);
        this.notificationHandler.setBlockingNotification(this.blockingNotification);
        this.notificationHandler.notify(event, cometHandler);
        if (event.getType() == 3 || event.getType() == 0) {
            this.resumeCometHandler(cometHandler);
        } else {
            this.registerKeys();
        }
    }

    protected void initialize(SelectionKey key) throws IOException {
        CometEvent event = new CometEvent();
        event.setType(2);
        event.setCometContext(this);
        Iterator iterator = this.handlers.keySet().iterator();
        CometHandler cometHandler = null;
        while (iterator.hasNext()) {
            cometHandler = (CometHandler)iterator.next();
            if (!this.handlers.get(cometHandler).equals(key)) continue;
            cometHandler.onInitialize(event);
            break;
        }
    }

    public void notify(E attachment, int eventType) throws IOException {
        CometEvent<E> event = new CometEvent<E>();
        event.setType(eventType);
        event.attach(attachment);
        event.setCometContext(this);
        Iterator<CometHandler> iterator = this.handlers.keySet().iterator();
        this.notificationHandler.setBlockingNotification(this.blockingNotification);
        this.notificationHandler.notify(event, iterator);
        if (event.getType() == 3 || event.getType() == 0) {
            while (iterator.hasNext()) {
                this.resumeCometHandler(iterator.next());
            }
        } else {
            this.registerKeys();
        }
    }

    private synchronized void registerKeys() {
        for (AsyncProcessorTask asyncTask : this.asyncTasks) {
            SelectionKey key = asyncTask.getSelectionKey();
            if (key == null) continue;
            CometTask cometTask = (CometTask)((Object)key.attachment());
            if (cometTask == null) {
                cometTask = CometEngine.getEngine().getCometTask(this, key, asyncTask.getPipeline());
                key.attach((Object)cometTask);
            }
            cometTask.setExpirationDelay(this.expirationDelay);
            cometTask.setExpireTime(System.currentTimeMillis());
        }
    }

    public boolean registerAsyncRead(CometHandler handler) {
        SelectionKey key = null;
        if (handler != null) {
            key = this.handlers.get(handler);
        }
        if (handler == null || key == null) {
            throw new IllegalStateException(INVALID_COMET_HANDLER);
        }
        SelectionKey cometKey = this.cometSelector.cometKeyFor(key.channel());
        if (cometKey != null) {
            cometKey.interestOps(cometKey.interestOps() | 1);
            if (cometKey.attachment() != null) {
                ((CometTask)((Object)cometKey.attachment())).setAsyncReadSupported(true);
            }
            return true;
        }
        return false;
    }

    public boolean registerAsyncWrite(CometHandler handler) {
        SelectionKey key = null;
        if (handler != null) {
            key = this.handlers.get(handler);
        }
        if (handler == null || key == null) {
            throw new IllegalStateException(INVALID_COMET_HANDLER);
        }
        SelectionKey cometKey = this.cometSelector.cometKeyFor(key.channel());
        if (cometKey != null) {
            cometKey.interestOps(cometKey.interestOps() | 4);
            return true;
        }
        return false;
    }

    protected void recycle() {
        this.handlers.clear();
        this.attributes.clear();
        this.cancelled = false;
        this.asyncTasks.clear();
    }

    protected boolean isCancelled() {
        return this.cancelled;
    }

    protected void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    protected void addAsyncProcessorTask(AsyncProcessorTask asyncTask) {
        this.asyncTasks.add(asyncTask);
    }

    protected ConcurrentLinkedQueue<AsyncProcessorTask> getAsyncProcessorTask() {
        return this.asyncTasks;
    }

    protected CometSelector getCometSelector() {
        return this.cometSelector;
    }

    protected void setCometSelector(CometSelector cometSelector) {
        this.cometSelector = cometSelector;
    }

    public String toString() {
        return this.contextPath;
    }

    public long getExpirationDelay() {
        return this.expirationDelay;
    }

    public void setExpirationDelay(long expirationDelay) {
        this.expirationDelay = expirationDelay;
    }

    protected void interrupt(SelectionKey key) {
        CometEvent event = new CometEvent();
        event.setType(0);
        event.attach(null);
        event.setCometContext(this);
        this.closeConnection(event, key);
    }

    private void closeConnection(CometEvent event, SelectionKey key) {
        Iterator iterator = this.handlers.keySet().iterator();
        while (iterator.hasNext()) {
            CometHandler handler = (CometHandler)iterator.next();
            if (!this.handlers.get(handler).equals(key)) continue;
            try {
                handler.onInterrupt(event);
                iterator.remove();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Exception: ", ex);
            }
            break;
        }
    }

    public boolean isBlockingNotification() {
        return this.blockingNotification;
    }

    public void setBlockingNotification(boolean blockingNotification) {
        this.blockingNotification = blockingNotification;
    }

    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    protected static void addInProgressSelectionKey(SelectionKey key) {
        inProgressSelectionKey.add(key);
    }

    protected static boolean removeInProgressSelectionKey(SelectionKey key) {
        return inProgressSelectionKey.remove(key);
    }
}

