/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.Pipeline;
import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometSelector;
import com.sun.grizzly.comet.CometTask;
import com.sun.grizzly.comet.DefaultNotificationHandler;
import com.sun.grizzly.comet.NotificationHandler;
import com.sun.grizzly.http.AsyncHandler;
import com.sun.grizzly.http.AsyncTask;
import com.sun.grizzly.http.SelectorThread;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CometEngine {
    public static final int BEFORE_REQUEST_PROCESSING = 0;
    public static final int AFTER_SERVLET_PROCESSING = 1;
    public static final int AFTER_RESPONSE_PROCESSING = 2;
    private static final Logger logger = SelectorThread.logger();
    protected Pipeline pipeline;
    private static CometEngine cometEngine;
    protected ConcurrentHashMap<String, CometContext> activeContexts = new ConcurrentHashMap();
    protected ConcurrentLinkedQueue<CometTask> cometTasks = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<CometContext> cometContexts = new ConcurrentLinkedQueue();
    protected CometSelector cometSelector = new CometSelector(this);
    protected static String notificationHandlerClassName;
    protected ConcurrentHashMap<Long, SelectionKey> threadsId;
    protected ConcurrentHashMap<Long, CometContext> updatedCometContexts;
    private ConcurrentLinkedQueue<AsyncProcessorTask> asyncTasks;

    protected CometEngine() {
        this.cometSelector.start();
        this.threadsId = new ConcurrentHashMap();
        this.updatedCometContexts = new ConcurrentHashMap();
        this.asyncTasks = new ConcurrentLinkedQueue();
    }

    public static synchronized CometEngine getEngine() {
        if (cometEngine == null) {
            cometEngine = new CometEngine();
        }
        return cometEngine;
    }

    public CometContext unregister(String contextPath) {
        CometContext cometContext = this.activeContexts.get(contextPath);
        try {
            cometContext.notify(cometContext, 3);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "unregister", ex);
        }
        this.finalizeContext(cometContext);
        return this.activeContexts.remove(contextPath);
    }

    public CometContext register(String contextPath) {
        return this.register(contextPath, 1);
    }

    public CometContext register(String contextPath, int type) {
        CometContext cometContext = this.activeContexts.get(contextPath);
        if (cometContext == null) {
            cometContext = this.cometContexts.poll();
            if (cometContext == null) {
                cometContext = new CometContext(contextPath, type);
                cometContext.setCometSelector(this.cometSelector);
                NotificationHandler notificationHandler = CometEngine.loadNotificationHandlerInstance(notificationHandlerClassName);
                cometContext.setNotificationHandler(notificationHandler);
                if (notificationHandler != null && notificationHandler instanceof DefaultNotificationHandler) {
                    ((DefaultNotificationHandler)notificationHandler).setPipeline(this.pipeline);
                }
            }
            this.activeContexts.put(contextPath, cometContext);
        }
        return cometContext;
    }

    protected boolean handle(AsyncProcessorTask apt) throws IOException {
        NotificationHandler notificationHandler;
        if (this.pipeline == null) {
            this.pipeline = apt.getPipeline();
        }
        String contextPath = apt.getProcessorTask().getRequestURI();
        CometContext cometContext = null;
        if (contextPath != null && (cometContext = this.activeContexts.get(contextPath)) != null && (notificationHandler = cometContext.getNotificationHandler()) instanceof DefaultNotificationHandler) {
            ((DefaultNotificationHandler)notificationHandler).setPipeline(this.pipeline);
        }
        boolean activateContinuation = true;
        SelectionKey key = apt.getProcessorTask().getSelectionKey();
        this.threadsId.put(Thread.currentThread().getId(), key);
        int continuationType = cometContext == null ? 1 : cometContext.continuationType;
        this.executeServlet(continuationType, apt);
        cometContext = this.updatedCometContexts.remove(Thread.currentThread().getId());
        if (cometContext == null) {
            activateContinuation = false;
        }
        boolean parkRequest = true;
        if (activateContinuation) {
            CometContext.addInProgressSelectionKey(key);
            key.attach(null);
            boolean isBlocking = cometContext.isBlockingNotification();
            cometContext.setBlockingNotification(true);
            cometContext.initialize(key);
            cometContext.setBlockingNotification(isBlocking);
            if (cometContext.getCometHandler(key) != null) {
                this.asyncTasks.offer(apt);
                CometTask cometTask = this.getCometTask(cometContext, key, apt.getPipeline());
                cometTask.setSelectorThread(apt.getProcessorTask().getSelectorThread());
                cometTask.setExpirationDelay(cometContext.getExpirationDelay());
                cometTask.setSelectorThread(apt.getSelectorThread());
                cometContext.addActiveCometTask(cometTask);
                this.cometSelector.registerKey(key, cometTask);
            } else {
                parkRequest = false;
            }
            CometContext.removeInProgressSelectionKey(key);
        } else {
            parkRequest = false;
        }
        return parkRequest;
    }

    protected SelectionKey activateContinuation(Long threadId, CometContext cometContext, boolean continueExecution) {
        if (!continueExecution) {
            this.updatedCometContexts.put(threadId, cometContext);
        }
        return this.threadsId.remove(threadId);
    }

    protected CometTask getCometTask(CometContext cometContext, SelectionKey key, Pipeline ctxPipeline) {
        CometTask cometTask;
        if (ctxPipeline == null) {
            ctxPipeline = this.pipeline;
        }
        if ((cometTask = this.cometTasks.poll()) == null) {
            cometTask = new CometTask();
        }
        cometTask.setCometContext(cometContext);
        cometTask.setSelectionKey(key);
        cometTask.setCometSelector(this.cometSelector);
        cometTask.setPipeline(ctxPipeline);
        return cometTask;
    }

    private void finalizeContext(CometContext cometContext) {
        for (String contextPath : this.activeContexts.keySet()) {
            if (!this.activeContexts.get(contextPath).equals(cometContext)) continue;
            this.activeContexts.remove(contextPath);
            break;
        }
        for (AsyncProcessorTask apt : this.asyncTasks) {
            this.flushResponse(apt);
        }
        cometContext.recycle();
        this.cometContexts.offer(cometContext);
    }

    public CometContext getCometContext(String contextPath) {
        return this.activeContexts.get(contextPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interrupt(SelectionKey key) {
        CometTask cometTask = (CometTask)((Object)key.attachment());
        key.attach(null);
        if (cometTask == null) {
            throw new IllegalStateException("cometTask cannot be null");
        }
        SelectionKey akey = cometTask.getSelectionKey();
        try {
            if (akey == null || !akey.isValid()) {
                return;
            }
            Iterator<AsyncProcessorTask> iterator = this.asyncTasks.iterator();
            AsyncHandler ah = null;
            while (iterator.hasNext()) {
                AsyncProcessorTask apt = iterator.next();
                ah = apt.getAsyncExecutor().getAsyncHandler();
                if (apt.getProcessorTask().getSelectionKey() != akey) continue;
                iterator.remove();
                ah.removeFromInterruptedQueue((AsyncTask)apt);
                if (akey != null) {
                    akey.attach(null);
                }
                if (apt.getStage() != 2) {
                } else {
                    this.flushResponse(apt);
                }
                break;
            }
        }
        finally {
            this.returnTask(cometTask);
        }
    }

    protected void returnTask(CometTask cometTask) {
        cometTask.recycle();
        this.cometTasks.offer(cometTask);
    }

    protected void resume(SelectionKey key) {
        Iterator<AsyncProcessorTask> iterator = this.asyncTasks.iterator();
        while (iterator.hasNext()) {
            AsyncProcessorTask apt = iterator.next();
            if (apt.getProcessorTask().getSelectionKey() != key) continue;
            iterator.remove();
            if (apt.getStage() != 2) break;
            apt.getAsyncExecutor().getAsyncHandler().removeFromInterruptedQueue((AsyncTask)apt);
            this.flushResponse(apt);
            break;
        }
    }

    private void flushResponse(AsyncProcessorTask apt) {
        apt.setStage(2);
        try {
            apt.doTask();
        }
        catch (IllegalStateException ex) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "flushResponse failed", ex);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "flushResponse failed", ex);
        }
    }

    private void executeServlet(int continuationType, AsyncProcessorTask apt) {
        switch (continuationType) {
            case 0: {
                apt.setStage(0);
                break;
            }
            case 1: {
                apt.getProcessorTask().invokeAdapter();
                return;
            }
            case 2: {
                apt.setStage(2);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state");
            }
        }
        try {
            apt.doTask();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "executeServlet", ex);
        }
    }

    public static String getNotificationHandlerClassName() {
        return notificationHandlerClassName;
    }

    public static void setNotificationHandlerClassName(String aNotificationHandlerClassName) {
        notificationHandlerClassName = aNotificationHandlerClassName;
    }

    protected static NotificationHandler loadNotificationHandlerInstance(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            return (NotificationHandler)clazz.newInstance();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Invalid NotificationHandler: ", t);
            return new DefaultNotificationHandler();
        }
    }

    public static final Logger logger() {
        return logger;
    }

    static {
        notificationHandlerClassName = DefaultNotificationHandler.class.getName();
    }
}

