/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd.bayeux;

import com.sun.grizzly.cometd.bayeux.Verb;
import com.sun.grizzly.cometd.bayeux.VerbBase;

abstract class Subscribe
extends VerbBase {
    public static final String META_SUBSCRIBE = "/meta/subscribe";
    protected String subscription;
    protected String clientId;

    public Subscribe() {
        this.type = Verb.Type.SUBSCRIBE;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isValid() {
        return this.clientId != null && this.subscription != null && this.getMetaChannel().equals(this.getChannel());
    }

    protected String getMetaChannel() {
        return META_SUBSCRIBE;
    }

    protected String getBody(boolean isResponse, String timestamp) {
        StringBuilder sb = new StringBuilder(this.getJSONPrefix() + "{" + "\"channel\":\"" + this.channel + "\"");
        if (isResponse) {
            sb.append(",\"successful\":" + this.successful);
        }
        sb.append(",\"clientId\":\"" + this.clientId + "\"");
        sb.append(",\"subscription\":\"" + this.subscription + "\"");
        if (isResponse && this.error != null) {
            sb.append(",\"error\":\"" + this.error + "\"");
        }
        if (isResponse && this.advice != null) {
            sb.append("," + this.advice.toJSON());
        }
        if (this.ext != null) {
            sb.append("," + this.ext.toJSON());
        }
        if (this.id != null) {
            sb.append(",\"id\":\"" + this.id + "\"");
        }
        if (timestamp != null) {
            sb.append(",\"timestamp\":\"" + timestamp + "\"");
        }
        sb.append("}" + this.getJSONPostfix());
        return sb.toString();
    }
}

