/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd.standalone;

import com.sun.grizzly.Controller;
import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.cometd.BayeuxCometHandler;
import com.sun.grizzly.cometd.CometdNotificationHandler;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.EventRouter;
import com.sun.grizzly.cometd.EventRouterImpl;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class CometdAdapter
extends GrizzlyAdapter {
    private String contextPath = "/cometd/cometd";
    private BayeuxCometHandler bayeuxCometHandler;
    private EventRouter eventRouter;
    public static final String COMETD_REQUEST = "request";
    public static final String COMETD_RESPONSE = "response";
    private ReentrantLock initializedLock = new ReentrantLock();

    public CometdAdapter() {
        this.setHandleStaticResources(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        try {
            CometEngine cometEngine = CometEngine.getEngine();
            CometContext cometContext = cometEngine.getCometContext(this.contextPath);
            this.initializedLock.lock();
            try {
                if (cometContext == null) {
                    cometContext = cometEngine.register(this.contextPath);
                    cometContext.setExpirationDelay(-1L);
                    cometContext.setBlockingNotification(true);
                    cometContext.setNotificationHandler(new CometdNotificationHandler());
                    this.bayeuxCometHandler = new BayeuxCometHandler();
                    this.eventRouter = new EventRouterImpl(cometContext);
                    int mainHandlerHash = cometContext.addCometHandler(this.bayeuxCometHandler, true);
                    cometContext.addAttribute("bayeuxCometHandler", mainHandlerHash);
                }
            }
            finally {
                this.initializedLock.unlock();
            }
            CometdRequest cometdReq = (CometdRequest)request.getNote(COMETD_REQUEST);
            CometdResponse cometdRes = (CometdResponse)request.getNote(COMETD_RESPONSE);
            if (cometdReq == null) {
                cometdReq = new CometdRequest<GrizzlyRequest>(request){

                    @Override
                    public String[] getParameterValues(String s) {
                        return ((GrizzlyRequest)this.request).getParameterValues(s);
                    }
                };
                cometdRes = new CometdResponse<GrizzlyResponse>(response){

                    @Override
                    public void write(String s) throws IOException {
                        ((GrizzlyResponse)this.response).getWriter().write(s);
                    }

                    @Override
                    public void flush() throws IOException {
                        ((GrizzlyResponse)this.response).getWriter().flush();
                    }

                    @Override
                    public void setContentType(String s) {
                        ((GrizzlyResponse)this.response).setContentType(s);
                    }
                };
                request.setNote(COMETD_REQUEST, (Object)cometdReq);
                request.setNote(COMETD_RESPONSE, (Object)cometdRes);
            }
            this.eventRouter.route(cometdReq, cometdRes);
        }
        catch (IOException ex) {
            Controller.logger().log(Level.SEVERE, "CometdAdapter exception", ex);
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }
}

