/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.cometd.BayeuxCometHandler;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.EventRouter;
import com.sun.grizzly.cometd.bayeux.Verb;
import com.sun.grizzly.cometd.bayeux.VerbUtils;
import com.sun.grizzly.cometd.util.JSONParser;
import java.io.IOException;
import java.util.List;

public class EventRouterImpl
implements EventRouter {
    private static final String JSON_MESSAGES = "message";
    private CometContext cometContext;

    public EventRouterImpl(CometContext cometContext) {
        this.setCometContext(cometContext);
    }

    public synchronized void route(CometdRequest req, CometdResponse res) throws IOException {
        String[] messages = req.getParameterValues(JSON_MESSAGES);
        if (messages != null && messages.length > 0) {
            for (String message : messages) {
                List<Verb> verbs = VerbUtils.parseRequest(JSONParser.parse(message));
                for (Verb verb : verbs) {
                    this.getCometContext().notify(BayeuxCometHandler.newCometdContext(req, res, verb), 1, (Integer)this.cometContext.getAttribute("bayeuxCometHandler"));
                }
            }
        } else {
            throw new IOException("Invalid request");
        }
    }

    public CometContext getCometContext() {
        return this.cometContext;
    }

    public void setCometContext(CometContext cometContext) {
        this.cometContext = cometContext;
    }
}

