/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.cometd.BayeuxParser;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.bayeux.DeliverResponse;
import com.sun.grizzly.http.SelectorThread;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataHandler
implements CometHandler<Object[]> {
    private static final Logger logger = SelectorThread.logger();
    private CometdRequest req;
    private CometdResponse res;
    private String clientId;
    private Collection<String> channels = new ConcurrentLinkedQueue<String>();
    private Collection<String> unmodifiableChannels = null;
    private BayeuxParser bayeuxParser;
    private boolean wasLast = false;

    public DataHandler(BayeuxParser bayeuxParser) {
        this.bayeuxParser = bayeuxParser;
    }

    private void writeEndAndResume(CometContext cometContext) throws IOException {
        if (cometContext.isActive(this)) {
            this.writeEnd();
            cometContext.resumeCometHandler(this);
        }
    }

    private void writeEnd() throws IOException {
        if (!this.wasLast) {
            this.wasLast = true;
            this.res.write("]*/");
            this.res.flush();
        }
    }

    @Override
    public void attach(Object[] reqRes) {
        this.req = (CometdRequest)reqRes[0];
        this.res = (CometdResponse)reqRes[1];
        this.wasLast = false;
    }

    @Override
    public synchronized void onEvent(CometEvent event) throws IOException {
        Object obj = event.attachment();
        try {
            if ("NOTIFY_END".equals(obj)) {
                this.writeEndAndResume(event.getCometContext());
                return;
            }
            if (obj instanceof DeliverResponse) {
                DeliverResponse deliverRes = (DeliverResponse)obj;
                String deliverResClientId = deliverRes.getClientId();
                if (deliverResClientId != null && deliverResClientId.equals(this.getClientId()) || deliverResClientId == null && this.getClientId() == null) {
                    return;
                }
                this.wasLast = deliverRes.isLast();
                this.res.write(deliverRes.toJSON());
                if (!this.wasLast) {
                    this.res.flush();
                }
                if (deliverRes.isFinished()) {
                    this.writeEndAndResume(event.getCometContext());
                }
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Data.onEvent", t);
        }
    }

    @Override
    public void onInitialize(CometEvent event) throws IOException {
    }

    @Override
    public void onTerminate(CometEvent event) throws IOException {
        this.writeEnd();
    }

    @Override
    public void onInterrupt(CometEvent event) throws IOException {
    }

    public synchronized Collection<String> getChannels() {
        if (this.unmodifiableChannels == null) {
            this.unmodifiableChannels = Collections.unmodifiableCollection(this.channels);
        }
        return this.unmodifiableChannels;
    }

    public synchronized void addChannel(String channel) {
        if (this.channels.contains(channel)) {
            throw new IllegalArgumentException(channel);
        }
        this.unmodifiableChannels = null;
        this.channels.add(channel);
    }

    public synchronized boolean removeChannel(String channel) {
        this.unmodifiableChannels = null;
        return this.channels.remove(channel);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
}

