/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd;

import com.sun.grizzly.cometd.BayeuxParser;
import com.sun.grizzly.cometd.CometdContext;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.EventRouter;
import com.sun.grizzly.cometd.bayeux.Verb;
import com.sun.grizzly.cometd.bayeux.VerbUtils;
import com.sun.grizzly.cometd.util.JSONParser;
import java.io.IOException;
import java.util.List;

public class EventRouterImpl
implements EventRouter {
    private static final String JSON_MESSAGES = "message";
    private BayeuxParser bayeuxParser;

    public EventRouterImpl(BayeuxParser bayeuxParser) {
        this.bayeuxParser = bayeuxParser;
    }

    public void route(final CometdRequest req, final CometdResponse res) throws IOException {
        String[] messages = req.getParameterValues(JSON_MESSAGES);
        CometdContext cometdContext = null;
        if (messages != null && messages.length > 0) {
            for (String message : messages) {
                List<Verb> verbs = VerbUtils.parseRequest(JSONParser.parse(message));
                for (final Verb verb : verbs) {
                    cometdContext = new CometdContext(){

                        public CometdRequest getRequest() {
                            return req;
                        }

                        public CometdResponse getResponse() {
                            return res;
                        }

                        public Verb getVerb() {
                            return verb;
                        }
                    };
                    this.bayeuxParser.parse(cometdContext);
                }
            }
        } else {
            throw new IOException("Invalid request");
        }
    }
}

