/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd.bayeux;

import com.sun.grizzly.cometd.bayeux.Verb;
import com.sun.grizzly.cometd.bayeux.VerbBase;

public class Advice
extends VerbBase {
    private static final String[] VALID_RECONNECT = new String[]{"none", "retry", "handshake", "recover"};
    private String reconnect = "retry";
    private Integer interval = 0;
    private Boolean multipleClients = Boolean.FALSE;
    private String[] hosts = null;
    private String transport = "\"long-polling\":\t{\n";

    public Advice() {
        this.type = Verb.Type.ADVICE;
    }

    public String getReconnect() {
        return this.reconnect;
    }

    public void setReconnect(String reconnect) {
        this.reconnect = reconnect;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public Boolean getMultipleClients() {
        return this.multipleClients;
    }

    public void setMultipleClients(Boolean multipleClients) {
        this.multipleClients = multipleClients;
    }

    public String[] getHosts() {
        return this.hosts;
    }

    public void setHosts(String[] hosts) {
        this.hosts = hosts;
    }

    public String toString() {
        return this.toJSON();
    }

    public String toJSON() {
        StringBuilder jsonSb = new StringBuilder("\"advice\":{\"reconnect\":\"" + this.reconnect + "\"," + "\"interval\":" + this.interval + "," + "\"multiple-clients\":" + this.multipleClients);
        if (this.hosts != null && this.hosts.length > 0) {
            jsonSb.append("\"hosts\":[");
            boolean first = true;
            for (String host : this.hosts) {
                if (first) {
                    first = false;
                } else {
                    jsonSb.append(",");
                }
                jsonSb.append("\"").append(host).append("\"");
            }
            jsonSb.append("]");
        }
        jsonSb.append("}");
        return jsonSb.toString();
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public boolean isValid() {
        for (String rc : VALID_RECONNECT) {
            if (!rc.equals(this.reconnect)) continue;
            return true;
        }
        return false;
    }
}

