/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd;

import com.sun.grizzly.Controller;
import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.cometd.CometdContext;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.DataHandler;
import com.sun.grizzly.cometd.bayeux.Advice;
import com.sun.grizzly.cometd.bayeux.ConnectRequest;
import com.sun.grizzly.cometd.bayeux.ConnectResponse;
import com.sun.grizzly.cometd.bayeux.Data;
import com.sun.grizzly.cometd.bayeux.DeliverResponse;
import com.sun.grizzly.cometd.bayeux.DisconnectRequest;
import com.sun.grizzly.cometd.bayeux.DisconnectResponse;
import com.sun.grizzly.cometd.bayeux.HandshakeRequest;
import com.sun.grizzly.cometd.bayeux.HandshakeResponse;
import com.sun.grizzly.cometd.bayeux.PublishRequest;
import com.sun.grizzly.cometd.bayeux.PublishResponse;
import com.sun.grizzly.cometd.bayeux.ReconnectRequest;
import com.sun.grizzly.cometd.bayeux.ReconnectResponse;
import com.sun.grizzly.cometd.bayeux.SubscribeRequest;
import com.sun.grizzly.cometd.bayeux.SubscribeResponse;
import com.sun.grizzly.cometd.bayeux.UnsubscribeRequest;
import com.sun.grizzly.cometd.bayeux.UnsubscribeResponse;
import com.sun.grizzly.cometd.bayeux.VerbBase;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;

public class BayeuxParser {
    private static Level level = Level.FINE;
    private static boolean enforceSubscriptionUnderPush = true;
    public static final String DEFAULT_CONTENT_TYPE = "application/json-comment-filtered";
    private ConcurrentHashMap<String, Collection<String>> inactiveChannels = new ConcurrentHashMap();
    private ConcurrentLinkedQueue<String> authenticatedUsers = new ConcurrentLinkedQueue();
    private Random random = new Random();
    private ConcurrentHashMap<String, CometContext> activeCometContexts = new ConcurrentHashMap();
    private ConcurrentHashMap<String, DataHandler> activeCometHandlers = new ConcurrentHashMap();

    public void parse(CometdContext cometdContext) throws IOException {
        this.log(cometdContext.getVerb().toString());
        switch (cometdContext.getVerb().getType()) {
            case HANDSHAKE: {
                this.onHandshake(cometdContext);
                break;
            }
            case CONNECT: {
                this.onConnect(cometdContext);
                break;
            }
            case DISCONNECT: {
                this.onDisconnect(cometdContext);
                break;
            }
            case RECONNECT: {
                this.onReconnect(cometdContext);
                break;
            }
            case SUBSCRIBE: {
                this.onSubscribe(cometdContext);
                break;
            }
            case UNSUBSCRIBE: {
                this.onUnsubscribe(cometdContext);
                break;
            }
            case PUBLISH: {
                this.onPublish(cometdContext);
                break;
            }
            case PING: {
                this.onPing(cometdContext);
                break;
            }
            case STATUS: {
                this.onStatus(cometdContext);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandshake(CometdContext cometdContext) throws IOException {
        CometdResponse res = cometdContext.getResponse();
        HandshakeRequest handshakeReq = (HandshakeRequest)cometdContext.getVerb();
        HandshakeResponse handshakeRes = new HandshakeResponse(handshakeReq);
        handshakeRes.setAdvice(new Advice());
        if (handshakeReq.isValid()) {
            String clientId = null;
            Random random = this.random;
            synchronized (random) {
                clientId = String.valueOf(Long.toHexString(this.random.nextLong()));
            }
            handshakeRes.setClientId(clientId);
            this.authenticatedUsers.offer(clientId);
        } else {
            handshakeRes.setSuccessful(false);
            handshakeRes.setError("501::invalid handshake");
        }
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(handshakeRes.toJSON());
        res.flush();
    }

    public void onConnect(CometdContext cometdContext) throws IOException {
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        ConnectRequest connectReq = (ConnectRequest)cometdContext.getVerb();
        ConnectResponse connectRes = new ConnectResponse(connectReq);
        connectRes.setAdvice(new Advice());
        String errorMessage = this.isAuthenticatedAndValid(connectReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            boolean hasChannel = false;
            String clientId = connectReq.getClientId();
            DataHandler dataHandler = this.activeCometHandlers.get(clientId);
            if (dataHandler != null && dataHandler.getChannels().size() > 0) {
                hasChannel = true;
                dataHandler.attach(new Object[]{req, res});
                for (String channel : dataHandler.getChannels()) {
                    CometContext cc = this.getCometContext(channel);
                    if (cc.getCometHandler(dataHandler.hashCode()) != null) continue;
                    this.log("Suspending client: " + clientId + " channel: " + channel);
                    cc.addCometHandler(dataHandler);
                }
                connectRes.setAdvice(null);
            }
            String jsonMessage = hasChannel ? connectRes.toLongPolledJSON() : connectRes.toJSON();
            res.write(jsonMessage);
        } else {
            res.write(errorMessage);
        }
        res.flush();
    }

    public void onDisconnect(CometdContext cometdContext) throws IOException {
        CometdResponse res = cometdContext.getResponse();
        DisconnectRequest disconnectReq = (DisconnectRequest)cometdContext.getVerb();
        DisconnectResponse disconnectRes = new DisconnectResponse(disconnectReq);
        String errorMessage = this.isAuthenticatedAndValid(disconnectReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            this.removeActiveHandler(disconnectReq.getClientId(), this.getCometContext(disconnectReq.getChannel()));
            this.authenticatedUsers.remove(disconnectReq.getClientId());
            res.write(disconnectRes.toJSON());
        } else {
            res.write(errorMessage);
        }
        res.flush();
        this.notifyEnd(disconnectReq);
    }

    public boolean removeActiveHandler(String clientId, CometContext ctx) throws IOException {
        DataHandler dataHandler = this.activeCometHandlers.remove(clientId);
        if (dataHandler != null && ctx.isActive(dataHandler)) {
            ctx.notify("disconnecting", 3, dataHandler);
            return true;
        }
        return false;
    }

    public void onReconnect(CometdContext cometdContext) throws IOException {
        CometdResponse res = cometdContext.getResponse();
        ReconnectRequest reconnectReq = (ReconnectRequest)cometdContext.getVerb();
        ReconnectResponse reconnectRes = new ReconnectResponse(reconnectReq);
        String errorMessage = this.isAuthenticatedAndValid(reconnectReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            res.write(reconnectRes.toJSON());
        } else {
            res.write(errorMessage);
        }
        res.flush();
        this.notifyEnd(reconnectReq);
    }

    public void onSubscribe(CometdContext cometdContext) throws IOException {
        CometdResponse res = cometdContext.getResponse();
        SubscribeRequest subscribeReq = (SubscribeRequest)cometdContext.getVerb();
        SubscribeResponse subscribeRes = new SubscribeResponse(subscribeReq);
        String errorMessage = this.isAuthenticatedAndValid(subscribeReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            String clientId = subscribeReq.getClientId();
            DataHandler dataHandler = this.activeCometHandlers.get(clientId);
            if (dataHandler == null) {
                dataHandler = new DataHandler(this);
                dataHandler.setClientId(clientId);
                DataHandler dh = this.activeCometHandlers.putIfAbsent(clientId, dataHandler);
                if (dh != null) {
                    dataHandler = dh;
                }
            }
            dataHandler.addChannel(subscribeReq.getSubscription());
            res.write(subscribeRes.toJSON());
        } else {
            res.write(errorMessage);
        }
        res.flush();
        this.notifyEnd(subscribeReq);
    }

    public void onUnsubscribe(CometdContext cometdContext) throws IOException {
        CometdResponse res = cometdContext.getResponse();
        UnsubscribeRequest unsubscribeReq = (UnsubscribeRequest)cometdContext.getVerb();
        UnsubscribeResponse unsubscribeRes = new UnsubscribeResponse(unsubscribeReq);
        boolean hasSubscription = false;
        DataHandler dataHandler = null;
        String clientId = unsubscribeReq.getClientId();
        String subscription = unsubscribeReq.getSubscription();
        String errorMessage = this.isAuthenticatedAndValid(unsubscribeReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            dataHandler = this.activeCometHandlers.get(clientId);
            if (dataHandler != null && (hasSubscription = dataHandler.removeChannel(subscription))) {
                Collection<String> uscs;
                dataHandler.removeChannel(subscription);
                Collection<String> unsubscribedChannels = this.inactiveChannels.get(clientId);
                if (unsubscribedChannels == null && (uscs = this.inactiveChannels.putIfAbsent(clientId, unsubscribedChannels = new ConcurrentLinkedQueue<String>())) != null) {
                    unsubscribedChannels = uscs;
                }
                unsubscribedChannels.add(subscription);
            }
            unsubscribeRes.setSuccessful(hasSubscription);
            res.write(unsubscribeRes.toJSON());
        } else {
            res.write(errorMessage);
        }
        res.flush();
        this.notifyEnd(unsubscribeReq);
    }

    public void onPublish(CometdContext cometdContext) throws IOException {
        CometdResponse res = cometdContext.getResponse();
        PublishRequest publishReq = (PublishRequest)cometdContext.getVerb();
        PublishResponse publishRes = new PublishResponse(publishReq);
        DeliverResponse deliverRes = null;
        String errorMessage = this.isAuthenticatedAndValid(publishReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage != null) {
            res.write(errorMessage);
        } else {
            String clientId;
            publishRes.setSuccessful(true);
            Data data = publishReq.getData();
            if (data != null) {
                deliverRes = new DeliverResponse(publishReq);
                deliverRes.setFollow(true);
                if (publishReq.isFirst()) {
                    deliverRes.setFirst(false);
                }
            }
            boolean hasWritten = false;
            if (deliverRes != null && (clientId = publishReq.getClientId()) != null) {
                Collection<String> subscribedChannels = null;
                DataHandler dataHandler = this.activeCometHandlers.get(clientId);
                if (dataHandler != null) {
                    subscribedChannels = dataHandler.getChannels();
                }
                if (subscribedChannels != null && subscribedChannels.contains(publishReq.getChannel())) {
                    hasWritten = true;
                    if (publishReq.isLast()) {
                        publishRes.setLast(false);
                    }
                    res.write(publishRes.toJSON());
                    res.write(deliverRes.toJSON());
                }
            }
            if (!hasWritten) {
                res.write(publishRes.toJSON());
            }
        }
        if (deliverRes != null) {
            if (enforceSubscriptionUnderPush) {
                for (Map.Entry<String, CometContext> entry : this.activeCometContexts.entrySet()) {
                    entry.getValue().notify(deliverRes);
                }
            } else {
                CometContext cc = this.getCometContext(publishReq.getChannel());
                this.log("Notifying " + publishReq.getChannel() + " to " + cc.getCometHandlers().size() + " CometHandler with message\n" + deliverRes);
                cc.notify(deliverRes);
            }
        }
        this.notifyEnd(publishReq);
    }

    private void notifyEnd(VerbBase verb) throws IOException {
        String clientId;
        if (verb.isLast() && (clientId = verb.getClientId()) != null) {
            Collection<String> subscribedChannels = null;
            DataHandler dataHandler = this.activeCometHandlers.get(clientId);
            if (dataHandler != null) {
                subscribedChannels = dataHandler.getChannels();
            }
            Collection<String> unsubscribedChannels = this.inactiveChannels.get(clientId);
            if (subscribedChannels != null && subscribedChannels.size() > 0 || unsubscribedChannels != null && unsubscribedChannels.size() > 0) {
                int i;
                if (subscribedChannels != null) {
                    i = 0;
                    for (String channel : subscribedChannels) {
                        this.log("Resuming subscribed " + channel);
                        if (i++ == 0) {
                            this.getCometContext(channel).notify("NOTIFY_END");
                            continue;
                        }
                        this.getCometContext(channel).getCometHandlers().remove(dataHandler);
                    }
                }
                if (unsubscribedChannels != null) {
                    i = 0;
                    for (String channel : unsubscribedChannels) {
                        this.log("Resuming unsubscribed " + channel);
                        if (i++ == 0) {
                            this.getCometContext(channel).notify("NOTIFY_END");
                            continue;
                        }
                        this.getCometContext(channel).getCometHandlers().remove(dataHandler);
                    }
                }
            }
            if (unsubscribedChannels != null) {
                unsubscribedChannels.clear();
                this.inactiveChannels.remove(clientId);
            }
        }
    }

    private String isAuthenticatedAndValid(VerbBase verb) {
        String clientId = verb.getClientId();
        if (clientId == null) {
            return null;
        }
        if (clientId != null && !this.authenticatedUsers.contains(clientId)) {
            return BayeuxParser.constructError("402", "Unknown Client", verb.getMetaChannel());
        }
        if (!verb.isValid()) {
            return BayeuxParser.constructError("501", "Invalid Operation", verb.getMetaChannel());
        }
        return null;
    }

    private static final String constructError(String errorMessage, String errorMsg, String meta) {
        StringBuilder sb = new StringBuilder();
        sb.append("[{\"successful\":false,\"error\":\"");
        sb.append(errorMessage);
        sb.append("::");
        sb.append(errorMsg);
        sb.append("\",\"advice\":{\"reconnect\":\"handshake\"},\"channel\":\"");
        sb.append(meta);
        sb.append("\"}]");
        return sb.toString();
    }

    private CometContext getCometContext(String channel) {
        CometContext cc = this.activeCometContexts.get(channel);
        if (cc == null) {
            cc = this.createCometContext(channel);
            this.activeCometContexts.put(channel, cc);
        }
        return cc;
    }

    private CometContext createCometContext(String channel) {
        this.log("Creating CometContext " + channel);
        CometContext cc = CometEngine.getEngine().register(channel);
        cc.setExpirationDelay(-1L);
        cc.setBlockingNotification(false);
        return cc;
    }

    private void log(String log) {
        if (Controller.logger().isLoggable(level)) {
            Controller.logger().log(level, log);
        }
    }

    public void onPing(CometdContext cometdContext) throws IOException {
    }

    public void onStatus(CometdContext cometdContext) throws IOException {
    }

    static {
        if (System.getProperty("com.sun.grizzly.cometd.logAll") != null) {
            level = Level.INFO;
        }
        if (System.getProperty("com.sun.grizzly.cometd.enforceSubscription") != null) {
            enforceSubscriptionUnderPush = false;
        }
    }
}

