/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.buf.HexUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;

public class CometWriter {
    private boolean isComplete = true;
    private SocketChannel socketChannel;
    protected byte[] chunkLength = new byte[10];
    private static final ByteBuffer end = ByteBuffer.wrap("0\r\n\r\n".getBytes());
    private boolean ready = true;

    public CometWriter() {
        this.chunkLength[8] = 13;
        this.chunkLength[9] = 10;
    }

    protected void setChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public int write(byte[] buf) throws IOException {
        return this.write(buf, 0, buf.length);
    }

    public int write(byte[] buf, int off, int len) throws IOException {
        int nWrite;
        if (!this.ready) {
            throw new IllegalStateException("This CometWriter is no longer usable.");
        }
        int pos = 7;
        if (this.isComplete) {
            for (int current = len; current > 0; current /= 16) {
                int digit = current % 16;
                this.chunkLength[pos--] = HexUtils.HEX[digit];
            }
            OutputWriter.flushChannel((SelectableChannel)this.socketChannel, (ByteBuffer)ByteBuffer.wrap(this.chunkLength, pos + 1, 9 - pos));
        }
        if ((nWrite = this.socketChannel.write(ByteBuffer.wrap(buf, off, len))) == len) {
            this.isComplete = true;
            OutputWriter.flushChannel((SelectableChannel)this.socketChannel, (ByteBuffer)ByteBuffer.wrap(this.chunkLength, 8, 2));
            OutputWriter.flushChannel((SelectableChannel)this.socketChannel, (ByteBuffer)end.slice());
        } else {
            this.isComplete = false;
        }
        return nWrite;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void recycle() {
        this.isComplete = true;
        this.socketChannel = null;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }
}

