/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.derby.client.am.ClientJDBCObjectFactory;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.am.Version;
import org.apache.derby.client.net.ClientJDBCObjectFactoryImpl;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.jdbc.ClientDataSource;

public class ClientDriver
implements Driver {
    private transient int traceFileSuffixIndex_ = 0;
    private static final int DERBY_REMOTE_PROTOCOL = 1;
    private static ClientJDBCObjectFactory factoryObject = null;
    private static SQLException exceptionsOnLoadDriver__ = null;
    private static ClientDriver registeredDriver__ = null;

    public Connection connect(String string, Properties properties) throws SQLException {
        NetConnection netConnection;
        try {
            int n;
            StringTokenizer stringTokenizer;
            int n2;
            if (exceptionsOnLoadDriver__ != null) {
                throw exceptionsOnLoadDriver__;
            }
            if (properties == null) {
                properties = new Properties();
            }
            if ((n2 = ClientDriver.tokenizeProtocol(string, stringTokenizer = new StringTokenizer(string, "/:= \t\n\r\f", true))) == 0) {
                return null;
            }
            String string2 = null;
            if (n2 == 1) {
                try {
                    string2 = stringTokenizer.nextToken(":/");
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new SqlException(null, new ClientMessageId("XJ028.C"), (Object)string, (Throwable)noSuchElementException);
                }
            }
            String string3 = ClientDriver.tokenizeServerName(stringTokenizer, string);
            int n3 = ClientDriver.tokenizeOptionalPortNumber(stringTokenizer, string);
            if (n3 == 0) {
                n3 = 1527;
            }
            String string4 = ClientDriver.tokenizeDatabase(stringTokenizer, string);
            Properties properties2 = ClientDriver.tokenizeURLProperties(string, properties);
            string4 = this.appendDatabaseAttributes(string4, properties2);
            try {
                n = ClientDataSource.getTraceLevel(properties2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SqlException(null, new ClientMessageId("XJ213.C"), numberFormatException);
            }
            LogWriter logWriter = ClientDataSource.computeDncLogWriterForNewConnection(DriverManager.getLogWriter(), ClientDataSource.getTraceDirectory(properties2), ClientDataSource.getTraceFile(properties2), ClientDataSource.getTraceFileAppend(properties2), n, "_driver", this.traceFileSuffixIndex_++);
            netConnection = (NetConnection)ClientDriver.getFactory().newNetConnection((LogWriter)((NetLogWriter)logWriter), DriverManager.getLoginTimeout(), string3, n3, string4, properties2);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        if (netConnection.isConnectionNull()) {
            return null;
        }
        return netConnection;
    }

    private String appendDatabaseAttributes(String string, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("user") || string2.equals("password") || string2.equals("ssl")) continue;
            stringBuffer.append(";" + string2 + "=" + properties.getProperty(string2));
        }
        return stringBuffer.toString();
    }

    public boolean acceptsURL(String string) throws SQLException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/:=; \t\n\r\f", true);
            int n = ClientDriver.tokenizeProtocol(string, stringTokenizer);
            return n != 0;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[2];
        if (properties == null) {
            properties = new Properties();
        }
        driverPropertyInfoArray[0] = new DriverPropertyInfo("user", properties.getProperty("user", "APP"));
        driverPropertyInfoArray[1] = new DriverPropertyInfo("password", properties.getProperty("password"));
        driverPropertyInfoArray[0].description = SqlException.getMessageUtil().getTextMessage("J132");
        driverPropertyInfoArray[1].description = SqlException.getMessageUtil().getTextMessage("J133");
        driverPropertyInfoArray[0].required = true;
        driverPropertyInfoArray[1].required = false;
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private static int tokenizeProtocol(String string, StringTokenizer stringTokenizer) throws SqlException {
        if (string == null) {
            return 0;
        }
        if (stringTokenizer == null) {
            return 0;
        }
        try {
            String string2 = stringTokenizer.nextToken(":");
            if (!string2.equals("jdbc")) {
                return 0;
            }
            if (!stringTokenizer.nextToken(":").equals(":")) {
                return 0;
            }
            String string3 = stringTokenizer.nextToken(":");
            int n = 0;
            if (!string3.equals("derby") || string.indexOf("derby://") == -1) {
                return 0;
            }
            n = 1;
            if (!stringTokenizer.nextToken(":").equals(":")) {
                return 0;
            }
            return n;
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
    }

    private static String tokenizeServerName(StringTokenizer stringTokenizer, String string) throws SqlException {
        try {
            if (!stringTokenizer.nextToken("/").equals("/")) {
                throw new SqlException(null, new ClientMessageId("XJ028.C"), string);
            }
            return stringTokenizer.nextToken("/:");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SqlException(null, new ClientMessageId("XJ028.C"), string);
        }
    }

    private static int tokenizeOptionalPortNumber(StringTokenizer stringTokenizer, String string) throws SqlException {
        try {
            String string2 = stringTokenizer.nextToken(":/");
            if (string2.equals(":")) {
                String string3 = stringTokenizer.nextToken("/");
                if (!stringTokenizer.nextToken("/").equals("/")) {
                    throw new SqlException(null, new ClientMessageId("XJ028.C"), string);
                }
                return Integer.parseInt(string3);
            }
            if (string2.equals("/")) {
                return 0;
            }
            throw new SqlException(null, new ClientMessageId("XJ028.C"), string);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SqlException(null, new ClientMessageId("XJ028.C"), (Object)string, (Throwable)noSuchElementException);
        }
    }

    private static String tokenizeDatabase(StringTokenizer stringTokenizer, String string) throws SqlException {
        try {
            String string2 = stringTokenizer.nextToken("\t\n\r\f;");
            return string2;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SqlException(null, new ClientMessageId("XJ028.C"), (Object)string, (Throwable)noSuchElementException);
        }
    }

    private static Properties tokenizeURLProperties(String string, Properties properties) throws SqlException {
        String string2 = null;
        int n = -1;
        if (string != null && (n = string.indexOf(";")) != -1) {
            string2 = string.substring(n);
        }
        return ClientDataSource.tokenizeAttributes(string2, properties);
    }

    public static ClientJDBCObjectFactory getFactory() {
        if (factoryObject != null) {
            return factoryObject;
        }
        factoryObject = Configuration.supportsJDBC40() ? ClientDriver.createJDBC40FactoryImpl() : ClientDriver.createDefaultFactoryImpl();
        return factoryObject;
    }

    private static ClientJDBCObjectFactory createDefaultFactoryImpl() {
        return new ClientJDBCObjectFactoryImpl();
    }

    private static ClientJDBCObjectFactory createJDBC40FactoryImpl() {
        try {
            return (ClientJDBCObjectFactory)Class.forName("org.apache.derby.client.net.ClientJDBCObjectFactoryImpl40").newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return ClientDriver.createDefaultFactoryImpl();
        }
        catch (InstantiationException instantiationException) {
            return ClientDriver.createDefaultFactoryImpl();
        }
        catch (IllegalAccessException illegalAccessException) {
            return ClientDriver.createDefaultFactoryImpl();
        }
    }

    static {
        if (Configuration.exceptionsOnLoadResources != null) {
            exceptionsOnLoadDriver__ = Utils.accumulateSQLException(Configuration.exceptionsOnLoadResources.getSQLException(), exceptionsOnLoadDriver__);
        }
        try {
            registeredDriver__ = new ClientDriver();
            DriverManager.registerDriver(registeredDriver__);
        }
        catch (SQLException sQLException) {
            exceptionsOnLoadDriver__ = new SqlException(null, new ClientMessageId("XBM0N.D")).getSQLException();
            exceptionsOnLoadDriver__.setNextException(sQLException);
        }
    }
}

