/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class VirtualColumnNode
extends ValueNode {
    private ResultSetNode sourceResultSet;
    private ResultColumn sourceColumn;
    int columnId;
    private boolean correlated = false;

    public void init(Object object, Object object2, Object object3) throws StandardException {
        ResultColumn resultColumn = (ResultColumn)object2;
        this.sourceResultSet = (ResultSetNode)object;
        this.sourceColumn = resultColumn;
        this.columnId = (Integer)object3;
        this.setType(resultColumn.getTypeServices());
    }

    public void printSubNodes(int n) {
    }

    public ResultSetNode getSourceResultSet() {
        return this.sourceResultSet;
    }

    public ResultColumn getSourceColumn() {
        return this.sourceColumn;
    }

    public String getTableName() {
        return this.sourceColumn.getTableName();
    }

    public String getSchemaName() throws StandardException {
        return this.sourceColumn.getSchemaName();
    }

    public boolean updatableByCursor() {
        return this.sourceColumn.updatableByCursor();
    }

    public ResultColumn getSourceResultColumn() {
        return this.sourceColumn;
    }

    void setCorrelated() {
        this.correlated = true;
    }

    boolean getCorrelated() {
        return this.correlated;
    }

    public boolean isCloneable() {
        return true;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = this.sourceColumn.getResultSetNumber();
        if (this.sourceColumn.isRedundant()) {
            this.sourceColumn.getExpression().generateExpression(expressionClassBuilder, methodBuilder);
            return;
        }
        expressionClassBuilder.pushColumnReference(methodBuilder, n, this.sourceColumn.getVirtualColumnId());
        methodBuilder.cast(this.sourceColumn.getTypeCompiler().interfaceName());
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.sourceColumn.getOrderableVariantType();
    }

    public DataTypeDescriptor getTypeServices() {
        return this.sourceColumn.getTypeServices();
    }

    public void setType(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        this.sourceColumn.setType(dataTypeDescriptor);
    }

    protected boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (this.isSameNodeType(valueNode)) {
            VirtualColumnNode virtualColumnNode = (VirtualColumnNode)valueNode;
            return this.sourceColumn.isEquivalent(virtualColumnNode.sourceColumn);
        }
        return false;
    }
}

