/*
 * Decompiled with CFR 0.152.
 */
package pkg.sun.servicetag;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import pkg.sun.servicetag.ServiceTag;
import pkg.sun.servicetag.UnauthorizedAccessException;
import pkg.sun.servicetag.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry {
    private static final String STCLIENT_SOLARIS = "/usr/bin/stclient";
    private static final String STCLIENT_LINUX = "/opt/sun/servicetag/bin/stclient";
    private static final int ST_ERR_NOT_AUTH = 245;
    private static final int ST_ERR_REC_NOT_FOUND = 225;
    private static final String INSTANCE_URN_DESC = "Product instance URN=";
    private static boolean initialized = false;
    private static boolean supportsHelperClass = true;
    private static File stclient = null;
    private static String stclientPath = null;
    private static Registry registry = new Registry();
    private static String SVCTAG_STCLIENT_CMD = "servicetag.stclient.cmd";
    private static String SVCTAG_STHELPER_SUPPORTED = "servicetag.sthelper.supported";

    private Registry() {
    }

    private static synchronized String getSTclient() {
        if (!initialized) {
            if (System.getProperty(SVCTAG_STHELPER_SUPPORTED) != null) {
                supportsHelperClass = Boolean.getBoolean(SVCTAG_STHELPER_SUPPORTED);
            }
            if ((stclientPath = System.getProperty(SVCTAG_STCLIENT_CMD)) != null) {
                return stclientPath;
            }
            String string = System.getProperty("os.name");
            if (string.equals("SunOS")) {
                stclient = new File(STCLIENT_SOLARIS);
            } else if (string.equals("Linux")) {
                stclient = new File(STCLIENT_LINUX);
            } else if (string.startsWith("Windows")) {
                stclient = Util.getWindowsStClientFile();
            } else if (Util.isVerbose()) {
                System.out.println("Running on non-Sun JDK");
            }
            initialized = true;
        }
        if (stclientPath == null && stclient != null && stclient.exists()) {
            stclientPath = stclient.getAbsolutePath();
        }
        return stclientPath;
    }

    public static Registry getSystemRegistry() {
        if (Registry.isSupported()) {
            return registry;
        }
        throw new UnsupportedOperationException("Registry class is not supported");
    }

    public static boolean isSupported() {
        return Registry.getSTclient() != null && supportsHelperClass;
    }

    private static List<String> getCommandList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (System.getProperty(SVCTAG_STCLIENT_CMD) != null) {
            String string = Registry.getSTclient();
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                int n3;
                char c = ' ';
                if (string.charAt(n2) == '\"') {
                    c = '\"';
                    ++n2;
                }
                for (n3 = n2 + 1; n3 < n && string.charAt(n3) != c; ++n3) {
                }
                if (n2 == n3 - 1) {
                    arrayList.add("\"\"");
                } else {
                    arrayList.add(string.substring(n2, n3));
                }
                for (n2 = n3 + 1; n2 < n && Character.isSpaceChar(string.charAt(n2)); ++n2) {
                }
            }
            if (Util.isVerbose()) {
                System.out.println("Command list:");
                for (String string2 : arrayList) {
                    System.out.println(string2);
                }
            }
        } else {
            arrayList.add(Registry.getSTclient());
        }
        return arrayList;
    }

    private static ServiceTag checkReturnError(int n, String string, ServiceTag serviceTag) throws IOException {
        switch (n) {
            case 225: {
                return null;
            }
            case 245: {
                if (serviceTag != null) {
                    throw new UnauthorizedAccessException("Not authorized to access " + serviceTag.getInstanceURN() + " installer_uid=" + serviceTag.getInstallerUID());
                }
                throw new UnauthorizedAccessException("Not authorized:" + string);
            }
        }
        throw new IOException("stclient exits with error (" + n + ")\n" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceTag addServiceTag(ServiceTag serviceTag) throws IOException {
        Object object;
        List<String> list = Registry.getCommandList();
        list.add("-a");
        if (serviceTag.getInstanceURN().length() > 0) {
            object = this.getServiceTag(serviceTag.getInstanceURN());
            if (object != null) {
                throw new IllegalArgumentException("Instance_urn = " + serviceTag.getInstanceURN() + " already exists");
            }
            list.add("-i");
            list.add(serviceTag.getInstanceURN());
        }
        list.add("-p");
        list.add(serviceTag.getProductName());
        list.add("-e");
        list.add(serviceTag.getProductVersion());
        list.add("-t");
        list.add(serviceTag.getProductURN());
        if (serviceTag.getProductParentURN().length() > 0) {
            list.add("-F");
            list.add(serviceTag.getProductParentURN());
        }
        list.add("-P");
        list.add(serviceTag.getProductParent());
        if (serviceTag.getProductDefinedInstanceID().length() > 0) {
            list.add("-I");
            list.add(serviceTag.getProductDefinedInstanceID());
        }
        list.add("-m");
        list.add(serviceTag.getProductVendor());
        list.add("-A");
        list.add(serviceTag.getPlatformArch());
        list.add("-z");
        list.add(serviceTag.getContainer());
        list.add("-S");
        list.add(serviceTag.getSource());
        object = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(list);
            Process process = processBuilder.start();
            String string = Util.commandOutput(process);
            if (Util.isVerbose()) {
                System.out.println("Output from stclient -a command:");
                System.out.println(string);
            }
            String string2 = "";
            if (process.exitValue() == 0) {
                object = new BufferedReader(new StringReader(string));
                String string3 = null;
                while ((string3 = ((BufferedReader)object).readLine()) != null) {
                    if (!(string3 = string3.trim()).startsWith(INSTANCE_URN_DESC)) continue;
                    string2 = string3.substring(INSTANCE_URN_DESC.length());
                    break;
                }
                if (string2.length() == 0) {
                    throw new IOException("Error in creating service tag:\n" + string);
                }
                ServiceTag serviceTag2 = this.getServiceTag(string2);
                return serviceTag2;
            }
            ServiceTag serviceTag3 = Registry.checkReturnError(process.exitValue(), string, serviceTag);
            return serviceTag3;
        }
        finally {
            if (object != null) {
                ((BufferedReader)object).close();
            }
        }
    }

    public ServiceTag removeServiceTag(String string) throws IOException {
        ServiceTag serviceTag = this.getServiceTag(string);
        if (serviceTag == null) {
            return null;
        }
        List<String> list = Registry.getCommandList();
        list.add("-d");
        list.add("-i");
        list.add(string);
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        Process process = processBuilder.start();
        String string2 = Util.commandOutput(process);
        if (Util.isVerbose()) {
            System.out.println("Output from stclient -d command:");
            System.out.println(string2);
        }
        if (process.exitValue() == 0) {
            return serviceTag;
        }
        return Registry.checkReturnError(process.exitValue(), string2, serviceTag);
    }

    public ServiceTag updateServiceTag(String string, String string2) throws IOException {
        ServiceTag serviceTag = this.getServiceTag(string);
        if (serviceTag == null) {
            return null;
        }
        List<String> list = Registry.getCommandList();
        list.add("-u");
        list.add("-i");
        list.add(string);
        list.add("-I");
        if (string2.length() > 0) {
            list.add(string2);
        } else {
            list.add("\"\"");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        Process process = processBuilder.start();
        String string3 = Util.commandOutput(process);
        if (Util.isVerbose()) {
            System.out.println("Output from stclient -u command:");
            System.out.println(string3);
        }
        if (process.exitValue() == 0) {
            return this.getServiceTag(string);
        }
        return Registry.checkReturnError(process.exitValue(), string3, serviceTag);
    }

    public ServiceTag getServiceTag(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("instanceURN is null");
        }
        List<String> list = Registry.getCommandList();
        list.add("-g");
        list.add("-i");
        list.add(string);
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        Process process = processBuilder.start();
        String string2 = Util.commandOutput(process);
        if (Util.isVerbose()) {
            System.out.println("Output from stclient -g command:");
            System.out.println(string2);
        }
        if (process.exitValue() == 0) {
            return this.parseServiceTag(string2);
        }
        return Registry.checkReturnError(process.exitValue(), string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceTag parseServiceTag(String string) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String[] stringArray;
            Properties properties = new Properties();
            bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).length() <= 0) continue;
                stringArray = string2.trim().split("=", 2);
                if (stringArray.length == 2) {
                    properties.setProperty(stringArray[0].trim(), stringArray[1].trim());
                    continue;
                }
                properties.setProperty(stringArray[0].trim(), "");
            }
            stringArray = properties.getProperty("instance_urn");
            String string3 = properties.getProperty("product_name");
            String string4 = properties.getProperty("product_version");
            String string5 = properties.getProperty("product_urn");
            String string6 = properties.getProperty("product_parent");
            String string7 = properties.getProperty("product_parent_urn");
            String string8 = properties.getProperty("product_defined_inst_id");
            String string9 = properties.getProperty("product_vendor");
            String string10 = properties.getProperty("platform_arch");
            String string11 = properties.getProperty("container");
            String string12 = properties.getProperty("source");
            int n = Util.getIntValue(properties.getProperty("installer_uid"));
            Date date = Util.parseTimestamp(properties.getProperty("timestamp"));
            ServiceTag serviceTag = new ServiceTag((String)stringArray, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, n, date);
            return serviceTag;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServiceTag> findServiceTags(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("productURN is null");
        }
        List<String> list = Registry.getCommandList();
        list.add("-f");
        list.add("-t");
        list.add(string);
        BufferedReader bufferedReader = null;
        try {
            Object object;
            ProcessBuilder processBuilder = new ProcessBuilder(list);
            Process process = processBuilder.start();
            String string2 = Util.commandOutput(process);
            HashSet<ServiceTag> hashSet = new HashSet<ServiceTag>();
            if (process.exitValue() == 0) {
                bufferedReader = new BufferedReader(new StringReader(string2));
                object = null;
                while ((object = bufferedReader.readLine()) != null) {
                    String string3 = ((String)object).trim();
                    if (!string3.startsWith("urn:st:")) continue;
                    hashSet.add(this.getServiceTag(string3));
                }
            } else {
                Registry.checkReturnError(process.exitValue(), string2, null);
            }
            object = hashSet;
            return object;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }
}

