/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.jaxr;

import com.sun.connector.jaxr.JaxrConnectionFactory;
import com.sun.connector.jaxr.JaxrConnectionRequestInfo;
import com.sun.connector.jaxr.JaxrManagedConnection;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.PasswordAuthentication;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.security.auth.Subject;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;

public class NoTxManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    static final String QUERY_URL_PROP = "javax.xml.registry.queryManagerURL";
    static final String LIFE_CYCLE_URL_PROP = "javax.xml.registry.lifeCycleManagerURL";
    static final String HTTP_PROXY_HOST = "com.sun.xml.registry.http.proxyHost";
    static final String HTTP_PROXY_PORT = "com.sun.xml.registry.http.proxyPort";
    static final String HTTPS_PROXY_HOST = "com.sun.xml.registry.https.proxyHost";
    static final String HTTPS_PROXY_PORT = "com.sun.xml.registry.https.proxyPort";
    static final String PROXY_USER_NAME = "com.sun.xml.registry.http.proxyUserName";
    static final String PROXY_PASSWORD = "com.sun.xml.registry.http.proxyPassword";
    static final String USER_DEF_TAXONOMIES = "com.sun.xml.registry.userTaxonomyFilenames";
    static final String USERNAME = "com.sun.xml.registry.userName";
    static final String PASSWORD = "com.sun.xml.registry.userPassword";
    static final String APPSERV_PROPERTY = "com.sun.appserv.uddi";
    private ResourceAdapter ra;
    private String queryManagerURL;
    private String lifeCycleManagerURL;
    private String httpProxyHost;
    private String httpProxyPort;
    private String httpsProxyHost;
    private String httpsProxyPort;
    private String proxyUsername;
    private String proxyUserPassword;
    private Properties properties;
    private PrintWriter out;
    private String userName;
    private String userPassword;
    private Boolean appserverUDDI = new Boolean(true);
    Log log = LogFactory.getLog((String)"com.sun.connector.jaxr");

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"NoTxManagedConnectionFactory returing JAXRConnectionFactory with ConnectionManager");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("NoTxManagedConnectionFactory - ConnectionManager class is " + connectionManager.getClass().getName()));
        }
        return new JaxrConnectionFactory(this, connectionManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        return new JaxrConnectionFactory(this, null);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Properties properties = null;
        try {
            Connection connection = null;
            if (connectionRequestInfo != null) {
                properties = ((JaxrConnectionRequestInfo)connectionRequestInfo).getProperties();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"NoTxManagedConnectionFactory creating JAXRManagedConnection");
            }
            ConnectionFactory connectionFactory = ConnectionFactory.newInstance();
            this.populateProperties(properties);
            if (this.properties != null) {
                connectionFactory.setProperties(this.properties);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"NoTxManagedConnectionFactory creating actual jaxr ConnectionImpl");
            }
            connection = connectionFactory.createConnection();
            if (this.userName != null) {
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(this.userName, this.userPassword.toCharArray());
                HashSet<PasswordAuthentication> hashSet = new HashSet<PasswordAuthentication>();
                hashSet.add(passwordAuthentication);
                connection.setCredentials(hashSet);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"NoTxManagedConnectionFactory returning new JAXRManagedConnection");
            }
            return new JaxrManagedConnection((ManagedConnectionFactory)this, this.properties, null, connection, false, false);
        }
        catch (Exception exception) {
            EISSystemException eISSystemException = new EISSystemException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("JAXRException:") + exception.getMessage());
            eISSystemException.setLinkedException(exception);
            throw eISSystemException;
        }
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"NoTxManagedConnectionFactory MatchingManagedConnections");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"NoTxManagedConnectionFactory mC - let's interate through the connectionSet passed as parameter by Appserer");
        }
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JaxrManagedConnection jaxrManagedConnection = (JaxrManagedConnection)iterator.next();
            jaxrManagedConnection.destroy();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"NoTxManagedConnectionFactory mC - interate - got JaxrManagedconnection ");
            }
            ++n;
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("NoTxManagedConnec - JaxrManagedconnection number " + n));
        }
        set.clear();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"NoTxManagedConnec - returning noMantched Connections");
        }
        return null;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.out = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof NoTxManagedConnectionFactory) {
            Properties properties = ((NoTxManagedConnectionFactory)object).properties;
            Properties properties2 = this.properties;
            return properties == null ? properties2 == null : properties.equals(properties2);
        }
        return false;
    }

    public int hashCode() {
        if (this.properties == null) {
            return new String("").hashCode();
        }
        return this.properties.hashCode();
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.ra = resourceAdapter;
    }

    public String getQueryManagerURL() {
        return this.queryManagerURL;
    }

    public void setQueryManagerURL(String string) {
        this.queryManagerURL = string;
    }

    public String getLifeCycleManagerURL() {
        return this.lifeCycleManagerURL;
    }

    public void setLifeCycleManagerURL(String string) {
        this.lifeCycleManagerURL = string;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserPassword(String string) {
        this.userPassword = string;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public Boolean getAppserverUDDI() {
        return this.appserverUDDI;
    }

    public void setAppserverUDDI(Boolean bl) {
        this.appserverUDDI = bl;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String string) {
        this.httpProxyHost = string;
    }

    public String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(String string) {
        this.httpProxyPort = string;
    }

    public String getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    public void setHttpsProxyHost(String string) {
        this.httpsProxyHost = string;
    }

    public String getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    public void setHttpsProxyPort(String string) {
        this.httpsProxyPort = string;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String string) {
        this.proxyUsername = string;
    }

    public String getProxyUserPassword() {
        return this.proxyUserPassword;
    }

    public void setProxyUserPassword(String string) {
        this.proxyUserPassword = string;
    }

    void populateDefaultProperties(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        if (this.queryManagerURL != null) {
            properties.put(QUERY_URL_PROP, this.queryManagerURL);
        }
        if (this.lifeCycleManagerURL != null) {
            properties.put(LIFE_CYCLE_URL_PROP, this.lifeCycleManagerURL);
        }
        if (this.httpProxyHost != null) {
            properties.put(HTTP_PROXY_HOST, this.httpProxyHost);
        }
        if (this.httpProxyPort != null) {
            properties.put(HTTP_PROXY_PORT, this.httpProxyPort);
        }
        if (this.httpsProxyHost != null) {
            properties.put(HTTPS_PROXY_HOST, this.httpsProxyHost);
        }
        if (this.httpsProxyPort != null) {
            properties.put(HTTPS_PROXY_PORT, this.httpsProxyPort);
        }
        if (this.proxyUsername != null) {
            properties.put(PROXY_USER_NAME, this.proxyUsername);
        }
        if (this.proxyUserPassword != null) {
            properties.put(PROXY_PASSWORD, this.proxyUserPassword);
        }
        if (this.userName != null) {
            properties.put(USERNAME, this.userName);
        }
        if (this.userPassword != null) {
            properties.put(PASSWORD, this.userPassword);
        }
        if (this.appserverUDDI != null) {
            properties.put(APPSERV_PROPERTY, this.appserverUDDI);
        }
    }

    void populateProperties(Properties properties) {
        Boolean bl;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (properties == null) {
            this.populateDefaultProperties(this.properties);
            return;
        }
        String string10 = properties.getProperty(QUERY_URL_PROP);
        if (string10 == null) {
            string10 = this.queryManagerURL;
        }
        if (string10 != null) {
            this.properties.put(QUERY_URL_PROP, string10);
        }
        if ((string9 = properties.getProperty(LIFE_CYCLE_URL_PROP)) == null) {
            string9 = this.lifeCycleManagerURL;
        }
        if (string9 != null) {
            this.properties.put(LIFE_CYCLE_URL_PROP, string9);
        }
        if ((string8 = properties.getProperty(HTTP_PROXY_HOST)) == null) {
            string8 = this.httpProxyHost;
        }
        if (string8 != null) {
            this.properties.put(HTTP_PROXY_HOST, string8);
        }
        if ((string7 = properties.getProperty(HTTP_PROXY_PORT)) == null) {
            string7 = this.httpProxyPort;
        }
        if (string7 != null) {
            this.properties.put(HTTP_PROXY_PORT, string7);
        }
        if ((string6 = properties.getProperty(HTTPS_PROXY_HOST)) == null) {
            string6 = this.httpsProxyHost;
        }
        if (string6 != null) {
            this.properties.put(HTTPS_PROXY_HOST, string6);
        }
        if ((string5 = properties.getProperty(HTTPS_PROXY_PORT)) == null) {
            string5 = this.httpsProxyPort;
        }
        if (string5 != null) {
            this.properties.put(HTTPS_PROXY_PORT, string5);
        }
        if ((string4 = properties.getProperty(PROXY_USER_NAME)) == null) {
            string4 = this.proxyUsername;
        }
        if (string4 != null) {
            this.properties.put(PROXY_USER_NAME, string4);
        }
        if ((string3 = properties.getProperty(PROXY_PASSWORD)) == null) {
            string3 = this.proxyUserPassword;
        }
        if (string3 != null) {
            this.properties.put(PROXY_PASSWORD, string3);
        }
        if ((string2 = properties.getProperty(USERNAME)) == null) {
            string2 = this.userName;
        }
        if (string2 != null) {
            this.properties.put(USERNAME, string2);
        }
        if ((string = properties.getProperty(PASSWORD)) == null) {
            string = this.userPassword;
        }
        if (string != null) {
            this.properties.put(PASSWORD, string);
        }
        if ((bl = Boolean.valueOf(properties.getProperty(APPSERV_PROPERTY))) == null) {
            bl = this.appserverUDDI;
        }
        this.properties.put(APPSERV_PROPERTY, Boolean.toString(bl));
    }
}

