/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.MetricCounters;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public abstract class IMQConnection
extends Connection
implements EventListener {
    public static final boolean DEBUG_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn");
    private String destroyReason = null;
    protected int msgsToConsumer = 0;
    protected int msgsIn = 0;
    private int pauseFlowCnt = 0;
    private int resumeFlowCnt = 0;
    boolean BLOCKING = false;
    Set tmpDestinations = Collections.synchronizedSet(new HashSet());
    public static final String CLIENT_ID = "client id";
    public static final String TRANSACTION_LIST = "transaction";
    public static final String TRANSACTION_IDMAP = "tidmap";
    public static final String TRANSACTION_CACHE = "txncache";
    public static final String USER_AGENT = "useragent";
    static boolean DEBUG = Globals.getConfig().getBooleanProperty("imq.packet.debug.info");
    protected MetricCounters counters = new MetricCounters();
    ConnectionInfo coninfo;
    byte[] empty = new byte[]{0};
    byte[] remoteIP = this.empty;
    protected boolean runningMsgs = false;
    protected boolean paused = false;
    protected boolean waitingForResumeFlow = false;
    protected int flowCount = 0;
    protected int sent_count = 0;
    Object stateLock = new Object();
    boolean busy = false;
    HashMap producers = new HashMap();
    HashMap sessions = new HashMap();
    HashMap lockToSession = new HashMap();
    Set busySessions = Collections.synchronizedSet(new LinkedHashSet());

    public void setDestroyReason(String string) {
        this.destroyReason = string;
    }

    public String getDestroyReason() {
        return this.destroyReason;
    }

    public void debug(String string) {
        if (string == null) {
            string = "";
        }
        this.dumpState();
        Iterator iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            ((Session)iterator.next()).debug("  ");
        }
    }

    public IMQConnection(Service service) throws BrokerException {
        super(service);
        this.setConnectionUID(new ConnectionUID());
        this.accessController = AccessController.getInstance(service.getName(), service.getServiceType());
        this.sessions = new HashMap();
    }

    public void dumpState() {
        this.logger.log(8, "Dumping state of " + this);
        this.logger.log(8, "\tsessions = " + this.sessions.size());
        this.logger.log(8, "\tbusySessions = " + this.busySessions.size());
        this.logger.log(8, "\trunningMsgs = " + this.runningMsgs);
        this.logger.log(8, "\tpaused = " + this.paused);
        this.logger.log(8, "\twaitingForResumeFlow = " + this.waitingForResumeFlow);
    }

    public boolean isBlocking() {
        return this.BLOCKING;
    }

    public void dump() {
        this.logger.log(8, "DUMPING CONNECTION " + this);
        this.dumpState();
        this.logger.log(8, "Sessions (size) :" + this.sessions.size());
        this.logger.log(8, "Sessions (list) :" + this.sessions);
        this.logger.log(8, "Busy (size) :" + this.busySessions.size());
        this.logger.log(8, "Busy (list) :" + this.busySessions);
        this.logger.log(8, "----------- sessions -----------");
        Iterator iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            ((Session)iterator.next()).dump("\t");
        }
        this.logger.log(8, "----------- busy sessions -----------");
        iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            this.logger.log(8, "\t" + ((Session)iterator.next()).toString());
        }
    }

    public synchronized Hashtable getDebugState() {
        Vector<String> vector;
        Hashtable hashtable = super.getDebugState();
        hashtable.put("pauseFlowCnt", String.valueOf(this.pauseFlowCnt));
        hashtable.put("resumeFlowCnt", String.valueOf(this.resumeFlowCnt));
        hashtable.put("producerCnt", String.valueOf(this.producers.size()));
        if (this.producers.size() > 0) {
            vector = new Vector<String>();
            for (Object object : this.producers.keySet()) {
                vector.add(object.toString());
            }
            hashtable.put("producers", vector);
        }
        hashtable.put("msgsToConsumer", String.valueOf(this.msgsToConsumer));
        hashtable.put("sessionCnt", String.valueOf(this.sessions.size()));
        if (this.sessions.size() > 0) {
            vector = new Vector();
            for (Object object : this.sessions.values()) {
                vector.add(((Session)object).getSessionUID().toString());
            }
            hashtable.put("sessions", vector);
        }
        hashtable.put("busySessionCnt", String.valueOf(this.busySessions.size()));
        if (this.busySessions.size() > 0) {
            vector = new Vector();
            for (Object object : this.busySessions) {
                vector.add(((Session)object).getSessionUID().toString());
            }
            hashtable.put("busySessions", vector);
        }
        hashtable.put("tempDestCnt", String.valueOf(this.tmpDestinations.size()));
        if (this.tmpDestinations.size() > 0) {
            vector = new Vector();
            for (Object object : this.tmpDestinations) {
                vector.add(((DestinationUID)object).toString());
            }
            hashtable.put("tempDestinations", vector);
        }
        hashtable.put("runningMsgs", String.valueOf(this.runningMsgs));
        hashtable.put("paused", String.valueOf(this.paused));
        hashtable.put("waitingForResumeFlow", String.valueOf(this.waitingForResumeFlow));
        hashtable.put("flowCount", String.valueOf(this.flowCount));
        hashtable.put("sentCount", String.valueOf(this.sent_count));
        hashtable.put("userName", this.getUserName());
        hashtable.put("remoteString", this.getRemoteConnectionString());
        return hashtable;
    }

    public Vector getDebugMessages(boolean bl) {
        Vector vector = new Vector();
        return vector;
    }

    public void setRemoteIP(byte[] byArray) {
        this.remoteIP = byArray;
        if (this.coninfo != null) {
            this.coninfo.remoteIP = byArray;
        }
    }

    public byte[] getRemoteIP() {
        return this.remoteIP;
    }

    public void resetCounters() {
        this.counters = new MetricCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionInfo getConnectionInfo() {
        if (this.coninfo == null) {
            this.coninfo = new ConnectionInfo();
            this.coninfo.id = this.conId == null ? this.empty : this.conId.toString().getBytes();
            this.coninfo.remoteIP = this.remoteIP;
            this.coninfo.service = this.service.getName();
        }
        this.coninfo.user = null;
        Principal principal = null;
        try {
            principal = this.getAuthenticatedName();
            if (principal != null) {
                this.coninfo.user = principal.getName();
            }
        }
        catch (BrokerException brokerException) {
            this.logger.log(4, "Exception getting authentication name " + (Object)((Object)this.conId));
            this.coninfo.user = brokerException.getMessage();
        }
        this.coninfo.uuid = this.conId.longValue();
        this.coninfo.metrics = (MetricCounters)this.counters.clone();
        this.coninfo.clientID = (String)this.getClientData(CLIENT_ID);
        this.coninfo.nproducers = this.producers.size();
        this.coninfo.userAgent = (String)this.getClientData(USER_AGENT);
        if (this.coninfo.userAgent == null) {
            this.coninfo.userAgent = "";
        }
        int n = 0;
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Iterator iterator = this.sessions.values().iterator();
            while (iterator.hasNext()) {
                n += ((Session)iterator.next()).getConsumerCnt();
            }
        }
        this.coninfo.nconsumers = n;
        return this.coninfo;
    }

    public MetricCounters getMetricCounters() {
        return this.counters;
    }

    public abstract boolean useDirectBuffers();

    public boolean isValid() {
        return this.getConnectionState() < 7;
    }

    public boolean isAuthenticated() {
        return this.getConnectionState() == 4;
    }

    public boolean isStarted() {
        return this.getConnectionState() > 1;
    }

    public boolean isBeingDestroyed() {
        return this.getConnectionState() > 4;
    }

    public boolean equals(Object object) {
        if (object instanceof ConnectionUID) {
            return object.equals((Object)this.getConnectionUID());
        }
        if (object instanceof Connection) {
            return ((Connection)object).getConnectionUID().equals((Object)this.getConnectionUID());
        }
        return false;
    }

    public int hashCode() {
        if (this.conId == null) {
            return 0;
        }
        return this.conId.hashCode();
    }

    public String toString() {
        return "IMQConn[" + IMQConnection.getConnectionStateString(this.state) + "," + this.getRemoteConnectionString() + "," + this.localServiceString() + "]";
    }

    public String toDebugString() {
        return super.toString() + " state: " + this.state;
    }

    public abstract String remoteHostString();

    public abstract String getRemoteConnectionString();

    protected abstract String localServiceString();

    public String getUserName() {
        String string = "???";
        try {
            Principal principal = this.getAuthenticatedName();
            if (principal != null) {
                string = principal.getName();
            }
        }
        catch (BrokerException brokerException) {
            this.logger.log(4, "Exception getting authentication name " + (Object)((Object)this.conId), (Throwable)brokerException);
        }
        return string;
    }

    public String userReadableString() {
        return this.getRemoteConnectionString() + "->" + this.localServiceString();
    }

    public void setFlowCount(int n) {
        this.flowCount = n;
    }

    public int getFlowCount() {
        return this.flowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeFlow(int n) {
        this.sent_count = 0;
        if (n != -1) {
            this.setFlowCount(n);
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.waitingForResumeFlow = false;
            ++this.resumeFlowCnt;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void haltFlow() {
        Object object = this.stateLock;
        synchronized (object) {
            this.waitingForResumeFlow = true;
            ++this.pauseFlowCnt;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConnection() {
        Object object = this.stateLock;
        synchronized (object) {
            this.runningMsgs = true;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionStarted() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.runningMsgs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopConnection() {
        Object object = this.stateLock;
        synchronized (object) {
            this.runningMsgs = false;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this.stateLock;
        synchronized (object) {
            this.paused = true;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.stateLock;
        synchronized (object) {
            this.paused = false;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cleanupConnection() {
        boolean bl = false;
        try {
            if (this.state >= 5) {
                this.wakeup();
                bl = true;
                Object var3_2 = null;
                if (!bl) {
                    this.state = 4;
                }
                return;
            }
            if (this.state < 5) {
                this.state = 5;
            }
            this.stopConnection();
            this.cleanup(false);
            this.wakeup();
            bl = true;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!bl) {
                this.state = 4;
            }
            throw throwable;
        }
        Object var3_3 = null;
        if (!bl) {
            this.state = 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup(boolean bl) {
        try {
            if (!bl) {
                this.cleanUpConsumers();
                this.cleanUpProducers();
            }
            this.cleanUpTransactions();
            this.lockToSession.clear();
            this.sessions.clear();
            this.busySessions.clear();
            this.cleanUpTempDest(bl);
            this.cleanupControlPackets(bl);
            Object var3_2 = null;
            Globals.getClusterBroadcast().connectionClosed(this.getConnectionUID(), this.isAdminConnection());
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Globals.getClusterBroadcast().connectionClosed(this.getConnectionUID(), this.isAdminConnection());
            throw throwable;
        }
    }

    protected abstract void cleanupControlPackets(boolean var1);

    private synchronized void cleanUpTransactions() {
        this.logger.log(4, "Cleaning up transactions on connection " + this);
        List list = (List)this.getClientData(TRANSACTION_LIST);
        if (list != null) {
            boolean bl = Globals.getConfig().getBooleanProperty("imq.transaction.detachedRetainAll", false);
            ArrayList<TransactionUID> arrayList = new ArrayList<TransactionUID>();
            TransactionList transactionList = Globals.getTransactionList();
            TransactionUID transactionUID2 = null;
            boolean bl2 = false;
            TransactionHandler transactionHandler = (TransactionHandler)Globals.getPacketRouter(0).getHandler(48);
            TransactionUID[] transactionUIDArray = list.toArray(new TransactionUID[0]);
            for (int i = 0; i < transactionUIDArray.length; ++i) {
                Object[] objectArray;
                transactionUID2 = transactionUIDArray[i];
                TransactionState transactionState = Globals.getTransactionList().retrieveState(transactionUID2);
                if (transactionState == null) continue;
                int n = transactionState.getState();
                if (transactionState.getXid() != null) {
                    if (bl) {
                        if (bl2) continue;
                        this.logger.log(8, Globals.getBrokerResources().getKString("B1282"));
                        bl2 = true;
                        continue;
                    }
                    if (n > 4) {
                        objectArray = new String[]{"" + transactionUID2 + "(XID=" + transactionState.getXid() + ")", TransactionState.toString(n), this.getConnectionUID().toString()};
                        this.logger.log(8, Globals.getBrokerResources().getKString("B1266", objectArray));
                        continue;
                    }
                    if (n == 3 || n == 4) {
                        transactionState.detachedFromConnection();
                        arrayList.add(transactionUID2);
                        objectArray = new String[]{"" + transactionUID2 + "(XID=" + transactionState.getXid() + ")", TransactionState.toString(n), this.getConnectionUID().toString()};
                        this.logger.log(8, Globals.getBrokerResources().getKString("B1266", objectArray));
                        continue;
                    }
                }
                if (n == 5 || n == 6 || n == 7) {
                    objectArray = new String[]{"" + transactionUID2, TransactionState.toString(n), this.getConnectionUID().toString()};
                    this.logger.log(8, Globals.getBrokerResources().getKString("B1266", objectArray));
                    continue;
                }
                if (DEBUG || DEBUG_TXN) {
                    this.logger.log(8, "Cleanup connection [" + (Object)((Object)this.getConnectionUID()) + "]: cleaning up transaction " + transactionUID2 + "[" + TransactionState.toString(n) + "]");
                }
                try {
                    transactionHandler.doRollback(transactionUID2, transactionState.getXid(), null, transactionState, list, null, RollbackReason.CONNECTION_CLEANUP);
                    continue;
                }
                catch (Exception exception) {
                    Object[] objectArray2 = new String[]{"" + transactionUID2 + "[" + TransactionState.toString(n) + "]", this.getConnectionUID().toString(), exception.getMessage()};
                    this.logger.logStack(16, Globals.getBrokerResources().getString("B2182", objectArray2), (Throwable)exception);
                }
            }
            for (TransactionUID transactionUID2 : arrayList) {
                transactionList.addDetachedTransactionID(transactionUID2);
            }
            arrayList.clear();
            transactionUIDArray = null;
            list.clear();
        }
    }

    public synchronized void shutdownConnection(String string) {
        if (DEBUG) {
            this.logger.log(2, "Shuting down Connection {0}", (Object)this.toString());
        }
        this.closeConnection(true, 1, string);
        this.destroyConnection(true, 1, string);
    }

    public void setConnectionUID(ConnectionUID connectionUID) {
        this.conId = connectionUID;
        if (this.coninfo != null) {
            this.coninfo.id = connectionUID.toString().getBytes();
        }
    }

    public abstract void sendControlMessage(Packet var1);

    protected abstract void checkState();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void cleanupMemory(boolean bl) {
    }

    public void flowPaused(long l) {
    }

    public void addProducer(Producer producer) {
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().addProducer();
        }
        Producer producer2 = this.producers.put(producer.getProducerUID(), producer);
        assert (producer2 == null);
    }

    public void removeProducer(ProducerUID producerUID, String string) throws BrokerException {
        Object v;
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().removeProducer();
        }
        if ((v = this.producers.remove((Object)producerUID)) == null) {
            throw new BrokerException("Requested removal of  producer " + (Object)((Object)producerUID) + " which is not associated with" + " connection " + (Object)((Object)this.getConnectionUID()));
        }
        Producer.destroyProducer(producerUID, string);
    }

    public List getSessions() {
        return new ArrayList(this.sessions.keySet());
    }

    public List getProducers() {
        return new ArrayList(this.producers.values());
    }

    public List getProducerIDs() {
        return new ArrayList(this.producers.keySet());
    }

    public int getProducerCnt() {
        return this.producers.size();
    }

    public List getConsumers() {
        ArrayList<Consumer> arrayList = new ArrayList<Consumer>();
        for (Session session : this.sessions.values()) {
            Iterator iterator = session.getConsumers();
            while (iterator.hasNext()) {
                Consumer consumer = (Consumer)iterator.next();
                arrayList.add(consumer);
            }
        }
        return arrayList;
    }

    public List getConsumersIDs() {
        ArrayList<ConsumerUID> arrayList = new ArrayList<ConsumerUID>();
        for (Session session : this.sessions.values()) {
            Iterator iterator = session.getConsumers();
            while (iterator.hasNext()) {
                Consumer consumer = (Consumer)iterator.next();
                arrayList.add(consumer.getConsumerUID());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpProducers() {
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().removeProducer(this.producers.size());
        }
        HashMap hashMap = this.producers;
        synchronized (hashMap) {
            Iterator iterator = this.producers.values().iterator();
            while (iterator.hasNext()) {
                Producer producer = (Producer)iterator.next();
                Producer.destroyProducer(producer.getProducerUID(), "cleanup of connection " + this);
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpConsumers() {
        Iterator iterator = null;
        Object object = this.sessions;
        synchronized (object) {
            iterator = new HashSet(this.sessions.keySet()).iterator();
        }
        while (iterator.hasNext()) {
            object = (SessionUID)((Object)iterator.next());
            try {
                this.closeSession((SessionUID)((Object)object));
            }
            catch (BrokerException brokerException) {}
        }
        this.sessions.clear();
        this.busySessions.clear();
    }

    public boolean hasBusySessions() {
        return this.busySessions.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(SessionUID sessionUID) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            return (Session)this.sessions.get((Object)sessionUID);
        }
    }

    public void attachTempDestination(DestinationUID destinationUID) {
        this.tmpDestinations.add(destinationUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpTempDest(boolean bl) {
        if (bl && this.getConnectionUID().getCanReconnect()) {
            return;
        }
        Set set = this.tmpDestinations;
        synchronized (set) {
            for (DestinationUID destinationUID : this.tmpDestinations) {
                this.logger.log(4, "Destroying temp destination " + destinationUID + " on connection death");
                try {
                    Destination.removeDestination(destinationUID, true, Globals.getBrokerResources().getString("B0068", (Object)this.getConnectionUID()));
                }
                catch (Exception exception) {
                    this.logger.log(8, "Error destination temp  destination " + destinationUID);
                }
            }
            this.tmpDestinations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachSession(Session session) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.put(session.getSessionUID(), session);
            this.lockToSession.put(session.getSessionUID(), session.addEventListener(this, EventType.BUSY_STATE_CHANGED, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(SessionUID sessionUID) throws BrokerException {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Session session = (Session)this.sessions.remove((Object)sessionUID);
            if (session == null) {
                throw new BrokerException("Requested removal of  session " + (Object)((Object)sessionUID) + " which is not associated with" + " connection " + (Object)((Object)this.getConnectionUID()));
            }
            if (this.lockToSession != null && session != null) {
                this.lockToSession.remove((Object)session.getSessionUID());
            }
        }
        Session.closeSession(sessionUID);
    }

    public void destroy(boolean bl, int n, String string) {
        this.destroyConnection(bl, n, string);
    }
}

