/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.SysMessageID;
import java.util.Comparator;

public class ExpirationInfo {
    static Comparator expireCompare = new ExpirationComparator();
    SysMessageID id;
    long expireTime;
    boolean expired = false;

    public String toString() {
        return "ExpirationInfo[" + this.id + "," + this.expireTime + "]";
    }

    public synchronized boolean isExpired(long l) {
        if (!this.expired) {
            this.expired = this.expireTime <= l;
        }
        return this.expired;
    }

    public synchronized boolean isExpired() {
        if (!this.expired) {
            return this.isExpired(System.currentTimeMillis());
        }
        return this.expired;
    }

    public static Comparator getComparator() {
        return expireCompare;
    }

    public ExpirationInfo(SysMessageID sysMessageID, long l) {
        this.id = sysMessageID;
        this.expireTime = l;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public SysMessageID getSysMessageID() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExpirationInfo)) {
            return false;
        }
        ExpirationInfo expirationInfo = (ExpirationInfo)object;
        assert (this.id != null && expirationInfo != null && expirationInfo.id != null);
        return this.id.equals((Object)expirationInfo.id);
    }

    static class ExpirationComparator
    implements Comparator {
        ExpirationComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof ExpirationInfo && object2 instanceof ExpirationInfo) {
                ExpirationInfo expirationInfo = (ExpirationInfo)object;
                ExpirationInfo expirationInfo2 = (ExpirationInfo)object2;
                long l = expirationInfo2.expireTime - expirationInfo.expireTime;
                if (l == 0L) {
                    SysMessageID sysMessageID = expirationInfo.id;
                    SysMessageID sysMessageID2 = expirationInfo2.id;
                    l = sysMessageID2.getTimestamp() - sysMessageID.getTimestamp();
                    if (l == 0L) {
                        l = sysMessageID2.getSequence() - sysMessageID.getSequence();
                    }
                }
                if (l < 0L) {
                    return 1;
                }
                if (l > 0L) {
                    return -1;
                }
                return 0;
            }
            assert (false);
            return object.hashCode() - object2.hashCode();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }
    }
}

