/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.XAResourceImpl;
import com.sun.messaging.jmq.util.XidImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class XAResourceMap {
    static HashMap<XidImpl, Set<XAResourceImpl>> resourceMap = new HashMap();

    public static synchronized void register(XidImpl xidImpl, XAResourceImpl xAResourceImpl, boolean bl) throws XAException {
        Set<XAResourceImpl> set = resourceMap.get(xidImpl);
        if (set == null) {
            set = new HashSet<XAResourceImpl>();
            resourceMap.put(xidImpl, set);
        } else if (!bl) {
            XAException xAException = new XAException("Trying to add a new XAResource to an existing xid without using the JOIN flag");
            xAException.errorCode = -8;
            throw xAException;
        }
        set.add(xAResourceImpl);
    }

    public static synchronized void unregister(XidImpl xidImpl) {
        resourceMap.remove(xidImpl);
    }

    public static synchronized void unregisterResource(XAResource xAResource, XidImpl xidImpl) {
        Set<XAResourceImpl> set = resourceMap.get(xidImpl);
        if (set != null) {
            set.remove(xAResource);
            if (set.size() == 0) {
                resourceMap.remove(xidImpl);
            }
        }
    }

    public static synchronized XAResourceImpl[] getXAResources(XidImpl xidImpl, boolean bl) throws XAException {
        Set<XAResourceImpl> set = resourceMap.get(xidImpl);
        if (set == null) {
            if (bl) {
                XAException xAException = new XAException("Unknown XID (was start() called?");
                throw xAException;
            }
            return new XAResourceImpl[0];
        }
        return set.toArray(new XAResourceImpl[set.size()]);
    }

    public static boolean isEmpty() {
        return resourceMap.isEmpty();
    }
}

