/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GetTransactionsHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetTransactionsHandler.getDEBUG();
    private static int LOCAL = 0;
    private static int CLUSTER = 1;
    private static int REMOTE = 2;
    private static int UNKNOWN = -1;
    TransactionList tl = null;

    public GetTransactionsHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
        this.tl = adminDataHandler.tl;
    }

    public static Hashtable getTransactionInfo(TransactionList transactionList, TransactionUID transactionUID, int n) {
        Logger logger = Globals.getLogger();
        TransactionState transactionState = transactionList.retrieveState(transactionUID);
        if (n == LOCAL) {
            transactionState = transactionList.retrieveState(transactionUID);
        } else if (n == CLUSTER) {
            transactionState = transactionList.retrieveState(transactionUID);
        } else if (n == REMOTE) {
            transactionState = transactionList.getRemoteTransactionState(transactionUID);
        }
        if (transactionState == null) {
            return null;
        }
        JMQXid jMQXid = transactionList.UIDToXid(transactionUID);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("type", new Integer(n));
        if (jMQXid != null) {
            hashtable.put("xid", jMQXid.toString());
        }
        hashtable.put("txnid", new Long(transactionUID.longValue()));
        if (transactionState.getUser() != null) {
            hashtable.put("user", transactionState.getUser());
        }
        if (transactionState.getClientID() != null) {
            hashtable.put("clientid", transactionState.getClientID());
        }
        hashtable.put("timestamp", new Long(System.currentTimeMillis() - transactionUID.age()));
        hashtable.put("connection", transactionState.getConnectionString());
        hashtable.put("nmsgs", new Integer(transactionList.retrieveNSentMessages(transactionUID)));
        hashtable.put("nacks", new Integer(transactionList.retrieveNConsumedMessages(transactionUID)));
        hashtable.put("state", new Integer(transactionState.getState()));
        ConnectionUID connectionUID = transactionState.getConnectionUID();
        if (connectionUID != null) {
            hashtable.put("connectionid", new Long(connectionUID.longValue()));
        }
        TransactionBroker transactionBroker = transactionList.getRemoteTransactionHomeBroker(transactionUID);
        String string = "";
        if (transactionBroker != null) {
            string = transactionBroker.getBrokerAddress().toString();
        }
        hashtable.put("homebroker", string);
        TransactionBroker[] transactionBrokerArray = null;
        try {
            transactionBrokerArray = transactionList.getClusterTransactionBrokers(transactionUID);
        }
        catch (BrokerException brokerException) {
            logger.log(16, "Exception caught while obtaining list of brokers in transaction", (Throwable)brokerException);
        }
        String string2 = "";
        String string3 = "";
        if (transactionBrokerArray != null) {
            for (int i = 0; i < transactionBrokerArray.length; ++i) {
                TransactionBroker transactionBroker2 = transactionBrokerArray[i];
                BrokerAddress brokerAddress = transactionBroker2.getBrokerAddress();
                if (string2.length() != 0) {
                    string2 = string2 + ", ";
                }
                string2 = string2 + brokerAddress.toString();
                if (transactionBroker2.isCompleted()) continue;
                if (string3.length() != 0) {
                    string3 = string3 + ", ";
                }
                string3 = string3 + brokerAddress.toString();
            }
        }
        hashtable.put("allbrokers", string2);
        hashtable.put("pendingbrokers", string3);
        return hashtable;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Getting transactions " + hashtable);
        }
        int n = 200;
        String string = null;
        TransactionUID transactionUID = null;
        Long l = (Long)hashtable.get("JMQTransactionID");
        if (l != null) {
            transactionUID = new TransactionUID(l);
        }
        Hashtable hashtable2 = null;
        Vector<Hashtable> vector = new Vector<Hashtable>();
        if (transactionUID != null) {
            int n2 = UNKNOWN;
            if (this.tl.isRemoteTransaction(transactionUID)) {
                n2 = REMOTE;
            } else if (this.tl.isClusterTransaction(transactionUID)) {
                n2 = CLUSTER;
            } else if (this.tl.isLocalTransaction(transactionUID)) {
                n2 = LOCAL;
            }
            hashtable2 = GetTransactionsHandler.getTransactionInfo(this.tl, transactionUID, n2);
            if (hashtable2 != null) {
                vector.add(hashtable2);
            }
        } else {
            Enumeration enumeration;
            Vector vector2 = this.tl.getTransactions(-1);
            if (vector2 != null) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    transactionUID = (TransactionUID)enumeration.nextElement();
                    hashtable2 = GetTransactionsHandler.getTransactionInfo(this.tl, transactionUID, LOCAL);
                    if (hashtable2 == null) continue;
                    vector.add(hashtable2);
                }
            }
            if ((vector2 = this.tl.getClusterTransactions(-1)) != null) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    transactionUID = (TransactionUID)enumeration.nextElement();
                    hashtable2 = GetTransactionsHandler.getTransactionInfo(this.tl, transactionUID, CLUSTER);
                    if (hashtable2 == null) continue;
                    vector.add(hashtable2);
                }
            }
            if ((vector2 = this.tl.getRemoteTransactions(-1)) != null) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    transactionUID = (TransactionUID)enumeration.nextElement();
                    hashtable2 = GetTransactionsHandler.getTransactionInfo(this.tl, transactionUID, REMOTE);
                    if (hashtable2 == null) continue;
                    vector.add(hashtable2);
                }
            }
        }
        if (transactionUID != null && vector.size() == 0) {
            n = 404;
            string = this.rb.getString("B3113", transactionUID);
        }
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(5);
        GetTransactionsHandler.setProperties(packet2, 61, n, string);
        try {
            packet2.getProperties().put("JMQQuantity", new Integer(vector.size()));
        }
        catch (IOException iOException) {
            this.logger.log(16, "B3100", (Object)"Admin: GetTransactions: Could not extract properties from pkt", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(16, "B3100", (Object)"Admin: GetTransactions: Could not extract properties from pkt", (Throwable)classNotFoundException);
        }
        this.setBodyObject(packet2, vector);
        this.parent.sendReply(iMQConnection, packet, packet2);
        return true;
    }
}

