/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.IMQBlockingQueue;
import com.sun.messaging.jmq.jmsservice.DirectBrokerConnection;
import com.sun.messaging.jmq.jmsservice.HandOffQueue;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import java.io.IOException;
import java.util.Hashtable;

public class IMQDualThreadConnection
extends IMQBasicConnection
implements DirectBrokerConnection {
    DummyQueue inputQueue = new DummyQueue();
    IMQBlockingQueue outputQueue = new IMQBlockingQueue();
    String localsvcstring = null;

    public IMQDualThreadConnection(Service service, PacketRouter packetRouter) throws IOException, BrokerException {
        super(service, packetRouter);
        this.setConnectionState(0);
    }

    public HandOffQueue getClientToBrokerQueue() {
        return this.inputQueue;
    }

    public HandOffQueue getBrokerToClientQueue() {
        return this.outputQueue;
    }

    public void checkState() {
    }

    public boolean isBlocking() {
        return true;
    }

    public void setFlowCount() {
    }

    public void haltFlow() {
    }

    public void resumeFlow(int n) {
    }

    public void cleanupControlPackets(boolean bl) {
    }

    public boolean useDirectBuffers() {
        return true;
    }

    protected void checkConnection() {
    }

    protected void flushConnection(long l) {
    }

    public void logConnectionInfo(boolean bl) {
        this.logConnectionInfo(bl, "Unknown");
    }

    public void logConnectionInfo(boolean bl, String string) {
        Object[] objectArray = new String[]{this.getRemoteConnectionString(), this.localServiceString(), Integer.toString(Globals.getConnectionManager().size()), string, "N/A", "N/A"};
        if (!bl) {
            this.logger.log(8, "B1065", objectArray);
        } else {
            this.logger.log(8, "B1066", objectArray);
        }
    }

    public void processReadPacket(Packet packet) {
        ++this.msgsIn;
        if (packet.getPacketType() < 80) {
            int n = packet.getPacketType();
            this.pktsIn[n] = this.pktsIn[n] + 1;
        }
        if (DEBUG || DUMP_PACKET || IN_DUMP_PACKET) {
            int n = DUMP_PACKET || IN_DUMP_PACKET ? 8 : 1;
            this.logger.log(n, "\n------------------------------\nReceived incoming Packet - Dumping\nConnection: " + this + "\n------------------------------" + "\n" + packet.dumpPacketString(">>>>****") + "\n------------------------------");
        }
        this.router.handleMessage(this, packet);
    }

    public boolean isDirectBuffers() {
        return false;
    }

    public void sendControlMessage(Packet packet) {
        if (packet.getPacketType() > 6) {
            packet.setIP(ipAddress);
            packet.setPort(0);
        }
        this.writePacket(packet, true);
    }

    public void writePacket(Packet packet, boolean bl) {
        int n;
        if (bl) {
            if (DEBUG || DUMP_PACKET || OUT_DUMP_PACKET) {
                n = DUMP_PACKET || OUT_DUMP_PACKET ? 8 : 1;
                this.logger.log(n, "\n------------------------------\nSending Control Packet - Dumping\n------------------------------\n" + packet.dumpPacketString("<<<<****") + "\n------------------------------");
            }
        } else if (DEBUG || DUMP_PACKET || OUT_DUMP_PACKET) {
            n = DUMP_PACKET || OUT_DUMP_PACKET ? 8 : 1;
            this.logger.log(n, "\n------------------------------\nSending JMS Message - Dumping\n------------------------------\n" + packet.dumpPacketString("<<<<****") + "\n------------------------------");
        }
        int n2 = packet.getPacketType();
        this.pktsOut[n2] = this.pktsOut[n2] + 1;
        try {
            ReadWritePacket readWritePacket = new ReadWritePacket();
            readWritePacket.fill(packet, !bl);
            this.outputQueue.add(readWritePacket);
        }
        catch (IOException iOException) {
            this.logger.log(4, "Unable to duplicate packet ", (Throwable)iOException);
        }
    }

    public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
        Session session = (Session)object;
        while (session.isBusy()) {
            Packet packet = new Packet();
            session.fillNextPacket(packet);
            this.writePacket(packet, false);
        }
    }

    public synchronized Hashtable getDebugState() {
        Hashtable hashtable = super.getDebugState();
        hashtable.put("transport", "Embedded2");
        hashtable.put("inputQueue", this.inputQueue.toString());
        hashtable.put("outputQueue", this.outputQueue.toString());
        return hashtable;
    }

    public String getRemoteConnectionString() {
        Object object;
        String string;
        boolean bl;
        block6: {
            if (this.remoteConString != null) {
                return this.remoteConString;
            }
            bl = false;
            string = "???";
            if (this.state >= 4) {
                try {
                    object = this.getAuthenticatedName();
                    if (object != null) {
                        string = object.getName();
                        bl = true;
                    }
                }
                catch (BrokerException brokerException) {
                    if (!DEBUG) break block6;
                    this.logger.log(4, "Exception getting authentication name " + (Object)((Object)this.conId), (Throwable)brokerException);
                }
            }
        }
        object = string + "@" + "Direct2" + ":" + (Object)((Object)this.getConnectionUID());
        if (bl) {
            this.remoteConString = object;
        }
        return object;
    }

    protected String localServiceString() {
        if (this.localsvcstring != null) {
            return this.localsvcstring;
        }
        this.localsvcstring = this.service.getName();
        return this.localsvcstring;
    }

    public synchronized void closeConnection(boolean bl, int n, String string) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DummyQueue<Packet>
    implements HandOffQueue<Packet> {
        DummyQueue() {
        }

        @Override
        public Packet take() throws InterruptedException {
            return null;
        }

        @Override
        public void put(Packet Packet2) throws InterruptedException {
            IMQDualThreadConnection.this.processReadPacket((Packet)Packet2);
        }

        @Override
        public void close() {
        }
    }
}

