/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.BigPacketException;
import com.sun.messaging.jmq.io.ByteBufferPool;
import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.JMQByteBufferOutputStream;
import com.sun.messaging.jmq.io.PacketFlag;
import com.sun.messaging.jmq.io.PacketPayload;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.PacketUtil;
import com.sun.messaging.jmq.io.PacketVariableHeader;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsservice.JMSPacket;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.Message;

public class Packet
implements JMSPacket {
    private static boolean DEBUG = false;
    private boolean destroyed = false;
    public static final int MAGIC = 469754818;
    public static final short VERSION1 = 103;
    public static final short VERSION2 = 200;
    public static final short VERSION3 = 301;
    public static final int HEADER_SIZE = 72;
    public static final int DEFAULT_POOL_SIZE = 0x100000;
    public static final int DEFAULT_POOL_BLOCKSIZE = 128;
    protected static int sequenceNumber = 0;
    protected static ByteBufferPool bbPool = null;
    protected static long SIZE_LOWER_BOUND = 524288L;
    protected static final long SIZE_UPPER_BOUND = Integer.MAX_VALUE;
    protected static long maxPacketSize = Integer.MAX_VALUE;
    protected boolean genTimestamp = true;
    protected boolean genSequenceNumber = true;
    protected ByteBuffer fixedBuf = null;
    protected boolean bufferDirty = false;
    protected boolean useDirect = false;
    protected ByteBuffer varBuf = null;
    protected ByteBuffer propBuf = null;
    protected ByteBuffer bodyBuf = null;
    protected ByteBuffer[] writeBufs = new ByteBuffer[4];
    protected ByteBuffer[] readBufs = new ByteBuffer[4];
    protected int[] readBufsLimits = new int[4];
    protected int nBufs = 0;
    protected ArrayList allocatedBuffers = new ArrayList(8);
    protected short version = (short)301;
    protected int magic = 469754818;
    protected short packetType = 0;
    protected int packetSize = 0;
    protected long expiration = 0L;
    protected int propertyOffset = 0;
    protected int propertySize = 0;
    protected byte encryption = 0;
    protected long transactionID = 0L;
    protected byte priority = (byte)5;
    protected int bitFlags = 0;
    protected long consumerID = 0L;
    protected SysMessageID sysMessageID = new SysMessageID();
    protected PacketVariableHeader packetVariableHeader = null;
    protected PacketPayload packetPayload = null;
    protected boolean readInProgress = false;
    protected boolean writeInProgress = false;
    protected boolean versionMismatch = false;
    protected int headerBytesRead = 0;
    protected int ropBytesRead = 0;
    protected int bytesWritten = 0;

    public static synchronized long setMaxPacketSize(long l) {
        maxPacketSize = l < SIZE_LOWER_BOUND ? SIZE_LOWER_BOUND : l;
        return maxPacketSize;
    }

    public static synchronized long getMaxPacketSize() {
        return maxPacketSize;
    }

    public static void setSizeLowerBound(long l) {
        SIZE_LOWER_BOUND = l;
    }

    public static long getSizeLowerBound() {
        return SIZE_LOWER_BOUND;
    }

    public static synchronized ByteBufferPool getBufferPool() {
        return bbPool;
    }

    public Packet() {
        this(false);
    }

    public Packet(boolean bl) {
        this.useDirect = bl;
        this.reset();
    }

    public synchronized void fill(Packet packet) throws IOException {
        this.fill(packet, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fill(Packet packet, boolean bl) throws IOException {
        this.reset();
        Packet packet2 = packet;
        synchronized (packet2) {
            Object object;
            packet.updateBuffers();
            ByteBuffer byteBuffer = null;
            byteBuffer = packet.getHeaderBytes();
            byteBuffer.rewind();
            this.fixedBuf.rewind();
            this.fixedBuf.put(byteBuffer);
            byteBuffer.rewind();
            this.fixedBuf.rewind();
            try {
                byteBuffer = packet.getPacketVariableHeader().getBytes();
            }
            catch (IOException iOException) {
                System.out.println("Could not get variable header" + iOException);
                return;
            }
            if (byteBuffer != null) {
                object = this.packetVariableHeader.getBytes();
                if (object == null || ((Buffer)object).capacity() < byteBuffer.limit()) {
                    object = this.allocateBuffer(byteBuffer.limit());
                } else {
                    ((ByteBuffer)object).limit(byteBuffer.limit());
                    ((ByteBuffer)object).rewind();
                }
                ((ByteBuffer)object).put(byteBuffer);
                ((ByteBuffer)object).rewind();
                byteBuffer.rewind();
                this.packetVariableHeader.setBytes((ByteBuffer)object);
            }
            if ((object = packet.getPacketPayload()) != null) {
                ByteBuffer byteBuffer2;
                ByteBuffer byteBuffer3 = ((PacketPayload)object).getPropertiesBytes(this.version);
                if (byteBuffer3 != null) {
                    if (bl) {
                        byteBuffer2 = this.allocateBuffer(byteBuffer3.limit());
                        byteBuffer2.put(byteBuffer3);
                        byteBuffer2.rewind();
                        this.packetPayload.setPropertiesBytes(byteBuffer2, this.version);
                    } else {
                        this.packetPayload.setPropertiesBytes((ByteBuffer)byteBuffer3.duplicate().rewind(), this.version);
                    }
                }
                if ((byteBuffer3 = ((PacketPayload)object).getBodyBytes()) != null) {
                    if (bl) {
                        byteBuffer2 = this.allocateBuffer(byteBuffer3.limit());
                        byteBuffer2.put(byteBuffer3);
                        byteBuffer2.rewind();
                        this.packetPayload.setBody(byteBuffer2);
                    } else {
                        this.packetPayload.setBody((ByteBuffer)byteBuffer3.duplicate().rewind());
                    }
                    byteBuffer3.rewind();
                }
            }
        }
        this.parseFixedBuffer(this.fixedBuf);
        this.getTransactionID();
        this.generateSequenceNumber(false);
        this.generateTimestamp(false);
    }

    private void parseFixedBuffer(ByteBuffer byteBuffer) throws StreamCorruptedException, IOException {
        byteBuffer.rewind();
        this.magic = byteBuffer.getInt();
        if (this.magic != 469754818) {
            throw new StreamCorruptedException("Bad packet magic number: " + this.magic + ". Expecting: " + 469754818);
        }
        this.version = byteBuffer.getShort();
        this.packetType = byteBuffer.getShort();
        this.packetSize = byteBuffer.getInt();
        if (this.version == 103) {
            this.transactionID = byteBuffer.getInt();
        }
        this.expiration = byteBuffer.getLong();
        JMQByteBufferInputStream jMQByteBufferInputStream = new JMQByteBufferInputStream(byteBuffer);
        DataInputStream dataInputStream = new DataInputStream(jMQByteBufferInputStream);
        this.sysMessageID.readID(dataInputStream);
        dataInputStream.close();
        ((InputStream)jMQByteBufferInputStream).close();
        this.propertyOffset = byteBuffer.getInt();
        this.propertySize = byteBuffer.getInt();
        this.priority = byteBuffer.get();
        this.encryption = byteBuffer.get();
        this.bitFlags = byteBuffer.getShort();
        if (this.version == 103) {
            this.consumerID = byteBuffer.getInt();
            this.bitFlags &= 0xFF;
        } else {
            this.consumerID = byteBuffer.getLong();
        }
        byteBuffer.rewind();
    }

    public boolean getFlag(int n) {
        return (this.bitFlags & n) == n;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getPacketType() {
        return this.packetType;
    }

    public synchronized int getPacketSize() {
        try {
            this.updateBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.packetSize;
    }

    public synchronized long getTransactionID() {
        if (this.version >= 200) {
            this.transactionID = this.packetVariableHeader.getLongField(8);
        }
        return this.transactionID;
    }

    public synchronized long getProducerID() {
        return this.packetVariableHeader.getLongField(9);
    }

    public synchronized long getTimestamp() {
        return this.sysMessageID.timestamp;
    }

    public synchronized long getExpiration() {
        return this.expiration;
    }

    public int getPort() {
        return this.sysMessageID.port;
    }

    public synchronized String getIPString() {
        return this.sysMessageID.toString();
    }

    public synchronized byte[] getIP() {
        return this.sysMessageID.getIPAddress();
    }

    public int getSequence() {
        return this.sysMessageID.sequence;
    }

    public synchronized int getPropertyOffset() {
        try {
            this.updateBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.propertyOffset;
    }

    public synchronized int getPropertySize() {
        try {
            this.updateBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.propertySize;
    }

    public int getEncryption() {
        return this.encryption;
    }

    public int getPriority() {
        return this.priority;
    }

    public synchronized long getConsumerID() {
        return this.consumerID;
    }

    public boolean getPersistent() {
        return this.getFlag(4);
    }

    public boolean getRedelivered() {
        return this.getFlag(2);
    }

    public boolean getIsQueue() {
        return this.getFlag(1);
    }

    public boolean getSelectorsProcessed() {
        return this.getFlag(8);
    }

    public boolean getSendAcknowledge() {
        return this.getFlag(16);
    }

    public boolean getIsLast() {
        return this.getFlag(32);
    }

    public boolean getFlowPaused() {
        return this.getFlag(64);
    }

    public boolean getIsTransacted() {
        return this.getFlag(128);
    }

    public boolean getConsumerFlow() {
        return this.getFlag(256);
    }

    public boolean getIndempotent() {
        return this.getFlag(2048);
    }

    public boolean getWildcard() {
        return this.getFlag(4096);
    }

    public synchronized String getMessageID() {
        String string = this.packetVariableHeader.getStringField(2);
        if (string == null) {
            return this.sysMessageID.toString();
        }
        return string;
    }

    public synchronized void setMessageID(String string) {
        this.packetVariableHeader.setStringField(2, string);
    }

    public synchronized SysMessageID getSysMessageID() {
        return this.sysMessageID;
    }

    public synchronized String getDestination() {
        return this.packetVariableHeader.getStringField(1);
    }

    public synchronized String getDestinationClass() {
        return this.packetVariableHeader.getStringField(6);
    }

    public synchronized String getCorrelationID() {
        return this.packetVariableHeader.getStringField(3);
    }

    public synchronized String getReplyTo() {
        return this.packetVariableHeader.getStringField(4);
    }

    public synchronized String getReplyToClass() {
        return this.packetVariableHeader.getStringField(7);
    }

    public synchronized String getMessageType() {
        return this.packetVariableHeader.getStringField(5);
    }

    public synchronized Hashtable getProperties() throws IOException, ClassNotFoundException {
        return this.packetPayload.getProperties();
    }

    public synchronized int getMessageBodySize() {
        return this.packetPayload.getBodySize();
    }

    public synchronized ByteBuffer getMessageBodyByteBuffer() {
        return this.packetPayload.getBodyBytes();
    }

    public synchronized byte[] getMessageBodyByteArray() {
        ByteBuffer byteBuffer = this.packetPayload.getBodyBytes();
        if (byteBuffer != null && byteBuffer.hasArray()) {
            return byteBuffer.array();
        }
        return null;
    }

    public synchronized void clearMessageBody() {
        if (this.packetPayload != null) {
            this.packetPayload.setBody(null);
        }
    }

    public synchronized InputStream getMessageBodyStream() {
        return this.packetPayload.getBodyStream();
    }

    public synchronized void reset() {
        this.version = (short)301;
        this.magic = 469754818;
        this.packetType = 0;
        this.packetSize = 0;
        this.expiration = 0L;
        this.propertyOffset = 0;
        this.propertySize = 0;
        this.encryption = 0;
        this.priority = (byte)5;
        this.bitFlags = 0;
        this.consumerID = 0L;
        this.transactionID = 0L;
        this.readInProgress = false;
        this.headerBytesRead = 0;
        this.ropBytesRead = 0;
        this.bufferDirty = false;
        this.sysMessageID.clear();
        if (this.fixedBuf != null) {
            this.fixedBuf.clear();
        } else {
            this.fixedBuf = this.allocateBuffer(72);
        }
        if (this.varBuf != null) {
            this.varBuf.clear();
        }
        if (this.propBuf != null) {
            this.propBuf.clear();
        }
        if (this.bodyBuf != null) {
            this.bodyBuf.clear();
        }
        if (this.packetVariableHeader != null) {
            this.packetVariableHeader.reset();
        } else {
            this.packetVariableHeader = new PacketVariableHeader();
        }
        if (this.packetPayload != null) {
            this.packetPayload.reset();
        } else {
            this.packetPayload = new PacketPayload();
        }
    }

    public void updateBuffers() throws IOException {
        if (!this.bufferDirty) {
            return;
        }
        ByteBuffer byteBuffer = this.version == 103 ? this.packetVariableHeader.getBytes2() : this.packetVariableHeader.getBytes();
        ByteBuffer byteBuffer2 = this.packetPayload.getPropertiesBytes(this.version);
        ByteBuffer byteBuffer3 = this.packetPayload.getBodyBytes();
        this.propertySize = byteBuffer2 == null ? 0 : byteBuffer2.limit();
        int n = byteBuffer == null ? 0 : byteBuffer.limit();
        int n2 = byteBuffer3 == null ? 0 : byteBuffer3.limit();
        this.propertyOffset = 72 + n;
        this.packetSize = this.propertyOffset + this.propertySize + n2;
        this.fixedBuf.rewind();
        this.fixedBuf.putInt(469754818);
        this.fixedBuf.putShort(this.version);
        this.fixedBuf.putShort(this.packetType);
        this.fixedBuf.putInt(this.packetSize);
        if (this.version == 103) {
            this.fixedBuf.putInt((int)this.transactionID);
        }
        this.fixedBuf.putLong(this.expiration);
        JMQByteBufferOutputStream jMQByteBufferOutputStream = new JMQByteBufferOutputStream(this.fixedBuf);
        DataOutputStream dataOutputStream = new DataOutputStream(jMQByteBufferOutputStream);
        this.sysMessageID.writeID(dataOutputStream);
        try {
            dataOutputStream.close();
            ((OutputStream)jMQByteBufferOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fixedBuf.putInt(this.propertyOffset);
        this.fixedBuf.putInt(this.propertySize);
        this.fixedBuf.put(this.priority);
        this.fixedBuf.put(this.encryption);
        this.fixedBuf.putShort((short)this.bitFlags);
        if (this.version == 103) {
            this.fixedBuf.putInt((int)this.consumerID);
        } else {
            this.fixedBuf.putLong(this.consumerID);
        }
        this.bufferDirty = false;
        this.fixedBuf.rewind();
    }

    public synchronized void setPacketType(int n) {
        this.packetType = (short)n;
        this.bufferDirty = true;
    }

    public synchronized void setTimestamp(long l) {
        this.sysMessageID.setTimestamp(l);
        this.bufferDirty = true;
    }

    public synchronized void setExpiration(long l) {
        this.expiration = l;
        this.bufferDirty = true;
    }

    public synchronized void setPort(int n) {
        this.sysMessageID.port = n;
        this.bufferDirty = true;
    }

    public synchronized void setIP(byte[] byArray) {
        this.sysMessageID.setIPAddress(byArray);
        this.bufferDirty = true;
    }

    public synchronized void setIP(byte[] byArray, byte[] byArray2) {
        this.sysMessageID.setIPAddress(byArray, byArray2);
        this.bufferDirty = true;
    }

    public synchronized void setSequence(int n) {
        this.sysMessageID.setSequence(n);
        this.bufferDirty = true;
    }

    public synchronized void setVersion(int n) {
        if (this.version != (short)n) {
            this.version = (short)n;
            if (this.version >= 200) {
                this.setTransactionID(this.transactionID);
            }
            this.bufferDirty = true;
        }
    }

    public synchronized void setTransactionID(long l) {
        this.transactionID = l;
        this.bufferDirty = true;
        if (this.version >= 200) {
            this.packetVariableHeader.setLongField(8, l);
        }
    }

    public synchronized void setProducerID(long l) {
        this.packetVariableHeader.setLongField(9, l);
        this.bufferDirty = true;
    }

    public synchronized void setEncryption(int n) {
        this.encryption = (byte)n;
        this.bufferDirty = true;
    }

    public synchronized void setPriority(int n) {
        this.priority = (byte)n;
        this.bufferDirty = true;
    }

    public synchronized void setConsumerID(long l) {
        this.consumerID = l;
        this.bufferDirty = true;
    }

    public void setPersistent(boolean bl) {
        this.setFlag(4, bl);
    }

    public void setRedelivered(boolean bl) {
        this.setFlag(2, bl);
    }

    public void setIsQueue(boolean bl) {
        this.setFlag(1, bl);
    }

    public void setSelectorsProcessed(boolean bl) {
        this.setFlag(8, bl);
    }

    public void setSendAcknowledge(boolean bl) {
        this.setFlag(16, bl);
    }

    public void setIsLast(boolean bl) {
        this.setFlag(32, bl);
    }

    public void setFlowPaused(boolean bl) {
        this.setFlag(64, bl);
    }

    public void setIsTransacted(boolean bl) {
        this.setFlag(128, bl);
    }

    public void setConsumerFlow(boolean bl) {
        this.setFlag(256, bl);
    }

    public void setIndempotent(boolean bl) {
        this.setFlag(2048, bl);
    }

    public void setWildcard(boolean bl) {
        this.setFlag(4096, bl);
    }

    public synchronized void setFlag(int n, boolean bl) {
        this.bitFlags = bl ? (this.bitFlags |= n) : (this.bitFlags &= ~n);
        this.bufferDirty = true;
    }

    public synchronized void setDestination(String string) {
        this.packetVariableHeader.setStringField(1, string);
        this.bufferDirty = true;
    }

    public synchronized void setDestinationClass(String string) {
        this.packetVariableHeader.setStringField(6, string);
        this.bufferDirty = true;
    }

    public synchronized void setCorrelationID(String string) {
        this.packetVariableHeader.setStringField(3, string);
        this.bufferDirty = true;
    }

    public synchronized void setReplyTo(String string) {
        this.packetVariableHeader.setStringField(4, string);
        this.bufferDirty = true;
    }

    public synchronized void setReplyToClass(String string) {
        this.packetVariableHeader.setStringField(7, string);
        this.bufferDirty = true;
    }

    public synchronized void setMessageType(String string) {
        this.packetVariableHeader.setStringField(5, string);
        this.bufferDirty = true;
    }

    public synchronized void setProperties(Hashtable hashtable) {
        this.packetPayload.setProperties(hashtable);
        this.bufferDirty = true;
    }

    public synchronized void setMessageBody(ByteBuffer byteBuffer) {
        this.packetPayload.setBody(byteBuffer.slice());
        this.bufferDirty = true;
    }

    public synchronized void setMessageBody(byte[] byArray) {
        ByteBuffer byteBuffer = null;
        if (byArray != null) {
            byteBuffer = ByteBuffer.wrap(byArray);
        }
        this.packetPayload.setBody(byteBuffer);
        this.bufferDirty = true;
    }

    public synchronized void setMessageBody(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        this.packetPayload.setBody(byteBuffer);
        this.bufferDirty = true;
    }

    protected ByteBuffer getHeaderBytes() {
        return this.fixedBuf;
    }

    protected PacketPayload getPacketPayload() {
        return this.packetPayload;
    }

    protected PacketVariableHeader getPacketVariableHeader() {
        return this.packetVariableHeader;
    }

    public void generateSequenceNumber(boolean bl) {
        this.genSequenceNumber = bl;
    }

    public void generateTimestamp(boolean bl) {
        this.genTimestamp = bl;
    }

    public synchronized void updateTimestamp() {
        this.setTimestamp(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateSequenceNumber() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.setSequence(++sequenceNumber);
        }
    }

    public synchronized boolean readPacket(ScatteringByteChannel scatteringByteChannel, boolean bl) throws IOException {
        if (this.writeInProgress) {
            throw new IOException("Can't read packet. Write in progress.");
        }
        if (this.destroyed) {
            throw new IOException("Packet has been destroyed");
        }
        if (!this.readInProgress) {
            this.reset();
            this.headerBytesRead = 0;
            this.ropBytesRead = 0;
            this.readInProgress = true;
            this.versionMismatch = false;
        }
        if (this.headerBytesRead < 72 && !this.readFixedHeader(scatteringByteChannel, bl)) {
            return false;
        }
        this.fixedBuf.rewind();
        this.parseFixedBuffer(this.fixedBuf);
        if ((long)this.packetSize > maxPacketSize) {
            this.skipBytes(scatteringByteChannel, (long)(this.packetSize - 72));
            throw new BigPacketException("Packet size (" + this.packetSize + ") is greater than the maximum allowed packet size (" + maxPacketSize + "). Disgarding packet.");
        }
        if (this.ropBytesRead == 0) {
            this.initializeReadBufs();
        }
        if (!this.readRestOfPacket(scatteringByteChannel, bl)) {
            return false;
        }
        this.packetVariableHeader.setBytes(this.varBuf);
        this.packetPayload.setPropertiesBytes(this.propBuf, this.version);
        this.packetPayload.setBody(this.bodyBuf);
        this.readInProgress = false;
        if (this.versionMismatch) {
            throw new IllegalArgumentException("Bad packet version number: " + this.version + ". Expecting: " + 103 + " or " + 200 + " or " + 301);
        }
        return true;
    }

    private long skipBytes(InputStream inputStream, long l) throws IOException {
        long l2 = 0L;
        int n = 0;
        long l3 = 0L;
        do {
            if (n > 1000) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n = 0;
            }
            if ((l3 = inputStream.skip(l - l2)) < 0L) {
                throw new EOFException();
            }
            if (l3 != 0L) continue;
            ++n;
        } while ((l2 += l3) < l);
        return l2;
    }

    private long skipBytes(ReadableByteChannel readableByteChannel, long l) throws IOException {
        int n = 1024;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        SelectableChannel selectableChannel = null;
        Selector selector = null;
        if (readableByteChannel instanceof SelectableChannel) {
            selectableChannel = (SelectableChannel)((Object)readableByteChannel);
        }
        if (selectableChannel != null && !selectableChannel.isBlocking()) {
            selector = Selector.open();
            selectableChannel.register(selector, 1);
        }
        long l2 = 0L;
        int n2 = 0;
        long l3 = 0L;
        do {
            if (n2 > 1000) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n2 = 0;
            }
            byteBuffer.rewind();
            l3 = readableByteChannel.read(byteBuffer);
            if (l3 < 0L) {
                throw new EOFException();
            }
            if (l3 == 0L) {
                ++n2;
                if (selector == null) continue;
                selector.select(1000L);
                continue;
            }
            l2 += l3;
        } while (l2 < l);
        return l2;
    }

    private boolean readFixedHeader(ScatteringByteChannel scatteringByteChannel, boolean bl) throws IOException {
        int n = 0;
        do {
            if ((n = scatteringByteChannel.read(this.fixedBuf)) < 0) {
                throw new EOFException();
            }
            this.headerBytesRead += n;
        } while ((n > 0 || bl) && this.headerBytesRead < 72);
        return this.headerBytesRead >= 72;
    }

    private void initializeReadBufs() {
        if (this.version != 103 && this.version != 200 && this.version != 301) {
            this.propertyOffset = 72;
            this.propertySize = 0;
            this.versionMismatch = true;
        }
        int n = 0;
        this.nBufs = 0;
        n = this.propertyOffset - 72;
        if (n != 0) {
            if (this.varBuf == null || this.varBuf.capacity() < n) {
                this.varBuf = this.allocateBuffer(n);
            } else {
                this.varBuf.clear();
                this.varBuf.limit(n);
            }
            this.readBufs[this.nBufs++] = this.varBuf;
        }
        if ((n = this.propertySize) > 0) {
            if (this.propBuf == null || this.propBuf.capacity() < n) {
                this.propBuf = this.allocateBuffer(n);
            } else {
                this.propBuf.clear();
                this.propBuf.limit(n);
            }
            this.readBufs[this.nBufs++] = this.propBuf;
        }
        if ((n = this.packetSize - this.propertyOffset - this.propertySize) > 0) {
            if (this.bodyBuf == null || this.bodyBuf.capacity() < n) {
                this.bodyBuf = this.allocateBuffer(n);
            } else {
                this.bodyBuf.clear();
                this.bodyBuf.limit(n);
            }
            this.readBufs[this.nBufs++] = this.bodyBuf;
        }
        for (int i = 0; i < this.readBufs.length; ++i) {
            if (this.readBufs[i] == null) continue;
            this.readBufsLimits[i] = this.readBufs[i].limit();
        }
    }

    private boolean readRestOfPacket(ScatteringByteChannel scatteringByteChannel, boolean bl) throws IOException {
        long l = 0L;
        do {
            if ((l = Packet.myChannelRead(scatteringByteChannel, this.readBufs, 0, this.nBufs)) < 0L) {
                throw new EOFException();
            }
            this.ropBytesRead = (int)((long)this.ropBytesRead + l);
            for (int i = 0; i < this.readBufs.length; ++i) {
                if (this.readBufs[i] == null || this.readBufs[i].limit() == this.readBufsLimits[i]) continue;
                this.readBufs[i].limit(this.readBufsLimits[i]);
            }
        } while ((l > 0L || bl) && this.ropBytesRead + this.headerBytesRead < this.packetSize);
        return this.headerBytesRead + this.ropBytesRead == this.packetSize;
    }

    private int initializeWriteBufs() throws IOException {
        this.nBufs = 0;
        this.fixedBuf.rewind();
        this.writeBufs[this.nBufs] = this.fixedBuf;
        ++this.nBufs;
        this.writeBufs[this.nBufs] = this.version == 103 ? this.packetVariableHeader.getBytes2() : this.packetVariableHeader.getBytes();
        if (this.writeBufs[this.nBufs] != null) {
            ++this.nBufs;
        }
        this.writeBufs[this.nBufs] = this.packetPayload.getPropertiesBytes(this.version);
        if (this.writeBufs[this.nBufs] != null) {
            ++this.nBufs;
        }
        this.writeBufs[this.nBufs] = this.packetPayload.getBodyBytes();
        if (this.writeBufs[this.nBufs] != null) {
            ++this.nBufs;
        }
        return this.nBufs;
    }

    public synchronized boolean writePacket(GatheringByteChannel gatheringByteChannel, boolean bl) throws IOException {
        if (this.readInProgress) {
            throw new IOException("Can't write packet. Read in progress.");
        }
        if (!this.writeInProgress) {
            if (this.genSequenceNumber) {
                this.updateSequenceNumber();
            }
            if (this.genTimestamp) {
                this.updateTimestamp();
            }
            this.updateBuffers();
            this.initializeWriteBufs();
            this.writeInProgress = true;
            this.bytesWritten = 0;
        }
        long l = 0L;
        do {
            l = Packet.myChannelWrite(gatheringByteChannel, this.writeBufs, 0, this.nBufs);
            this.bytesWritten = (int)((long)this.bytesWritten + l);
        } while ((l > 0L || bl) && this.bytesWritten < this.packetSize);
        if (this.bytesWritten != this.packetSize) {
            return false;
        }
        this.writeInProgress = false;
        return true;
    }

    public synchronized String toString() {
        return PacketType.getString(this.packetType) + ":" + this.sysMessageID.toString();
    }

    public synchronized String dumpPacketString(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.dump(new PrintStream(byteArrayOutputStream), string);
        return byteArrayOutputStream.toString();
    }

    public String dumpPacketString() {
        return this.dumpPacketString(null);
    }

    public void dump(PrintStream printStream) {
        this.dump(printStream, null);
    }

    public synchronized String headerToString() {
        return "  Magic/Version: " + this.magic + "/" + this.version + "\tSize: " + this.packetSize + "\t Type: " + PacketType.getString(this.packetType) + "\n" + "     Expiration: " + this.expiration + (this.version == 103 ? "   TransactionID: " + this.transactionID : "\t\t") + "       Timestamp: " + this.sysMessageID.timestamp + "\n" + "      Source IP: " + this.sysMessageID.ip.toString() + "  Port: " + this.sysMessageID.port + "\tSequence: " + this.sysMessageID.sequence + "\n" + "Property Offset: " + this.propertyOffset + "\t\t\tProperty Size: " + this.propertySize + "\n" + "     Encryption: " + this.encryption + "\tPriority: " + this.priority + "\n" + "          Flags: " + PacketFlag.getString(this.bitFlags) + "\t\t\t   consumerID: " + this.consumerID;
    }

    public synchronized void dump(PrintStream printStream, String string) {
        if (string == null) {
            string = "********";
        }
        try {
            this.updateBuffers();
        }
        catch (Exception exception) {
            printStream.println("Warning!: Could not update buffers: " + exception);
        }
        printStream.println(string + " Packet: " + this.toString() + "\n" + this.headerToString());
        if (this.version >= 200) {
            printStream.println("   TransactionID: " + this.getTransactionID());
        }
        if (this.getProducerID() != 0L) {
            printStream.println("      ProducerID: " + this.getProducerID());
        }
        if (this.getDestination() != null) {
            printStream.println("     Destination: " + this.getDestination());
        }
        if (this.getDestinationClass() != null) {
            printStream.println("DestinationClass: " + this.getDestinationClass());
        }
        if (this.getMessageID() != null) {
            printStream.println("       MessageID: " + this.getMessageID());
        }
        if (this.getCorrelationID() != null) {
            printStream.println("   CorrelationID: " + this.getCorrelationID());
        }
        if (this.getReplyTo() != null) {
            printStream.println("         ReplyTo: " + this.getReplyTo());
        }
        if (this.getReplyToClass() != null) {
            printStream.println("    ReplyToClass: " + this.getReplyToClass());
        }
        if (this.getMessageType() != null) {
            printStream.println("     MessageType: " + this.getMessageType());
        }
        printStream.flush();
        Hashtable hashtable = null;
        try {
            hashtable = this.getProperties();
        }
        catch (Exception exception) {
            printStream.println("Exception getting properties: " + exception.getMessage());
        }
        if (hashtable == null) {
            printStream.println("      Properties: null");
        } else {
            printStream.println("      Properties: " + hashtable);
        }
        PacketUtil.dumpBody(printStream, this.packetType, this.getMessageBodyStream(), this.getMessageBodySize(), hashtable);
        printStream.println("Internal Buffers (useDirect=" + this.useDirect + "):");
        printStream.println("Fixed Header Buffer:" + this.fixedBuf.toString());
    }

    public synchronized void readPacket(InputStream inputStream) throws IOException, EOFException, StreamCorruptedException, IllegalArgumentException {
        if (this.writeInProgress) {
            throw new IOException("Can't read packet. Write in progress.");
        }
        this.reset();
        this.readFully(inputStream, this.fixedBuf, true);
        this.fixedBuf.rewind();
        this.parseFixedBuffer(this.fixedBuf);
        if ((long)this.packetSize > maxPacketSize) {
            this.skipBytes(inputStream, (long)(this.packetSize - 72));
            throw new BigPacketException("Packet size (" + this.packetSize + ") is greater than the maximum allowed packet size (" + maxPacketSize + "). Disgarding packet.");
        }
        this.initializeReadBufs();
        for (int i = 0; i < this.nBufs; ++i) {
            this.readFully(inputStream, this.readBufs[i], true);
        }
        this.packetVariableHeader.setBytes(this.varBuf);
        this.packetPayload.setPropertiesBytes(this.propBuf, this.version);
        this.packetPayload.setBody(this.bodyBuf);
        if (this.versionMismatch) {
            throw new IllegalArgumentException("Bad packet version number: " + this.version + ". Expecting: " + 103 + " or " + 200 + " or " + 301);
        }
    }

    private void readFully(InputStream inputStream, ByteBuffer byteBuffer, boolean bl) throws IOException, EOFException, InterruptedIOException {
        byte[] byArray = null;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        if (!byteBuffer.hasArray()) {
            bl2 = true;
        }
        if (!bl2) {
            try {
                byArray = byteBuffer.array();
                n = byteBuffer.arrayOffset() + byteBuffer.position();
                n2 = byteBuffer.remaining();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                bl2 = true;
            }
        }
        if (bl2) {
            byArray = new byte[byteBuffer.remaining()];
            bl2 = true;
            n = 0;
            n2 = byArray.length;
        }
        this.readFully(inputStream, byArray, n, n2, true);
        byteBuffer.rewind();
        if (bl2) {
            byteBuffer.put(byArray);
        }
    }

    private void readFully(InputStream inputStream, byte[] byArray, int n, int n2, boolean bl) throws IOException, EOFException, InterruptedIOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = 0;
            try {
                n3 = inputStream.read(byArray, n + i, n2 - i);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!bl && i == 0 && n3 == 0 && interruptedIOException.bytesTransferred == 0) {
                    throw new InterruptedIOException("no data available");
                }
                n3 = interruptedIOException.bytesTransferred;
                Thread.yield();
            }
            if (n3 >= 0) continue;
            throw new EOFException("Trying to read " + (n2 - i) + " bytes. Already read " + i + " bytes.");
        }
    }

    public synchronized void writePacket(OutputStream outputStream) throws IOException {
        if (this.genSequenceNumber) {
            this.updateSequenceNumber();
        }
        if (this.genTimestamp) {
            this.updateTimestamp();
        }
        this.updateBuffers();
        this.initializeWriteBufs();
        byte[] byArray = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < this.nBufs; ++i) {
            if (this.writeBufs[i].isDirect()) {
                bl = true;
            }
            if (!bl) {
                try {
                    byArray = this.writeBufs[i].array();
                    n = this.writeBufs[i].arrayOffset();
                    n2 = this.writeBufs[i].remaining();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    bl = true;
                }
            }
            if (bl) {
                byArray = new byte[this.writeBufs[i].remaining()];
                this.writeBufs[i].get(byArray);
                n = 0;
                n2 = byArray.length;
            }
            outputStream.write(byArray, n, n2);
        }
        outputStream.flush();
    }

    public synchronized byte[] getBytes() throws IOException {
        if (this.genSequenceNumber) {
            this.updateSequenceNumber();
        }
        if (this.genTimestamp) {
            this.updateTimestamp();
        }
        this.updateBuffers();
        this.initializeWriteBufs();
        byte[] byArray = new byte[this.packetSize];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nBufs; ++i) {
            n2 = this.writeBufs[i].remaining();
            this.writeBufs[i].get(byArray, n, n2);
            n += n2;
        }
        return byArray;
    }

    public synchronized void prepareToSend() {
        this.updateSequenceNumber();
        this.updateTimestamp();
        if (this.packetVariableHeader.getStringField(2) != null) {
            this.packetVariableHeader.setStringField(2, null);
        }
    }

    private ByteBuffer allocateBuffer(int n) {
        ByteBuffer byteBuffer = null;
        if (this.useDirect) {
            byteBuffer = bbPool == null ? ByteBuffer.allocateDirect(n) : bbPool.get(n);
            this.allocatedBuffers.add(byteBuffer);
        } else {
            byteBuffer = ByteBuffer.allocate(n);
        }
        return byteBuffer;
    }

    public synchronized void destroy() {
        int n;
        this.destroyed = true;
        ByteBuffer byteBuffer = null;
        this.reset();
        Iterator iterator = this.allocatedBuffers.iterator();
        while (iterator.hasNext()) {
            byteBuffer = (ByteBuffer)iterator.next();
            if (byteBuffer.isDirect() && bbPool != null) {
                bbPool.put(byteBuffer);
            }
            iterator.remove();
        }
        for (n = 0; n < this.writeBufs.length; ++n) {
            this.writeBufs[n] = null;
        }
        for (n = 0; n < this.readBufs.length; ++n) {
            this.readBufs[n] = null;
        }
        this.varBuf = null;
        this.propBuf = null;
        this.bodyBuf = null;
        this.fixedBuf = null;
        this.packetVariableHeader = null;
        this.packetPayload = null;
    }

    public static void dumpBufs(ByteBuffer[] byteBufferArray) {
        for (int i = 0; i < byteBufferArray.length; ++i) {
            System.out.println("bufs[" + i + "]=" + byteBufferArray[i]);
        }
    }

    public static long myChannelWrite(GatheringByteChannel gatheringByteChannel, ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            int n6 = byteBufferArray[n5].remaining();
            if (n6 != 0) {
                n4 = gatheringByteChannel.write(byteBufferArray[n5]);
                if (n4 < 0) {
                    return n4;
                }
                if (n4 == 0) {
                    return n3;
                }
                n3 += n4;
                if (n4 != n6) continue;
                ++n5;
                continue;
            }
            ++n5;
        }
        return n3;
    }

    public static long myChannelRead(ScatteringByteChannel scatteringByteChannel, ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            int n6 = byteBufferArray[n5].remaining();
            if (n6 != 0) {
                n4 = scatteringByteChannel.read(byteBufferArray[n5]);
                if (n4 < 0) {
                    return n4;
                }
                if (n4 == 0) {
                    return n3;
                }
                n3 += n4;
                if (n4 != n6) continue;
                ++n5;
                continue;
            }
            ++n5;
        }
        return n3;
    }

    public Message getMessage() {
        return null;
    }

    public Packet getPacket() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<Packet> clazz = Packet.class;
        synchronized (Packet.class) {
            if (bbPool == null) {
                bbPool = new ByteBufferPool(0x100000, true);
                bbPool.setBlockSize(72);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

