/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.runtime.impl;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.runtime.impl.DirectBrokerInstance;
import com.sun.messaging.jmq.jmsservice.BrokerEventListener;
import com.sun.messaging.jmq.jmsservice.DirectBrokerConnection;
import com.sun.messaging.jmq.jmsservice.JMSBroker;
import com.sun.messaging.jmq.jmsservice.JMSDirectBroker;
import java.util.Properties;
import javax.jms.JMSException;

public class BrokerInstanceImpl
implements DirectBrokerInstance {
    private static final String BROKER_PROCESS = "com.sun.messaging.jmq.jmsserver.BrokerProcess";
    private static final String DIRECT_BROKER_PROCESS2 = "com.sun.messaging.jmq.jmsserver.DualThreadDBP";
    private static final String DIRECT_BROKER_PROCESS = "com.sun.messaging.jmq.jmsserver.DirectBrokerProcess";
    private BrokerEventListener evlistener = null;
    private Properties props = null;
    private JMSBroker bkr = null;
    private boolean running = false;
    private boolean isShutdown = false;
    private static boolean isDirect = true;
    public static volatile boolean isTwoThread = true;

    protected BrokerInstanceImpl() {
        ConnectionImpl.getConnectionLogger().info("new broker instance constructed ...");
    }

    public static BrokerInstanceImpl getInstance() {
        return MyInstance.self;
    }

    public BrokerEventListener getBrokerEventListener() {
        return this.evlistener;
    }

    public Properties getProperties() {
        return this.props;
    }

    public synchronized void init(Properties properties, BrokerEventListener brokerEventListener) {
        this.props = properties;
        this.evlistener = brokerEventListener;
        if (this.running) {
            throw new IllegalStateException("Cannot initialize while broker is in running state.");
        }
        try {
            this.getBroker();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Properties parseArgs(String[] stringArray) throws IllegalArgumentException {
        this.getBroker();
        return this.bkr.parseArgs(stringArray);
    }

    public void shutdown() {
        this.bkr.stop(true);
        this.isShutdown = true;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        try {
            ConnectionImpl.getConnectionLogger().info("Client runtime Starting embedd broker, direct mode enabled=" + isDirect);
            this.bkr.start(true, this.props, this.evlistener, false);
            this.running = true;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.bkr.stop(false);
        this.running = false;
    }

    public synchronized boolean isBrokerRunning() {
        return this.running;
    }

    public boolean isDirectMode() {
        return isDirect;
    }

    public DirectBrokerConnection createDirectConnection() throws JMSException {
        DirectBrokerConnection directBrokerConnection = null;
        if (isDirect) {
            directBrokerConnection = ((JMSDirectBroker)this.bkr).getConnection();
        }
        return directBrokerConnection;
    }

    private synchronized void getBroker() {
        try {
            if (this.bkr == null) {
                this.bkr = isDirect ? (isTwoThread ? (JMSBroker)Class.forName(DIRECT_BROKER_PROCESS2).newInstance() : (JMSBroker)Class.forName(DIRECT_BROKER_PROCESS).newInstance()) : (JMSBroker)Class.forName(BROKER_PROCESS).newInstance();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    static {
        boolean bl = Boolean.getBoolean("imq.embed.broker.direct.disabled");
        if (bl) {
            isDirect = false;
        }
        isTwoThread = Boolean.valueOf(System.getProperty("imq.embed.broker.direct.twothread", "true"));
    }

    private static class MyInstance {
        private static final BrokerInstanceImpl self = new BrokerInstanceImpl();

        private MyInstance() {
        }
    }
}

