/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyStatus;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.HashMap;

abstract class ReplyWaiter {
    protected Logger logger = Globals.getLogger();
    protected static final int WAITING = 0;
    protected int waitStatus = 0;
    protected HashMap participants = new HashMap();
    protected HashMap replies = new HashMap();
    private short protocol;
    private static final long DEFAULT_WAIT_INTERVAL = 60000L;

    public ReplyWaiter(BrokerAddress brokerAddress, short s) {
        this(new BrokerAddress[]{brokerAddress}, s);
    }

    public ReplyWaiter(BrokerAddress[] brokerAddressArray, short s) {
        for (int i = 0; i < brokerAddressArray.length; ++i) {
            this.participants.put(brokerAddressArray[i], "");
        }
        this.protocol = s;
    }

    public synchronized int getWaitStatus() {
        return this.waitStatus;
    }

    public synchronized void setWaitStatus(int n) {
        this.waitStatus = n;
        this.notify();
    }

    private synchronized String currentParticipants() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (BrokerAddress brokerAddress : this.participants.keySet()) {
            stringBuffer.append("\n\t" + brokerAddress.toString());
        }
        return stringBuffer.toString();
    }

    public synchronized ReplyStatus waitForReply(long l) throws BrokerException {
        long l2 = System.currentTimeMillis() + l * 1000L;
        long l3 = l * 1000L;
        if (l3 > 60000L) {
            l3 = 60000L;
        }
        int n = 1;
        while (this.waitStatus == 0) {
            try {
                this.logger.log(n, Globals.getBrokerResources().getKString("B1174", ProtocolGlobals.getPacketTypeDisplayString(this.protocol), this.currentParticipants()));
                this.wait(l3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l4 = System.currentTimeMillis();
            if (l4 >= l2) {
                if (this.waitStatus != 0) continue;
                this.waitStatus = 408;
                continue;
            }
            l3 = l2 - l4;
            if (l3 > 60000L) {
                l3 = 60000L;
            }
            n = 8;
        }
        if (this.waitStatus == 200) {
            return this.getReply();
        }
        throw new BrokerException(Status.getString((int)this.waitStatus), this.waitStatus);
    }

    public synchronized void abort() {
        if (this.waitStatus != 0) {
            return;
        }
        this.waitStatus = 200;
        this.notify();
    }

    public synchronized void notifyReply(BrokerAddress brokerAddress, GPacket gPacket) {
        if (this.participants.remove(brokerAddress) != null) {
            this.replies.put(brokerAddress, new ReplyStatus(gPacket));
            this.onReply(brokerAddress, gPacket);
        }
    }

    public synchronized void addParticipant(BrokerAddress brokerAddress) {
        this.onAddParticipant(brokerAddress);
    }

    public synchronized void removeParticipant(BrokerAddress brokerAddress, boolean bl, boolean bl2) {
        if (this.waitStatus != 0) {
            return;
        }
        this.onRemoveParticipant(brokerAddress, bl, bl2);
    }

    public abstract void onReply(BrokerAddress var1, GPacket var2);

    public abstract void onAddParticipant(BrokerAddress var1);

    public abstract void onRemoveParticipant(BrokerAddress var1, boolean var2, boolean var3);

    public abstract ReplyStatus getReply();
}

