/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQDirectService;
import com.sun.messaging.jmq.jmsservice.JMSAck;
import com.sun.messaging.jmq.jmsservice.JMSPacket;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

class SessionListener
implements EventListener,
Runnable {
    IMQDirectService parent;
    boolean valid = false;
    boolean stopped = true;
    Session session = null;
    boolean sync = true;
    boolean sessionEvListenerRegistered = false;
    boolean started = false;
    static HashMap listeners = new HashMap();
    HashMap consumers = new HashMap();
    Object sessionLock = new Object();
    Object sessionEL = null;
    boolean sessionLockNotify = false;
    HashSet cuidNotify = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionListener getListener(SessionUID sessionUID) {
        HashMap hashMap = listeners;
        synchronized (hashMap) {
            return (SessionListener)listeners.get((Object)sessionUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionListener(IMQDirectService iMQDirectService, Session session) {
        this.parent = iMQDirectService;
        this.session = session;
        HashMap hashMap = listeners;
        synchronized (hashMap) {
            listeners.put(session.getSessionUID(), this);
        }
    }

    public Packet getNextConsumerPacket(ConsumerUID consumerUID) {
        return this.getNextConsumerPacket(consumerUID, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet getNextConsumerPacket(ConsumerUID consumerUID, long l) {
        ConsumerUID consumerUID2;
        if (!this.sync) {
            throw new RuntimeException("Cannot invoke SessionListener.getNextConsumerPacket() when in asynchronous receiving mode");
        }
        Consumer consumer = Consumer.getConsumer(consumerUID);
        this.sync = true;
        if (l < 0L && (this.stopped || !consumer.isBusy())) {
            return null;
        }
        Object object = consumer.addEventListener(this, EventType.BUSY_STATE_CHANGED, null);
        while (!consumer.isBusy() || this.stopped) {
            try {
                consumerUID2 = consumer.getConsumerUID();
                synchronized (consumerUID2) {
                    Object object2 = this.sessionLock;
                    synchronized (object2) {
                        if (this.stopped) {
                            if (l > 0L) {
                                long l2 = System.currentTimeMillis();
                                try {
                                    this.sessionLock.wait(l);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                long l3 = System.currentTimeMillis();
                                if ((l -= l3 - l2) <= 0L) {
                                    return null;
                                }
                            } else if (l == 0L) {
                                try {
                                    this.sessionLock.wait(l);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (this.stopped) {
                                return null;
                            }
                        }
                    }
                    if (this.cuidNotify.remove(consumer.getConsumerUID())) {
                        continue;
                    }
                    if (l < 0L) {
                        consumer.removeEventListener(object);
                        return null;
                    }
                    consumer.getConsumerUID().wait(l);
                }
                if (this.stopped) {
                    return null;
                }
                if (!consumer.isBusy() && l > 0L) {
                    consumer.removeEventListener(object);
                    return null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            consumer.removeEventListener(object);
        }
        if (this.stopped) {
            return null;
        }
        consumerUID2 = consumer.getConsumerUID();
        synchronized (consumerUID2) {
            this.cuidNotify.remove(consumer.getConsumerUID());
        }
        consumerUID2 = new Packet();
        if (this.session.fillNextPacket((Packet)consumerUID2, consumerUID)) {
            return consumerUID2;
        }
        return this.getNextConsumerPacket(consumerUID, l);
    }

    public void setAsyncListener(Consumer consumer, com.sun.messaging.jmq.jmsservice.Consumer consumer2) {
        if (consumer2 == null) {
            this.sync = true;
            ConsumerUID consumerUID = consumer.getConsumerUID();
            this.consumers.remove(consumerUID);
            return;
        }
        this.sync = false;
        ConsumerUID consumerUID = consumer.getConsumerUID();
        this.consumers.put(consumerUID, consumer2);
        if (!this.sessionEvListenerRegistered) {
            this.sessionEL = this.session.addEventListener(this, EventType.BUSY_STATE_CHANGED, null);
            this.sessionEvListenerRegistered = true;
        }
        if (!this.started) {
            Thread thread = new Thread((Runnable)this, "Session" + (Object)((Object)this.session.getSessionUID()));
            thread.start();
            this.started = true;
        }
    }

    public void run() {
        this.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        if (this.sync) {
            throw new RuntimeException("Cannot invoke SessionListener.process() when in synchronous receiving mode");
        }
        this.valid = true;
        while (this.valid) {
            ConsumerUID consumerUID;
            Object object;
            while (!this.session.isBusy() || this.stopped) {
                object = this.sessionLock;
                synchronized (object) {
                    if (this.sessionLockNotify) {
                        this.sessionLockNotify = false;
                        continue;
                    }
                    try {
                        this.sessionLock.wait();
                    }
                    catch (Exception exception) {
                        Globals.getLogger().log(1, "Exception in sessionlock wait", (Throwable)exception);
                    }
                }
            }
            object = this.sessionLock;
            synchronized (object) {
                this.sessionLockNotify = false;
            }
            if (!this.session.isBusy() || this.stopped || (consumerUID = this.session.fillNextPacket((Packet)(object = new Packet()))) == null) continue;
            com.sun.messaging.jmq.jmsservice.Consumer consumer = (com.sun.messaging.jmq.jmsservice.Consumer)this.consumers.get(consumerUID);
            try {
                JMSAck jMSAck = null;
                jMSAck = consumer.deliver((JMSPacket)object);
                if (jMSAck == null) continue;
                long l = jMSAck.getTransactionId();
                long l2 = jMSAck.getConsumerId();
                SysMessageID sysMessageID = jMSAck.getSysMessageID();
                TransactionUID transactionUID = null;
                ConsumerUID consumerUID2 = null;
                if (l != 0L) {
                    transactionUID = new TransactionUID(l);
                }
                if (l2 != 0L) {
                    consumerUID2 = new ConsumerUID(l2);
                }
                IMQConnection iMQConnection = this.parent.checkConnectionId(jMSAck.getConnectionId(), "Listener Thread");
                SysMessageID[] sysMessageIDArray = new SysMessageID[]{object.getSysMessageID()};
                ConsumerUID[] consumerUIDArray = new ConsumerUID[]{consumerUID2};
                Globals.getProtocol().acknowledge(iMQConnection, transactionUID, false, 0, null, null, 0, sysMessageIDArray, consumerUIDArray);
            }
            catch (Exception exception) {
                Globals.getLogger().log(32, "Can not deliver message to " + consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
        if (eventType != EventType.BUSY_STATE_CHANGED) {
            return;
        }
        if (object instanceof Consumer) {
            Consumer consumer = (Consumer)object;
            ConsumerUID consumerUID = consumer.getConsumerUID();
            if (consumer.isBusy()) {
                ConsumerUID consumerUID2 = consumerUID;
                synchronized (consumerUID2) {
                    this.cuidNotify.add(consumerUID);
                    consumerUID.notifyAll();
                }
            }
            return;
        }
        Session session = (Session)object;
        Object object5 = this.sessionLock;
        synchronized (object5) {
            this.sessionLockNotify = true;
            this.sessionLock.notify();
        }
    }

    public static void startConnection(IMQConnection iMQConnection) {
        if (iMQConnection == null) {
            return;
        }
        List list = iMQConnection.getSessions();
        if (list == null) {
            return;
        }
        for (SessionUID sessionUID : list) {
            SessionListener sessionListener = SessionListener.getListener(sessionUID);
            sessionListener.startSession();
        }
    }

    public static void stopConnection(IMQConnection iMQConnection) {
        if (iMQConnection == null) {
            return;
        }
        List list = iMQConnection.getSessions();
        if (list == null) {
            return;
        }
        for (SessionUID sessionUID : list) {
            SessionListener sessionListener = SessionListener.getListener(sessionUID);
            sessionListener.stopSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSession() {
        this.stopped = false;
        Object object = this.sessionLock;
        synchronized (object) {
            this.sessionLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSession() {
        this.stopped = true;
        Object object = this.sessionLock;
        synchronized (object) {
            this.sessionLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.valid = false;
        Object object = this.sessionLock;
        synchronized (object) {
            this.sessionLock.notify();
        }
        this.session.removeEventListener(this.sessionEL);
        object = listeners;
        synchronized (object) {
            listeners.remove((Object)this.session.getSessionUID());
        }
        this.consumers = null;
    }
}

