/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.lists.EventBroadcastHelper;
import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Prioritized;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.log.Logger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Session
implements EventBroadcaster,
EventListener {
    private static boolean DEBUG = false;
    private static boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg") || DEBUG;
    public static final int AUTO_ACKNOWLEDGE = 1;
    public static final int CLIENT_ACKNOWLEDGE = 2;
    public static final int DUPS_OK_ACKNOWLEDGE = 3;
    public static final int NO_ACK_ACKNOWLEDGE = 32768;
    public static final int NONE = 0;
    protected Logger logger = Globals.getLogger();
    private int ackType = 0;
    private boolean isTransacted = false;
    private boolean isXATransacted = false;
    private TransactionUID currentTransactionID = null;
    SessionUID uid;
    Map deliveredMessages;
    Map cidToStoredCid = null;
    Object sessionLock = new Object();
    EventBroadcastHelper evb = new EventBroadcastHelper();
    Map cleanupList = new HashMap();
    Map storeMap = new HashMap();
    Map consumers = null;
    Map listeners = null;
    Set busyConsumers = null;
    boolean paused = false;
    int pausecnt = 0;
    boolean valid = false;
    private boolean busy = false;
    ConnectionUID parentCuid = null;
    transient String creator = null;
    private static boolean NOACK_ENABLED = false;
    Set detachedRConsumerUIDs = Collections.synchronizedSet(new LinkedHashSet());
    static Map ConsumerToSession;
    static Map allSessions;

    public static boolean isValidAckType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 32768: {
                return true;
            }
        }
        return false;
    }

    public ConnectionUID getConnectionUID() {
        return this.parentCuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getAllDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("TABLE", "All Sessions");
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        Map map = allSessions;
        synchronized (map) {
            hashtable.put("allSessionCnt", String.valueOf(allSessions.size()));
            for (Object object : allSessions.values()) {
                hashtable2.put(String.valueOf(((Session)object).getSessionUID().longValue()), ((Session)object).getDebugState());
            }
        }
        hashtable.put("allSessions", hashtable2);
        hashtable2 = new Hashtable();
        map = ConsumerToSession;
        synchronized (map) {
            hashtable.put("ConsumerToSession", String.valueOf(ConsumerToSession.size()));
            for (Object object : ConsumerToSession.keySet()) {
                hashtable2.put(object.toString(), ConsumerToSession.get(object).toString());
            }
        }
        hashtable.put("ConsumerToSession", hashtable2);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Object object;
        Cloneable cloneable;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("TABLE", "Session[" + this.uid.longValue() + "]");
        hashtable.put("uid", String.valueOf(this.uid.longValue()));
        hashtable.put("connection", String.valueOf(this.parentCuid.longValue()));
        hashtable.put("paused", String.valueOf(this.paused));
        hashtable.put("pausecnt", String.valueOf(this.pausecnt));
        hashtable.put("valid", String.valueOf(this.valid));
        hashtable.put("busy", String.valueOf(this.busy));
        hashtable.put("PendingAcks(deliveredMessages)", String.valueOf(this.deliveredMessages.size()));
        if (this.deliveredMessages.size() > 0) {
            int n;
            Object object22;
            cloneable = null;
            object = null;
            Iterator iterator = null;
            Object object3 = this.deliveredMessages;
            synchronized (object3) {
                cloneable = new HashMap(this.deliveredMessages);
            }
            object3 = this.consumers;
            synchronized (object3) {
                object = new ArrayList(this.consumers.keySet());
            }
            iterator = (Iterator)new int[((ArrayList)object).size()];
            for (Object object22 : ((HashMap)cloneable).values()) {
                n = ((ArrayList)object).indexOf(((ackEntry)object22).getConsumerUID());
                if (n == -1) continue;
                Iterator iterator2 = iterator;
                int n2 = n;
                iterator2[n2] = iterator2[n2] + true;
            }
            object22 = new Hashtable();
            for (n = 0; n < ((ArrayList)object).size(); ++n) {
                if (iterator[n] == false) continue;
                ConsumerUID consumerUID = (ConsumerUID)((ArrayList)object).get(n);
                ((Hashtable)object22).put(String.valueOf(consumerUID.longValue()), String.valueOf(iterator[n]));
            }
            if (!((Hashtable)object22).isEmpty()) {
                hashtable.put("PendingAcksByConsumer", object22);
            }
        }
        hashtable.put("consumerCnt", String.valueOf(this.consumers.size()));
        cloneable = new Vector();
        object = this.consumers;
        synchronized (object) {
            for (Object object3 : this.consumers.keySet()) {
                ((Vector)cloneable).add(String.valueOf(object3.longValue()));
            }
        }
        hashtable.put("consumers", cloneable);
        hashtable.put("busyConsumerCnt", String.valueOf(this.busyConsumers.size()));
        cloneable = new Vector();
        object = this.busyConsumers;
        synchronized (object) {
            for (Object object3 : this.busyConsumers) {
                ((Vector)cloneable).add(String.valueOf(object3.longValue()));
            }
        }
        hashtable.put("busyConsumers", cloneable);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDebugMessages(boolean bl) {
        Vector<String> vector = new Vector<String>();
        Map map = this.deliveredMessages;
        synchronized (map) {
            for (ackEntry ackEntry2 : this.deliveredMessages.values()) {
                vector.add(ackEntry2.getDebugMessage(bl));
            }
        }
        return vector;
    }

    public int getNumPendingAcks(ConsumerUID consumerUID) {
        return this.getPendingAcks(consumerUID).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPendingAcks(ConsumerUID consumerUID) {
        ArrayList<SysMessageID> arrayList = new ArrayList<SysMessageID>();
        HashMap hashMap = new HashMap();
        Map map = this.deliveredMessages;
        synchronized (map) {
            if (this.deliveredMessages.size() == 0) {
                return arrayList;
            }
            hashMap.putAll(this.deliveredMessages);
        }
        for (ackEntry ackEntry2 : hashMap.values()) {
            if (!ackEntry2.getConsumerUID().equals(consumerUID)) continue;
            arrayList.add(ackEntry2.getSysMessageID());
        }
        return arrayList;
    }

    public void setAckType(int n) throws BrokerException {
        if (!Session.isValidAckType(n)) {
            throw new BrokerException("Internal Error: Invalid Ack Type :" + n, 400);
        }
        if (n == 32768 && !NOACK_ENABLED) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3122", Globals.getBrokerResources().getKString("B0058")), "B3122", null, 405);
        }
        this.ackType = n;
    }

    public int getConsumerCnt() {
        if (this.consumers == null) {
            return 0;
        }
        return this.consumers.size();
    }

    public Iterator getConsumers() {
        if (this.consumers == null) {
            return new ArrayList().iterator();
        }
        return new ArrayList(this.consumers.values()).iterator();
    }

    public boolean isAutoAck(ConsumerUID consumerUID) {
        if (this.isUnknown()) {
            return consumerUID.isAutoAck();
        }
        return this.ackType == 1;
    }

    public boolean isUnknown() {
        return this.ackType == 0;
    }

    public boolean isClientAck(ConsumerUID consumerUID) {
        if (this.isUnknown()) {
            return !consumerUID.isAutoAck() && !consumerUID.isDupsOK();
        }
        return this.ackType == 2;
    }

    public boolean isDupsOK(ConsumerUID consumerUID) {
        if (this.isUnknown()) {
            return consumerUID.isDupsOK();
        }
        return this.ackType == 3;
    }

    public boolean isUnsafeAck(ConsumerUID consumerUID) {
        return this.isDupsOK(consumerUID) || this.isNoAck(consumerUID);
    }

    public boolean isNoAck(ConsumerUID consumerUID) {
        if (this.isUnknown()) {
            return consumerUID.isNoAck();
        }
        return this.ackType == 32768;
    }

    public boolean isTransacted() {
        return this.isTransacted;
    }

    public TransactionUID getCurrentTransactionID() {
        return this.currentTransactionID;
    }

    public void debug(String string) {
        if (string == null) {
            string = "";
        }
        this.logger.log(8, string + "Session " + (Object)((Object)this.uid));
        this.logger.log(8, "Paused " + this.paused);
        this.logger.log(8, "pausecnt " + this.pausecnt);
        this.logger.log(8, "busy " + this.busy);
        this.logger.log(8, "ConsumerCnt " + this.consumers.size());
        this.logger.log(8, "BusyConsumerCnt " + this.consumers.size());
        for (Consumer consumer : this.consumers.values()) {
            consumer.debug("\t");
        }
    }

    private Session(ConnectionUID connectionUID, String string) {
        this(new SessionUID(), connectionUID, string);
    }

    private Session(SessionUID sessionUID, ConnectionUID connectionUID, String string) {
        this.uid = sessionUID;
        this.parentCuid = connectionUID;
        this.deliveredMessages = Collections.synchronizedMap(new LinkedHashMap());
        this.cidToStoredCid = Collections.synchronizedMap(new HashMap());
        this.consumers = Collections.synchronizedMap(new HashMap());
        this.listeners = Collections.synchronizedMap(new HashMap());
        this.busyConsumers = Collections.synchronizedSet(new LinkedHashSet());
        this.valid = true;
        this.creator = string;
        DEBUG = DEBUG || this.logger.getLevel() <= 4 || DEBUG_CLUSTER_MSG;
        this.logger.log(4, "Created new session " + (Object)((Object)sessionUID) + " on connection " + (Object)((Object)connectionUID));
    }

    public void dump(String string) {
        if (string == null) {
            string = "";
        }
        this.logger.log(8, string + " Session " + (Object)((Object)this.uid));
        this.logger.log(8, string + "---------------------------");
        this.logger.log(8, string + "busyConsumers (size) " + this.busyConsumers.size());
        this.logger.log(8, string + "busyConsumers (list) " + this.busyConsumers);
        this.logger.log(8, string + "consumers (size) " + this.consumers.size());
        this.logger.log(8, string + "consumers (list) " + this.consumers);
        this.logger.log(8, string + "---------------------------");
        Iterator iterator = this.consumers.values().iterator();
        while (iterator.hasNext()) {
            ((Consumer)iterator.next()).dump(string + "\t");
        }
    }

    public SessionUID getSessionUID() {
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(String string) {
        Object object = this.sessionLock;
        synchronized (object) {
            this.paused = true;
            ++this.pausecnt;
            if (DEBUG) {
                this.logger.log(8, "Session: Pausing " + this + "[" + this.pausecnt + "]" + string);
            }
        }
        this.checkState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(String string) {
        Object object = this.sessionLock;
        synchronized (object) {
            --this.pausecnt;
            if (this.pausecnt <= 0) {
                this.paused = false;
            }
            assert (this.pausecnt >= 0) : "Bad pause " + this;
            if (DEBUG) {
                this.logger.log(8, "Session: Resuming " + this + "[" + this.pausecnt + "]" + string);
            }
        }
        this.checkState(null);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean hasWork() {
        return this.busyConsumers.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fillNextPacket(Packet packet, ConsumerUID consumerUID) {
        if (this.paused) {
            return false;
        }
        Consumer consumer = (Consumer)this.consumers.get(consumerUID);
        PacketReference packetReference = null;
        Object object = this.sessionLock;
        synchronized (object) {
            Object object2;
            packetReference = consumer.getAndFillNextPacket(packet);
            if (packetReference == null) {
                return false;
            }
            ConsumerUID consumerUID2 = consumer.getStoredConsumerUID();
            ackEntry ackEntry2 = null;
            if (!consumer.getConsumerUID().isNoAck()) {
                ackEntry2 = new ackEntry(packetReference, consumerUID, consumerUID2);
                object2 = this.deliveredMessages;
                synchronized (object2) {
                    this.deliveredMessages.put(ackEntry2, ackEntry2);
                }
            }
            try {
                object2 = consumer.getConsumerUID();
                boolean bl = !this.isAutoAck((ConsumerUID)object2) || this.deliveredMessages.size() == 1;
                if (packetReference.delivered((ConsumerUID)object2, consumerUID2, !this.isUnsafeAck((ConsumerUID)object2), bl)) {
                    Destination destination = packetReference.getDestination();
                    if (packetReference.isDead()) {
                        destination.removeDeadMessage(packetReference);
                        packetReference = null;
                    } else {
                        destination.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    }
                }
            }
            catch (Exception exception) {
                this.logger.logStack(8, "Message Gone, unable to update state of the message " + packetReference, (Throwable)exception);
                Map map = this.deliveredMessages;
                synchronized (map) {
                    if (ackEntry2 != null) {
                        this.deliveredMessages.get(ackEntry2);
                    }
                }
            }
        }
        return packetReference != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerUID fillNextPacket(Packet packet) {
        if (this.paused) {
            return null;
        }
        ConsumerUID consumerUID = null;
        Consumer consumer = null;
        while (!this.paused) {
            Object object;
            Object object2 = this.busyConsumers;
            synchronized (object2) {
                if (this.busyConsumers.isEmpty()) {
                    break;
                }
                object = this.busyConsumers.iterator();
                consumerUID = (ConsumerUID)object.next();
                consumer = (Consumer)this.consumers.get(consumerUID);
                object.remove();
            }
            assert (packet != null);
            if (consumer == null) {
                return null;
            }
            object2 = null;
            object = this.sessionLock;
            synchronized (object) {
                block32: {
                    Object object3;
                    Object object4;
                    if (this.paused) {
                        object4 = this.busyConsumers;
                        synchronized (object4) {
                            if (consumer.isBusy()) {
                                this.busyConsumers.add(consumerUID);
                            }
                        }
                        return null;
                    }
                    object2 = consumer.getAndFillNextPacket(packet);
                    object4 = this.busyConsumers;
                    synchronized (object4) {
                        if (consumer.isBusy()) {
                            this.busyConsumers.add(consumerUID);
                        }
                    }
                    if (object2 == null) {
                        continue;
                    }
                    object4 = consumer.getStoredConsumerUID();
                    ackEntry ackEntry2 = null;
                    if (!consumer.getConsumerUID().isNoAck()) {
                        ackEntry2 = new ackEntry((PacketReference)object2, consumerUID, (ConsumerUID)object4);
                        object3 = this.deliveredMessages;
                        synchronized (object3) {
                            this.deliveredMessages.put(ackEntry2, ackEntry2);
                        }
                    }
                    try {
                        object3 = consumer.getConsumerUID();
                        boolean bl = !this.isAutoAck((ConsumerUID)object3) || this.deliveredMessages.size() == 1;
                        if (!((PacketReference)object2).delivered((ConsumerUID)object3, (ConsumerUID)object4, !this.isUnsafeAck((ConsumerUID)object3), bl)) break block32;
                        Destination destination = ((PacketReference)object2).getDestination();
                        if (((PacketReference)object2).isDead()) {
                            destination.removeDeadMessage((PacketReference)object2);
                            object2 = null;
                            continue;
                        }
                        destination.removeMessage(((PacketReference)object2).getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    }
                    catch (Exception exception) {
                        this.logger.logStack(8, "Message Gone, unable to update state of the message " + object2, (Throwable)exception);
                        Map map = this.deliveredMessages;
                        synchronized (map) {
                            if (ackEntry2 != null) {
                                this.deliveredMessages.get(ackEntry2);
                            }
                        }
                    }
                }
            }
            this.checkState(null);
            return object2 != null && consumerUID != null ? consumerUID : null;
        }
        this.checkState(null);
        return null;
    }

    public Object getBusyLock() {
        return this.busyConsumers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        Set set = this.busyConsumers;
        synchronized (set) {
            return this.busy;
        }
    }

    public String toString() {
        return "Session [" + (Object)((Object)this.uid) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void attachConsumer(Consumer consumer) {
        this.logger.log(4, "Attaching Consumer " + consumer.getConsumerUID() + " to Session " + (Object)((Object)this.uid));
        if (!this.valid) {
            throw new IllegalStateException(this + " is closed");
        }
        consumer.attachToSession(this.getSessionUID());
        ConsumerUID consumerUID = consumer.getConsumerUID();
        consumerUID.setAckType(this.ackType);
        consumer.getStoredConsumerUID().setAckType(this.ackType);
        this.consumers.put(consumerUID, consumer);
        Destination destination = consumer.getFirstDestination();
        this.listeners.put(consumerUID, consumer.addEventListener(this, EventType.BUSY_STATE_CHANGED, null));
        if (consumer.isBusy()) {
            this.busyConsumers.add(consumerUID);
        }
        Map map = ConsumerToSession;
        synchronized (map) {
            ConsumerToSession.put(consumer.getConsumerUID(), this.getSessionUID());
        }
        this.checkState(null);
    }

    public Consumer detatchConsumer(ConsumerUID consumerUID, SysMessageID sysMessageID, boolean bl, boolean bl2) throws BrokerException {
        this.pause("Consumer.java: detatch consumer " + consumerUID);
        Consumer consumer = (Consumer)this.consumers.remove(consumerUID);
        if (consumer == null) {
            assert (consumer != null);
            this.resume("Consumer.java: bad removal " + consumerUID);
            throw new BrokerException("Detatching consumer " + consumerUID + " not currently attached " + "to " + this);
        }
        consumer.pause("Consumer.java: detatch consumer " + consumerUID + " DEAD");
        this.detatchConsumer(consumer, sysMessageID, bl, bl2);
        this.resume("Consumer.java: detatch consumer " + consumerUID);
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detatchConsumer(Consumer consumer, SysMessageID sysMessageID, boolean bl, boolean bl2) {
        if (DEBUG) {
            this.logger.log(8, "Detaching Consumer " + consumer.getConsumerUID() + " on connection " + (Object)((Object)consumer.getConnectionUID()) + " from Session " + (Object)((Object)this.uid) + " last id was " + sysMessageID);
        }
        consumer.pause("Consumer.java: Detatch consumer 1 " + consumer);
        this.pause("Consumer.java: Detatch consumer A " + consumer);
        ConsumerUID consumerUID = consumer.getConsumerUID();
        ConsumerUID consumerUID2 = consumer.getStoredConsumerUID();
        Object v = this.listeners.remove(consumerUID);
        assert (v != null);
        consumer.removeEventListener(v);
        consumer.attachToSession(null);
        this.busyConsumers.remove(consumerUID);
        this.consumers.remove(consumerUID);
        this.checkState(null);
        LinkedHashSet<PacketReference> linkedHashSet = new LinkedHashSet<PacketReference>();
        HashMap hashMap = new HashMap();
        Map map = this.deliveredMessages;
        synchronized (map) {
            List<SysMessageID> list;
            BrokerAddress brokerAddress;
            PacketReference packetReference;
            ackEntry ackEntry2;
            boolean bl3;
            Object object;
            ackEntry ackEntry3 = null;
            if (sysMessageID != null) {
                object = new ackEntry(sysMessageID, consumerUID);
                ackEntry3 = (ackEntry)this.deliveredMessages.get(object);
            }
            this.cleanupList.put(consumerUID, consumer.getParentList());
            this.storeMap.put(consumerUID, consumer.getStoredConsumerUID());
            object = this.deliveredMessages.values().iterator();
            boolean bl4 = bl3 = ackEntry3 == null && sysMessageID != null;
            while (!bl2 && !bl3 && object.hasNext()) {
                ackEntry2 = (ackEntry)object.next();
                if (ackEntry2 == ackEntry3) {
                    bl3 = true;
                }
                if (ackEntry2.storedcid != consumerUID2 && ackEntry2.uid != consumerUID) continue;
                packetReference = ackEntry2.getReference();
                try {
                    packetReference.consumed(consumerUID2, !this.isUnsafeAck(consumerUID), this.isAutoAck(consumerUID));
                }
                catch (Exception exception) {
                    this.logger.log(8, "Internal Error Unable to consume " + consumerUID2 + ":" + packetReference, (Throwable)exception);
                }
                if (bl) {
                    if (packetReference != null) {
                        linkedHashSet.add(packetReference);
                    }
                    object.remove();
                    continue;
                }
                if (this.isTransacted && !Globals.getTransactionList().isConsumedInTransaction(ackEntry2.getSysMessageID(), ackEntry2.uid)) {
                    if (packetReference != null) {
                        linkedHashSet.add(packetReference);
                    }
                    object.remove();
                    continue;
                }
                if (packetReference == null || packetReference.isLocal() || !this.valid || (brokerAddress = packetReference.getAddress()) == null) continue;
                list = (List)hashMap.get(brokerAddress);
                if (list == null) {
                    list = new ArrayList();
                    hashMap.put(brokerAddress, list);
                }
                list.add(packetReference.getSysMessageID());
                this.detachedRConsumerUIDs.add(ackEntry2.uid);
            }
            while (object.hasNext()) {
                ackEntry2 = (ackEntry)object.next();
                if (!ackEntry2.storedcid.equals(consumerUID2) || !ackEntry2.uid.equals(consumerUID)) continue;
                packetReference = ackEntry2.getReference();
                if (this.isTransacted && Globals.getTransactionList().isConsumedInTransaction(ackEntry2.getSysMessageID(), ackEntry2.uid)) {
                    if (packetReference == null || packetReference.isLocal() || !this.valid || (brokerAddress = packetReference.getAddress()) == null) continue;
                    list = (ArrayList<SysMessageID>)hashMap.get(brokerAddress);
                    if (list == null) {
                        list = new ArrayList<SysMessageID>();
                        hashMap.put(brokerAddress, list);
                    }
                    list.add(packetReference.getSysMessageID());
                    this.detachedRConsumerUIDs.add(ackEntry2.uid);
                    continue;
                }
                if (packetReference != null) {
                    linkedHashSet.add(packetReference);
                }
                object.remove();
                try {
                    if (packetReference == null) continue;
                    packetReference.removeDelivered(consumerUID2, true);
                }
                catch (Exception exception) {
                    this.logger.log(8, "Internal Error Unable to consume " + consumerUID2 + ":" + packetReference, (Throwable)exception);
                }
            }
        }
        consumer.destroyConsumer(linkedHashSet, hashMap, consumer.tobeRecreated() || !this.valid && !this.isXATransacted, false, true);
        this.resume("Consumer.java: resuming after detatch " + consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerAddress acknowledgeInTransaction(ConsumerUID consumerUID, SysMessageID sysMessageID, TransactionUID transactionUID, boolean bl) throws BrokerException {
        if (!this.isTransacted) {
            this.isTransacted = true;
        }
        if (bl && !this.isXATransacted) {
            this.isXATransacted = true;
        }
        this.currentTransactionID = transactionUID;
        ackEntry ackEntry2 = new ackEntry(sysMessageID, consumerUID);
        Object object = this.deliveredMessages;
        synchronized (object) {
            ackEntry2 = (ackEntry)this.deliveredMessages.get(ackEntry2);
        }
        if (ackEntry2 == null) {
            object = "Received unknown message for transaction " + transactionUID + " on session " + (Object)((Object)this.uid) + " ack info is " + consumerUID + "," + sysMessageID;
            PacketReference packetReference = Destination.get(sysMessageID);
            object = packetReference == null ? (String)object + ": Broker does not know about the message" : (String)object + ":Broker knows about the message, not associated with the session";
            this.logger.log(16, (String)object);
            BrokerException brokerException = new BrokerException((String)object, 410);
            brokerException.setRemoteConsumerUIDs(String.valueOf(consumerUID.longValue()));
            brokerException.setRemote(true);
            throw brokerException;
        }
        if (ackEntry2.getTUID() != null && !ackEntry2.getTUID().equals(transactionUID)) {
            object = new BrokerException("Message requeued:" + ackEntry2.getReference(), 410);
            ((BrokerException)object).setRemoteConsumerUIDs(String.valueOf(ackEntry2.getConsumerUID().longValue()));
            ((BrokerException)object).setRemote(true);
            throw object;
        }
        object = ackEntry2.getReference();
        if (object == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B1290", "" + sysMessageID + "[" + consumerUID + ":" + ackEntry2.getStoredUID() + "]TUID=" + transactionUID), 409);
        }
        if (((PacketReference)object).isOverrided()) {
            BrokerException brokerException = new BrokerException("Message requeued:" + ackEntry2.getReference(), 410);
            brokerException.setRemoteConsumerUIDs(String.valueOf(ackEntry2.getConsumerUID().longValue()));
            brokerException.setRemote(true);
            throw brokerException;
        }
        ackEntry2.setTUID(transactionUID);
        return ((PacketReference)object).getAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        Object object11;
        Object object2;
        Object object3 = this;
        synchronized (object3) {
            if (!this.valid) {
                return;
            }
            this.valid = false;
        }
        this.logger.log(4, "Close Session " + (Object)((Object)this.uid));
        object3 = Globals.getConnectionManager().getConnection(this.getConnectionUID());
        boolean bl = false;
        if (object3 != null && ((Connection)object3).getClientProtocolVersion() < 350) {
            bl = true;
        }
        Iterator<Object> iterator = null;
        Object object4 = this;
        synchronized (object4) {
            iterator = new HashSet(this.consumers.values()).iterator();
        }
        while (iterator.hasNext()) {
            object4 = (Consumer)iterator.next();
            iterator.remove();
            this.detatchConsumer((Consumer)object4, null, bl, false);
        }
        object4 = this.deliveredMessages;
        synchronized (object4) {
            if (!this.deliveredMessages.isEmpty()) {
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                UID uID;
                ackEntry ackEntry2;
                object2 = new HashMap();
                iterator = this.deliveredMessages.entrySet().iterator();
                while (iterator.hasNext()) {
                    object11 = (Map.Entry)iterator.next();
                    ackEntry2 = (ackEntry)object11.getValue();
                    uID = ackEntry2.getTUID();
                    if (uID != null) {
                        object9 = Globals.getTransactionList().UIDToXid((TransactionUID)uID);
                        object8 = ackEntry2.getConsumerUID();
                        Object object10 = object7 = ackEntry2.getStoredUID() == null ? object8 : ackEntry2.getStoredUID();
                        if (object9 != null) {
                            Globals.getTransactionList().addOrphanAck((TransactionUID)uID, ackEntry2.getSysMessageID(), (ConsumerUID)object7, (ConsumerUID)object8);
                            iterator.remove();
                            continue;
                        }
                        object6 = Globals.getTransactionList().retrieveState((TransactionUID)uID, true);
                        if (object6 != null && ((TransactionState)object6).getState() == 5) {
                            Globals.getTransactionList().addOrphanAck((TransactionUID)uID, ackEntry2.getSysMessageID(), (ConsumerUID)object7, (ConsumerUID)object8);
                            iterator.remove();
                            continue;
                        }
                        if (object6 != null && ((TransactionState)object6).getState() == 6) {
                            iterator.remove();
                            continue;
                        }
                        if (object6 != null && object3 != null && ((TransactionState)object6).getState() == 4 && ((Connection)object3).getConnectionState() >= 6) {
                            object5 = new String[]{"" + uID, TransactionState.toString(((TransactionState)object6).getState()), this.getConnectionUID().toString()};
                            this.logger.log(8, Globals.getBrokerResources().getKString("B1266", (Object[])object5));
                            Globals.getTransactionList().addOrphanAck((TransactionUID)uID, ackEntry2.getSysMessageID(), (ConsumerUID)object7, (ConsumerUID)object8);
                            iterator.remove();
                            continue;
                        }
                    }
                    if ((object9 = ackEntry2.getReference()) == null) {
                        object9 = Destination.get(ackEntry2.getSysMessageID());
                    }
                    if (object9 != null && !((PacketReference)object9).isLocal()) {
                        iterator.remove();
                        try {
                            object9 = ackEntry2.acknowledged(false);
                            if (object9 == null) continue;
                            object8 = ((PacketReference)object9).getDestination();
                            ((Destination)object8).removeRemoteMessage(((PacketReference)object9).getSysMessageID(), RemoveReason.ACKNOWLEDGED, (PacketReference)object9);
                        }
                        catch (Exception exception) {
                            this.logger.logStack(DEBUG_CLUSTER_MSG ? 16 : 4, "Unable to clean up remote message " + ackEntry2.getDebugMessage(false), (Throwable)exception);
                        }
                        continue;
                    }
                    object8 = ackEntry2.getConsumerUID();
                    object7 = (Set)((HashMap)object2).get(object8);
                    if (object7 == null) {
                        object7 = new LinkedHashSet<ackEntry>();
                        ((HashMap)object2).put(object8, object7);
                    }
                    object7.add(ackEntry2);
                }
                for (Object object11 : ((HashMap)object2).keySet()) {
                    ackEntry2 = (Prioritized)this.cleanupList.get(object11);
                    uID = (ConsumerUID)this.storeMap.get(object11);
                    if (ackEntry2 == null) {
                        object9 = (Set)((HashMap)object2).get(object11);
                        object8 = object9.iterator();
                        while (object8.hasNext()) {
                            object7 = (ackEntry)object8.next();
                            try {
                                object6 = ((ackEntry)object7).acknowledged(false);
                                if (object6 == null) continue;
                                object5 = ((PacketReference)object6).getDestination();
                                try {
                                    object5.removeMessage(((PacketReference)object6).getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                                }
                                catch (Exception exception) {
                                    this.logger.logStack(8, "Internal Error", (Throwable)exception);
                                }
                            }
                            catch (Exception exception) {}
                        }
                        continue;
                    }
                    object9 = new LinkedHashSet();
                    object8 = (Set)((HashMap)object2).get(object11);
                    object7 = object8.iterator();
                    while (object7.hasNext()) {
                        object6 = (ackEntry)object7.next();
                        object5 = ((ackEntry)object6).getReference();
                        if (object5 != null) {
                            try {
                                object5.consumed((ConsumerUID)uID, !this.isUnsafeAck((ConsumerUID)object11), this.isAutoAck((ConsumerUID)object11));
                            }
                            catch (Exception exception) {
                                this.logger.log(8, "Internal Error Unable to consume " + uID + ":" + object5, (Throwable)exception);
                            }
                            ((HashSet)object9).add(object5);
                            continue;
                        }
                        object7.remove();
                    }
                    ackEntry2.addAllOrdered((Collection)object9);
                }
                this.deliveredMessages.clear();
                this.cleanupList.clear();
                this.storeMap.clear();
            }
        }
        object4 = this.detachedRConsumerUIDs;
        synchronized (object4) {
            iterator = new LinkedHashSet(this.detachedRConsumerUIDs).iterator();
        }
        if (!this.isXATransacted) {
            while (iterator.hasNext()) {
                object4 = Consumer.newInstance((ConsumerUID)iterator.next());
                try {
                    Globals.getClusterBroadcast().destroyConsumer((Consumer)object4, null, true);
                }
                catch (Exception exception) {
                    this.logger.log(16, "Unable to send consumer [" + object4 + "] cleanup notification for closing of session [" + this + "].");
                }
            }
        }
        object4 = ConsumerToSession;
        synchronized (object4) {
            object2 = ConsumerToSession.values().iterator();
            while (object2.hasNext()) {
                object11 = (SessionUID)((Object)object2.next());
                if (!object11.equals((Object)this.uid)) continue;
                object2.remove();
            }
        }
        allSessions.remove((Object)this.uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketReference handleUndeliverable(ConsumerUID consumerUID, SysMessageID sysMessageID) throws BrokerException {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        ackEntry ackEntry2 = new ackEntry(sysMessageID, consumerUID);
        PacketReference packetReference = null;
        Object object = this.deliveredMessages;
        synchronized (object) {
            ackEntry2 = (ackEntry)this.deliveredMessages.remove(ackEntry2);
        }
        if (ackEntry2 == null) {
            return null;
        }
        packetReference = ackEntry2.getReference();
        if (packetReference == null) {
            return null;
        }
        object = consumer.getStoredConsumerUID();
        if (object.equals((Object)consumerUID)) {
            try {
                if (packetReference.acknowledged(consumerUID, (ConsumerUID)object, false, false)) {
                    return packetReference;
                }
            }
            catch (Exception exception) {
                this.logger.logStack(4, "Error handling undeliverable", (Throwable)exception);
            }
            return null;
        }
        Destination destination = packetReference.getDestination();
        destination.forwardOrphanMessage(packetReference, (ConsumerUID)object);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketReference handleDead(ConsumerUID consumerUID, SysMessageID sysMessageID, Throwable throwable, String string, int n) throws BrokerException {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        ackEntry ackEntry2 = new ackEntry(sysMessageID, consumerUID);
        PacketReference packetReference = null;
        Object object = this.deliveredMessages;
        synchronized (object) {
            ackEntry2 = (ackEntry)this.deliveredMessages.remove(ackEntry2);
        }
        if (ackEntry2 == null) {
            return null;
        }
        packetReference = ackEntry2.getReference();
        if (packetReference == null) {
            return null;
        }
        object = consumer.getStoredConsumerUID();
        Destination destination = packetReference.getDestination();
        if (packetReference.markDead((ConsumerUID)object, string, throwable, RemoveReason.UNDELIVERABLE, n, null)) {
            return packetReference;
        }
        return null;
    }

    public PacketReference ackMessage(ConsumerUID consumerUID, SysMessageID sysMessageID) throws BrokerException {
        return this.ackMessage(consumerUID, sysMessageID, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketReference ackMessage(ConsumerUID consumerUID, SysMessageID sysMessageID, TransactionUID transactionUID, HashMap hashMap) throws BrokerException {
        ackEntry ackEntry2 = new ackEntry(sysMessageID, consumerUID);
        PacketReference packetReference = null;
        Map map = this.deliveredMessages;
        synchronized (map) {
            ackEntry2 = (ackEntry)this.deliveredMessages.remove(ackEntry2);
        }
        if (ackEntry2 == null) {
            return null;
        }
        packetReference = ackEntry2.acknowledged(true, transactionUID, hashMap);
        if (this.isAutoAck(ackEntry2.getConsumerUID())) {
            map = this.deliveredMessages;
            synchronized (map) {
                Iterator iterator = this.deliveredMessages.values().iterator();
                while (iterator.hasNext()) {
                    ackEntry ackEntry3 = (ackEntry)iterator.next();
                    PacketReference packetReference2 = ackEntry3.getReference();
                    if (packetReference2 == null) {
                        packetReference2 = Destination.get(sysMessageID);
                        if (packetReference2 == null) {
                            this.logger.log(2, "Removing purged reference " + ackEntry3);
                        } else {
                            this.logger.log(8, "Weird reference behavior" + packetReference2);
                            try {
                                ackEntry3.acknowledged(true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        iterator.remove();
                        continue;
                    }
                    try {
                        packetReference2.delivered(ackEntry3.getConsumerUID(), ackEntry3.getStoredUID(), true, packetReference2.isStored());
                        break;
                    }
                    catch (Exception exception) {
                        this.logger.logStack(8, "Internal error, unable to deliver " + consumerUID + ":" + packetReference, (Throwable)exception);
                    }
                }
            }
        }
        return packetReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acknowledgeToMessage(ConsumerUID consumerUID, SysMessageID sysMessageID) throws BrokerException {
        boolean bl = false;
        ackEntry ackEntry2 = new ackEntry(sysMessageID, consumerUID);
        Map map = this.deliveredMessages;
        synchronized (map) {
            ackEntry ackEntry3 = (ackEntry)this.deliveredMessages.get(ackEntry2);
            if (ackEntry3 == null) {
                assert (false) : ackEntry2;
                return false;
            }
            Iterator iterator = this.deliveredMessages.values().iterator();
            while (iterator.hasNext()) {
                ackEntry ackEntry4 = (ackEntry)iterator.next();
                PacketReference packetReference = ackEntry4.acknowledged(true);
                if (packetReference != null) {
                    Destination destination = packetReference.getDestination();
                    try {
                        destination.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    }
                    catch (Exception exception) {
                        this.logger.logStack(8, "Internal Error", (Throwable)exception);
                    }
                }
                iterator.remove();
                bl = true;
                if (!ackEntry4.equals(ackEntry3)) continue;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
        ConsumerUID consumerUID = ((Consumer)object).getConsumerUID();
        if (eventType == EventType.BUSY_STATE_CHANGED) {
            Set set = this.busyConsumers;
            synchronized (set) {
                Consumer consumer = (Consumer)this.consumers.get(consumerUID);
                if (consumer != null && consumer.isBusy()) {
                    this.busyConsumers.add(consumerUID);
                }
            }
            this.checkState(null);
        } else assert (false) : " event is not valid ";
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Object object) throws UnsupportedOperationException {
        if (eventType != EventType.BUSY_STATE_CHANGED) {
            throw new UnsupportedOperationException("Only Busy and Not Busy types supported on this class");
        }
        return this.evb.addEventListener(eventListener, eventType, object);
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Reason reason, Object object) throws UnsupportedOperationException {
        if (eventType != EventType.BUSY_STATE_CHANGED) {
            throw new UnsupportedOperationException("Only Busy and Not Busy types supported on this class");
        }
        return this.evb.addEventListener(eventListener, eventType, reason, object);
    }

    public Object removeEventListener(Object object) {
        return this.evb.removeEventListener(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState(Reason reason) {
        boolean bl = false;
        boolean bl2 = false;
        Set set = this.busyConsumers;
        synchronized (set) {
            boolean bl3 = bl2 = !this.paused && this.busyConsumers.size() > 0;
            if (bl2 != this.busy) {
                this.busy = bl2;
                bl = true;
            }
        }
        if (bl) {
            this.notifyChange(EventType.BUSY_STATE_CHANGED, reason, this, !bl2, bl2);
        }
    }

    private void notifyChange(EventType eventType, Reason reason, Object object, Object object2, Object object3) {
        this.evb.notifyChange(eventType, reason, object, object2, object3);
    }

    public synchronized Consumer getConsumerOnSession(ConsumerUID consumerUID) {
        return (Consumer)this.consumers.get(consumerUID);
    }

    public static void clearSessions() {
        ConsumerToSession.clear();
        allSessions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(ConsumerUID consumerUID) {
        SessionUID sessionUID = null;
        Map map = ConsumerToSession;
        synchronized (map) {
            sessionUID = (SessionUID)((Object)ConsumerToSession.get(consumerUID));
        }
        if (sessionUID == null) {
            return null;
        }
        return Session.getSession(sessionUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll() {
        Map map = allSessions;
        synchronized (map) {
            Globals.getLogger().log(8, "Dumping active sessions");
            for (Object k : allSessions.keySet()) {
                Object v = allSessions.get(k);
                Globals.getLogger().log(8, "\t" + k + " : " + v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session createSession(ConnectionUID connectionUID, String string) {
        Session session = new Session(connectionUID, string);
        Map map = allSessions;
        synchronized (map) {
            allSessions.put(session.getSessionUID(), session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session createSession(SessionUID sessionUID, ConnectionUID connectionUID, String string) {
        Session session = new Session(sessionUID, connectionUID, string);
        Map map = allSessions;
        synchronized (map) {
            allSessions.put(session.getSessionUID(), session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeSession(SessionUID sessionUID) {
        Session session = null;
        Map map = allSessions;
        synchronized (map) {
            session = (Session)allSessions.remove((Object)sessionUID);
        }
        if (session == null) {
            return;
        }
        assert (session != null);
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(SessionUID sessionUID) {
        Map map = allSessions;
        synchronized (map) {
            return (Session)allSessions.get((Object)sessionUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(String string) {
        if (string == null) {
            return null;
        }
        Map map = allSessions;
        synchronized (map) {
            for (Session session : allSessions.values()) {
                if (!string.equals(session.creator)) continue;
                return session;
            }
        }
        return null;
    }

    static {
        try {
            LicenseBase licenseBase = Globals.getCurrentLicense(null);
            NOACK_ENABLED = licenseBase.getBooleanProperty("imq.enable_no_ack", false);
        }
        catch (BrokerException brokerException) {
            NOACK_ENABLED = false;
        }
        ConsumerToSession = new HashMap();
        allSessions = new HashMap();
    }

    class ackEntry {
        ConsumerUID uid = null;
        ConsumerUID storedcid = null;
        Object pref = null;
        SysMessageID id = null;
        TransactionUID tuid = null;
        int hc = 0;

        public ackEntry(SysMessageID sysMessageID, ConsumerUID consumerUID) {
            assert (sysMessageID != null);
            assert (consumerUID != null);
            this.id = sysMessageID;
            this.uid = consumerUID;
            this.pref = null;
        }

        public String toString() {
            return this.id + "[" + this.uid + "," + this.storedcid + "]" + (this.tuid == null ? "" : "TUID=" + this.tuid);
        }

        public String getDebugMessage(boolean bl) {
            PacketReference packetReference = this.getReference();
            Packet packet = packetReference == null ? null : packetReference.getPacket();
            String string = "[" + this.uid + "," + this.storedcid + "," + (packet == null ? "null" : packet.toString()) + "]";
            if (bl && packet != null) {
                string = string + "\n" + packet.dumpPacketString(">>");
            }
            return string;
        }

        public void setTUID(TransactionUID transactionUID) {
            this.tuid = transactionUID;
        }

        public TransactionUID getTUID() {
            return this.tuid;
        }

        public ConsumerUID getConsumerUID() {
            return this.uid;
        }

        public ConsumerUID getStoredUID() {
            return this.storedcid;
        }

        public SysMessageID getSysMessageID() {
            return this.id;
        }

        public PacketReference getReference() {
            if (this.pref instanceof WeakReference) {
                return (PacketReference)((WeakReference)this.pref).get();
            }
            return (PacketReference)this.pref;
        }

        public ackEntry(PacketReference packetReference, ConsumerUID consumerUID, ConsumerUID consumerUID2) {
            this.pref = packetReference.isLocal() ? new WeakReference<PacketReference>(packetReference) : packetReference;
            this.id = packetReference.getSysMessageID();
            this.storedcid = consumerUID2;
            this.uid = consumerUID;
        }

        public PacketReference acknowledged(boolean bl) throws BrokerException {
            return this.acknowledged(bl, null, null);
        }

        public PacketReference acknowledged(boolean bl, TransactionUID transactionUID, HashMap hashMap) throws BrokerException {
            assert (this.pref != null);
            boolean bl2 = false;
            PacketReference packetReference = this.getReference();
            try {
                if (packetReference == null || packetReference.isOverrided()) {
                    packetReference = Destination.get(this.id);
                }
                if (packetReference == null) {
                    String string = null;
                    string = transactionUID == null ? Globals.getBrokerResources().getKString("B2212", this.toString()) : Globals.getBrokerResources().getKString("B2213", transactionUID.toString(), this.toString());
                    Session.this.logger.log(16, string);
                    throw new BrokerException(string, 409);
                }
                if (packetReference.isOverrided()) {
                    BrokerException brokerException = new BrokerException("Message requeued:" + packetReference, 410);
                    brokerException.setRemoteConsumerUIDs(String.valueOf(this.getConsumerUID().longValue()));
                    brokerException.setRemote(true);
                    throw brokerException;
                }
                bl2 = packetReference.acknowledged(this.uid, this.storedcid, !Session.this.isUnsafeAck(this.uid), bl, transactionUID, hashMap);
                Consumer consumer = (Consumer)Session.this.consumers.get(this.uid);
                if (consumer != null) {
                    consumer.setLastAckTime(System.currentTimeMillis());
                }
            }
            catch (Exception exception) {
                assert (false) : packetReference;
                Session.this.logger.logStack(4, "Unable to process acknowledgement, Ignoring", (Throwable)exception);
                if (exception instanceof BrokerException) {
                    throw (BrokerException)exception;
                }
                throw new BrokerException("Unable to process ack", exception);
            }
            return bl2 ? packetReference : null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ackEntry)) {
                return false;
            }
            ackEntry ackEntry2 = (ackEntry)object;
            return this.uid.equals(ackEntry2.uid) && this.id.equals((Object)ackEntry2.id);
        }

        public int hashCode() {
            if (this.hc == 0) {
                this.hc = this.id.hashCode() * 15 + this.uid.hashCode();
            }
            return this.hc;
        }
    }
}

