/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RedeliverHandler
extends PacketHandler {
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn");
    static final int REDELIVER_BLOCK_SIZE = 40;
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Hashtable hashtable = null;
        try {
            hashtable = packet.getProperties();
        }
        catch (Exception exception) {
            this.logger.log(8, "Internal Error: unable to retrieve  properties from redeliver message " + packet, (Throwable)exception);
            hashtable = new Hashtable();
        }
        boolean bl = false;
        TransactionUID transactionUID = null;
        if (hashtable != null) {
            long l;
            Object v;
            Boolean bl2 = (Boolean)hashtable.get("JMQSetRedelivered");
            if (bl2 != null) {
                bl = bl2;
            }
            if ((v = hashtable.get("JMQTransactionID")) != null) {
                transactionUID = v instanceof Integer ? new TransactionUID(((Integer)v).intValue()) : new TransactionUID((Long)v);
            }
            if (transactionUID == null && (l = packet.getTransactionID()) != 0L) {
                transactionUID = new TransactionUID(l);
            }
        }
        int n = packet.getMessageBodySize();
        int n2 = n / 40;
        int n3 = n % 40;
        if (n2 == 0) {
            return true;
        }
        if (n3 != 0) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Invalid Redeliver Message Size: " + n + ". Not multiple of " + 40));
        }
        if (DEBUG) {
            this.logger.log(4, "RedeliverMessage: processing message {0} {1}", (Object)packet.toString(), (Object)iMQConnection.getConnectionUID().toString());
        }
        DataInputStream dataInputStream = new DataInputStream(packet.getMessageBodyStream());
        ConsumerUID[] consumerUIDArray = new ConsumerUID[n2];
        SysMessageID[] sysMessageIDArray = new SysMessageID[n2];
        try {
            for (int i = 0; i < n2; ++i) {
                consumerUIDArray[i] = new ConsumerUID(dataInputStream.readLong());
                sysMessageIDArray[i] = new SysMessageID();
                sysMessageIDArray[i].readID((DataInput)dataInputStream);
            }
            this.redeliver(consumerUIDArray, sysMessageIDArray, iMQConnection, transactionUID, bl);
        }
        catch (Exception exception) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Invalid Redeliver Packet", exception), exception);
        }
        return true;
    }

    public void redeliver(ConsumerUID[] consumerUIDArray, SysMessageID[] sysMessageIDArray, IMQConnection iMQConnection, TransactionUID transactionUID, boolean bl) throws BrokerException, IOException {
        Object object;
        Object object2;
        SysMessageID sysMessageID = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        HashMap hashMap = new HashMap();
        boolean bl2 = false;
        for (int i = 0; i < consumerUIDArray.length; ++i) {
            LinkedHashSet<Object> linkedHashSet;
            ConsumerUID object3 = consumerUIDArray[i];
            object3.setConnectionUID(iMQConnection.getConnectionUID());
            sysMessageID = sysMessageIDArray[i];
            object2 = Destination.get(sysMessageID, false);
            if (object2 == null || ((PacketReference)object2).isInvalid()) continue;
            object = Session.getSession(object3);
            Consumer consumer = null;
            if (object != null) {
                if (!hashSet.contains(object)) {
                    ((Session)object).pause("redeliver");
                    hashSet.add(object);
                }
                consumer = ((Session)object).getConsumerOnSession(object3);
            }
            if (consumer == null) {
                consumer = Consumer.getConsumer(object3);
                if (consumer != null) {
                    this.logger.log(16, "Internal Error  consumer with id of " + object3 + " is unavailable " + " on session " + object + "[conuid,sess conuid] =" + "[" + iMQConnection.getConnectionUID().longValue() + "," + (object == null ? 0L : ((Session)object).getConnectionUID().longValue()) + "] consumer session is : " + (Object)((Object)consumer.getSessionUID()));
                    continue;
                }
                this.logger.log(4, "Internal Error  consumer with id of " + object3 + " is unavailable " + " on session " + object + "[conuid,sess conuid] =" + "[" + iMQConnection.getConnectionUID().longValue() + "," + (object == null ? 0L : ((Session)object).getConnectionUID().longValue()) + "] it has been closed");
                continue;
            }
            if (bl && (transactionUID != null || ((Session)object).isTransacted())) {
                List list;
                HashMap hashMap2;
                if (transactionUID == null) {
                    transactionUID = ((Session)object).getCurrentTransactionID();
                }
                if ((hashMap2 = ((TransactionList)((Object)(linkedHashSet = Globals.getTransactionList()))).retrieveRemovedConsumedMessages(transactionUID)) != null && hashMap2.size() > 0 && (list = (List)hashMap2.get(sysMessageID)) != null && list.size() > 0) {
                    boolean bl3 = false;
                    for (int j = 0; j < list.size(); ++j) {
                        TransactionState transactionState;
                        ConsumerUID consumerUID = (ConsumerUID)list.get(j);
                        if (!consumerUID.equals(object3) || (transactionState = ((TransactionList)((Object)linkedHashSet)).retrieveState(transactionUID)) == null || transactionState.getState() != 2) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) {
                        if (!DEBUG_CLUSTER_TXN) continue;
                        this.logger.log(8, "Ignore redeliver request for [" + sysMessageID + ":" + object3 + "], removed with transaction " + transactionUID);
                        continue;
                    }
                }
            }
            if ((linkedHashSet = (Set)hashMap.get(consumer)) == null) {
                linkedHashSet = new LinkedHashSet<Object>();
                hashMap.put(consumer, linkedHashSet);
            }
            if (!linkedHashSet.contains(object2)) {
                linkedHashSet.add(object2);
            } else if (DEBUG_CLUSTER_TXN) {
                this.logger.log(8, "Ignore duplicated redeliver request [" + sysMessageID + ":" + object3 + "]");
            }
            if (bl) {
                ((PacketReference)object2).consumed(consumer.getStoredConsumerUID(), ((Session)object).isDupsOK(consumer.getConsumerUID()), false);
                continue;
            }
            ((PacketReference)object2).removeDelivered(consumer.getStoredConsumerUID(), true);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (Consumer)entry.getKey();
            object = (Set)entry.getValue();
            ((Consumer)object2).pause("start redeliver");
            ((Consumer)object2).routeMessages((Collection)object, true);
            ((Consumer)object2).resume("end redeliver");
        }
        hashMap.clear();
        for (Session session : hashSet) {
            session.resume("redeliver");
        }
    }
}

