/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.LoopbackAddressException;
import com.sun.messaging.jmq.jmsserver.util.VerifyAddressException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;

public class BrokerAddressImpl
extends BrokerAddress {
    private static final Logger logger = Globals.getLogger();
    private static final BrokerResources br = Globals.getBrokerResources();
    static final long serialVersionUID = 2088198635383118304L;
    private String hostName = null;
    private String instName = null;
    private boolean HAEnabled = false;
    private String brokerID = null;
    private UID brokerSessionUID = null;
    private UID storeSessionUID = null;
    private int port = -1;
    private transient int clusterVersion = 0;
    public static final int VERSION = 100;

    public BrokerAddressImpl(BrokerMQAddress brokerMQAddress, String string, boolean bl, String string2) throws Exception {
        this.hostName = brokerMQAddress.getHost().getHostAddress();
        this.port = brokerMQAddress.getPort();
        this.instName = string == null ? "???" : string;
        this.HAEnabled = bl;
        if (bl) {
            this.brokerID = string2;
        }
        this.brokerSessionUID = null;
        this.storeSessionUID = null;
        this.initialize(brokerMQAddress);
        this.verifyAddress();
    }

    public BrokerAddressImpl(String string, String string2, int n, boolean bl, String string3, UID uID, UID uID2) throws Exception {
        this.initialize(string, n);
        this.hostName = this.getMQAddress().getHost().getHostAddress();
        this.instName = string2;
        this.port = n;
        this.HAEnabled = bl;
        this.brokerID = string3;
        this.brokerSessionUID = uID;
        this.storeSessionUID = uID2;
        this.verifyAddress();
    }

    public BrokerAddressImpl() throws Exception {
        this(Globals.getPortMapper().getHostname(), Globals.getConfigName(), Globals.getPortMapper().getPort(), Globals.getHAEnabled(), Globals.getBrokerID(), Globals.getClusterManager().getBrokerSessionUID(), Globals.getClusterManager().getStoreSessionUID());
    }

    public int getClusterVersion() {
        return this.clusterVersion;
    }

    public void setClusterVersion(int n) {
        this.clusterVersion = n;
    }

    private void verifyAddress() throws Exception {
        InetAddress inetAddress = null;
        inetAddress = InetAddress.getByName("127.0.0.1");
        if (inetAddress == null) {
            throw new VerifyAddressException(Globals.getBrokerResources().getString("B4213", this.toString()));
        }
        if (inetAddress.equals(this.getMQAddress().getHost())) {
            throw new LoopbackAddressException(Globals.getBrokerResources().getString("B4214", this.toString()));
        }
        if (Globals.getHAEnabled() != this.getHAEnabled()) {
            throw new VerifyAddressException(Globals.getBrokerResources().getString("B4215", this.toString()));
        }
        if (this.getHAEnabled() && this.brokerID == null) {
            throw new VerifyAddressException(Globals.getBrokerResources().getString("B4216", this.toString()));
        }
    }

    public String getHostName() {
        return this.getMQAddress().getHost().getHostAddress();
    }

    public String getInstanceName() {
        return this.instName;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getHost() {
        return this.getMQAddress().getHost();
    }

    public boolean getHAEnabled() {
        return this.HAEnabled;
    }

    public String getBrokerID() {
        return this.brokerID;
    }

    public UID getBrokerSessionUID() {
        return this.brokerSessionUID;
    }

    public UID getStoreSessionUID() {
        return this.storeSessionUID;
    }

    public Object clone() {
        BrokerAddressImpl brokerAddressImpl;
        try {
            brokerAddressImpl = (BrokerAddressImpl)super.getObjectClone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("BrokerAddressImpl: Could not clone: " + cloneNotSupportedException);
            return null;
        }
        return brokerAddressImpl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BrokerAddressImpl)) {
            return false;
        }
        BrokerAddressImpl brokerAddressImpl = (BrokerAddressImpl)object;
        if (this.getHAEnabled() != brokerAddressImpl.getHAEnabled()) {
            return false;
        }
        if (this.getHAEnabled()) {
            if (this.brokerID == null || brokerAddressImpl.getBrokerID() == null) {
                return false;
            }
            return this.brokerID.equals(brokerAddressImpl.getBrokerID());
        }
        if (!this.instName.equals(brokerAddressImpl.instName)) {
            return false;
        }
        if (this.getMQAddress().getHost() == null || brokerAddressImpl.getMQAddress().getHost() == null) {
            return false;
        }
        return this.getMQAddress().getHost().equals(brokerAddressImpl.getMQAddress().getHost());
    }

    public int hashCode() {
        return 31 * this.getMQAddress().getHost().hashCode() + this.instName.hashCode();
    }

    public String toProtocolString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getMQAddress().toString());
        stringBuffer.append("?");
        stringBuffer.append("instName=" + this.getInstanceName());
        if (this.getBrokerID() != null) {
            stringBuffer.append("&");
            stringBuffer.append("brokerID=");
            stringBuffer.append(this.getBrokerID());
        }
        stringBuffer.append("&");
        stringBuffer.append("brokerSessionUID=");
        stringBuffer.append(this.getBrokerSessionUID());
        if (this.getHAEnabled()) {
            stringBuffer.append("&");
            stringBuffer.append("ha=true");
            stringBuffer.append("&");
            stringBuffer.append("storeSessionUID=");
            stringBuffer.append(this.getStoreSessionUID());
        }
        return stringBuffer.toString();
    }

    public BrokerAddress fromProtocolString(String string) throws Exception {
        BrokerMQAddress brokerMQAddress = BrokerMQAddress.createAddress(string);
        String string2 = brokerMQAddress.getProperty("ha");
        return new BrokerAddressImpl(brokerMQAddress.getHostName(), brokerMQAddress.getProperty("instName"), brokerMQAddress.getPort(), string2 != null, brokerMQAddress.getProperty("brokerID"), new UID(Long.valueOf(brokerMQAddress.getProperty("brokerSessionUID")).longValue()), string2 == null ? null : new UID(Long.valueOf(brokerMQAddress.getProperty("storeSessionUID")).longValue()));
    }

    public void writeBrokerAddress(GPacket gPacket) {
        gPacket.putProp((Object)"HA", (Object)this.getHAEnabled());
        if (this.brokerID != null) {
            gPacket.putProp((Object)"brokerID", (Object)this.getBrokerID());
        }
        if (this.brokerSessionUID != null) {
            gPacket.putProp((Object)"brokerSession", (Object)new Long(this.getBrokerSessionUID().longValue()));
        }
        if (this.storeSessionUID != null) {
            gPacket.putProp((Object)"storeSession", (Object)new Long(this.getStoreSessionUID().longValue()));
        }
        gPacket.putProp((Object)"instanceName", (Object)this.getInstanceName());
        gPacket.putProp((Object)"host", (Object)this.getHostName());
        gPacket.putProp((Object)"port", (Object)new Integer(this.getPort()));
    }

    public static BrokerAddressImpl readBrokerAddress(GPacket gPacket) throws Exception {
        if (gPacket.getProp((Object)"HA") == null) {
            return null;
        }
        boolean bl = (Boolean)gPacket.getProp((Object)"HA");
        String string = (String)gPacket.getProp((Object)"brokerID");
        String string2 = (String)gPacket.getProp((Object)"instanceName");
        String string3 = (String)gPacket.getProp((Object)"host");
        int n = (Integer)gPacket.getProp((Object)"port");
        Long l = (Long)gPacket.getProp((Object)"brokerSession");
        Long l2 = (Long)gPacket.getProp((Object)"storeSession");
        UID uID = null;
        UID uID2 = null;
        if (l != null) {
            uID = new UID(l.longValue());
        }
        if (l2 != null) {
            uID2 = new UID(l2.longValue());
        }
        BrokerAddressImpl brokerAddressImpl = new BrokerAddressImpl(string3, string2, n, bl, string, uID, uID2);
        return brokerAddressImpl;
    }

    public void writeBrokerAddress(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(100);
        dataOutputStream.writeUTF(this.hostName);
        dataOutputStream.writeUTF(this.instName);
        dataOutputStream.writeInt(this.port);
        dataOutputStream.flush();
    }

    public void readBrokerAddress(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n > 100) {
            throw new IOException(Globals.getBrokerResources().getString("B4117", "BrokerAddress version mismatch."));
        }
        this.hostName = dataInputStream.readUTF();
        this.instName = dataInputStream.readUTF();
        this.port = dataInputStream.readInt();
        this.initialize(this.hostName, this.port);
        this.HAEnabled = false;
        this.brokerID = null;
        this.brokerSessionUID = null;
        this.storeSessionUID = null;
        this.clusterVersion = 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize(this.hostName, this.port);
    }

    public String toString() {
        this.getMQAddress().getHost().getHostName();
        return this.toProtocolString();
    }
}

