/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQEmbeddedConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.OperationRunnable;
import com.sun.messaging.jmq.jmsserver.service.imq.OperationRunnableFactory;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.pool.RunnableFactory;
import com.sun.messaging.jmq.jmsserver.util.pool.ThreadPool;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class IMQEmbeddedService
extends IMQService {
    private static boolean DEBUG = false;
    Properties cfg = System.getProperties();
    BrokerConfig cprops = Globals.getConfig();
    protected PacketRouter router = null;
    private AuthCacheData authCacheData = new AuthCacheData();
    protected ThreadPool pool = null;
    protected RunnableFactory runfac = null;
    private ConnectionManager ConnectionList = Globals.getConnectionManager();

    public IMQEmbeddedService(String string, int n, PacketRouter packetRouter, int n2, int n3) {
        super(string, n);
        this.router = packetRouter;
        this.runfac = this.getRunnableFactory();
        if (n3 == 0) {
            throw new RuntimeException(Globals.getBrokerResources().getKString("B4136", string, String.valueOf(n3)));
        }
        this.pool = new ThreadPool(string, n2, n3, this.runfac);
    }

    public Hashtable getPoolDebugState() {
        return this.pool.getDebugState();
    }

    public void dumpPool() {
        this.pool.debug();
    }

    protected RunnableFactory getRunnableFactory() {
        return new OperationRunnableFactory(true);
    }

    public synchronized int getMinThreadpool() {
        if (this.pool == null) {
            return 0;
        }
        return this.pool.getMinimum();
    }

    public synchronized int getMaxThreadpool() {
        if (this.pool == null) {
            return 0;
        }
        return this.pool.getMaximum();
    }

    public synchronized int getActiveThreadpool() {
        if (this.pool == null) {
            return 0;
        }
        return this.pool.getThreadNum();
    }

    public void setPriority(int n) {
        this.pool.setPriority(n);
    }

    public synchronized void setMinMaxThreadpool(int n, int n2) {
        if (this.pool == null) {
            return;
        }
        this.pool.setMinMax(n, n2);
    }

    public synchronized void startService(boolean bl) {
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", (Object)"unable to start service, already started.");
            return;
        }
        this.setState(2);
        Object[] objectArray = new String[]{this.getName(), "in-process connections", String.valueOf(this.getMinThreadpool()), String.valueOf(this.getMaxThreadpool())};
        this.logger.log(8, "B1004", objectArray);
        try {
            this.logger.log(8, "B1227", (Object)AccessController.getInstance(this.getName(), this.getServiceType()).getUserRepository(), (Object)this.getName());
        }
        catch (BrokerException brokerException) {
            this.logger.log(16, "B2135", (Object)this.getName(), (Object)brokerException.getMessage());
        }
        this.pool.start();
        if (bl) {
            this.setServiceRunning(false);
            this.setState(4);
        } else {
            this.setServiceRunning(true);
            this.setState(3);
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService(boolean bl) {
        int n;
        Object object;
        Object object2 = this;
        synchronized (object2) {
            if (this.isShuttingDown()) {
                return;
            }
            object = new String[]{this.getName(), "none"};
            if (bl) {
                this.logger.log(8, "B1007", (Object[])object);
            } else if (!this.isShuttingDown()) {
                this.logger.log(8, "B1053", (Object[])object);
            }
            this.setShuttingDown(true);
        }
        if (this.getServiceType() == 0) {
            object2 = this.connectionList.getConnectionList(this);
            object = null;
            for (n = object2.size() - 1; n >= 0; --n) {
                object = (Connection)object2.get(n);
                ((Connection)object).stopConnection();
            }
        }
        object2 = this;
        synchronized (object2) {
            this.setState(5);
            this.notify();
        }
        if (!bl) {
            return;
        }
        if (this.getServiceType() == 0) {
            object2 = this.connectionList.getConnectionList(this);
            object = null;
            for (n = object2.size() - 1; n >= 0; --n) {
                object = (Connection)object2.get(n);
                ((Connection)object).destroyConnection(true, 1, Globals.getBrokerResources().getKString("B0060"));
            }
        }
        object2 = this;
        synchronized (object2) {
            this.setState(6);
            this.notify();
        }
        if (this.pool.isValid()) {
            this.pool.waitOnDestroy(this.getDestroyWaitTime());
        }
        if (DEBUG) {
            this.logger.log(4, "Destroying Service {0} with protocol {1} ", (Object)this.getName(), (Object)"none");
        }
    }

    public void stopNewConnections() throws IOException, IllegalStateException {
        if (this.getState() != 3) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4254"));
        }
        this.setState(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewConnections() throws IOException {
        if (this.getState() != 8 && this.getState() != 4) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4255"));
        }
        IMQEmbeddedService iMQEmbeddedService = this;
        synchronized (iMQEmbeddedService) {
            this.setState(3);
            this.notify();
        }
    }

    public void pauseService(boolean bl) {
        if (!this.isServiceRunning()) {
            this.logger.log(4, "B3100", (Object)("unable to pause service " + this.name + ", already paused."));
            return;
        }
        Object[] objectArray = new String[]{this.getName(), "none"};
        this.logger.log(4, "B1005", objectArray);
        try {
            this.stopNewConnections();
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B3100", (Object)("pausing service " + this), (Throwable)exception);
        }
        this.setState(4);
        if (bl) {
            this.pool.suspend();
        }
        this.setServiceRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeService() {
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", (Object)("unable to resume service " + this.name + ", already running."));
            return;
        }
        Object[] objectArray = new String[]{this.getName(), "none"};
        this.logger.log(4, "B1006", objectArray);
        try {
            this.startNewConnections();
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B3100", (Object)("pausing service " + this), (Throwable)exception);
        }
        this.pool.resume();
        this.setServiceRunning(true);
        IMQEmbeddedService iMQEmbeddedService = this;
        synchronized (iMQEmbeddedService) {
            this.setState(3);
            this.notify();
        }
    }

    public IMQEmbeddedConnection createConnection() throws IOException, BrokerException {
        IMQEmbeddedConnection iMQEmbeddedConnection = new IMQEmbeddedConnection(this, this.router);
        OperationRunnable operationRunnable = (OperationRunnable)this.pool.getAvailRunnable(false);
        OperationRunnable operationRunnable2 = (OperationRunnable)this.pool.getAvailRunnable(false);
        if (operationRunnable == null || operationRunnable2 == null) {
            if (operationRunnable != null) {
                this.pool.releaseRunnable(operationRunnable);
            }
            if (operationRunnable2 != null) {
                this.pool.releaseRunnable(operationRunnable2);
            }
            Object[] objectArray = new String[]{this.toString(), String.valueOf(this.pool.getAssignedCnt()), String.valueOf(this.pool.getMaximum())};
            this.logger.log(16, "B3004", objectArray);
            this.pool.debug();
            iMQEmbeddedConnection.destroyConnection(true, 4, Globals.getBrokerResources().getKString("B3004", objectArray));
            throw new BrokerException(Globals.getBrokerResources().getKString("B3004", objectArray), "B3004", null, 405);
        }
        this.connectionList.addConnection(iMQEmbeddedConnection);
        try {
            operationRunnable.assignOperation(iMQEmbeddedConnection, 1, -1);
            operationRunnable2.assignOperation(iMQEmbeddedConnection, 4, -1);
        }
        catch (IllegalAccessException illegalAccessException) {
            Globals.getLogger().logStack(32, "Internal Error: ", (Throwable)illegalAccessException);
            this.pool.releaseRunnable(operationRunnable);
            this.pool.releaseRunnable(operationRunnable2);
        }
        return iMQEmbeddedConnection;
    }
}

