/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.data.TransactionDetails;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class BaseTransaction {
    public static final int UNDEFINED_TRANSACTION_TYPE = 0;
    public static final int LOCAL_TRANSACTION_TYPE = 1;
    public static final int REMOTE_TRANSACTION_TYPE = 2;
    public static final int CLUSTER_TRANSACTION_TYPE = 3;
    TransactionDetails transactionDetails = new TransactionDetails();
    TransactionWork transactionWork;
    TransactionState transactionState;
    byte[] data;

    public BaseTransaction(int n) {
        this.transactionDetails.setType(n);
    }

    public int getType() {
        return this.transactionDetails.getType();
    }

    public int getState() {
        return this.transactionDetails.getState();
    }

    public TransactionUID getTid() {
        return this.transactionDetails.getTid();
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public String toString() {
        return this.transactionDetails.toString();
    }

    public TransactionWork getTransactionWork() {
        return this.transactionWork;
    }

    public void setTransactionWork(TransactionWork transactionWork) {
        this.transactionWork = transactionWork;
    }

    public TransactionDetails getTransactionDetails() {
        return this.transactionDetails;
    }

    public void setTransactionDetails(TransactionDetails transactionDetails) {
        this.transactionDetails = transactionDetails;
    }

    public TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setTransactionState(TransactionState transactionState) {
        this.transactionState = transactionState;
    }

    String getPrefix() {
        return "BaseTransaction: " + Thread.currentThread().getName() + " " + this.getTid();
    }

    public void readFromBytes(byte[] byArray) throws IOException, BrokerException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.readData(dataInputStream);
        int n = dataInputStream.readInt();
        byte[] byArray2 = new byte[n];
        dataInputStream.read(byArray2);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream2);
        try {
            this.readObjects(objectInputStream);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        objectInputStream.close();
        byteArrayInputStream2.close();
        dataInputStream.close();
        byteArrayInputStream.close();
    }

    public abstract void readData(DataInputStream var1) throws IOException, BrokerException;

    public abstract void readObjects(ObjectInputStream var1) throws IOException, BrokerException, ClassNotFoundException;

    public byte[] writeToBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeData(dataOutputStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(1024);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream2);
        this.writeObjects(objectOutputStream);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream2.toByteArray();
        int n = byArray.length;
        dataOutputStream.writeInt(n);
        dataOutputStream.write(byArray);
        byteArrayOutputStream2.close();
        dataOutputStream.close();
        byteArrayOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    public abstract void writeData(DataOutputStream var1) throws IOException;

    public abstract void writeObjects(ObjectOutputStream var1) throws IOException;
}

